/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.testabilityexception;

import java.time.LocalDate;
import org.evomaster.client.java.instrumentation.testabilityexception.ExceptionHeuristics;

public class LocalDateExceptionHeuristics {
    public static double parse(String input) {
        if (input == null) {
            return 0.05;
        }
        try {
            LocalDate.parse(input);
            return 1.0;
        }
        catch (Exception exception) {
            double base = 0.1;
            long distance = 0L;
            for (int i = 0; i < input.length(); ++i) {
                char c = input.charAt(i);
                if (i >= 0 && i <= 3) {
                    distance += (long)ExceptionHeuristics.distanceToDigit(c);
                    continue;
                }
                if (i == 4 || i == 7) {
                    distance += (long)ExceptionHeuristics.distanceToChar(c, '-');
                    continue;
                }
                if (i == 5) {
                    distance += (long)ExceptionHeuristics.distanceToChar(c, '0');
                    continue;
                }
                if (i == 6) {
                    distance += (long)ExceptionHeuristics.distanceToRange(c, '1', '9');
                    continue;
                }
                if (i == 8) {
                    distance += (long)ExceptionHeuristics.distanceToRange(c, '0', '2');
                    continue;
                }
                if (i == 9) {
                    distance += (long)ExceptionHeuristics.distanceToRange(c, '1', '8');
                    continue;
                }
                distance += 65536L;
            }
            if (input.length() < 10) {
                distance += (long)(65536 * (10 - input.length()));
            }
            assert (distance != 0L);
            return 0.1 + 0.9 / (double)(distance + 1L);
        }
    }
}

