/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.glassfish.jersey.jetty;

import java.net.URI;
import java.util.concurrent.ThreadFactory;
import javax.ws.rs.ProcessingException;
import shaded.org.eclipse.jetty.server.Connector;
import shaded.org.eclipse.jetty.server.HttpConfiguration;
import shaded.org.eclipse.jetty.server.HttpConnectionFactory;
import shaded.org.eclipse.jetty.server.SecureRequestCustomizer;
import shaded.org.eclipse.jetty.server.Server;
import shaded.org.eclipse.jetty.server.ServerConnector;
import shaded.org.eclipse.jetty.server.SslConnectionFactory;
import shaded.org.eclipse.jetty.util.ssl.SslContextFactory;
import shaded.org.eclipse.jetty.util.thread.QueuedThreadPool;
import shaded.org.glassfish.jersey.internal.guava.ThreadFactoryBuilder;
import shaded.org.glassfish.jersey.jetty.JettyHttpContainer;
import shaded.org.glassfish.jersey.jetty.internal.LocalizationMessages;
import shaded.org.glassfish.jersey.process.JerseyProcessingUncaughtExceptionHandler;
import shaded.org.glassfish.jersey.server.ContainerFactory;
import shaded.org.glassfish.jersey.server.ResourceConfig;

public final class JettyHttpContainerFactory {
    private JettyHttpContainerFactory() {
    }

    public static Server createServer(URI uri) throws ProcessingException {
        return JettyHttpContainerFactory.createServer(uri, null, null, true);
    }

    public static Server createServer(URI uri, boolean start) throws ProcessingException {
        return JettyHttpContainerFactory.createServer(uri, null, null, start);
    }

    public static Server createServer(URI uri, ResourceConfig config) throws ProcessingException {
        JettyHttpContainer container = ContainerFactory.createContainer(JettyHttpContainer.class, config);
        return JettyHttpContainerFactory.createServer(uri, null, container, true);
    }

    public static Server createServer(URI uri, ResourceConfig configuration, boolean start) throws ProcessingException {
        return JettyHttpContainerFactory.createServer(uri, null, ContainerFactory.createContainer(JettyHttpContainer.class, configuration), start);
    }

    public static Server createServer(URI uri, ResourceConfig config, boolean start, Object parentContext) {
        return JettyHttpContainerFactory.createServer(uri, null, new JettyHttpContainer(config, parentContext), start);
    }

    public static Server createServer(URI uri, ResourceConfig config, Object parentContext) {
        return JettyHttpContainerFactory.createServer(uri, null, new JettyHttpContainer(config, parentContext), true);
    }

    public static Server createServer(URI uri, SslContextFactory sslContextFactory, ResourceConfig config) throws ProcessingException {
        JettyHttpContainer container = ContainerFactory.createContainer(JettyHttpContainer.class, config);
        return JettyHttpContainerFactory.createServer(uri, sslContextFactory, container, true);
    }

    public static Server createServer(URI uri, SslContextFactory sslContextFactory, JettyHttpContainer handler, boolean start) {
        if (uri == null) {
            throw new IllegalArgumentException(LocalizationMessages.URI_CANNOT_BE_NULL());
        }
        String scheme = uri.getScheme();
        int defaultPort = 80;
        if (sslContextFactory == null) {
            if (!"http".equalsIgnoreCase(scheme)) {
                throw new IllegalArgumentException(LocalizationMessages.WRONG_SCHEME_WHEN_USING_HTTP());
            }
        } else {
            if (!"https".equalsIgnoreCase(scheme)) {
                throw new IllegalArgumentException(LocalizationMessages.WRONG_SCHEME_WHEN_USING_HTTPS());
            }
            defaultPort = 443;
        }
        int port = uri.getPort() == -1 ? defaultPort : uri.getPort();
        Server server = new Server(new JettyConnectorThreadPool());
        HttpConfiguration config = new HttpConfiguration();
        if (sslContextFactory != null) {
            config.setSecureScheme("https");
            config.setSecurePort(port);
            config.addCustomizer(new SecureRequestCustomizer());
            ServerConnector https = new ServerConnector(server, new SslConnectionFactory(sslContextFactory, "http/1.1"), new HttpConnectionFactory(config));
            https.setPort(port);
            server.setConnectors(new Connector[]{https});
        } else {
            ServerConnector http = new ServerConnector(server, new HttpConnectionFactory(config));
            http.setPort(port);
            server.setConnectors(new Connector[]{http});
        }
        if (handler != null) {
            server.setHandler(handler);
        }
        if (start) {
            try {
                server.start();
            }
            catch (Exception e) {
                throw new ProcessingException(LocalizationMessages.ERROR_WHEN_CREATING_SERVER(), (Throwable)e);
            }
        }
        return server;
    }

    private static final class JettyConnectorThreadPool
    extends QueuedThreadPool {
        private final ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("jetty-http-server-%d").setUncaughtExceptionHandler(new JerseyProcessingUncaughtExceptionHandler()).build();

        private JettyConnectorThreadPool() {
        }

        @Override
        protected Thread newThread(Runnable runnable) {
            return this.threadFactory.newThread(runnable);
        }
    }
}

