/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.glassfish.jersey.server.internal.routing;

import java.util.LinkedList;
import java.util.List;
import shaded.org.glassfish.jersey.server.internal.routing.PathMatchingRouter;
import shaded.org.glassfish.jersey.server.internal.routing.PathToRouterBuilder;
import shaded.org.glassfish.jersey.server.internal.routing.Route;
import shaded.org.glassfish.jersey.server.internal.routing.Router;
import shaded.org.glassfish.jersey.uri.PathPattern;

final class PathMatchingRouterBuilder
implements PathToRouterBuilder {
    private final List<Route> acceptedRoutes = new LinkedList<Route>();
    private List<Router> currentRouters;

    static PathToRouterBuilder newRoute(PathPattern pattern) {
        PathMatchingRouterBuilder builder = new PathMatchingRouterBuilder();
        builder.startNewRoute(pattern);
        return builder;
    }

    private PathMatchingRouterBuilder() {
    }

    private void startNewRoute(PathPattern pattern) {
        this.currentRouters = new LinkedList<Router>();
        this.acceptedRoutes.add(Route.of(pattern, this.currentRouters));
    }

    protected List<Route> acceptedRoutes() {
        return this.acceptedRoutes;
    }

    @Override
    public PathMatchingRouterBuilder to(Router router) {
        this.currentRouters.add(router);
        return this;
    }

    public PathToRouterBuilder route(PathPattern pattern) {
        this.startNewRoute(pattern);
        return this;
    }

    public PathMatchingRouter build() {
        return new PathMatchingRouter(this.acceptedRoutes());
    }
}

