/*
 * Decompiled with CFR 0.152.
 */
package shaded.net.sf.jsqlparser.statement.insert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import shaded.net.sf.jsqlparser.expression.Expression;
import shaded.net.sf.jsqlparser.expression.OracleHint;
import shaded.net.sf.jsqlparser.expression.operators.relational.ItemsList;
import shaded.net.sf.jsqlparser.schema.Column;
import shaded.net.sf.jsqlparser.schema.Table;
import shaded.net.sf.jsqlparser.statement.Statement;
import shaded.net.sf.jsqlparser.statement.StatementVisitor;
import shaded.net.sf.jsqlparser.statement.insert.InsertModifierPriority;
import shaded.net.sf.jsqlparser.statement.select.PlainSelect;
import shaded.net.sf.jsqlparser.statement.select.Select;
import shaded.net.sf.jsqlparser.statement.select.SelectExpressionItem;
import shaded.net.sf.jsqlparser.statement.select.WithItem;

public class Insert
implements Statement {
    private Table table;
    private OracleHint oracleHint = null;
    private List<Column> columns;
    private ItemsList itemsList;
    private boolean useValues = true;
    private Select select;
    private boolean useSelectBrackets = true;
    private boolean useDuplicate = false;
    private List<Column> duplicateUpdateColumns;
    private List<Expression> duplicateUpdateExpressionList;
    private InsertModifierPriority modifierPriority = null;
    private boolean modifierIgnore = false;
    private boolean returningAllColumns = false;
    private List<SelectExpressionItem> returningExpressionList = null;
    private boolean useSet = false;
    private List<Column> setColumns;
    private List<Expression> setExpressionList;
    private List<WithItem> withItemsList;

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table name) {
        this.table = name;
    }

    public OracleHint getOracleHint() {
        return this.oracleHint;
    }

    public void setOracleHint(OracleHint oracleHint) {
        this.oracleHint = oracleHint;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public void setColumns(List<Column> list) {
        this.columns = list;
    }

    public ItemsList getItemsList() {
        return this.itemsList;
    }

    public void setItemsList(ItemsList list) {
        this.itemsList = list;
    }

    public boolean isUseValues() {
        return this.useValues;
    }

    public void setUseValues(boolean useValues) {
        this.useValues = useValues;
    }

    public boolean isReturningAllColumns() {
        return this.returningAllColumns;
    }

    public void setReturningAllColumns(boolean returningAllColumns) {
        this.returningAllColumns = returningAllColumns;
    }

    public List<SelectExpressionItem> getReturningExpressionList() {
        return this.returningExpressionList;
    }

    public void setReturningExpressionList(List<SelectExpressionItem> returningExpressionList) {
        this.returningExpressionList = returningExpressionList;
    }

    public Select getSelect() {
        return this.select;
    }

    public void setSelect(Select select) {
        this.select = select;
    }

    public boolean isUseSelectBrackets() {
        return this.useSelectBrackets;
    }

    public void setUseSelectBrackets(boolean useSelectBrackets) {
        this.useSelectBrackets = useSelectBrackets;
    }

    public boolean isUseDuplicate() {
        return this.useDuplicate;
    }

    public void setUseDuplicate(boolean useDuplicate) {
        this.useDuplicate = useDuplicate;
    }

    public List<Column> getDuplicateUpdateColumns() {
        return this.duplicateUpdateColumns;
    }

    public void setDuplicateUpdateColumns(List<Column> duplicateUpdateColumns) {
        this.duplicateUpdateColumns = duplicateUpdateColumns;
    }

    public List<Expression> getDuplicateUpdateExpressionList() {
        return this.duplicateUpdateExpressionList;
    }

    public void setDuplicateUpdateExpressionList(List<Expression> duplicateUpdateExpressionList) {
        this.duplicateUpdateExpressionList = duplicateUpdateExpressionList;
    }

    public InsertModifierPriority getModifierPriority() {
        return this.modifierPriority;
    }

    public void setModifierPriority(InsertModifierPriority modifierPriority) {
        this.modifierPriority = modifierPriority;
    }

    public boolean isModifierIgnore() {
        return this.modifierIgnore;
    }

    public void setModifierIgnore(boolean modifierIgnore) {
        this.modifierIgnore = modifierIgnore;
    }

    public void setUseSet(boolean useSet) {
        this.useSet = useSet;
    }

    public boolean isUseSet() {
        return this.useSet;
    }

    public void setSetColumns(List<Column> setColumns) {
        this.setColumns = setColumns;
    }

    public List<Column> getSetColumns() {
        return this.setColumns;
    }

    public void setSetExpressionList(List<Expression> setExpressionList) {
        this.setExpressionList = setExpressionList;
    }

    public List<Expression> getSetExpressionList() {
        return this.setExpressionList;
    }

    public List<WithItem> getWithItemsList() {
        return this.withItemsList;
    }

    public void setWithItemsList(List<WithItem> withItemsList) {
        this.withItemsList = withItemsList;
    }

    public String toString() {
        StringBuilder sql = new StringBuilder();
        if (this.withItemsList != null && !this.withItemsList.isEmpty()) {
            sql.append("WITH ");
            Iterator<WithItem> iter = this.withItemsList.iterator();
            while (iter.hasNext()) {
                WithItem withItem = iter.next();
                sql.append(withItem);
                if (iter.hasNext()) {
                    sql.append(",");
                }
                sql.append(" ");
            }
        }
        sql.append("INSERT ");
        if (this.modifierPriority != null) {
            sql.append(this.modifierPriority.name()).append(" ");
        }
        if (this.modifierIgnore) {
            sql.append("IGNORE ");
        }
        sql.append("INTO ");
        sql.append(this.table).append(" ");
        if (this.columns != null) {
            sql.append(PlainSelect.getStringList(this.columns, true, true)).append(" ");
        }
        if (this.useValues) {
            sql.append("VALUES ");
        }
        if (this.itemsList != null) {
            sql.append(this.itemsList);
        } else {
            if (this.useSelectBrackets) {
                sql.append("(");
            }
            if (this.select != null) {
                sql.append(this.select);
            }
            if (this.useSelectBrackets) {
                sql.append(")");
            }
        }
        if (this.useSet) {
            sql.append("SET ");
            for (int i = 0; i < this.getSetColumns().size(); ++i) {
                if (i != 0) {
                    sql.append(", ");
                }
                sql.append(this.setColumns.get(i)).append(" = ");
                sql.append(this.setExpressionList.get(i));
            }
        }
        if (this.useDuplicate) {
            sql.append(" ON DUPLICATE KEY UPDATE ");
            for (int i = 0; i < this.getDuplicateUpdateColumns().size(); ++i) {
                if (i != 0) {
                    sql.append(", ");
                }
                sql.append(this.duplicateUpdateColumns.get(i)).append(" = ");
                sql.append(this.duplicateUpdateExpressionList.get(i));
            }
        }
        if (this.isReturningAllColumns()) {
            sql.append(" RETURNING *");
        } else if (this.getReturningExpressionList() != null) {
            sql.append(" RETURNING ").append(PlainSelect.getStringList(this.getReturningExpressionList(), true, false));
        }
        return sql.toString();
    }

    public Insert withWithItemsList(List<WithItem> withList) {
        this.withItemsList = withList;
        return this;
    }

    public Insert withUseValues(boolean useValues) {
        this.setUseValues(useValues);
        return this;
    }

    public Insert withSelect(Select select) {
        this.setSelect(select);
        return this;
    }

    public Insert withUseSelectBrackets(boolean useSelectBrackets) {
        this.setUseSelectBrackets(useSelectBrackets);
        return this;
    }

    public Insert withUseDuplicate(boolean useDuplicate) {
        this.setUseDuplicate(useDuplicate);
        return this;
    }

    public Insert withDuplicateUpdateColumns(List<Column> duplicateUpdateColumns) {
        this.setDuplicateUpdateColumns(duplicateUpdateColumns);
        return this;
    }

    public Insert withDuplicateUpdateExpressionList(List<Expression> duplicateUpdateExpressionList) {
        this.setDuplicateUpdateExpressionList(duplicateUpdateExpressionList);
        return this;
    }

    public Insert withModifierPriority(InsertModifierPriority modifierPriority) {
        this.setModifierPriority(modifierPriority);
        return this;
    }

    public Insert withModifierIgnore(boolean modifierIgnore) {
        this.setModifierIgnore(modifierIgnore);
        return this;
    }

    public Insert withReturningAllColumns(boolean returningAllColumns) {
        this.setReturningAllColumns(returningAllColumns);
        return this;
    }

    public Insert withReturningExpressionList(List<SelectExpressionItem> returningExpressionList) {
        this.setReturningExpressionList(returningExpressionList);
        return this;
    }

    public Insert withUseSet(boolean useSet) {
        this.setUseSet(useSet);
        return this;
    }

    public Insert withUseSetColumns(List<Column> setColumns) {
        this.setSetColumns(setColumns);
        return this;
    }

    public Insert withSetExpressionList(List<Expression> setExpressionList) {
        this.setSetExpressionList(setExpressionList);
        return this;
    }

    public Insert withTable(Table table) {
        this.setTable(table);
        return this;
    }

    public Insert withColumns(List<Column> columns) {
        this.setColumns(columns);
        return this;
    }

    public Insert withSetColumns(List<Column> columns) {
        this.setSetColumns(columns);
        return this;
    }

    public Insert withItemsList(ItemsList itemsList) {
        this.setItemsList(itemsList);
        return this;
    }

    public Insert addColumns(Column ... columns) {
        List collection = Optional.ofNullable(this.getColumns()).orElseGet(ArrayList::new);
        Collections.addAll(collection, columns);
        return this.withColumns(collection);
    }

    public Insert addColumns(Collection<? extends Column> columns) {
        List collection = Optional.ofNullable(this.getColumns()).orElseGet(ArrayList::new);
        collection.addAll(columns);
        return this.withColumns(collection);
    }

    public Insert addDuplicateUpdateColumns(Column ... duplicateUpdateColumns) {
        List collection = Optional.ofNullable(this.getDuplicateUpdateColumns()).orElseGet(ArrayList::new);
        Collections.addAll(collection, duplicateUpdateColumns);
        return this.withDuplicateUpdateColumns(collection);
    }

    public Insert addDuplicateUpdateColumns(Collection<? extends Column> duplicateUpdateColumns) {
        List collection = Optional.ofNullable(this.getDuplicateUpdateColumns()).orElseGet(ArrayList::new);
        collection.addAll(duplicateUpdateColumns);
        return this.withDuplicateUpdateColumns(collection);
    }

    public Insert addDuplicateUpdateExpressionList(Expression ... duplicateUpdateExpressionList) {
        List collection = Optional.ofNullable(this.getDuplicateUpdateExpressionList()).orElseGet(ArrayList::new);
        Collections.addAll(collection, duplicateUpdateExpressionList);
        return this.withDuplicateUpdateExpressionList(collection);
    }

    public Insert addDuplicateUpdateExpressionList(Collection<? extends Expression> duplicateUpdateExpressionList) {
        List collection = Optional.ofNullable(this.getDuplicateUpdateExpressionList()).orElseGet(ArrayList::new);
        collection.addAll(duplicateUpdateExpressionList);
        return this.withDuplicateUpdateExpressionList(collection);
    }

    public Insert addReturningExpressionList(SelectExpressionItem ... returningExpressionList) {
        List collection = Optional.ofNullable(this.getReturningExpressionList()).orElseGet(ArrayList::new);
        Collections.addAll(collection, returningExpressionList);
        return this.withReturningExpressionList(collection);
    }

    public Insert addReturningExpressionList(Collection<? extends SelectExpressionItem> returningExpressionList) {
        List collection = Optional.ofNullable(this.getReturningExpressionList()).orElseGet(ArrayList::new);
        collection.addAll(returningExpressionList);
        return this.withReturningExpressionList(collection);
    }

    public Insert addSetColumns(Column ... setColumns) {
        List collection = Optional.ofNullable(this.getSetColumns()).orElseGet(ArrayList::new);
        Collections.addAll(collection, setColumns);
        return this.withSetColumns(collection);
    }

    public Insert addSetColumns(Collection<? extends Column> setColumns) {
        List collection = Optional.ofNullable(this.getSetColumns()).orElseGet(ArrayList::new);
        collection.addAll(setColumns);
        return this.withSetColumns(collection);
    }

    public Insert addSetExpressionList(Expression ... setExpressionList) {
        List collection = Optional.ofNullable(this.getSetExpressionList()).orElseGet(ArrayList::new);
        Collections.addAll(collection, setExpressionList);
        return this.withSetExpressionList(collection);
    }

    public Insert addSetExpressionList(Collection<? extends Expression> setExpressionList) {
        List collection = Optional.ofNullable(this.getSetExpressionList()).orElseGet(ArrayList::new);
        collection.addAll(setExpressionList);
        return this.withSetExpressionList(collection);
    }

    public <E extends ItemsList> E getItemsList(Class<E> type) {
        return (E)((ItemsList)type.cast(this.getItemsList()));
    }
}

