/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.problem.rpc;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.evomaster.client.java.controller.api.dto.CustomizedRequestValueDto;
import org.evomaster.client.java.controller.api.dto.MockDatabaseDto;
import org.evomaster.client.java.controller.api.dto.auth.AuthenticationDto;
import org.evomaster.client.java.controller.api.dto.auth.JsonAuthRPCEndpointDto;
import org.evomaster.client.java.controller.api.dto.problem.rpc.MockRPCExternalServiceDto;
import org.evomaster.client.java.controller.api.dto.problem.rpc.RPCActionDto;
import org.evomaster.client.java.controller.api.dto.problem.rpc.RPCType;
import org.evomaster.client.java.controller.api.dto.problem.rpc.SeededRPCActionDto;
import org.evomaster.client.java.controller.api.dto.problem.rpc.SeededRPCTestDto;
import org.evomaster.client.java.controller.problem.rpc.CodeJavaOrKotlinGenerator;
import org.evomaster.client.java.controller.problem.rpc.CustomizedNotNullAnnotationForRPCDto;
import org.evomaster.client.java.controller.problem.rpc.JavaXConstraintHandler;
import org.evomaster.client.java.controller.problem.rpc.Protobuf3Field;
import org.evomaster.client.java.controller.problem.rpc.schema.EndpointSchema;
import org.evomaster.client.java.controller.problem.rpc.schema.InterfaceSchema;
import org.evomaster.client.java.controller.problem.rpc.schema.LocalAuthSetupSchema;
import org.evomaster.client.java.controller.problem.rpc.schema.params.ArrayParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.BigDecimalParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.BigIntegerParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.ByteBufferParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.DateParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.EnumParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.ListParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.MapParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.NamedTypedValue;
import org.evomaster.client.java.controller.problem.rpc.schema.params.ObjectParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.PairParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.PrimitiveOrWrapperParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.Protobuf3ByteStringParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.SetParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.StringParam;
import org.evomaster.client.java.controller.problem.rpc.schema.types.AccessibleSchema;
import org.evomaster.client.java.controller.problem.rpc.schema.types.BigDecimalType;
import org.evomaster.client.java.controller.problem.rpc.schema.types.BigIntegerType;
import org.evomaster.client.java.controller.problem.rpc.schema.types.CollectionType;
import org.evomaster.client.java.controller.problem.rpc.schema.types.CycleObjectType;
import org.evomaster.client.java.controller.problem.rpc.schema.types.EnumType;
import org.evomaster.client.java.controller.problem.rpc.schema.types.JavaDtoSpec;
import org.evomaster.client.java.controller.problem.rpc.schema.types.LocalDateType;
import org.evomaster.client.java.controller.problem.rpc.schema.types.MapType;
import org.evomaster.client.java.controller.problem.rpc.schema.types.ObjectType;
import org.evomaster.client.java.controller.problem.rpc.schema.types.PairType;
import org.evomaster.client.java.controller.problem.rpc.schema.types.PrimitiveOrWrapperType;
import org.evomaster.client.java.controller.problem.rpc.schema.types.Protobuf3ByteStringType;
import org.evomaster.client.java.controller.problem.rpc.schema.types.StringType;
import org.evomaster.client.java.controller.problem.rpc.schema.types.TypeSchema;
import org.evomaster.client.java.controller.problem.rpc.schema.types.UtilDateType;
import org.evomaster.client.java.utils.SimpleLogger;
import shaded.com.fasterxml.jackson.core.JsonProcessingException;
import shaded.com.fasterxml.jackson.databind.JsonNode;
import shaded.com.fasterxml.jackson.databind.ObjectMapper;

public class RPCEndpointsBuilder {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final String OBJECT_FLAG = "OBJECT";
    private static final String OBJECT_FLAG_SEPARATOR = ":";
    private static final String PROTOBUF_PACKAGE = "com.google.protobuf";
    private static final String PROTOBUF_BUILDER = "Builder";
    private static final String PROTOBUF_MAP_FIELD_SUFFIX = "Map";
    private static final String PROTOBUF_MAP_SETTER_PREFIX = "putAll";
    private static final String PROTOBUF_LIST_FIELD_SUFFIX = "List";
    private static final String PROTOBUF_LIST_SETTER_PREFIX = "addAll";
    private static final String PROTOBUF_INTERFACE_BUILDER_SUFFIX = "OrBuilder";
    private static final String NATIVE_THRIFT_DTO_INTERFACE = "org.apache.thrift.TBase";
    private static final String NATIVE_THRIFT_FIELD_SCHEMA = "metaDataMap";

    private static String getObjectTypeNameWithFlag(Class<?> clazz, String name, int level) {
        if (RPCEndpointsBuilder.isNotCustomizedObject(clazz)) {
            return name;
        }
        if (level < 0) {
            return "OBJECT:" + name;
        }
        return "OBJECT:" + name + OBJECT_FLAG_SEPARATOR + level;
    }

    private static String[] parseObjectTypeFlag(String objectFlag) {
        String[] info = objectFlag.split(OBJECT_FLAG_SEPARATOR);
        if (info.length == 3) {
            return info;
        }
        return null;
    }

    private static boolean isNotCustomizedObject(Class<?> clazz) {
        return PrimitiveOrWrapperType.isPrimitiveOrTypes(clazz) || clazz == String.class || clazz == ByteBuffer.class || clazz.isEnum() || clazz.isArray() || List.class.isAssignableFrom(clazz) || Set.class.isAssignableFrom(clazz);
    }

    public static void validateCustomizedValueInRequests(List<CustomizedRequestValueDto> customizedRequestValueDtos) {
        if (customizedRequestValueDtos == null || customizedRequestValueDtos.isEmpty()) {
            return;
        }
        customizedRequestValueDtos.forEach(s -> {
            if (s.keyValues != null && s.combinedKeyValuePairs != null) {
                throw new IllegalArgumentException("Driver Config Error: keyValues and keyValuePairs should not be specified at the same time");
            }
            if (s.keyValues == null && s.combinedKeyValuePairs == null) {
                throw new IllegalArgumentException("Driver Config Error: one of keyValues and keyValuePairs must be specified, could not be null at the same time");
            }
        });
        RPCEndpointsBuilder.validateKeyValuePairs(customizedRequestValueDtos);
        RPCEndpointsBuilder.validateKeyValues(customizedRequestValueDtos);
    }

    public static void validateCustomizedNotNullAnnotationForRPCDto(List<CustomizedNotNullAnnotationForRPCDto> notNullAnnotations) {
        if (notNullAnnotations == null || notNullAnnotations.isEmpty()) {
            return;
        }
        notNullAnnotations.forEach(s -> {
            if (s.annotationType == null) {
                throw new IllegalArgumentException("Driver Config Error: annotationType should not be null");
            }
            if (s.annotationMethod == null ^ s.equalsTo == null) {
                throw new IllegalArgumentException("Driver Config Error: annotationMethod and equalsTo should be specified at the same time");
            }
        });
    }

    public static void handleExternalResponses(InterfaceSchema schema, SeededRPCActionDto actionDto, RPCType type) {
        if (actionDto.mockRPCExternalServiceDtos != null && !actionDto.mockRPCExternalServiceDtos.isEmpty()) {
            for (MockRPCExternalServiceDto mockRPCExternalServiceDto : actionDto.mockRPCExternalServiceDtos) {
                RPCEndpointsBuilder.buildExternalServiceResponse(schema, mockRPCExternalServiceDto, type);
            }
        }
        if (actionDto.mockDatabaseDtos != null && !actionDto.mockDatabaseDtos.isEmpty()) {
            for (MockDatabaseDto mockDatabaseDto : actionDto.mockDatabaseDtos) {
                RPCEndpointsBuilder.buildDbExternalServiceResponse(schema, mockDatabaseDto, type);
            }
        }
    }

    private static NamedTypedValue buildExternalServiceResponse(InterfaceSchema schema, String responseType, RPCType rpcType) {
        try {
            Class<?> clazz = Class.forName(responseType);
            HashMap<TypeVariable, Type> genericTypeMap = new HashMap<TypeVariable, Type>();
            return RPCEndpointsBuilder.build(schema, clazz, null, "return", rpcType, new ArrayList<String>(), 0, null, null, null, null, null, genericTypeMap, true);
        }
        catch (ClassNotFoundException e) {
            SimpleLogger.recordErrorMessage("Warning: cannot identify the class from the driver " + e.getMessage());
        }
        catch (Exception e) {
            throw new RuntimeException("EM schema parser error: fail to extract mocked response " + responseType);
        }
        return null;
    }

    public static NamedTypedValue buildExternalServiceResponse(InterfaceSchema schema, MockRPCExternalServiceDto apiDto, RPCType rpcType) {
        try {
            if (apiDto != null) {
                Class<?> interfaceClazz = Class.forName(apiDto.interfaceFullName);
                List<Method> methods = Arrays.stream(interfaceClazz.getDeclaredMethods()).filter(m -> m.getName().equals(apiDto.functionName)).collect(Collectors.toList());
                Method method = RPCEndpointsBuilder.findMethod(methods, apiDto.inputParameterTypes);
                HashMap<TypeVariable, Type> genericTypeMap = new HashMap<TypeVariable, Type>();
                NamedTypedValue response = RPCEndpointsBuilder.build(schema, method.getReturnType(), method.getGenericReturnType(), "return", rpcType, new ArrayList<String>(), 0, null, null, null, null, null, genericTypeMap, true);
                ArrayList<String> modifiedTypes = new ArrayList<String>(apiDto.responseTypes);
                for (int i = 0; i < modifiedTypes.size(); ++i) {
                    if (!((String)modifiedTypes.get(i)).equals(method.getReturnType().getName())) continue;
                    modifiedTypes.set(i, ((TypeSchema)response.getType()).getFullTypeNameWithGenericType());
                }
                apiDto.responseFullTypesWithGeneric = modifiedTypes;
                return response;
            }
        }
        catch (ClassNotFoundException e) {
            if (apiDto.responseTypes != null && !apiDto.responseTypes.isEmpty()) {
                for (String responseType : apiDto.responseTypes) {
                    if (responseType.length() <= 0) continue;
                    RPCEndpointsBuilder.buildExternalServiceResponse(schema, responseType, rpcType);
                }
            }
            return null;
        }
        return null;
    }

    public static NamedTypedValue buildDbExternalServiceResponse(InterfaceSchema schema, MockDatabaseDto dbDto, RPCType rpcType) {
        try {
            int index;
            if (dbDto != null && (index = dbDto.commandName.lastIndexOf(".")) > 0) {
                String methodName = dbDto.commandName.substring(index + 1);
                String dbClazzName = dbDto.commandName.substring(0, index);
                Class<?> dbClazz = Class.forName(dbClazzName);
                List<Method> methods = Arrays.stream(dbClazz.getDeclaredMethods()).filter(m -> m.getName().equals(methodName)).collect(Collectors.toList());
                Method method = RPCEndpointsBuilder.findMethod(methods, null);
                HashMap<TypeVariable, Type> genericTypeMap = new HashMap<TypeVariable, Type>();
                NamedTypedValue response = RPCEndpointsBuilder.build(schema, method.getReturnType(), method.getGenericReturnType(), "return", rpcType, new ArrayList<String>(), 0, null, null, null, null, null, genericTypeMap, true);
                dbDto.responseFullTypeWithGeneric = ((TypeSchema)response.getType()).getFullTypeNameWithGenericType();
                return response;
            }
        }
        catch (ClassNotFoundException e) {
            if (dbDto.responseFullType != null && dbDto.responseFullType.length() > 0) {
                RPCEndpointsBuilder.buildExternalServiceResponse(schema, dbDto.responseFullType, rpcType);
            }
            return null;
        }
        return null;
    }

    private static Method findMethod(List<Method> methods, List<String> inputs) {
        if (methods.isEmpty()) {
            return null;
        }
        if (methods.size() == 1 || inputs == null) {
            return methods.get(0);
        }
        return methods.stream().filter(m -> m.getParameterTypes().length == inputs.size() && Arrays.stream(m.getParameterTypes()).allMatch(fc -> inputs.contains(fc.getName()))).findFirst().orElse(null);
    }

    private static void validateKeyValues(List<CustomizedRequestValueDto> customizedRequestValueDtos) {
        ArrayList handled = new ArrayList();
        customizedRequestValueDtos.stream().filter(s -> s.keyValues != null).forEach(s -> {
            if (s.keyValues.key == null) {
                throw new IllegalArgumentException("Driver Config Error: key must be specified when customizing keyValues");
            }
            if (s.keyValues.values.isEmpty()) {
                throw new IllegalArgumentException("Driver Config Error: at least one values is needed for customizing keyValues with the key " + s.keyValues.key);
            }
            String key = "key:" + s.keyValues.key + RPCEndpointsBuilder.getKeyForCustomizedRequestValueDto(s);
            if (handled.contains(key)) {
                throw new IllegalArgumentException("Driver Config Error: " + key + " should be specified only once");
            }
            handled.add(key);
        });
    }

    private static void validateKeyValuePairs(List<CustomizedRequestValueDto> customizedRequestValueDtos) {
        HashMap<String, List> group = new HashMap<String, List>();
        customizedRequestValueDtos.stream().filter(s -> s.combinedKeyValuePairs != null && !s.combinedKeyValuePairs.isEmpty()).forEach(s -> {
            String key = RPCEndpointsBuilder.getKeyForCustomizedRequestValueDto(s);
            if (key.length() != 0) {
                if (!group.containsKey(key)) {
                    group.put(key, new ArrayList());
                }
                ((List)group.get(key)).add(s);
            }
        });
        group.forEach((key, g) -> {
            if (g.size() > 1) {
                List keys = ((CustomizedRequestValueDto)g.get((int)0)).combinedKeyValuePairs.stream().map(a -> a.fieldKey).collect(Collectors.toList());
                g.forEach(a -> {
                    List akeys = a.combinedKeyValuePairs.stream().map(k -> k.fieldKey).collect(Collectors.toList());
                    if (akeys.size() != keys.size() || !akeys.containsAll(keys)) {
                        throw new IllegalArgumentException("Driver Config Error: keys for same " + key + " must be specified with same keys");
                    }
                });
            }
        });
    }

    private static String getKeyForCustomizedRequestValueDto(CustomizedRequestValueDto s) {
        String key = "";
        if (s.annotationOnEndpoint != null) {
            key = key + " annotationOnEndpoint_" + s.annotationOnEndpoint;
        }
        if (s.specificEndpointName != null) {
            key = key + " specificEndpointName_" + s.specificEndpointName;
        }
        if (s.specificRequestTypeName != null) {
            key = key + " specificRequestTypeName_" + s.specificRequestTypeName;
        }
        return key;
    }

    public static InterfaceSchema build(String interfaceName, RPCType rpcType, Object client, List<String> skipEndpointsByName, List<String> skipEndpointsByAnnotation, List<String> involveEndpointsByName, List<String> involveEndpointsByAnnotation, List<AuthenticationDto> authenticationDtoList, List<CustomizedRequestValueDto> customizedRequestValueDtos, List<CustomizedNotNullAnnotationForRPCDto> notNullAnnotations) {
        ArrayList<EndpointSchema> endpoints = new ArrayList<EndpointSchema>();
        ArrayList<EndpointSchema> endpointsForAuth = new ArrayList<EndpointSchema>();
        ArrayList<String> skippedEndpoints = new ArrayList<String>();
        HashMap<Integer, EndpointSchema> authEndpoints = new HashMap<Integer, EndpointSchema>();
        try {
            Class<?> interfaze = Class.forName(interfaceName);
            InterfaceSchema schema = new InterfaceSchema(interfaceName, endpoints, RPCEndpointsBuilder.getClientClass(client), rpcType, skippedEndpoints, authEndpoints, endpointsForAuth);
            for (Method m : interfaze.getDeclaredMethods()) {
                List<AuthenticationDto> auths;
                if (RPCEndpointsBuilder.filterRPCFunctionMethod(m)) {
                    if (RPCEndpointsBuilder.filterRPCFunctionMethodBasedOnSpecified(m, skipEndpointsByName, skipEndpointsByAnnotation, involveEndpointsByName, involveEndpointsByAnnotation)) {
                        try {
                            EndpointSchema endpointSchema = RPCEndpointsBuilder.build(schema, m, rpcType, authenticationDtoList, customizedRequestValueDtos, notNullAnnotations);
                            endpoints.add(endpointSchema);
                        }
                        catch (RuntimeException exception) {
                            SimpleLogger.recordErrorMessage("EM Driver Error: fail to handle the endpoint schema " + m.getName() + " with the error msg:" + exception.getMessage());
                        }
                    } else {
                        skippedEndpoints.add(m.getName());
                    }
                }
                if ((auths = RPCEndpointsBuilder.getAuthEndpointInInterface(authenticationDtoList, interfaceName, m)) == null || auths.isEmpty()) continue;
                try {
                    EndpointSchema authEndpoint = RPCEndpointsBuilder.build(schema, m, rpcType, null, customizedRequestValueDtos, notNullAnnotations);
                    endpointsForAuth.add(authEndpoint);
                    for (AuthenticationDto auth : auths) {
                        EndpointSchema copy = authEndpoint.copyStructure();
                        if (auth.jsonAuthEndpoint == null) {
                            throw new IllegalArgumentException("Driver Config Error: now we only support auth info specified with JsonAuthRPCEndpointDto");
                        }
                        int index = authenticationDtoList.indexOf(auth);
                        if (copy.getRequestParams().size() != auth.jsonAuthEndpoint.jsonPayloads.size()) {
                            throw new IllegalArgumentException("Driver Config Error: mismatched size of jsonPayloads (" + auth.jsonAuthEndpoint.classNames.size() + ") with real endpoint (" + authEndpoint.getRequestParams().size() + ").");
                        }
                        RPCEndpointsBuilder.setAuthEndpoint(copy, auth.jsonAuthEndpoint);
                        authEndpoints.put(index, copy);
                    }
                }
                catch (RuntimeException exception) {
                    SimpleLogger.recordErrorMessage("EM Driver Error: fail to handle the authEndpoint schema " + m.getName() + " with the error msg:" + exception.getMessage());
                }
            }
            return schema;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("cannot find the interface with the name (" + interfaceName + ") and the error message is " + e.getMessage());
        }
    }

    public static Map<Integer, LocalAuthSetupSchema> buildLocalAuthSetup(List<AuthenticationDto> authenticationDtoList) {
        if (authenticationDtoList == null || authenticationDtoList.isEmpty()) {
            return null;
        }
        HashMap<Integer, LocalAuthSetupSchema> map = new HashMap<Integer, LocalAuthSetupSchema>();
        for (AuthenticationDto dto : authenticationDtoList) {
            if (dto.localAuthSetup == null) continue;
            int index = authenticationDtoList.indexOf(dto);
            LocalAuthSetupSchema local = new LocalAuthSetupSchema();
            local.getRequestParams().get(0).setValueBasedOnInstance(dto.localAuthSetup.authenticationInfo);
            map.put(index, local);
        }
        return map;
    }

    private static void setAuthEndpoint(EndpointSchema authEndpoint, JsonAuthRPCEndpointDto jsonAuthEndpoint) throws ClassNotFoundException {
        if (jsonAuthEndpoint.classNames != null && jsonAuthEndpoint.classNames.size() != jsonAuthEndpoint.jsonPayloads.size()) {
            throw new IllegalArgumentException("Driver Config Error: to specify inputs for auth endpoint, classNames and jsonPayloads should have same size");
        }
        for (int i = 0; i < authEndpoint.getRequestParams().size(); ++i) {
            NamedTypedValue inputParam = authEndpoint.getRequestParams().get(i);
            String jsonString = jsonAuthEndpoint.jsonPayloads.get(i);
            if (jsonAuthEndpoint.classNames == null) {
                RPCEndpointsBuilder.setNamedValueBasedOnJsonString(inputParam, jsonString, i);
                continue;
            }
            Class<?> clazz = Class.forName(jsonAuthEndpoint.classNames.get(i));
            try {
                Object value = objectMapper.readValue(jsonString, clazz);
                inputParam.setValueBasedOnInstance(value);
                continue;
            }
            catch (JsonProcessingException e) {
                SimpleLogger.recordErrorMessage("Driver Config Error: a jsonPayload at (" + i + ") cannot be read as the object " + jsonAuthEndpoint.classNames.get(i));
                RPCEndpointsBuilder.setNamedValueBasedOnJsonString(inputParam, jsonString, i);
            }
        }
    }

    private static void setNamedValueBasedOnJsonString(NamedTypedValue inputParam, String jsonString, int index) {
        if (inputParam instanceof StringParam || inputParam instanceof PrimitiveOrWrapperParam || inputParam instanceof ByteBufferParam) {
            RPCEndpointsBuilder.setNamedValueBasedOnCandidates(inputParam, jsonString);
        } else if (inputParam instanceof ObjectParam) {
            try {
                JsonNode node = objectMapper.readTree(jsonString);
                ArrayList fields = new ArrayList();
                for (NamedTypedValue f : ((ObjectType)((ObjectParam)inputParam).getType()).getFields()) {
                    NamedTypedValue v = f.copyStructureWithProperties();
                    if (node.has(v.getName())) {
                        RPCEndpointsBuilder.setNamedValueBasedOnCandidates(f, node.textValue());
                        fields.add(v);
                        continue;
                    }
                    SimpleLogger.recordErrorMessage("Warning: cannot find field with the name " + v.getName() + " in the specified json");
                }
                inputParam.setValue(fields);
            }
            catch (JsonProcessingException ex) {
                SimpleLogger.recordErrorMessage("Driver Config Error: a jsonPayload at (" + index + ") cannot be read as a JSON object with error:" + ex.getMessage());
            }
        }
    }

    private static List<AuthenticationDto> getAuthEndpointInInterface(List<AuthenticationDto> authenticationDtos, String interfaceName, Method method) {
        if (authenticationDtos == null) {
            return null;
        }
        for (AuthenticationDto dto : authenticationDtos) {
            if (dto.localAuthSetup != null || dto.jsonAuthEndpoint != null && dto.jsonAuthEndpoint.endpointName != null && dto.jsonAuthEndpoint.interfaceName != null) continue;
            SimpleLogger.recordErrorMessage("Driver Config Error: To specify auth for RPC, either localAuthSetup or jsonAuthEndpoint should be specified.For JsonAuthRPCEndpointDto, endpointName and interfaceName cannot be null");
        }
        return authenticationDtos.stream().filter(a -> a.jsonAuthEndpoint != null && a.jsonAuthEndpoint.endpointName.equals(method.getName()) && a.jsonAuthEndpoint.interfaceName.equals(interfaceName)).collect(Collectors.toList());
    }

    private static boolean filterRPCFunctionMethod(Method endpoint) {
        if (RPCEndpointsBuilder.isPotentialStreamingAPI(endpoint)) {
            return false;
        }
        return Modifier.isPublic(endpoint.getModifiers());
    }

    private static boolean filterRPCFunctionMethodBasedOnSpecified(Method endpoint, List<String> skipEndpointsByName, List<String> skipEndpointsByAnnotation, List<String> involveEndpointsByName, List<String> involveEndpointsByAnnotation) {
        if (skipEndpointsByName != null && involveEndpointsByName != null) {
            throw new IllegalArgumentException("Driver Config Error: skipEndpointsByName and involveEndpointsByName should not be specified at same time.");
        }
        if (skipEndpointsByAnnotation != null && involveEndpointsByAnnotation != null) {
            throw new IllegalArgumentException("Driver Config Error: skipEndpointsByAnnotation and involveEndpointsByAnnotation should not be specified at same time.");
        }
        if (skipEndpointsByName != null || skipEndpointsByAnnotation != null) {
            return !RPCEndpointsBuilder.anyMatchByNameAndAnnotation(endpoint, skipEndpointsByName, skipEndpointsByAnnotation);
        }
        if (involveEndpointsByName != null || involveEndpointsByAnnotation != null) {
            return RPCEndpointsBuilder.anyMatchByNameAndAnnotation(endpoint, involveEndpointsByName, involveEndpointsByAnnotation);
        }
        return true;
    }

    private static boolean isPotentialStreamingAPI(Method method) {
        Class<?> returnType = method.getReturnType();
        if (returnType.equals(Iterator.class)) {
            return true;
        }
        for (Parameter parameter : method.getParameters()) {
            if (!parameter.getType().equals(Iterator.class)) continue;
            return true;
        }
        return false;
    }

    private static boolean anyMatchByNameAndAnnotation(Method endpoint, List<String> names, List<String> annotations) {
        boolean anyMatch = false;
        if (annotations != null) {
            for (Annotation annotation : endpoint.getAnnotations()) {
                anyMatch = anyMatch || annotations.contains(annotation.annotationType().getName());
            }
        }
        if (names != null) {
            anyMatch = anyMatch || names.contains(endpoint.getName());
        }
        return anyMatch;
    }

    private static String getClientClass(Object client) {
        if (client == null) {
            return null;
        }
        String clazzType = client.getClass().getName();
        if (!clazzType.startsWith("com.sun.proxy.")) {
            return clazzType;
        }
        Class<?>[] clazz = client.getClass().getInterfaces();
        if (clazz.length == 0) {
            SimpleLogger.recordErrorMessage("Error: the client is not related to any interface");
            return null;
        }
        if (clazz.length > 1) {
            SimpleLogger.recordErrorMessage("ERROR: the client has more than one interfaces");
        }
        return clazz[0].getName();
    }

    private static EndpointSchema build(InterfaceSchema schema, Method method, RPCType rpcType, List<AuthenticationDto> authenticationDtoList, List<CustomizedRequestValueDto> customizedRequestValueDtos, List<CustomizedNotNullAnnotationForRPCDto> notNullAnnotations) {
        ArrayList<NamedTypedValue> requestParams = new ArrayList<NamedTypedValue>();
        List<AuthenticationDto> authAnnotationDtos = RPCEndpointsBuilder.getSpecificRelatedAuth(authenticationDtoList, method);
        List<Integer> authKeys = null;
        if (authAnnotationDtos != null) {
            authKeys = authAnnotationDtos.stream().map(s -> authenticationDtoList.indexOf(s)).collect(Collectors.toList());
        }
        HashSet<String> relatedCustomization = new HashSet<String>();
        for (Parameter p : method.getParameters()) {
            requestParams.add(RPCEndpointsBuilder.buildInputParameter(schema, p, rpcType, RPCEndpointsBuilder.getRelatedCustomization(customizedRequestValueDtos, method), relatedCustomization, notNullAnnotations));
        }
        NamedTypedValue response = null;
        if (!method.getReturnType().equals(Void.TYPE)) {
            HashMap<TypeVariable, Type> genericTypeMap = new HashMap<TypeVariable, Type>();
            response = RPCEndpointsBuilder.build(schema, method.getReturnType(), method.getGenericReturnType(), "return", rpcType, new ArrayList<String>(), 0, null, null, null, null, null, genericTypeMap, false);
        }
        ArrayList<NamedTypedValue> exceptions = null;
        if (method.getExceptionTypes().length > 0) {
            exceptions = new ArrayList<NamedTypedValue>();
            for (int i = 0; i < method.getExceptionTypes().length; ++i) {
                NamedTypedValue exception = RPCEndpointsBuilder.build(schema, method.getExceptionTypes()[i], method.getGenericExceptionTypes()[i], "exception_" + i, rpcType, new ArrayList<String>(), 0, null, null, null, null, null, null, false);
                exceptions.add(exception);
            }
        }
        return new EndpointSchema(method.getName(), schema.getName(), schema.getClientInfo(), requestParams, response, exceptions, authAnnotationDtos != null && !authAnnotationDtos.isEmpty(), authKeys, relatedCustomization);
    }

    private static List<AuthenticationDto> getSpecificRelatedAuth(List<AuthenticationDto> authenticationDtoList, Method method) {
        if (authenticationDtoList == null) {
            return null;
        }
        List annotations = Arrays.stream(method.getAnnotations()).map(s -> s.annotationType().getName()).collect(Collectors.toList());
        return authenticationDtoList.stream().filter(s -> s.localAuthSetup != null && s.localAuthSetup.annotationOnEndpoint != null && annotations.contains(s.localAuthSetup.annotationOnEndpoint) || s.jsonAuthEndpoint != null && s.jsonAuthEndpoint.annotationOnEndpoint != null && annotations.contains(s.jsonAuthEndpoint.annotationOnEndpoint)).collect(Collectors.toList());
    }

    private static Map<Integer, CustomizedRequestValueDto> getRelatedCustomization(List<CustomizedRequestValueDto> customizedRequestValueDtos, Method method) {
        if (customizedRequestValueDtos == null) {
            return null;
        }
        List annotations = Arrays.stream(method.getAnnotations()).map(s -> s.annotationType().getName()).collect(Collectors.toList());
        List<CustomizedRequestValueDto> list = customizedRequestValueDtos.stream().filter(s -> !(s.annotationOnEndpoint != null && !annotations.contains(s.annotationOnEndpoint) || s.specificEndpointName != null && !s.specificEndpointName.contains(method.getName()))).collect(Collectors.toList());
        if (list.isEmpty()) {
            return null;
        }
        HashMap<Integer, CustomizedRequestValueDto> map = new HashMap<Integer, CustomizedRequestValueDto>();
        list.forEach(s -> map.put(customizedRequestValueDtos.indexOf(s), (CustomizedRequestValueDto)s));
        return map;
    }

    private static NamedTypedValue buildInputParameter(InterfaceSchema schema, Parameter parameter, RPCType type, Map<Integer, CustomizedRequestValueDto> customizationDtos, Set<String> relatedCustomization, List<CustomizedNotNullAnnotationForRPCDto> notNullAnnotations) {
        String name = parameter.getName();
        Class<?> clazz = parameter.getType();
        ArrayList<String> flattenDepth = new ArrayList<String>();
        int level = 0;
        HashMap<TypeVariable, Type> genericTypeMap = new HashMap<TypeVariable, Type>();
        NamedTypedValue namedTypedValue = RPCEndpointsBuilder.build(schema, clazz, parameter.getParameterizedType(), name, type, flattenDepth, level, customizationDtos, relatedCustomization, null, notNullAnnotations, null, genericTypeMap, false);
        for (Annotation annotation : parameter.getAnnotations()) {
            RPCEndpointsBuilder.handleConstraint(namedTypedValue, annotation, notNullAnnotations);
        }
        return namedTypedValue;
    }

    private static NamedTypedValue build(InterfaceSchema schema, Class<?> clazz, Type genericType, String name, RPCType rpcType, List<String> flattenDepth, int level, Map<Integer, CustomizedRequestValueDto> customizationDtos, Set<String> relatedCustomization, AccessibleSchema accessibleSchema, List<CustomizedNotNullAnnotationForRPCDto> notNullAnnotations, Class<?> originalType, Map<TypeVariable, Type> genericTypeMap, boolean isTypeToIdentify) {
        NamedTypedValue namedValue;
        block41: {
            RPCEndpointsBuilder.handleGenericSuperclass(clazz, genericTypeMap);
            List<String> genericTypes = RPCEndpointsBuilder.handleGenericType(clazz, genericType, genericTypeMap);
            String clazzWithGenericTypes = CodeJavaOrKotlinGenerator.handleClassNameWithGeneric(clazz.getName(), genericTypes);
            flattenDepth.add(RPCEndpointsBuilder.getObjectTypeNameWithFlag(clazz, clazzWithGenericTypes, level));
            namedValue = null;
            JavaDtoSpec spec = JavaDtoSpec.DEFAULT;
            if (rpcType == RPCType.gRPC || RPCEndpointsBuilder.isProtobuf(clazz)) {
                spec = JavaDtoSpec.PROTO3;
            }
            try {
                if (PrimitiveOrWrapperType.isPrimitiveOrTypes(clazz)) {
                    namedValue = PrimitiveOrWrapperParam.build(name, clazz, accessibleSchema, spec);
                    break block41;
                }
                if (clazz == String.class) {
                    StringType stringType = new StringType(spec);
                    namedValue = new StringParam(name, stringType, accessibleSchema);
                    break block41;
                }
                if (clazz == BigDecimal.class) {
                    BigDecimalType bigDecimalType = new BigDecimalType(spec);
                    namedValue = new BigDecimalParam(name, bigDecimalType, accessibleSchema);
                    break block41;
                }
                if (clazz == BigInteger.class) {
                    BigIntegerType bigIntegerType = new BigIntegerType(spec);
                    namedValue = new BigIntegerParam(name, bigIntegerType, accessibleSchema);
                    break block41;
                }
                if (clazz.isEnum()) {
                    String[] items = (String[])Arrays.stream(clazz.getEnumConstants()).map(e -> RPCEndpointsBuilder.getNameEnumConstant(e)).toArray(String[]::new);
                    EnumType enumType = new EnumType(clazz.getSimpleName(), clazz.getName(), items, clazz, spec);
                    EnumParam param = new EnumParam(name, enumType, accessibleSchema);
                    schema.registerType(enumType.copy(), param.copyStructureWithProperties(), isTypeToIdentify);
                    namedValue = param;
                    break block41;
                }
                if (clazz.isArray()) {
                    Type type = null;
                    Class<?> templateClazz = null;
                    if (genericType instanceof GenericArrayType) {
                        type = ((GenericArrayType)genericType).getGenericComponentType();
                        templateClazz = RPCEndpointsBuilder.getTemplateClass(type, genericTypeMap);
                    } else {
                        templateClazz = clazz.getComponentType();
                    }
                    NamedTypedValue template = RPCEndpointsBuilder.build(schema, templateClazz, type, "template", rpcType, flattenDepth, level, customizationDtos, relatedCustomization, null, notNullAnnotations, null, genericTypeMap, isTypeToIdentify);
                    template.setNullable(false);
                    CollectionType ctype = new CollectionType(clazz.getSimpleName(), clazz.getName(), template, clazz, spec);
                    ctype.depth = RPCEndpointsBuilder.getDepthLevel(clazz, flattenDepth, level, clazzWithGenericTypes);
                    namedValue = new ArrayParam(name, ctype, accessibleSchema);
                    break block41;
                }
                if (clazz == ByteBuffer.class) {
                    namedValue = new ByteBufferParam(name, accessibleSchema, spec);
                    break block41;
                }
                if (clazz.getName().equals("com.google.protobuf.ByteString")) {
                    Protobuf3ByteStringType type = Protobuf3ByteStringType.getInstance(spec, clazz);
                    namedValue = new Protobuf3ByteStringParam(name, type, accessibleSchema);
                    break block41;
                }
                if (List.class.isAssignableFrom(clazz) || Set.class.isAssignableFrom(clazz)) {
                    NamedTypedValue template = null;
                    if (genericType != null) {
                        Type type = ((ParameterizedType)genericType).getActualTypeArguments()[0];
                        Class<?> templateClazz = RPCEndpointsBuilder.getTemplateClass(type, genericTypeMap);
                        template = RPCEndpointsBuilder.build(schema, templateClazz, type, "template", rpcType, flattenDepth, level, customizationDtos, relatedCustomization, null, notNullAnnotations, null, genericTypeMap, isTypeToIdentify);
                    } else {
                        template = new StringParam(name, new StringType(spec), null);
                    }
                    template.setNullable(false);
                    CollectionType ctype = new CollectionType(clazz.getSimpleName(), clazz.getName(), template, clazz, spec);
                    ctype.depth = RPCEndpointsBuilder.getDepthLevel(clazz, flattenDepth, level, clazzWithGenericTypes);
                    if (List.class.isAssignableFrom(clazz)) {
                        namedValue = new ListParam(name, ctype, accessibleSchema);
                    } else if (Set.class.isAssignableFrom(clazz)) {
                        namedValue = new SetParam(name, ctype, accessibleSchema);
                    }
                    break block41;
                }
                if (Map.class.isAssignableFrom(clazz)) {
                    if (genericType == null) {
                        throw new RuntimeException("genericType should not be null for List and Set class");
                    }
                    Type keyType = ((ParameterizedType)genericType).getActualTypeArguments()[0];
                    Type valueType = ((ParameterizedType)genericType).getActualTypeArguments()[1];
                    Class<?> keyTemplateClazz = RPCEndpointsBuilder.getTemplateClass(keyType, genericTypeMap);
                    NamedTypedValue keyTemplate = RPCEndpointsBuilder.build(schema, keyTemplateClazz, keyType, "keyTemplate", rpcType, flattenDepth, level, customizationDtos, relatedCustomization, null, notNullAnnotations, null, genericTypeMap, isTypeToIdentify);
                    keyTemplate.setNullable(false);
                    Class<?> valueTemplateClazz = RPCEndpointsBuilder.getTemplateClass(valueType, genericTypeMap);
                    NamedTypedValue valueTemplate = RPCEndpointsBuilder.build(schema, valueTemplateClazz, valueType, "valueTemplate", rpcType, flattenDepth, level, customizationDtos, relatedCustomization, null, notNullAnnotations, null, genericTypeMap, isTypeToIdentify);
                    MapType mtype = new MapType(clazz.getSimpleName(), clazz.getName(), new PairParam(new PairType(keyTemplate, valueTemplate, spec), null), clazz, spec);
                    mtype.depth = RPCEndpointsBuilder.getDepthLevel(clazz, flattenDepth, level, clazzWithGenericTypes);
                    namedValue = new MapParam(name, mtype, accessibleSchema);
                    break block41;
                }
                if (Date.class.isAssignableFrom(clazz)) {
                    if (clazz == Date.class) {
                        namedValue = new DateParam(name, new UtilDateType(spec), accessibleSchema);
                        break block41;
                    }
                    throw new RuntimeException("NOT support " + clazz.getName() + " date type in java yet");
                }
                if (LocalDate.class.isAssignableFrom(clazz)) {
                    if (clazz == LocalDate.class) {
                        namedValue = new DateParam(name, new LocalDateType(spec), accessibleSchema);
                        break block41;
                    }
                    throw new RuntimeException("NOT support " + clazz.getName() + " date type in java yet");
                }
                if (Exception.class.isAssignableFrom(clazz) && clazz.getName().startsWith("java")) {
                    StringParam msgField = new StringParam("message", new AccessibleSchema(false, null, "getMessage", String.class), spec);
                    ObjectType exceptionType = new ObjectType(clazz.getSimpleName(), clazz.getName(), Collections.singletonList(msgField), clazz, genericTypes, spec);
                    namedValue = new ObjectParam(name, exceptionType, accessibleSchema);
                    break block41;
                }
                if (clazz.getName().startsWith("java")) {
                    throw new RuntimeException("NOT handle " + clazz.getName() + " class in java yet");
                }
                long cycleSize = RPCEndpointsBuilder.getCycleSize(flattenDepth, clazz, clazzWithGenericTypes, level);
                if (cycleSize == 1L) {
                    ArrayList<NamedTypedValue> fields = new ArrayList<NamedTypedValue>();
                    Map<Integer, CustomizedRequestValueDto> objRelatedCustomizationDtos = RPCEndpointsBuilder.getCustomizationBasedOnSpecifiedType(customizationDtos, clazz.getName());
                    int flevel = level + 1;
                    if (rpcType == RPCType.gRPC || RPCEndpointsBuilder.isProtobuf(clazz)) {
                        List<Protobuf3Field> pfList = RPCEndpointsBuilder.getProtobuf3FieldsAndType(clazz);
                        for (Protobuf3Field pf : pfList) {
                            AccessibleSchema faccessSchema = new AccessibleSchema(false, pf.setterName, pf.getterName, pf.fieldType, pf.setterInputParams);
                            NamedTypedValue field = RPCEndpointsBuilder.build(schema, pf.fieldType, pf.genericType, pf.fieldName, rpcType, flattenDepth, flevel, objRelatedCustomizationDtos, relatedCustomization, faccessSchema, notNullAnnotations, null, genericTypeMap, isTypeToIdentify);
                            fields.add(field);
                        }
                    } else {
                        ArrayList<Field> fieldList = new ArrayList<Field>();
                        RPCEndpointsBuilder.getAllFields(clazz, fieldList, rpcType);
                        for (Field f : fieldList) {
                            if (Modifier.isFinal(f.getModifiers()) || RPCEndpointsBuilder.doSkipReflection(f.getName())) continue;
                            AccessibleSchema faccessSchema = RPCEndpointsBuilder.extractAccessibleSchema(clazz, f);
                            if (!(Modifier.isPublic(f.getModifiers()) || faccessSchema.getterMethodName != null && faccessSchema.setterMethodName != null)) {
                                SimpleLogger.recordErrorMessage("Error: skip the field " + f.getName() + " since its setter/getter is not found");
                                continue;
                            }
                            Class fType = f.getType();
                            Class<?> foriginalType = null;
                            Type fGType = f.getGenericType();
                            if (f.getGenericType() instanceof TypeVariable) {
                                foriginalType = f.getType();
                                Type actualType = RPCEndpointsBuilder.getActualType(genericTypeMap, (TypeVariable)f.getGenericType());
                                if (actualType instanceof Class) {
                                    fType = (Class)actualType;
                                    fGType = fType;
                                } else if (actualType instanceof ParameterizedType) {
                                    fGType = actualType;
                                    if (((ParameterizedType)actualType).getRawType() instanceof Class) {
                                        fType = (Class)((ParameterizedType)actualType).getRawType();
                                    } else {
                                        throw new RuntimeException("Error: Fail to handle actual type of a generic type");
                                    }
                                }
                            }
                            NamedTypedValue field = RPCEndpointsBuilder.build(schema, fType, fGType, f.getName(), rpcType, flattenDepth, flevel, objRelatedCustomizationDtos, relatedCustomization, faccessSchema, notNullAnnotations, foriginalType, genericTypeMap, isTypeToIdentify);
                            for (Annotation annotation : f.getAnnotations()) {
                                RPCEndpointsBuilder.handleConstraint(field, annotation, notNullAnnotations);
                            }
                            fields.add(field);
                        }
                    }
                    RPCEndpointsBuilder.handleNativeRPCConstraints(clazz, fields, rpcType);
                    ObjectType otype = new ObjectType(clazz.getSimpleName(), clazz.getName(), fields, clazz, genericTypes, spec);
                    otype.setOriginalType(originalType);
                    otype.depth = RPCEndpointsBuilder.getDepthLevel(clazz, flattenDepth, level, clazzWithGenericTypes);
                    ObjectParam oparam = new ObjectParam(name, otype, accessibleSchema);
                    schema.registerType(otype.copy(), oparam, isTypeToIdentify);
                    namedValue = oparam;
                    break block41;
                }
                CycleObjectType otype = new CycleObjectType(clazz.getSimpleName(), clazz.getName(), clazz, genericTypes, spec);
                otype.depth = RPCEndpointsBuilder.getDepthLevel(clazz, flattenDepth, level, clazzWithGenericTypes);
                ObjectParam oparam = new ObjectParam(name, otype, accessibleSchema);
                schema.registerType(otype.copy(), oparam, isTypeToIdentify);
                namedValue = oparam;
            }
            catch (ClassCastException e2) {
                throw new RuntimeException(String.format("fail to perform reflection on param/field: %s; class: %s; genericType: %s; class of genericType: %s; depth: %s; error info:%s", name, clazz.getName(), genericType == null ? "null" : genericType.getTypeName(), genericType == null ? "null" : genericType.getClass().getName(), String.join((CharSequence)",", flattenDepth), e2.getMessage()));
            }
        }
        ((TypeSchema)namedValue.getType()).setOriginalType(originalType);
        if (customizationDtos != null) {
            RPCEndpointsBuilder.handleNamedValueWithCustomizedDto(namedValue, customizationDtos, relatedCustomization);
        }
        return namedValue;
    }

    private static int getCycleSize(List<String> flattenDepth, Class<?> clazz, String name, int level) {
        int cycle = 1;
        for (String obj : flattenDepth) {
            String[] info = RPCEndpointsBuilder.parseObjectTypeFlag(obj);
            if (RPCEndpointsBuilder.isNotCustomizedObject(clazz) || info == null || Integer.parseInt(info[2]) >= level || !info[1].equals(name)) continue;
            ++cycle;
        }
        return cycle;
    }

    private static boolean isProtobuf(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        boolean isProtobuf = clazz.getName().startsWith(PROTOBUF_PACKAGE);
        if (isProtobuf) {
            return isProtobuf;
        }
        Class<?> pclazz = clazz.getSuperclass();
        if (pclazz != null) {
            return RPCEndpointsBuilder.isProtobuf(pclazz);
        }
        return false;
    }

    private static List<Protobuf3Field> getProtobuf3FieldsAndType(Class<?> clazz) {
        Optional<Class> op = Arrays.stream(clazz.getDeclaredClasses()).filter(s -> s.getSimpleName().equals(PROTOBUF_BUILDER)).findFirst();
        if (!op.isPresent()) {
            return null;
        }
        ArrayList<Protobuf3Field> list = new ArrayList<Protobuf3Field>();
        for (Field f : op.get().getDeclaredFields()) {
            if (!RPCEndpointsBuilder.filterProtobuf3Field(f)) continue;
            String fieldName = RPCEndpointsBuilder.formatProtobuf3FieldName(f.getName());
            Protobuf3Field pf = RPCEndpointsBuilder.findProtobuf3FieldType(op.get(), fieldName);
            if (pf == null) continue;
            list.add(pf);
        }
        return list;
    }

    private static String getNameEnumConstant(Object object) {
        try {
            Method name = object.getClass().getMethod("name", new Class[0]);
            name.setAccessible(true);
            return (String)name.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            SimpleLogger.recordErrorMessage("Driver Error: fail to extract name for enum constant:" + e.getMessage());
            return object.toString();
        }
    }

    private static void handleGenericSuperclass(Class clazz, Map<TypeVariable, Type> map) {
        if (RPCEndpointsBuilder.isNotCustomizedObject(clazz)) {
            return;
        }
        if (clazz.getGenericSuperclass() == null || !(clazz.getGenericSuperclass() instanceof ParameterizedType)) {
            return;
        }
        Type[] actualTypes = ((ParameterizedType)clazz.getGenericSuperclass()).getActualTypeArguments();
        if (((ParameterizedType)clazz.getGenericSuperclass()).getActualTypeArguments().length == 0) {
            return;
        }
        TypeVariable<Class<T>>[] typeVariables = clazz.getSuperclass().getTypeParameters();
        if (typeVariables.length != actualTypes.length) {
            throw new RuntimeException("Error: fail to handle generic types in Dto");
        }
        for (int i = 0; i < typeVariables.length; ++i) {
            map.put(typeVariables[i], actualTypes[i]);
        }
        RPCEndpointsBuilder.handleGenericSuperclass(clazz.getSuperclass(), map);
    }

    private static List<String> handleGenericType(Class<?> clazz, Type genericType, Map<TypeVariable, Type> map) {
        if (RPCEndpointsBuilder.isNotCustomizedObject(clazz)) {
            return null;
        }
        if (!(genericType instanceof ParameterizedType)) {
            return null;
        }
        ArrayList<String> genericTypes = new ArrayList<String>();
        Type[] actualTypes = ((ParameterizedType)genericType).getActualTypeArguments();
        TypeVariable<Class<?>>[] typeVariables = clazz.getTypeParameters();
        if (typeVariables.length != actualTypes.length) {
            throw new RuntimeException("Error: fail to handle generic types in Dto");
        }
        for (int i = 0; i < typeVariables.length; ++i) {
            Type a = actualTypes[i];
            if (a instanceof TypeVariable) {
                a = RPCEndpointsBuilder.getActualType(map, (TypeVariable)a);
            }
            if (a != null) {
                genericTypes.add(a.getTypeName());
            }
            map.put(typeVariables[i], actualTypes[i]);
        }
        return genericTypes;
    }

    private static Type getActualType(Map<TypeVariable, Type> map, TypeVariable typeVariable) {
        Type t = map.get(typeVariable);
        if (t == null) {
            return null;
        }
        if (t instanceof TypeVariable) {
            return RPCEndpointsBuilder.getActualType(map, (TypeVariable)t);
        }
        return t;
    }

    private static void getAllFields(Class<?> clazz, List<Field> fieldList, RPCType type) {
        if (RPCEndpointsBuilder.isNativeThriftDto(clazz)) {
            RPCEndpointsBuilder.getFieldForNativeThriftDto(clazz, fieldList);
            return;
        }
        fieldList.addAll(0, Arrays.asList(clazz.getDeclaredFields()));
        if (!Exception.class.isAssignableFrom(clazz) && clazz.getSuperclass() != null && clazz.getSuperclass() != Object.class) {
            RPCEndpointsBuilder.getAllFields(clazz.getSuperclass(), fieldList, type);
        }
    }

    private static Map<Integer, CustomizedRequestValueDto> getCustomizationBasedOnSpecifiedType(Map<Integer, CustomizedRequestValueDto> customizationDtos, String objTypeName) {
        if (customizationDtos == null) {
            return null;
        }
        return customizationDtos.entrySet().stream().filter(s -> ((CustomizedRequestValueDto)s.getValue()).specificRequestTypeName == null || ((CustomizedRequestValueDto)s.getValue()).specificRequestTypeName.equals(objTypeName)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static AccessibleSchema extractAccessibleSchema(Class<?> clazz, Field field) {
        Method getter = Arrays.stream(clazz.getMethods()).filter(m -> Modifier.isPublic(m.getModifiers()) && RPCEndpointsBuilder.isGetter(field.getName(), m.getName(), field.getType().getTypeName()) && m.getParameterCount() == 0).findFirst().orElse(null);
        Method setter = Arrays.stream(clazz.getMethods()).filter(m -> Modifier.isPublic(m.getModifiers()) && RPCEndpointsBuilder.isSetter(field.getName(), m.getName(), field.getType().getTypeName()) && m.getParameterCount() == 1 && (m.getParameterTypes()[0].equals(field.getType()) || m.getParameterTypes()[0].equals(PrimitiveOrWrapperParam.getPrimitiveOrWrapper(field.getType())))).findFirst().orElse(null);
        return new AccessibleSchema(Modifier.isPublic(field.getModifiers()), setter != null ? setter.getName() : null, getter != null ? getter.getName() : null, getter != null ? getter.getReturnType() : null);
    }

    private static String findGetterOrSetter(Class<?> clazz, Field field, boolean findGetter) {
        List found = findGetter ? Arrays.stream(clazz.getMethods()).filter(m -> Modifier.isPublic(m.getModifiers()) && RPCEndpointsBuilder.isGetter(field.getName(), m.getName(), field.getType().getTypeName()) && m.getParameterCount() == 0).collect(Collectors.toList()) : Arrays.stream(clazz.getMethods()).filter(m -> Modifier.isPublic(m.getModifiers()) && RPCEndpointsBuilder.isSetter(field.getName(), m.getName(), field.getType().getTypeName()) && m.getParameterCount() == 1 && (m.getParameterTypes()[0].equals(field.getType()) || m.getParameterTypes()[0].equals(PrimitiveOrWrapperParam.getPrimitiveOrWrapper(field.getType())))).collect(Collectors.toList());
        if (found.size() == 1) {
            return ((Method)found.get(0)).getName();
        }
        if (Modifier.isPublic(field.getModifiers())) {
            return null;
        }
        String msg = "RPC extract schema Error: cannot access field property, there exist " + found.size() + " methods to access the field " + field.getName() + " for the class " + clazz.getName();
        if (found.size() > 1) {
            SimpleLogger.recordErrorMessage(msg);
            return ((Method)found.get(0)).getName();
        }
        SimpleLogger.recordErrorMessage(msg);
        return null;
    }

    private static boolean isSetter(String fieldName, String methodName, String type) {
        String gsMethod;
        boolean isBoolean = type.equals(Boolean.class.getName()) || type.equals(Boolean.TYPE.getName());
        String fieldText = fieldName;
        if (isBoolean && fieldText.startsWith("is") && fieldText.length() > 2) {
            fieldText = fieldText.substring(2);
        }
        return methodName.equalsIgnoreCase((gsMethod = "set") + fieldText) || methodName.equalsIgnoreCase(gsMethod + fieldName);
    }

    private static boolean isGetter(String fieldName, String methodName, String type) {
        boolean isBoolean = type.equals(Boolean.class.getName()) || type.equals(Boolean.TYPE.getName());
        return methodName.equalsIgnoreCase("get" + fieldName) || isBoolean && (methodName.equalsIgnoreCase(fieldName) || methodName.equalsIgnoreCase("is" + fieldName)) || isBoolean && fieldName.startsWith("is") && methodName.equalsIgnoreCase(fieldName.replaceFirst("is", "get"));
    }

    private static String formatProtobuf3FieldName(String fieldName) {
        if (fieldName.endsWith("_")) {
            return fieldName.substring(0, fieldName.length() - 1);
        }
        return fieldName;
    }

    private static Protobuf3Field findProtobuf3FieldType(Class<?> clazz, String fieldName) {
        List getters;
        Method setter = null;
        Method getter = null;
        Class<?> getterClazz = clazz;
        if (clazz.getInterfaces().length == 1 && clazz.getInterfaces()[0].getName().endsWith(PROTOBUF_INTERFACE_BUILDER_SUFFIX)) {
            getterClazz = clazz.getInterfaces()[0];
        }
        if ((getters = Arrays.stream(getterClazz.getDeclaredMethods()).filter(m -> m.getParameters().length == 0 && m.getAnnotation(Deprecated.class) == null && (m.getName().equalsIgnoreCase("get" + fieldName) || m.getName().equalsIgnoreCase("get" + fieldName + PROTOBUF_LIST_FIELD_SUFFIX) || m.getName().equalsIgnoreCase("get" + fieldName + PROTOBUF_MAP_FIELD_SUFFIX))).collect(Collectors.toList())).size() != 1) {
            return null;
        }
        getter = (Method)getters.get(0);
        if (getter != null && RPCEndpointsBuilder.filterProtobuf3Type(getter.getReturnType())) {
            String setterName = "set" + fieldName;
            if (Map.class.isAssignableFrom(getter.getReturnType())) {
                setterName = PROTOBUF_MAP_SETTER_PREFIX + fieldName;
            } else if (List.class.isAssignableFrom(getter.getReturnType())) {
                setterName = PROTOBUF_LIST_SETTER_PREFIX + fieldName;
            }
            for (Method m2 : clazz.getDeclaredMethods()) {
                if (!m2.getName().equalsIgnoreCase(setterName) || m2.getParameterTypes().length != 1 || !m2.getParameterTypes()[0].isAssignableFrom(getter.getReturnType())) continue;
                setter = m2;
                break;
            }
        }
        if (getter != null && setter != null) {
            Protobuf3Field pf = new Protobuf3Field();
            pf.fieldName = fieldName;
            pf.fieldType = getter.getReturnType();
            pf.genericType = getter.getGenericReturnType();
            pf.getterName = getter.getName();
            pf.setterName = setter.getName();
            pf.setterInputParams = setter.getParameterTypes();
            return pf;
        }
        return null;
    }

    private static boolean filterProtobuf3Field(Field field) {
        return !field.getName().equals("bitField0_");
    }

    private static boolean filterProtobuf3Type(Class<?> clazz) {
        return true;
    }

    private static void handleNamedValueWithCustomizedDto(NamedTypedValue namedTypedValue, Map<Integer, CustomizedRequestValueDto> customizationDtos, Set<String> relatedCustomization) {
        ArrayList<String> candidateReferences = new ArrayList<String>();
        ArrayList<NamedTypedValue> candidates = new ArrayList<NamedTypedValue>();
        customizationDtos.forEach((i, dto) -> {
            if (dto.combinedKeyValuePairs != null) {
                dto.combinedKeyValuePairs.forEach(p -> {
                    NamedTypedValue copy;
                    boolean ok;
                    if (p.fieldKey.equals(namedTypedValue.getName()) && (ok = RPCEndpointsBuilder.setNamedValueBasedOnCandidates(copy = namedTypedValue.copyStructureWithProperties(), p.fieldValue))) {
                        if (!candidateReferences.contains("" + i)) {
                            relatedCustomization.add("" + i);
                            candidateReferences.add("" + i);
                            candidates.add(copy);
                        } else {
                            throw new IllegalArgumentException("Error: there should not exist same key with the name " + p.fieldKey + "in a combinedKeyValuePairs");
                        }
                    }
                });
            }
        });
        if (!candidates.isEmpty()) {
            namedTypedValue.setCandidateReferences(candidateReferences);
            namedTypedValue.setCandidates(candidates);
            return;
        }
        List ikey = customizationDtos.values().stream().filter(s -> s.keyValues != null && s.keyValues.key.equals(namedTypedValue.getName())).collect(Collectors.toList());
        if (ikey.size() == 1) {
            RPCEndpointsBuilder.setCandidatesForNamedValue(namedTypedValue, (CustomizedRequestValueDto)ikey.get(0));
        } else if (ikey.size() > 1) {
            throw new IllegalStateException("Error: more than one Dto for independent key with " + RPCEndpointsBuilder.getKeyForCustomizedRequestValueDto((CustomizedRequestValueDto)ikey.get(0)));
        }
    }

    private static void setCandidatesForNamedValue(NamedTypedValue namedTypedValue, CustomizedRequestValueDto customizedRequestValueDto) {
        boolean handled = true;
        ArrayList<NamedTypedValue> candidates = new ArrayList<NamedTypedValue>();
        if (namedTypedValue instanceof PrimitiveOrWrapperParam || namedTypedValue instanceof StringParam || namedTypedValue instanceof ByteBufferParam) {
            for (String v : customizedRequestValueDto.keyValues.values) {
                NamedTypedValue copy = namedTypedValue.copyStructureWithProperties();
                handled = handled && RPCEndpointsBuilder.setNamedValueBasedOnCandidates(copy, v);
                candidates.add(copy);
            }
        } else {
            SimpleLogger.recordErrorMessage("Error: Do not support configuring pre-defined values for the type " + ((TypeSchema)namedTypedValue.getType()).getFullTypeName());
            return;
        }
        if (handled) {
            namedTypedValue.setCandidates(candidates);
        }
    }

    private static boolean setNamedValueBasedOnCandidates(NamedTypedValue copy, String value) {
        try {
            if (copy instanceof PrimitiveOrWrapperParam) {
                ((PrimitiveOrWrapperParam)copy).setValueBasedOnStringValue(value);
            } else if (copy instanceof StringParam) {
                copy.setValue(value);
            } else if (copy instanceof ByteBufferParam) {
                copy.setValue(value.getBytes());
            }
        }
        catch (RuntimeException exception) {
            SimpleLogger.recordErrorMessage("Error: fail to generate candidates with string value " + value + " for " + copy.getName() + " with type " + ((TypeSchema)copy.getType()).getFullTypeName());
            return false;
        }
        return true;
    }

    private static void handleConstraint(NamedTypedValue namedTypedValue, Annotation annotation, List<CustomizedNotNullAnnotationForRPCDto> notNullAnnotations) {
        if (annotation.annotationType().getName().startsWith("javax.validation.constraints")) {
            JavaXConstraintHandler.handleParam(namedTypedValue, annotation);
        } else if (notNullAnnotations != null && !notNullAnnotations.isEmpty()) {
            boolean isRequired = notNullAnnotations.stream().anyMatch(a -> RPCEndpointsBuilder.isRequired(annotation, a));
            namedTypedValue.setNullable(!isRequired);
        }
    }

    private static boolean isRequired(Annotation annotation, CustomizedNotNullAnnotationForRPCDto notNullAnnotations) {
        if (annotation.annotationType().getName().equals(notNullAnnotations.annotationType)) {
            if (notNullAnnotations.annotationMethod != null && notNullAnnotations.equalsTo != null) {
                try {
                    return annotation.annotationType().getDeclaredMethod(notNullAnnotations.annotationMethod, new Class[0]).invoke((Object)annotation, new Object[0]).equals(notNullAnnotations.equalsTo);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    SimpleLogger.recordErrorMessage("Error: fail to invoke the specified method in the annotation with the error msg:" + e.getMessage());
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private static Class<?> getTemplateClass(Type type, Map<TypeVariable, Type> genericTypeMap) {
        Type actualType = type;
        if (type instanceof TypeVariable) {
            actualType = RPCEndpointsBuilder.getActualType(genericTypeMap, (TypeVariable)type);
        }
        if (actualType instanceof ParameterizedType) {
            return (Class)((ParameterizedType)actualType).getRawType();
        }
        if (actualType instanceof Class) {
            return (Class)actualType;
        }
        throw new RuntimeException("unhanded type:" + type);
    }

    private static boolean doSkipReflection(String name) {
        return name.equals("$jacocoData");
    }

    private static boolean isMetaMap(Field field) {
        boolean result;
        boolean bl = result = field.getName().equals(NATIVE_THRIFT_FIELD_SCHEMA) && Map.class.isAssignableFrom(field.getType());
        if (!result) {
            return result;
        }
        Type genericType = field.getGenericType();
        Type valueType = ((ParameterizedType)genericType).getActualTypeArguments()[1];
        return valueType.getTypeName().equals("org.apache.thrift.meta_data.FieldMetaData");
    }

    private static boolean isNativeThriftDto(Class<?> clazz) {
        return clazz.getInterfaces().length > 0 && Arrays.stream(clazz.getInterfaces()).anyMatch(i -> i.getName().equals(NATIVE_THRIFT_DTO_INTERFACE));
    }

    private static void getFieldForNativeThriftDto(Class<?> clazz, List<Field> fields) {
        try {
            Object metaMap;
            Field metaMap_field = clazz.getDeclaredField(NATIVE_THRIFT_FIELD_SCHEMA);
            if (RPCEndpointsBuilder.isMetaMap(metaMap_field) && (metaMap = metaMap_field.get(null)) instanceof Map) {
                for (Object f : ((Map)metaMap).values()) {
                    Field fname = f.getClass().getDeclaredField("fieldName");
                    fname.setAccessible(true);
                    String name = (String)fname.get(f);
                    fields.add(clazz.getDeclaredField(name));
                }
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            SimpleLogger.recordErrorMessage("Error: fail to get the metaDataMap field in native dto");
        }
    }

    private static void handleNativeRPCConstraints(Class<?> clazz, List<NamedTypedValue> fields, RPCType type) {
        if (RPCEndpointsBuilder.isNativeThriftDto(clazz)) {
            try {
                Field metaMap_field = clazz.getDeclaredField(NATIVE_THRIFT_FIELD_SCHEMA);
                if (RPCEndpointsBuilder.isMetaMap(metaMap_field)) {
                    RPCEndpointsBuilder.handleMetaMap(metaMap_field, fields);
                }
            }
            catch (NoSuchFieldException e) {
                SimpleLogger.recordErrorMessage("Error: fail to get the metaDataMap field in native dto");
            }
        }
    }

    private static void handleMetaMap(Field metaMap_field, List<NamedTypedValue> fields) {
        Object metaMap = null;
        try {
            metaMap = metaMap_field.get(null);
            if (metaMap instanceof Map) {
                for (Object f : ((Map)metaMap).values()) {
                    Field fname = f.getClass().getDeclaredField("fieldName");
                    fname.setAccessible(true);
                    String name = (String)fname.get(f);
                    NamedTypedValue field = RPCEndpointsBuilder.findFieldByName(name, fields);
                    if (field != null) {
                        Field frequiredType = f.getClass().getDeclaredField("requirementType");
                        frequiredType.setAccessible(true);
                        byte required = (Byte)frequiredType.get(f);
                        if (required != 1) continue;
                        field.setNullable(false);
                        continue;
                    }
                    SimpleLogger.recordErrorMessage("Error: fail to find field in list but exist in metaMap, and the field name is " + name);
                }
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            SimpleLogger.recordErrorMessage("Error: fail to set isNull based on metaMap of Thrift struct " + e.getMessage());
        }
    }

    private static NamedTypedValue findFieldByName(String name, List<NamedTypedValue> fields) {
        for (NamedTypedValue f : fields) {
            if (!f.getName().equals(name)) continue;
            return f;
        }
        return null;
    }

    private static int getDepthLevel(Class clazz, List<String> flattendepth, int level, String clazzFullNameWithGeneric) {
        String tag = RPCEndpointsBuilder.getObjectTypeNameWithFlag(clazz, clazzFullNameWithGeneric, -2);
        int start = 0;
        for (int i = 0; i < flattendepth.size(); ++i) {
            if (!flattendepth.get(i).startsWith(tag)) continue;
            start = i;
        }
        return flattendepth.subList(start, flattendepth.size()).stream().filter(s -> !s.startsWith(tag) && s.startsWith(OBJECT_FLAG)).collect(Collectors.toSet()).size();
    }

    public static Map<String, List<RPCActionDto>> buildSeededTest(Map<String, InterfaceSchema> rpcInterfaceSchema, List<SeededRPCTestDto> seedRPCTests, RPCType rpcType) {
        HashMap<String, List<RPCActionDto>> results = new HashMap<String, List<RPCActionDto>>();
        for (SeededRPCTestDto dto : seedRPCTests) {
            if (dto.rpcFunctions != null && !dto.rpcFunctions.isEmpty()) {
                ArrayList<RPCActionDto> test = new ArrayList<RPCActionDto>();
                try {
                    for (SeededRPCActionDto actionDto : dto.rpcFunctions) {
                        InterfaceSchema schema = rpcInterfaceSchema.get(actionDto.interfaceName);
                        if (schema != null) {
                            EndpointSchema actionSchema = schema.getOneEndpointWithSeededDto(actionDto);
                            if (actionSchema != null) {
                                EndpointSchema copy = actionSchema.copyStructure();
                                for (int i = 0; i < copy.getRequestParams().size(); ++i) {
                                    NamedTypedValue p = copy.getRequestParams().get(i);
                                    try {
                                        String stringValue = actionDto.inputParams.get(i);
                                        p.setValueBasedOnInstanceOrJson(stringValue);
                                        continue;
                                    }
                                    catch (JsonProcessingException e) {
                                        SimpleLogger.recordErrorMessage(String.format("Seeded Test Error: cannot parse the seeded test %s at the parameter %d with error msg: %s", actionDto, i, e.getMessage()));
                                    }
                                }
                                RPCActionDto rpcActionDto = copy.getDto();
                                rpcActionDto.mockRPCExternalServiceDtos = actionDto.mockRPCExternalServiceDtos;
                                rpcActionDto.mockDatabaseDtos = actionDto.mockDatabaseDtos;
                                RPCEndpointsBuilder.handleExternalResponses(schema, actionDto, rpcType);
                                test.add(rpcActionDto);
                                continue;
                            }
                            SimpleLogger.recordErrorMessage("Seeded Test Error: cannot find the action " + actionDto.functionName);
                            continue;
                        }
                        SimpleLogger.recordErrorMessage("Seeded Test Error: cannot find the interface " + actionDto.interfaceName);
                    }
                    results.put(String.format("%s_INDEX_%d", dto.testName != null ? dto.testName : "untitled", seedRPCTests.indexOf(dto)), test);
                }
                catch (RuntimeException e) {
                    SimpleLogger.recordErrorMessage("Fail to handle specified seeded test: " + (dto.testName != null ? dto.testName : "index_" + seedRPCTests.indexOf(dto)));
                    StringBuilder msg = new StringBuilder("Fail to handle specified seeded test " + e.getMessage());
                    StackTraceElement[] exceptionStack = e.getStackTrace();
                    if (exceptionStack != null && exceptionStack.length > 0) {
                        msg.append(" with stack:");
                        for (int i = 0; i < Math.min(exceptionStack.length, 5); ++i) {
                            msg.append(exceptionStack.toString());
                            msg.append(System.lineSeparator());
                        }
                    }
                    SimpleLogger.recordErrorMessage(msg.toString());
                }
                continue;
            }
            SimpleLogger.warn("Seeded Test: empty RPC function calls for the test " + (dto.testName != null ? dto.testName : "index_" + seedRPCTests.indexOf(dto)));
        }
        return results;
    }
}

