/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation;

import java.io.Serializable;
import java.util.Objects;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.ExternalServiceInfoUtils;

public class HostnameResolutionInfo
implements Serializable {
    private final String remoteHostname;
    private final String resolvedAddress;

    public HostnameResolutionInfo(String remoteHostname, String resolvedAddress) {
        if (remoteHostname == null || remoteHostname.isEmpty()) {
            throw new IllegalArgumentException("Empty remoteHostName");
        }
        if (resolvedAddress != null && !ExternalServiceInfoUtils.isValidIP(resolvedAddress)) {
            throw new IllegalArgumentException("Invalid resolved IP address: " + resolvedAddress);
        }
        this.remoteHostname = remoteHostname;
        this.resolvedAddress = resolvedAddress;
    }

    public String getHostname() {
        return this.remoteHostname;
    }

    public String getResolvedAddress() {
        return this.resolvedAddress;
    }

    public Boolean getResolved() {
        return this.resolvedAddress != null;
    }

    public HostnameResolutionInfo copy() {
        return new HostnameResolutionInfo(this.remoteHostname, this.resolvedAddress);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostnameResolutionInfo that = (HostnameResolutionInfo)o;
        return Objects.equals(this.remoteHostname, that.remoteHostname) && Objects.equals(this.resolvedAddress, that.resolvedAddress);
    }

    public int hashCode() {
        return Objects.hash(this.remoteHostname, this.resolvedAddress);
    }
}

