/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.visitor.classv;

import org.evomaster.client.java.instrumentation.Constants;
import org.evomaster.client.java.instrumentation.coverage.visitor.methodv.CheckCastMethodVisitor;
import org.evomaster.client.java.instrumentation.coverage.visitor.methodv.MethodReplacementMethodVisitor;
import org.evomaster.client.java.instrumentation.coverage.visitor.methodv.ScheduledMethodVisitor;
import org.evomaster.client.java.instrumentation.shared.ClassName;
import shaded.org.objectweb.asm.ClassVisitor;
import shaded.org.objectweb.asm.MethodVisitor;
import shaded.org.objectweb.asm.commons.JSRInlinerAdapter;

public class ThirdPartyClassVisitor
extends ClassVisitor {
    private final String bytecodeClassName;

    public ThirdPartyClassVisitor(ClassVisitor cv, ClassName className) {
        super(589824, cv);
        this.bytecodeClassName = className.getBytecodeName();
    }

    @Override
    public MethodVisitor visitMethod(int methodAccess, String name, String descriptor, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(methodAccess, name, descriptor, signature, exceptions);
        mv = new JSRInlinerAdapter(mv, methodAccess, name, descriptor, signature, exceptions);
        if (Constants.isMethodBridge(methodAccess)) {
            return mv;
        }
        if (name.equals("<clinit>")) {
            return mv;
        }
        mv = new ScheduledMethodVisitor(mv);
        mv = new CheckCastMethodVisitor(mv);
        mv = new MethodReplacementMethodVisitor(false, false, mv, this.bytecodeClassName, name, descriptor);
        return mv;
    }
}

