/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.object;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.evomaster.client.java.instrumentation.object.CustomTypeToOasConverter;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;
import org.evomaster.client.java.instrumentation.staticstate.UnitsInfoRecorder;
import org.evomaster.client.java.utils.SimpleLogger;

public class ClassToSchema {
    private static final Map<Type, String> cacheSchema = new ConcurrentHashMap<Type, String>();
    private static final Map<Type, String> cacheSchemaWithItsRef = new ConcurrentHashMap<Type, String>();
    private static final Map<Type, Map<String, String>> cacheMapOfDtoAndItsRefToSchemas = new ConcurrentHashMap<Type, Map<String, String>>();
    private static final String fieldRefPrefix = "{\"$ref\":\"";
    private static final String fieldRefPostfix = "\"}";

    public static void registerSchemaIfNeeded(Class<?> valueType) {
        ClassToSchema.registerSchemaIfNeeded(valueType, false, Collections.emptyList());
    }

    public static void registerSchemaIfNeeded(Class<?> valueType, boolean objectFieldsRequired, List<CustomTypeToOasConverter> converters) {
        if (valueType == null) {
            return;
        }
        if (valueType.getName().startsWith("io.swagger.")) {
            return;
        }
        try {
            String name = valueType.getName();
            if (!UnitsInfoRecorder.isDtoSchemaRegister(name).booleanValue()) {
                ArrayList embedded = new ArrayList();
                String schema = ClassToSchema.getOrDeriveSchema(valueType, embedded, objectFieldsRequired, converters);
                UnitsInfoRecorder.registerNewParsedDto(name, schema);
                if (!embedded.isEmpty()) {
                    embedded.forEach(e -> ClassToSchema.registerSchemaIfNeeded(e, objectFieldsRequired, converters));
                }
            }
            ExecutionTracer.addParsedDtoName(name);
        }
        catch (Exception e2) {
            SimpleLogger.warn("Fail to get schema for Class:" + valueType.getName(), e2);
        }
    }

    public static String getOrDeriveSchemaWithItsRef(Class<?> klass) {
        return ClassToSchema.getOrDeriveSchemaWithItsRef(klass, false, Collections.emptyList());
    }

    public static String getOrDeriveSchemaWithItsRef(Class<?> klass, boolean objectFieldsRequired, List<CustomTypeToOasConverter> converters) {
        if (!cacheSchemaWithItsRef.containsKey(klass)) {
            StringBuilder sb = new StringBuilder();
            Map<String, String> map = ClassToSchema.getOrDeriveSchemaAndNestedClasses(klass, objectFieldsRequired, converters);
            sb.append("{");
            sb.append(map.get(klass.getName()));
            map.keySet().stream().filter(s -> !s.equals(klass.getName())).forEach(s -> sb.append(",").append((String)map.get(s)));
            sb.append("}");
            cacheSchemaWithItsRef.put(klass, ClassToSchema.named(klass.getName(), sb.toString()));
        }
        return cacheSchemaWithItsRef.get(klass);
    }

    public static String getOrDeriveNonNestedSchema(Class<?> klass, boolean objectFieldsRequired, List<CustomTypeToOasConverter> converters) {
        return ClassToSchema.getOrDeriveSchema(klass, Collections.emptyList(), objectFieldsRequired, converters);
    }

    public static String getOrDeriveNonNestedSchema(Class<?> klass) {
        return ClassToSchema.getOrDeriveNonNestedSchema(klass, false, Collections.emptyList());
    }

    public static String getOrDeriveSchema(Class<?> klass, List<Class<?>> nested) {
        return ClassToSchema.getOrDeriveSchema(klass, nested, false, Collections.emptyList());
    }

    public static String getOrDeriveSchema(Class<?> klass, List<Class<?>> nested, boolean objectFieldsRequired, List<CustomTypeToOasConverter> converters) {
        if (!cacheSchema.containsKey(klass)) {
            cacheSchema.put(klass, ClassToSchema.getOrDeriveSchema(klass.getName(), klass, false, nested, objectFieldsRequired, converters));
        }
        return cacheSchema.get(klass);
    }

    private static String getOrDeriveSchema(String name, Type type, Boolean useRefObject, List<Class<?>> nested, boolean objectFieldsRequired, List<CustomTypeToOasConverter> converters) {
        if (cacheSchema.containsKey(type) && !useRefObject.booleanValue() && !ClassToSchema.isCollectionOrMap(type)) {
            return cacheSchema.get(type);
        }
        String schema = ClassToSchema.getSchema(type, useRefObject, nested, false, objectFieldsRequired, converters);
        String namedSchema = ClassToSchema.named(name, schema);
        if (!schema.startsWith(fieldRefPrefix) && !ClassToSchema.isCollectionOrMap(type)) {
            cacheSchema.put(type, namedSchema);
        }
        return namedSchema;
    }

    private static boolean isCollectionOrMap(Type type) {
        if (!(type instanceof Class)) {
            return false;
        }
        Class kclazz = (Class)type;
        return kclazz.isArray() || Collection.class.isAssignableFrom(kclazz) || Map.class.isAssignableFrom(kclazz);
    }

    public static Map<String, String> getOrDeriveSchemaAndNestedClasses(Class<?> klass, boolean objectFieldsRequired, List<CustomTypeToOasConverter> converters) {
        if (!cacheMapOfDtoAndItsRefToSchemas.containsKey(klass)) {
            ArrayList nested = new ArrayList();
            ClassToSchema.registerSchemaIfNeeded(klass, objectFieldsRequired, converters);
            ClassToSchema.findAllNestedClassAndRegisterThemIfNeeded(klass, nested, objectFieldsRequired, converters);
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            for (Class clazz : nested) {
                map.putIfAbsent(clazz.getName(), ClassToSchema.getOrDeriveNonNestedSchema(clazz, objectFieldsRequired, converters));
            }
            cacheMapOfDtoAndItsRefToSchemas.put(klass, map);
        }
        return cacheMapOfDtoAndItsRefToSchemas.get(klass);
    }

    private static void findAllNestedClassAndRegisterThemIfNeeded(Class<?> klass, List<Class<?>> nested, boolean objectFieldsRequired, List<CustomTypeToOasConverter> converters) {
        if (!nested.contains(klass)) {
            ArrayList innerNested = new ArrayList();
            ClassToSchema.getSchema(klass, false, innerNested, true, objectFieldsRequired, converters);
            nested.add(klass);
            List<Class> toAdd = innerNested.stream().filter(s -> !nested.contains(s)).collect(Collectors.toList());
            if (toAdd.isEmpty()) {
                return;
            }
            toAdd.forEach(a -> ClassToSchema.findAllNestedClassAndRegisterThemIfNeeded(a, nested, objectFieldsRequired, converters));
        }
    }

    private static String named(String name, String jsonObject) {
        return "\"" + name + "\":" + jsonObject;
    }

    private static String getSchema(Type type, Boolean useRefObject, List<Class<?>> nested, boolean allNested, boolean objectFieldsRequired, List<CustomTypeToOasConverter> converters) {
        Class klass = null;
        if (type instanceof Class) {
            klass = (Class)type;
        }
        ParameterizedType pType = null;
        if (type instanceof ParameterizedType) {
            pType = (ParameterizedType)type;
        }
        if (klass != null) {
            if (klass.isEnum()) {
                String[] items = (String[])Arrays.stream(klass.getEnumConstants()).map(e -> ClassToSchema.getNameEnumConstant(e)).toArray(String[]::new);
                return ClassToSchema.fieldEnumSchema(items);
            }
            if (String.class.isAssignableFrom(klass)) {
                return ClassToSchema.fieldSchema("string");
            }
            if (Byte.class.isAssignableFrom(klass) || Byte.TYPE == klass) {
                return ClassToSchema.fieldSchema("integer", "int8");
            }
            if (Character.class.isAssignableFrom(klass) || Character.TYPE == klass) {
                return ClassToSchema.fieldSchema("string", "char");
            }
            if (Short.class.isAssignableFrom(klass) || Short.TYPE == klass) {
                return ClassToSchema.fieldSchema("integer", "int16");
            }
            if (Integer.class.isAssignableFrom(klass) || Integer.TYPE == klass) {
                return ClassToSchema.fieldSchema("integer", "int32");
            }
            if (Long.class.isAssignableFrom(klass) || Long.TYPE == klass) {
                return ClassToSchema.fieldSchema("integer", "int64");
            }
            if (Float.class.isAssignableFrom(klass) || Float.TYPE == klass) {
                return ClassToSchema.fieldSchema("number", "float");
            }
            if (Double.class.isAssignableFrom(klass) || Double.TYPE == klass) {
                return ClassToSchema.fieldSchema("number", "double");
            }
            if (Boolean.class.isAssignableFrom(klass) || Boolean.TYPE == klass) {
                return ClassToSchema.fieldSchema("boolean");
            }
            if (BigDecimal.class.isAssignableFrom(klass)) {
                return ClassToSchema.fieldSchema("integer", "int64");
            }
            if (Date.class.isAssignableFrom(klass)) {
                return ClassToSchema.fieldSchema("string", "date");
            }
            if (LocalDate.class.isAssignableFrom(klass)) {
                return ClassToSchema.fieldSchema("string", "local-date");
            }
            if (LocalDateTime.class.isAssignableFrom(klass)) {
                return ClassToSchema.fieldSchema("string", "local-date-time");
            }
            if (LocalTime.class.isAssignableFrom(klass)) {
                return ClassToSchema.fieldSchema("string", "local-time");
            }
            for (CustomTypeToOasConverter converter : converters) {
                if (!converter.isInstanceOf(klass)) continue;
                return converter.convert();
            }
        }
        if (klass != null && (klass.isArray() || Collection.class.isAssignableFrom(klass)) || pType != null && Collection.class.isAssignableFrom((Class)pType.getRawType())) {
            return ClassToSchema.fieldArraySchema(klass, pType, nested, allNested, objectFieldsRequired, converters);
        }
        if (klass != null && Map.class.isAssignableFrom(klass) || pType != null && Map.class.isAssignableFrom((Class)pType.getRawType())) {
            Type keyType;
            if (pType != null && pType.getActualTypeArguments().length > 0 && (keyType = pType.getActualTypeArguments()[0]) != String.class) {
                throw new IllegalStateException("only support Map with String key");
            }
            return ClassToSchema.fieldStringKeyMapSchema(klass, pType, nested, allNested, objectFieldsRequired, converters);
        }
        if (klass != null && useRefObject.booleanValue()) {
            if (!(!allNested && UnitsInfoRecorder.isDtoSchemaRegister(klass.getName()).booleanValue() || nested.contains(klass))) {
                nested.add(klass);
            }
            return ClassToSchema.fieldObjectRefSchema(klass.getName());
        }
        ArrayList<String> properties = new ArrayList<String>();
        ArrayList<String> propertiesNames = new ArrayList<String>();
        for (Class target = klass; target != null; target = target.getSuperclass()) {
            for (Field f : target.getDeclaredFields()) {
                if (!ClassToSchema.shouldAddToSchema(f)) continue;
                String fieldName = ClassToSchema.getName(f);
                String fieldSchema = null;
                fieldSchema = allNested ? ClassToSchema.named(fieldName, ClassToSchema.getSchema(f.getGenericType(), true, nested, true, objectFieldsRequired, converters)) : ClassToSchema.getOrDeriveSchema(fieldName, f.getGenericType(), true, nested, objectFieldsRequired, converters);
                properties.add(fieldSchema);
                propertiesNames.add("\"" + fieldName + "\"");
            }
        }
        return ClassToSchema.fieldObjectSchema(properties, propertiesNames, objectFieldsRequired);
    }

    private static boolean shouldAddToSchema(Field field) {
        if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) {
            return false;
        }
        for (Annotation a : field.getAnnotations()) {
            String name = a.annotationType().getSimpleName();
            if (!name.equalsIgnoreCase("Ignore") && !name.equalsIgnoreCase("Ignored") && !name.equalsIgnoreCase("Exclude") && !name.equalsIgnoreCase("Excluded") && !name.equalsIgnoreCase("JsonIgnore") && !name.equalsIgnoreCase("Skip") && !name.equalsIgnoreCase("Transient")) continue;
            return false;
        }
        return true;
    }

    private static String getName(Field field) {
        for (Annotation a : field.getAnnotations()) {
            String name = a.annotationType().getName();
            if (!name.equals("  com.fasterxml.jackson.annotation.JsonProperty".trim()) && !name.equals("com.google.gson.annotations.SerializedName") && !name.equals("org.springframework.data.mongodb.core.mapping.Field")) continue;
            try {
                Method m = a.annotationType().getMethod("value", new Class[0]);
                String value = (String)m.invoke((Object)a, new Object[0]);
                if (value == null || value.isEmpty()) continue;
                return value;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return field.getName();
    }

    private static String fieldArraySchema(Class<?> klass, ParameterizedType pType, List<Class<?>> embedded, boolean allEmbedded, boolean objectFieldsRequired, List<CustomTypeToOasConverter> converters) {
        String item;
        if (klass != null) {
            item = klass.isArray() ? ClassToSchema.getSchema(klass.getComponentType(), true, embedded, allEmbedded, objectFieldsRequired, converters) : ClassToSchema.getSchema(String.class, true, embedded, allEmbedded, objectFieldsRequired, converters);
        } else {
            Type generic = pType.getActualTypeArguments()[0];
            item = ClassToSchema.getSchema(generic, true, embedded, allEmbedded, objectFieldsRequired, converters);
        }
        return "{\"type\":\"array\", \"items\":" + item + "}";
    }

    private static String fieldStringKeyMapSchema(Class<?> klass, ParameterizedType pType, List<Class<?>> embedded, boolean allEmbedded, boolean objectFieldsRequired, List<CustomTypeToOasConverter> converters) {
        String value;
        if (klass != null) {
            value = "true";
        } else {
            Type generic = pType.getActualTypeArguments()[1];
            value = ClassToSchema.getSchema(generic, true, embedded, allEmbedded, objectFieldsRequired, converters);
        }
        return "{\"type\":\"object\", \"additionalProperties\":" + value + "}";
    }

    private static String fieldObjectSchema(List<String> properties, List<String> propertiesNames, boolean objectFieldsRequired) {
        String p = properties.stream().collect(Collectors.joining(","));
        String r = propertiesNames.stream().collect(Collectors.joining(","));
        if (objectFieldsRequired) {
            return "{\"type\":\"object\", \"properties\": {" + p + "}, \"required\": [" + r + "]}";
        }
        return "{\"type\":\"object\", \"properties\": {" + p + "}}";
    }

    private static String fieldObjectRefSchema(String name) {
        return "{\"$ref\":\"#/components/schemas/" + name + fieldRefPostfix;
    }

    private static String fieldSchema(String type) {
        return "{\"type\":\"" + type + fieldRefPostfix;
    }

    private static String fieldSchema(String type, String format) {
        return "{\"type\":\"" + type + "\", \"format\":\"" + format + fieldRefPostfix;
    }

    private static String fieldEnumSchema(String[] items) {
        return "{\"type\":\"string\", \"enum\":[" + Arrays.stream(items).map(s -> "\"" + s + "\"").collect(Collectors.joining(",")) + "]}";
    }

    private static String getNameEnumConstant(Object object) {
        try {
            Method name = object.getClass().getMethod("name", new Class[0]);
            name.setAccessible(true);
            return (String)name.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            SimpleLogger.warn("Driver Error: fail to extract name for enum constant", e);
            return object.toString();
        }
    }
}

