/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.jetty.server;

import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.Set;
import shaded.org.eclipse.jetty.io.EndPoint;
import shaded.org.eclipse.jetty.server.Connector;
import shaded.org.eclipse.jetty.server.HttpConfiguration;
import shaded.org.eclipse.jetty.server.ProxyConnectionFactory;
import shaded.org.eclipse.jetty.server.Request;
import shaded.org.eclipse.jetty.util.Attributes;

public class ProxyCustomizer
implements HttpConfiguration.Customizer {
    public static final String REMOTE_ADDRESS_ATTRIBUTE_NAME = "shaded.org.eclipse.jetty.proxy.remote.address";
    public static final String REMOTE_PORT_ATTRIBUTE_NAME = "shaded.org.eclipse.jetty.proxy.remote.port";
    public static final String LOCAL_ADDRESS_ATTRIBUTE_NAME = "shaded.org.eclipse.jetty.proxy.local.address";
    public static final String LOCAL_PORT_ATTRIBUTE_NAME = "shaded.org.eclipse.jetty.proxy.local.port";

    @Override
    public void customize(Connector connector, HttpConfiguration channelConfig, Request request) {
        EndPoint endPoint = request.getHttpChannel().getEndPoint();
        if (endPoint instanceof ProxyConnectionFactory.ProxyEndPoint) {
            EndPoint underlyingEndpoint = ((ProxyConnectionFactory.ProxyEndPoint)endPoint).unwrap();
            request.setAttributes(new ProxyAttributes(underlyingEndpoint.getRemoteAddress(), underlyingEndpoint.getLocalAddress(), request.getAttributes()));
        }
    }

    private static class ProxyAttributes
    extends Attributes.Wrapper {
        private final InetSocketAddress remoteAddress;
        private final InetSocketAddress localAddress;

        private ProxyAttributes(InetSocketAddress remoteAddress, InetSocketAddress localAddress, Attributes attributes) {
            super(attributes);
            this.remoteAddress = remoteAddress;
            this.localAddress = localAddress;
        }

        @Override
        public Object getAttribute(String name) {
            switch (name) {
                case "shaded.org.eclipse.jetty.proxy.remote.address": {
                    return this.remoteAddress.getAddress().getHostAddress();
                }
                case "shaded.org.eclipse.jetty.proxy.remote.port": {
                    return this.remoteAddress.getPort();
                }
                case "shaded.org.eclipse.jetty.proxy.local.address": {
                    return this.localAddress.getAddress().getHostAddress();
                }
                case "shaded.org.eclipse.jetty.proxy.local.port": {
                    return this.localAddress.getPort();
                }
            }
            return super.getAttribute(name);
        }

        @Override
        public Set<String> getAttributeNameSet() {
            HashSet<String> names = new HashSet<String>(this._attributes.getAttributeNameSet());
            names.add(ProxyCustomizer.REMOTE_ADDRESS_ATTRIBUTE_NAME);
            names.add(ProxyCustomizer.REMOTE_PORT_ATTRIBUTE_NAME);
            names.add(ProxyCustomizer.LOCAL_ADDRESS_ATTRIBUTE_NAME);
            names.add(ProxyCustomizer.LOCAL_PORT_ATTRIBUTE_NAME);
            return names;
        }
    }
}

