/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.insert.Insert;
import org.evomaster.client.java.controller.api.dto.database.operations.InsertionDto;
import org.evomaster.client.java.controller.api.dto.database.operations.InsertionEntryDto;
import org.evomaster.client.java.controller.api.dto.database.operations.InsertionResultsDto;
import org.evomaster.client.java.sql.QueryResult;
import org.evomaster.client.java.sql.internal.ParserUtils;
import org.evomaster.client.java.utils.SimpleLogger;

public class SqlScriptRunner {
    private static final String DEFAULT_DELIMITER = ";";
    public static final Pattern delimP = Pattern.compile("^\\s*(--)?\\s*delimiter\\s*=?\\s*([^\\s]+)+\\s*.*$", 2);
    private static final String SINGLE_APOSTROPHE = "'";
    private static final String DOUBLE_APOSTROPHE = "''";
    private static final String QUOTATION_MARK = "\"";
    private static final String SINGLE_APOSTROPHE_PLACEHOLDER = "SINGLE_APOSTROPHE_PLACEHOLDER";
    private String delimiter = ";";
    private boolean fullLineDelimiter = false;

    public void setDelimiter(String delimiter, boolean fullLineDelimiter) {
        this.delimiter = delimiter;
        this.fullLineDelimiter = fullLineDelimiter;
    }

    public static void runScript(Connection connection, Reader reader) {
        Objects.requireNonNull(reader);
        SqlScriptRunner.runCommands(connection, new SqlScriptRunner().readCommands(reader));
    }

    public static void runScriptFromResourceFile(Connection connection, String resourcePath) {
        try {
            InputStream in = SqlScriptRunner.class.getResourceAsStream(resourcePath);
            SqlScriptRunner.runScript(connection, new InputStreamReader(in));
            in.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runCommands(Connection connection, List<String> commands) {
        try {
            boolean originalAutoCommit = connection.getAutoCommit();
            try {
                if (!originalAutoCommit) {
                    connection.setAutoCommit(true);
                }
                for (String command : commands) {
                    SqlScriptRunner.execCommand(connection, command);
                }
            }
            finally {
                connection.setAutoCommit(originalAutoCommit);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error running script.  Cause: " + e, e);
        }
    }

    public String readSQLCommandsAsString(Reader reader) {
        return String.join((CharSequence)(DEFAULT_DELIMITER + System.lineSeparator()), this.readCommands(reader));
    }

    public List<String> readCommands(Reader reader) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder command = null;
        try {
            String line;
            LineNumberReader lineReader = new LineNumberReader(reader);
            while ((line = lineReader.readLine()) != null) {
                if (command == null) {
                    command = new StringBuilder();
                }
                String trimmedLine = line.trim();
                Matcher delimMatch = delimP.matcher(trimmedLine);
                if (trimmedLine.isEmpty() || trimmedLine.startsWith("//") || trimmedLine.startsWith("--")) continue;
                if (delimMatch.matches()) {
                    this.setDelimiter(delimMatch.group(2), false);
                    continue;
                }
                if (!this.fullLineDelimiter && trimmedLine.endsWith(this.delimiter) || this.fullLineDelimiter && trimmedLine.equals(this.delimiter)) {
                    command.append(line, 0, line.lastIndexOf(this.delimiter));
                    command.append(" ");
                    list.add(command.toString());
                    command = null;
                    continue;
                }
                command.append(line);
                command.append("\n");
            }
            if (command != null && command.length() > 0) {
                list.add(command.toString());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return list;
    }

    public static InsertionResultsDto execInsert(Connection conn, List<InsertionDto> insertions, InsertionResultsDto ... previous) throws SQLException {
        if (insertions == null || insertions.isEmpty()) {
            throw new IllegalArgumentException("No data to insert");
        }
        String insertSql = "INSERT INTO ";
        HashMap<Long, Long> map = new HashMap<Long, Long>();
        if (previous != null) {
            Arrays.stream(previous).forEach(p -> map.putAll(p.idMapping));
        }
        ArrayList<Boolean> sqlResults = new ArrayList<Boolean>(Collections.nCopies(insertions.size(), false));
        for (int i = 0; i < insertions.size(); ++i) {
            Long autoGeneratedId;
            InsertionDto insDto = insertions.get(i);
            String sql = SqlScriptRunner.prepareSqlInsertionCommand(insertSql, map, i, insDto);
            try {
                autoGeneratedId = SqlScriptRunner.execInsert(conn, sql);
                sqlResults.set(i, true);
            }
            catch (SQLException e2) {
                String msg = "Failed to execute insertion with index " + i + " with SQL: " + sql + ". Error: " + e2.getMessage();
                SimpleLogger.warn((String)msg);
                sqlResults.set(i, false);
                continue;
            }
            if (insDto.id == null) continue;
            if (autoGeneratedId != null) {
                map.put(insDto.id, autoGeneratedId);
                continue;
            }
            InsertionEntryDto entry = insDto.data.stream().filter(e -> e.foreignKeyToPreviouslyGeneratedRow != null).findFirst().orElse(null);
            if (entry == null) continue;
            long previouslyGeneratedValue = (Long)map.get(entry.foreignKeyToPreviouslyGeneratedRow);
            map.put(insDto.id, previouslyGeneratedValue);
        }
        InsertionResultsDto insertionResultsDto = new InsertionResultsDto();
        insertionResultsDto.idMapping = map;
        insertionResultsDto.executionResults = sqlResults;
        return insertionResultsDto;
    }

    private static String prepareSqlInsertionCommand(String insertSql, Map<Long, Long> map, int i, InsertionDto insDto) {
        StringBuilder sql = new StringBuilder(insertSql);
        sql.append(insDto.targetTable).append(" (");
        sql.append(insDto.data.stream().map(e -> e.variableName).collect(Collectors.joining(",")));
        sql.append(" )  VALUES (");
        for (InsertionEntryDto e2 : insDto.data) {
            if (e2.printableValue != null || e2.foreignKeyToPreviouslyGeneratedRow == null || map.containsKey(e2.foreignKeyToPreviouslyGeneratedRow)) continue;
            throw new IllegalArgumentException("Insertion operation at position " + i + " has a foreign key reference to key " + e2.foreignKeyToPreviouslyGeneratedRow + " but that was not processed. Processed primary keys: " + map.keySet().stream().map(Object::toString).collect(Collectors.joining(", ")));
        }
        sql.append(insDto.data.stream().map(e -> e.printableValue != null ? SqlScriptRunner.replaceQuotes(e.printableValue) : ((Long)map.get(e.foreignKeyToPreviouslyGeneratedRow)).toString()).collect(Collectors.joining(",")));
        sql.append(");");
        return sql.toString();
    }

    private static String replaceQuotes(String value) {
        if (value.contains(SINGLE_APOSTROPHE)) {
            String oldValue = value;
            value = value.replaceAll(SINGLE_APOSTROPHE, DOUBLE_APOSTROPHE);
            assert (!oldValue.equals(value));
        }
        if (value.contains(SINGLE_APOSTROPHE_PLACEHOLDER)) {
            value = value.replaceAll(SINGLE_APOSTROPHE_PLACEHOLDER, SINGLE_APOSTROPHE);
        }
        if (value.startsWith(QUOTATION_MARK) && value.endsWith(QUOTATION_MARK)) {
            return SINGLE_APOSTROPHE + value.substring(1, value.length() - 1) + SINGLE_APOSTROPHE;
        }
        return value;
    }

    public static Long execInsert(Connection conn, String command) throws SQLException {
        Long autoGeneratedId;
        SimpleLogger.debug((String)"Executing DB insertion:");
        SimpleLogger.debug((String)command);
        String insert = "INSERT ";
        command = command.trim();
        if (!command.toUpperCase().startsWith(insert)) {
            throw new IllegalArgumentException("SQL command is not an INSERT\n" + command);
        }
        Statement statement = conn.createStatement();
        try {
            statement.executeUpdate(command, 1);
        }
        catch (SQLException e) {
            statement.close();
            String errText = String.format("Error executing '%s': %s", command, e.getMessage());
            throw new SQLException(errText, e);
        }
        ResultSet generatedKeys = statement.getGeneratedKeys();
        ResultSetMetaData generatedKeysMetaData = generatedKeys.getMetaData();
        if (generatedKeys.next()) {
            int columnType = generatedKeysMetaData.getColumnType(1);
            switch (columnType) {
                case -6: 
                case -5: 
                case 4: 
                case 5: {
                    autoGeneratedId = generatedKeys.getLong(1);
                    break;
                }
                default: {
                    autoGeneratedId = null;
                    break;
                }
            }
        } else {
            autoGeneratedId = null;
        }
        statement.close();
        return autoGeneratedId;
    }

    public static void execScript(Connection conn, String script) throws SQLException {
        List<String> commands = SqlScriptRunner.extractSql(script);
        for (String command : commands) {
            SqlScriptRunner.execCommand(conn, command + DEFAULT_DELIMITER);
        }
    }

    public static void execScript(Connection conn, String script, List<String> tablesToInsert) throws SQLException {
        if (tablesToInsert == null || tablesToInsert.isEmpty()) {
            return;
        }
        List<String> commands = SqlScriptRunner.extractSql(script);
        for (String command : commands) {
            if (!SqlScriptRunner.shouldExecuteInsert(command, tablesToInsert)) continue;
            SqlScriptRunner.execCommand(conn, command + DEFAULT_DELIMITER);
        }
    }

    public static List<String> extractSql(String script) {
        String[] commands = script.split(DEFAULT_DELIMITER);
        return Arrays.stream(commands).filter(s -> !s.replaceAll("\r\n", "").replaceAll("\n", "").isEmpty()).map(s -> s + DEFAULT_DELIMITER).collect(Collectors.toList());
    }

    public static Map<String, List<String>> extractSqlTableMap(List<String> commands) {
        HashMap<String, List<String>> tableSqlMap = new HashMap<String, List<String>>();
        for (String command : commands) {
            if (!ParserUtils.isInsert(command)) continue;
            Insert stmt = (Insert)ParserUtils.asStatement(command);
            Table table = stmt.getTable();
            tableSqlMap.putIfAbsent(table.getName(), new ArrayList());
            String end = "";
            if (!command.replaceAll(" ", "").replaceAll("\r", "").replaceAll("\n", "").endsWith(DEFAULT_DELIMITER)) {
                end = DEFAULT_DELIMITER;
            }
            ((List)tableSqlMap.get(table.getName())).add(command + end);
        }
        return tableSqlMap;
    }

    public static QueryResult execCommand(Connection conn, String command) throws SQLException {
        Statement statement = conn.createStatement();
        SimpleLogger.debug((String)"Executing DB command:");
        SimpleLogger.debug((String)command);
        try {
            statement.execute(command);
        }
        catch (SQLException e) {
            statement.close();
            String errText = String.format("Error executing '%s': %s", command, e.getMessage());
            throw new SQLException(errText, e);
        }
        ResultSet result = statement.getResultSet();
        QueryResult queryResult = new QueryResult(result);
        statement.close();
        return queryResult;
    }

    private static boolean shouldExecuteInsert(String command, List<String> tablesToInsert) {
        if (!ParserUtils.isInsert(command)) {
            return true;
        }
        if (tablesToInsert == null || tablesToInsert.isEmpty()) {
            return false;
        }
        Insert stmt = (Insert)ParserUtils.asStatement(command);
        Table table = stmt.getTable();
        return table != null && tablesToInsert.stream().anyMatch(t -> t.equalsIgnoreCase(table.getName()));
    }
}

