/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.scripting.secure.behavior;

import org.apache.commons.lang3.exception.ExceptionUtils;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.delegate.BpmnError;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.bpmn.behavior.ScriptTaskActivityBehavior;
import org.flowable.engine.impl.bpmn.helper.ErrorPropagation;
import org.flowable.scripting.secure.impl.SecureJavascriptUtil;
import org.flowable.variable.api.delegate.VariableScope;

public class SecureJavascriptTaskActivityBehavior
extends ScriptTaskActivityBehavior {
    public SecureJavascriptTaskActivityBehavior(String scriptTaskId, String script, String language, String resultVariable, boolean storeScriptVariables) {
        super(scriptTaskId, script, language, resultVariable, storeScriptVariables);
    }

    public void execute(DelegateExecution execution) {
        boolean noErrors = true;
        try {
            Object result = SecureJavascriptUtil.evaluateScript((VariableScope)execution, this.script);
            if (this.resultVariable != null) {
                execution.setVariable(this.resultVariable, result);
            }
        }
        catch (FlowableException e) {
            noErrors = false;
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause instanceof BpmnError) {
                ErrorPropagation.propagateError((BpmnError)((BpmnError)rootCause), (DelegateExecution)execution);
            }
            throw e;
        }
        if (noErrors) {
            this.leave(execution);
        }
    }
}

