/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.python.embedding.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class GraalPyRunner {
    public static void run(Set<String> classpath, Log log, String ... args) throws IOException, InterruptedException {
        String workdir = System.getProperty("exec.workingdir");
        Path java = Paths.get(System.getProperty("java.home"), "bin", "java");
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(java.toString());
        cmd.add("-classpath");
        cmd.add(String.join((CharSequence)File.pathSeparator, classpath));
        cmd.add("com.oracle.graal.python.shell.GraalPythonMain");
        cmd.addAll(List.of(args));
        ProcessBuilder pb = new ProcessBuilder(cmd);
        if (workdir != null) {
            pb.directory(new File(workdir));
        }
        log.mvnDebug(String.format("Running GraalPy: %s", String.join((CharSequence)" ", cmd)));
        pb.redirectError();
        pb.redirectOutput();
        Process process = pb.start();
        Thread outputReader = new Thread(() -> {
            try (InputStream is = process.getInputStream();
                 BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
                String line;
                while ((line = reader.readLine()) != null) {
                    log.subProcessOut(line);
                }
            }
            catch (IOException e) {
                log.subProcessErr(e);
            }
        });
        outputReader.start();
        Thread errorReader = new Thread(() -> {
            try {
                String line;
                BufferedReader errorBufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                while ((line = errorBufferedReader.readLine()) != null) {
                    log.subProcessErr(line);
                }
            }
            catch (IOException e) {
                log.subProcessErr(e);
            }
        });
        errorReader.start();
        process.waitFor();
        outputReader.join();
        errorReader.join();
        if (process.exitValue() != 0) {
            throw new RuntimeException(String.format("Running command: '%s' ended with code %d.See the error output above.", String.join((CharSequence)" ", pb.command()), process.exitValue()));
        }
    }

    public static interface Log {
        public void subProcessOut(CharSequence var1);

        public void subProcessErr(CharSequence var1);

        public void subProcessOut(Throwable var1);

        public void subProcessErr(Throwable var1);

        public void mvnDebug(CharSequence var1);

        public void mvnDebug(CharSequence var1, Throwable var2);

        public void mvnDebug(Throwable var1);

        public void mvnInfo(CharSequence var1);

        public void mvnInfo(CharSequence var1, Throwable var2);

        public void mvnInfo(Throwable var1);

        public void mvnWarn(CharSequence var1);

        public void mvnWarn(CharSequence var1, Throwable var2);

        public void mvnWarn(Throwable var1);

        public void mvnError(CharSequence var1);

        public void mvnError(CharSequence var1, Throwable var2);

        public void mvnError(Throwable var1);
    }
}

