/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.python.embedding.utils;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystemException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import org.graalvm.polyglot.io.FileSystem;

public final class VirtualFileSystem
implements FileSystem,
AutoCloseable {
    private final String vfsPrefix;
    private final String filesListPath;
    private final TreeMap<String, Entry> vfsEntries = new TreeMap();
    private static Set<String> filesList;
    private static Set<String> dirsList;
    private static Map<String, String> lowercaseToResourceMap;
    private final FileSystem delegate;
    private static final String PLATFORM_SEPARATOR;
    private static final char RESOURCE_SEPARATOR_CHAR = '/';
    private static final String RESOURCE_SEPARATOR;
    private final Path mountPoint;
    private final Path extractDir;
    private final Predicate<Path> extractFilter;
    private static final boolean caseInsensitive;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static VirtualFileSystem create() {
        return VirtualFileSystem.newBuilder().build();
    }

    private VirtualFileSystem(Predicate<Path> extractFilter, String resourcesPrefix, String fileListResource, String windowsMountPoint, String unixMountPoint, HostIO allowHostIO) {
        this.vfsPrefix = resourcesPrefix;
        this.filesListPath = fileListResource;
        String mp = System.getenv("GRAALPY_VFS_MOUNT_POINT");
        if (mp == null) {
            mp = VirtualFileSystem.isWindows() ? windowsMountPoint : unixMountPoint;
        }
        this.mountPoint = Path.of(mp, new String[0]);
        if (mp.endsWith(PLATFORM_SEPARATOR) || !this.mountPoint.isAbsolute()) {
            throw new IllegalArgumentException("GRAALPY_VFS_MOUNT_POINT must be set to an absolute path without a trailing separator");
        }
        this.extractFilter = extractFilter;
        if (extractFilter != null) {
            try {
                this.extractDir = Files.createTempDirectory("vfsx", new FileAttribute[0]);
                Runtime.getRuntime().addShutdownHook(new DeleteTempDir(this.extractDir));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        } else {
            this.extractDir = null;
        }
        this.delegate = switch (allowHostIO.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> null;
            case 1 -> FileSystem.newReadOnlyFileSystem((FileSystem)FileSystem.newDefaultFileSystem());
            case 2 -> FileSystem.newDefaultFileSystem();
        };
    }

    @Override
    public void close() {
        DeleteTempDir.run(this.extractDir);
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("windows");
    }

    public String resourcePathToPlatformPath(String inputPath) {
        assert (inputPath.startsWith(this.vfsPrefix));
        String path = inputPath.substring(this.vfsPrefix.length() + 1);
        if (!PLATFORM_SEPARATOR.equals(RESOURCE_SEPARATOR)) {
            path = path.replace(RESOURCE_SEPARATOR, PLATFORM_SEPARATOR);
        }
        return this.mountPoint.resolve(path).toString();
    }

    private String platformPathToResourcePath(String inputPath) throws IOException {
        String mountPointString = this.mountPoint.toString();
        Object path = inputPath;
        assert (((String)path).startsWith(mountPointString));
        if (((String)path).startsWith(mountPointString)) {
            path = ((String)path).substring(mountPointString.length());
        }
        if (!PLATFORM_SEPARATOR.equals(RESOURCE_SEPARATOR)) {
            path = ((String)path).replace(PLATFORM_SEPARATOR, RESOURCE_SEPARATOR);
        }
        if (((String)path).endsWith(RESOURCE_SEPARATOR)) {
            path = ((String)path).substring(0, ((String)path).length() - RESOURCE_SEPARATOR.length());
        }
        path = this.vfsPrefix + (String)path;
        if (caseInsensitive) {
            path = this.getLowercaseToResourceMap().get(path);
        }
        return path;
    }

    private Set<String> getFilesList() throws IOException {
        if (filesList == null) {
            this.initFilesAndDirsList();
        }
        return filesList;
    }

    private Set<String> getDirsList() throws IOException {
        if (dirsList == null) {
            this.initFilesAndDirsList();
        }
        return dirsList;
    }

    private Map<String, String> getLowercaseToResourceMap() throws IOException {
        assert (caseInsensitive);
        if (lowercaseToResourceMap == null) {
            this.initFilesAndDirsList();
        }
        return lowercaseToResourceMap;
    }

    private void initFilesAndDirsList() throws IOException {
        filesList = new HashSet<String>();
        dirsList = new HashSet<String>();
        if (caseInsensitive) {
            lowercaseToResourceMap = new HashMap<String, String>();
        }
        try (InputStream stream = VirtualFileSystem.class.getResourceAsStream(this.filesListPath);){
            String line;
            if (stream == null) {
                return;
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(stream));
            while ((line = br.readLine()) != null) {
                if (line.endsWith(RESOURCE_SEPARATOR)) {
                    line = line.substring(0, line.length() - 1);
                    dirsList.add(line);
                } else {
                    filesList.add(line);
                }
                if (!caseInsensitive) continue;
                lowercaseToResourceMap.put(line.toLowerCase(Locale.ROOT), line);
            }
        }
    }

    private Entry readDirEntry(String parentDir) throws IOException {
        ArrayList<String> l = new ArrayList<String>();
        for (String file : this.getFilesList()) {
            if (!VirtualFileSystem.isParent(parentDir, file)) continue;
            l.add(file);
        }
        for (String file : this.getDirsList()) {
            if (!VirtualFileSystem.isParent(parentDir, file)) continue;
            l.add(file);
        }
        Path[] paths = new Path[l.size()];
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = Paths.get(this.resourcePathToPlatformPath((String)l.get(i)), new String[0]);
        }
        return new Entry(false, paths);
    }

    private static boolean isParent(String parentDir, String file) {
        return file.length() > parentDir.length() && file.startsWith(parentDir) && file.indexOf(47, parentDir.length() + 1) < 0;
    }

    private static Entry readFileEntry(String file) throws IOException {
        return new Entry(true, VirtualFileSystem.readResource(file));
    }

    static byte[] readResource(String path) throws IOException {
        try (InputStream stream = VirtualFileSystem.class.getResourceAsStream(path);){
            int n;
            if (stream == null) {
                byte[] byArray = null;
                return byArray;
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[4096];
            while ((n = stream.readNBytes(data, 0, data.length)) != 0) {
                buffer.write(data, 0, n);
            }
            buffer.flush();
            byte[] byArray = buffer.toByteArray();
            return byArray;
        }
    }

    private Path toAbsolutePathInternal(Path path) {
        if (path.startsWith(this.mountPoint)) {
            return path;
        }
        return this.mountPoint.resolve(path);
    }

    private Entry file(Path inputPath) throws IOException {
        Path path = this.toAbsolutePathInternal(inputPath).normalize();
        String pathString = path.toString();
        String entryKey = caseInsensitive ? pathString.toLowerCase(Locale.ROOT) : pathString;
        Entry e = this.vfsEntries.get(entryKey);
        if (e == null) {
            URL uri;
            URL uRL = uri = (pathString = this.platformPathToResourcePath(pathString)) == null ? null : VirtualFileSystem.class.getResource(pathString);
            if (uri != null) {
                e = this.getDirsList().contains(pathString) ? this.readDirEntry(pathString) : VirtualFileSystem.readFileEntry(pathString);
                this.vfsEntries.put(entryKey, e);
            } else if (this.getDirsList().contains(pathString)) {
                e = this.readDirEntry(pathString);
            }
        }
        return e;
    }

    public String getPrefix() {
        return this.vfsPrefix;
    }

    public String getFileListPath() {
        return this.filesListPath;
    }

    private boolean shouldExtract(Path path) {
        return this.extractFilter != null && this.extractFilter.test(path);
    }

    private Path getExtractedPath(Path path) {
        assert (this.extractDir != null);
        assert (this.shouldExtract(path));
        try {
            Path relPath = path.startsWith(this.mountPoint) ? this.mountPoint.relativize(path) : path;
            Path xPath = this.extractDir.resolve(relPath);
            if (!Files.exists(xPath, new LinkOption[0])) {
                Entry e = this.file(relPath);
                if (e == null) {
                    return path;
                }
                if (e.isFile()) {
                    Path parent = xPath.getParent();
                    assert (parent == null || Files.isDirectory(parent, new LinkOption[0]));
                    if (parent == null) {
                        throw new NullPointerException("Parent is null during extracting path.");
                    }
                    Files.createDirectories(parent, new FileAttribute[0]);
                    Files.write(xPath, (byte[])e.data(), new OpenOption[0]);
                } else {
                    Files.createDirectories(xPath, new FileAttribute[0]);
                }
            }
            return xPath;
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Error while extracting virtual filesystem path '%s' to the disk", path), e);
        }
    }

    public Path parsePath(URI uri) {
        if (uri.getScheme().equals("file")) {
            return Paths.get(uri);
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Path parsePath(String path) {
        return Paths.get(path, new String[0]);
    }

    public void checkAccess(Path path, Set<? extends AccessMode> modes, LinkOption ... linkOptions) throws IOException {
        if (path.normalize().startsWith(this.mountPoint)) {
            if (modes.contains((Object)AccessMode.WRITE)) {
                throw new SecurityException("read-only filesystem");
            }
            if (this.file(path) == null) {
                throw new NoSuchFileException("no such file or directory");
            }
        } else if (this.delegate != null) {
            this.delegate.checkAccess(path, modes, linkOptions);
        } else {
            throw new SecurityException("read-only filesystem");
        }
    }

    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        if (this.delegate == null || dir.normalize().startsWith(this.mountPoint)) {
            throw new SecurityException("read-only filesystem");
        }
        this.delegate.createDirectory(dir, (FileAttribute[])attrs);
    }

    public void delete(Path path) throws IOException {
        if (this.delegate == null || path.normalize().startsWith(this.mountPoint)) {
            throw new SecurityException("read-only filesystem");
        }
        this.delegate.delete(path);
    }

    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        if (this.delegate != null && !path.normalize().startsWith(this.mountPoint)) {
            return this.delegate.newByteChannel(path, options, (FileAttribute[])attrs);
        }
        if (options.isEmpty() || options.size() == 1 && options.contains(StandardOpenOption.READ)) {
            final Entry e = this.file(path);
            if (e == null) {
                throw new FileNotFoundException("No such file or directory");
            }
            if (!e.isFile) {
                throw new FileSystemException(path.toString(), null, "Is a directory");
            }
            return new SeekableByteChannel(){
                long position = 0L;
                byte[] bytes;
                final /* synthetic */ VirtualFileSystem this$0;
                {
                    this.this$0 = this$0;
                    this.bytes = (byte[])e.data;
                }

                @Override
                public int read(ByteBuffer dst) throws IOException {
                    if (this.position > (long)this.bytes.length) {
                        return -1;
                    }
                    if (this.position == (long)this.bytes.length) {
                        return 0;
                    }
                    int length = Math.min(this.bytes.length - (int)this.position, dst.remaining());
                    dst.put(this.bytes, (int)this.position, length);
                    this.position += (long)length;
                    if (dst.hasRemaining()) {
                        ++this.position;
                    }
                    return length;
                }

                @Override
                public int write(ByteBuffer src) throws IOException {
                    throw new IOException("read-only");
                }

                @Override
                public long position() throws IOException {
                    return this.position;
                }

                @Override
                public SeekableByteChannel position(long newPosition) throws IOException {
                    this.position = Math.max(0L, newPosition);
                    return this;
                }

                @Override
                public long size() throws IOException {
                    return this.bytes.length;
                }

                @Override
                public SeekableByteChannel truncate(long size) throws IOException {
                    throw new IOException("read-only");
                }

                @Override
                public boolean isOpen() {
                    return true;
                }

                @Override
                public void close() throws IOException {
                }
            };
        }
        throw new SecurityException("read-only filesystem");
    }

    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        if (this.delegate != null && !dir.normalize().startsWith(this.mountPoint)) {
            return this.delegate.newDirectoryStream(dir, filter);
        }
        final Entry e = this.file(dir);
        if (e == null || e.isFile) {
            throw new NotDirectoryException(dir.toString());
        }
        return new DirectoryStream<Path>(this){
            final /* synthetic */ VirtualFileSystem this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void close() throws IOException {
            }

            @Override
            public Iterator<Path> iterator() {
                return Arrays.asList((Path[])e.data).iterator();
            }
        };
    }

    public Path toAbsolutePath(Path path) {
        Path result = this.shouldExtract(path) ? this.getExtractedPath(path) : path;
        return this.toAbsolutePathInternal(result);
    }

    public Path toRealPath(Path path, LinkOption ... linkOptions) throws IOException {
        Path result = this.shouldExtract(path) ? this.getExtractedPath(path) : path;
        return result.normalize();
    }

    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        if (this.delegate != null && !path.normalize().startsWith(this.mountPoint)) {
            return this.delegate.readAttributes(path, attributes, options);
        }
        Entry e = this.file(path);
        if (e == null) {
            throw new IOException("no such file " + String.valueOf(path));
        }
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        if (attributes.startsWith("unix:") || attributes.startsWith("posix:")) {
            throw new UnsupportedOperationException();
        }
        attrs.put("creationTime", FileTime.fromMillis(0L));
        attrs.put("lastModifiedTime", FileTime.fromMillis(0L));
        attrs.put("lastAccessTime", FileTime.fromMillis(0L));
        attrs.put("isRegularFile", e.isFile);
        attrs.put("isDirectory", !e.isFile);
        attrs.put("isSymbolicLink", false);
        attrs.put("isOther", false);
        attrs.put("size", Long.valueOf(e.isFile ? ((byte[])e.data).length : 0));
        attrs.put("mode", 365);
        attrs.put("dev", 0L);
        attrs.put("nlink", 1);
        attrs.put("uid", 0);
        attrs.put("gid", 0);
        attrs.put("ctime", FileTime.fromMillis(0L));
        return attrs;
    }

    static {
        PLATFORM_SEPARATOR = Paths.get("", new String[0]).getFileSystem().getSeparator();
        RESOURCE_SEPARATOR = String.valueOf('/');
        caseInsensitive = VirtualFileSystem.isWindows();
    }

    public static final class Builder {
        private static final Predicate<Path> DEFAULT_EXTRACT_FILTER = p -> {
            String s = p.toString();
            return s.endsWith(".so") || s.endsWith(".dylib") || s.endsWith(".pyd") || s.endsWith(".dll");
        };
        private String vfsPrefix = "/vfs";
        private String filesListPath = this.vfsPrefix + "/fileslist.txt";
        private String windowsMountPoint = "X:\\graalpy_vfs";
        private String unixMountPoint = "/graalpy_vfs";
        private Predicate<Path> extractFilter = DEFAULT_EXTRACT_FILTER;
        private HostIO allowHostIO = HostIO.READ_WRITE;

        private Builder() {
        }

        public Builder vfsPrefix(String s) {
            this.vfsPrefix = s;
            return this;
        }

        public Builder allowHostIO(HostIO b) {
            this.allowHostIO = b;
            return this;
        }

        public Builder filesListPath(String s) {
            this.filesListPath = s;
            return this;
        }

        public Builder windowsMountPoint(String s) {
            this.windowsMountPoint = s;
            return this;
        }

        public Builder unixMountPoint(String s) {
            this.unixMountPoint = s;
            return this;
        }

        public Builder extractFilter(Predicate<Path> filter) {
            this.extractFilter = this.extractFilter == null ? null : p -> filter.test((Path)p) || DEFAULT_EXTRACT_FILTER.test((Path)p);
            return this;
        }

        public VirtualFileSystem build() {
            return new VirtualFileSystem(this.extractFilter, this.vfsPrefix, this.filesListPath, this.windowsMountPoint, this.unixMountPoint, this.allowHostIO);
        }
    }

    private static final class DeleteTempDir
    extends Thread {
        private final Path extractDir;

        public DeleteTempDir(Path extractDir) {
            this.extractDir = extractDir;
        }

        @Override
        public void run() {
            DeleteTempDir.run(this.extractDir);
        }

        private static void run(Path extractDir) {
            if (extractDir != null) {
                try {
                    Files.walkFileTree(extractDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            Files.delete(file);
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                            Files.delete(dir);
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                catch (IOException e) {
                    System.err.format("Could not delete temp directory '%s': %s", extractDir, e);
                }
            }
        }
    }

    public static enum HostIO {
        NONE,
        READ,
        READ_WRITE;

    }

    private record Entry(boolean isFile, Object data) {
    }
}

