/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.python.embedding.utils;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystemException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.graalvm.polyglot.io.FileSystem;

public final class VirtualFileSystem
implements FileSystem,
AutoCloseable {
    static final String VFS_ROOT = "/org.graalvm.python.vfs";
    static final String VFS_HOME = "home";
    static final String VFS_VENV = "venv";
    static final String VFS_PROJ = "proj";
    static final String VFS_SRC = "src";
    private static final String FILES_LIST_PATH = "/org.graalvm.python.vfs/fileslist.txt";
    private static final String VENV_PREFIX = "/org.graalvm.python.vfs/venv";
    private static final String HOME_PREFIX = "/org.graalvm.python.vfs/home";
    private static final String PROJ_PREFIX = "/org.graalvm.python.vfs/proj";
    private static final String SRC_PREFIX = "/org.graalvm.python.vfs/src";
    private boolean extractOnStartup = "true".equals(System.getProperty("graalpy.vfs.extractOnStartup"));
    private Map<String, BaseEntry> vfsEntries;
    private Class<?> resourceLoadingClass;
    private final FileSystem delegate;
    private static final String PLATFORM_SEPARATOR = Paths.get("", new String[0]).getFileSystem().getSeparator();
    private static final char RESOURCE_SEPARATOR_CHAR = '/';
    private static final String RESOURCE_SEPARATOR = String.valueOf('/');
    private final Path mountPoint;
    private final String mountPointLowerCase;
    private final Path extractDir;
    private final Predicate<Path> extractFilter;
    private final boolean caseInsensitive;
    private final DeleteTempDir deleteTempDir;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static VirtualFileSystem create() {
        return VirtualFileSystem.newBuilder().build();
    }

    VirtualFileSystem(Predicate<Path> extractFilter, String windowsMountPoint, String unixMountPoint, HostIO allowHostIO, Class<?> resourceLoadingClass, boolean caseInsensitive) {
        this.resourceLoadingClass = resourceLoadingClass != null ? resourceLoadingClass : VirtualFileSystem.class;
        this.caseInsensitive = caseInsensitive;
        String mp = System.getenv("GRAALPY_VFS_MOUNT_POINT");
        if (mp == null) {
            mp = VirtualFileSystem.isWindows() ? windowsMountPoint : unixMountPoint;
        }
        this.mountPoint = Path.of(mp, new String[0]);
        this.mountPointLowerCase = mp.toLowerCase(Locale.ROOT);
        if (mp.endsWith(PLATFORM_SEPARATOR) || !this.mountPoint.isAbsolute()) {
            throw new IllegalArgumentException("GRAALPY_VFS_MOUNT_POINT must be set to an absolute path without a trailing separator");
        }
        this.extractFilter = extractFilter;
        if (extractFilter != null) {
            try {
                this.extractDir = Files.createTempDirectory("org.graalvm.python.vfsx", new FileAttribute[0]);
                this.deleteTempDir = new DeleteTempDir(this.extractDir);
                Runtime.getRuntime().addShutdownHook(this.deleteTempDir);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        } else {
            this.extractDir = null;
            this.deleteTempDir = null;
        }
        this.delegate = switch (allowHostIO.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> null;
            case 1 -> FileSystem.newReadOnlyFileSystem((FileSystem)FileSystem.newDefaultFileSystem());
            case 2 -> FileSystem.newDefaultFileSystem();
        };
    }

    @Override
    public void close() {
        if (this.deleteTempDir != null) {
            this.deleteTempDir.removeExtractDir();
        }
    }

    static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("windows");
    }

    String vfsHomePath() {
        return this.resourcePathToPlatformPath(HOME_PREFIX);
    }

    String vfsProjPath() {
        return this.resourcePathToPlatformPath(PROJ_PREFIX);
    }

    String vfsSrcPath() {
        return this.resourcePathToPlatformPath(SRC_PREFIX);
    }

    String vfsVenvPath() {
        return this.resourcePathToPlatformPath(VENV_PREFIX);
    }

    @Deprecated
    public String resourcePathToPlatformPath(String resourcePath) {
        if (resourcePath.length() <= VFS_ROOT.length() || !resourcePath.startsWith(VFS_ROOT)) {
            String msg = "Resource path is expected to start with '/org.graalvm.python.vfs' but was '" + resourcePath + "'.\nPlease also ensure that your virtual file system resources root directory is '/org.graalvm.python.vfs'";
            throw new IllegalArgumentException(msg);
        }
        String path = resourcePath.substring(VFS_ROOT.length() + 1);
        if (!PLATFORM_SEPARATOR.equals(RESOURCE_SEPARATOR)) {
            path = path.replace(RESOURCE_SEPARATOR, PLATFORM_SEPARATOR);
        }
        Object absolute = this.mountPoint.resolve(path).toString();
        if (resourcePath.endsWith(RESOURCE_SEPARATOR) && !((String)absolute).endsWith(PLATFORM_SEPARATOR)) {
            absolute = (String)absolute + PLATFORM_SEPARATOR;
        }
        return absolute;
    }

    private String platformPathToResourcePath(String inputPath) {
        String mountPointString = this.mountPoint.toString();
        Object path = inputPath;
        assert (((String)path).startsWith(mountPointString));
        if (((String)path).startsWith(mountPointString)) {
            path = ((String)path).substring(mountPointString.length());
        }
        if (!PLATFORM_SEPARATOR.equals(RESOURCE_SEPARATOR)) {
            path = ((String)path).replace(PLATFORM_SEPARATOR, RESOURCE_SEPARATOR);
        }
        if (((String)path).endsWith(RESOURCE_SEPARATOR)) {
            path = ((String)path).substring(0, ((String)path).length() - RESOURCE_SEPARATOR.length());
        }
        path = VFS_ROOT + (String)path;
        return path;
    }

    private String toCaseComparable(String file) {
        return this.caseInsensitive ? file.toLowerCase(Locale.ROOT) : file;
    }

    private void initEntries() throws IOException {
        this.vfsEntries = new HashMap<String, BaseEntry>();
        try (InputStream stream = this.resourceLoadingClass.getResourceAsStream(FILES_LIST_PATH);){
            String line;
            if (stream == null) {
                return;
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(stream));
            while ((line = br.readLine()) != null) {
                Path p;
                String platformPath = this.resourcePathToPlatformPath(line);
                int i = 0;
                DirEntry parent = null;
                while ((i = platformPath.indexOf(PLATFORM_SEPARATOR, i)) != -1) {
                    String dir = platformPath.substring(0, i);
                    String dirKey = this.toCaseComparable(dir);
                    DirEntry dirEntry = (DirEntry)this.vfsEntries.get(dirKey);
                    if (dirEntry == null) {
                        dirEntry = new DirEntry(dir);
                        this.vfsEntries.put(dirKey, dirEntry);
                        if (parent != null) {
                            parent.entries.add(dirEntry);
                        }
                    }
                    parent = dirEntry;
                    ++i;
                }
                assert (parent != null);
                if (platformPath.endsWith(PLATFORM_SEPARATOR)) continue;
                FileEntry fileEntry = new FileEntry(platformPath);
                this.vfsEntries.put(this.toCaseComparable(platformPath), fileEntry);
                parent.entries.add(fileEntry);
                if (!this.extractOnStartup || !this.shouldExtract(p = Paths.get(fileEntry.getPlatformPath(), new String[0]))) continue;
                this.getExtractedPath(p);
            }
        }
    }

    byte[] readResource(String path) throws IOException {
        try (InputStream stream = this.resourceLoadingClass.getResourceAsStream(path);){
            int n;
            if (stream == null) {
                byte[] byArray = null;
                return byArray;
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[4096];
            while ((n = stream.readNBytes(data, 0, data.length)) != 0) {
                buffer.write(data, 0, n);
            }
            buffer.flush();
            byte[] byArray = buffer.toByteArray();
            return byArray;
        }
    }

    private Path toAbsolutePathInternal(Path path) {
        if (this.pathIsInVfs(path)) {
            return path;
        }
        return this.mountPoint.resolve(path);
    }

    private BaseEntry getEntry(Path inputPath) throws IOException {
        if (this.vfsEntries == null) {
            this.initEntries();
        }
        Path path = this.toAbsolutePathInternal(inputPath).normalize();
        return this.vfsEntries.get(this.toCaseComparable(path.toString()));
    }

    public String getMountPoint() {
        return this.mountPoint.toString();
    }

    private boolean pathIsInVfs(Path path) {
        return this.toCaseComparable(path.normalize().toString()).startsWith(this.mountPointLowerCase);
    }

    private boolean shouldExtract(Path path) {
        return this.extractFilter != null && this.extractFilter.test(path);
    }

    private Path getExtractedPath(Path path) {
        assert (this.shouldExtract(path));
        return this.extractPath(path, true);
    }

    private Path extractPath(Path path, boolean extractLibsDir) {
        assert (this.extractDir != null);
        try {
            BaseEntry entry = this.getEntry(path);
            Path relPath = this.mountPoint.relativize(Paths.get(entry.getPlatformPath(), new String[0]));
            Path xPath = this.extractDir.resolve(relPath);
            if (!Files.exists(xPath, new LinkOption[0])) {
                if (entry instanceof FileEntry) {
                    Path pkgDir;
                    FileEntry fileEntry = (FileEntry)entry;
                    Path parent = xPath.getParent();
                    assert (parent == null || !Files.exists(parent, new LinkOption[0]) || Files.isDirectory(parent, new LinkOption[0]));
                    if (parent == null) {
                        throw new NullPointerException("Parent is null during extracting path.");
                    }
                    Files.createDirectories(parent, new FileAttribute[0]);
                    Files.write(xPath, fileEntry.getData(), new OpenOption[0]);
                    if (extractLibsDir && (pkgDir = VirtualFileSystem.getPythonPackageDir(path)) != null) {
                        Path libsDir = Paths.get(String.valueOf(pkgDir) + ".libs", new String[0]);
                        this.extract(libsDir);
                    }
                } else if (entry instanceof DirEntry) {
                    Files.createDirectories(xPath, new FileAttribute[0]);
                } else {
                    return path;
                }
            }
            return xPath;
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Error while extracting virtual filesystem path '%s' to the disk", path), e);
        }
    }

    private static Path getPythonPackageDir(Path path) {
        Path prev = null;
        Path p = path;
        while ((p = p.getParent()) != null) {
            Path fileName = p.getFileName();
            if (fileName != null && "site-packages".equals(fileName.toString())) {
                return prev;
            }
            prev = p;
        }
        return null;
    }

    private void extract(Path path) throws IOException {
        BaseEntry entry = this.getEntry(path);
        if (entry instanceof FileEntry) {
            this.extractPath(path, false);
        } else if (entry != null && ((DirEntry)entry).entries != null) {
            for (BaseEntry be : ((DirEntry)entry).entries) {
                this.extract(Path.of(be.getPlatformPath(), new String[0]));
            }
        }
    }

    void extractResources(Path resourcesDirectory) throws IOException {
        String resourcePath;
        InputStream stream = this.resourceLoadingClass.getResourceAsStream(FILES_LIST_PATH);
        if (stream == null) {
            return;
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(stream));
        while ((resourcePath = br.readLine()) != null) {
            Path destFile = resourcesDirectory.resolve(Path.of(resourcePath.substring(VFS_ROOT.length() + 1), new String[0]));
            if (destFile == null) continue;
            if (resourcePath.endsWith(RESOURCE_SEPARATOR)) {
                Files.createDirectories(destFile, new FileAttribute[0]);
                continue;
            }
            Path parent = destFile.getParent();
            if (parent != null) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            Files.write(destFile, this.readResource(resourcePath), new OpenOption[0]);
        }
    }

    public Path parsePath(URI uri) {
        if (uri.getScheme().equals("file")) {
            return Paths.get(uri);
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Path parsePath(String path) {
        return Paths.get(path, new String[0]);
    }

    public void checkAccess(Path path, Set<? extends AccessMode> modes, LinkOption ... linkOptions) throws IOException {
        if (this.pathIsInVfs(path)) {
            if (modes.contains((Object)AccessMode.WRITE)) {
                throw new SecurityException("read-only filesystem");
            }
            if (this.getEntry(path) == null) {
                throw new NoSuchFileException("no such file or directory");
            }
        } else if (this.delegate != null) {
            this.delegate.checkAccess(path, modes, linkOptions);
        } else {
            throw new SecurityException("read-only filesystem");
        }
    }

    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        if (this.delegate == null || this.pathIsInVfs(dir)) {
            throw new SecurityException("read-only filesystem");
        }
        this.delegate.createDirectory(dir, (FileAttribute[])attrs);
    }

    public void delete(Path path) throws IOException {
        if (this.delegate == null || this.pathIsInVfs(path)) {
            throw new SecurityException("read-only filesystem");
        }
        this.delegate.delete(path);
    }

    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        if (this.delegate != null && !this.pathIsInVfs(path)) {
            return this.delegate.newByteChannel(path, options, (FileAttribute[])attrs);
        }
        if (options.isEmpty() || options.size() == 1 && options.contains(StandardOpenOption.READ)) {
            BaseEntry entry = this.getEntry(path);
            if (entry == null) {
                throw new FileNotFoundException("No such file or directory");
            }
            if (!(entry instanceof FileEntry)) {
                throw new FileSystemException(path.toString(), null, "Is a directory");
            }
            final FileEntry fileEntry = (FileEntry)entry;
            return new SeekableByteChannel(){
                long position = 0L;
                final byte[] bytes = fileEntry.getData();
                final /* synthetic */ VirtualFileSystem this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public int read(ByteBuffer dst) throws IOException {
                    if (this.position > (long)this.bytes.length) {
                        return -1;
                    }
                    if (this.position == (long)this.bytes.length) {
                        return 0;
                    }
                    int length = Math.min(this.bytes.length - (int)this.position, dst.remaining());
                    dst.put(this.bytes, (int)this.position, length);
                    this.position += (long)length;
                    if (dst.hasRemaining()) {
                        ++this.position;
                    }
                    return length;
                }

                @Override
                public int write(ByteBuffer src) throws IOException {
                    throw new IOException("read-only");
                }

                @Override
                public long position() throws IOException {
                    return this.position;
                }

                @Override
                public SeekableByteChannel position(long newPosition) throws IOException {
                    this.position = Math.max(0L, newPosition);
                    return this;
                }

                @Override
                public long size() throws IOException {
                    return this.bytes.length;
                }

                @Override
                public SeekableByteChannel truncate(long size) throws IOException {
                    throw new IOException("read-only");
                }

                @Override
                public boolean isOpen() {
                    return true;
                }

                @Override
                public void close() throws IOException {
                }
            };
        }
        throw new SecurityException("read-only filesystem");
    }

    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        if (this.delegate != null && !this.pathIsInVfs(dir)) {
            return this.delegate.newDirectoryStream(dir, filter);
        }
        BaseEntry entry = this.getEntry(dir);
        if (entry instanceof FileEntry) {
            throw new NotDirectoryException(dir.toString());
        }
        if (entry instanceof DirEntry) {
            final DirEntry dirEntry = (DirEntry)entry;
            return new DirectoryStream<Path>(this){
                final /* synthetic */ VirtualFileSystem this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void close() throws IOException {
                }

                @Override
                public Iterator<Path> iterator() {
                    return dirEntry.entries.stream().map(e -> Path.of(e.getPlatformPath(), new String[0])).iterator();
                }
            };
        }
        throw new NoSuchFileException(dir.toString());
    }

    public Path toAbsolutePath(Path path) {
        Path result = this.shouldExtract(path) ? this.getExtractedPath(path) : path;
        return this.toAbsolutePathInternal(result);
    }

    public Path toRealPath(Path path, LinkOption ... linkOptions) throws IOException {
        Path result = this.shouldExtract(path) ? this.getExtractedPath(path) : path;
        return result.normalize();
    }

    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        int n;
        if (this.delegate != null && !this.pathIsInVfs(path)) {
            return this.delegate.readAttributes(path, attributes, options);
        }
        BaseEntry entry = this.getEntry(path);
        if (entry == null) {
            throw new NoSuchFileException("no such file or directory");
        }
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        if (attributes.startsWith("unix:") || attributes.startsWith("posix:")) {
            throw new UnsupportedOperationException();
        }
        attrs.put("creationTime", FileTime.fromMillis(0L));
        attrs.put("lastModifiedTime", FileTime.fromMillis(0L));
        attrs.put("lastAccessTime", FileTime.fromMillis(0L));
        attrs.put("isRegularFile", entry instanceof FileEntry);
        attrs.put("isDirectory", entry instanceof DirEntry);
        attrs.put("isSymbolicLink", false);
        attrs.put("isOther", false);
        if (entry instanceof FileEntry) {
            FileEntry fileEntry = (FileEntry)entry;
            n = fileEntry.getData().length;
        } else {
            n = 0;
        }
        attrs.put("size", Long.valueOf(n));
        attrs.put("mode", 365);
        attrs.put("dev", 0L);
        attrs.put("nlink", 1);
        attrs.put("uid", 0);
        attrs.put("gid", 0);
        attrs.put("ctime", FileTime.fromMillis(0L));
        return attrs;
    }

    public static final class Builder {
        private static final Predicate<Path> DEFAULT_EXTRACT_FILTER = p -> {
            String s = p.toString();
            return s.endsWith(".so") || s.endsWith(".dylib") || s.endsWith(".pyd") || s.endsWith(".dll") || s.endsWith(".ttf");
        };
        private String windowsMountPoint = "X:\\graalpy_vfs";
        private String unixMountPoint = "/graalpy_vfs";
        private Predicate<Path> extractFilter = DEFAULT_EXTRACT_FILTER;
        private HostIO allowHostIO = HostIO.READ_WRITE;
        private boolean caseInsensitive = VirtualFileSystem.isWindows();
        private Class<?> resourceLoadingClass;

        private Builder() {
        }

        public Builder caseInsensitive(boolean value) {
            this.caseInsensitive = value;
            return this;
        }

        public Builder allowHostIO(HostIO b) {
            this.allowHostIO = b;
            return this;
        }

        public Builder windowsMountPoint(String s) {
            this.windowsMountPoint = s;
            return this;
        }

        public Builder unixMountPoint(String s) {
            this.unixMountPoint = s;
            return this;
        }

        public Builder resourceLoadingClass(Class<?> c) {
            this.resourceLoadingClass = c;
            return this;
        }

        public Builder extractFilter(Predicate<Path> filter) {
            this.extractFilter = this.extractFilter == null ? null : p -> filter.test((Path)p) || DEFAULT_EXTRACT_FILTER.test((Path)p);
            return this;
        }

        public VirtualFileSystem build() {
            return new VirtualFileSystem(this.extractFilter, this.windowsMountPoint, this.unixMountPoint, this.allowHostIO, this.resourceLoadingClass, this.caseInsensitive);
        }
    }

    private static final class DeleteTempDir
    extends Thread {
        private final Path extractDir;
        private static final SimpleFileVisitor<Path> deleteVisitor = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        };

        DeleteTempDir(Path extractDir) {
            this.extractDir = extractDir;
        }

        @Override
        public void run() {
            this.removeExtractDir();
        }

        private void removeExtractDir() {
            if (this.extractDir != null && Files.exists(this.extractDir, new LinkOption[0])) {
                try {
                    Files.walkFileTree(this.extractDir, deleteVisitor);
                }
                catch (IOException e) {
                    System.err.format("Could not delete temp directory '%s': %s", this.extractDir, e);
                }
            }
        }
    }

    public static enum HostIO {
        NONE,
        READ,
        READ_WRITE;

    }

    private final class DirEntry
    extends BaseEntry {
        List<BaseEntry> entries;

        DirEntry(String platformPath) {
            super(platformPath);
            this.entries = new ArrayList<BaseEntry>();
        }
    }

    private final class FileEntry
    extends BaseEntry {
        private byte[] data;

        public FileEntry(String path) {
            super(path);
        }

        private byte[] getData() throws IOException {
            if (this.data == null) {
                this.data = VirtualFileSystem.this.readResource(this.getResourcePath());
            }
            return this.data;
        }
    }

    private abstract class BaseEntry {
        private final String platformPath;

        private BaseEntry(String platformPath) {
            this.platformPath = platformPath;
        }

        String getPlatformPath() {
            return this.platformPath;
        }

        String getResourcePath() {
            return VirtualFileSystem.this.platformPathToResourcePath(this.platformPath);
        }
    }
}

