/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.capi;

import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiFunction;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.ArgDescriptor;
import com.oracle.graal.python.builtins.objects.cext.structs.CConstants;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructs;
import com.oracle.graal.python.builtins.objects.type.MethodsFlags;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class CApiCodeGen {
    private static final String START_CAPI_BUILTINS = "{{start CAPI_BUILTINS}}";
    private static final String END_CAPI_BUILTINS = "{{end CAPI_BUILTINS}}";
    private static final String[] ADDITIONAL = new String[]{"PyCFunction_GetClass", "PyDescrObject_GetName", "PyDescrObject_GetType", "PyInterpreterState_GetIDFromThreadState", "PyMethodDescrObject_GetMethod", "PyObject_GetDoc", "PyObject_SetDoc", "PySlice_Start", "PySlice_Step", "PySlice_Stop", "_PyASCIIObject_LENGTH", "_PyASCIIObject_STATE_ASCII", "_PyASCIIObject_STATE_COMPACT", "_PyASCIIObject_STATE_KIND", "_PyASCIIObject_STATE_READY", "_PyASCIIObject_WSTR", "_PyByteArray_Start", "_PyEval_SetCoroutineOriginTrackingDepth", "_PyFrame_SetLineNumber", "_PyMemoryView_GetBuffer", "_PySequence_Fast_ITEMS", "_PySequence_ITEM", "_PyUnicodeObject_DATA", "_PyUnicode_get_wstr_length", "_Py_REFCNT", "_Py_SET_REFCNT", "_Py_SET_SIZE", "_Py_SET_TYPE", "_Py_SIZE", "_Py_TYPE", "_PyTuple_SET_ITEM", "_PyCFunction_GetModule", "_PyCFunction_GetMethodDef", "PyCode_GetName", "PyCode_GetFileName", "_PyList_SET_ITEM", "_PyArray_Resize", "_PyErr_Occurred", "PyFrame_GetLasti", "PyFrame_GetLocals", "PyFrame_GetGlobals", "PyFrame_GetBuiltins"};

    private static Path resolvePath(Path path) {
        Path result = Path.of("graalpython", new String[0]).resolve(path);
        if (result.toFile().exists()) {
            return result;
        }
        result = Path.of("..", new String[0]).resolve(path);
        if (result.toFile().exists()) {
            return result;
        }
        throw new RuntimeException("not found: " + path);
    }

    private static boolean writeGenerated(Path path, List<String> contents) throws IOException {
        Path capi = CApiCodeGen.resolvePath(path);
        List<String> lines = Files.readAllLines(capi);
        int start = -1;
        int end = -1;
        String prefix = "";
        for (int i = 0; i < lines.size(); ++i) {
            if (lines.get(i).contains(START_CAPI_BUILTINS)) {
                assert (start == -1);
                start = i + 1;
                prefix = lines.get(i).substring(0, lines.get(i).indexOf(START_CAPI_BUILTINS));
                continue;
            }
            if (!lines.get(i).contains(END_CAPI_BUILTINS)) continue;
            assert (end == -1);
            end = i;
        }
        assert (start != -1 && end != -1);
        ArrayList<Object> result = new ArrayList<Object>();
        result.addAll(lines.subList(0, start));
        result.add(prefix + "GENERATED CODE - see " + CApiCodeGen.class.getSimpleName());
        result.add(prefix + "This can be re-generated using the 'mx python-capi-forwards' command or");
        result.add(prefix + "by executing the main class " + CApiCodeGen.class.getSimpleName());
        result.add("");
        result.addAll(contents);
        result.addAll(lines.subList(end, lines.size()));
        if (result.equals(lines)) {
            System.out.println("no changes for CAPI_BUILTINS in " + capi);
            return false;
        }
        assert (result.stream().noneMatch(l -> l.contains("\n"))) : "comparison fails with embedded newlines";
        Files.write(capi, result, new OpenOption[0]);
        System.out.println("replacing CAPI_BUILTINS in " + capi);
        return true;
    }

    private static boolean isSimilarType(ArgDescriptor t1, ArgDescriptor t2) {
        return t1.cSignature.equals(t2.cSignature) || t1.cSignature.equals("struct " + t2.cSignature) || ("struct " + t1.cSignature).equals(t2.cSignature);
    }

    private static void compareFunction(String name, ArgDescriptor ret1, ArgDescriptor ret2, ArgDescriptor[] args1, ArgDescriptor[] args2) {
        if (!CApiCodeGen.isSimilarType(ret1, ret2)) {
            System.out.println("duplicate entry for " + name + ", different return " + ret1 + " vs. " + ret2);
        }
        if (args1.length != args2.length) {
            System.out.println("duplicate entry for " + name + ", different arg lengths " + args1.length + " vs. " + args2.length);
        } else {
            for (int i = 0; i < args1.length; ++i) {
                if (CApiCodeGen.isSimilarType(args1[i], args2[i])) continue;
                System.out.println("duplicate entry for " + name + ", different arg " + i + ": " + args1[i] + " vs. " + args2[i]);
            }
        }
    }

    private static String argName(int i) {
        return "" + (char)(97 + i);
    }

    private static Optional<CApiBuiltinDesc> findBuiltin(List<CApiBuiltinDesc> builtins, String name) {
        return builtins.stream().filter(n -> n.name.equals(name)).findFirst();
    }

    private static boolean generateCApiSource(List<CApiBuiltinDesc> javaBuiltins) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        for (CApiBuiltinDesc entry : javaBuiltins) {
            int i;
            String name = entry.name;
            CApiBuiltinDesc cApiBuiltinDesc = entry;
            if (cApiBuiltinDesc.call != PythonCextBuiltins.CApiCallPath.Direct && cApiBuiltinDesc.call != PythonCextBuiltins.CApiCallPath.NotImplemented) continue;
            lines.add("#undef " + name);
            Object line = "PyAPI_FUNC(" + cApiBuiltinDesc.returnType.cSignature + ") " + name + "(";
            for (i = 0; i < cApiBuiltinDesc.arguments.length; ++i) {
                line = (String)line + (i == 0 ? "" : ", ") + CApiBuiltinDesc.getArgSignatureWithName(cApiBuiltinDesc.arguments[i], i);
            }
            line = (String)line + ") {";
            lines.add((String)line);
            if (cApiBuiltinDesc.call == PythonCextBuiltins.CApiCallPath.Direct) {
                line = "    " + (cApiBuiltinDesc.returnType == ArgDescriptor.Void ? "" : "return ") + "Graal" + name + "(";
                for (i = 0; i < cApiBuiltinDesc.arguments.length; ++i) {
                    line = (String)line + (i == 0 ? "" : ", ");
                    line = (String)line + CApiCodeGen.argName(i);
                }
                line = (String)line + ");";
            } else {
                line = "    FUNC_NOT_IMPLEMENTED";
            }
            lines.add((String)line);
            lines.add("}");
        }
        lines.add("PyAPI_FUNC(int64_t*) PyTruffle_constants() {");
        lines.add("    static int64_t constants[] = {");
        for (CConstants cConstants : CConstants.VALUES) {
            lines.add("        (int64_t) " + cConstants.name() + ",");
        }
        lines.add("        0xdead1111 // marker value");
        lines.add("    };");
        lines.add("    return constants;");
        lines.add("}");
        lines.add("PyAPI_FUNC(Py_ssize_t*) PyTruffle_struct_offsets() {");
        lines.add("    static Py_ssize_t offsets[] = {");
        for (Enum enum_ : CFields.VALUES) {
            int delim = enum_.name().indexOf("__");
            assert (delim != -1);
            String struct = enum_.name().substring(0, delim);
            String name = enum_.name().substring(delim + 2);
            name = name.replace("__", ".");
            lines.add("        offsetof(" + struct + ", " + name + "),");
        }
        lines.add("        0xdead2222 // marker value");
        lines.add("    };");
        lines.add("    return offsets;");
        lines.add("}");
        lines.add("PyAPI_FUNC(Py_ssize_t*) PyTruffle_struct_sizes() {");
        lines.add("    static Py_ssize_t sizes[] = {");
        for (Enum enum_ : CStructs.VALUES) {
            lines.add("        sizeof(" + enum_.name().replace("__", " ") + "),");
        }
        lines.add("        0xdead3333 // marker value");
        lines.add("    };");
        lines.add("    return sizes;");
        lines.add("}");
        return CApiCodeGen.writeGenerated(Path.of("com.oracle.graal.python.cext", "src", "capi.c"), lines);
    }

    private static boolean generateCApiHeader(List<CApiBuiltinDesc> javaBuiltins) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("#define CAPI_BUILTINS \\");
        int id = 0;
        for (CApiBuiltinDesc entry : javaBuiltins) {
            assert (id++ == entry.id);
            String line = "    BUILTIN(" + entry.name + ", " + entry.returnType.cSignature;
            for (ArgDescriptor arg : entry.arguments) {
                line = line + ", " + arg.cSignature;
            }
            line = line + ") \\";
            lines.add(line);
        }
        lines.add("");
        for (CApiBuiltinDesc entry : javaBuiltins) {
            String field;
            StringBuilder macro;
            String type;
            String name = entry.name;
            if (name.endsWith("_dummy")) continue;
            if (name.startsWith("Py_get_")) {
                assert (entry.arguments.length == 1) : name;
                type = entry.arguments[0].name().replace("Wrapper", "");
                macro = new StringBuilder();
                assert (name.charAt(7 + type.length()) == '_') : name;
                field = name.substring(7 + type.length() + 1);
                macro.append("#define " + name.substring(7) + "(OBJ) ( points_to_py_handle_space(OBJ) ? Graal" + name + "((" + type + "*) (OBJ)) : ((" + type + "*) (OBJ))->" + field + " )");
                lines.add(macro.toString());
                continue;
            }
            if (!name.startsWith("Py_set_")) continue;
            assert (entry.arguments.length == 2) : name;
            type = entry.arguments[0].name().replace("Wrapper", "");
            macro = new StringBuilder();
            assert (name.charAt(7 + type.length()) == '_') : name;
            field = name.substring(7 + type.length() + 1);
            macro.append("#define set_" + name.substring(7) + "(OBJ, VALUE) { if (points_to_py_handle_space(OBJ)) Graal" + name + "((" + type + "*) (OBJ), (VALUE)); else  ((" + type + "*) (OBJ))->" + field + " = (VALUE); }");
            lines.add(macro.toString());
        }
        lines.add("");
        lines.addAll(MethodsFlags.CAPI_METHODS_FLAGS_DEFINES);
        return CApiCodeGen.writeGenerated(Path.of("com.oracle.graal.python.cext", "src", "capi.h"), lines);
    }

    private static boolean generateBuiltinRegistry(List<CApiBuiltinDesc> javaBuiltins) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("    // @formatter:off");
        lines.add("    // Checkstyle: stop");
        for (CApiBuiltinDesc builtin : javaBuiltins) {
            String argString = Arrays.stream(builtin.arguments).map(b -> "ArgDescriptor." + b).collect(Collectors.joining(", "));
            lines.add("    public static final CApiBuiltinExecutable " + builtin.name + " = new CApiBuiltinExecutable(\"" + builtin.name + "\", CApiCallPath." + builtin.call + ", ArgDescriptor." + builtin.returnType + ", new ArgDescriptor[]{" + argString + "}, " + builtin.id + ");");
        }
        lines.add("");
        lines.add("    public static final CApiBuiltinExecutable[] builtins = {");
        for (CApiBuiltinDesc builtin : javaBuiltins) {
            lines.add("                    " + builtin.name + ",");
        }
        lines.add("    };");
        lines.add("");
        lines.add("    static CApiBuiltinNode createBuiltinNode(int id) {");
        lines.add("        switch (id) {");
        for (CApiBuiltinDesc builtin : javaBuiltins) {
            lines.add("            case " + builtin.id + ":");
            lines.add("                return " + builtin.factory + ".create();");
        }
        lines.add("        }");
        lines.add("        return null;");
        lines.add("    }");
        lines.add("");
        lines.add("    // @formatter:on");
        return CApiCodeGen.writeGenerated(Path.of("com.oracle.graal.python", "src", "com", "oracle", "graal", "python", "builtins", "modules", "cext", "PythonCextBuiltinRegistry.java"), lines);
    }

    private static void checkUnimplementedAPI(Path path, List<CApiBuiltinDesc> additionalBuiltins) {
        List<String> lines;
        try {
            lines = Files.readAllLines(path);
        }
        catch (IOException e) {
            System.out.println("    Error while reading " + path + ": " + e.getMessage());
            return;
        }
        boolean msg = false;
        for (CApiBuiltinDesc builtin : additionalBuiltins) {
            if (builtin.call != PythonCextBuiltins.CApiCallPath.NotImplemented) continue;
            for (int i = 0; i < lines.size(); ++i) {
                String line = lines.get(i);
                int offset = line.indexOf(builtin.name);
                if (offset > 0 && Character.isUnicodeIdentifierPart(line.charAt(offset - 1)) || offset + builtin.name.length() < line.length() && Character.isUnicodeIdentifierPart(line.charAt(offset + builtin.name.length())) || !line.contains(builtin.name)) continue;
                if (!msg) {
                    msg = true;
                    System.out.println("Checking " + path);
                }
                System.out.println("    " + builtin.name + " used in " + path + " line " + (i + 1) + ": " + line);
            }
        }
    }

    public static void main(String[] args) throws IOException {
        List<CApiBuiltinDesc> javaBuiltins = CApiFunction.getJavaBuiltinDefinitions();
        List<CApiBuiltinDesc> additionalBuiltins = CApiFunction.getOtherBuiltinDefinitions();
        if (args.length == 2 && "check".equals(args[0])) {
            System.out.println("Checking usages of unimplemented API:");
            String path = args[1];
            try (Stream<Path> stream = Files.walk(Paths.get(path, new String[0]), new FileVisitOption[0]);){
                stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(p -> CApiCodeGen.checkUnimplementedAPI(p, additionalBuiltins));
            }
            return;
        }
        ArrayList<CApiBuiltinDesc> allBuiltins = new ArrayList<CApiBuiltinDesc>();
        allBuiltins.addAll(additionalBuiltins);
        for (CApiBuiltinDesc entry : javaBuiltins) {
            Optional<CApiBuiltinDesc> existing1 = CApiCodeGen.findBuiltin(allBuiltins, entry.name);
            if (existing1.isPresent()) {
                CApiCodeGen.compareFunction(entry.name, entry.returnType, existing1.get().returnType, entry.arguments, existing1.get().arguments);
                continue;
            }
            allBuiltins.add(entry);
        }
        Collections.sort(allBuiltins, (a, b) -> a.name.compareTo(b.name));
        boolean changed = false;
        changed |= CApiCodeGen.generateCApiSource(allBuiltins);
        changed |= CApiCodeGen.generateCApiHeader(javaBuiltins);
        changed |= CApiCodeGen.generateBuiltinRegistry(javaBuiltins);
        if (changed |= CApiCodeGen.checkImports(allBuiltins)) {
            System.exit(-1);
        }
    }

    public static boolean assertBuiltins(Object capiLibrary) {
        ArrayList<CApiBuiltinDesc> builtins = new ArrayList<CApiBuiltinDesc>();
        builtins.addAll(CApiFunction.getOtherBuiltinDefinitions());
        builtins.addAll(CApiFunction.getJavaBuiltinDefinitions());
        TreeSet<CallSite> messages = new TreeSet<CallSite>();
        for (CApiBuiltinDesc function : builtins) {
            boolean hasMember = InteropLibrary.getUncached().isMemberReadable(capiLibrary, function.name);
            if (hasMember) {
                try {
                    InteropLibrary.getUncached().readMember(capiLibrary, function.name);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
                catch (UnknownIdentifierException e) {
                    hasMember = false;
                }
            }
            if (hasMember) {
                if (function.call == PythonCextBuiltins.CApiCallPath.CImpl || function.call == PythonCextBuiltins.CApiCallPath.Direct || function.call == PythonCextBuiltins.CApiCallPath.NotImplemented) continue;
                messages.add((CallSite)((Object)("unexpected C impl: " + function.name)));
                continue;
            }
            if (function.call == PythonCextBuiltins.CApiCallPath.Ignored) continue;
            messages.add((CallSite)((Object)("missing implementation: " + function.name)));
        }
        messages.forEach(System.out::println);
        return messages.isEmpty();
    }

    private static boolean checkImports(List<CApiBuiltinDesc> builtins) throws IOException {
        boolean result = false;
        List<String> lines = Files.readAllLines(CApiCodeGen.resolvePath(Path.of("com.oracle.graal.python.cext", "CAPIFunctions.txt")));
        TreeSet<CallSite> newBuiltins = new TreeSet<CallSite>();
        TreeSet<String> names = new TreeSet<String>();
        builtins.forEach(n -> names.add(n.name));
        for (String line : lines) {
            String[] s = line.split(";");
            String name = s[0].trim();
            names.remove(name);
            ArgDescriptor ret = ArgDescriptor.resolve(s[1].trim());
            String[] argSplit = s[2].isBlank() || "void".equals(s[2]) ? new String[]{} : s[2].trim().split("\\|");
            ArgDescriptor[] args = (ArgDescriptor[])Arrays.stream(argSplit).map(ArgDescriptor::resolve).toArray(ArgDescriptor[]::new);
            Optional<CApiBuiltinDesc> existing = CApiCodeGen.findBuiltin(builtins, name);
            if (existing.isPresent()) {
                CApiCodeGen.compareFunction(name, existing.get().returnType, ret, existing.get().arguments, args);
                continue;
            }
            String argString = Arrays.stream(args).map(t -> String.valueOf(t)).collect(Collectors.joining(", "));
            newBuiltins.add((CallSite)((Object)("    @CApiBuiltin(name = \"" + name + "\", ret = " + ret + ", args = {" + argString + "}, call = NotImplemented)")));
        }
        if (!newBuiltins.isEmpty()) {
            System.out.println("missing builtins (defined in CPython, but not in GraalPy):");
            newBuiltins.stream().forEach(System.out::println);
            result = true;
        }
        names.removeIf(n -> n.startsWith("Py_get_"));
        names.removeIf(n -> n.startsWith("Py_set_"));
        names.removeIf(n -> n.startsWith("PyTruffle"));
        names.removeIf(n -> n.startsWith("_PyTruffle"));
        names.removeAll(Arrays.asList(ADDITIONAL));
        if (!names.isEmpty()) {
            System.out.println("extra builtins (defined in GraalPy, but not in CPython - some of these are necessary for internal modules like 'math'):");
            System.out.println("    " + names.stream().collect(Collectors.joining(", ")));
            result = true;
        }
        return result;
    }

    public static final class CApiBuiltinDesc {
        public final String name;
        public final boolean inlined;
        public final ArgDescriptor[] arguments;
        public final ArgDescriptor returnType;
        public final PythonCextBuiltins.CApiCallPath call;
        public final String factory;
        public int id;

        public CApiBuiltinDesc(String name, boolean inlined, ArgDescriptor returnType, ArgDescriptor[] arguments, PythonCextBuiltins.CApiCallPath call, String factory) {
            this.name = name;
            this.inlined = inlined;
            this.returnType = returnType;
            this.arguments = arguments;
            this.call = call;
            this.factory = factory;
        }

        public static String getArgSignatureWithName(ArgDescriptor arg, int i) {
            if (arg == ArgDescriptor.VARARGS) {
                return arg.cSignature;
            }
            String sig = arg.getCSignature();
            if (sig.contains("(*)")) {
                return sig.replace("(*)", "(*" + CApiCodeGen.argName(i) + ")");
            }
            if (sig.endsWith("[]")) {
                return sig.substring(0, sig.length() - 2) + CApiCodeGen.argName(i) + "[]";
            }
            return arg.getCSignature() + " " + CApiCodeGen.argName(i);
        }
    }
}

