/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.common;

import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.nfi.api.SignatureLibrary;

public interface NativeCExtSymbol {
    public String getName();

    public TruffleString getTsName();

    public String getSignature();

    @CompilerDirectives.TruffleBoundary
    public static Object ensureExecutable(Object callable, NativeCExtSymbol sig) {
        InteropLibrary lib = InteropLibrary.getUncached();
        if (!lib.isExecutable(callable)) {
            Object funPtr;
            TruffleLanguage.Env env = PythonContext.get(null).getEnv();
            boolean panama = (Boolean)PythonOptions.UsePanama.getValue(env.getOptions());
            if (!1.$assertionsDisabled && (sig.getSignature() == null || sig.getSignature().isEmpty())) {
                throw new AssertionError();
            }
            Object nfiSignature = env.parseInternal(Source.newBuilder((String)"nfi", (CharSequence)((panama ? "with panama " : "") + sig.getSignature()), (String)sig.getName()).build(), new String[0]).call(new Object[0]);
            if (lib.isPointer(callable)) {
                try {
                    funPtr = new CApiTransitions.PointerContainer(lib.asPointer(callable));
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
            } else {
                funPtr = callable;
            }
            return SignatureLibrary.getUncached().bind(nfiSignature, funPtr);
        }
        return callable;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

