/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.generator;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.generator.CoroutineBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.generator.GeneratorBuiltins;
import com.oracle.graal.python.builtins.objects.generator.PGenerator;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PCoroutine})
public final class CoroutineBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return CoroutineBuiltinsFactory.getFactories();
    }

    @Builtin(name="__await__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class AwaitNode
    extends PythonUnaryBuiltinNode {
        AwaitNode() {
        }

        @Specialization
        Object await(PGenerator self) {
            return this.factory().createCoroutineWrapper(self);
        }
    }

    @Builtin(name="cr_running", isGetter=true, minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class IsRunning
    extends PythonUnaryBuiltinNode {
        @Specialization
        public boolean isRunning(PGenerator self) {
            return self.isRunning();
        }
    }

    @Builtin(name="cr_frame", isGetter=true, minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class GetFrame
    extends PythonUnaryBuiltinNode {
        @Specialization
        public Object getFrame(VirtualFrame frame, PGenerator self, @Cached GeneratorBuiltins.GetFrameNode getFrame) {
            return getFrame.execute(frame, self);
        }
    }

    @Builtin(name="cr_await", isGetter=true, minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class GetAwait
    extends PythonUnaryBuiltinNode {
        @Specialization
        public Object getAwait(PGenerator self) {
            Object yieldFrom = self.getYieldFrom();
            return yieldFrom != null ? yieldFrom : PNone.NONE;
        }
    }

    @Builtin(name="cr_code", isGetter=true, minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class GetCode
    extends PythonUnaryBuiltinNode {
        @Specialization
        public Object getCode(PGenerator self, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile hasCodeProfile) {
            return self.getOrCreateCode(inliningTarget, hasCodeProfile, this.factory());
        }
    }
}

