/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.getsetdescriptor;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.io.IONodes;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.getsetdescriptor.DescriptorBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.getsetdescriptor.DescriptorDeleteMarker;
import com.oracle.graal.python.builtins.objects.getsetdescriptor.GetSetDescriptor;
import com.oracle.graal.python.builtins.objects.getsetdescriptor.HiddenKeyDescriptor;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.attributes.GetAttributeNode;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToObjectNode;
import com.oracle.graal.python.nodes.call.special.CallBinaryMethodNode;
import com.oracle.graal.python.nodes.call.special.CallUnaryMethodNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.GetSetDescriptor, PythonBuiltinClassType.MemberDescriptor})
public final class DescriptorBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return DescriptorBuiltinsFactory.getFactories();
    }

    private static abstract class AbstractDescrNode
    extends Node {
        @Node.Child
        private TypeNodes.GetNameNode getNameNode;
        @Node.Child
        private PRaiseNode raiseNode;

        private AbstractDescrNode() {
        }

        protected Object getTypeName(Object descrType) {
            if (this.getNameNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getNameNode = (TypeNodes.GetNameNode)this.insert(TypeNodes.GetNameNode.create());
            }
            return this.getNameNode.executeCached(descrType);
        }

        protected PRaiseNode getRaiseNode() {
            if (this.raiseNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.raiseNode = (PRaiseNode)this.insert(PRaiseNode.create());
            }
            return this.raiseNode;
        }
    }

    public static abstract class DescrDeleteNode
    extends AbstractDescrNode {
        public abstract Object execute(VirtualFrame var1, Object var2, Object var3);

        @Specialization
        Object doGetSetDescriptor(VirtualFrame frame, GetSetDescriptor descr, Object obj, @Bind(value="this") Node inliningTarget, @Cached CallBinaryMethodNode callNode, @Cached InlinedBranchProfile branchProfile) {
            if (descr.allowsDelete()) {
                return callNode.executeObject((Frame)frame, descr.getSet(), obj, DescriptorDeleteMarker.INSTANCE);
            }
            branchProfile.enter(inliningTarget);
            if (descr.getSet() != null) {
                if (descr.getName().equalsUncached((AbstractTruffleString)IONodes.T__CHUNK_SIZE, PythonUtils.TS_ENCODING)) {
                    throw this.getRaiseNode().raise(PythonErrorType.AttributeError, ErrorMessages.CANNOT_DELETE);
                }
                throw this.getRaiseNode().raise(PythonErrorType.TypeError, ErrorMessages.CANNOT_DELETE_ATTRIBUTE, this.getTypeName(descr.getType()), descr.getName());
            }
            throw this.getRaiseNode().raise(PythonErrorType.AttributeError, ErrorMessages.ATTRIBUTE_S_OF_P_OBJECTS_IS_NOT_WRITABLE, descr.getName(), obj);
        }

        @Specialization
        Object doHiddenKeyDescriptor(HiddenKeyDescriptor descr, Object obj, @Bind(value="this") Node inliningTarget, @Cached WriteAttributeToObjectNode writeNode, @Cached ReadAttributeFromObjectNode readNode, @Cached InlinedConditionProfile profile) {
            if (profile.profile(inliningTarget, readNode.execute(obj, descr.getKey()) != PNone.NO_VALUE)) {
                writeNode.execute(obj, descr.getKey(), (Object)PNone.NO_VALUE);
                return PNone.NONE;
            }
            throw this.getRaiseNode().raise(PythonBuiltinClassType.AttributeError, ErrorMessages.S, descr.getKey().getName());
        }
    }

    public static abstract class DescrSetNode
    extends AbstractDescrNode {
        public abstract Object execute(VirtualFrame var1, Object var2, Object var3, Object var4);

        @Specialization
        Object doGetSetDescriptor(VirtualFrame frame, GetSetDescriptor descr, Object obj, Object value, @Cached CallBinaryMethodNode callNode) {
            if (descr.getSet() != null) {
                return callNode.executeObject((Frame)frame, descr.getSet(), obj, value);
            }
            throw this.getRaiseNode().raise(PythonErrorType.AttributeError, ErrorMessages.ATTR_S_OF_S_OBJ_IS_NOT_WRITABLE, descr.getName(), this.getTypeName(descr.getType()));
        }

        @Specialization
        static Object doHiddenKeyDescriptor(HiddenKeyDescriptor descr, Object obj, Object value, @Cached WriteAttributeToObjectNode writeNode) {
            return writeNode.execute(obj, descr.getKey(), value);
        }
    }

    public static abstract class DescrGetNode
    extends AbstractDescrNode {
        public abstract Object execute(VirtualFrame var1, Object var2, Object var3);

        @Specialization
        Object doGetSetDescriptor(VirtualFrame frame, GetSetDescriptor descr, Object obj, @Cached CallUnaryMethodNode callNode) {
            if (descr.getGet() != null) {
                return callNode.executeObject((Frame)frame, descr.getGet(), obj);
            }
            throw this.getRaiseNode().raise(PythonErrorType.AttributeError, ErrorMessages.ATTR_S_OF_S_IS_NOT_READABLE, descr.getName(), this.getTypeName(descr.getType()));
        }

        @Specialization
        Object doHiddenKeyDescriptor(HiddenKeyDescriptor descr, Object obj, @Cached ReadAttributeFromObjectNode readNode) {
            Object val = readNode.execute(obj, descr.getKey());
            if (val != PNone.NO_VALUE) {
                return val;
            }
            throw this.getRaiseNode().raise(PythonErrorType.AttributeError, ErrorMessages.OBJ_N_HAS_NO_ATTR_S, descr.getType(), descr.getKey().getName());
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class DescriptorCheckNode
    extends Node {
        DescriptorCheckNode() {
        }

        public void execute(Node inliningTarget, Object descrType, TruffleString name, Object obj) {
            this.executeInternal(inliningTarget, descrType, name, obj);
        }

        public void execute(Node inliningTarget, Object descrType, HiddenKey name, Object obj) {
            this.executeInternal(inliningTarget, descrType, name, obj);
        }

        abstract void executeInternal(Node var1, Object var2, Object var3, Object var4);

        @Specialization
        static void check(Node inliningTarget, Object descrType, Object name, Object obj, @Cached GetClassNode getClassNode, @Cached(inline=false) IsSubtypeNode isSubtypeNode, @Cached(inline=false) PRaiseNode raiseNode) {
            Object type = getClassNode.execute(inliningTarget, obj);
            if (!isSubtypeNode.execute(type, descrType)) {
                throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.DESC_S_FOR_N_DOESNT_APPLY_TO_N, name, descrType, type);
            }
        }
    }

    @Builtin(name="__name__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class NameNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static TruffleString doGetSetDescriptor(GetSetDescriptor self) {
            return self.getName();
        }

        @Specialization
        static TruffleString doHiddenKeyDescriptor(HiddenKeyDescriptor self, @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            return fromJavaStringNode.execute(self.getKey().getName(), PythonUtils.TS_ENCODING);
        }
    }

    @Builtin(name="__qualname__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class QualnameNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static TruffleString doGetSetDescriptor(VirtualFrame frame, GetSetDescriptor self, @Cached.Shared @Cached(value="create(T___QUALNAME__)") GetAttributeNode.GetFixedAttributeNode readQualNameNode, @Cached.Shared(value="formatter") @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            return simpleTruffleStringFormatNode.format("%s.%s", QualnameNode.toStr(readQualNameNode.executeObject(frame, self.getType())), self.getName());
        }

        @Specialization
        static TruffleString doHiddenKeyDescriptor(VirtualFrame frame, HiddenKeyDescriptor self, @Cached.Shared @Cached(value="create(T___QUALNAME__)") GetAttributeNode.GetFixedAttributeNode readQualNameNode, @Cached.Shared(value="formatter") @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            return simpleTruffleStringFormatNode.format("%s.%s", QualnameNode.toStr(readQualNameNode.executeObject(frame, self.getType())), self.getKey().getName());
        }

        @CompilerDirectives.TruffleBoundary
        private static String toStr(Object o) {
            return o.toString();
        }
    }
}

