// CheckStyle: start generated
package com.oracle.graal.python.builtins.objects.cext.capi;

import com.oracle.graal.python.builtins.objects.cext.capi.ManagedMethodWrappers.MethodWrapper;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.nfi.api.SignatureLibrary;
import java.lang.invoke.VarHandle;
import java.util.Objects;

@GeneratedBy(MethodWrapper.class)
@SuppressWarnings("javadoc")
public final class MethodWrapperGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<SignatureLibrary> SIGNATURE_LIBRARY_ = LibraryFactory.resolve(SignatureLibrary.class);

    static  {
        LibraryExport.register(MethodWrapper.class, new InteropLibraryExports());
    }

    private MethodWrapperGen() {
    }

    @GeneratedBy(MethodWrapper.class)
    public static class InteropLibraryExports extends LibraryExport<InteropLibrary> {

        private InteropLibraryExports() {
            super(InteropLibrary.class, MethodWrapper.class, false, false, 0);
        }

        @Override
        protected InteropLibrary createUncached(Object receiver) {
            assert receiver instanceof MethodWrapper;
            InteropLibrary uncached = new Uncached(receiver);
            return uncached;
        }

        @Override
        protected InteropLibrary createCached(Object receiver) {
            assert receiver instanceof MethodWrapper;
            return new Cached(receiver);
        }

        @GeneratedBy(MethodWrapper.class)
        public static class Cached extends InteropLibrary {

            private final Class<? extends MethodWrapper> receiverClass_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link MethodWrapper#toNative(MethodWrapper, SignatureLibrary)}
             * </pre> */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link MethodWrapper#toNative(MethodWrapper, SignatureLibrary)}
             *   Parameter: {@link SignatureLibrary} signatureLibrary</pre> */
            @Child private SignatureLibrary signatureLibrary_;

            protected Cached(Object receiver) {
                MethodWrapper castReceiver = ((MethodWrapper) receiver) ;
                this.receiverClass_ = castReceiver.getClass();
            }

            @Override
            public boolean accepts(Object receiver) {
                assert receiver.getClass() != this.receiverClass_ || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact(receiver, this.receiverClass_);
            }

            @Override
            public boolean isPointer(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (CompilerDirectives.castExact(receiver, receiverClass_)).isPointer();
            }

            @Override
            public long asPointer(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (CompilerDirectives.castExact(receiver, receiverClass_)).asPointer();
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link MethodWrapper#toNative(MethodWrapper, SignatureLibrary)}
             *     Activation probability: 1.00000
             *     With/without class size: 24/4 bytes
             * </pre> */
            @Override
            public void toNative(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                MethodWrapper arg0Value = CompilerDirectives.castExact(arg0Value_, receiverClass_);
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[MethodWrapper.toNative(MethodWrapper, SignatureLibrary)] */) {
                    {
                        SignatureLibrary signatureLibrary__ = this.signatureLibrary_;
                        if (signatureLibrary__ != null) {
                            arg0Value.toNative(signatureLibrary__);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                executeAndSpecialize(arg0Value);
                return;
            }

            private void executeAndSpecialize(MethodWrapper arg0Value) {
                int state_0 = this.state_0_;
                SignatureLibrary signatureLibrary__ = this.insert((SIGNATURE_LIBRARY_.createDispatched(1)));
                Objects.requireNonNull(signatureLibrary__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.signatureLibrary_ = signatureLibrary__;
                state_0 = state_0 | 0b1 /* add SpecializationActive[MethodWrapper.toNative(MethodWrapper, SignatureLibrary)] */;
                this.state_0_ = state_0;
                arg0Value.toNative(signatureLibrary__);
                return;
            }

        }
        @GeneratedBy(MethodWrapper.class)
        public static class Uncached extends InteropLibrary implements UnadoptableNode {

            private final Class<? extends MethodWrapper> receiverClass_;

            protected Uncached(Object receiver) {
                this.receiverClass_ = ((MethodWrapper) receiver).getClass();
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert receiver.getClass() != this.receiverClass_ || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact(receiver, this.receiverClass_);
            }

            @TruffleBoundary
            @Override
            public boolean isPointer(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((MethodWrapper) receiver) .isPointer();
            }

            @TruffleBoundary
            @Override
            public long asPointer(Object receiver) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((MethodWrapper) receiver) .asPointer();
            }

            @TruffleBoundary
            @Override
            public void toNative(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                MethodWrapper arg0Value = ((MethodWrapper) arg0Value_);
                arg0Value.toNative((SIGNATURE_LIBRARY_.getUncached()));
                return;
            }

        }
    }
}
