// CheckStyle: start generated
package com.oracle.graal.python.nodes.bytecode.instrumentation;

import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.instrumentation.InstrumentableNode.WrapperNode;

@GeneratedBy(InstrumentationRoot.class)
final class InstrumentationRootWrapper extends InstrumentationRoot implements WrapperNode {

    @Child private InstrumentationRoot delegateNode;
    @Child private ProbeNode probeNode;

    InstrumentationRootWrapper(InstrumentationRoot delegateNode, ProbeNode probeNode) {
        this.delegateNode = delegateNode;
        this.probeNode = probeNode;
    }

    @Override
    public InstrumentationRoot getDelegateNode() {
        return delegateNode;
    }

    @Override
    public ProbeNode getProbeNode() {
        return probeNode;
    }

    @Override
    public void execute(@SuppressWarnings("unused") VirtualFrame frame) {
        for (;;) {
            boolean wasOnReturnExecuted = false;
            try {
                probeNode.onEnter(frame);
                delegateNode.execute(frame);
                wasOnReturnExecuted = true;
                probeNode.onReturnValue(frame, null);
                break;
            } catch (Throwable t) {
                Object result = probeNode.onReturnExceptionalOrUnwind(frame, t, wasOnReturnExecuted);
                if (result == ProbeNode.UNWIND_ACTION_REENTER) {
                    continue;
                } else if (result != null) {
                    break;
                }
                throw t;
            }
        }
    }

    @Override
    public InstrumentationSupport getInstrumentation() {
        return this.delegateNode.getInstrumentation();
    }

}
