// CheckStyle: start generated
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.modules.ThreadModuleBuiltins.AllocateLockNode;
import com.oracle.graal.python.builtins.modules.ThreadModuleBuiltins.DaemonThreadsAllowedNode;
import com.oracle.graal.python.builtins.modules.ThreadModuleBuiltins.ExitThreadNode;
import com.oracle.graal.python.builtins.modules.ThreadModuleBuiltins.GetCurrentThreadIdNode;
import com.oracle.graal.python.builtins.modules.ThreadModuleBuiltins.GetNativeIdNode;
import com.oracle.graal.python.builtins.modules.ThreadModuleBuiltins.GetThreadCountNode;
import com.oracle.graal.python.builtins.modules.ThreadModuleBuiltins.GetThreadStackSizeNode;
import com.oracle.graal.python.builtins.modules.ThreadModuleBuiltins.InterruptMainThreadNode;
import com.oracle.graal.python.builtins.modules.ThreadModuleBuiltins.SetSentinelNode;
import com.oracle.graal.python.builtins.modules.ThreadModuleBuiltins.StartNewThreadNode;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNodeGen;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.PRaiseNodeGen;
import com.oracle.graal.python.nodes.argument.ReadArgumentNode;
import com.oracle.graal.python.nodes.argument.keywords.ExpandKeywordStarargsNode;
import com.oracle.graal.python.nodes.argument.keywords.ExpandKeywordStarargsNodeGen;
import com.oracle.graal.python.nodes.argument.positional.ExecutePositionalStarargsNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.List;
import java.util.Objects;

@GeneratedBy(ThreadModuleBuiltins.class)
@SuppressWarnings({"javadoc", "unused"})
public final class ThreadModuleBuiltinsFactory {

    public static List<NodeFactory<? extends PythonBuiltinBaseNode>> getFactories() {
        return List.of(AllocateLockNodeFactory.getInstance(), GetCurrentThreadIdNodeFactory.getInstance(), GetNativeIdNodeFactory.getInstance(), GetThreadCountNodeFactory.getInstance(), GetThreadStackSizeNodeFactory.getInstance(), StartNewThreadNodeFactory.getInstance(), SetSentinelNodeFactory.getInstance(), InterruptMainThreadNodeFactory.getInstance(), ExitThreadNodeFactory.getInstance(), DaemonThreadsAllowedNodeFactory.getInstance());
    }

    @GeneratedBy(AllocateLockNode.class)
    public static final class AllocateLockNodeFactory implements NodeFactory<AllocateLockNode> {

        private static final AllocateLockNodeFactory ALLOCATE_LOCK_NODE_FACTORY_INSTANCE = new AllocateLockNodeFactory();

        private AllocateLockNodeFactory() {
        }

        @Override
        public Class<AllocateLockNode> getNodeClass() {
            return AllocateLockNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public AllocateLockNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<AllocateLockNode> getInstance() {
            return ALLOCATE_LOCK_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static AllocateLockNode create() {
            return new AllocateLockNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link AllocateLockNode#construct}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre> */
        @GeneratedBy(AllocateLockNode.class)
        @SuppressWarnings("javadoc")
        public static final class AllocateLockNodeGen extends AllocateLockNode {

            private AllocateLockNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                {
                    PythonLanguage language__ = (PythonLanguage.get(this));
                    return construct(arg0Value, arg1Value, language__);
                }
            }

        }
    }
    @GeneratedBy(GetCurrentThreadIdNode.class)
    public static final class GetCurrentThreadIdNodeFactory implements NodeFactory<GetCurrentThreadIdNode> {

        private static final GetCurrentThreadIdNodeFactory GET_CURRENT_THREAD_ID_NODE_FACTORY_INSTANCE = new GetCurrentThreadIdNodeFactory();

        private GetCurrentThreadIdNodeFactory() {
        }

        @Override
        public Class<GetCurrentThreadIdNode> getNodeClass() {
            return GetCurrentThreadIdNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of();
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(ReadArgumentNode[].class));
        }

        @Override
        public GetCurrentThreadIdNode createNode(Object... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return create((ReadArgumentNode[]) arguments[0]);
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<GetCurrentThreadIdNode> getInstance() {
            return GET_CURRENT_THREAD_ID_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static GetCurrentThreadIdNode create(ReadArgumentNode[] arguments) {
            return new GetCurrentThreadIdNodeGen(arguments);
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link GetCurrentThreadIdNode#getId}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre> */
        @GeneratedBy(GetCurrentThreadIdNode.class)
        @SuppressWarnings("javadoc")
        public static final class GetCurrentThreadIdNodeGen extends GetCurrentThreadIdNode {

            private GetCurrentThreadIdNodeGen(ReadArgumentNode[] arguments) {
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return GetCurrentThreadIdNode.getId();
            }

        }
    }
    @GeneratedBy(GetNativeIdNode.class)
    public static final class GetNativeIdNodeFactory implements NodeFactory<GetNativeIdNode> {

        private static final GetNativeIdNodeFactory GET_NATIVE_ID_NODE_FACTORY_INSTANCE = new GetNativeIdNodeFactory();

        private GetNativeIdNodeFactory() {
        }

        @Override
        public Class<GetNativeIdNode> getNodeClass() {
            return GetNativeIdNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of();
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(ReadArgumentNode[].class));
        }

        @Override
        public GetNativeIdNode createNode(Object... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return create((ReadArgumentNode[]) arguments[0]);
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<GetNativeIdNode> getInstance() {
            return GET_NATIVE_ID_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static GetNativeIdNode create(ReadArgumentNode[] arguments) {
            return new GetNativeIdNodeGen(arguments);
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link GetNativeIdNode#getId}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre> */
        @GeneratedBy(GetNativeIdNode.class)
        @SuppressWarnings("javadoc")
        public static final class GetNativeIdNodeGen extends GetNativeIdNode {

            private GetNativeIdNodeGen(ReadArgumentNode[] arguments) {
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return GetNativeIdNode.getId();
            }

        }
    }
    @GeneratedBy(GetThreadCountNode.class)
    static final class GetThreadCountNodeFactory implements NodeFactory<GetThreadCountNode> {

        private static final GetThreadCountNodeFactory GET_THREAD_COUNT_NODE_FACTORY_INSTANCE = new GetThreadCountNodeFactory();

        private GetThreadCountNodeFactory() {
        }

        @Override
        public Class<GetThreadCountNode> getNodeClass() {
            return GetThreadCountNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public GetThreadCountNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<GetThreadCountNode> getInstance() {
            return GET_THREAD_COUNT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static GetThreadCountNode create() {
            return new GetThreadCountNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link GetThreadCountNode#getCount}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre> */
        @GeneratedBy(GetThreadCountNode.class)
        @SuppressWarnings("javadoc")
        static final class GetThreadCountNodeGen extends GetThreadCountNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link GetThreadCountNode#getCount}
             * </pre> */
            @CompilationFinal private int state_0_;

            private GetThreadCountNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[ThreadModuleBuiltins.GetThreadCountNode.getCount(PythonModule)] */ && arg0Value instanceof PythonModule) {
                    PythonModule arg0Value_ = (PythonModule) arg0Value;
                    return getCount(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private long executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PythonModule) {
                    PythonModule arg0Value_ = (PythonModule) arg0Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[ThreadModuleBuiltins.GetThreadCountNode.getCount(PythonModule)] */;
                    this.state_0_ = state_0;
                    return getCount(arg0Value_);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

        }
    }
    @GeneratedBy(GetThreadStackSizeNode.class)
    static final class GetThreadStackSizeNodeFactory implements NodeFactory<GetThreadStackSizeNode> {

        private static final GetThreadStackSizeNodeFactory GET_THREAD_STACK_SIZE_NODE_FACTORY_INSTANCE = new GetThreadStackSizeNodeFactory();

        private GetThreadStackSizeNodeFactory() {
        }

        @Override
        public Class<GetThreadStackSizeNode> getNodeClass() {
            return GetThreadStackSizeNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public GetThreadStackSizeNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<GetThreadStackSizeNode> getInstance() {
            return GET_THREAD_STACK_SIZE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static GetThreadStackSizeNode create() {
            return new GetThreadStackSizeNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link GetThreadStackSizeNode#getStackSize(PNone)}
         *     Activation probability: 0.65000
         *     With/without class size: 11/0 bytes
         *   Specialization {@link GetThreadStackSizeNode#getStackSize(VirtualFrame, Object, Node, PyNumberAsSizeNode, PRaiseNode)}
         *     Activation probability: 0.35000
         *     With/without class size: 12/5 bytes
         * </pre> */
        @GeneratedBy(GetThreadStackSizeNode.class)
        @SuppressWarnings("javadoc")
        static final class GetThreadStackSizeNodeGen extends GetThreadStackSizeNode {

            private static final StateField STATE_0_GetThreadStackSizeNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link GetThreadStackSizeNode#getStackSize(VirtualFrame, Object, Node, PyNumberAsSizeNode, PRaiseNode)}
             *   Parameter: {@link PyNumberAsSizeNode} asSizeNode
             *   Inline method: {@link PyNumberAsSizeNodeGen#inline}</pre> */
            private static final PyNumberAsSizeNode INLINED_FALLBACK_AS_SIZE_NODE_ = PyNumberAsSizeNodeGen.inline(InlineTarget.create(PyNumberAsSizeNode.class, STATE_0_GetThreadStackSizeNode_UPDATER.subUpdater(2, 5), ReferenceField.create(MethodHandles.lookup(), "fallback_asSizeNode__field1_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link GetThreadStackSizeNode#getStackSize(VirtualFrame, Object, Node, PyNumberAsSizeNode, PRaiseNode)}
             *   Parameter: {@link PRaiseNode} raiseNode
             *   Inline method: {@link PRaiseNodeGen#inline}</pre> */
            private static final PRaiseNode INLINED_FALLBACK_RAISE_NODE_ = PRaiseNodeGen.inline(InlineTarget.create(PRaiseNode.class, STATE_0_GetThreadStackSizeNode_UPDATER.subUpdater(7, 1)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link GetThreadStackSizeNode#getStackSize(PNone)}
             *   1: SpecializationActive {@link GetThreadStackSizeNode#getStackSize(VirtualFrame, Object, Node, PyNumberAsSizeNode, PRaiseNode)}
             *   2-6: InlinedCache
             *        Specialization: {@link GetThreadStackSizeNode#getStackSize(VirtualFrame, Object, Node, PyNumberAsSizeNode, PRaiseNode)}
             *        Parameter: {@link PyNumberAsSizeNode} asSizeNode
             *        Inline method: {@link PyNumberAsSizeNodeGen#inline}
             *   7: InlinedCache
             *        Specialization: {@link GetThreadStackSizeNode#getStackSize(VirtualFrame, Object, Node, PyNumberAsSizeNode, PRaiseNode)}
             *        Parameter: {@link PRaiseNode} raiseNode
             *        Inline method: {@link PRaiseNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link GetThreadStackSizeNode#getStackSize(VirtualFrame, Object, Node, PyNumberAsSizeNode, PRaiseNode)}
             *   Parameter: {@link PyNumberAsSizeNode} asSizeNode
             *   Inline method: {@link PyNumberAsSizeNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node fallback_asSizeNode__field1_;

            private GetThreadStackSizeNodeGen() {
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(Object arg0Value) {
                if (arg0Value instanceof PNone) {
                    PNone arg0Value_ = (PNone) arg0Value;
                    if ((PGuards.isNoValue(arg0Value_))) {
                        return false;
                    }
                }
                return true;
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[ThreadModuleBuiltins.GetThreadStackSizeNode.getStackSize(PNone)] || SpecializationActive[ThreadModuleBuiltins.GetThreadStackSizeNode.getStackSize(VirtualFrame, Object, Node, PyNumberAsSizeNode, PRaiseNode)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[ThreadModuleBuiltins.GetThreadStackSizeNode.getStackSize(PNone)] */ && arg0Value instanceof PNone) {
                        PNone arg0Value_ = (PNone) arg0Value;
                        if ((PGuards.isNoValue(arg0Value_))) {
                            return getStackSize(arg0Value_);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[ThreadModuleBuiltins.GetThreadStackSizeNode.getStackSize(VirtualFrame, Object, Node, PyNumberAsSizeNode, PRaiseNode)] */) {
                        {
                            Node inliningTarget__ = (this);
                            if (fallbackGuard_(arg0Value)) {
                                return GetThreadStackSizeNode.getStackSize(frameValue, arg0Value, inliningTarget__, INLINED_FALLBACK_AS_SIZE_NODE_, INLINED_FALLBACK_RAISE_NODE_);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value);
            }

            private long executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PNone) {
                    PNone arg0Value_ = (PNone) arg0Value;
                    if ((PGuards.isNoValue(arg0Value_))) {
                        state_0 = state_0 | 0b1 /* add SpecializationActive[ThreadModuleBuiltins.GetThreadStackSizeNode.getStackSize(PNone)] */;
                        this.state_0_ = state_0;
                        return getStackSize(arg0Value_);
                    }
                }
                {
                    Node inliningTarget__ = null;
                    inliningTarget__ = (this);
                    state_0 = state_0 | 0b10 /* add SpecializationActive[ThreadModuleBuiltins.GetThreadStackSizeNode.getStackSize(VirtualFrame, Object, Node, PyNumberAsSizeNode, PRaiseNode)] */;
                    this.state_0_ = state_0;
                    return GetThreadStackSizeNode.getStackSize(frameValue, arg0Value, inliningTarget__, INLINED_FALLBACK_AS_SIZE_NODE_, INLINED_FALLBACK_RAISE_NODE_);
                }
            }

        }
    }
    @GeneratedBy(StartNewThreadNode.class)
    static final class StartNewThreadNodeFactory implements NodeFactory<StartNewThreadNode> {

        private static final StartNewThreadNodeFactory START_NEW_THREAD_NODE_FACTORY_INSTANCE = new StartNewThreadNodeFactory();

        private StartNewThreadNodeFactory() {
        }

        @Override
        public Class<StartNewThreadNode> getNodeClass() {
            return StartNewThreadNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public StartNewThreadNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<StartNewThreadNode> getInstance() {
            return START_NEW_THREAD_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static StartNewThreadNode create() {
            return new StartNewThreadNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link StartNewThreadNode#start}
         *     Activation probability: 1.00000
         *     With/without class size: 36/13 bytes
         * </pre> */
        @GeneratedBy(StartNewThreadNode.class)
        @SuppressWarnings("javadoc")
        static final class StartNewThreadNodeGen extends StartNewThreadNode {

            private static final StateField STATE_0_StartNewThreadNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link StartNewThreadNode#start}
             *   Parameter: {@link ExpandKeywordStarargsNode} getKwArgsNode
             *   Inline method: {@link ExpandKeywordStarargsNodeGen#inline}</pre> */
            private static final ExpandKeywordStarargsNode INLINED_GET_KW_ARGS_NODE_ = ExpandKeywordStarargsNodeGen.inline(InlineTarget.create(ExpandKeywordStarargsNode.class, STATE_0_StartNewThreadNode_UPDATER.subUpdater(1, 2), ReferenceField.create(MethodHandles.lookup(), "getKwArgsNode__field1_", Node.class)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link StartNewThreadNode#start}
             *   1-2: InlinedCache
             *        Specialization: {@link StartNewThreadNode#start}
             *        Parameter: {@link ExpandKeywordStarargsNode} getKwArgsNode
             *        Inline method: {@link ExpandKeywordStarargsNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link StartNewThreadNode#start}
             *   Parameter: {@link CallNode} callNode</pre> */
            @Child private CallNode callNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link StartNewThreadNode#start}
             *   Parameter: {@link ExecutePositionalStarargsNode} getArgsNode</pre> */
            @Child private ExecutePositionalStarargsNode getArgsNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link StartNewThreadNode#start}
             *   Parameter: {@link ExpandKeywordStarargsNode} getKwArgsNode
             *   Inline method: {@link ExpandKeywordStarargsNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node getKwArgsNode__field1_;

            private StartNewThreadNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[ThreadModuleBuiltins.StartNewThreadNode.start(VirtualFrame, Object, Object, Object, Node, PythonContext, CallNode, ExecutePositionalStarargsNode, ExpandKeywordStarargsNode)] */) {
                    {
                        CallNode callNode__ = this.callNode_;
                        if (callNode__ != null) {
                            ExecutePositionalStarargsNode getArgsNode__ = this.getArgsNode_;
                            if (getArgsNode__ != null) {
                                Node inliningTarget__ = (this);
                                PythonContext context__ = (PythonContext.get(this));
                                return StartNewThreadNode.start(frameValue, arg0Value, arg1Value, arg2Value, inliningTarget__, context__, callNode__, getArgsNode__, INLINED_GET_KW_ARGS_NODE_);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value, arg2Value);
            }

            private long executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value) {
                int state_0 = this.state_0_;
                {
                    PythonContext context__ = null;
                    Node inliningTarget__ = null;
                    inliningTarget__ = (this);
                    context__ = (PythonContext.get(this));
                    CallNode callNode__ = this.insert((CallNode.create()));
                    Objects.requireNonNull(callNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.callNode_ = callNode__;
                    ExecutePositionalStarargsNode getArgsNode__ = this.insert((ExecutePositionalStarargsNode.create()));
                    Objects.requireNonNull(getArgsNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.getArgsNode_ = getArgsNode__;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[ThreadModuleBuiltins.StartNewThreadNode.start(VirtualFrame, Object, Object, Object, Node, PythonContext, CallNode, ExecutePositionalStarargsNode, ExpandKeywordStarargsNode)] */;
                    this.state_0_ = state_0;
                    return StartNewThreadNode.start(frameValue, arg0Value, arg1Value, arg2Value, inliningTarget__, context__, callNode__, getArgsNode__, INLINED_GET_KW_ARGS_NODE_);
                }
            }

        }
    }
    @GeneratedBy(SetSentinelNode.class)
    static final class SetSentinelNodeFactory implements NodeFactory<SetSentinelNode> {

        private static final SetSentinelNodeFactory SET_SENTINEL_NODE_FACTORY_INSTANCE = new SetSentinelNodeFactory();

        private SetSentinelNodeFactory() {
        }

        @Override
        public Class<SetSentinelNode> getNodeClass() {
            return SetSentinelNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of();
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(ReadArgumentNode[].class));
        }

        @Override
        public SetSentinelNode createNode(Object... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return create((ReadArgumentNode[]) arguments[0]);
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<SetSentinelNode> getInstance() {
            return SET_SENTINEL_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static SetSentinelNode create(ReadArgumentNode[] arguments) {
            return new SetSentinelNodeGen(arguments);
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link SetSentinelNode#setSentinel}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre> */
        @GeneratedBy(SetSentinelNode.class)
        @SuppressWarnings("javadoc")
        static final class SetSentinelNodeGen extends SetSentinelNode {

            private SetSentinelNodeGen(ReadArgumentNode[] arguments) {
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return setSentinel();
            }

        }
    }
    @GeneratedBy(InterruptMainThreadNode.class)
    static final class InterruptMainThreadNodeFactory implements NodeFactory<InterruptMainThreadNode> {

        private static final InterruptMainThreadNodeFactory INTERRUPT_MAIN_THREAD_NODE_FACTORY_INSTANCE = new InterruptMainThreadNodeFactory();

        private InterruptMainThreadNodeFactory() {
        }

        @Override
        public Class<InterruptMainThreadNode> getNodeClass() {
            return InterruptMainThreadNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public InterruptMainThreadNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<InterruptMainThreadNode> getInstance() {
            return INTERRUPT_MAIN_THREAD_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static InterruptMainThreadNode create() {
            return new InterruptMainThreadNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link InterruptMainThreadNode#getCount}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre> */
        @GeneratedBy(InterruptMainThreadNode.class)
        @SuppressWarnings("javadoc")
        static final class InterruptMainThreadNodeGen extends InterruptMainThreadNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link InterruptMainThreadNode#getCount}
             * </pre> */
            @CompilationFinal private int state_0_;

            private InterruptMainThreadNodeGen() {
            }

            @Override
            protected Object executeWithoutClinic(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[ThreadModuleBuiltins.InterruptMainThreadNode.getCount(int)] */ && arg0Value instanceof Integer) {
                    int arg0Value_ = (int) arg0Value;
                    return getCount(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private Object executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof Integer) {
                    int arg0Value_ = (int) arg0Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[ThreadModuleBuiltins.InterruptMainThreadNode.getCount(int)] */;
                    this.state_0_ = state_0;
                    return getCount(arg0Value_);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

        }
    }
    @GeneratedBy(ExitThreadNode.class)
    static final class ExitThreadNodeFactory implements NodeFactory<ExitThreadNode> {

        private static final ExitThreadNodeFactory EXIT_THREAD_NODE_FACTORY_INSTANCE = new ExitThreadNodeFactory();

        private ExitThreadNodeFactory() {
        }

        @Override
        public Class<ExitThreadNode> getNodeClass() {
            return ExitThreadNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of();
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(ReadArgumentNode[].class));
        }

        @Override
        public ExitThreadNode createNode(Object... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return create((ReadArgumentNode[]) arguments[0]);
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<ExitThreadNode> getInstance() {
            return EXIT_THREAD_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ExitThreadNode create(ReadArgumentNode[] arguments) {
            return new ExitThreadNodeGen(arguments);
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link ExitThreadNode#exit}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre> */
        @GeneratedBy(ExitThreadNode.class)
        @SuppressWarnings("javadoc")
        static final class ExitThreadNodeGen extends ExitThreadNode {

            private ExitThreadNodeGen(ReadArgumentNode[] arguments) {
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                {
                    Node inliningTarget__ = (this);
                    return ExitThreadNode.exit(inliningTarget__);
                }
            }

        }
    }
    @GeneratedBy(DaemonThreadsAllowedNode.class)
    public static final class DaemonThreadsAllowedNodeFactory implements NodeFactory<DaemonThreadsAllowedNode> {

        private static final DaemonThreadsAllowedNodeFactory DAEMON_THREADS_ALLOWED_NODE_FACTORY_INSTANCE = new DaemonThreadsAllowedNodeFactory();

        private DaemonThreadsAllowedNodeFactory() {
        }

        @Override
        public Class<DaemonThreadsAllowedNode> getNodeClass() {
            return DaemonThreadsAllowedNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of();
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(ReadArgumentNode[].class));
        }

        @Override
        public DaemonThreadsAllowedNode createNode(Object... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return create((ReadArgumentNode[]) arguments[0]);
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<DaemonThreadsAllowedNode> getInstance() {
            return DAEMON_THREADS_ALLOWED_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static DaemonThreadsAllowedNode create(ReadArgumentNode[] arguments) {
            return new DaemonThreadsAllowedNodeGen(arguments);
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link DaemonThreadsAllowedNode#daemonAllowed}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre> */
        @GeneratedBy(DaemonThreadsAllowedNode.class)
        @SuppressWarnings("javadoc")
        public static final class DaemonThreadsAllowedNodeGen extends DaemonThreadsAllowedNode {

            private DaemonThreadsAllowedNodeGen(ReadArgumentNode[] arguments) {
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return DaemonThreadsAllowedNode.daemonAllowed();
            }

        }
    }
}
