// CheckStyle: start generated
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.builtins.modules.UnicodeDataModuleBuiltins.BidirectionalNode;
import com.oracle.graal.python.builtins.modules.UnicodeDataModuleBuiltins.CategoryNode;
import com.oracle.graal.python.builtins.modules.UnicodeDataModuleBuiltins.IsNormalizedNode;
import com.oracle.graal.python.builtins.modules.UnicodeDataModuleBuiltins.NameNode;
import com.oracle.graal.python.builtins.modules.UnicodeDataModuleBuiltins.NormalizeNode;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.PRaiseNodeGen;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleString.EqualNode;
import com.oracle.truffle.api.strings.TruffleString.FromJavaStringNode;
import com.oracle.truffle.api.strings.TruffleString.ToJavaStringNode;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.List;
import java.util.Objects;
import org.graalvm.shadowed.com.ibm.icu.text.Normalizer2;

@GeneratedBy(UnicodeDataModuleBuiltins.class)
@SuppressWarnings("javadoc")
public final class UnicodeDataModuleBuiltinsFactory {

    public static List<NodeFactory<? extends PythonBuiltinBaseNode>> getFactories() {
        return List.of(NormalizeNodeFactory.getInstance(), IsNormalizedNodeFactory.getInstance(), NameNodeFactory.getInstance(), BidirectionalNodeFactory.getInstance(), CategoryNodeFactory.getInstance());
    }

    @GeneratedBy(NormalizeNode.class)
    public static final class NormalizeNodeFactory implements NodeFactory<NormalizeNode> {

        private static final NormalizeNodeFactory NORMALIZE_NODE_FACTORY_INSTANCE = new NormalizeNodeFactory();

        private NormalizeNodeFactory() {
        }

        @Override
        public Class<NormalizeNode> getNodeClass() {
            return NormalizeNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public NormalizeNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<NormalizeNode> getInstance() {
            return NORMALIZE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static NormalizeNode create() {
            return new NormalizeNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link NormalizeNode#normalize(TruffleString, TruffleString, TruffleString, Normalizer2, EqualNode, ToJavaStringNode, FromJavaStringNode)}
         *     Activation probability: 0.65000
         *     With/without class size: 30/20 bytes
         *   Specialization {@link NormalizeNode#invalidForm}
         *     Activation probability: 0.35000
         *     With/without class size: 8/0 bytes
         * </pre> */
        @GeneratedBy(NormalizeNode.class)
        @SuppressWarnings("javadoc")
        public static final class NormalizeNodeGen extends NormalizeNode {

            static final ReferenceField<NormalizeData> NORMALIZE_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "normalize_cache", NormalizeData.class);

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link NormalizeNode#normalize(TruffleString, TruffleString, TruffleString, Normalizer2, EqualNode, ToJavaStringNode, FromJavaStringNode)}
             *   1: SpecializationActive {@link NormalizeNode#invalidForm}
             * </pre> */
            @CompilationFinal private int state_0_;
            @UnsafeAccessedField @Child private NormalizeData normalize_cache;

            private NormalizeNodeGen() {
            }

            @ExplodeLoop
            @Override
            protected Object executeWithoutClinic(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[UnicodeDataModuleBuiltins.NormalizeNode.normalize(TruffleString, TruffleString, TruffleString, Normalizer2, EqualNode, ToJavaStringNode, FromJavaStringNode)] || SpecializationActive[UnicodeDataModuleBuiltins.NormalizeNode.invalidForm(TruffleString, TruffleString)] */ && arg0Value instanceof TruffleString) {
                    TruffleString arg0Value_ = (TruffleString) arg0Value;
                    if (arg1Value instanceof TruffleString) {
                        TruffleString arg1Value_ = (TruffleString) arg1Value;
                        if ((state_0 & 0b1) != 0 /* is SpecializationActive[UnicodeDataModuleBuiltins.NormalizeNode.normalize(TruffleString, TruffleString, TruffleString, Normalizer2, EqualNode, ToJavaStringNode, FromJavaStringNode)] */) {
                            NormalizeData s0_ = this.normalize_cache;
                            while (s0_ != null) {
                                assert DSLSupport.assertIdempotence((s0_.cachedNormalizer_ != null));
                                if ((PGuards.stringEquals(arg0Value_, s0_.cachedForm_, s0_.equalNode_))) {
                                    return NormalizeNode.normalize(arg0Value_, arg1Value_, s0_.cachedForm_, s0_.cachedNormalizer_, s0_.equalNode_, s0_.toJavaStringNode_, s0_.fromJavaStringNode_);
                                }
                                s0_ = s0_.next_;
                            }
                        }
                        if ((state_0 & 0b10) != 0 /* is SpecializationActive[UnicodeDataModuleBuiltins.NormalizeNode.invalidForm(TruffleString, TruffleString)] */) {
                            if ((UnicodeDataModuleBuiltins.getNormalizer(arg0Value_) == null)) {
                                return invalidForm(arg0Value_, arg1Value_);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            @SuppressWarnings("unused")
            private TruffleString executeAndSpecialize(Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof TruffleString) {
                    TruffleString arg0Value_ = (TruffleString) arg0Value;
                    if (arg1Value instanceof TruffleString) {
                        TruffleString arg1Value_ = (TruffleString) arg1Value;
                        while (true) {
                            int count0_ = 0;
                            NormalizeData s0_ = NORMALIZE_CACHE_UPDATER.getVolatile(this);
                            NormalizeData s0_original = s0_;
                            while (s0_ != null) {
                                assert DSLSupport.assertIdempotence((s0_.cachedNormalizer_ != null));
                                if ((PGuards.stringEquals(arg0Value_, s0_.cachedForm_, s0_.equalNode_))) {
                                    break;
                                }
                                count0_++;
                                s0_ = s0_.next_;
                            }
                            if (s0_ == null) {
                                {
                                    TruffleString cachedForm__ = (arg0Value_);
                                    Normalizer2 cachedNormalizer__ = (UnicodeDataModuleBuiltins.getNormalizer(cachedForm__));
                                    if ((cachedNormalizer__ != null)) {
                                        EqualNode equalNode__ = this.insert((EqualNode.create()));
                                        if ((PGuards.stringEquals(arg0Value_, cachedForm__, equalNode__)) && count0_ < (UnicodeDataModuleBuiltins.NORMALIZER_FORM_COUNT)) {
                                            s0_ = this.insert(new NormalizeData(s0_original));
                                            s0_.cachedForm_ = cachedForm__;
                                            s0_.cachedNormalizer_ = cachedNormalizer__;
                                            Objects.requireNonNull(s0_.insert(equalNode__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                            s0_.equalNode_ = equalNode__;
                                            ToJavaStringNode toJavaStringNode__ = s0_.insert((ToJavaStringNode.create()));
                                            Objects.requireNonNull(toJavaStringNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                            s0_.toJavaStringNode_ = toJavaStringNode__;
                                            FromJavaStringNode fromJavaStringNode__ = s0_.insert((FromJavaStringNode.create()));
                                            Objects.requireNonNull(fromJavaStringNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                            s0_.fromJavaStringNode_ = fromJavaStringNode__;
                                            if (!NORMALIZE_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                                continue;
                                            }
                                            state_0 = state_0 | 0b1 /* add SpecializationActive[UnicodeDataModuleBuiltins.NormalizeNode.normalize(TruffleString, TruffleString, TruffleString, Normalizer2, EqualNode, ToJavaStringNode, FromJavaStringNode)] */;
                                            this.state_0_ = state_0;
                                        }
                                    }
                                }
                            }
                            if (s0_ != null) {
                                return NormalizeNode.normalize(arg0Value_, arg1Value_, s0_.cachedForm_, s0_.cachedNormalizer_, s0_.equalNode_, s0_.toJavaStringNode_, s0_.fromJavaStringNode_);
                            }
                            break;
                        }
                        if ((UnicodeDataModuleBuiltins.getNormalizer(arg0Value_) == null)) {
                            state_0 = state_0 | 0b10 /* add SpecializationActive[UnicodeDataModuleBuiltins.NormalizeNode.invalidForm(TruffleString, TruffleString)] */;
                            this.state_0_ = state_0;
                            return invalidForm(arg0Value_, arg1Value_);
                        }
                    }
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value);
            }

            @GeneratedBy(NormalizeNode.class)
            @DenyReplace
            private static final class NormalizeData extends Node implements SpecializationDataNode {

                @Child NormalizeData next_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link NormalizeNode#normalize(TruffleString, TruffleString, TruffleString, Normalizer2, EqualNode, ToJavaStringNode, FromJavaStringNode)}
                 *   Parameter: {@link TruffleString} cachedForm</pre> */
                @CompilationFinal TruffleString cachedForm_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link NormalizeNode#normalize(TruffleString, TruffleString, TruffleString, Normalizer2, EqualNode, ToJavaStringNode, FromJavaStringNode)}
                 *   Parameter: {@link Normalizer2} cachedNormalizer</pre> */
                @CompilationFinal Normalizer2 cachedNormalizer_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link NormalizeNode#normalize(TruffleString, TruffleString, TruffleString, Normalizer2, EqualNode, ToJavaStringNode, FromJavaStringNode)}
                 *   Parameter: {@link EqualNode} equalNode</pre> */
                @Child EqualNode equalNode_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link NormalizeNode#normalize(TruffleString, TruffleString, TruffleString, Normalizer2, EqualNode, ToJavaStringNode, FromJavaStringNode)}
                 *   Parameter: {@link ToJavaStringNode} toJavaStringNode</pre> */
                @Child ToJavaStringNode toJavaStringNode_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link NormalizeNode#normalize(TruffleString, TruffleString, TruffleString, Normalizer2, EqualNode, ToJavaStringNode, FromJavaStringNode)}
                 *   Parameter: {@link FromJavaStringNode} fromJavaStringNode</pre> */
                @Child FromJavaStringNode fromJavaStringNode_;

                NormalizeData(NormalizeData next_) {
                    this.next_ = next_;
                }

            }
        }
    }
    @GeneratedBy(IsNormalizedNode.class)
    public static final class IsNormalizedNodeFactory implements NodeFactory<IsNormalizedNode> {

        private static final IsNormalizedNodeFactory IS_NORMALIZED_NODE_FACTORY_INSTANCE = new IsNormalizedNodeFactory();

        private IsNormalizedNodeFactory() {
        }

        @Override
        public Class<IsNormalizedNode> getNodeClass() {
            return IsNormalizedNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public IsNormalizedNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<IsNormalizedNode> getInstance() {
            return IS_NORMALIZED_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IsNormalizedNode create() {
            return new IsNormalizedNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link IsNormalizedNode#isNormalized}
         *     Activation probability: 0.65000
         *     With/without class size: 24/12 bytes
         *   Specialization {@link IsNormalizedNode#invalidForm}
         *     Activation probability: 0.35000
         *     With/without class size: 8/0 bytes
         * </pre> */
        @GeneratedBy(IsNormalizedNode.class)
        @SuppressWarnings("javadoc")
        public static final class IsNormalizedNodeGen extends IsNormalizedNode {

            static final ReferenceField<IsNormalizedData> IS_NORMALIZED_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "isNormalized_cache", IsNormalizedData.class);

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link IsNormalizedNode#isNormalized}
             *   1: SpecializationActive {@link IsNormalizedNode#invalidForm}
             * </pre> */
            @CompilationFinal private int state_0_;
            @UnsafeAccessedField @Child private IsNormalizedData isNormalized_cache;

            private IsNormalizedNodeGen() {
            }

            @ExplodeLoop
            @Override
            protected Object executeWithoutClinic(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[UnicodeDataModuleBuiltins.IsNormalizedNode.isNormalized(TruffleString, TruffleString, TruffleString, Normalizer2, EqualNode)] || SpecializationActive[UnicodeDataModuleBuiltins.IsNormalizedNode.invalidForm(TruffleString, TruffleString)] */ && arg0Value instanceof TruffleString) {
                    TruffleString arg0Value_ = (TruffleString) arg0Value;
                    if (arg1Value instanceof TruffleString) {
                        TruffleString arg1Value_ = (TruffleString) arg1Value;
                        if ((state_0 & 0b1) != 0 /* is SpecializationActive[UnicodeDataModuleBuiltins.IsNormalizedNode.isNormalized(TruffleString, TruffleString, TruffleString, Normalizer2, EqualNode)] */) {
                            IsNormalizedData s0_ = this.isNormalized_cache;
                            while (s0_ != null) {
                                assert DSLSupport.assertIdempotence((s0_.cachedNormalizer_ != null));
                                if ((PGuards.stringEquals(arg0Value_, s0_.cachedForm_, s0_.equalNode_))) {
                                    return isNormalized(arg0Value_, arg1Value_, s0_.cachedForm_, s0_.cachedNormalizer_, s0_.equalNode_);
                                }
                                s0_ = s0_.next_;
                            }
                        }
                        if ((state_0 & 0b10) != 0 /* is SpecializationActive[UnicodeDataModuleBuiltins.IsNormalizedNode.invalidForm(TruffleString, TruffleString)] */) {
                            if ((UnicodeDataModuleBuiltins.getNormalizer(arg0Value_) == null)) {
                                return invalidForm(arg0Value_, arg1Value_);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            @SuppressWarnings("unused")
            private Object executeAndSpecialize(Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof TruffleString) {
                    TruffleString arg0Value_ = (TruffleString) arg0Value;
                    if (arg1Value instanceof TruffleString) {
                        TruffleString arg1Value_ = (TruffleString) arg1Value;
                        while (true) {
                            int count0_ = 0;
                            IsNormalizedData s0_ = IS_NORMALIZED_CACHE_UPDATER.getVolatile(this);
                            IsNormalizedData s0_original = s0_;
                            while (s0_ != null) {
                                assert DSLSupport.assertIdempotence((s0_.cachedNormalizer_ != null));
                                if ((PGuards.stringEquals(arg0Value_, s0_.cachedForm_, s0_.equalNode_))) {
                                    break;
                                }
                                count0_++;
                                s0_ = s0_.next_;
                            }
                            if (s0_ == null) {
                                {
                                    TruffleString cachedForm__ = (arg0Value_);
                                    Normalizer2 cachedNormalizer__ = (UnicodeDataModuleBuiltins.getNormalizer(cachedForm__));
                                    if ((cachedNormalizer__ != null)) {
                                        EqualNode equalNode__ = this.insert((EqualNode.create()));
                                        if ((PGuards.stringEquals(arg0Value_, cachedForm__, equalNode__)) && count0_ < (UnicodeDataModuleBuiltins.NORMALIZER_FORM_COUNT)) {
                                            s0_ = this.insert(new IsNormalizedData(s0_original));
                                            s0_.cachedForm_ = cachedForm__;
                                            s0_.cachedNormalizer_ = cachedNormalizer__;
                                            Objects.requireNonNull(s0_.insert(equalNode__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                            s0_.equalNode_ = equalNode__;
                                            if (!IS_NORMALIZED_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                                continue;
                                            }
                                            state_0 = state_0 | 0b1 /* add SpecializationActive[UnicodeDataModuleBuiltins.IsNormalizedNode.isNormalized(TruffleString, TruffleString, TruffleString, Normalizer2, EqualNode)] */;
                                            this.state_0_ = state_0;
                                        }
                                    }
                                }
                            }
                            if (s0_ != null) {
                                return isNormalized(arg0Value_, arg1Value_, s0_.cachedForm_, s0_.cachedNormalizer_, s0_.equalNode_);
                            }
                            break;
                        }
                        if ((UnicodeDataModuleBuiltins.getNormalizer(arg0Value_) == null)) {
                            state_0 = state_0 | 0b10 /* add SpecializationActive[UnicodeDataModuleBuiltins.IsNormalizedNode.invalidForm(TruffleString, TruffleString)] */;
                            this.state_0_ = state_0;
                            return invalidForm(arg0Value_, arg1Value_);
                        }
                    }
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value);
            }

            @GeneratedBy(IsNormalizedNode.class)
            @DenyReplace
            private static final class IsNormalizedData extends Node implements SpecializationDataNode {

                @Child IsNormalizedData next_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link IsNormalizedNode#isNormalized}
                 *   Parameter: {@link TruffleString} cachedForm</pre> */
                @CompilationFinal TruffleString cachedForm_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link IsNormalizedNode#isNormalized}
                 *   Parameter: {@link Normalizer2} cachedNormalizer</pre> */
                @CompilationFinal Normalizer2 cachedNormalizer_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link IsNormalizedNode#isNormalized}
                 *   Parameter: {@link EqualNode} equalNode</pre> */
                @Child EqualNode equalNode_;

                IsNormalizedData(IsNormalizedData next_) {
                    this.next_ = next_;
                }

            }
        }
    }
    @GeneratedBy(NameNode.class)
    public static final class NameNodeFactory implements NodeFactory<NameNode> {

        private static final NameNodeFactory NAME_NODE_FACTORY_INSTANCE = new NameNodeFactory();

        private NameNodeFactory() {
        }

        @Override
        public Class<NameNode> getNodeClass() {
            return NameNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public NameNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<NameNode> getInstance() {
            return NAME_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static NameNode create() {
            return new NameNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link NameNode#name}
         *     Activation probability: 1.00000
         *     With/without class size: 28/5 bytes
         * </pre> */
        @GeneratedBy(NameNode.class)
        @SuppressWarnings("javadoc")
        public static final class NameNodeGen extends NameNode {

            private static final StateField STATE_0_NameNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link NameNode#name}
             *   Parameter: {@link PRaiseNode} raiseNode
             *   Inline method: {@link PRaiseNodeGen#inline}</pre> */
            private static final PRaiseNode INLINED_RAISE_NODE_ = PRaiseNodeGen.inline(InlineTarget.create(PRaiseNode.class, STATE_0_NameNode_UPDATER.subUpdater(1, 1)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link NameNode#name}
             *   1: InlinedCache
             *        Specialization: {@link NameNode#name}
             *        Parameter: {@link PRaiseNode} raiseNode
             *        Inline method: {@link PRaiseNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link NameNode#name}
             *   Parameter: {@link FromJavaStringNode} fromJavaStringNode</pre> */
            @Child private FromJavaStringNode fromJavaStringNode_;

            private NameNodeGen() {
            }

            @Override
            protected Object executeWithoutClinic(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[UnicodeDataModuleBuiltins.NameNode.name(int, Object, Node, FromJavaStringNode, PRaiseNode)] */ && arg0Value instanceof Integer) {
                    int arg0Value_ = (int) arg0Value;
                    {
                        FromJavaStringNode fromJavaStringNode__ = this.fromJavaStringNode_;
                        if (fromJavaStringNode__ != null) {
                            Node inliningTarget__ = (this);
                            return NameNode.name(arg0Value_, arg1Value, inliningTarget__, fromJavaStringNode__, INLINED_RAISE_NODE_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                {
                    Node inliningTarget__ = null;
                    if (arg0Value instanceof Integer) {
                        int arg0Value_ = (int) arg0Value;
                        inliningTarget__ = (this);
                        FromJavaStringNode fromJavaStringNode__ = this.insert((FromJavaStringNode.create()));
                        Objects.requireNonNull(fromJavaStringNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.fromJavaStringNode_ = fromJavaStringNode__;
                        state_0 = state_0 | 0b1 /* add SpecializationActive[UnicodeDataModuleBuiltins.NameNode.name(int, Object, Node, FromJavaStringNode, PRaiseNode)] */;
                        this.state_0_ = state_0;
                        return NameNode.name(arg0Value_, arg1Value, inliningTarget__, fromJavaStringNode__, INLINED_RAISE_NODE_);
                    }
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value);
            }

        }
    }
    @GeneratedBy(BidirectionalNode.class)
    public static final class BidirectionalNodeFactory implements NodeFactory<BidirectionalNode> {

        private static final BidirectionalNodeFactory BIDIRECTIONAL_NODE_FACTORY_INSTANCE = new BidirectionalNodeFactory();

        private BidirectionalNodeFactory() {
        }

        @Override
        public Class<BidirectionalNode> getNodeClass() {
            return BidirectionalNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public BidirectionalNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<BidirectionalNode> getInstance() {
            return BIDIRECTIONAL_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static BidirectionalNode create() {
            return new BidirectionalNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link BidirectionalNode#bidirectional}
         *     Activation probability: 1.00000
         *     With/without class size: 24/4 bytes
         * </pre> */
        @GeneratedBy(BidirectionalNode.class)
        @SuppressWarnings("javadoc")
        public static final class BidirectionalNodeGen extends BidirectionalNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link BidirectionalNode#bidirectional}
             * </pre> */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link BidirectionalNode#bidirectional}
             *   Parameter: {@link FromJavaStringNode} fromJavaStringNode</pre> */
            @Child private FromJavaStringNode fromJavaStringNode_;

            private BidirectionalNodeGen() {
            }

            @Override
            protected Object executeWithoutClinic(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[UnicodeDataModuleBuiltins.BidirectionalNode.bidirectional(int, FromJavaStringNode)] */ && arg0Value instanceof Integer) {
                    int arg0Value_ = (int) arg0Value;
                    {
                        FromJavaStringNode fromJavaStringNode__ = this.fromJavaStringNode_;
                        if (fromJavaStringNode__ != null) {
                            return BidirectionalNode.bidirectional(arg0Value_, fromJavaStringNode__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private TruffleString executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof Integer) {
                    int arg0Value_ = (int) arg0Value;
                    FromJavaStringNode fromJavaStringNode__ = this.insert((FromJavaStringNode.create()));
                    Objects.requireNonNull(fromJavaStringNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.fromJavaStringNode_ = fromJavaStringNode__;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[UnicodeDataModuleBuiltins.BidirectionalNode.bidirectional(int, FromJavaStringNode)] */;
                    this.state_0_ = state_0;
                    return BidirectionalNode.bidirectional(arg0Value_, fromJavaStringNode__);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

        }
    }
    @GeneratedBy(CategoryNode.class)
    public static final class CategoryNodeFactory implements NodeFactory<CategoryNode> {

        private static final CategoryNodeFactory CATEGORY_NODE_FACTORY_INSTANCE = new CategoryNodeFactory();

        private CategoryNodeFactory() {
        }

        @Override
        public Class<CategoryNode> getNodeClass() {
            return CategoryNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public CategoryNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<CategoryNode> getInstance() {
            return CATEGORY_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static CategoryNode create() {
            return new CategoryNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link CategoryNode#category}
         *     Activation probability: 1.00000
         *     With/without class size: 24/4 bytes
         * </pre> */
        @GeneratedBy(CategoryNode.class)
        @SuppressWarnings("javadoc")
        public static final class CategoryNodeGen extends CategoryNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link CategoryNode#category}
             * </pre> */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CategoryNode#category}
             *   Parameter: {@link FromJavaStringNode} fromJavaStringNode</pre> */
            @Child private FromJavaStringNode fromJavaStringNode_;

            private CategoryNodeGen() {
            }

            @Override
            protected Object executeWithoutClinic(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[UnicodeDataModuleBuiltins.CategoryNode.category(int, FromJavaStringNode)] */ && arg0Value instanceof Integer) {
                    int arg0Value_ = (int) arg0Value;
                    {
                        FromJavaStringNode fromJavaStringNode__ = this.fromJavaStringNode_;
                        if (fromJavaStringNode__ != null) {
                            return CategoryNode.category(arg0Value_, fromJavaStringNode__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private TruffleString executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof Integer) {
                    int arg0Value_ = (int) arg0Value;
                    FromJavaStringNode fromJavaStringNode__ = this.insert((FromJavaStringNode.create()));
                    Objects.requireNonNull(fromJavaStringNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.fromJavaStringNode_ = fromJavaStringNode__;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[UnicodeDataModuleBuiltins.CategoryNode.category(int, FromJavaStringNode)] */;
                    this.state_0_ = state_0;
                    return CategoryNode.category(arg0Value_, fromJavaStringNode__);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

        }
    }
}
