// @formatter:off
// Checkstyle: stop
package com.oracle.graal.python.builtins.modules.cext;

import java.util.TreeSet;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;

public abstract class PythonCApiAssertions {

    private PythonCApiAssertions() {
        // no instances
    }

    public static boolean reallyHasMember(Object capiLibrary, String name) {
        try {
            InteropLibrary.getUncached().readMember(capiLibrary, name);
        } catch (UnsupportedMessageException e) {
            throw CompilerDirectives.shouldNotReachHere(e);
        } catch (UnknownIdentifierException e) {
            return false;
        }
        return true;
    }

    /**
     * Checks whether the expected builtins exist in the library.
     */
    public static boolean assertBuiltins(Object capiLibrary) {
        boolean hasMember = false;
        TreeSet<String> messages = new TreeSet<>();
        
        hasMember = reallyHasMember(capiLibrary, "GraalPyArray_Data");
        if (!hasMember) messages.add("missing implementation: GraalPyArray_Data");
        hasMember = reallyHasMember(capiLibrary, "GraalPyArray_Resize");
        if (!hasMember) messages.add("missing implementation: GraalPyArray_Resize");
        hasMember = reallyHasMember(capiLibrary, "GraalPyCode_GetFileName");
        if (!hasMember) messages.add("missing implementation: GraalPyCode_GetFileName");
        hasMember = reallyHasMember(capiLibrary, "GraalPyCode_GetName");
        if (!hasMember) messages.add("missing implementation: GraalPyCode_GetName");
        hasMember = reallyHasMember(capiLibrary, "GraalPyDateTime_DATE_GET_FOLD");
        if (!hasMember) messages.add("missing implementation: GraalPyDateTime_DATE_GET_FOLD");
        hasMember = reallyHasMember(capiLibrary, "GraalPyDateTime_DATE_GET_HOUR");
        if (!hasMember) messages.add("missing implementation: GraalPyDateTime_DATE_GET_HOUR");
        hasMember = reallyHasMember(capiLibrary, "GraalPyDateTime_DATE_GET_MICROSECOND");
        if (!hasMember) messages.add("missing implementation: GraalPyDateTime_DATE_GET_MICROSECOND");
        hasMember = reallyHasMember(capiLibrary, "GraalPyDateTime_DATE_GET_MINUTE");
        if (!hasMember) messages.add("missing implementation: GraalPyDateTime_DATE_GET_MINUTE");
        hasMember = reallyHasMember(capiLibrary, "GraalPyDateTime_DATE_GET_SECOND");
        if (!hasMember) messages.add("missing implementation: GraalPyDateTime_DATE_GET_SECOND");
        hasMember = reallyHasMember(capiLibrary, "GraalPyDateTime_DATE_GET_TZINFO");
        if (!hasMember) messages.add("missing implementation: GraalPyDateTime_DATE_GET_TZINFO");
        hasMember = reallyHasMember(capiLibrary, "GraalPyDateTime_DELTA_GET_DAYS");
        if (!hasMember) messages.add("missing implementation: GraalPyDateTime_DELTA_GET_DAYS");
        hasMember = reallyHasMember(capiLibrary, "GraalPyDateTime_DELTA_GET_MICROSECONDS");
        if (!hasMember) messages.add("missing implementation: GraalPyDateTime_DELTA_GET_MICROSECONDS");
        hasMember = reallyHasMember(capiLibrary, "GraalPyDateTime_DELTA_GET_SECONDS");
        if (!hasMember) messages.add("missing implementation: GraalPyDateTime_DELTA_GET_SECONDS");
        hasMember = reallyHasMember(capiLibrary, "GraalPyDateTime_GET_DAY");
        if (!hasMember) messages.add("missing implementation: GraalPyDateTime_GET_DAY");
        hasMember = reallyHasMember(capiLibrary, "GraalPyDateTime_GET_MONTH");
        if (!hasMember) messages.add("missing implementation: GraalPyDateTime_GET_MONTH");
        hasMember = reallyHasMember(capiLibrary, "GraalPyDateTime_GET_YEAR");
        if (!hasMember) messages.add("missing implementation: GraalPyDateTime_GET_YEAR");
        hasMember = reallyHasMember(capiLibrary, "GraalPyDateTime_TIME_GET_FOLD");
        if (!hasMember) messages.add("missing implementation: GraalPyDateTime_TIME_GET_FOLD");
        hasMember = reallyHasMember(capiLibrary, "GraalPyDateTime_TIME_GET_HOUR");
        if (!hasMember) messages.add("missing implementation: GraalPyDateTime_TIME_GET_HOUR");
        hasMember = reallyHasMember(capiLibrary, "GraalPyDateTime_TIME_GET_MICROSECOND");
        if (!hasMember) messages.add("missing implementation: GraalPyDateTime_TIME_GET_MICROSECOND");
        hasMember = reallyHasMember(capiLibrary, "GraalPyDateTime_TIME_GET_MINUTE");
        if (!hasMember) messages.add("missing implementation: GraalPyDateTime_TIME_GET_MINUTE");
        hasMember = reallyHasMember(capiLibrary, "GraalPyDateTime_TIME_GET_SECOND");
        if (!hasMember) messages.add("missing implementation: GraalPyDateTime_TIME_GET_SECOND");
        hasMember = reallyHasMember(capiLibrary, "GraalPyDateTime_TIME_GET_TZINFO");
        if (!hasMember) messages.add("missing implementation: GraalPyDateTime_TIME_GET_TZINFO");
        hasMember = reallyHasMember(capiLibrary, "GraalPyFrame_SetLineNumber");
        if (!hasMember) messages.add("missing implementation: GraalPyFrame_SetLineNumber");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_AddInheritedSlots");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Array_getbuffer");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Array_releasebuffer");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_BeforeThreadDetach");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_BulkNotifyRefCount");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_ByteArray_EmptyWithCapacity");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_ByteArray_FromStringAndSize");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Bytes_CheckEmbeddedNull");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Bytes_Concat");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Bytes_EmptyWithCapacity");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Bytes_FromFormat");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Bytes_FromStringAndSize");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Bytes_Resize");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_CData_NewGetBuffer");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_CData_ReleaseBuffer");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_CFunction_SetDoc");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_CMethod_NewEx");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Complex_AsCComplex");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Complex_ImagAsDouble");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Complex_RealAsDouble");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Compute_Mro");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_ContextVar_Get");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_DateTimeCAPI_DateTime_FromDateAndTime");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_DateTimeCAPI_DateTime_FromDateAndTimeAndFold");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_DateTimeCAPI_DateTime_FromTimestamp");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_DateTimeCAPI_Date_FromDate");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_DateTimeCAPI_Date_FromTimestamp");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_DateTimeCAPI_Delta_FromDelta");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_DateTimeCAPI_TimeZone_FromTimeZone");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_DateTimeCAPI_Time_FromTime");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_DateTimeCAPI_Time_FromTimeAndFold");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Debug");
        if (!hasMember) messages.add("missing implementation: GraalPyPrivate_Debug");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_DebugTrace");
        if (!hasMember) messages.add("missing implementation: GraalPyPrivate_DebugTrace");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Descr_NewClassMethod");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Descr_NewGetSet");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Dict_MaybeUntrack");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_DisableReferneceQueuePolling");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Ellipsis");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_EnableReferneceQueuePolling");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Err_CreateAndSetException");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Err_GetExcInfo");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Err_SetTraceback");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Err_Warn");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Err_WarnExplicit");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Eval_EvalCodeEx");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_False");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_FatalErrorFunc");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_FileSystemDefaultEncoding");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Float_AsDouble");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_GILState_Check");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_GILState_Ensure");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_GILState_Release");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_GetInitialNativeMemory");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_GetMMapData");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_GetMaxNativeMemory");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Get_PyASCIIObject_length");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Get_PyASCIIObject_state_ascii");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Get_PyASCIIObject_state_compact");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Get_PyASCIIObject_state_interned");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Get_PyASCIIObject_state_kind");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Get_PyASCIIObject_state_ready");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Get_PyByteArrayObject_ob_exports");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Get_PyByteArrayObject_ob_start");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Get_PyCFunctionObject_m_ml");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Get_PyCFunctionObject_m_module");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Get_PyCFunctionObject_m_self");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Get_PyCFunctionObject_m_weakreflist");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Get_PyCFunctionObject_vectorcall");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Get_PyCMethodObject_mm_class");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Get_PyDescrObject_d_name");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Get_PyDescrObject_d_type");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Get_PyFrameObject_f_lineno");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Get_PyGetSetDef_closure");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Get_PyGetSetDef_doc");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Get_PyGetSetDef_get");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Get_PyGetSetDef_name");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Get_PyGetSetDef_set");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Get_PyInstanceMethodObject_func");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Get_PyListObject_ob_item");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Get_PyLongObject_long_value_lv_tag");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Get_PyMethodDescrObject_d_method");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Get_PyMethodObject_im_func");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Get_PyMethodObject_im_self");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Get_PyModuleDef_m_doc");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Get_PyModuleDef_m_methods");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Get_PyModuleDef_m_name");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Get_PyModuleDef_m_size");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Get_PyModuleObject_md_def");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Get_PyModuleObject_md_dict");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Get_PyModuleObject_md_state");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Get_PyObject_ob_refcnt");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Get_PyObject_ob_type");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Get_PySetObject_used");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Get_PySliceObject_start");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Get_PySliceObject_step");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Get_PySliceObject_stop");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Get_PyTupleObject_ob_item");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Get_PyUnicodeObject_data");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Get_PyVarObject_ob_size");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_HashConstant");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_HashDouble");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Hash_InitSecret");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_InitBuiltinTypesAndStructs");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Is");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_IsReferencedFromManaged");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Iter_Send");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_List_ClearManagedOrGetItems");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_List_TryGetItems");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_LogString");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Long_AsPrimitive");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Long_DigitCount");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Long_FromLongLong");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Long_FromString");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_ManagedObject_GC_Del");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Mapping_Size");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_MemoryViewFromBuffer");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Module_AddFunctionToModule");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Module_CreateInitialized_PyModule_New");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Module_SetDef");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Module_SetState");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Module_Traverse");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Native_Options");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_NewTypeDict");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_NoValue");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_None");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_NotImplemented");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_NotifyRefCount");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Object_Call1");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Object_CallFunctionObjArgs");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Object_CallMethod1");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Object_CallMethodObjArgs");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Object_Dump");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Object_GC_EnsureWeak");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Object_GC_Track");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Object_GC_UnTrack");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Object_GenericGetAttr");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Object_GenericGetDict");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Object_GenericSetAttr");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Object_GetItemString");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Object_IsFreed");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Object_ReplicateNativeReferences");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Object_Size");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_PickleBuffer_viewobj");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_PrintStacktrace");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_PyNumber_Add");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_PyNumber_And");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_PyNumber_Divmod");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_PyNumber_FloorDivide");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_PyNumber_InPlaceAdd");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_PyNumber_InPlaceAnd");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_PyNumber_InPlaceFloorDivide");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_PyNumber_InPlaceLshift");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_PyNumber_InPlaceMatrixMultiply");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_PyNumber_InPlaceMultiply");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_PyNumber_InPlaceOr");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_PyNumber_InPlacePower");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_PyNumber_InPlaceRemainder");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_PyNumber_InPlaceRshift");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_PyNumber_InPlaceSubtract");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_PyNumber_InPlaceTrueDivide");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_PyNumber_InPlaceXor");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_PyNumber_Lshift");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_PyNumber_MatrixMultiply");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_PyNumber_Multiply");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_PyNumber_Or");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_PyNumber_Power");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_PyNumber_Remainder");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_PyNumber_Rshift");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_PyNumber_Subtract");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_PyNumber_TrueDivide");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_PyNumber_Xor");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_PyUnicode_Find");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_SET_SIZE");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Sequence_DelItem");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Sequence_GetItem");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Sequence_SetItem");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Sequence_Size");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Set_Native_Slots");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Set_NextEntry");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Set_PyByteArrayObject_ob_exports");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Set_PyCFunctionObject_m_ml");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Set_PyCFunctionObject_m_module");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_State_FindModule");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_StructSequence_InitType2");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_StructSequence_NewType");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Sys_FormatStd");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Sys_WriteStd");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_ThreadState_Get");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_ToNative");
        if (!hasMember) messages.add("missing implementation: GraalPyPrivate_ToNative");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_TraceMalloc_Track");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_TraceMalloc_Untrack");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Trace_Type");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_TriggerGC");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_True");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Tuple_GetItem");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Tuple_Resize");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Type");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Type_AddFunctionToType");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Type_AddGetSet");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Type_AddMember");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Type_AddOperators");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Type_SetBufferProcs");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Unicode_AsUTF8AndSize");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Unicode_AsUnicodeAndSize");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Unicode_AsWideChar");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Unicode_Decode");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Unicode_DecodeUTF16Stateful");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Unicode_DecodeUTF32Stateful");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Unicode_DecodeUTF8Stateful");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Unicode_FSDecoder");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Unicode_FillUnicode");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Unicode_FillUtf8");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Unicode_FromFormat");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Unicode_FromUCS");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Unicode_FromUTF");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Unicode_IsMaterialized");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Unicode_LookupAndIntern");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_Unicode_New");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_tss_create");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_tss_delete");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_tss_get");
        hasMember = reallyHasMember(capiLibrary, "GraalPyPrivate_tss_set");
        hasMember = reallyHasMember(capiLibrary, "GraalPySlice_Start");
        if (!hasMember) messages.add("missing implementation: GraalPySlice_Start");
        hasMember = reallyHasMember(capiLibrary, "GraalPySlice_Step");
        if (!hasMember) messages.add("missing implementation: GraalPySlice_Step");
        hasMember = reallyHasMember(capiLibrary, "GraalPySlice_Stop");
        if (!hasMember) messages.add("missing implementation: GraalPySlice_Stop");
        hasMember = reallyHasMember(capiLibrary, "PyAIter_Check");
        if (!hasMember) messages.add("missing implementation: PyAIter_Check");
        hasMember = reallyHasMember(capiLibrary, "PyArg_Parse");
        if (!hasMember) messages.add("missing implementation: PyArg_Parse");
        hasMember = reallyHasMember(capiLibrary, "PyArg_ParseTuple");
        if (!hasMember) messages.add("missing implementation: PyArg_ParseTuple");
        hasMember = reallyHasMember(capiLibrary, "PyArg_ParseTupleAndKeywords");
        if (!hasMember) messages.add("missing implementation: PyArg_ParseTupleAndKeywords");
        hasMember = reallyHasMember(capiLibrary, "PyArg_UnpackTuple");
        if (!hasMember) messages.add("missing implementation: PyArg_UnpackTuple");
        hasMember = reallyHasMember(capiLibrary, "PyArg_VaParse");
        if (!hasMember) messages.add("missing implementation: PyArg_VaParse");
        hasMember = reallyHasMember(capiLibrary, "PyArg_VaParseTupleAndKeywords");
        if (!hasMember) messages.add("missing implementation: PyArg_VaParseTupleAndKeywords");
        hasMember = reallyHasMember(capiLibrary, "PyArg_ValidateKeywordArguments");
        if (!hasMember) messages.add("missing implementation: PyArg_ValidateKeywordArguments");
        hasMember = reallyHasMember(capiLibrary, "PyAsyncGen_New");
        if (!hasMember) messages.add("missing implementation: PyAsyncGen_New");
        hasMember = reallyHasMember(capiLibrary, "PyBool_FromLong");
        if (!hasMember) messages.add("missing implementation: PyBool_FromLong");
        hasMember = reallyHasMember(capiLibrary, "PyBuffer_FillContiguousStrides");
        if (!hasMember) messages.add("missing implementation: PyBuffer_FillContiguousStrides");
        hasMember = reallyHasMember(capiLibrary, "PyBuffer_FillInfo");
        if (!hasMember) messages.add("missing implementation: PyBuffer_FillInfo");
        hasMember = reallyHasMember(capiLibrary, "PyBuffer_FromContiguous");
        if (!hasMember) messages.add("missing implementation: PyBuffer_FromContiguous");
        hasMember = reallyHasMember(capiLibrary, "PyBuffer_GetPointer");
        if (!hasMember) messages.add("missing implementation: PyBuffer_GetPointer");
        hasMember = reallyHasMember(capiLibrary, "PyBuffer_IsContiguous");
        if (!hasMember) messages.add("missing implementation: PyBuffer_IsContiguous");
        hasMember = reallyHasMember(capiLibrary, "PyBuffer_Release");
        if (!hasMember) messages.add("missing implementation: PyBuffer_Release");
        hasMember = reallyHasMember(capiLibrary, "PyBuffer_SizeFromFormat");
        if (!hasMember) messages.add("missing implementation: PyBuffer_SizeFromFormat");
        hasMember = reallyHasMember(capiLibrary, "PyBuffer_ToContiguous");
        if (!hasMember) messages.add("missing implementation: PyBuffer_ToContiguous");
        hasMember = reallyHasMember(capiLibrary, "PyByteArray_AsString");
        if (!hasMember) messages.add("missing implementation: PyByteArray_AsString");
        hasMember = reallyHasMember(capiLibrary, "PyByteArray_Concat");
        if (!hasMember) messages.add("missing implementation: PyByteArray_Concat");
        hasMember = reallyHasMember(capiLibrary, "PyByteArray_FromObject");
        if (!hasMember) messages.add("missing implementation: PyByteArray_FromObject");
        hasMember = reallyHasMember(capiLibrary, "PyByteArray_FromStringAndSize");
        if (!hasMember) messages.add("missing implementation: PyByteArray_FromStringAndSize");
        hasMember = reallyHasMember(capiLibrary, "PyByteArray_Resize");
        if (!hasMember) messages.add("missing implementation: PyByteArray_Resize");
        hasMember = reallyHasMember(capiLibrary, "PyByteArray_Size");
        if (!hasMember) messages.add("missing implementation: PyByteArray_Size");
        hasMember = reallyHasMember(capiLibrary, "PyBytes_AsString");
        if (!hasMember) messages.add("missing implementation: PyBytes_AsString");
        hasMember = reallyHasMember(capiLibrary, "PyBytes_AsStringAndSize");
        if (!hasMember) messages.add("missing implementation: PyBytes_AsStringAndSize");
        hasMember = reallyHasMember(capiLibrary, "PyBytes_Concat");
        if (!hasMember) messages.add("missing implementation: PyBytes_Concat");
        hasMember = reallyHasMember(capiLibrary, "PyBytes_ConcatAndDel");
        if (!hasMember) messages.add("missing implementation: PyBytes_ConcatAndDel");
        hasMember = reallyHasMember(capiLibrary, "PyBytes_DecodeEscape");
        if (!hasMember) messages.add("missing implementation: PyBytes_DecodeEscape");
        hasMember = reallyHasMember(capiLibrary, "PyBytes_FromFormat");
        if (!hasMember) messages.add("missing implementation: PyBytes_FromFormat");
        hasMember = reallyHasMember(capiLibrary, "PyBytes_FromFormatV");
        if (!hasMember) messages.add("missing implementation: PyBytes_FromFormatV");
        hasMember = reallyHasMember(capiLibrary, "PyBytes_FromObject");
        if (!hasMember) messages.add("missing implementation: PyBytes_FromObject");
        hasMember = reallyHasMember(capiLibrary, "PyBytes_FromString");
        if (!hasMember) messages.add("missing implementation: PyBytes_FromString");
        hasMember = reallyHasMember(capiLibrary, "PyBytes_FromStringAndSize");
        if (!hasMember) messages.add("missing implementation: PyBytes_FromStringAndSize");
        hasMember = reallyHasMember(capiLibrary, "PyBytes_Repr");
        if (!hasMember) messages.add("missing implementation: PyBytes_Repr");
        hasMember = reallyHasMember(capiLibrary, "PyBytes_Size");
        if (!hasMember) messages.add("missing implementation: PyBytes_Size");
        hasMember = reallyHasMember(capiLibrary, "PyCFunction_Call");
        if (!hasMember) messages.add("missing implementation: PyCFunction_Call");
        hasMember = reallyHasMember(capiLibrary, "PyCFunction_GetFlags");
        if (!hasMember) messages.add("missing implementation: PyCFunction_GetFlags");
        hasMember = reallyHasMember(capiLibrary, "PyCFunction_GetFunction");
        if (!hasMember) messages.add("missing implementation: PyCFunction_GetFunction");
        hasMember = reallyHasMember(capiLibrary, "PyCFunction_GetSelf");
        if (!hasMember) messages.add("missing implementation: PyCFunction_GetSelf");
        hasMember = reallyHasMember(capiLibrary, "PyCFunction_New");
        if (!hasMember) messages.add("missing implementation: PyCFunction_New");
        hasMember = reallyHasMember(capiLibrary, "PyCFunction_NewEx");
        if (!hasMember) messages.add("missing implementation: PyCFunction_NewEx");
        hasMember = reallyHasMember(capiLibrary, "PyCMethod_New");
        if (!hasMember) messages.add("missing implementation: PyCMethod_New");
        hasMember = reallyHasMember(capiLibrary, "PyCallIter_New");
        if (!hasMember) messages.add("missing implementation: PyCallIter_New");
        hasMember = reallyHasMember(capiLibrary, "PyCallable_Check");
        if (!hasMember) messages.add("missing implementation: PyCallable_Check");
        hasMember = reallyHasMember(capiLibrary, "PyCapsule_GetContext");
        if (!hasMember) messages.add("missing implementation: PyCapsule_GetContext");
        hasMember = reallyHasMember(capiLibrary, "PyCapsule_GetDestructor");
        if (!hasMember) messages.add("missing implementation: PyCapsule_GetDestructor");
        hasMember = reallyHasMember(capiLibrary, "PyCapsule_GetName");
        if (!hasMember) messages.add("missing implementation: PyCapsule_GetName");
        hasMember = reallyHasMember(capiLibrary, "PyCapsule_GetPointer");
        if (!hasMember) messages.add("missing implementation: PyCapsule_GetPointer");
        hasMember = reallyHasMember(capiLibrary, "PyCapsule_Import");
        if (!hasMember) messages.add("missing implementation: PyCapsule_Import");
        hasMember = reallyHasMember(capiLibrary, "PyCapsule_IsValid");
        if (!hasMember) messages.add("missing implementation: PyCapsule_IsValid");
        hasMember = reallyHasMember(capiLibrary, "PyCapsule_New");
        if (!hasMember) messages.add("missing implementation: PyCapsule_New");
        hasMember = reallyHasMember(capiLibrary, "PyCapsule_SetContext");
        if (!hasMember) messages.add("missing implementation: PyCapsule_SetContext");
        hasMember = reallyHasMember(capiLibrary, "PyCapsule_SetDestructor");
        if (!hasMember) messages.add("missing implementation: PyCapsule_SetDestructor");
        hasMember = reallyHasMember(capiLibrary, "PyCapsule_SetName");
        if (!hasMember) messages.add("missing implementation: PyCapsule_SetName");
        hasMember = reallyHasMember(capiLibrary, "PyCapsule_SetPointer");
        if (!hasMember) messages.add("missing implementation: PyCapsule_SetPointer");
        hasMember = reallyHasMember(capiLibrary, "PyCell_Get");
        if (!hasMember) messages.add("missing implementation: PyCell_Get");
        hasMember = reallyHasMember(capiLibrary, "PyCell_New");
        if (!hasMember) messages.add("missing implementation: PyCell_New");
        hasMember = reallyHasMember(capiLibrary, "PyCell_Set");
        if (!hasMember) messages.add("missing implementation: PyCell_Set");
        hasMember = reallyHasMember(capiLibrary, "PyClassMethod_New");
        if (!hasMember) messages.add("missing implementation: PyClassMethod_New");
        hasMember = reallyHasMember(capiLibrary, "PyCode_AddWatcher");
        if (!hasMember) messages.add("missing implementation: PyCode_AddWatcher");
        hasMember = reallyHasMember(capiLibrary, "PyCode_Addr2Line");
        if (!hasMember) messages.add("missing implementation: PyCode_Addr2Line");
        hasMember = reallyHasMember(capiLibrary, "PyCode_Addr2Location");
        if (!hasMember) messages.add("missing implementation: PyCode_Addr2Location");
        hasMember = reallyHasMember(capiLibrary, "PyCode_ClearWatcher");
        if (!hasMember) messages.add("missing implementation: PyCode_ClearWatcher");
        hasMember = reallyHasMember(capiLibrary, "PyCode_GetCellvars");
        if (!hasMember) messages.add("missing implementation: PyCode_GetCellvars");
        hasMember = reallyHasMember(capiLibrary, "PyCode_GetCode");
        if (!hasMember) messages.add("missing implementation: PyCode_GetCode");
        hasMember = reallyHasMember(capiLibrary, "PyCode_GetFreevars");
        if (!hasMember) messages.add("missing implementation: PyCode_GetFreevars");
        hasMember = reallyHasMember(capiLibrary, "PyCode_GetVarnames");
        if (!hasMember) messages.add("missing implementation: PyCode_GetVarnames");
        hasMember = reallyHasMember(capiLibrary, "PyCode_NewEmpty");
        if (!hasMember) messages.add("missing implementation: PyCode_NewEmpty");
        hasMember = reallyHasMember(capiLibrary, "PyCode_Optimize");
        if (!hasMember) messages.add("missing implementation: PyCode_Optimize");
        hasMember = reallyHasMember(capiLibrary, "PyCodec_BackslashReplaceErrors");
        if (!hasMember) messages.add("missing implementation: PyCodec_BackslashReplaceErrors");
        hasMember = reallyHasMember(capiLibrary, "PyCodec_Decode");
        if (!hasMember) messages.add("missing implementation: PyCodec_Decode");
        hasMember = reallyHasMember(capiLibrary, "PyCodec_Decoder");
        if (!hasMember) messages.add("missing implementation: PyCodec_Decoder");
        hasMember = reallyHasMember(capiLibrary, "PyCodec_Encode");
        if (!hasMember) messages.add("missing implementation: PyCodec_Encode");
        hasMember = reallyHasMember(capiLibrary, "PyCodec_Encoder");
        if (!hasMember) messages.add("missing implementation: PyCodec_Encoder");
        hasMember = reallyHasMember(capiLibrary, "PyCodec_IgnoreErrors");
        if (!hasMember) messages.add("missing implementation: PyCodec_IgnoreErrors");
        hasMember = reallyHasMember(capiLibrary, "PyCodec_IncrementalDecoder");
        if (!hasMember) messages.add("missing implementation: PyCodec_IncrementalDecoder");
        hasMember = reallyHasMember(capiLibrary, "PyCodec_IncrementalEncoder");
        if (!hasMember) messages.add("missing implementation: PyCodec_IncrementalEncoder");
        hasMember = reallyHasMember(capiLibrary, "PyCodec_KnownEncoding");
        if (!hasMember) messages.add("missing implementation: PyCodec_KnownEncoding");
        hasMember = reallyHasMember(capiLibrary, "PyCodec_LookupError");
        if (!hasMember) messages.add("missing implementation: PyCodec_LookupError");
        hasMember = reallyHasMember(capiLibrary, "PyCodec_NameReplaceErrors");
        if (!hasMember) messages.add("missing implementation: PyCodec_NameReplaceErrors");
        hasMember = reallyHasMember(capiLibrary, "PyCodec_Register");
        if (!hasMember) messages.add("missing implementation: PyCodec_Register");
        hasMember = reallyHasMember(capiLibrary, "PyCodec_RegisterError");
        if (!hasMember) messages.add("missing implementation: PyCodec_RegisterError");
        hasMember = reallyHasMember(capiLibrary, "PyCodec_ReplaceErrors");
        if (!hasMember) messages.add("missing implementation: PyCodec_ReplaceErrors");
        hasMember = reallyHasMember(capiLibrary, "PyCodec_StreamReader");
        if (!hasMember) messages.add("missing implementation: PyCodec_StreamReader");
        hasMember = reallyHasMember(capiLibrary, "PyCodec_StreamWriter");
        if (!hasMember) messages.add("missing implementation: PyCodec_StreamWriter");
        hasMember = reallyHasMember(capiLibrary, "PyCodec_StrictErrors");
        if (!hasMember) messages.add("missing implementation: PyCodec_StrictErrors");
        hasMember = reallyHasMember(capiLibrary, "PyCodec_Unregister");
        if (!hasMember) messages.add("missing implementation: PyCodec_Unregister");
        hasMember = reallyHasMember(capiLibrary, "PyCodec_XMLCharRefReplaceErrors");
        if (!hasMember) messages.add("missing implementation: PyCodec_XMLCharRefReplaceErrors");
        hasMember = reallyHasMember(capiLibrary, "PyCompile_OpcodeStackEffect");
        if (!hasMember) messages.add("missing implementation: PyCompile_OpcodeStackEffect");
        hasMember = reallyHasMember(capiLibrary, "PyCompile_OpcodeStackEffectWithJump");
        if (!hasMember) messages.add("missing implementation: PyCompile_OpcodeStackEffectWithJump");
        hasMember = reallyHasMember(capiLibrary, "PyComplex_AsCComplex");
        if (!hasMember) messages.add("missing implementation: PyComplex_AsCComplex");
        hasMember = reallyHasMember(capiLibrary, "PyComplex_FromCComplex");
        if (!hasMember) messages.add("missing implementation: PyComplex_FromCComplex");
        hasMember = reallyHasMember(capiLibrary, "PyComplex_FromDoubles");
        if (!hasMember) messages.add("missing implementation: PyComplex_FromDoubles");
        hasMember = reallyHasMember(capiLibrary, "PyComplex_ImagAsDouble");
        if (!hasMember) messages.add("missing implementation: PyComplex_ImagAsDouble");
        hasMember = reallyHasMember(capiLibrary, "PyComplex_RealAsDouble");
        if (!hasMember) messages.add("missing implementation: PyComplex_RealAsDouble");
        hasMember = reallyHasMember(capiLibrary, "PyConfig_Clear");
        if (!hasMember) messages.add("missing implementation: PyConfig_Clear");
        hasMember = reallyHasMember(capiLibrary, "PyConfig_InitIsolatedConfig");
        if (!hasMember) messages.add("missing implementation: PyConfig_InitIsolatedConfig");
        hasMember = reallyHasMember(capiLibrary, "PyConfig_InitPythonConfig");
        if (!hasMember) messages.add("missing implementation: PyConfig_InitPythonConfig");
        hasMember = reallyHasMember(capiLibrary, "PyConfig_Read");
        if (!hasMember) messages.add("missing implementation: PyConfig_Read");
        hasMember = reallyHasMember(capiLibrary, "PyConfig_SetArgv");
        if (!hasMember) messages.add("missing implementation: PyConfig_SetArgv");
        hasMember = reallyHasMember(capiLibrary, "PyConfig_SetBytesArgv");
        if (!hasMember) messages.add("missing implementation: PyConfig_SetBytesArgv");
        hasMember = reallyHasMember(capiLibrary, "PyConfig_SetBytesString");
        if (!hasMember) messages.add("missing implementation: PyConfig_SetBytesString");
        hasMember = reallyHasMember(capiLibrary, "PyConfig_SetString");
        if (!hasMember) messages.add("missing implementation: PyConfig_SetString");
        hasMember = reallyHasMember(capiLibrary, "PyConfig_SetWideStringList");
        if (!hasMember) messages.add("missing implementation: PyConfig_SetWideStringList");
        hasMember = reallyHasMember(capiLibrary, "PyContextVar_Get");
        if (!hasMember) messages.add("missing implementation: PyContextVar_Get");
        hasMember = reallyHasMember(capiLibrary, "PyContextVar_New");
        if (!hasMember) messages.add("missing implementation: PyContextVar_New");
        hasMember = reallyHasMember(capiLibrary, "PyContextVar_Reset");
        if (!hasMember) messages.add("missing implementation: PyContextVar_Reset");
        hasMember = reallyHasMember(capiLibrary, "PyContextVar_Set");
        if (!hasMember) messages.add("missing implementation: PyContextVar_Set");
        hasMember = reallyHasMember(capiLibrary, "PyContext_Copy");
        if (!hasMember) messages.add("missing implementation: PyContext_Copy");
        hasMember = reallyHasMember(capiLibrary, "PyContext_CopyCurrent");
        if (!hasMember) messages.add("missing implementation: PyContext_CopyCurrent");
        hasMember = reallyHasMember(capiLibrary, "PyContext_Enter");
        if (!hasMember) messages.add("missing implementation: PyContext_Enter");
        hasMember = reallyHasMember(capiLibrary, "PyContext_Exit");
        if (!hasMember) messages.add("missing implementation: PyContext_Exit");
        hasMember = reallyHasMember(capiLibrary, "PyContext_New");
        if (!hasMember) messages.add("missing implementation: PyContext_New");
        hasMember = reallyHasMember(capiLibrary, "PyCoro_New");
        if (!hasMember) messages.add("missing implementation: PyCoro_New");
        hasMember = reallyHasMember(capiLibrary, "PyDescr_IsData");
        if (!hasMember) messages.add("missing implementation: PyDescr_IsData");
        hasMember = reallyHasMember(capiLibrary, "PyDescr_NewClassMethod");
        if (!hasMember) messages.add("missing implementation: PyDescr_NewClassMethod");
        hasMember = reallyHasMember(capiLibrary, "PyDescr_NewGetSet");
        if (!hasMember) messages.add("missing implementation: PyDescr_NewGetSet");
        hasMember = reallyHasMember(capiLibrary, "PyDescr_NewMember");
        if (!hasMember) messages.add("missing implementation: PyDescr_NewMember");
        hasMember = reallyHasMember(capiLibrary, "PyDescr_NewMethod");
        if (!hasMember) messages.add("missing implementation: PyDescr_NewMethod");
        hasMember = reallyHasMember(capiLibrary, "PyDescr_NewWrapper");
        if (!hasMember) messages.add("missing implementation: PyDescr_NewWrapper");
        hasMember = reallyHasMember(capiLibrary, "PyDictProxy_New");
        if (!hasMember) messages.add("missing implementation: PyDictProxy_New");
        hasMember = reallyHasMember(capiLibrary, "PyDict_AddWatcher");
        if (!hasMember) messages.add("missing implementation: PyDict_AddWatcher");
        hasMember = reallyHasMember(capiLibrary, "PyDict_Clear");
        if (!hasMember) messages.add("missing implementation: PyDict_Clear");
        hasMember = reallyHasMember(capiLibrary, "PyDict_ClearWatcher");
        if (!hasMember) messages.add("missing implementation: PyDict_ClearWatcher");
        hasMember = reallyHasMember(capiLibrary, "PyDict_Contains");
        if (!hasMember) messages.add("missing implementation: PyDict_Contains");
        hasMember = reallyHasMember(capiLibrary, "PyDict_Copy");
        if (!hasMember) messages.add("missing implementation: PyDict_Copy");
        hasMember = reallyHasMember(capiLibrary, "PyDict_DelItem");
        if (!hasMember) messages.add("missing implementation: PyDict_DelItem");
        hasMember = reallyHasMember(capiLibrary, "PyDict_DelItemString");
        if (!hasMember) messages.add("missing implementation: PyDict_DelItemString");
        hasMember = reallyHasMember(capiLibrary, "PyDict_GetItem");
        if (!hasMember) messages.add("missing implementation: PyDict_GetItem");
        hasMember = reallyHasMember(capiLibrary, "PyDict_GetItemString");
        if (!hasMember) messages.add("missing implementation: PyDict_GetItemString");
        hasMember = reallyHasMember(capiLibrary, "PyDict_GetItemWithError");
        if (!hasMember) messages.add("missing implementation: PyDict_GetItemWithError");
        hasMember = reallyHasMember(capiLibrary, "PyDict_Items");
        if (!hasMember) messages.add("missing implementation: PyDict_Items");
        hasMember = reallyHasMember(capiLibrary, "PyDict_Keys");
        if (!hasMember) messages.add("missing implementation: PyDict_Keys");
        hasMember = reallyHasMember(capiLibrary, "PyDict_Merge");
        if (!hasMember) messages.add("missing implementation: PyDict_Merge");
        hasMember = reallyHasMember(capiLibrary, "PyDict_MergeFromSeq2");
        if (!hasMember) messages.add("missing implementation: PyDict_MergeFromSeq2");
        hasMember = reallyHasMember(capiLibrary, "PyDict_New");
        if (!hasMember) messages.add("missing implementation: PyDict_New");
        hasMember = reallyHasMember(capiLibrary, "PyDict_Next");
        if (!hasMember) messages.add("missing implementation: PyDict_Next");
        hasMember = reallyHasMember(capiLibrary, "PyDict_SetDefault");
        if (!hasMember) messages.add("missing implementation: PyDict_SetDefault");
        hasMember = reallyHasMember(capiLibrary, "PyDict_SetItem");
        if (!hasMember) messages.add("missing implementation: PyDict_SetItem");
        hasMember = reallyHasMember(capiLibrary, "PyDict_SetItemString");
        if (!hasMember) messages.add("missing implementation: PyDict_SetItemString");
        hasMember = reallyHasMember(capiLibrary, "PyDict_Size");
        if (!hasMember) messages.add("missing implementation: PyDict_Size");
        hasMember = reallyHasMember(capiLibrary, "PyDict_Unwatch");
        if (!hasMember) messages.add("missing implementation: PyDict_Unwatch");
        hasMember = reallyHasMember(capiLibrary, "PyDict_Update");
        if (!hasMember) messages.add("missing implementation: PyDict_Update");
        hasMember = reallyHasMember(capiLibrary, "PyDict_Values");
        if (!hasMember) messages.add("missing implementation: PyDict_Values");
        hasMember = reallyHasMember(capiLibrary, "PyDict_Watch");
        if (!hasMember) messages.add("missing implementation: PyDict_Watch");
        hasMember = reallyHasMember(capiLibrary, "PyErr_BadArgument");
        if (!hasMember) messages.add("missing implementation: PyErr_BadArgument");
        hasMember = reallyHasMember(capiLibrary, "PyErr_BadInternalCall");
        if (!hasMember) messages.add("missing implementation: PyErr_BadInternalCall");
        hasMember = reallyHasMember(capiLibrary, "PyErr_CheckSignals");
        if (!hasMember) messages.add("missing implementation: PyErr_CheckSignals");
        hasMember = reallyHasMember(capiLibrary, "PyErr_Clear");
        if (!hasMember) messages.add("missing implementation: PyErr_Clear");
        hasMember = reallyHasMember(capiLibrary, "PyErr_Display");
        if (!hasMember) messages.add("missing implementation: PyErr_Display");
        hasMember = reallyHasMember(capiLibrary, "PyErr_DisplayException");
        if (!hasMember) messages.add("missing implementation: PyErr_DisplayException");
        hasMember = reallyHasMember(capiLibrary, "PyErr_ExceptionMatches");
        if (!hasMember) messages.add("missing implementation: PyErr_ExceptionMatches");
        hasMember = reallyHasMember(capiLibrary, "PyErr_Fetch");
        if (!hasMember) messages.add("missing implementation: PyErr_Fetch");
        hasMember = reallyHasMember(capiLibrary, "PyErr_Format");
        if (!hasMember) messages.add("missing implementation: PyErr_Format");
        hasMember = reallyHasMember(capiLibrary, "PyErr_FormatV");
        if (!hasMember) messages.add("missing implementation: PyErr_FormatV");
        hasMember = reallyHasMember(capiLibrary, "PyErr_GetExcInfo");
        if (!hasMember) messages.add("missing implementation: PyErr_GetExcInfo");
        hasMember = reallyHasMember(capiLibrary, "PyErr_GetHandledException");
        if (!hasMember) messages.add("missing implementation: PyErr_GetHandledException");
        hasMember = reallyHasMember(capiLibrary, "PyErr_GetRaisedException");
        if (!hasMember) messages.add("missing implementation: PyErr_GetRaisedException");
        hasMember = reallyHasMember(capiLibrary, "PyErr_GivenExceptionMatches");
        if (!hasMember) messages.add("missing implementation: PyErr_GivenExceptionMatches");
        hasMember = reallyHasMember(capiLibrary, "PyErr_NewException");
        if (!hasMember) messages.add("missing implementation: PyErr_NewException");
        hasMember = reallyHasMember(capiLibrary, "PyErr_NewExceptionWithDoc");
        if (!hasMember) messages.add("missing implementation: PyErr_NewExceptionWithDoc");
        hasMember = reallyHasMember(capiLibrary, "PyErr_NoMemory");
        if (!hasMember) messages.add("missing implementation: PyErr_NoMemory");
        hasMember = reallyHasMember(capiLibrary, "PyErr_NormalizeException");
        if (!hasMember) messages.add("missing implementation: PyErr_NormalizeException");
        hasMember = reallyHasMember(capiLibrary, "PyErr_Occurred");
        if (!hasMember) messages.add("missing implementation: PyErr_Occurred");
        hasMember = reallyHasMember(capiLibrary, "PyErr_Print");
        if (!hasMember) messages.add("missing implementation: PyErr_Print");
        hasMember = reallyHasMember(capiLibrary, "PyErr_PrintEx");
        if (!hasMember) messages.add("missing implementation: PyErr_PrintEx");
        hasMember = reallyHasMember(capiLibrary, "PyErr_ProgramText");
        if (!hasMember) messages.add("missing implementation: PyErr_ProgramText");
        hasMember = reallyHasMember(capiLibrary, "PyErr_ProgramTextObject");
        if (!hasMember) messages.add("missing implementation: PyErr_ProgramTextObject");
        hasMember = reallyHasMember(capiLibrary, "PyErr_RangedSyntaxLocationObject");
        if (!hasMember) messages.add("missing implementation: PyErr_RangedSyntaxLocationObject");
        hasMember = reallyHasMember(capiLibrary, "PyErr_ResourceWarning");
        if (!hasMember) messages.add("missing implementation: PyErr_ResourceWarning");
        hasMember = reallyHasMember(capiLibrary, "PyErr_Restore");
        if (!hasMember) messages.add("missing implementation: PyErr_Restore");
        hasMember = reallyHasMember(capiLibrary, "PyErr_SetExcInfo");
        if (!hasMember) messages.add("missing implementation: PyErr_SetExcInfo");
        hasMember = reallyHasMember(capiLibrary, "PyErr_SetFromErrno");
        if (!hasMember) messages.add("missing implementation: PyErr_SetFromErrno");
        hasMember = reallyHasMember(capiLibrary, "PyErr_SetFromErrnoWithFilename");
        if (!hasMember) messages.add("missing implementation: PyErr_SetFromErrnoWithFilename");
        hasMember = reallyHasMember(capiLibrary, "PyErr_SetFromErrnoWithFilenameObject");
        if (!hasMember) messages.add("missing implementation: PyErr_SetFromErrnoWithFilenameObject");
        hasMember = reallyHasMember(capiLibrary, "PyErr_SetFromErrnoWithFilenameObjects");
        if (!hasMember) messages.add("missing implementation: PyErr_SetFromErrnoWithFilenameObjects");
        hasMember = reallyHasMember(capiLibrary, "PyErr_SetHandledException");
        if (!hasMember) messages.add("missing implementation: PyErr_SetHandledException");
        hasMember = reallyHasMember(capiLibrary, "PyErr_SetImportError");
        if (!hasMember) messages.add("missing implementation: PyErr_SetImportError");
        hasMember = reallyHasMember(capiLibrary, "PyErr_SetImportErrorSubclass");
        if (!hasMember) messages.add("missing implementation: PyErr_SetImportErrorSubclass");
        hasMember = reallyHasMember(capiLibrary, "PyErr_SetInterrupt");
        if (!hasMember) messages.add("missing implementation: PyErr_SetInterrupt");
        hasMember = reallyHasMember(capiLibrary, "PyErr_SetInterruptEx");
        if (!hasMember) messages.add("missing implementation: PyErr_SetInterruptEx");
        hasMember = reallyHasMember(capiLibrary, "PyErr_SetNone");
        if (!hasMember) messages.add("missing implementation: PyErr_SetNone");
        hasMember = reallyHasMember(capiLibrary, "PyErr_SetObject");
        if (!hasMember) messages.add("missing implementation: PyErr_SetObject");
        hasMember = reallyHasMember(capiLibrary, "PyErr_SetRaisedException");
        if (!hasMember) messages.add("missing implementation: PyErr_SetRaisedException");
        hasMember = reallyHasMember(capiLibrary, "PyErr_SetString");
        if (!hasMember) messages.add("missing implementation: PyErr_SetString");
        hasMember = reallyHasMember(capiLibrary, "PyErr_SyntaxLocation");
        if (!hasMember) messages.add("missing implementation: PyErr_SyntaxLocation");
        hasMember = reallyHasMember(capiLibrary, "PyErr_SyntaxLocationEx");
        if (!hasMember) messages.add("missing implementation: PyErr_SyntaxLocationEx");
        hasMember = reallyHasMember(capiLibrary, "PyErr_SyntaxLocationObject");
        if (!hasMember) messages.add("missing implementation: PyErr_SyntaxLocationObject");
        hasMember = reallyHasMember(capiLibrary, "PyErr_WarnEx");
        if (!hasMember) messages.add("missing implementation: PyErr_WarnEx");
        hasMember = reallyHasMember(capiLibrary, "PyErr_WarnExplicit");
        if (!hasMember) messages.add("missing implementation: PyErr_WarnExplicit");
        hasMember = reallyHasMember(capiLibrary, "PyErr_WarnExplicit");
        if (!hasMember) messages.add("missing implementation: PyErr_WarnExplicit");
        hasMember = reallyHasMember(capiLibrary, "PyErr_WarnExplicitFormat");
        if (!hasMember) messages.add("missing implementation: PyErr_WarnExplicitFormat");
        hasMember = reallyHasMember(capiLibrary, "PyErr_WarnExplicitFormat");
        if (!hasMember) messages.add("missing implementation: PyErr_WarnExplicitFormat");
        hasMember = reallyHasMember(capiLibrary, "PyErr_WarnExplicitObject");
        if (!hasMember) messages.add("missing implementation: PyErr_WarnExplicitObject");
        hasMember = reallyHasMember(capiLibrary, "PyErr_WarnExplicitObject");
        if (!hasMember) messages.add("missing implementation: PyErr_WarnExplicitObject");
        hasMember = reallyHasMember(capiLibrary, "PyErr_WarnFormat");
        if (!hasMember) messages.add("missing implementation: PyErr_WarnFormat");
        hasMember = reallyHasMember(capiLibrary, "PyErr_WriteUnraisable");
        if (!hasMember) messages.add("missing implementation: PyErr_WriteUnraisable");
        hasMember = reallyHasMember(capiLibrary, "PyEval_AcquireLock");
        if (!hasMember) messages.add("missing implementation: PyEval_AcquireLock");
        hasMember = reallyHasMember(capiLibrary, "PyEval_AcquireThread");
        if (!hasMember) messages.add("missing implementation: PyEval_AcquireThread");
        hasMember = reallyHasMember(capiLibrary, "PyEval_CallFunction");
        if (!hasMember) messages.add("missing implementation: PyEval_CallFunction");
        hasMember = reallyHasMember(capiLibrary, "PyEval_CallMethod");
        if (!hasMember) messages.add("missing implementation: PyEval_CallMethod");
        hasMember = reallyHasMember(capiLibrary, "PyEval_CallObjectWithKeywords");
        if (!hasMember) messages.add("missing implementation: PyEval_CallObjectWithKeywords");
        hasMember = reallyHasMember(capiLibrary, "PyEval_EvalCode");
        if (!hasMember) messages.add("missing implementation: PyEval_EvalCode");
        hasMember = reallyHasMember(capiLibrary, "PyEval_EvalCodeEx");
        if (!hasMember) messages.add("missing implementation: PyEval_EvalCodeEx");
        hasMember = reallyHasMember(capiLibrary, "PyEval_EvalFrame");
        if (!hasMember) messages.add("missing implementation: PyEval_EvalFrame");
        hasMember = reallyHasMember(capiLibrary, "PyEval_EvalFrameEx");
        if (!hasMember) messages.add("missing implementation: PyEval_EvalFrameEx");
        hasMember = reallyHasMember(capiLibrary, "PyEval_GetBuiltins");
        if (!hasMember) messages.add("missing implementation: PyEval_GetBuiltins");
        hasMember = reallyHasMember(capiLibrary, "PyEval_GetFrame");
        if (!hasMember) messages.add("missing implementation: PyEval_GetFrame");
        hasMember = reallyHasMember(capiLibrary, "PyEval_GetFuncDesc");
        if (!hasMember) messages.add("missing implementation: PyEval_GetFuncDesc");
        hasMember = reallyHasMember(capiLibrary, "PyEval_GetFuncName");
        if (!hasMember) messages.add("missing implementation: PyEval_GetFuncName");
        hasMember = reallyHasMember(capiLibrary, "PyEval_GetGlobals");
        if (!hasMember) messages.add("missing implementation: PyEval_GetGlobals");
        hasMember = reallyHasMember(capiLibrary, "PyEval_GetLocals");
        if (!hasMember) messages.add("missing implementation: PyEval_GetLocals");
        hasMember = reallyHasMember(capiLibrary, "PyEval_InitThreads");
        if (!hasMember) messages.add("missing implementation: PyEval_InitThreads");
        hasMember = reallyHasMember(capiLibrary, "PyEval_MergeCompilerFlags");
        if (!hasMember) messages.add("missing implementation: PyEval_MergeCompilerFlags");
        hasMember = reallyHasMember(capiLibrary, "PyEval_ReleaseLock");
        if (!hasMember) messages.add("missing implementation: PyEval_ReleaseLock");
        hasMember = reallyHasMember(capiLibrary, "PyEval_ReleaseThread");
        if (!hasMember) messages.add("missing implementation: PyEval_ReleaseThread");
        hasMember = reallyHasMember(capiLibrary, "PyEval_RestoreThread");
        if (!hasMember) messages.add("missing implementation: PyEval_RestoreThread");
        hasMember = reallyHasMember(capiLibrary, "PyEval_SaveThread");
        if (!hasMember) messages.add("missing implementation: PyEval_SaveThread");
        hasMember = reallyHasMember(capiLibrary, "PyEval_SetProfile");
        if (!hasMember) messages.add("missing implementation: PyEval_SetProfile");
        hasMember = reallyHasMember(capiLibrary, "PyEval_SetProfileAllThreads");
        if (!hasMember) messages.add("missing implementation: PyEval_SetProfileAllThreads");
        hasMember = reallyHasMember(capiLibrary, "PyEval_SetTrace");
        if (!hasMember) messages.add("missing implementation: PyEval_SetTrace");
        hasMember = reallyHasMember(capiLibrary, "PyEval_SetTraceAllThreads");
        if (!hasMember) messages.add("missing implementation: PyEval_SetTraceAllThreads");
        hasMember = reallyHasMember(capiLibrary, "PyEval_ThreadsInitialized");
        if (!hasMember) messages.add("missing implementation: PyEval_ThreadsInitialized");
        hasMember = reallyHasMember(capiLibrary, "PyExceptionClass_Name");
        if (!hasMember) messages.add("missing implementation: PyExceptionClass_Name");
        hasMember = reallyHasMember(capiLibrary, "PyException_GetArgs");
        if (!hasMember) messages.add("missing implementation: PyException_GetArgs");
        hasMember = reallyHasMember(capiLibrary, "PyException_GetCause");
        if (!hasMember) messages.add("missing implementation: PyException_GetCause");
        hasMember = reallyHasMember(capiLibrary, "PyException_GetContext");
        if (!hasMember) messages.add("missing implementation: PyException_GetContext");
        hasMember = reallyHasMember(capiLibrary, "PyException_GetTraceback");
        if (!hasMember) messages.add("missing implementation: PyException_GetTraceback");
        hasMember = reallyHasMember(capiLibrary, "PyException_SetArgs");
        if (!hasMember) messages.add("missing implementation: PyException_SetArgs");
        hasMember = reallyHasMember(capiLibrary, "PyException_SetCause");
        if (!hasMember) messages.add("missing implementation: PyException_SetCause");
        hasMember = reallyHasMember(capiLibrary, "PyException_SetContext");
        if (!hasMember) messages.add("missing implementation: PyException_SetContext");
        hasMember = reallyHasMember(capiLibrary, "PyException_SetTraceback");
        if (!hasMember) messages.add("missing implementation: PyException_SetTraceback");
        hasMember = reallyHasMember(capiLibrary, "PyFile_FromFd");
        if (!hasMember) messages.add("missing implementation: PyFile_FromFd");
        hasMember = reallyHasMember(capiLibrary, "PyFile_GetLine");
        if (!hasMember) messages.add("missing implementation: PyFile_GetLine");
        hasMember = reallyHasMember(capiLibrary, "PyFile_NewStdPrinter");
        if (!hasMember) messages.add("missing implementation: PyFile_NewStdPrinter");
        hasMember = reallyHasMember(capiLibrary, "PyFile_OpenCode");
        if (!hasMember) messages.add("missing implementation: PyFile_OpenCode");
        hasMember = reallyHasMember(capiLibrary, "PyFile_OpenCodeObject");
        if (!hasMember) messages.add("missing implementation: PyFile_OpenCodeObject");
        hasMember = reallyHasMember(capiLibrary, "PyFile_SetOpenCodeHook");
        if (!hasMember) messages.add("missing implementation: PyFile_SetOpenCodeHook");
        hasMember = reallyHasMember(capiLibrary, "PyFile_WriteObject");
        if (!hasMember) messages.add("missing implementation: PyFile_WriteObject");
        hasMember = reallyHasMember(capiLibrary, "PyFile_WriteString");
        if (!hasMember) messages.add("missing implementation: PyFile_WriteString");
        hasMember = reallyHasMember(capiLibrary, "PyFloat_AsDouble");
        if (!hasMember) messages.add("missing implementation: PyFloat_AsDouble");
        hasMember = reallyHasMember(capiLibrary, "PyFloat_FromDouble");
        if (!hasMember) messages.add("missing implementation: PyFloat_FromDouble");
        hasMember = reallyHasMember(capiLibrary, "PyFloat_FromString");
        if (!hasMember) messages.add("missing implementation: PyFloat_FromString");
        hasMember = reallyHasMember(capiLibrary, "PyFloat_GetInfo");
        if (!hasMember) messages.add("missing implementation: PyFloat_GetInfo");
        hasMember = reallyHasMember(capiLibrary, "PyFloat_GetMax");
        if (!hasMember) messages.add("missing implementation: PyFloat_GetMax");
        hasMember = reallyHasMember(capiLibrary, "PyFloat_GetMin");
        if (!hasMember) messages.add("missing implementation: PyFloat_GetMin");
        hasMember = reallyHasMember(capiLibrary, "PyFloat_Pack2");
        if (!hasMember) messages.add("missing implementation: PyFloat_Pack2");
        hasMember = reallyHasMember(capiLibrary, "PyFloat_Pack4");
        if (!hasMember) messages.add("missing implementation: PyFloat_Pack4");
        hasMember = reallyHasMember(capiLibrary, "PyFloat_Pack8");
        if (!hasMember) messages.add("missing implementation: PyFloat_Pack8");
        hasMember = reallyHasMember(capiLibrary, "PyFloat_Unpack2");
        if (!hasMember) messages.add("missing implementation: PyFloat_Unpack2");
        hasMember = reallyHasMember(capiLibrary, "PyFloat_Unpack4");
        if (!hasMember) messages.add("missing implementation: PyFloat_Unpack4");
        hasMember = reallyHasMember(capiLibrary, "PyFloat_Unpack8");
        if (!hasMember) messages.add("missing implementation: PyFloat_Unpack8");
        hasMember = reallyHasMember(capiLibrary, "PyFrame_FastToLocals");
        if (!hasMember) messages.add("missing implementation: PyFrame_FastToLocals");
        hasMember = reallyHasMember(capiLibrary, "PyFrame_FastToLocalsWithError");
        if (!hasMember) messages.add("missing implementation: PyFrame_FastToLocalsWithError");
        hasMember = reallyHasMember(capiLibrary, "PyFrame_GetBack");
        if (!hasMember) messages.add("missing implementation: PyFrame_GetBack");
        hasMember = reallyHasMember(capiLibrary, "PyFrame_GetBuiltins");
        if (!hasMember) messages.add("missing implementation: PyFrame_GetBuiltins");
        hasMember = reallyHasMember(capiLibrary, "PyFrame_GetCode");
        if (!hasMember) messages.add("missing implementation: PyFrame_GetCode");
        hasMember = reallyHasMember(capiLibrary, "PyFrame_GetGenerator");
        if (!hasMember) messages.add("missing implementation: PyFrame_GetGenerator");
        hasMember = reallyHasMember(capiLibrary, "PyFrame_GetGlobals");
        if (!hasMember) messages.add("missing implementation: PyFrame_GetGlobals");
        hasMember = reallyHasMember(capiLibrary, "PyFrame_GetLasti");
        if (!hasMember) messages.add("missing implementation: PyFrame_GetLasti");
        hasMember = reallyHasMember(capiLibrary, "PyFrame_GetLineNumber");
        if (!hasMember) messages.add("missing implementation: PyFrame_GetLineNumber");
        hasMember = reallyHasMember(capiLibrary, "PyFrame_GetLocals");
        if (!hasMember) messages.add("missing implementation: PyFrame_GetLocals");
        hasMember = reallyHasMember(capiLibrary, "PyFrame_GetVar");
        if (!hasMember) messages.add("missing implementation: PyFrame_GetVar");
        hasMember = reallyHasMember(capiLibrary, "PyFrame_GetVarString");
        if (!hasMember) messages.add("missing implementation: PyFrame_GetVarString");
        hasMember = reallyHasMember(capiLibrary, "PyFrame_LocalsToFast");
        if (!hasMember) messages.add("missing implementation: PyFrame_LocalsToFast");
        hasMember = reallyHasMember(capiLibrary, "PyFrame_New");
        if (!hasMember) messages.add("missing implementation: PyFrame_New");
        hasMember = reallyHasMember(capiLibrary, "PyFrozenSet_New");
        if (!hasMember) messages.add("missing implementation: PyFrozenSet_New");
        hasMember = reallyHasMember(capiLibrary, "PyFunction_AddWatcher");
        if (!hasMember) messages.add("missing implementation: PyFunction_AddWatcher");
        hasMember = reallyHasMember(capiLibrary, "PyFunction_ClearWatcher");
        if (!hasMember) messages.add("missing implementation: PyFunction_ClearWatcher");
        hasMember = reallyHasMember(capiLibrary, "PyFunction_GetAnnotations");
        if (!hasMember) messages.add("missing implementation: PyFunction_GetAnnotations");
        hasMember = reallyHasMember(capiLibrary, "PyFunction_GetClosure");
        if (!hasMember) messages.add("missing implementation: PyFunction_GetClosure");
        hasMember = reallyHasMember(capiLibrary, "PyFunction_GetCode");
        if (!hasMember) messages.add("missing implementation: PyFunction_GetCode");
        hasMember = reallyHasMember(capiLibrary, "PyFunction_GetDefaults");
        if (!hasMember) messages.add("missing implementation: PyFunction_GetDefaults");
        hasMember = reallyHasMember(capiLibrary, "PyFunction_GetGlobals");
        if (!hasMember) messages.add("missing implementation: PyFunction_GetGlobals");
        hasMember = reallyHasMember(capiLibrary, "PyFunction_GetKwDefaults");
        if (!hasMember) messages.add("missing implementation: PyFunction_GetKwDefaults");
        hasMember = reallyHasMember(capiLibrary, "PyFunction_GetModule");
        if (!hasMember) messages.add("missing implementation: PyFunction_GetModule");
        hasMember = reallyHasMember(capiLibrary, "PyFunction_New");
        if (!hasMember) messages.add("missing implementation: PyFunction_New");
        hasMember = reallyHasMember(capiLibrary, "PyFunction_NewWithQualName");
        if (!hasMember) messages.add("missing implementation: PyFunction_NewWithQualName");
        hasMember = reallyHasMember(capiLibrary, "PyFunction_SetAnnotations");
        if (!hasMember) messages.add("missing implementation: PyFunction_SetAnnotations");
        hasMember = reallyHasMember(capiLibrary, "PyFunction_SetClosure");
        if (!hasMember) messages.add("missing implementation: PyFunction_SetClosure");
        hasMember = reallyHasMember(capiLibrary, "PyFunction_SetDefaults");
        if (!hasMember) messages.add("missing implementation: PyFunction_SetDefaults");
        hasMember = reallyHasMember(capiLibrary, "PyFunction_SetKwDefaults");
        if (!hasMember) messages.add("missing implementation: PyFunction_SetKwDefaults");
        hasMember = reallyHasMember(capiLibrary, "PyFunction_SetVectorcall");
        if (!hasMember) messages.add("missing implementation: PyFunction_SetVectorcall");
        hasMember = reallyHasMember(capiLibrary, "PyGC_Collect");
        if (!hasMember) messages.add("missing implementation: PyGC_Collect");
        hasMember = reallyHasMember(capiLibrary, "PyGC_Disable");
        if (!hasMember) messages.add("missing implementation: PyGC_Disable");
        hasMember = reallyHasMember(capiLibrary, "PyGC_Enable");
        if (!hasMember) messages.add("missing implementation: PyGC_Enable");
        hasMember = reallyHasMember(capiLibrary, "PyGC_IsEnabled");
        if (!hasMember) messages.add("missing implementation: PyGC_IsEnabled");
        hasMember = reallyHasMember(capiLibrary, "PyGILState_Check");
        if (!hasMember) messages.add("missing implementation: PyGILState_Check");
        hasMember = reallyHasMember(capiLibrary, "PyGILState_Ensure");
        if (!hasMember) messages.add("missing implementation: PyGILState_Ensure");
        hasMember = reallyHasMember(capiLibrary, "PyGILState_GetThisThreadState");
        if (!hasMember) messages.add("missing implementation: PyGILState_GetThisThreadState");
        hasMember = reallyHasMember(capiLibrary, "PyGILState_Release");
        if (!hasMember) messages.add("missing implementation: PyGILState_Release");
        hasMember = reallyHasMember(capiLibrary, "PyGen_GetCode");
        if (!hasMember) messages.add("missing implementation: PyGen_GetCode");
        hasMember = reallyHasMember(capiLibrary, "PyGen_New");
        if (!hasMember) messages.add("missing implementation: PyGen_New");
        hasMember = reallyHasMember(capiLibrary, "PyGen_NewWithQualName");
        if (!hasMember) messages.add("missing implementation: PyGen_NewWithQualName");
        hasMember = reallyHasMember(capiLibrary, "PyHash_GetFuncDef");
        hasMember = reallyHasMember(capiLibrary, "PyImport_AddModule");
        if (!hasMember) messages.add("missing implementation: PyImport_AddModule");
        hasMember = reallyHasMember(capiLibrary, "PyImport_AddModuleObject");
        if (!hasMember) messages.add("missing implementation: PyImport_AddModuleObject");
        hasMember = reallyHasMember(capiLibrary, "PyImport_AppendInittab");
        if (!hasMember) messages.add("missing implementation: PyImport_AppendInittab");
        hasMember = reallyHasMember(capiLibrary, "PyImport_ExecCodeModule");
        if (!hasMember) messages.add("missing implementation: PyImport_ExecCodeModule");
        hasMember = reallyHasMember(capiLibrary, "PyImport_ExecCodeModuleEx");
        if (!hasMember) messages.add("missing implementation: PyImport_ExecCodeModuleEx");
        hasMember = reallyHasMember(capiLibrary, "PyImport_ExecCodeModuleObject");
        if (!hasMember) messages.add("missing implementation: PyImport_ExecCodeModuleObject");
        hasMember = reallyHasMember(capiLibrary, "PyImport_ExecCodeModuleWithPathnames");
        if (!hasMember) messages.add("missing implementation: PyImport_ExecCodeModuleWithPathnames");
        hasMember = reallyHasMember(capiLibrary, "PyImport_ExtendInittab");
        if (!hasMember) messages.add("missing implementation: PyImport_ExtendInittab");
        hasMember = reallyHasMember(capiLibrary, "PyImport_GetImporter");
        if (!hasMember) messages.add("missing implementation: PyImport_GetImporter");
        hasMember = reallyHasMember(capiLibrary, "PyImport_GetMagicNumber");
        if (!hasMember) messages.add("missing implementation: PyImport_GetMagicNumber");
        hasMember = reallyHasMember(capiLibrary, "PyImport_GetMagicTag");
        if (!hasMember) messages.add("missing implementation: PyImport_GetMagicTag");
        hasMember = reallyHasMember(capiLibrary, "PyImport_GetModule");
        if (!hasMember) messages.add("missing implementation: PyImport_GetModule");
        hasMember = reallyHasMember(capiLibrary, "PyImport_GetModuleDict");
        if (!hasMember) messages.add("missing implementation: PyImport_GetModuleDict");
        hasMember = reallyHasMember(capiLibrary, "PyImport_Import");
        if (!hasMember) messages.add("missing implementation: PyImport_Import");
        hasMember = reallyHasMember(capiLibrary, "PyImport_ImportFrozenModule");
        if (!hasMember) messages.add("missing implementation: PyImport_ImportFrozenModule");
        hasMember = reallyHasMember(capiLibrary, "PyImport_ImportFrozenModuleObject");
        if (!hasMember) messages.add("missing implementation: PyImport_ImportFrozenModuleObject");
        hasMember = reallyHasMember(capiLibrary, "PyImport_ImportModule");
        if (!hasMember) messages.add("missing implementation: PyImport_ImportModule");
        hasMember = reallyHasMember(capiLibrary, "PyImport_ImportModuleLevel");
        if (!hasMember) messages.add("missing implementation: PyImport_ImportModuleLevel");
        hasMember = reallyHasMember(capiLibrary, "PyImport_ImportModuleLevelObject");
        if (!hasMember) messages.add("missing implementation: PyImport_ImportModuleLevelObject");
        hasMember = reallyHasMember(capiLibrary, "PyImport_ImportModuleNoBlock");
        if (!hasMember) messages.add("missing implementation: PyImport_ImportModuleNoBlock");
        hasMember = reallyHasMember(capiLibrary, "PyImport_ReloadModule");
        if (!hasMember) messages.add("missing implementation: PyImport_ReloadModule");
        hasMember = reallyHasMember(capiLibrary, "PyIndex_Check");
        if (!hasMember) messages.add("missing implementation: PyIndex_Check");
        hasMember = reallyHasMember(capiLibrary, "PyInit__imp");
        hasMember = reallyHasMember(capiLibrary, "PyInstanceMethod_Function");
        if (!hasMember) messages.add("missing implementation: PyInstanceMethod_Function");
        hasMember = reallyHasMember(capiLibrary, "PyInstanceMethod_New");
        if (!hasMember) messages.add("missing implementation: PyInstanceMethod_New");
        hasMember = reallyHasMember(capiLibrary, "PyInterpreterState_Clear");
        if (!hasMember) messages.add("missing implementation: PyInterpreterState_Clear");
        hasMember = reallyHasMember(capiLibrary, "PyInterpreterState_Delete");
        if (!hasMember) messages.add("missing implementation: PyInterpreterState_Delete");
        hasMember = reallyHasMember(capiLibrary, "PyInterpreterState_Get");
        if (!hasMember) messages.add("missing implementation: PyInterpreterState_Get");
        hasMember = reallyHasMember(capiLibrary, "PyInterpreterState_GetDict");
        if (!hasMember) messages.add("missing implementation: PyInterpreterState_GetDict");
        hasMember = reallyHasMember(capiLibrary, "PyInterpreterState_GetID");
        if (!hasMember) messages.add("missing implementation: PyInterpreterState_GetID");
        hasMember = reallyHasMember(capiLibrary, "PyInterpreterState_Head");
        if (!hasMember) messages.add("missing implementation: PyInterpreterState_Head");
        hasMember = reallyHasMember(capiLibrary, "PyInterpreterState_Main");
        if (!hasMember) messages.add("missing implementation: PyInterpreterState_Main");
        hasMember = reallyHasMember(capiLibrary, "PyInterpreterState_New");
        if (!hasMember) messages.add("missing implementation: PyInterpreterState_New");
        hasMember = reallyHasMember(capiLibrary, "PyInterpreterState_Next");
        if (!hasMember) messages.add("missing implementation: PyInterpreterState_Next");
        hasMember = reallyHasMember(capiLibrary, "PyInterpreterState_ThreadHead");
        if (!hasMember) messages.add("missing implementation: PyInterpreterState_ThreadHead");
        hasMember = reallyHasMember(capiLibrary, "PyIter_Check");
        if (!hasMember) messages.add("missing implementation: PyIter_Check");
        hasMember = reallyHasMember(capiLibrary, "PyIter_Next");
        if (!hasMember) messages.add("missing implementation: PyIter_Next");
        hasMember = reallyHasMember(capiLibrary, "PyIter_Send");
        if (!hasMember) messages.add("missing implementation: PyIter_Send");
        hasMember = reallyHasMember(capiLibrary, "PyList_Append");
        if (!hasMember) messages.add("missing implementation: PyList_Append");
        hasMember = reallyHasMember(capiLibrary, "PyList_AsTuple");
        if (!hasMember) messages.add("missing implementation: PyList_AsTuple");
        hasMember = reallyHasMember(capiLibrary, "PyList_GetItem");
        if (!hasMember) messages.add("missing implementation: PyList_GetItem");
        hasMember = reallyHasMember(capiLibrary, "PyList_GetSlice");
        if (!hasMember) messages.add("missing implementation: PyList_GetSlice");
        hasMember = reallyHasMember(capiLibrary, "PyList_Insert");
        if (!hasMember) messages.add("missing implementation: PyList_Insert");
        hasMember = reallyHasMember(capiLibrary, "PyList_New");
        if (!hasMember) messages.add("missing implementation: PyList_New");
        hasMember = reallyHasMember(capiLibrary, "PyList_Reverse");
        if (!hasMember) messages.add("missing implementation: PyList_Reverse");
        hasMember = reallyHasMember(capiLibrary, "PyList_SetItem");
        if (!hasMember) messages.add("missing implementation: PyList_SetItem");
        hasMember = reallyHasMember(capiLibrary, "PyList_SetSlice");
        if (!hasMember) messages.add("missing implementation: PyList_SetSlice");
        hasMember = reallyHasMember(capiLibrary, "PyList_Size");
        if (!hasMember) messages.add("missing implementation: PyList_Size");
        hasMember = reallyHasMember(capiLibrary, "PyList_Sort");
        if (!hasMember) messages.add("missing implementation: PyList_Sort");
        hasMember = reallyHasMember(capiLibrary, "PyLong_AsDouble");
        if (!hasMember) messages.add("missing implementation: PyLong_AsDouble");
        hasMember = reallyHasMember(capiLibrary, "PyLong_AsLong");
        if (!hasMember) messages.add("missing implementation: PyLong_AsLong");
        hasMember = reallyHasMember(capiLibrary, "PyLong_AsLongAndOverflow");
        if (!hasMember) messages.add("missing implementation: PyLong_AsLongAndOverflow");
        hasMember = reallyHasMember(capiLibrary, "PyLong_AsLongLong");
        if (!hasMember) messages.add("missing implementation: PyLong_AsLongLong");
        hasMember = reallyHasMember(capiLibrary, "PyLong_AsLongLongAndOverflow");
        if (!hasMember) messages.add("missing implementation: PyLong_AsLongLongAndOverflow");
        hasMember = reallyHasMember(capiLibrary, "PyLong_AsSize_t");
        if (!hasMember) messages.add("missing implementation: PyLong_AsSize_t");
        hasMember = reallyHasMember(capiLibrary, "PyLong_AsSsize_t");
        if (!hasMember) messages.add("missing implementation: PyLong_AsSsize_t");
        hasMember = reallyHasMember(capiLibrary, "PyLong_AsUnsignedLong");
        if (!hasMember) messages.add("missing implementation: PyLong_AsUnsignedLong");
        hasMember = reallyHasMember(capiLibrary, "PyLong_AsUnsignedLongLong");
        if (!hasMember) messages.add("missing implementation: PyLong_AsUnsignedLongLong");
        hasMember = reallyHasMember(capiLibrary, "PyLong_AsUnsignedLongLongMask");
        if (!hasMember) messages.add("missing implementation: PyLong_AsUnsignedLongLongMask");
        hasMember = reallyHasMember(capiLibrary, "PyLong_AsUnsignedLongMask");
        if (!hasMember) messages.add("missing implementation: PyLong_AsUnsignedLongMask");
        hasMember = reallyHasMember(capiLibrary, "PyLong_AsVoidPtr");
        if (!hasMember) messages.add("missing implementation: PyLong_AsVoidPtr");
        hasMember = reallyHasMember(capiLibrary, "PyLong_FromDouble");
        if (!hasMember) messages.add("missing implementation: PyLong_FromDouble");
        hasMember = reallyHasMember(capiLibrary, "PyLong_FromLong");
        if (!hasMember) messages.add("missing implementation: PyLong_FromLong");
        hasMember = reallyHasMember(capiLibrary, "PyLong_FromLongLong");
        if (!hasMember) messages.add("missing implementation: PyLong_FromLongLong");
        hasMember = reallyHasMember(capiLibrary, "PyLong_FromSize_t");
        if (!hasMember) messages.add("missing implementation: PyLong_FromSize_t");
        hasMember = reallyHasMember(capiLibrary, "PyLong_FromSsize_t");
        if (!hasMember) messages.add("missing implementation: PyLong_FromSsize_t");
        hasMember = reallyHasMember(capiLibrary, "PyLong_FromString");
        if (!hasMember) messages.add("missing implementation: PyLong_FromString");
        hasMember = reallyHasMember(capiLibrary, "PyLong_FromUnicodeObject");
        if (!hasMember) messages.add("missing implementation: PyLong_FromUnicodeObject");
        hasMember = reallyHasMember(capiLibrary, "PyLong_FromUnsignedLong");
        if (!hasMember) messages.add("missing implementation: PyLong_FromUnsignedLong");
        hasMember = reallyHasMember(capiLibrary, "PyLong_FromUnsignedLongLong");
        if (!hasMember) messages.add("missing implementation: PyLong_FromUnsignedLongLong");
        hasMember = reallyHasMember(capiLibrary, "PyLong_FromVoidPtr");
        if (!hasMember) messages.add("missing implementation: PyLong_FromVoidPtr");
        hasMember = reallyHasMember(capiLibrary, "PyLong_GetInfo");
        if (!hasMember) messages.add("missing implementation: PyLong_GetInfo");
        hasMember = reallyHasMember(capiLibrary, "PyMapping_Check");
        if (!hasMember) messages.add("missing implementation: PyMapping_Check");
        hasMember = reallyHasMember(capiLibrary, "PyMapping_GetItemString");
        if (!hasMember) messages.add("missing implementation: PyMapping_GetItemString");
        hasMember = reallyHasMember(capiLibrary, "PyMapping_HasKey");
        if (!hasMember) messages.add("missing implementation: PyMapping_HasKey");
        hasMember = reallyHasMember(capiLibrary, "PyMapping_HasKeyString");
        if (!hasMember) messages.add("missing implementation: PyMapping_HasKeyString");
        hasMember = reallyHasMember(capiLibrary, "PyMapping_Items");
        if (!hasMember) messages.add("missing implementation: PyMapping_Items");
        hasMember = reallyHasMember(capiLibrary, "PyMapping_Keys");
        if (!hasMember) messages.add("missing implementation: PyMapping_Keys");
        hasMember = reallyHasMember(capiLibrary, "PyMapping_Length");
        if (!hasMember) messages.add("missing implementation: PyMapping_Length");
        hasMember = reallyHasMember(capiLibrary, "PyMapping_SetItemString");
        if (!hasMember) messages.add("missing implementation: PyMapping_SetItemString");
        hasMember = reallyHasMember(capiLibrary, "PyMapping_Size");
        if (!hasMember) messages.add("missing implementation: PyMapping_Size");
        hasMember = reallyHasMember(capiLibrary, "PyMapping_Values");
        if (!hasMember) messages.add("missing implementation: PyMapping_Values");
        hasMember = reallyHasMember(capiLibrary, "PyMarshal_ReadLastObjectFromFile");
        if (!hasMember) messages.add("missing implementation: PyMarshal_ReadLastObjectFromFile");
        hasMember = reallyHasMember(capiLibrary, "PyMarshal_ReadLongFromFile");
        if (!hasMember) messages.add("missing implementation: PyMarshal_ReadLongFromFile");
        hasMember = reallyHasMember(capiLibrary, "PyMarshal_ReadObjectFromFile");
        if (!hasMember) messages.add("missing implementation: PyMarshal_ReadObjectFromFile");
        hasMember = reallyHasMember(capiLibrary, "PyMarshal_ReadObjectFromString");
        if (!hasMember) messages.add("missing implementation: PyMarshal_ReadObjectFromString");
        hasMember = reallyHasMember(capiLibrary, "PyMarshal_ReadShortFromFile");
        if (!hasMember) messages.add("missing implementation: PyMarshal_ReadShortFromFile");
        hasMember = reallyHasMember(capiLibrary, "PyMarshal_WriteLongToFile");
        if (!hasMember) messages.add("missing implementation: PyMarshal_WriteLongToFile");
        hasMember = reallyHasMember(capiLibrary, "PyMarshal_WriteObjectToFile");
        if (!hasMember) messages.add("missing implementation: PyMarshal_WriteObjectToFile");
        hasMember = reallyHasMember(capiLibrary, "PyMarshal_WriteObjectToString");
        if (!hasMember) messages.add("missing implementation: PyMarshal_WriteObjectToString");
        hasMember = reallyHasMember(capiLibrary, "PyMem_Calloc");
        if (!hasMember) messages.add("missing implementation: PyMem_Calloc");
        hasMember = reallyHasMember(capiLibrary, "PyMem_Free");
        if (!hasMember) messages.add("missing implementation: PyMem_Free");
        hasMember = reallyHasMember(capiLibrary, "PyMem_GetAllocator");
        if (!hasMember) messages.add("missing implementation: PyMem_GetAllocator");
        hasMember = reallyHasMember(capiLibrary, "PyMem_Malloc");
        if (!hasMember) messages.add("missing implementation: PyMem_Malloc");
        hasMember = reallyHasMember(capiLibrary, "PyMem_RawCalloc");
        if (!hasMember) messages.add("missing implementation: PyMem_RawCalloc");
        hasMember = reallyHasMember(capiLibrary, "PyMem_RawFree");
        if (!hasMember) messages.add("missing implementation: PyMem_RawFree");
        hasMember = reallyHasMember(capiLibrary, "PyMem_RawMalloc");
        if (!hasMember) messages.add("missing implementation: PyMem_RawMalloc");
        hasMember = reallyHasMember(capiLibrary, "PyMem_RawRealloc");
        if (!hasMember) messages.add("missing implementation: PyMem_RawRealloc");
        hasMember = reallyHasMember(capiLibrary, "PyMem_Realloc");
        if (!hasMember) messages.add("missing implementation: PyMem_Realloc");
        hasMember = reallyHasMember(capiLibrary, "PyMem_SetAllocator");
        if (!hasMember) messages.add("missing implementation: PyMem_SetAllocator");
        hasMember = reallyHasMember(capiLibrary, "PyMem_SetupDebugHooks");
        if (!hasMember) messages.add("missing implementation: PyMem_SetupDebugHooks");
        hasMember = reallyHasMember(capiLibrary, "PyMember_GetOne");
        if (!hasMember) messages.add("missing implementation: PyMember_GetOne");
        hasMember = reallyHasMember(capiLibrary, "PyMember_SetOne");
        if (!hasMember) messages.add("missing implementation: PyMember_SetOne");
        hasMember = reallyHasMember(capiLibrary, "PyMemoryView_FromBuffer");
        if (!hasMember) messages.add("missing implementation: PyMemoryView_FromBuffer");
        hasMember = reallyHasMember(capiLibrary, "PyMemoryView_FromMemory");
        if (!hasMember) messages.add("missing implementation: PyMemoryView_FromMemory");
        hasMember = reallyHasMember(capiLibrary, "PyMemoryView_FromObject");
        if (!hasMember) messages.add("missing implementation: PyMemoryView_FromObject");
        hasMember = reallyHasMember(capiLibrary, "PyMemoryView_GetContiguous");
        if (!hasMember) messages.add("missing implementation: PyMemoryView_GetContiguous");
        hasMember = reallyHasMember(capiLibrary, "PyMethod_Function");
        if (!hasMember) messages.add("missing implementation: PyMethod_Function");
        hasMember = reallyHasMember(capiLibrary, "PyMethod_New");
        if (!hasMember) messages.add("missing implementation: PyMethod_New");
        hasMember = reallyHasMember(capiLibrary, "PyMethod_Self");
        if (!hasMember) messages.add("missing implementation: PyMethod_Self");
        hasMember = reallyHasMember(capiLibrary, "PyModuleDef_Init");
        if (!hasMember) messages.add("missing implementation: PyModuleDef_Init");
        hasMember = reallyHasMember(capiLibrary, "PyModule_AddFunctions");
        if (!hasMember) messages.add("missing implementation: PyModule_AddFunctions");
        hasMember = reallyHasMember(capiLibrary, "PyModule_AddIntConstant");
        if (!hasMember) messages.add("missing implementation: PyModule_AddIntConstant");
        hasMember = reallyHasMember(capiLibrary, "PyModule_AddObject");
        if (!hasMember) messages.add("missing implementation: PyModule_AddObject");
        hasMember = reallyHasMember(capiLibrary, "PyModule_AddObjectRef");
        if (!hasMember) messages.add("missing implementation: PyModule_AddObjectRef");
        hasMember = reallyHasMember(capiLibrary, "PyModule_AddStringConstant");
        if (!hasMember) messages.add("missing implementation: PyModule_AddStringConstant");
        hasMember = reallyHasMember(capiLibrary, "PyModule_AddType");
        if (!hasMember) messages.add("missing implementation: PyModule_AddType");
        hasMember = reallyHasMember(capiLibrary, "PyModule_Create2");
        if (!hasMember) messages.add("missing implementation: PyModule_Create2");
        hasMember = reallyHasMember(capiLibrary, "PyModule_ExecDef");
        if (!hasMember) messages.add("missing implementation: PyModule_ExecDef");
        hasMember = reallyHasMember(capiLibrary, "PyModule_FromDefAndSpec2");
        if (!hasMember) messages.add("missing implementation: PyModule_FromDefAndSpec2");
        hasMember = reallyHasMember(capiLibrary, "PyModule_GetDef");
        if (!hasMember) messages.add("missing implementation: PyModule_GetDef");
        hasMember = reallyHasMember(capiLibrary, "PyModule_GetDict");
        if (!hasMember) messages.add("missing implementation: PyModule_GetDict");
        hasMember = reallyHasMember(capiLibrary, "PyModule_GetFilename");
        if (!hasMember) messages.add("missing implementation: PyModule_GetFilename");
        hasMember = reallyHasMember(capiLibrary, "PyModule_GetFilenameObject");
        if (!hasMember) messages.add("missing implementation: PyModule_GetFilenameObject");
        hasMember = reallyHasMember(capiLibrary, "PyModule_GetName");
        if (!hasMember) messages.add("missing implementation: PyModule_GetName");
        hasMember = reallyHasMember(capiLibrary, "PyModule_GetNameObject");
        if (!hasMember) messages.add("missing implementation: PyModule_GetNameObject");
        hasMember = reallyHasMember(capiLibrary, "PyModule_GetState");
        if (!hasMember) messages.add("missing implementation: PyModule_GetState");
        hasMember = reallyHasMember(capiLibrary, "PyModule_New");
        if (!hasMember) messages.add("missing implementation: PyModule_New");
        hasMember = reallyHasMember(capiLibrary, "PyModule_NewObject");
        if (!hasMember) messages.add("missing implementation: PyModule_NewObject");
        hasMember = reallyHasMember(capiLibrary, "PyModule_SetDocString");
        if (!hasMember) messages.add("missing implementation: PyModule_SetDocString");
        hasMember = reallyHasMember(capiLibrary, "PyNumber_Absolute");
        if (!hasMember) messages.add("missing implementation: PyNumber_Absolute");
        hasMember = reallyHasMember(capiLibrary, "PyNumber_Add");
        if (!hasMember) messages.add("missing implementation: PyNumber_Add");
        hasMember = reallyHasMember(capiLibrary, "PyNumber_And");
        if (!hasMember) messages.add("missing implementation: PyNumber_And");
        hasMember = reallyHasMember(capiLibrary, "PyNumber_AsSsize_t");
        if (!hasMember) messages.add("missing implementation: PyNumber_AsSsize_t");
        hasMember = reallyHasMember(capiLibrary, "PyNumber_Check");
        if (!hasMember) messages.add("missing implementation: PyNumber_Check");
        hasMember = reallyHasMember(capiLibrary, "PyNumber_Divmod");
        if (!hasMember) messages.add("missing implementation: PyNumber_Divmod");
        hasMember = reallyHasMember(capiLibrary, "PyNumber_Float");
        if (!hasMember) messages.add("missing implementation: PyNumber_Float");
        hasMember = reallyHasMember(capiLibrary, "PyNumber_FloorDivide");
        if (!hasMember) messages.add("missing implementation: PyNumber_FloorDivide");
        hasMember = reallyHasMember(capiLibrary, "PyNumber_InPlaceAdd");
        if (!hasMember) messages.add("missing implementation: PyNumber_InPlaceAdd");
        hasMember = reallyHasMember(capiLibrary, "PyNumber_InPlaceAnd");
        if (!hasMember) messages.add("missing implementation: PyNumber_InPlaceAnd");
        hasMember = reallyHasMember(capiLibrary, "PyNumber_InPlaceFloorDivide");
        if (!hasMember) messages.add("missing implementation: PyNumber_InPlaceFloorDivide");
        hasMember = reallyHasMember(capiLibrary, "PyNumber_InPlaceLshift");
        if (!hasMember) messages.add("missing implementation: PyNumber_InPlaceLshift");
        hasMember = reallyHasMember(capiLibrary, "PyNumber_InPlaceMatrixMultiply");
        if (!hasMember) messages.add("missing implementation: PyNumber_InPlaceMatrixMultiply");
        hasMember = reallyHasMember(capiLibrary, "PyNumber_InPlaceMultiply");
        if (!hasMember) messages.add("missing implementation: PyNumber_InPlaceMultiply");
        hasMember = reallyHasMember(capiLibrary, "PyNumber_InPlaceOr");
        if (!hasMember) messages.add("missing implementation: PyNumber_InPlaceOr");
        hasMember = reallyHasMember(capiLibrary, "PyNumber_InPlacePower");
        if (!hasMember) messages.add("missing implementation: PyNumber_InPlacePower");
        hasMember = reallyHasMember(capiLibrary, "PyNumber_InPlaceRemainder");
        if (!hasMember) messages.add("missing implementation: PyNumber_InPlaceRemainder");
        hasMember = reallyHasMember(capiLibrary, "PyNumber_InPlaceRshift");
        if (!hasMember) messages.add("missing implementation: PyNumber_InPlaceRshift");
        hasMember = reallyHasMember(capiLibrary, "PyNumber_InPlaceSubtract");
        if (!hasMember) messages.add("missing implementation: PyNumber_InPlaceSubtract");
        hasMember = reallyHasMember(capiLibrary, "PyNumber_InPlaceTrueDivide");
        if (!hasMember) messages.add("missing implementation: PyNumber_InPlaceTrueDivide");
        hasMember = reallyHasMember(capiLibrary, "PyNumber_InPlaceXor");
        if (!hasMember) messages.add("missing implementation: PyNumber_InPlaceXor");
        hasMember = reallyHasMember(capiLibrary, "PyNumber_Index");
        if (!hasMember) messages.add("missing implementation: PyNumber_Index");
        hasMember = reallyHasMember(capiLibrary, "PyNumber_Invert");
        if (!hasMember) messages.add("missing implementation: PyNumber_Invert");
        hasMember = reallyHasMember(capiLibrary, "PyNumber_Long");
        if (!hasMember) messages.add("missing implementation: PyNumber_Long");
        hasMember = reallyHasMember(capiLibrary, "PyNumber_Lshift");
        if (!hasMember) messages.add("missing implementation: PyNumber_Lshift");
        hasMember = reallyHasMember(capiLibrary, "PyNumber_MatrixMultiply");
        if (!hasMember) messages.add("missing implementation: PyNumber_MatrixMultiply");
        hasMember = reallyHasMember(capiLibrary, "PyNumber_Multiply");
        if (!hasMember) messages.add("missing implementation: PyNumber_Multiply");
        hasMember = reallyHasMember(capiLibrary, "PyNumber_Negative");
        if (!hasMember) messages.add("missing implementation: PyNumber_Negative");
        hasMember = reallyHasMember(capiLibrary, "PyNumber_Or");
        if (!hasMember) messages.add("missing implementation: PyNumber_Or");
        hasMember = reallyHasMember(capiLibrary, "PyNumber_Positive");
        if (!hasMember) messages.add("missing implementation: PyNumber_Positive");
        hasMember = reallyHasMember(capiLibrary, "PyNumber_Power");
        if (!hasMember) messages.add("missing implementation: PyNumber_Power");
        hasMember = reallyHasMember(capiLibrary, "PyNumber_Remainder");
        if (!hasMember) messages.add("missing implementation: PyNumber_Remainder");
        hasMember = reallyHasMember(capiLibrary, "PyNumber_Rshift");
        if (!hasMember) messages.add("missing implementation: PyNumber_Rshift");
        hasMember = reallyHasMember(capiLibrary, "PyNumber_Subtract");
        if (!hasMember) messages.add("missing implementation: PyNumber_Subtract");
        hasMember = reallyHasMember(capiLibrary, "PyNumber_ToBase");
        if (!hasMember) messages.add("missing implementation: PyNumber_ToBase");
        hasMember = reallyHasMember(capiLibrary, "PyNumber_TrueDivide");
        if (!hasMember) messages.add("missing implementation: PyNumber_TrueDivide");
        hasMember = reallyHasMember(capiLibrary, "PyNumber_Xor");
        if (!hasMember) messages.add("missing implementation: PyNumber_Xor");
        hasMember = reallyHasMember(capiLibrary, "PyODict_DelItem");
        if (!hasMember) messages.add("missing implementation: PyODict_DelItem");
        hasMember = reallyHasMember(capiLibrary, "PyODict_New");
        if (!hasMember) messages.add("missing implementation: PyODict_New");
        hasMember = reallyHasMember(capiLibrary, "PyODict_SetItem");
        if (!hasMember) messages.add("missing implementation: PyODict_SetItem");
        hasMember = reallyHasMember(capiLibrary, "PyOS_AfterFork");
        if (!hasMember) messages.add("missing implementation: PyOS_AfterFork");
        hasMember = reallyHasMember(capiLibrary, "PyOS_AfterFork_Child");
        if (!hasMember) messages.add("missing implementation: PyOS_AfterFork_Child");
        hasMember = reallyHasMember(capiLibrary, "PyOS_AfterFork_Parent");
        if (!hasMember) messages.add("missing implementation: PyOS_AfterFork_Parent");
        hasMember = reallyHasMember(capiLibrary, "PyOS_BeforeFork");
        if (!hasMember) messages.add("missing implementation: PyOS_BeforeFork");
        hasMember = reallyHasMember(capiLibrary, "PyOS_FSPath");
        if (!hasMember) messages.add("missing implementation: PyOS_FSPath");
        hasMember = reallyHasMember(capiLibrary, "PyOS_InterruptOccurred");
        if (!hasMember) messages.add("missing implementation: PyOS_InterruptOccurred");
        hasMember = reallyHasMember(capiLibrary, "PyOS_Readline");
        if (!hasMember) messages.add("missing implementation: PyOS_Readline");
        hasMember = reallyHasMember(capiLibrary, "PyOS_double_to_string");
        if (!hasMember) messages.add("missing implementation: PyOS_double_to_string");
        hasMember = reallyHasMember(capiLibrary, "PyOS_getsig");
        if (!hasMember) messages.add("missing implementation: PyOS_getsig");
        hasMember = reallyHasMember(capiLibrary, "PyOS_mystricmp");
        if (!hasMember) messages.add("missing implementation: PyOS_mystricmp");
        hasMember = reallyHasMember(capiLibrary, "PyOS_mystrnicmp");
        if (!hasMember) messages.add("missing implementation: PyOS_mystrnicmp");
        hasMember = reallyHasMember(capiLibrary, "PyOS_setsig");
        if (!hasMember) messages.add("missing implementation: PyOS_setsig");
        hasMember = reallyHasMember(capiLibrary, "PyOS_snprintf");
        if (!hasMember) messages.add("missing implementation: PyOS_snprintf");
        hasMember = reallyHasMember(capiLibrary, "PyOS_string_to_double");
        if (!hasMember) messages.add("missing implementation: PyOS_string_to_double");
        hasMember = reallyHasMember(capiLibrary, "PyOS_strtol");
        if (!hasMember) messages.add("missing implementation: PyOS_strtol");
        hasMember = reallyHasMember(capiLibrary, "PyOS_strtoul");
        if (!hasMember) messages.add("missing implementation: PyOS_strtoul");
        hasMember = reallyHasMember(capiLibrary, "PyOS_vsnprintf");
        if (!hasMember) messages.add("missing implementation: PyOS_vsnprintf");
        hasMember = reallyHasMember(capiLibrary, "PyObject_ASCII");
        if (!hasMember) messages.add("missing implementation: PyObject_ASCII");
        hasMember = reallyHasMember(capiLibrary, "PyObject_AsCharBuffer");
        if (!hasMember) messages.add("missing implementation: PyObject_AsCharBuffer");
        hasMember = reallyHasMember(capiLibrary, "PyObject_AsFileDescriptor");
        if (!hasMember) messages.add("missing implementation: PyObject_AsFileDescriptor");
        hasMember = reallyHasMember(capiLibrary, "PyObject_AsReadBuffer");
        if (!hasMember) messages.add("missing implementation: PyObject_AsReadBuffer");
        hasMember = reallyHasMember(capiLibrary, "PyObject_AsWriteBuffer");
        if (!hasMember) messages.add("missing implementation: PyObject_AsWriteBuffer");
        hasMember = reallyHasMember(capiLibrary, "PyObject_Bytes");
        if (!hasMember) messages.add("missing implementation: PyObject_Bytes");
        hasMember = reallyHasMember(capiLibrary, "PyObject_Call");
        if (!hasMember) messages.add("missing implementation: PyObject_Call");
        hasMember = reallyHasMember(capiLibrary, "PyObject_CallFinalizer");
        if (!hasMember) messages.add("missing implementation: PyObject_CallFinalizer");
        hasMember = reallyHasMember(capiLibrary, "PyObject_CallFinalizerFromDealloc");
        if (!hasMember) messages.add("missing implementation: PyObject_CallFinalizerFromDealloc");
        hasMember = reallyHasMember(capiLibrary, "PyObject_CallFunction");
        if (!hasMember) messages.add("missing implementation: PyObject_CallFunction");
        hasMember = reallyHasMember(capiLibrary, "PyObject_CallFunctionObjArgs");
        if (!hasMember) messages.add("missing implementation: PyObject_CallFunctionObjArgs");
        hasMember = reallyHasMember(capiLibrary, "PyObject_CallMethod");
        if (!hasMember) messages.add("missing implementation: PyObject_CallMethod");
        hasMember = reallyHasMember(capiLibrary, "PyObject_CallMethodObjArgs");
        if (!hasMember) messages.add("missing implementation: PyObject_CallMethodObjArgs");
        hasMember = reallyHasMember(capiLibrary, "PyObject_CallNoArgs");
        if (!hasMember) messages.add("missing implementation: PyObject_CallNoArgs");
        hasMember = reallyHasMember(capiLibrary, "PyObject_CallObject");
        if (!hasMember) messages.add("missing implementation: PyObject_CallObject");
        hasMember = reallyHasMember(capiLibrary, "PyObject_CallOneArg");
        if (!hasMember) messages.add("missing implementation: PyObject_CallOneArg");
        hasMember = reallyHasMember(capiLibrary, "PyObject_Calloc");
        if (!hasMember) messages.add("missing implementation: PyObject_Calloc");
        hasMember = reallyHasMember(capiLibrary, "PyObject_CheckBuffer");
        if (!hasMember) messages.add("missing implementation: PyObject_CheckBuffer");
        hasMember = reallyHasMember(capiLibrary, "PyObject_CheckReadBuffer");
        if (!hasMember) messages.add("missing implementation: PyObject_CheckReadBuffer");
        hasMember = reallyHasMember(capiLibrary, "PyObject_ClearWeakRefs");
        if (!hasMember) messages.add("missing implementation: PyObject_ClearWeakRefs");
        hasMember = reallyHasMember(capiLibrary, "PyObject_CopyData");
        if (!hasMember) messages.add("missing implementation: PyObject_CopyData");
        hasMember = reallyHasMember(capiLibrary, "PyObject_DelItem");
        if (!hasMember) messages.add("missing implementation: PyObject_DelItem");
        hasMember = reallyHasMember(capiLibrary, "PyObject_DelItemString");
        if (!hasMember) messages.add("missing implementation: PyObject_DelItemString");
        hasMember = reallyHasMember(capiLibrary, "PyObject_Dir");
        if (!hasMember) messages.add("missing implementation: PyObject_Dir");
        hasMember = reallyHasMember(capiLibrary, "PyObject_Format");
        if (!hasMember) messages.add("missing implementation: PyObject_Format");
        hasMember = reallyHasMember(capiLibrary, "PyObject_Free");
        if (!hasMember) messages.add("missing implementation: PyObject_Free");
        hasMember = reallyHasMember(capiLibrary, "PyObject_GC_Del");
        if (!hasMember) messages.add("missing implementation: PyObject_GC_Del");
        hasMember = reallyHasMember(capiLibrary, "PyObject_GC_IsFinalized");
        if (!hasMember) messages.add("missing implementation: PyObject_GC_IsFinalized");
        hasMember = reallyHasMember(capiLibrary, "PyObject_GC_IsTracked");
        if (!hasMember) messages.add("missing implementation: PyObject_GC_IsTracked");
        hasMember = reallyHasMember(capiLibrary, "PyObject_GC_Track");
        if (!hasMember) messages.add("missing implementation: PyObject_GC_Track");
        hasMember = reallyHasMember(capiLibrary, "PyObject_GC_UnTrack");
        if (!hasMember) messages.add("missing implementation: PyObject_GC_UnTrack");
        hasMember = reallyHasMember(capiLibrary, "PyObject_GET_WEAKREFS_LISTPTR");
        if (!hasMember) messages.add("missing implementation: PyObject_GET_WEAKREFS_LISTPTR");
        hasMember = reallyHasMember(capiLibrary, "PyObject_GenericGetAttr");
        if (!hasMember) messages.add("missing implementation: PyObject_GenericGetAttr");
        hasMember = reallyHasMember(capiLibrary, "PyObject_GenericGetDict");
        if (!hasMember) messages.add("missing implementation: PyObject_GenericGetDict");
        hasMember = reallyHasMember(capiLibrary, "PyObject_GenericSetAttr");
        if (!hasMember) messages.add("missing implementation: PyObject_GenericSetAttr");
        hasMember = reallyHasMember(capiLibrary, "PyObject_GenericSetDict");
        if (!hasMember) messages.add("missing implementation: PyObject_GenericSetDict");
        hasMember = reallyHasMember(capiLibrary, "PyObject_GetAIter");
        if (!hasMember) messages.add("missing implementation: PyObject_GetAIter");
        hasMember = reallyHasMember(capiLibrary, "PyObject_GetArenaAllocator");
        if (!hasMember) messages.add("missing implementation: PyObject_GetArenaAllocator");
        hasMember = reallyHasMember(capiLibrary, "PyObject_GetAttr");
        if (!hasMember) messages.add("missing implementation: PyObject_GetAttr");
        hasMember = reallyHasMember(capiLibrary, "PyObject_GetAttrString");
        if (!hasMember) messages.add("missing implementation: PyObject_GetAttrString");
        hasMember = reallyHasMember(capiLibrary, "PyObject_GetBuffer");
        if (!hasMember) messages.add("missing implementation: PyObject_GetBuffer");
        hasMember = reallyHasMember(capiLibrary, "PyObject_GetDoc");
        if (!hasMember) messages.add("missing implementation: PyObject_GetDoc");
        hasMember = reallyHasMember(capiLibrary, "PyObject_GetItem");
        if (!hasMember) messages.add("missing implementation: PyObject_GetItem");
        hasMember = reallyHasMember(capiLibrary, "PyObject_GetItemData");
        if (!hasMember) messages.add("missing implementation: PyObject_GetItemData");
        hasMember = reallyHasMember(capiLibrary, "PyObject_GetIter");
        if (!hasMember) messages.add("missing implementation: PyObject_GetIter");
        hasMember = reallyHasMember(capiLibrary, "PyObject_GetTypeData");
        if (!hasMember) messages.add("missing implementation: PyObject_GetTypeData");
        hasMember = reallyHasMember(capiLibrary, "PyObject_HasAttr");
        if (!hasMember) messages.add("missing implementation: PyObject_HasAttr");
        hasMember = reallyHasMember(capiLibrary, "PyObject_HasAttrString");
        if (!hasMember) messages.add("missing implementation: PyObject_HasAttrString");
        hasMember = reallyHasMember(capiLibrary, "PyObject_Hash");
        if (!hasMember) messages.add("missing implementation: PyObject_Hash");
        hasMember = reallyHasMember(capiLibrary, "PyObject_HashNotImplemented");
        if (!hasMember) messages.add("missing implementation: PyObject_HashNotImplemented");
        hasMember = reallyHasMember(capiLibrary, "PyObject_IS_GC");
        if (!hasMember) messages.add("missing implementation: PyObject_IS_GC");
        hasMember = reallyHasMember(capiLibrary, "PyObject_Init");
        if (!hasMember) messages.add("missing implementation: PyObject_Init");
        hasMember = reallyHasMember(capiLibrary, "PyObject_InitVar");
        if (!hasMember) messages.add("missing implementation: PyObject_InitVar");
        hasMember = reallyHasMember(capiLibrary, "PyObject_IsInstance");
        if (!hasMember) messages.add("missing implementation: PyObject_IsInstance");
        hasMember = reallyHasMember(capiLibrary, "PyObject_IsSubclass");
        if (!hasMember) messages.add("missing implementation: PyObject_IsSubclass");
        hasMember = reallyHasMember(capiLibrary, "PyObject_IsTrue");
        if (!hasMember) messages.add("missing implementation: PyObject_IsTrue");
        hasMember = reallyHasMember(capiLibrary, "PyObject_Length");
        if (!hasMember) messages.add("missing implementation: PyObject_Length");
        hasMember = reallyHasMember(capiLibrary, "PyObject_LengthHint");
        if (!hasMember) messages.add("missing implementation: PyObject_LengthHint");
        hasMember = reallyHasMember(capiLibrary, "PyObject_Malloc");
        if (!hasMember) messages.add("missing implementation: PyObject_Malloc");
        hasMember = reallyHasMember(capiLibrary, "PyObject_Not");
        if (!hasMember) messages.add("missing implementation: PyObject_Not");
        hasMember = reallyHasMember(capiLibrary, "PyObject_Print");
        if (!hasMember) messages.add("missing implementation: PyObject_Print");
        hasMember = reallyHasMember(capiLibrary, "PyObject_Realloc");
        if (!hasMember) messages.add("missing implementation: PyObject_Realloc");
        hasMember = reallyHasMember(capiLibrary, "PyObject_Repr");
        if (!hasMember) messages.add("missing implementation: PyObject_Repr");
        hasMember = reallyHasMember(capiLibrary, "PyObject_RichCompare");
        if (!hasMember) messages.add("missing implementation: PyObject_RichCompare");
        hasMember = reallyHasMember(capiLibrary, "PyObject_RichCompareBool");
        if (!hasMember) messages.add("missing implementation: PyObject_RichCompareBool");
        hasMember = reallyHasMember(capiLibrary, "PyObject_SelfIter");
        if (!hasMember) messages.add("missing implementation: PyObject_SelfIter");
        hasMember = reallyHasMember(capiLibrary, "PyObject_SetArenaAllocator");
        if (!hasMember) messages.add("missing implementation: PyObject_SetArenaAllocator");
        hasMember = reallyHasMember(capiLibrary, "PyObject_SetAttr");
        if (!hasMember) messages.add("missing implementation: PyObject_SetAttr");
        hasMember = reallyHasMember(capiLibrary, "PyObject_SetAttrString");
        if (!hasMember) messages.add("missing implementation: PyObject_SetAttrString");
        hasMember = reallyHasMember(capiLibrary, "PyObject_SetDoc");
        if (!hasMember) messages.add("missing implementation: PyObject_SetDoc");
        hasMember = reallyHasMember(capiLibrary, "PyObject_SetItem");
        if (!hasMember) messages.add("missing implementation: PyObject_SetItem");
        hasMember = reallyHasMember(capiLibrary, "PyObject_Size");
        if (!hasMember) messages.add("missing implementation: PyObject_Size");
        hasMember = reallyHasMember(capiLibrary, "PyObject_Str");
        if (!hasMember) messages.add("missing implementation: PyObject_Str");
        hasMember = reallyHasMember(capiLibrary, "PyObject_Type");
        if (!hasMember) messages.add("missing implementation: PyObject_Type");
        hasMember = reallyHasMember(capiLibrary, "PyObject_Vectorcall");
        if (!hasMember) messages.add("missing implementation: PyObject_Vectorcall");
        hasMember = reallyHasMember(capiLibrary, "PyObject_VectorcallDict");
        if (!hasMember) messages.add("missing implementation: PyObject_VectorcallDict");
        hasMember = reallyHasMember(capiLibrary, "PyObject_VectorcallMethod");
        if (!hasMember) messages.add("missing implementation: PyObject_VectorcallMethod");
        hasMember = reallyHasMember(capiLibrary, "PyPickleBuffer_FromObject");
        if (!hasMember) messages.add("missing implementation: PyPickleBuffer_FromObject");
        hasMember = reallyHasMember(capiLibrary, "PyPickleBuffer_GetBuffer");
        if (!hasMember) messages.add("missing implementation: PyPickleBuffer_GetBuffer");
        hasMember = reallyHasMember(capiLibrary, "PyPickleBuffer_Release");
        if (!hasMember) messages.add("missing implementation: PyPickleBuffer_Release");
        hasMember = reallyHasMember(capiLibrary, "PyPreConfig_InitIsolatedConfig");
        if (!hasMember) messages.add("missing implementation: PyPreConfig_InitIsolatedConfig");
        hasMember = reallyHasMember(capiLibrary, "PyPreConfig_InitPythonConfig");
        if (!hasMember) messages.add("missing implementation: PyPreConfig_InitPythonConfig");
        hasMember = reallyHasMember(capiLibrary, "PyRun_AnyFile");
        if (!hasMember) messages.add("missing implementation: PyRun_AnyFile");
        hasMember = reallyHasMember(capiLibrary, "PyRun_AnyFileEx");
        if (!hasMember) messages.add("missing implementation: PyRun_AnyFileEx");
        hasMember = reallyHasMember(capiLibrary, "PyRun_AnyFileExFlags");
        if (!hasMember) messages.add("missing implementation: PyRun_AnyFileExFlags");
        hasMember = reallyHasMember(capiLibrary, "PyRun_AnyFileFlags");
        if (!hasMember) messages.add("missing implementation: PyRun_AnyFileFlags");
        hasMember = reallyHasMember(capiLibrary, "PyRun_File");
        if (!hasMember) messages.add("missing implementation: PyRun_File");
        hasMember = reallyHasMember(capiLibrary, "PyRun_FileEx");
        if (!hasMember) messages.add("missing implementation: PyRun_FileEx");
        hasMember = reallyHasMember(capiLibrary, "PyRun_FileExFlags");
        if (!hasMember) messages.add("missing implementation: PyRun_FileExFlags");
        hasMember = reallyHasMember(capiLibrary, "PyRun_FileFlags");
        if (!hasMember) messages.add("missing implementation: PyRun_FileFlags");
        hasMember = reallyHasMember(capiLibrary, "PyRun_InteractiveLoop");
        if (!hasMember) messages.add("missing implementation: PyRun_InteractiveLoop");
        hasMember = reallyHasMember(capiLibrary, "PyRun_InteractiveLoopFlags");
        if (!hasMember) messages.add("missing implementation: PyRun_InteractiveLoopFlags");
        hasMember = reallyHasMember(capiLibrary, "PyRun_InteractiveOne");
        if (!hasMember) messages.add("missing implementation: PyRun_InteractiveOne");
        hasMember = reallyHasMember(capiLibrary, "PyRun_InteractiveOneFlags");
        if (!hasMember) messages.add("missing implementation: PyRun_InteractiveOneFlags");
        hasMember = reallyHasMember(capiLibrary, "PyRun_InteractiveOneObject");
        if (!hasMember) messages.add("missing implementation: PyRun_InteractiveOneObject");
        hasMember = reallyHasMember(capiLibrary, "PyRun_SimpleFile");
        if (!hasMember) messages.add("missing implementation: PyRun_SimpleFile");
        hasMember = reallyHasMember(capiLibrary, "PyRun_SimpleFileEx");
        if (!hasMember) messages.add("missing implementation: PyRun_SimpleFileEx");
        hasMember = reallyHasMember(capiLibrary, "PyRun_SimpleFileExFlags");
        if (!hasMember) messages.add("missing implementation: PyRun_SimpleFileExFlags");
        hasMember = reallyHasMember(capiLibrary, "PyRun_SimpleString");
        if (!hasMember) messages.add("missing implementation: PyRun_SimpleString");
        hasMember = reallyHasMember(capiLibrary, "PyRun_SimpleStringFlags");
        if (!hasMember) messages.add("missing implementation: PyRun_SimpleStringFlags");
        hasMember = reallyHasMember(capiLibrary, "PyRun_String");
        if (!hasMember) messages.add("missing implementation: PyRun_String");
        hasMember = reallyHasMember(capiLibrary, "PyRun_StringFlags");
        if (!hasMember) messages.add("missing implementation: PyRun_StringFlags");
        hasMember = reallyHasMember(capiLibrary, "PySeqIter_New");
        if (!hasMember) messages.add("missing implementation: PySeqIter_New");
        hasMember = reallyHasMember(capiLibrary, "PySequence_Check");
        if (!hasMember) messages.add("missing implementation: PySequence_Check");
        hasMember = reallyHasMember(capiLibrary, "PySequence_Concat");
        if (!hasMember) messages.add("missing implementation: PySequence_Concat");
        hasMember = reallyHasMember(capiLibrary, "PySequence_Contains");
        if (!hasMember) messages.add("missing implementation: PySequence_Contains");
        hasMember = reallyHasMember(capiLibrary, "PySequence_Count");
        if (!hasMember) messages.add("missing implementation: PySequence_Count");
        hasMember = reallyHasMember(capiLibrary, "PySequence_DelItem");
        if (!hasMember) messages.add("missing implementation: PySequence_DelItem");
        hasMember = reallyHasMember(capiLibrary, "PySequence_DelSlice");
        if (!hasMember) messages.add("missing implementation: PySequence_DelSlice");
        hasMember = reallyHasMember(capiLibrary, "PySequence_Fast");
        if (!hasMember) messages.add("missing implementation: PySequence_Fast");
        hasMember = reallyHasMember(capiLibrary, "PySequence_GetItem");
        if (!hasMember) messages.add("missing implementation: PySequence_GetItem");
        hasMember = reallyHasMember(capiLibrary, "PySequence_GetSlice");
        if (!hasMember) messages.add("missing implementation: PySequence_GetSlice");
        hasMember = reallyHasMember(capiLibrary, "PySequence_In");
        if (!hasMember) messages.add("missing implementation: PySequence_In");
        hasMember = reallyHasMember(capiLibrary, "PySequence_InPlaceConcat");
        if (!hasMember) messages.add("missing implementation: PySequence_InPlaceConcat");
        hasMember = reallyHasMember(capiLibrary, "PySequence_InPlaceRepeat");
        if (!hasMember) messages.add("missing implementation: PySequence_InPlaceRepeat");
        hasMember = reallyHasMember(capiLibrary, "PySequence_Index");
        if (!hasMember) messages.add("missing implementation: PySequence_Index");
        hasMember = reallyHasMember(capiLibrary, "PySequence_Length");
        if (!hasMember) messages.add("missing implementation: PySequence_Length");
        hasMember = reallyHasMember(capiLibrary, "PySequence_List");
        if (!hasMember) messages.add("missing implementation: PySequence_List");
        hasMember = reallyHasMember(capiLibrary, "PySequence_Repeat");
        if (!hasMember) messages.add("missing implementation: PySequence_Repeat");
        hasMember = reallyHasMember(capiLibrary, "PySequence_SetItem");
        if (!hasMember) messages.add("missing implementation: PySequence_SetItem");
        hasMember = reallyHasMember(capiLibrary, "PySequence_SetSlice");
        if (!hasMember) messages.add("missing implementation: PySequence_SetSlice");
        hasMember = reallyHasMember(capiLibrary, "PySequence_Size");
        if (!hasMember) messages.add("missing implementation: PySequence_Size");
        hasMember = reallyHasMember(capiLibrary, "PySequence_Tuple");
        if (!hasMember) messages.add("missing implementation: PySequence_Tuple");
        hasMember = reallyHasMember(capiLibrary, "PySet_Add");
        if (!hasMember) messages.add("missing implementation: PySet_Add");
        hasMember = reallyHasMember(capiLibrary, "PySet_Clear");
        if (!hasMember) messages.add("missing implementation: PySet_Clear");
        hasMember = reallyHasMember(capiLibrary, "PySet_Contains");
        if (!hasMember) messages.add("missing implementation: PySet_Contains");
        hasMember = reallyHasMember(capiLibrary, "PySet_Discard");
        if (!hasMember) messages.add("missing implementation: PySet_Discard");
        hasMember = reallyHasMember(capiLibrary, "PySet_New");
        if (!hasMember) messages.add("missing implementation: PySet_New");
        hasMember = reallyHasMember(capiLibrary, "PySet_Pop");
        if (!hasMember) messages.add("missing implementation: PySet_Pop");
        hasMember = reallyHasMember(capiLibrary, "PySet_Size");
        if (!hasMember) messages.add("missing implementation: PySet_Size");
        hasMember = reallyHasMember(capiLibrary, "PySlice_AdjustIndices");
        if (!hasMember) messages.add("missing implementation: PySlice_AdjustIndices");
        hasMember = reallyHasMember(capiLibrary, "PySlice_GetIndices");
        if (!hasMember) messages.add("missing implementation: PySlice_GetIndices");
        hasMember = reallyHasMember(capiLibrary, "PySlice_GetIndicesEx");
        if (!hasMember) messages.add("missing implementation: PySlice_GetIndicesEx");
        hasMember = reallyHasMember(capiLibrary, "PySlice_New");
        if (!hasMember) messages.add("missing implementation: PySlice_New");
        hasMember = reallyHasMember(capiLibrary, "PySlice_Unpack");
        if (!hasMember) messages.add("missing implementation: PySlice_Unpack");
        hasMember = reallyHasMember(capiLibrary, "PyState_AddModule");
        if (!hasMember) messages.add("missing implementation: PyState_AddModule");
        hasMember = reallyHasMember(capiLibrary, "PyState_FindModule");
        if (!hasMember) messages.add("missing implementation: PyState_FindModule");
        hasMember = reallyHasMember(capiLibrary, "PyState_RemoveModule");
        if (!hasMember) messages.add("missing implementation: PyState_RemoveModule");
        hasMember = reallyHasMember(capiLibrary, "PyStaticMethod_New");
        if (!hasMember) messages.add("missing implementation: PyStaticMethod_New");
        hasMember = reallyHasMember(capiLibrary, "PyStatus_Error");
        if (!hasMember) messages.add("missing implementation: PyStatus_Error");
        hasMember = reallyHasMember(capiLibrary, "PyStatus_Exception");
        if (!hasMember) messages.add("missing implementation: PyStatus_Exception");
        hasMember = reallyHasMember(capiLibrary, "PyStatus_Exit");
        if (!hasMember) messages.add("missing implementation: PyStatus_Exit");
        hasMember = reallyHasMember(capiLibrary, "PyStatus_IsError");
        if (!hasMember) messages.add("missing implementation: PyStatus_IsError");
        hasMember = reallyHasMember(capiLibrary, "PyStatus_IsExit");
        if (!hasMember) messages.add("missing implementation: PyStatus_IsExit");
        hasMember = reallyHasMember(capiLibrary, "PyStatus_NoMemory");
        if (!hasMember) messages.add("missing implementation: PyStatus_NoMemory");
        hasMember = reallyHasMember(capiLibrary, "PyStatus_Ok");
        if (!hasMember) messages.add("missing implementation: PyStatus_Ok");
        hasMember = reallyHasMember(capiLibrary, "PyStructSequence_GetItem");
        if (!hasMember) messages.add("missing implementation: PyStructSequence_GetItem");
        hasMember = reallyHasMember(capiLibrary, "PyStructSequence_InitType");
        if (!hasMember) messages.add("missing implementation: PyStructSequence_InitType");
        hasMember = reallyHasMember(capiLibrary, "PyStructSequence_InitType2");
        if (!hasMember) messages.add("missing implementation: PyStructSequence_InitType2");
        hasMember = reallyHasMember(capiLibrary, "PyStructSequence_New");
        if (!hasMember) messages.add("missing implementation: PyStructSequence_New");
        hasMember = reallyHasMember(capiLibrary, "PyStructSequence_NewType");
        if (!hasMember) messages.add("missing implementation: PyStructSequence_NewType");
        hasMember = reallyHasMember(capiLibrary, "PyStructSequence_SetItem");
        if (!hasMember) messages.add("missing implementation: PyStructSequence_SetItem");
        hasMember = reallyHasMember(capiLibrary, "PySys_AddAuditHook");
        if (!hasMember) messages.add("missing implementation: PySys_AddAuditHook");
        hasMember = reallyHasMember(capiLibrary, "PySys_AddWarnOption");
        if (!hasMember) messages.add("missing implementation: PySys_AddWarnOption");
        hasMember = reallyHasMember(capiLibrary, "PySys_AddWarnOptionUnicode");
        if (!hasMember) messages.add("missing implementation: PySys_AddWarnOptionUnicode");
        hasMember = reallyHasMember(capiLibrary, "PySys_AddXOption");
        if (!hasMember) messages.add("missing implementation: PySys_AddXOption");
        hasMember = reallyHasMember(capiLibrary, "PySys_Audit");
        if (!hasMember) messages.add("missing implementation: PySys_Audit");
        hasMember = reallyHasMember(capiLibrary, "PySys_FormatStderr");
        if (!hasMember) messages.add("missing implementation: PySys_FormatStderr");
        hasMember = reallyHasMember(capiLibrary, "PySys_FormatStdout");
        if (!hasMember) messages.add("missing implementation: PySys_FormatStdout");
        hasMember = reallyHasMember(capiLibrary, "PySys_GetObject");
        if (!hasMember) messages.add("missing implementation: PySys_GetObject");
        hasMember = reallyHasMember(capiLibrary, "PySys_GetXOptions");
        if (!hasMember) messages.add("missing implementation: PySys_GetXOptions");
        hasMember = reallyHasMember(capiLibrary, "PySys_HasWarnOptions");
        if (!hasMember) messages.add("missing implementation: PySys_HasWarnOptions");
        hasMember = reallyHasMember(capiLibrary, "PySys_ResetWarnOptions");
        if (!hasMember) messages.add("missing implementation: PySys_ResetWarnOptions");
        hasMember = reallyHasMember(capiLibrary, "PySys_SetArgv");
        if (!hasMember) messages.add("missing implementation: PySys_SetArgv");
        hasMember = reallyHasMember(capiLibrary, "PySys_SetArgvEx");
        if (!hasMember) messages.add("missing implementation: PySys_SetArgvEx");
        hasMember = reallyHasMember(capiLibrary, "PySys_SetObject");
        if (!hasMember) messages.add("missing implementation: PySys_SetObject");
        hasMember = reallyHasMember(capiLibrary, "PySys_SetPath");
        if (!hasMember) messages.add("missing implementation: PySys_SetPath");
        hasMember = reallyHasMember(capiLibrary, "PySys_WriteStderr");
        if (!hasMember) messages.add("missing implementation: PySys_WriteStderr");
        hasMember = reallyHasMember(capiLibrary, "PySys_WriteStdout");
        if (!hasMember) messages.add("missing implementation: PySys_WriteStdout");
        hasMember = reallyHasMember(capiLibrary, "PyThreadState_Clear");
        if (!hasMember) messages.add("missing implementation: PyThreadState_Clear");
        hasMember = reallyHasMember(capiLibrary, "PyThreadState_Delete");
        if (!hasMember) messages.add("missing implementation: PyThreadState_Delete");
        hasMember = reallyHasMember(capiLibrary, "PyThreadState_DeleteCurrent");
        if (!hasMember) messages.add("missing implementation: PyThreadState_DeleteCurrent");
        hasMember = reallyHasMember(capiLibrary, "PyThreadState_EnterTracing");
        if (!hasMember) messages.add("missing implementation: PyThreadState_EnterTracing");
        hasMember = reallyHasMember(capiLibrary, "PyThreadState_Get");
        if (!hasMember) messages.add("missing implementation: PyThreadState_Get");
        hasMember = reallyHasMember(capiLibrary, "PyThreadState_GetDict");
        if (!hasMember) messages.add("missing implementation: PyThreadState_GetDict");
        hasMember = reallyHasMember(capiLibrary, "PyThreadState_GetFrame");
        if (!hasMember) messages.add("missing implementation: PyThreadState_GetFrame");
        hasMember = reallyHasMember(capiLibrary, "PyThreadState_GetID");
        if (!hasMember) messages.add("missing implementation: PyThreadState_GetID");
        hasMember = reallyHasMember(capiLibrary, "PyThreadState_GetInterpreter");
        if (!hasMember) messages.add("missing implementation: PyThreadState_GetInterpreter");
        hasMember = reallyHasMember(capiLibrary, "PyThreadState_LeaveTracing");
        if (!hasMember) messages.add("missing implementation: PyThreadState_LeaveTracing");
        hasMember = reallyHasMember(capiLibrary, "PyThreadState_New");
        if (!hasMember) messages.add("missing implementation: PyThreadState_New");
        hasMember = reallyHasMember(capiLibrary, "PyThreadState_Next");
        if (!hasMember) messages.add("missing implementation: PyThreadState_Next");
        hasMember = reallyHasMember(capiLibrary, "PyThreadState_SetAsyncExc");
        if (!hasMember) messages.add("missing implementation: PyThreadState_SetAsyncExc");
        hasMember = reallyHasMember(capiLibrary, "PyThreadState_Swap");
        if (!hasMember) messages.add("missing implementation: PyThreadState_Swap");
        hasMember = reallyHasMember(capiLibrary, "PyThread_GetInfo");
        if (!hasMember) messages.add("missing implementation: PyThread_GetInfo");
        hasMember = reallyHasMember(capiLibrary, "PyThread_ReInitTLS");
        if (!hasMember) messages.add("missing implementation: PyThread_ReInitTLS");
        hasMember = reallyHasMember(capiLibrary, "PyThread_acquire_lock");
        if (!hasMember) messages.add("missing implementation: PyThread_acquire_lock");
        hasMember = reallyHasMember(capiLibrary, "PyThread_acquire_lock_timed");
        if (!hasMember) messages.add("missing implementation: PyThread_acquire_lock_timed");
        hasMember = reallyHasMember(capiLibrary, "PyThread_allocate_lock");
        if (!hasMember) messages.add("missing implementation: PyThread_allocate_lock");
        hasMember = reallyHasMember(capiLibrary, "PyThread_create_key");
        if (!hasMember) messages.add("missing implementation: PyThread_create_key");
        hasMember = reallyHasMember(capiLibrary, "PyThread_delete_key");
        if (!hasMember) messages.add("missing implementation: PyThread_delete_key");
        hasMember = reallyHasMember(capiLibrary, "PyThread_delete_key_value");
        if (!hasMember) messages.add("missing implementation: PyThread_delete_key_value");
        hasMember = reallyHasMember(capiLibrary, "PyThread_exit_thread");
        if (!hasMember) messages.add("missing implementation: PyThread_exit_thread");
        hasMember = reallyHasMember(capiLibrary, "PyThread_free_lock");
        if (!hasMember) messages.add("missing implementation: PyThread_free_lock");
        hasMember = reallyHasMember(capiLibrary, "PyThread_get_key_value");
        if (!hasMember) messages.add("missing implementation: PyThread_get_key_value");
        hasMember = reallyHasMember(capiLibrary, "PyThread_get_stacksize");
        if (!hasMember) messages.add("missing implementation: PyThread_get_stacksize");
        hasMember = reallyHasMember(capiLibrary, "PyThread_get_thread_ident");
        if (!hasMember) messages.add("missing implementation: PyThread_get_thread_ident");
        hasMember = reallyHasMember(capiLibrary, "PyThread_get_thread_native_id");
        if (!hasMember) messages.add("missing implementation: PyThread_get_thread_native_id");
        hasMember = reallyHasMember(capiLibrary, "PyThread_init_thread");
        if (!hasMember) messages.add("missing implementation: PyThread_init_thread");
        hasMember = reallyHasMember(capiLibrary, "PyThread_release_lock");
        if (!hasMember) messages.add("missing implementation: PyThread_release_lock");
        hasMember = reallyHasMember(capiLibrary, "PyThread_set_key_value");
        if (!hasMember) messages.add("missing implementation: PyThread_set_key_value");
        hasMember = reallyHasMember(capiLibrary, "PyThread_set_stacksize");
        if (!hasMember) messages.add("missing implementation: PyThread_set_stacksize");
        hasMember = reallyHasMember(capiLibrary, "PyThread_start_new_thread");
        if (!hasMember) messages.add("missing implementation: PyThread_start_new_thread");
        hasMember = reallyHasMember(capiLibrary, "PyThread_tss_alloc");
        if (!hasMember) messages.add("missing implementation: PyThread_tss_alloc");
        hasMember = reallyHasMember(capiLibrary, "PyThread_tss_create");
        if (!hasMember) messages.add("missing implementation: PyThread_tss_create");
        hasMember = reallyHasMember(capiLibrary, "PyThread_tss_delete");
        if (!hasMember) messages.add("missing implementation: PyThread_tss_delete");
        hasMember = reallyHasMember(capiLibrary, "PyThread_tss_free");
        if (!hasMember) messages.add("missing implementation: PyThread_tss_free");
        hasMember = reallyHasMember(capiLibrary, "PyThread_tss_get");
        if (!hasMember) messages.add("missing implementation: PyThread_tss_get");
        hasMember = reallyHasMember(capiLibrary, "PyThread_tss_is_created");
        if (!hasMember) messages.add("missing implementation: PyThread_tss_is_created");
        hasMember = reallyHasMember(capiLibrary, "PyThread_tss_set");
        if (!hasMember) messages.add("missing implementation: PyThread_tss_set");
        hasMember = reallyHasMember(capiLibrary, "PyTraceBack_Here");
        if (!hasMember) messages.add("missing implementation: PyTraceBack_Here");
        hasMember = reallyHasMember(capiLibrary, "PyTraceBack_Print");
        if (!hasMember) messages.add("missing implementation: PyTraceBack_Print");
        hasMember = reallyHasMember(capiLibrary, "PyTraceMalloc_Track");
        if (!hasMember) messages.add("missing implementation: PyTraceMalloc_Track");
        hasMember = reallyHasMember(capiLibrary, "PyTraceMalloc_Untrack");
        if (!hasMember) messages.add("missing implementation: PyTraceMalloc_Untrack");
        hasMember = reallyHasMember(capiLibrary, "PyTuple_GetItem");
        if (!hasMember) messages.add("missing implementation: PyTuple_GetItem");
        hasMember = reallyHasMember(capiLibrary, "PyTuple_GetSlice");
        if (!hasMember) messages.add("missing implementation: PyTuple_GetSlice");
        hasMember = reallyHasMember(capiLibrary, "PyTuple_New");
        if (!hasMember) messages.add("missing implementation: PyTuple_New");
        hasMember = reallyHasMember(capiLibrary, "PyTuple_Pack");
        if (!hasMember) messages.add("missing implementation: PyTuple_Pack");
        hasMember = reallyHasMember(capiLibrary, "PyTuple_SetItem");
        if (!hasMember) messages.add("missing implementation: PyTuple_SetItem");
        hasMember = reallyHasMember(capiLibrary, "PyTuple_Size");
        if (!hasMember) messages.add("missing implementation: PyTuple_Size");
        hasMember = reallyHasMember(capiLibrary, "PyType_AddWatcher");
        if (!hasMember) messages.add("missing implementation: PyType_AddWatcher");
        hasMember = reallyHasMember(capiLibrary, "PyType_ClearCache");
        if (!hasMember) messages.add("missing implementation: PyType_ClearCache");
        hasMember = reallyHasMember(capiLibrary, "PyType_ClearWatcher");
        if (!hasMember) messages.add("missing implementation: PyType_ClearWatcher");
        hasMember = reallyHasMember(capiLibrary, "PyType_FromMetaclass");
        if (!hasMember) messages.add("missing implementation: PyType_FromMetaclass");
        hasMember = reallyHasMember(capiLibrary, "PyType_FromModuleAndSpec");
        if (!hasMember) messages.add("missing implementation: PyType_FromModuleAndSpec");
        hasMember = reallyHasMember(capiLibrary, "PyType_FromSpec");
        if (!hasMember) messages.add("missing implementation: PyType_FromSpec");
        hasMember = reallyHasMember(capiLibrary, "PyType_FromSpecWithBases");
        if (!hasMember) messages.add("missing implementation: PyType_FromSpecWithBases");
        hasMember = reallyHasMember(capiLibrary, "PyType_GenericAlloc");
        if (!hasMember) messages.add("missing implementation: PyType_GenericAlloc");
        hasMember = reallyHasMember(capiLibrary, "PyType_GenericNew");
        if (!hasMember) messages.add("missing implementation: PyType_GenericNew");
        hasMember = reallyHasMember(capiLibrary, "PyType_GetDict");
        if (!hasMember) messages.add("missing implementation: PyType_GetDict");
        hasMember = reallyHasMember(capiLibrary, "PyType_GetFlags");
        if (!hasMember) messages.add("missing implementation: PyType_GetFlags");
        hasMember = reallyHasMember(capiLibrary, "PyType_GetModule");
        if (!hasMember) messages.add("missing implementation: PyType_GetModule");
        hasMember = reallyHasMember(capiLibrary, "PyType_GetModuleByDef");
        if (!hasMember) messages.add("missing implementation: PyType_GetModuleByDef");
        hasMember = reallyHasMember(capiLibrary, "PyType_GetModuleState");
        if (!hasMember) messages.add("missing implementation: PyType_GetModuleState");
        hasMember = reallyHasMember(capiLibrary, "PyType_GetName");
        if (!hasMember) messages.add("missing implementation: PyType_GetName");
        hasMember = reallyHasMember(capiLibrary, "PyType_GetQualName");
        if (!hasMember) messages.add("missing implementation: PyType_GetQualName");
        hasMember = reallyHasMember(capiLibrary, "PyType_GetSlot");
        if (!hasMember) messages.add("missing implementation: PyType_GetSlot");
        hasMember = reallyHasMember(capiLibrary, "PyType_GetTypeDataSize");
        if (!hasMember) messages.add("missing implementation: PyType_GetTypeDataSize");
        hasMember = reallyHasMember(capiLibrary, "PyType_IsSubtype");
        if (!hasMember) messages.add("missing implementation: PyType_IsSubtype");
        hasMember = reallyHasMember(capiLibrary, "PyType_Modified");
        if (!hasMember) messages.add("missing implementation: PyType_Modified");
        hasMember = reallyHasMember(capiLibrary, "PyType_Ready");
        if (!hasMember) messages.add("missing implementation: PyType_Ready");
        hasMember = reallyHasMember(capiLibrary, "PyType_SUPPORTS_WEAKREFS");
        if (!hasMember) messages.add("missing implementation: PyType_SUPPORTS_WEAKREFS");
        hasMember = reallyHasMember(capiLibrary, "PyType_Unwatch");
        if (!hasMember) messages.add("missing implementation: PyType_Unwatch");
        hasMember = reallyHasMember(capiLibrary, "PyType_Watch");
        if (!hasMember) messages.add("missing implementation: PyType_Watch");
        hasMember = reallyHasMember(capiLibrary, "PyUnicodeDecodeError_Create");
        if (!hasMember) messages.add("missing implementation: PyUnicodeDecodeError_Create");
        hasMember = reallyHasMember(capiLibrary, "PyUnicodeDecodeError_GetEncoding");
        if (!hasMember) messages.add("missing implementation: PyUnicodeDecodeError_GetEncoding");
        hasMember = reallyHasMember(capiLibrary, "PyUnicodeDecodeError_GetEnd");
        if (!hasMember) messages.add("missing implementation: PyUnicodeDecodeError_GetEnd");
        hasMember = reallyHasMember(capiLibrary, "PyUnicodeDecodeError_GetObject");
        if (!hasMember) messages.add("missing implementation: PyUnicodeDecodeError_GetObject");
        hasMember = reallyHasMember(capiLibrary, "PyUnicodeDecodeError_GetReason");
        if (!hasMember) messages.add("missing implementation: PyUnicodeDecodeError_GetReason");
        hasMember = reallyHasMember(capiLibrary, "PyUnicodeDecodeError_GetStart");
        if (!hasMember) messages.add("missing implementation: PyUnicodeDecodeError_GetStart");
        hasMember = reallyHasMember(capiLibrary, "PyUnicodeDecodeError_SetEnd");
        if (!hasMember) messages.add("missing implementation: PyUnicodeDecodeError_SetEnd");
        hasMember = reallyHasMember(capiLibrary, "PyUnicodeDecodeError_SetReason");
        if (!hasMember) messages.add("missing implementation: PyUnicodeDecodeError_SetReason");
        hasMember = reallyHasMember(capiLibrary, "PyUnicodeDecodeError_SetStart");
        if (!hasMember) messages.add("missing implementation: PyUnicodeDecodeError_SetStart");
        hasMember = reallyHasMember(capiLibrary, "PyUnicodeEncodeError_GetEncoding");
        if (!hasMember) messages.add("missing implementation: PyUnicodeEncodeError_GetEncoding");
        hasMember = reallyHasMember(capiLibrary, "PyUnicodeEncodeError_GetEnd");
        if (!hasMember) messages.add("missing implementation: PyUnicodeEncodeError_GetEnd");
        hasMember = reallyHasMember(capiLibrary, "PyUnicodeEncodeError_GetObject");
        if (!hasMember) messages.add("missing implementation: PyUnicodeEncodeError_GetObject");
        hasMember = reallyHasMember(capiLibrary, "PyUnicodeEncodeError_GetReason");
        if (!hasMember) messages.add("missing implementation: PyUnicodeEncodeError_GetReason");
        hasMember = reallyHasMember(capiLibrary, "PyUnicodeEncodeError_GetStart");
        if (!hasMember) messages.add("missing implementation: PyUnicodeEncodeError_GetStart");
        hasMember = reallyHasMember(capiLibrary, "PyUnicodeEncodeError_SetEnd");
        if (!hasMember) messages.add("missing implementation: PyUnicodeEncodeError_SetEnd");
        hasMember = reallyHasMember(capiLibrary, "PyUnicodeEncodeError_SetReason");
        if (!hasMember) messages.add("missing implementation: PyUnicodeEncodeError_SetReason");
        hasMember = reallyHasMember(capiLibrary, "PyUnicodeEncodeError_SetStart");
        if (!hasMember) messages.add("missing implementation: PyUnicodeEncodeError_SetStart");
        hasMember = reallyHasMember(capiLibrary, "PyUnicodeTranslateError_GetEnd");
        if (!hasMember) messages.add("missing implementation: PyUnicodeTranslateError_GetEnd");
        hasMember = reallyHasMember(capiLibrary, "PyUnicodeTranslateError_GetObject");
        if (!hasMember) messages.add("missing implementation: PyUnicodeTranslateError_GetObject");
        hasMember = reallyHasMember(capiLibrary, "PyUnicodeTranslateError_GetReason");
        if (!hasMember) messages.add("missing implementation: PyUnicodeTranslateError_GetReason");
        hasMember = reallyHasMember(capiLibrary, "PyUnicodeTranslateError_GetStart");
        if (!hasMember) messages.add("missing implementation: PyUnicodeTranslateError_GetStart");
        hasMember = reallyHasMember(capiLibrary, "PyUnicodeTranslateError_SetEnd");
        if (!hasMember) messages.add("missing implementation: PyUnicodeTranslateError_SetEnd");
        hasMember = reallyHasMember(capiLibrary, "PyUnicodeTranslateError_SetReason");
        if (!hasMember) messages.add("missing implementation: PyUnicodeTranslateError_SetReason");
        hasMember = reallyHasMember(capiLibrary, "PyUnicodeTranslateError_SetStart");
        if (!hasMember) messages.add("missing implementation: PyUnicodeTranslateError_SetStart");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_Append");
        if (!hasMember) messages.add("missing implementation: PyUnicode_Append");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_AppendAndDel");
        if (!hasMember) messages.add("missing implementation: PyUnicode_AppendAndDel");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_AsASCIIString");
        if (!hasMember) messages.add("missing implementation: PyUnicode_AsASCIIString");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_AsCharmapString");
        if (!hasMember) messages.add("missing implementation: PyUnicode_AsCharmapString");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_AsDecodedObject");
        if (!hasMember) messages.add("missing implementation: PyUnicode_AsDecodedObject");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_AsDecodedUnicode");
        if (!hasMember) messages.add("missing implementation: PyUnicode_AsDecodedUnicode");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_AsEncodedObject");
        if (!hasMember) messages.add("missing implementation: PyUnicode_AsEncodedObject");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_AsEncodedString");
        if (!hasMember) messages.add("missing implementation: PyUnicode_AsEncodedString");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_AsEncodedUnicode");
        if (!hasMember) messages.add("missing implementation: PyUnicode_AsEncodedUnicode");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_AsLatin1String");
        if (!hasMember) messages.add("missing implementation: PyUnicode_AsLatin1String");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_AsMBCSString");
        if (!hasMember) messages.add("missing implementation: PyUnicode_AsMBCSString");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_AsRawUnicodeEscapeString");
        if (!hasMember) messages.add("missing implementation: PyUnicode_AsRawUnicodeEscapeString");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_AsUCS4");
        if (!hasMember) messages.add("missing implementation: PyUnicode_AsUCS4");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_AsUCS4Copy");
        if (!hasMember) messages.add("missing implementation: PyUnicode_AsUCS4Copy");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_AsUTF16String");
        if (!hasMember) messages.add("missing implementation: PyUnicode_AsUTF16String");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_AsUTF32String");
        if (!hasMember) messages.add("missing implementation: PyUnicode_AsUTF32String");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_AsUTF8");
        if (!hasMember) messages.add("missing implementation: PyUnicode_AsUTF8");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_AsUTF8AndSize");
        if (!hasMember) messages.add("missing implementation: PyUnicode_AsUTF8AndSize");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_AsUTF8String");
        if (!hasMember) messages.add("missing implementation: PyUnicode_AsUTF8String");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_AsUnicodeEscapeString");
        if (!hasMember) messages.add("missing implementation: PyUnicode_AsUnicodeEscapeString");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_AsWideChar");
        if (!hasMember) messages.add("missing implementation: PyUnicode_AsWideChar");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_AsWideCharString");
        if (!hasMember) messages.add("missing implementation: PyUnicode_AsWideCharString");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_BuildEncodingMap");
        if (!hasMember) messages.add("missing implementation: PyUnicode_BuildEncodingMap");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_Compare");
        if (!hasMember) messages.add("missing implementation: PyUnicode_Compare");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_CompareWithASCIIString");
        if (!hasMember) messages.add("missing implementation: PyUnicode_CompareWithASCIIString");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_Concat");
        if (!hasMember) messages.add("missing implementation: PyUnicode_Concat");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_Contains");
        if (!hasMember) messages.add("missing implementation: PyUnicode_Contains");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_CopyCharacters");
        if (!hasMember) messages.add("missing implementation: PyUnicode_CopyCharacters");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_Count");
        if (!hasMember) messages.add("missing implementation: PyUnicode_Count");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_Decode");
        if (!hasMember) messages.add("missing implementation: PyUnicode_Decode");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_DecodeASCII");
        if (!hasMember) messages.add("missing implementation: PyUnicode_DecodeASCII");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_DecodeCharmap");
        if (!hasMember) messages.add("missing implementation: PyUnicode_DecodeCharmap");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_DecodeCodePageStateful");
        if (!hasMember) messages.add("missing implementation: PyUnicode_DecodeCodePageStateful");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_DecodeFSDefault");
        if (!hasMember) messages.add("missing implementation: PyUnicode_DecodeFSDefault");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_DecodeFSDefaultAndSize");
        if (!hasMember) messages.add("missing implementation: PyUnicode_DecodeFSDefaultAndSize");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_DecodeLatin1");
        if (!hasMember) messages.add("missing implementation: PyUnicode_DecodeLatin1");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_DecodeLocale");
        if (!hasMember) messages.add("missing implementation: PyUnicode_DecodeLocale");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_DecodeLocaleAndSize");
        if (!hasMember) messages.add("missing implementation: PyUnicode_DecodeLocaleAndSize");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_DecodeMBCS");
        if (!hasMember) messages.add("missing implementation: PyUnicode_DecodeMBCS");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_DecodeMBCSStateful");
        if (!hasMember) messages.add("missing implementation: PyUnicode_DecodeMBCSStateful");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_DecodeRawUnicodeEscape");
        if (!hasMember) messages.add("missing implementation: PyUnicode_DecodeRawUnicodeEscape");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_DecodeUTF16");
        if (!hasMember) messages.add("missing implementation: PyUnicode_DecodeUTF16");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_DecodeUTF16Stateful");
        if (!hasMember) messages.add("missing implementation: PyUnicode_DecodeUTF16Stateful");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_DecodeUTF32");
        if (!hasMember) messages.add("missing implementation: PyUnicode_DecodeUTF32");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_DecodeUTF32Stateful");
        if (!hasMember) messages.add("missing implementation: PyUnicode_DecodeUTF32Stateful");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_DecodeUTF7");
        if (!hasMember) messages.add("missing implementation: PyUnicode_DecodeUTF7");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_DecodeUTF7Stateful");
        if (!hasMember) messages.add("missing implementation: PyUnicode_DecodeUTF7Stateful");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_DecodeUTF8");
        if (!hasMember) messages.add("missing implementation: PyUnicode_DecodeUTF8");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_DecodeUTF8Stateful");
        if (!hasMember) messages.add("missing implementation: PyUnicode_DecodeUTF8Stateful");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_DecodeUnicodeEscape");
        if (!hasMember) messages.add("missing implementation: PyUnicode_DecodeUnicodeEscape");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_EncodeCodePage");
        if (!hasMember) messages.add("missing implementation: PyUnicode_EncodeCodePage");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_EncodeFSDefault");
        if (!hasMember) messages.add("missing implementation: PyUnicode_EncodeFSDefault");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_EncodeLocale");
        if (!hasMember) messages.add("missing implementation: PyUnicode_EncodeLocale");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_FSConverter");
        if (!hasMember) messages.add("missing implementation: PyUnicode_FSConverter");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_FSDecoder");
        if (!hasMember) messages.add("missing implementation: PyUnicode_FSDecoder");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_Fill");
        if (!hasMember) messages.add("missing implementation: PyUnicode_Fill");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_Find");
        if (!hasMember) messages.add("missing implementation: PyUnicode_Find");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_FindChar");
        if (!hasMember) messages.add("missing implementation: PyUnicode_FindChar");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_Format");
        if (!hasMember) messages.add("missing implementation: PyUnicode_Format");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_FromEncodedObject");
        if (!hasMember) messages.add("missing implementation: PyUnicode_FromEncodedObject");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_FromFormat");
        if (!hasMember) messages.add("missing implementation: PyUnicode_FromFormat");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_FromFormatV");
        if (!hasMember) messages.add("missing implementation: PyUnicode_FromFormatV");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_FromKindAndData");
        if (!hasMember) messages.add("missing implementation: PyUnicode_FromKindAndData");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_FromObject");
        if (!hasMember) messages.add("missing implementation: PyUnicode_FromObject");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_FromOrdinal");
        if (!hasMember) messages.add("missing implementation: PyUnicode_FromOrdinal");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_FromString");
        if (!hasMember) messages.add("missing implementation: PyUnicode_FromString");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_FromStringAndSize");
        if (!hasMember) messages.add("missing implementation: PyUnicode_FromStringAndSize");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_FromWideChar");
        if (!hasMember) messages.add("missing implementation: PyUnicode_FromWideChar");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_GetDefaultEncoding");
        if (!hasMember) messages.add("missing implementation: PyUnicode_GetDefaultEncoding");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_GetLength");
        if (!hasMember) messages.add("missing implementation: PyUnicode_GetLength");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_InternFromString");
        if (!hasMember) messages.add("missing implementation: PyUnicode_InternFromString");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_InternInPlace");
        if (!hasMember) messages.add("missing implementation: PyUnicode_InternInPlace");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_IsIdentifier");
        if (!hasMember) messages.add("missing implementation: PyUnicode_IsIdentifier");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_Join");
        if (!hasMember) messages.add("missing implementation: PyUnicode_Join");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_New");
        if (!hasMember) messages.add("missing implementation: PyUnicode_New");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_Partition");
        if (!hasMember) messages.add("missing implementation: PyUnicode_Partition");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_RPartition");
        if (!hasMember) messages.add("missing implementation: PyUnicode_RPartition");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_RSplit");
        if (!hasMember) messages.add("missing implementation: PyUnicode_RSplit");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_ReadChar");
        if (!hasMember) messages.add("missing implementation: PyUnicode_ReadChar");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_Replace");
        if (!hasMember) messages.add("missing implementation: PyUnicode_Replace");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_Resize");
        if (!hasMember) messages.add("missing implementation: PyUnicode_Resize");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_RichCompare");
        if (!hasMember) messages.add("missing implementation: PyUnicode_RichCompare");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_Split");
        if (!hasMember) messages.add("missing implementation: PyUnicode_Split");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_Splitlines");
        if (!hasMember) messages.add("missing implementation: PyUnicode_Splitlines");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_Substring");
        if (!hasMember) messages.add("missing implementation: PyUnicode_Substring");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_Tailmatch");
        if (!hasMember) messages.add("missing implementation: PyUnicode_Tailmatch");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_Translate");
        if (!hasMember) messages.add("missing implementation: PyUnicode_Translate");
        hasMember = reallyHasMember(capiLibrary, "PyUnicode_WriteChar");
        if (!hasMember) messages.add("missing implementation: PyUnicode_WriteChar");
        hasMember = reallyHasMember(capiLibrary, "PyUnstable_Code_GetExtra");
        if (!hasMember) messages.add("missing implementation: PyUnstable_Code_GetExtra");
        hasMember = reallyHasMember(capiLibrary, "PyUnstable_Code_New");
        if (!hasMember) messages.add("missing implementation: PyUnstable_Code_New");
        hasMember = reallyHasMember(capiLibrary, "PyUnstable_Code_NewWithPosOnlyArgs");
        if (!hasMember) messages.add("missing implementation: PyUnstable_Code_NewWithPosOnlyArgs");
        hasMember = reallyHasMember(capiLibrary, "PyUnstable_Code_SetExtra");
        if (!hasMember) messages.add("missing implementation: PyUnstable_Code_SetExtra");
        hasMember = reallyHasMember(capiLibrary, "PyUnstable_Eval_RequestCodeExtraIndex");
        if (!hasMember) messages.add("missing implementation: PyUnstable_Eval_RequestCodeExtraIndex");
        hasMember = reallyHasMember(capiLibrary, "PyUnstable_Exc_PrepReraiseStar");
        if (!hasMember) messages.add("missing implementation: PyUnstable_Exc_PrepReraiseStar");
        hasMember = reallyHasMember(capiLibrary, "PyUnstable_GC_VisitObjects");
        if (!hasMember) messages.add("missing implementation: PyUnstable_GC_VisitObjects");
        hasMember = reallyHasMember(capiLibrary, "PyUnstable_InterpreterFrame_GetCode");
        if (!hasMember) messages.add("missing implementation: PyUnstable_InterpreterFrame_GetCode");
        hasMember = reallyHasMember(capiLibrary, "PyUnstable_InterpreterFrame_GetLasti");
        if (!hasMember) messages.add("missing implementation: PyUnstable_InterpreterFrame_GetLasti");
        hasMember = reallyHasMember(capiLibrary, "PyUnstable_InterpreterFrame_GetLine");
        if (!hasMember) messages.add("missing implementation: PyUnstable_InterpreterFrame_GetLine");
        hasMember = reallyHasMember(capiLibrary, "PyUnstable_Long_CompactValue");
        if (!hasMember) messages.add("missing implementation: PyUnstable_Long_CompactValue");
        hasMember = reallyHasMember(capiLibrary, "PyUnstable_Long_IsCompact");
        if (!hasMember) messages.add("missing implementation: PyUnstable_Long_IsCompact");
        hasMember = reallyHasMember(capiLibrary, "PyUnstable_Object_GC_NewWithExtraData");
        if (!hasMember) messages.add("missing implementation: PyUnstable_Object_GC_NewWithExtraData");
        hasMember = reallyHasMember(capiLibrary, "PyUnstable_PerfMapState_Fini");
        if (!hasMember) messages.add("missing implementation: PyUnstable_PerfMapState_Fini");
        hasMember = reallyHasMember(capiLibrary, "PyUnstable_PerfMapState_Init");
        if (!hasMember) messages.add("missing implementation: PyUnstable_PerfMapState_Init");
        hasMember = reallyHasMember(capiLibrary, "PyUnstable_Type_AssignVersionTag");
        if (!hasMember) messages.add("missing implementation: PyUnstable_Type_AssignVersionTag");
        hasMember = reallyHasMember(capiLibrary, "PyUnstable_WritePerfMapEntry");
        if (!hasMember) messages.add("missing implementation: PyUnstable_WritePerfMapEntry");
        hasMember = reallyHasMember(capiLibrary, "PyVectorcall_Call");
        if (!hasMember) messages.add("missing implementation: PyVectorcall_Call");
        hasMember = reallyHasMember(capiLibrary, "PyVectorcall_Call");
        if (!hasMember) messages.add("missing implementation: PyVectorcall_Call");
        hasMember = reallyHasMember(capiLibrary, "PyVectorcall_Function");
        if (!hasMember) messages.add("missing implementation: PyVectorcall_Function");
        hasMember = reallyHasMember(capiLibrary, "PyVectorcall_NARGS");
        if (!hasMember) messages.add("missing implementation: PyVectorcall_NARGS");
        hasMember = reallyHasMember(capiLibrary, "PyWeakref_GetObject");
        if (!hasMember) messages.add("missing implementation: PyWeakref_GetObject");
        hasMember = reallyHasMember(capiLibrary, "PyWeakref_NewProxy");
        if (!hasMember) messages.add("missing implementation: PyWeakref_NewProxy");
        hasMember = reallyHasMember(capiLibrary, "PyWeakref_NewRef");
        if (!hasMember) messages.add("missing implementation: PyWeakref_NewRef");
        hasMember = reallyHasMember(capiLibrary, "PyWideStringList_Append");
        if (!hasMember) messages.add("missing implementation: PyWideStringList_Append");
        hasMember = reallyHasMember(capiLibrary, "PyWideStringList_Insert");
        if (!hasMember) messages.add("missing implementation: PyWideStringList_Insert");
        hasMember = reallyHasMember(capiLibrary, "PyWrapper_New");
        if (!hasMember) messages.add("missing implementation: PyWrapper_New");
        hasMember = reallyHasMember(capiLibrary, "Py_AddPendingCall");
        if (!hasMember) messages.add("missing implementation: Py_AddPendingCall");
        hasMember = reallyHasMember(capiLibrary, "Py_AtExit");
        if (!hasMember) messages.add("missing implementation: Py_AtExit");
        hasMember = reallyHasMember(capiLibrary, "Py_BuildValue");
        if (!hasMember) messages.add("missing implementation: Py_BuildValue");
        hasMember = reallyHasMember(capiLibrary, "Py_BytesMain");
        if (!hasMember) messages.add("missing implementation: Py_BytesMain");
        hasMember = reallyHasMember(capiLibrary, "Py_CompileString");
        if (!hasMember) messages.add("missing implementation: Py_CompileString");
        hasMember = reallyHasMember(capiLibrary, "Py_CompileStringExFlags");
        if (!hasMember) messages.add("missing implementation: Py_CompileStringExFlags");
        hasMember = reallyHasMember(capiLibrary, "Py_CompileStringObject");
        if (!hasMember) messages.add("missing implementation: Py_CompileStringObject");
        hasMember = reallyHasMember(capiLibrary, "Py_DecRef");
        if (!hasMember) messages.add("missing implementation: Py_DecRef");
        hasMember = reallyHasMember(capiLibrary, "Py_DecodeLocale");
        if (!hasMember) messages.add("missing implementation: Py_DecodeLocale");
        hasMember = reallyHasMember(capiLibrary, "Py_EncodeLocale");
        if (!hasMember) messages.add("missing implementation: Py_EncodeLocale");
        hasMember = reallyHasMember(capiLibrary, "Py_EndInterpreter");
        if (!hasMember) messages.add("missing implementation: Py_EndInterpreter");
        hasMember = reallyHasMember(capiLibrary, "Py_EnterRecursiveCall");
        if (!hasMember) messages.add("missing implementation: Py_EnterRecursiveCall");
        hasMember = reallyHasMember(capiLibrary, "Py_Exit");
        if (!hasMember) messages.add("missing implementation: Py_Exit");
        hasMember = reallyHasMember(capiLibrary, "Py_ExitStatusException");
        if (!hasMember) messages.add("missing implementation: Py_ExitStatusException");
        hasMember = reallyHasMember(capiLibrary, "Py_FatalError");
        if (!hasMember) messages.add("missing implementation: Py_FatalError");
        hasMember = reallyHasMember(capiLibrary, "Py_FdIsInteractive");
        if (!hasMember) messages.add("missing implementation: Py_FdIsInteractive");
        hasMember = reallyHasMember(capiLibrary, "Py_Finalize");
        if (!hasMember) messages.add("missing implementation: Py_Finalize");
        hasMember = reallyHasMember(capiLibrary, "Py_FinalizeEx");
        if (!hasMember) messages.add("missing implementation: Py_FinalizeEx");
        hasMember = reallyHasMember(capiLibrary, "Py_FrozenMain");
        if (!hasMember) messages.add("missing implementation: Py_FrozenMain");
        hasMember = reallyHasMember(capiLibrary, "Py_GETENV");
        if (!hasMember) messages.add("missing implementation: Py_GETENV");
        hasMember = reallyHasMember(capiLibrary, "Py_GenericAlias");
        if (!hasMember) messages.add("missing implementation: Py_GenericAlias");
        hasMember = reallyHasMember(capiLibrary, "Py_GetArgcArgv");
        if (!hasMember) messages.add("missing implementation: Py_GetArgcArgv");
        hasMember = reallyHasMember(capiLibrary, "Py_GetBuildInfo");
        if (!hasMember) messages.add("missing implementation: Py_GetBuildInfo");
        hasMember = reallyHasMember(capiLibrary, "Py_GetCompiler");
        if (!hasMember) messages.add("missing implementation: Py_GetCompiler");
        hasMember = reallyHasMember(capiLibrary, "Py_GetCopyright");
        if (!hasMember) messages.add("missing implementation: Py_GetCopyright");
        hasMember = reallyHasMember(capiLibrary, "Py_GetExecPrefix");
        if (!hasMember) messages.add("missing implementation: Py_GetExecPrefix");
        hasMember = reallyHasMember(capiLibrary, "Py_GetPath");
        if (!hasMember) messages.add("missing implementation: Py_GetPath");
        hasMember = reallyHasMember(capiLibrary, "Py_GetPlatform");
        if (!hasMember) messages.add("missing implementation: Py_GetPlatform");
        hasMember = reallyHasMember(capiLibrary, "Py_GetPrefix");
        if (!hasMember) messages.add("missing implementation: Py_GetPrefix");
        hasMember = reallyHasMember(capiLibrary, "Py_GetProgramFullPath");
        if (!hasMember) messages.add("missing implementation: Py_GetProgramFullPath");
        hasMember = reallyHasMember(capiLibrary, "Py_GetProgramName");
        if (!hasMember) messages.add("missing implementation: Py_GetProgramName");
        hasMember = reallyHasMember(capiLibrary, "Py_GetPythonHome");
        if (!hasMember) messages.add("missing implementation: Py_GetPythonHome");
        hasMember = reallyHasMember(capiLibrary, "Py_GetRecursionLimit");
        if (!hasMember) messages.add("missing implementation: Py_GetRecursionLimit");
        hasMember = reallyHasMember(capiLibrary, "Py_GetVersion");
        if (!hasMember) messages.add("missing implementation: Py_GetVersion");
        hasMember = reallyHasMember(capiLibrary, "Py_IncRef");
        if (!hasMember) messages.add("missing implementation: Py_IncRef");
        hasMember = reallyHasMember(capiLibrary, "Py_Initialize");
        if (!hasMember) messages.add("missing implementation: Py_Initialize");
        hasMember = reallyHasMember(capiLibrary, "Py_InitializeEx");
        if (!hasMember) messages.add("missing implementation: Py_InitializeEx");
        hasMember = reallyHasMember(capiLibrary, "Py_InitializeFromConfig");
        if (!hasMember) messages.add("missing implementation: Py_InitializeFromConfig");
        hasMember = reallyHasMember(capiLibrary, "Py_Is");
        if (!hasMember) messages.add("missing implementation: Py_Is");
        hasMember = reallyHasMember(capiLibrary, "Py_IsFalse");
        if (!hasMember) messages.add("missing implementation: Py_IsFalse");
        hasMember = reallyHasMember(capiLibrary, "Py_IsInitialized");
        if (!hasMember) messages.add("missing implementation: Py_IsInitialized");
        hasMember = reallyHasMember(capiLibrary, "Py_IsNone");
        if (!hasMember) messages.add("missing implementation: Py_IsNone");
        hasMember = reallyHasMember(capiLibrary, "Py_IsTrue");
        if (!hasMember) messages.add("missing implementation: Py_IsTrue");
        hasMember = reallyHasMember(capiLibrary, "Py_LeaveRecursiveCall");
        if (!hasMember) messages.add("missing implementation: Py_LeaveRecursiveCall");
        hasMember = reallyHasMember(capiLibrary, "Py_Main");
        if (!hasMember) messages.add("missing implementation: Py_Main");
        hasMember = reallyHasMember(capiLibrary, "Py_MakePendingCalls");
        if (!hasMember) messages.add("missing implementation: Py_MakePendingCalls");
        hasMember = reallyHasMember(capiLibrary, "Py_NewInterpreter");
        if (!hasMember) messages.add("missing implementation: Py_NewInterpreter");
        hasMember = reallyHasMember(capiLibrary, "Py_NewInterpreterFromConfig");
        if (!hasMember) messages.add("missing implementation: Py_NewInterpreterFromConfig");
        hasMember = reallyHasMember(capiLibrary, "Py_NewRef");
        if (!hasMember) messages.add("missing implementation: Py_NewRef");
        hasMember = reallyHasMember(capiLibrary, "Py_PreInitialize");
        if (!hasMember) messages.add("missing implementation: Py_PreInitialize");
        hasMember = reallyHasMember(capiLibrary, "Py_PreInitializeFromArgs");
        if (!hasMember) messages.add("missing implementation: Py_PreInitializeFromArgs");
        hasMember = reallyHasMember(capiLibrary, "Py_PreInitializeFromBytesArgs");
        if (!hasMember) messages.add("missing implementation: Py_PreInitializeFromBytesArgs");
        hasMember = reallyHasMember(capiLibrary, "Py_ReprEnter");
        if (!hasMember) messages.add("missing implementation: Py_ReprEnter");
        hasMember = reallyHasMember(capiLibrary, "Py_ReprLeave");
        if (!hasMember) messages.add("missing implementation: Py_ReprLeave");
        hasMember = reallyHasMember(capiLibrary, "Py_RunMain");
        if (!hasMember) messages.add("missing implementation: Py_RunMain");
        hasMember = reallyHasMember(capiLibrary, "Py_SetPath");
        if (!hasMember) messages.add("missing implementation: Py_SetPath");
        hasMember = reallyHasMember(capiLibrary, "Py_SetProgramName");
        if (!hasMember) messages.add("missing implementation: Py_SetProgramName");
        hasMember = reallyHasMember(capiLibrary, "Py_SetPythonHome");
        if (!hasMember) messages.add("missing implementation: Py_SetPythonHome");
        hasMember = reallyHasMember(capiLibrary, "Py_SetRecursionLimit");
        if (!hasMember) messages.add("missing implementation: Py_SetRecursionLimit");
        hasMember = reallyHasMember(capiLibrary, "Py_SetStandardStreamEncoding");
        if (!hasMember) messages.add("missing implementation: Py_SetStandardStreamEncoding");
        hasMember = reallyHasMember(capiLibrary, "Py_UniversalNewlineFgets");
        if (!hasMember) messages.add("missing implementation: Py_UniversalNewlineFgets");
        hasMember = reallyHasMember(capiLibrary, "Py_VaBuildValue");
        if (!hasMember) messages.add("missing implementation: Py_VaBuildValue");
        hasMember = reallyHasMember(capiLibrary, "Py_XNewRef");
        if (!hasMember) messages.add("missing implementation: Py_XNewRef");
        hasMember = reallyHasMember(capiLibrary, "_PyArg_BadArgument");
        if (!hasMember) messages.add("missing implementation: _PyArg_BadArgument");
        hasMember = reallyHasMember(capiLibrary, "_PyArg_CheckPositional");
        if (!hasMember) messages.add("missing implementation: _PyArg_CheckPositional");
        hasMember = reallyHasMember(capiLibrary, "_PyArg_NoKeywords");
        if (!hasMember) messages.add("missing implementation: _PyArg_NoKeywords");
        hasMember = reallyHasMember(capiLibrary, "_PyArg_NoKwnames");
        if (!hasMember) messages.add("missing implementation: _PyArg_NoKwnames");
        hasMember = reallyHasMember(capiLibrary, "_PyArg_NoPositional");
        if (!hasMember) messages.add("missing implementation: _PyArg_NoPositional");
        hasMember = reallyHasMember(capiLibrary, "_PyArg_ParseStack");
        if (!hasMember) messages.add("missing implementation: _PyArg_ParseStack");
        hasMember = reallyHasMember(capiLibrary, "_PyArg_ParseStackAndKeywords");
        if (!hasMember) messages.add("missing implementation: _PyArg_ParseStackAndKeywords");
        hasMember = reallyHasMember(capiLibrary, "_PyArg_ParseTupleAndKeywordsFast");
        if (!hasMember) messages.add("missing implementation: _PyArg_ParseTupleAndKeywordsFast");
        hasMember = reallyHasMember(capiLibrary, "_PyArg_UnpackKeywords");
        if (!hasMember) messages.add("missing implementation: _PyArg_UnpackKeywords");
        hasMember = reallyHasMember(capiLibrary, "_PyArg_UnpackKeywordsWithVararg");
        if (!hasMember) messages.add("missing implementation: _PyArg_UnpackKeywordsWithVararg");
        hasMember = reallyHasMember(capiLibrary, "_PyArg_UnpackStack");
        if (!hasMember) messages.add("missing implementation: _PyArg_UnpackStack");
        hasMember = reallyHasMember(capiLibrary, "_PyArg_VaParseTupleAndKeywordsFast");
        if (!hasMember) messages.add("missing implementation: _PyArg_VaParseTupleAndKeywordsFast");
        hasMember = reallyHasMember(capiLibrary, "_PyBytesWriter_Alloc");
        if (!hasMember) messages.add("missing implementation: _PyBytesWriter_Alloc");
        hasMember = reallyHasMember(capiLibrary, "_PyBytesWriter_Dealloc");
        if (!hasMember) messages.add("missing implementation: _PyBytesWriter_Dealloc");
        hasMember = reallyHasMember(capiLibrary, "_PyBytesWriter_Finish");
        if (!hasMember) messages.add("missing implementation: _PyBytesWriter_Finish");
        hasMember = reallyHasMember(capiLibrary, "_PyBytesWriter_Init");
        if (!hasMember) messages.add("missing implementation: _PyBytesWriter_Init");
        hasMember = reallyHasMember(capiLibrary, "_PyBytesWriter_Prepare");
        if (!hasMember) messages.add("missing implementation: _PyBytesWriter_Prepare");
        hasMember = reallyHasMember(capiLibrary, "_PyBytesWriter_Resize");
        if (!hasMember) messages.add("missing implementation: _PyBytesWriter_Resize");
        hasMember = reallyHasMember(capiLibrary, "_PyBytesWriter_WriteBytes");
        if (!hasMember) messages.add("missing implementation: _PyBytesWriter_WriteBytes");
        hasMember = reallyHasMember(capiLibrary, "_PyBytes_DecodeEscape");
        if (!hasMember) messages.add("missing implementation: _PyBytes_DecodeEscape");
        hasMember = reallyHasMember(capiLibrary, "_PyBytes_FormatEx");
        if (!hasMember) messages.add("missing implementation: _PyBytes_FormatEx");
        hasMember = reallyHasMember(capiLibrary, "_PyBytes_FromHex");
        if (!hasMember) messages.add("missing implementation: _PyBytes_FromHex");
        hasMember = reallyHasMember(capiLibrary, "_PyBytes_Join");
        if (!hasMember) messages.add("missing implementation: _PyBytes_Join");
        hasMember = reallyHasMember(capiLibrary, "_PyBytes_Resize");
        if (!hasMember) messages.add("missing implementation: _PyBytes_Resize");
        hasMember = reallyHasMember(capiLibrary, "_PyCode_CheckLineNumber");
        if (!hasMember) messages.add("missing implementation: _PyCode_CheckLineNumber");
        hasMember = reallyHasMember(capiLibrary, "_PyCode_ConstantKey");
        if (!hasMember) messages.add("missing implementation: _PyCode_ConstantKey");
        hasMember = reallyHasMember(capiLibrary, "_PyCodecInfo_GetIncrementalDecoder");
        if (!hasMember) messages.add("missing implementation: _PyCodecInfo_GetIncrementalDecoder");
        hasMember = reallyHasMember(capiLibrary, "_PyCodecInfo_GetIncrementalEncoder");
        if (!hasMember) messages.add("missing implementation: _PyCodecInfo_GetIncrementalEncoder");
        hasMember = reallyHasMember(capiLibrary, "_PyCodec_DecodeText");
        if (!hasMember) messages.add("missing implementation: _PyCodec_DecodeText");
        hasMember = reallyHasMember(capiLibrary, "_PyCodec_EncodeText");
        if (!hasMember) messages.add("missing implementation: _PyCodec_EncodeText");
        hasMember = reallyHasMember(capiLibrary, "_PyCodec_Lookup");
        if (!hasMember) messages.add("missing implementation: _PyCodec_Lookup");
        hasMember = reallyHasMember(capiLibrary, "_PyCodec_LookupTextEncoding");
        if (!hasMember) messages.add("missing implementation: _PyCodec_LookupTextEncoding");
        hasMember = reallyHasMember(capiLibrary, "_PyContext_NewHamtForTests");
        if (!hasMember) messages.add("missing implementation: _PyContext_NewHamtForTests");
        hasMember = reallyHasMember(capiLibrary, "_PyCrossInterpreterData_Clear");
        if (!hasMember) messages.add("missing implementation: _PyCrossInterpreterData_Clear");
        hasMember = reallyHasMember(capiLibrary, "_PyCrossInterpreterData_Init");
        if (!hasMember) messages.add("missing implementation: _PyCrossInterpreterData_Init");
        hasMember = reallyHasMember(capiLibrary, "_PyCrossInterpreterData_InitWithSize");
        if (!hasMember) messages.add("missing implementation: _PyCrossInterpreterData_InitWithSize");
        hasMember = reallyHasMember(capiLibrary, "_PyCrossInterpreterData_Lookup");
        if (!hasMember) messages.add("missing implementation: _PyCrossInterpreterData_Lookup");
        hasMember = reallyHasMember(capiLibrary, "_PyCrossInterpreterData_NewObject");
        if (!hasMember) messages.add("missing implementation: _PyCrossInterpreterData_NewObject");
        hasMember = reallyHasMember(capiLibrary, "_PyCrossInterpreterData_RegisterClass");
        if (!hasMember) messages.add("missing implementation: _PyCrossInterpreterData_RegisterClass");
        hasMember = reallyHasMember(capiLibrary, "_PyCrossInterpreterData_Release");
        if (!hasMember) messages.add("missing implementation: _PyCrossInterpreterData_Release");
        hasMember = reallyHasMember(capiLibrary, "_PyCrossInterpreterData_UnregisterClass");
        if (!hasMember) messages.add("missing implementation: _PyCrossInterpreterData_UnregisterClass");
        hasMember = reallyHasMember(capiLibrary, "_PyDeadline_Get");
        if (!hasMember) messages.add("missing implementation: _PyDeadline_Get");
        hasMember = reallyHasMember(capiLibrary, "_PyDeadline_Init");
        if (!hasMember) messages.add("missing implementation: _PyDeadline_Init");
        hasMember = reallyHasMember(capiLibrary, "_PyDebugAllocatorStats");
        if (!hasMember) messages.add("missing implementation: _PyDebugAllocatorStats");
        hasMember = reallyHasMember(capiLibrary, "_PyDictView_Intersect");
        if (!hasMember) messages.add("missing implementation: _PyDictView_Intersect");
        hasMember = reallyHasMember(capiLibrary, "_PyDictView_New");
        if (!hasMember) messages.add("missing implementation: _PyDictView_New");
        hasMember = reallyHasMember(capiLibrary, "_PyDict_ContainsId");
        if (!hasMember) messages.add("missing implementation: _PyDict_ContainsId");
        hasMember = reallyHasMember(capiLibrary, "_PyDict_Contains_KnownHash");
        if (!hasMember) messages.add("missing implementation: _PyDict_Contains_KnownHash");
        hasMember = reallyHasMember(capiLibrary, "_PyDict_DebugMallocStats");
        if (!hasMember) messages.add("missing implementation: _PyDict_DebugMallocStats");
        hasMember = reallyHasMember(capiLibrary, "_PyDict_DelItemId");
        if (!hasMember) messages.add("missing implementation: _PyDict_DelItemId");
        hasMember = reallyHasMember(capiLibrary, "_PyDict_DelItemIf");
        if (!hasMember) messages.add("missing implementation: _PyDict_DelItemIf");
        hasMember = reallyHasMember(capiLibrary, "_PyDict_DelItem_KnownHash");
        if (!hasMember) messages.add("missing implementation: _PyDict_DelItem_KnownHash");
        hasMember = reallyHasMember(capiLibrary, "_PyDict_GetItemIdWithError");
        if (!hasMember) messages.add("missing implementation: _PyDict_GetItemIdWithError");
        hasMember = reallyHasMember(capiLibrary, "_PyDict_GetItemStringWithError");
        if (!hasMember) messages.add("missing implementation: _PyDict_GetItemStringWithError");
        hasMember = reallyHasMember(capiLibrary, "_PyDict_GetItemWithError");
        if (!hasMember) messages.add("missing implementation: _PyDict_GetItemWithError");
        hasMember = reallyHasMember(capiLibrary, "_PyDict_GetItem_KnownHash");
        if (!hasMember) messages.add("missing implementation: _PyDict_GetItem_KnownHash");
        hasMember = reallyHasMember(capiLibrary, "_PyDict_HasOnlyStringKeys");
        if (!hasMember) messages.add("missing implementation: _PyDict_HasOnlyStringKeys");
        hasMember = reallyHasMember(capiLibrary, "_PyDict_MaybeUntrack");
        if (!hasMember) messages.add("missing implementation: _PyDict_MaybeUntrack");
        hasMember = reallyHasMember(capiLibrary, "_PyDict_MergeEx");
        if (!hasMember) messages.add("missing implementation: _PyDict_MergeEx");
        hasMember = reallyHasMember(capiLibrary, "_PyDict_NewPresized");
        if (!hasMember) messages.add("missing implementation: _PyDict_NewPresized");
        hasMember = reallyHasMember(capiLibrary, "_PyDict_Next");
        if (!hasMember) messages.add("missing implementation: _PyDict_Next");
        hasMember = reallyHasMember(capiLibrary, "_PyDict_Pop");
        if (!hasMember) messages.add("missing implementation: _PyDict_Pop");
        hasMember = reallyHasMember(capiLibrary, "_PyDict_SetItemId");
        if (!hasMember) messages.add("missing implementation: _PyDict_SetItemId");
        hasMember = reallyHasMember(capiLibrary, "_PyDict_SetItem_KnownHash");
        if (!hasMember) messages.add("missing implementation: _PyDict_SetItem_KnownHash");
        hasMember = reallyHasMember(capiLibrary, "_PyDict_SizeOf");
        if (!hasMember) messages.add("missing implementation: _PyDict_SizeOf");
        hasMember = reallyHasMember(capiLibrary, "_PyErr_BadInternalCall");
        if (!hasMember) messages.add("missing implementation: _PyErr_BadInternalCall");
        hasMember = reallyHasMember(capiLibrary, "_PyErr_ChainExceptions");
        if (!hasMember) messages.add("missing implementation: _PyErr_ChainExceptions");
        hasMember = reallyHasMember(capiLibrary, "_PyErr_ChainExceptions1");
        if (!hasMember) messages.add("missing implementation: _PyErr_ChainExceptions1");
        hasMember = reallyHasMember(capiLibrary, "_PyErr_CheckSignals");
        if (!hasMember) messages.add("missing implementation: _PyErr_CheckSignals");
        hasMember = reallyHasMember(capiLibrary, "_PyErr_FormatFromCause");
        if (!hasMember) messages.add("missing implementation: _PyErr_FormatFromCause");
        hasMember = reallyHasMember(capiLibrary, "_PyErr_GetExcInfo");
        if (!hasMember) messages.add("missing implementation: _PyErr_GetExcInfo");
        hasMember = reallyHasMember(capiLibrary, "_PyErr_GetHandledException");
        if (!hasMember) messages.add("missing implementation: _PyErr_GetHandledException");
        hasMember = reallyHasMember(capiLibrary, "_PyErr_GetTopmostException");
        if (!hasMember) messages.add("missing implementation: _PyErr_GetTopmostException");
        hasMember = reallyHasMember(capiLibrary, "_PyErr_ProgramDecodedTextObject");
        if (!hasMember) messages.add("missing implementation: _PyErr_ProgramDecodedTextObject");
        hasMember = reallyHasMember(capiLibrary, "_PyErr_SetFromPyStatus");
        if (!hasMember) messages.add("missing implementation: _PyErr_SetFromPyStatus");
        hasMember = reallyHasMember(capiLibrary, "_PyErr_SetHandledException");
        if (!hasMember) messages.add("missing implementation: _PyErr_SetHandledException");
        hasMember = reallyHasMember(capiLibrary, "_PyErr_SetKeyError");
        if (!hasMember) messages.add("missing implementation: _PyErr_SetKeyError");
        hasMember = reallyHasMember(capiLibrary, "_PyErr_WriteUnraisableMsg");
        if (!hasMember) messages.add("missing implementation: _PyErr_WriteUnraisableMsg");
        hasMember = reallyHasMember(capiLibrary, "_PyEval_EvalFrameDefault");
        if (!hasMember) messages.add("missing implementation: _PyEval_EvalFrameDefault");
        hasMember = reallyHasMember(capiLibrary, "_PyEval_GetBuiltin");
        if (!hasMember) messages.add("missing implementation: _PyEval_GetBuiltin");
        hasMember = reallyHasMember(capiLibrary, "_PyEval_GetBuiltinId");
        if (!hasMember) messages.add("missing implementation: _PyEval_GetBuiltinId");
        hasMember = reallyHasMember(capiLibrary, "_PyEval_GetSwitchInterval");
        if (!hasMember) messages.add("missing implementation: _PyEval_GetSwitchInterval");
        hasMember = reallyHasMember(capiLibrary, "_PyEval_MakePendingCalls");
        if (!hasMember) messages.add("missing implementation: _PyEval_MakePendingCalls");
        hasMember = reallyHasMember(capiLibrary, "_PyEval_SetProfile");
        if (!hasMember) messages.add("missing implementation: _PyEval_SetProfile");
        hasMember = reallyHasMember(capiLibrary, "_PyEval_SetSwitchInterval");
        if (!hasMember) messages.add("missing implementation: _PyEval_SetSwitchInterval");
        hasMember = reallyHasMember(capiLibrary, "_PyEval_SetTrace");
        if (!hasMember) messages.add("missing implementation: _PyEval_SetTrace");
        hasMember = reallyHasMember(capiLibrary, "_PyEval_SliceIndex");
        if (!hasMember) messages.add("missing implementation: _PyEval_SliceIndex");
        hasMember = reallyHasMember(capiLibrary, "_PyEval_SliceIndexNotNone");
        if (!hasMember) messages.add("missing implementation: _PyEval_SliceIndexNotNone");
        hasMember = reallyHasMember(capiLibrary, "_PyException_AddNote");
        if (!hasMember) messages.add("missing implementation: _PyException_AddNote");
        hasMember = reallyHasMember(capiLibrary, "_PyFrame_IsEntryFrame");
        if (!hasMember) messages.add("missing implementation: _PyFrame_IsEntryFrame");
        hasMember = reallyHasMember(capiLibrary, "_PyFunction_Vectorcall");
        if (!hasMember) messages.add("missing implementation: _PyFunction_Vectorcall");
        hasMember = reallyHasMember(capiLibrary, "_PyGILState_GetInterpreterStateUnsafe");
        if (!hasMember) messages.add("missing implementation: _PyGILState_GetInterpreterStateUnsafe");
        hasMember = reallyHasMember(capiLibrary, "_PyGen_FetchStopIterationValue");
        if (!hasMember) messages.add("missing implementation: _PyGen_FetchStopIterationValue");
        hasMember = reallyHasMember(capiLibrary, "_PyGen_Finalize");
        if (!hasMember) messages.add("missing implementation: _PyGen_Finalize");
        hasMember = reallyHasMember(capiLibrary, "_PyGen_SetStopIterationValue");
        if (!hasMember) messages.add("missing implementation: _PyGen_SetStopIterationValue");
        hasMember = reallyHasMember(capiLibrary, "_PyImport_AcquireLock");
        if (!hasMember) messages.add("missing implementation: _PyImport_AcquireLock");
        hasMember = reallyHasMember(capiLibrary, "_PyImport_FixupBuiltin");
        if (!hasMember) messages.add("missing implementation: _PyImport_FixupBuiltin");
        hasMember = reallyHasMember(capiLibrary, "_PyImport_FixupExtensionObject");
        if (!hasMember) messages.add("missing implementation: _PyImport_FixupExtensionObject");
        hasMember = reallyHasMember(capiLibrary, "_PyImport_GetModuleAttr");
        if (!hasMember) messages.add("missing implementation: _PyImport_GetModuleAttr");
        hasMember = reallyHasMember(capiLibrary, "_PyImport_GetModuleAttrString");
        if (!hasMember) messages.add("missing implementation: _PyImport_GetModuleAttrString");
        hasMember = reallyHasMember(capiLibrary, "_PyImport_GetModuleId");
        if (!hasMember) messages.add("missing implementation: _PyImport_GetModuleId");
        hasMember = reallyHasMember(capiLibrary, "_PyImport_IsInitialized");
        if (!hasMember) messages.add("missing implementation: _PyImport_IsInitialized");
        hasMember = reallyHasMember(capiLibrary, "_PyImport_ReleaseLock");
        if (!hasMember) messages.add("missing implementation: _PyImport_ReleaseLock");
        hasMember = reallyHasMember(capiLibrary, "_PyImport_SetModule");
        if (!hasMember) messages.add("missing implementation: _PyImport_SetModule");
        hasMember = reallyHasMember(capiLibrary, "_PyImport_SetModuleString");
        if (!hasMember) messages.add("missing implementation: _PyImport_SetModuleString");
        hasMember = reallyHasMember(capiLibrary, "_PyInterpreterState_GetConfig");
        if (!hasMember) messages.add("missing implementation: _PyInterpreterState_GetConfig");
        hasMember = reallyHasMember(capiLibrary, "_PyInterpreterState_GetConfigCopy");
        if (!hasMember) messages.add("missing implementation: _PyInterpreterState_GetConfigCopy");
        hasMember = reallyHasMember(capiLibrary, "_PyInterpreterState_GetEvalFrameFunc");
        if (!hasMember) messages.add("missing implementation: _PyInterpreterState_GetEvalFrameFunc");
        hasMember = reallyHasMember(capiLibrary, "_PyInterpreterState_GetMainModule");
        if (!hasMember) messages.add("missing implementation: _PyInterpreterState_GetMainModule");
        hasMember = reallyHasMember(capiLibrary, "_PyInterpreterState_HasFeature");
        if (!hasMember) messages.add("missing implementation: _PyInterpreterState_HasFeature");
        hasMember = reallyHasMember(capiLibrary, "_PyInterpreterState_RequireIDRef");
        if (!hasMember) messages.add("missing implementation: _PyInterpreterState_RequireIDRef");
        hasMember = reallyHasMember(capiLibrary, "_PyInterpreterState_RequiresIDRef");
        if (!hasMember) messages.add("missing implementation: _PyInterpreterState_RequiresIDRef");
        hasMember = reallyHasMember(capiLibrary, "_PyInterpreterState_SetConfig");
        if (!hasMember) messages.add("missing implementation: _PyInterpreterState_SetConfig");
        hasMember = reallyHasMember(capiLibrary, "_PyInterpreterState_SetEvalFrameFunc");
        if (!hasMember) messages.add("missing implementation: _PyInterpreterState_SetEvalFrameFunc");
        hasMember = reallyHasMember(capiLibrary, "_PyList_DebugMallocStats");
        if (!hasMember) messages.add("missing implementation: _PyList_DebugMallocStats");
        hasMember = reallyHasMember(capiLibrary, "_PyList_Extend");
        if (!hasMember) messages.add("missing implementation: _PyList_Extend");
        hasMember = reallyHasMember(capiLibrary, "_PyLong_AsByteArray");
        if (!hasMember) messages.add("missing implementation: _PyLong_AsByteArray");
        hasMember = reallyHasMember(capiLibrary, "_PyLong_AsInt");
        if (!hasMember) messages.add("missing implementation: _PyLong_AsInt");
        hasMember = reallyHasMember(capiLibrary, "_PyLong_AsTime_t");
        if (!hasMember) messages.add("missing implementation: _PyLong_AsTime_t");
        hasMember = reallyHasMember(capiLibrary, "_PyLong_Copy");
        if (!hasMember) messages.add("missing implementation: _PyLong_Copy");
        hasMember = reallyHasMember(capiLibrary, "_PyLong_DivmodNear");
        if (!hasMember) messages.add("missing implementation: _PyLong_DivmodNear");
        hasMember = reallyHasMember(capiLibrary, "_PyLong_FileDescriptor_Converter");
        if (!hasMember) messages.add("missing implementation: _PyLong_FileDescriptor_Converter");
        hasMember = reallyHasMember(capiLibrary, "_PyLong_Format");
        if (!hasMember) messages.add("missing implementation: _PyLong_Format");
        hasMember = reallyHasMember(capiLibrary, "_PyLong_Frexp");
        if (!hasMember) messages.add("missing implementation: _PyLong_Frexp");
        hasMember = reallyHasMember(capiLibrary, "_PyLong_FromByteArray");
        if (!hasMember) messages.add("missing implementation: _PyLong_FromByteArray");
        hasMember = reallyHasMember(capiLibrary, "_PyLong_FromBytes");
        if (!hasMember) messages.add("missing implementation: _PyLong_FromBytes");
        hasMember = reallyHasMember(capiLibrary, "_PyLong_FromDigits");
        if (!hasMember) messages.add("missing implementation: _PyLong_FromDigits");
        hasMember = reallyHasMember(capiLibrary, "_PyLong_FromTime_t");
        if (!hasMember) messages.add("missing implementation: _PyLong_FromTime_t");
        hasMember = reallyHasMember(capiLibrary, "_PyLong_GCD");
        if (!hasMember) messages.add("missing implementation: _PyLong_GCD");
        hasMember = reallyHasMember(capiLibrary, "_PyLong_Lshift");
        if (!hasMember) messages.add("missing implementation: _PyLong_Lshift");
        hasMember = reallyHasMember(capiLibrary, "_PyLong_New");
        if (!hasMember) messages.add("missing implementation: _PyLong_New");
        hasMember = reallyHasMember(capiLibrary, "_PyLong_NumBits");
        if (!hasMember) messages.add("missing implementation: _PyLong_NumBits");
        hasMember = reallyHasMember(capiLibrary, "_PyLong_Rshift");
        if (!hasMember) messages.add("missing implementation: _PyLong_Rshift");
        hasMember = reallyHasMember(capiLibrary, "_PyLong_Sign");
        if (!hasMember) messages.add("missing implementation: _PyLong_Sign");
        hasMember = reallyHasMember(capiLibrary, "_PyLong_Size_t_Converter");
        if (!hasMember) messages.add("missing implementation: _PyLong_Size_t_Converter");
        hasMember = reallyHasMember(capiLibrary, "_PyLong_UnsignedInt_Converter");
        if (!hasMember) messages.add("missing implementation: _PyLong_UnsignedInt_Converter");
        hasMember = reallyHasMember(capiLibrary, "_PyLong_UnsignedLongLong_Converter");
        if (!hasMember) messages.add("missing implementation: _PyLong_UnsignedLongLong_Converter");
        hasMember = reallyHasMember(capiLibrary, "_PyLong_UnsignedLong_Converter");
        if (!hasMember) messages.add("missing implementation: _PyLong_UnsignedLong_Converter");
        hasMember = reallyHasMember(capiLibrary, "_PyLong_UnsignedShort_Converter");
        if (!hasMember) messages.add("missing implementation: _PyLong_UnsignedShort_Converter");
        hasMember = reallyHasMember(capiLibrary, "_PyMem_GetCurrentAllocatorName");
        if (!hasMember) messages.add("missing implementation: _PyMem_GetCurrentAllocatorName");
        hasMember = reallyHasMember(capiLibrary, "_PyMem_RawStrdup");
        if (!hasMember) messages.add("missing implementation: _PyMem_RawStrdup");
        hasMember = reallyHasMember(capiLibrary, "_PyMem_RawWcsdup");
        if (!hasMember) messages.add("missing implementation: _PyMem_RawWcsdup");
        hasMember = reallyHasMember(capiLibrary, "_PyMem_Strdup");
        if (!hasMember) messages.add("missing implementation: _PyMem_Strdup");
        hasMember = reallyHasMember(capiLibrary, "_PyModuleSpec_IsInitializing");
        if (!hasMember) messages.add("missing implementation: _PyModuleSpec_IsInitializing");
        hasMember = reallyHasMember(capiLibrary, "_PyModule_Add");
        if (!hasMember) messages.add("missing implementation: _PyModule_Add");
        hasMember = reallyHasMember(capiLibrary, "_PyModule_Clear");
        if (!hasMember) messages.add("missing implementation: _PyModule_Clear");
        hasMember = reallyHasMember(capiLibrary, "_PyModule_ClearDict");
        if (!hasMember) messages.add("missing implementation: _PyModule_ClearDict");
        hasMember = reallyHasMember(capiLibrary, "_PyModule_CreateInitialized");
        if (!hasMember) messages.add("missing implementation: _PyModule_CreateInitialized");
        hasMember = reallyHasMember(capiLibrary, "_PyNamespace_New");
        if (!hasMember) messages.add("missing implementation: _PyNamespace_New");
        hasMember = reallyHasMember(capiLibrary, "_PyNumber_Index");
        if (!hasMember) messages.add("missing implementation: _PyNumber_Index");
        hasMember = reallyHasMember(capiLibrary, "_PyOS_IsMainThread");
        if (!hasMember) messages.add("missing implementation: _PyOS_IsMainThread");
        hasMember = reallyHasMember(capiLibrary, "_PyOS_URandom");
        if (!hasMember) messages.add("missing implementation: _PyOS_URandom");
        hasMember = reallyHasMember(capiLibrary, "_PyOS_URandomNonblock");
        if (!hasMember) messages.add("missing implementation: _PyOS_URandomNonblock");
        hasMember = reallyHasMember(capiLibrary, "_PyObject_AssertFailed");
        if (!hasMember) messages.add("missing implementation: _PyObject_AssertFailed");
        hasMember = reallyHasMember(capiLibrary, "_PyObject_CallFunction_SizeT");
        if (!hasMember) messages.add("missing implementation: _PyObject_CallFunction_SizeT");
        hasMember = reallyHasMember(capiLibrary, "_PyObject_CallMethod");
        if (!hasMember) messages.add("missing implementation: _PyObject_CallMethod");
        hasMember = reallyHasMember(capiLibrary, "_PyObject_CallMethodId");
        if (!hasMember) messages.add("missing implementation: _PyObject_CallMethodId");
        hasMember = reallyHasMember(capiLibrary, "_PyObject_CallMethodIdObjArgs");
        if (!hasMember) messages.add("missing implementation: _PyObject_CallMethodIdObjArgs");
        hasMember = reallyHasMember(capiLibrary, "_PyObject_CallMethodIdObjArgs");
        if (!hasMember) messages.add("missing implementation: _PyObject_CallMethodIdObjArgs");
        hasMember = reallyHasMember(capiLibrary, "_PyObject_CallMethodId_SizeT");
        if (!hasMember) messages.add("missing implementation: _PyObject_CallMethodId_SizeT");
        hasMember = reallyHasMember(capiLibrary, "_PyObject_CallMethod_SizeT");
        if (!hasMember) messages.add("missing implementation: _PyObject_CallMethod_SizeT");
        hasMember = reallyHasMember(capiLibrary, "_PyObject_CheckConsistency");
        if (!hasMember) messages.add("missing implementation: _PyObject_CheckConsistency");
        hasMember = reallyHasMember(capiLibrary, "_PyObject_CheckCrossInterpreterData");
        if (!hasMember) messages.add("missing implementation: _PyObject_CheckCrossInterpreterData");
        hasMember = reallyHasMember(capiLibrary, "_PyObject_ClearManagedDict");
        if (!hasMember) messages.add("missing implementation: _PyObject_ClearManagedDict");
        hasMember = reallyHasMember(capiLibrary, "_PyObject_DebugTypeStats");
        if (!hasMember) messages.add("missing implementation: _PyObject_DebugTypeStats");
        hasMember = reallyHasMember(capiLibrary, "_PyObject_Dump");
        if (!hasMember) messages.add("missing implementation: _PyObject_Dump");
        hasMember = reallyHasMember(capiLibrary, "_PyObject_FastCall");
        if (!hasMember) messages.add("missing implementation: _PyObject_FastCall");
        hasMember = reallyHasMember(capiLibrary, "_PyObject_FunctionStr");
        if (!hasMember) messages.add("missing implementation: _PyObject_FunctionStr");
        hasMember = reallyHasMember(capiLibrary, "_PyObject_GC_New");
        if (!hasMember) messages.add("missing implementation: _PyObject_GC_New");
        hasMember = reallyHasMember(capiLibrary, "_PyObject_GC_NewVar");
        if (!hasMember) messages.add("missing implementation: _PyObject_GC_NewVar");
        hasMember = reallyHasMember(capiLibrary, "_PyObject_GC_Resize");
        if (!hasMember) messages.add("missing implementation: _PyObject_GC_Resize");
        hasMember = reallyHasMember(capiLibrary, "_PyObject_GenericGetAttrWithDict");
        if (!hasMember) messages.add("missing implementation: _PyObject_GenericGetAttrWithDict");
        hasMember = reallyHasMember(capiLibrary, "_PyObject_GenericSetAttrWithDict");
        if (!hasMember) messages.add("missing implementation: _PyObject_GenericSetAttrWithDict");
        hasMember = reallyHasMember(capiLibrary, "_PyObject_GetAttrId");
        if (!hasMember) messages.add("missing implementation: _PyObject_GetAttrId");
        hasMember = reallyHasMember(capiLibrary, "_PyObject_GetCrossInterpreterData");
        if (!hasMember) messages.add("missing implementation: _PyObject_GetCrossInterpreterData");
        hasMember = reallyHasMember(capiLibrary, "_PyObject_GetDictPtr");
        if (!hasMember) messages.add("missing implementation: _PyObject_GetDictPtr");
        hasMember = reallyHasMember(capiLibrary, "_PyObject_GetMethod");
        if (!hasMember) messages.add("missing implementation: _PyObject_GetMethod");
        hasMember = reallyHasMember(capiLibrary, "_PyObject_GetState");
        if (!hasMember) messages.add("missing implementation: _PyObject_GetState");
        hasMember = reallyHasMember(capiLibrary, "_PyObject_HasLen");
        if (!hasMember) messages.add("missing implementation: _PyObject_HasLen");
        hasMember = reallyHasMember(capiLibrary, "_PyObject_IsAbstract");
        if (!hasMember) messages.add("missing implementation: _PyObject_IsAbstract");
        hasMember = reallyHasMember(capiLibrary, "_PyObject_IsFreed");
        if (!hasMember) messages.add("missing implementation: _PyObject_IsFreed");
        hasMember = reallyHasMember(capiLibrary, "_PyObject_LookupAttr");
        if (!hasMember) messages.add("missing implementation: _PyObject_LookupAttr");
        hasMember = reallyHasMember(capiLibrary, "_PyObject_LookupAttrId");
        if (!hasMember) messages.add("missing implementation: _PyObject_LookupAttrId");
        hasMember = reallyHasMember(capiLibrary, "_PyObject_LookupSpecialId");
        if (!hasMember) messages.add("missing implementation: _PyObject_LookupSpecialId");
        hasMember = reallyHasMember(capiLibrary, "_PyObject_MakeTpCall");
        if (!hasMember) messages.add("missing implementation: _PyObject_MakeTpCall");
        hasMember = reallyHasMember(capiLibrary, "_PyObject_New");
        if (!hasMember) messages.add("missing implementation: _PyObject_New");
        hasMember = reallyHasMember(capiLibrary, "_PyObject_NewVar");
        if (!hasMember) messages.add("missing implementation: _PyObject_NewVar");
        hasMember = reallyHasMember(capiLibrary, "_PyObject_NextNotImplemented");
        if (!hasMember) messages.add("missing implementation: _PyObject_NextNotImplemented");
        hasMember = reallyHasMember(capiLibrary, "_PyObject_RealIsInstance");
        if (!hasMember) messages.add("missing implementation: _PyObject_RealIsInstance");
        hasMember = reallyHasMember(capiLibrary, "_PyObject_RealIsSubclass");
        if (!hasMember) messages.add("missing implementation: _PyObject_RealIsSubclass");
        hasMember = reallyHasMember(capiLibrary, "_PyObject_SetAttrId");
        if (!hasMember) messages.add("missing implementation: _PyObject_SetAttrId");
        hasMember = reallyHasMember(capiLibrary, "_PyObject_VisitManagedDict");
        if (!hasMember) messages.add("missing implementation: _PyObject_VisitManagedDict");
        hasMember = reallyHasMember(capiLibrary, "_PyRun_AnyFileObject");
        if (!hasMember) messages.add("missing implementation: _PyRun_AnyFileObject");
        hasMember = reallyHasMember(capiLibrary, "_PyRun_InteractiveLoopObject");
        if (!hasMember) messages.add("missing implementation: _PyRun_InteractiveLoopObject");
        hasMember = reallyHasMember(capiLibrary, "_PyRun_SimpleFileObject");
        if (!hasMember) messages.add("missing implementation: _PyRun_SimpleFileObject");
        hasMember = reallyHasMember(capiLibrary, "_PySequence_BytesToCharpArray");
        if (!hasMember) messages.add("missing implementation: _PySequence_BytesToCharpArray");
        hasMember = reallyHasMember(capiLibrary, "_PySequence_IterSearch");
        if (!hasMember) messages.add("missing implementation: _PySequence_IterSearch");
        hasMember = reallyHasMember(capiLibrary, "_PySet_NextEntry");
        if (!hasMember) messages.add("missing implementation: _PySet_NextEntry");
        hasMember = reallyHasMember(capiLibrary, "_PySet_Update");
        if (!hasMember) messages.add("missing implementation: _PySet_Update");
        hasMember = reallyHasMember(capiLibrary, "_PySlice_FromIndices");
        if (!hasMember) messages.add("missing implementation: _PySlice_FromIndices");
        hasMember = reallyHasMember(capiLibrary, "_PySlice_GetLongIndices");
        if (!hasMember) messages.add("missing implementation: _PySlice_GetLongIndices");
        hasMember = reallyHasMember(capiLibrary, "_PyStack_AsDict");
        if (!hasMember) messages.add("missing implementation: _PyStack_AsDict");
        hasMember = reallyHasMember(capiLibrary, "_PySys_GetAttr");
        if (!hasMember) messages.add("missing implementation: _PySys_GetAttr");
        hasMember = reallyHasMember(capiLibrary, "_PySys_GetSizeOf");
        if (!hasMember) messages.add("missing implementation: _PySys_GetSizeOf");
        hasMember = reallyHasMember(capiLibrary, "_PyThreadState_GetDict");
        if (!hasMember) messages.add("missing implementation: _PyThreadState_GetDict");
        hasMember = reallyHasMember(capiLibrary, "_PyThreadState_Prealloc");
        if (!hasMember) messages.add("missing implementation: _PyThreadState_Prealloc");
        hasMember = reallyHasMember(capiLibrary, "_PyThreadState_UncheckedGet");
        if (!hasMember) messages.add("missing implementation: _PyThreadState_UncheckedGet");
        hasMember = reallyHasMember(capiLibrary, "_PyThread_CurrentExceptions");
        if (!hasMember) messages.add("missing implementation: _PyThread_CurrentExceptions");
        hasMember = reallyHasMember(capiLibrary, "_PyThread_CurrentFrames");
        if (!hasMember) messages.add("missing implementation: _PyThread_CurrentFrames");
        hasMember = reallyHasMember(capiLibrary, "_PyThread_at_fork_reinit");
        if (!hasMember) messages.add("missing implementation: _PyThread_at_fork_reinit");
        hasMember = reallyHasMember(capiLibrary, "_PyTime_Add");
        if (!hasMember) messages.add("missing implementation: _PyTime_Add");
        hasMember = reallyHasMember(capiLibrary, "_PyTime_AsMicroseconds");
        if (!hasMember) messages.add("missing implementation: _PyTime_AsMicroseconds");
        hasMember = reallyHasMember(capiLibrary, "_PyTime_AsMilliseconds");
        if (!hasMember) messages.add("missing implementation: _PyTime_AsMilliseconds");
        hasMember = reallyHasMember(capiLibrary, "_PyTime_AsNanoseconds");
        if (!hasMember) messages.add("missing implementation: _PyTime_AsNanoseconds");
        hasMember = reallyHasMember(capiLibrary, "_PyTime_AsNanosecondsObject");
        if (!hasMember) messages.add("missing implementation: _PyTime_AsNanosecondsObject");
        hasMember = reallyHasMember(capiLibrary, "_PyTime_AsSecondsDouble");
        if (!hasMember) messages.add("missing implementation: _PyTime_AsSecondsDouble");
        hasMember = reallyHasMember(capiLibrary, "_PyTime_AsTimespec");
        if (!hasMember) messages.add("missing implementation: _PyTime_AsTimespec");
        hasMember = reallyHasMember(capiLibrary, "_PyTime_AsTimespec_clamp");
        if (!hasMember) messages.add("missing implementation: _PyTime_AsTimespec_clamp");
        hasMember = reallyHasMember(capiLibrary, "_PyTime_AsTimeval");
        if (!hasMember) messages.add("missing implementation: _PyTime_AsTimeval");
        hasMember = reallyHasMember(capiLibrary, "_PyTime_AsTimevalTime_t");
        if (!hasMember) messages.add("missing implementation: _PyTime_AsTimevalTime_t");
        hasMember = reallyHasMember(capiLibrary, "_PyTime_AsTimeval_clamp");
        if (!hasMember) messages.add("missing implementation: _PyTime_AsTimeval_clamp");
        hasMember = reallyHasMember(capiLibrary, "_PyTime_FromMicrosecondsClamp");
        if (!hasMember) messages.add("missing implementation: _PyTime_FromMicrosecondsClamp");
        hasMember = reallyHasMember(capiLibrary, "_PyTime_FromMillisecondsObject");
        if (!hasMember) messages.add("missing implementation: _PyTime_FromMillisecondsObject");
        hasMember = reallyHasMember(capiLibrary, "_PyTime_FromNanoseconds");
        if (!hasMember) messages.add("missing implementation: _PyTime_FromNanoseconds");
        hasMember = reallyHasMember(capiLibrary, "_PyTime_FromNanosecondsObject");
        if (!hasMember) messages.add("missing implementation: _PyTime_FromNanosecondsObject");
        hasMember = reallyHasMember(capiLibrary, "_PyTime_FromSeconds");
        if (!hasMember) messages.add("missing implementation: _PyTime_FromSeconds");
        hasMember = reallyHasMember(capiLibrary, "_PyTime_FromSecondsObject");
        if (!hasMember) messages.add("missing implementation: _PyTime_FromSecondsObject");
        hasMember = reallyHasMember(capiLibrary, "_PyTime_FromTimespec");
        if (!hasMember) messages.add("missing implementation: _PyTime_FromTimespec");
        hasMember = reallyHasMember(capiLibrary, "_PyTime_FromTimeval");
        if (!hasMember) messages.add("missing implementation: _PyTime_FromTimeval");
        hasMember = reallyHasMember(capiLibrary, "_PyTime_GetMonotonicClock");
        if (!hasMember) messages.add("missing implementation: _PyTime_GetMonotonicClock");
        hasMember = reallyHasMember(capiLibrary, "_PyTime_GetMonotonicClockWithInfo");
        if (!hasMember) messages.add("missing implementation: _PyTime_GetMonotonicClockWithInfo");
        hasMember = reallyHasMember(capiLibrary, "_PyTime_GetPerfCounter");
        if (!hasMember) messages.add("missing implementation: _PyTime_GetPerfCounter");
        hasMember = reallyHasMember(capiLibrary, "_PyTime_GetPerfCounterWithInfo");
        if (!hasMember) messages.add("missing implementation: _PyTime_GetPerfCounterWithInfo");
        hasMember = reallyHasMember(capiLibrary, "_PyTime_GetSystemClock");
        if (!hasMember) messages.add("missing implementation: _PyTime_GetSystemClock");
        hasMember = reallyHasMember(capiLibrary, "_PyTime_GetSystemClockWithInfo");
        if (!hasMember) messages.add("missing implementation: _PyTime_GetSystemClockWithInfo");
        hasMember = reallyHasMember(capiLibrary, "_PyTime_MulDiv");
        if (!hasMember) messages.add("missing implementation: _PyTime_MulDiv");
        hasMember = reallyHasMember(capiLibrary, "_PyTime_ObjectToTime_t");
        if (!hasMember) messages.add("missing implementation: _PyTime_ObjectToTime_t");
        hasMember = reallyHasMember(capiLibrary, "_PyTime_ObjectToTimespec");
        if (!hasMember) messages.add("missing implementation: _PyTime_ObjectToTimespec");
        hasMember = reallyHasMember(capiLibrary, "_PyTime_ObjectToTimeval");
        if (!hasMember) messages.add("missing implementation: _PyTime_ObjectToTimeval");
        hasMember = reallyHasMember(capiLibrary, "_PyTime_gmtime");
        if (!hasMember) messages.add("missing implementation: _PyTime_gmtime");
        hasMember = reallyHasMember(capiLibrary, "_PyTime_localtime");
        if (!hasMember) messages.add("missing implementation: _PyTime_localtime");
        hasMember = reallyHasMember(capiLibrary, "_PyTraceMalloc_ClearTraces");
        if (!hasMember) messages.add("missing implementation: _PyTraceMalloc_ClearTraces");
        hasMember = reallyHasMember(capiLibrary, "_PyTraceMalloc_GetMemory");
        if (!hasMember) messages.add("missing implementation: _PyTraceMalloc_GetMemory");
        hasMember = reallyHasMember(capiLibrary, "_PyTraceMalloc_GetObjectTraceback");
        if (!hasMember) messages.add("missing implementation: _PyTraceMalloc_GetObjectTraceback");
        hasMember = reallyHasMember(capiLibrary, "_PyTraceMalloc_GetTraceback");
        if (!hasMember) messages.add("missing implementation: _PyTraceMalloc_GetTraceback");
        hasMember = reallyHasMember(capiLibrary, "_PyTraceMalloc_GetTracebackLimit");
        if (!hasMember) messages.add("missing implementation: _PyTraceMalloc_GetTracebackLimit");
        hasMember = reallyHasMember(capiLibrary, "_PyTraceMalloc_GetTracedMemory");
        if (!hasMember) messages.add("missing implementation: _PyTraceMalloc_GetTracedMemory");
        hasMember = reallyHasMember(capiLibrary, "_PyTraceMalloc_GetTraces");
        if (!hasMember) messages.add("missing implementation: _PyTraceMalloc_GetTraces");
        hasMember = reallyHasMember(capiLibrary, "_PyTraceMalloc_Init");
        if (!hasMember) messages.add("missing implementation: _PyTraceMalloc_Init");
        hasMember = reallyHasMember(capiLibrary, "_PyTraceMalloc_IsTracing");
        if (!hasMember) messages.add("missing implementation: _PyTraceMalloc_IsTracing");
        hasMember = reallyHasMember(capiLibrary, "_PyTraceMalloc_ResetPeak");
        if (!hasMember) messages.add("missing implementation: _PyTraceMalloc_ResetPeak");
        hasMember = reallyHasMember(capiLibrary, "_PyTraceMalloc_Start");
        if (!hasMember) messages.add("missing implementation: _PyTraceMalloc_Start");
        hasMember = reallyHasMember(capiLibrary, "_PyTraceMalloc_Stop");
        if (!hasMember) messages.add("missing implementation: _PyTraceMalloc_Stop");
        hasMember = reallyHasMember(capiLibrary, "_PyTraceback_Add");
        if (!hasMember) messages.add("missing implementation: _PyTraceback_Add");
        hasMember = reallyHasMember(capiLibrary, "_PyTrash_begin");
        if (!hasMember) messages.add("missing implementation: _PyTrash_begin");
        hasMember = reallyHasMember(capiLibrary, "_PyTrash_cond");
        if (!hasMember) messages.add("missing implementation: _PyTrash_cond");
        hasMember = reallyHasMember(capiLibrary, "_PyTrash_end");
        if (!hasMember) messages.add("missing implementation: _PyTrash_end");
        hasMember = reallyHasMember(capiLibrary, "_PyTuple_DebugMallocStats");
        if (!hasMember) messages.add("missing implementation: _PyTuple_DebugMallocStats");
        hasMember = reallyHasMember(capiLibrary, "_PyTuple_MaybeUntrack");
        if (!hasMember) messages.add("missing implementation: _PyTuple_MaybeUntrack");
        hasMember = reallyHasMember(capiLibrary, "_PyTuple_Resize");
        if (!hasMember) messages.add("missing implementation: _PyTuple_Resize");
        hasMember = reallyHasMember(capiLibrary, "_PyType_CalculateMetaclass");
        if (!hasMember) messages.add("missing implementation: _PyType_CalculateMetaclass");
        hasMember = reallyHasMember(capiLibrary, "_PyType_GetDocFromInternalDoc");
        if (!hasMember) messages.add("missing implementation: _PyType_GetDocFromInternalDoc");
        hasMember = reallyHasMember(capiLibrary, "_PyType_GetTextSignatureFromInternalDoc");
        if (!hasMember) messages.add("missing implementation: _PyType_GetTextSignatureFromInternalDoc");
        hasMember = reallyHasMember(capiLibrary, "_PyType_Lookup");
        if (!hasMember) messages.add("missing implementation: _PyType_Lookup");
        hasMember = reallyHasMember(capiLibrary, "_PyType_LookupId");
        if (!hasMember) messages.add("missing implementation: _PyType_LookupId");
        hasMember = reallyHasMember(capiLibrary, "_PyType_Name");
        if (!hasMember) messages.add("missing implementation: _PyType_Name");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicodeTranslateError_Create");
        if (!hasMember) messages.add("missing implementation: _PyUnicodeTranslateError_Create");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicodeWriter_Dealloc");
        if (!hasMember) messages.add("missing implementation: _PyUnicodeWriter_Dealloc");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicodeWriter_Finish");
        if (!hasMember) messages.add("missing implementation: _PyUnicodeWriter_Finish");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicodeWriter_Init");
        if (!hasMember) messages.add("missing implementation: _PyUnicodeWriter_Init");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicodeWriter_PrepareInternal");
        if (!hasMember) messages.add("missing implementation: _PyUnicodeWriter_PrepareInternal");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicodeWriter_PrepareKindInternal");
        if (!hasMember) messages.add("missing implementation: _PyUnicodeWriter_PrepareKindInternal");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicodeWriter_WriteASCIIString");
        if (!hasMember) messages.add("missing implementation: _PyUnicodeWriter_WriteASCIIString");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicodeWriter_WriteChar");
        if (!hasMember) messages.add("missing implementation: _PyUnicodeWriter_WriteChar");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicodeWriter_WriteLatin1String");
        if (!hasMember) messages.add("missing implementation: _PyUnicodeWriter_WriteLatin1String");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicodeWriter_WriteStr");
        if (!hasMember) messages.add("missing implementation: _PyUnicodeWriter_WriteStr");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicodeWriter_WriteSubstring");
        if (!hasMember) messages.add("missing implementation: _PyUnicodeWriter_WriteSubstring");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicode_AsASCIIString");
        if (!hasMember) messages.add("missing implementation: _PyUnicode_AsASCIIString");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicode_AsLatin1String");
        if (!hasMember) messages.add("missing implementation: _PyUnicode_AsLatin1String");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicode_AsUTF8String");
        if (!hasMember) messages.add("missing implementation: _PyUnicode_AsUTF8String");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicode_CheckConsistency");
        if (!hasMember) messages.add("missing implementation: _PyUnicode_CheckConsistency");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicode_Copy");
        if (!hasMember) messages.add("missing implementation: _PyUnicode_Copy");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicode_DecodeRawUnicodeEscapeStateful");
        if (!hasMember) messages.add("missing implementation: _PyUnicode_DecodeRawUnicodeEscapeStateful");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicode_DecodeUnicodeEscapeInternal");
        if (!hasMember) messages.add("missing implementation: _PyUnicode_DecodeUnicodeEscapeInternal");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicode_DecodeUnicodeEscapeStateful");
        if (!hasMember) messages.add("missing implementation: _PyUnicode_DecodeUnicodeEscapeStateful");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicode_EQ");
        if (!hasMember) messages.add("missing implementation: _PyUnicode_EQ");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicode_EncodeCharmap");
        if (!hasMember) messages.add("missing implementation: _PyUnicode_EncodeCharmap");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicode_EncodeUTF16");
        if (!hasMember) messages.add("missing implementation: _PyUnicode_EncodeUTF16");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicode_EncodeUTF32");
        if (!hasMember) messages.add("missing implementation: _PyUnicode_EncodeUTF32");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicode_EncodeUTF7");
        if (!hasMember) messages.add("missing implementation: _PyUnicode_EncodeUTF7");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicode_Equal");
        if (!hasMember) messages.add("missing implementation: _PyUnicode_Equal");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicode_EqualToASCIIId");
        if (!hasMember) messages.add("missing implementation: _PyUnicode_EqualToASCIIId");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicode_EqualToASCIIString");
        if (!hasMember) messages.add("missing implementation: _PyUnicode_EqualToASCIIString");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicode_FastCopyCharacters");
        if (!hasMember) messages.add("missing implementation: _PyUnicode_FastCopyCharacters");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicode_FastFill");
        if (!hasMember) messages.add("missing implementation: _PyUnicode_FastFill");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicode_FindMaxChar");
        if (!hasMember) messages.add("missing implementation: _PyUnicode_FindMaxChar");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicode_FormatAdvancedWriter");
        if (!hasMember) messages.add("missing implementation: _PyUnicode_FormatAdvancedWriter");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicode_FormatLong");
        if (!hasMember) messages.add("missing implementation: _PyUnicode_FormatLong");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicode_FromASCII");
        if (!hasMember) messages.add("missing implementation: _PyUnicode_FromASCII");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicode_FromId");
        if (!hasMember) messages.add("missing implementation: _PyUnicode_FromId");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicode_InsertThousandsGrouping");
        if (!hasMember) messages.add("missing implementation: _PyUnicode_InsertThousandsGrouping");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicode_IsAlpha");
        if (!hasMember) messages.add("missing implementation: _PyUnicode_IsAlpha");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicode_IsCaseIgnorable");
        if (!hasMember) messages.add("missing implementation: _PyUnicode_IsCaseIgnorable");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicode_IsCased");
        if (!hasMember) messages.add("missing implementation: _PyUnicode_IsCased");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicode_IsDecimalDigit");
        if (!hasMember) messages.add("missing implementation: _PyUnicode_IsDecimalDigit");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicode_IsDigit");
        if (!hasMember) messages.add("missing implementation: _PyUnicode_IsDigit");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicode_IsLinebreak");
        if (!hasMember) messages.add("missing implementation: _PyUnicode_IsLinebreak");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicode_IsLowercase");
        if (!hasMember) messages.add("missing implementation: _PyUnicode_IsLowercase");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicode_IsNumeric");
        if (!hasMember) messages.add("missing implementation: _PyUnicode_IsNumeric");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicode_IsPrintable");
        if (!hasMember) messages.add("missing implementation: _PyUnicode_IsPrintable");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicode_IsTitlecase");
        if (!hasMember) messages.add("missing implementation: _PyUnicode_IsTitlecase");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicode_IsUppercase");
        if (!hasMember) messages.add("missing implementation: _PyUnicode_IsUppercase");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicode_IsWhitespace");
        if (!hasMember) messages.add("missing implementation: _PyUnicode_IsWhitespace");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicode_IsXidContinue");
        if (!hasMember) messages.add("missing implementation: _PyUnicode_IsXidContinue");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicode_IsXidStart");
        if (!hasMember) messages.add("missing implementation: _PyUnicode_IsXidStart");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicode_JoinArray");
        if (!hasMember) messages.add("missing implementation: _PyUnicode_JoinArray");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicode_ScanIdentifier");
        if (!hasMember) messages.add("missing implementation: _PyUnicode_ScanIdentifier");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicode_ToDecimalDigit");
        if (!hasMember) messages.add("missing implementation: _PyUnicode_ToDecimalDigit");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicode_ToDigit");
        if (!hasMember) messages.add("missing implementation: _PyUnicode_ToDigit");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicode_ToFoldedFull");
        if (!hasMember) messages.add("missing implementation: _PyUnicode_ToFoldedFull");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicode_ToLowerFull");
        if (!hasMember) messages.add("missing implementation: _PyUnicode_ToLowerFull");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicode_ToLowercase");
        if (!hasMember) messages.add("missing implementation: _PyUnicode_ToLowercase");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicode_ToNumeric");
        if (!hasMember) messages.add("missing implementation: _PyUnicode_ToNumeric");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicode_ToTitleFull");
        if (!hasMember) messages.add("missing implementation: _PyUnicode_ToTitleFull");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicode_ToTitlecase");
        if (!hasMember) messages.add("missing implementation: _PyUnicode_ToTitlecase");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicode_ToUpperFull");
        if (!hasMember) messages.add("missing implementation: _PyUnicode_ToUpperFull");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicode_ToUppercase");
        if (!hasMember) messages.add("missing implementation: _PyUnicode_ToUppercase");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicode_TransformDecimalAndSpaceToASCII");
        if (!hasMember) messages.add("missing implementation: _PyUnicode_TransformDecimalAndSpaceToASCII");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicode_WideCharString_Converter");
        if (!hasMember) messages.add("missing implementation: _PyUnicode_WideCharString_Converter");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicode_WideCharString_Opt_Converter");
        if (!hasMember) messages.add("missing implementation: _PyUnicode_WideCharString_Opt_Converter");
        hasMember = reallyHasMember(capiLibrary, "_PyUnicode_XStrip");
        if (!hasMember) messages.add("missing implementation: _PyUnicode_XStrip");
        hasMember = reallyHasMember(capiLibrary, "_PyWeakref_ClearRef");
        if (!hasMember) messages.add("missing implementation: _PyWeakref_ClearRef");
        hasMember = reallyHasMember(capiLibrary, "_PyWeakref_GetWeakrefCount");
        if (!hasMember) messages.add("missing implementation: _PyWeakref_GetWeakrefCount");
        hasMember = reallyHasMember(capiLibrary, "_Py_AtExit");
        if (!hasMember) messages.add("missing implementation: _Py_AtExit");
        hasMember = reallyHasMember(capiLibrary, "_Py_BreakPoint");
        if (!hasMember) messages.add("missing implementation: _Py_BreakPoint");
        hasMember = reallyHasMember(capiLibrary, "_Py_BuildValue_SizeT");
        if (!hasMember) messages.add("missing implementation: _Py_BuildValue_SizeT");
        hasMember = reallyHasMember(capiLibrary, "_Py_CheckFunctionResult");
        if (!hasMember) messages.add("missing implementation: _Py_CheckFunctionResult");
        hasMember = reallyHasMember(capiLibrary, "_Py_CoerceLegacyLocale");
        if (!hasMember) messages.add("missing implementation: _Py_CoerceLegacyLocale");
        hasMember = reallyHasMember(capiLibrary, "_Py_Dealloc");
        if (!hasMember) messages.add("missing implementation: _Py_Dealloc");
        hasMember = reallyHasMember(capiLibrary, "_Py_DecRef");
        if (!hasMember) messages.add("missing implementation: _Py_DecRef");
        hasMember = reallyHasMember(capiLibrary, "_Py_DisplaySourceLine");
        if (!hasMember) messages.add("missing implementation: _Py_DisplaySourceLine");
        hasMember = reallyHasMember(capiLibrary, "_Py_FatalErrorFormat");
        if (!hasMember) messages.add("missing implementation: _Py_FatalErrorFormat");
        hasMember = reallyHasMember(capiLibrary, "_Py_FatalErrorFunc");
        if (!hasMember) messages.add("missing implementation: _Py_FatalErrorFunc");
        hasMember = reallyHasMember(capiLibrary, "_Py_FdIsInteractive");
        if (!hasMember) messages.add("missing implementation: _Py_FdIsInteractive");
        hasMember = reallyHasMember(capiLibrary, "_Py_FreeCharPArray");
        if (!hasMember) messages.add("missing implementation: _Py_FreeCharPArray");
        hasMember = reallyHasMember(capiLibrary, "_Py_GetConfig");
        if (!hasMember) messages.add("missing implementation: _Py_GetConfig");
        hasMember = reallyHasMember(capiLibrary, "_Py_GetErrorHandler");
        if (!hasMember) messages.add("missing implementation: _Py_GetErrorHandler");
        hasMember = reallyHasMember(capiLibrary, "_Py_HashBytes");
        if (!hasMember) messages.add("missing implementation: _Py_HashBytes");
        hasMember = reallyHasMember(capiLibrary, "_Py_HashDouble");
        if (!hasMember) messages.add("missing implementation: _Py_HashDouble");
        hasMember = reallyHasMember(capiLibrary, "_Py_HashPointer");
        if (!hasMember) messages.add("missing implementation: _Py_HashPointer");
        hasMember = reallyHasMember(capiLibrary, "_Py_HashPointerRaw");
        if (!hasMember) messages.add("missing implementation: _Py_HashPointerRaw");
        hasMember = reallyHasMember(capiLibrary, "_Py_IncRef");
        if (!hasMember) messages.add("missing implementation: _Py_IncRef");
        hasMember = reallyHasMember(capiLibrary, "_Py_InitializeMain");
        if (!hasMember) messages.add("missing implementation: _Py_InitializeMain");
        hasMember = reallyHasMember(capiLibrary, "_Py_IsCoreInitialized");
        if (!hasMember) messages.add("missing implementation: _Py_IsCoreInitialized");
        hasMember = reallyHasMember(capiLibrary, "_Py_IsFinalizing");
        if (!hasMember) messages.add("missing implementation: _Py_IsFinalizing");
        hasMember = reallyHasMember(capiLibrary, "_Py_IsInterpreterFinalizing");
        if (!hasMember) messages.add("missing implementation: _Py_IsInterpreterFinalizing");
        hasMember = reallyHasMember(capiLibrary, "_Py_LegacyLocaleDetected");
        if (!hasMember) messages.add("missing implementation: _Py_LegacyLocaleDetected");
        hasMember = reallyHasMember(capiLibrary, "_Py_NewReference");
        if (!hasMember) messages.add("missing implementation: _Py_NewReference");
        hasMember = reallyHasMember(capiLibrary, "_Py_NewReferenceNoTotal");
        if (!hasMember) messages.add("missing implementation: _Py_NewReferenceNoTotal");
        hasMember = reallyHasMember(capiLibrary, "_Py_RestoreSignals");
        if (!hasMember) messages.add("missing implementation: _Py_RestoreSignals");
        hasMember = reallyHasMember(capiLibrary, "_Py_SetLocaleFromEnv");
        if (!hasMember) messages.add("missing implementation: _Py_SetLocaleFromEnv");
        hasMember = reallyHasMember(capiLibrary, "_Py_SetProgramFullPath");
        if (!hasMember) messages.add("missing implementation: _Py_SetProgramFullPath");
        hasMember = reallyHasMember(capiLibrary, "_Py_SourceAsString");
        if (!hasMember) messages.add("missing implementation: _Py_SourceAsString");
        hasMember = reallyHasMember(capiLibrary, "_Py_UniversalNewlineFgetsWithSize");
        if (!hasMember) messages.add("missing implementation: _Py_UniversalNewlineFgetsWithSize");
        hasMember = reallyHasMember(capiLibrary, "_Py_VaBuildStack");
        if (!hasMember) messages.add("missing implementation: _Py_VaBuildStack");
        hasMember = reallyHasMember(capiLibrary, "_Py_VaBuildStack_SizeT");
        if (!hasMember) messages.add("missing implementation: _Py_VaBuildStack_SizeT");
        hasMember = reallyHasMember(capiLibrary, "_Py_VaBuildValue_SizeT");
        if (!hasMember) messages.add("missing implementation: _Py_VaBuildValue_SizeT");
        hasMember = reallyHasMember(capiLibrary, "_Py_add_one_to_index_C");
        if (!hasMember) messages.add("missing implementation: _Py_add_one_to_index_C");
        hasMember = reallyHasMember(capiLibrary, "_Py_add_one_to_index_F");
        if (!hasMember) messages.add("missing implementation: _Py_add_one_to_index_F");
        hasMember = reallyHasMember(capiLibrary, "_Py_c_abs");
        if (!hasMember) messages.add("missing implementation: _Py_c_abs");
        hasMember = reallyHasMember(capiLibrary, "_Py_c_diff");
        if (!hasMember) messages.add("missing implementation: _Py_c_diff");
        hasMember = reallyHasMember(capiLibrary, "_Py_c_neg");
        if (!hasMember) messages.add("missing implementation: _Py_c_neg");
        hasMember = reallyHasMember(capiLibrary, "_Py_c_pow");
        if (!hasMember) messages.add("missing implementation: _Py_c_pow");
        hasMember = reallyHasMember(capiLibrary, "_Py_c_prod");
        if (!hasMember) messages.add("missing implementation: _Py_c_prod");
        hasMember = reallyHasMember(capiLibrary, "_Py_c_quot");
        if (!hasMember) messages.add("missing implementation: _Py_c_quot");
        hasMember = reallyHasMember(capiLibrary, "_Py_c_sum");
        if (!hasMember) messages.add("missing implementation: _Py_c_sum");
        hasMember = reallyHasMember(capiLibrary, "_Py_convert_optional_to_ssize_t");
        if (!hasMember) messages.add("missing implementation: _Py_convert_optional_to_ssize_t");
        hasMember = reallyHasMember(capiLibrary, "_Py_fopen_obj");
        if (!hasMember) messages.add("missing implementation: _Py_fopen_obj");
        hasMember = reallyHasMember(capiLibrary, "_Py_gitidentifier");
        if (!hasMember) messages.add("missing implementation: _Py_gitidentifier");
        hasMember = reallyHasMember(capiLibrary, "_Py_gitversion");
        if (!hasMember) messages.add("missing implementation: _Py_gitversion");
        hasMember = reallyHasMember(capiLibrary, "_Py_parse_inf_or_nan");
        if (!hasMember) messages.add("missing implementation: _Py_parse_inf_or_nan");
        hasMember = reallyHasMember(capiLibrary, "_Py_string_to_number_with_underscores");
        if (!hasMember) messages.add("missing implementation: _Py_string_to_number_with_underscores");

        messages.forEach(System.err::println);
        return messages.isEmpty();
    }
}
