// CheckStyle: start generated
package com.oracle.graal.python.builtins.modules.pickle;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.modules.pickle.PData.PDataBaseNode;
import com.oracle.graal.python.builtins.modules.pickle.PData.PDataPopListNode;
import com.oracle.graal.python.builtins.modules.pickle.PData.PDataPopNode;
import com.oracle.graal.python.builtins.modules.pickle.PData.PDataPopTupleNode;
import com.oracle.graal.python.builtins.modules.pickle.PData.PDataPushNode;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.PRaiseNodeGen;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.nodes.Node;
import java.lang.invoke.MethodHandles;
import java.util.List;

@GeneratedBy(PData.class)
@SuppressWarnings("javadoc")
public final class PDataFactory {

    public static List<NodeFactory<? extends PDataBaseNode>> getFactories() {
        return List.of(PDataPopNodeFactory.getInstance(), PDataPushNodeFactory.getInstance(), PDataPopTupleNodeFactory.getInstance(), PDataPopListNodeFactory.getInstance());
    }

    @GeneratedBy(PDataPopNode.class)
    public static final class PDataPopNodeFactory implements NodeFactory<PDataPopNode> {

        private static final PDataPopNodeFactory PDATA_POP_NODE_FACTORY_INSTANCE = new PDataPopNodeFactory();

        private PDataPopNodeFactory() {
        }

        @Override
        public Class<PDataPopNode> getNodeClass() {
            return PDataPopNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public PDataPopNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<PDataPopNode> getInstance() {
            return PDATA_POP_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static PDataPopNode create() {
            return new PDataPopNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link PDataPopNode#pop}
         *     Activation probability: 1.00000
         *     With/without class size: 24/1 bytes
         * </pre> */
        @GeneratedBy(PDataPopNode.class)
        @SuppressWarnings("javadoc")
        public static final class PDataPopNodeGen extends PDataPopNode {

            private static final StateField STATE_0_PDataPopNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link PDataPopNode#pop}
             *   Parameter: {@link PRaiseNode} raiseNode
             *   Inline method: {@link PRaiseNodeGen#inline}</pre> */
            private static final PRaiseNode INLINED_RAISE_NODE_ = PRaiseNodeGen.inline(InlineTarget.create(PRaiseNode.class, STATE_0_PDataPopNode_UPDATER.subUpdater(0, 1)));

            /**
             * State Info: <pre>
             *   0: InlinedCache
             *        Specialization: {@link PDataPopNode#pop}
             *        Parameter: {@link PRaiseNode} raiseNode
             *        Inline method: {@link PRaiseNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;

            private PDataPopNodeGen() {
            }

            @Override
            public Object execute(PData arg0Value) {
                {
                    Node inliningTarget__ = (this);
                    return PDataPopNode.pop(arg0Value, inliningTarget__, INLINED_RAISE_NODE_);
                }
            }

        }
    }
    @GeneratedBy(PDataPushNode.class)
    public static final class PDataPushNodeFactory implements NodeFactory<PDataPushNode> {

        private static final PDataPushNodeFactory PDATA_PUSH_NODE_FACTORY_INSTANCE = new PDataPushNodeFactory();

        private PDataPushNodeFactory() {
        }

        @Override
        public Class<PDataPushNode> getNodeClass() {
            return PDataPushNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public PDataPushNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<PDataPushNode> getInstance() {
            return PDATA_PUSH_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static PDataPushNode create() {
            return new PDataPushNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link PDataPushNode#push}
         *     Activation probability: 1.00000
         *     With/without class size: 24/1 bytes
         * </pre> */
        @GeneratedBy(PDataPushNode.class)
        @SuppressWarnings("javadoc")
        public static final class PDataPushNodeGen extends PDataPushNode {

            private static final StateField STATE_0_PDataPushNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link PDataPushNode#push}
             *   Parameter: {@link PRaiseNode} raiseNode
             *   Inline method: {@link PRaiseNodeGen#inline}</pre> */
            private static final PRaiseNode INLINED_RAISE_NODE_ = PRaiseNodeGen.inline(InlineTarget.create(PRaiseNode.class, STATE_0_PDataPushNode_UPDATER.subUpdater(0, 1)));

            /**
             * State Info: <pre>
             *   0: InlinedCache
             *        Specialization: {@link PDataPushNode#push}
             *        Parameter: {@link PRaiseNode} raiseNode
             *        Inline method: {@link PRaiseNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;

            private PDataPushNodeGen() {
            }

            @Override
            public void execute(PData arg0Value, Object arg1Value) {
                {
                    Node inliningTarget__ = (this);
                    PDataPushNode.push(arg0Value, arg1Value, inliningTarget__, INLINED_RAISE_NODE_);
                    return;
                }
            }

        }
    }
    @GeneratedBy(PDataPopTupleNode.class)
    public static final class PDataPopTupleNodeFactory implements NodeFactory<PDataPopTupleNode> {

        private static final PDataPopTupleNodeFactory PDATA_POP_TUPLE_NODE_FACTORY_INSTANCE = new PDataPopTupleNodeFactory();

        private PDataPopTupleNodeFactory() {
        }

        @Override
        public Class<PDataPopTupleNode> getNodeClass() {
            return PDataPopTupleNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public PDataPopTupleNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<PDataPopTupleNode> getInstance() {
            return PDATA_POP_TUPLE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static PDataPopTupleNode create() {
            return new PDataPopTupleNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link PDataPopTupleNode#popTuple}
         *     Activation probability: 1.00000
         *     With/without class size: 24/1 bytes
         * </pre> */
        @GeneratedBy(PDataPopTupleNode.class)
        @SuppressWarnings("javadoc")
        public static final class PDataPopTupleNodeGen extends PDataPopTupleNode {

            private static final StateField STATE_0_PDataPopTupleNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link PDataPopTupleNode#popTuple}
             *   Parameter: {@link PRaiseNode} raiseNode
             *   Inline method: {@link PRaiseNodeGen#inline}</pre> */
            private static final PRaiseNode INLINED_RAISE_NODE_ = PRaiseNodeGen.inline(InlineTarget.create(PRaiseNode.class, STATE_0_PDataPopTupleNode_UPDATER.subUpdater(0, 1)));

            /**
             * State Info: <pre>
             *   0: InlinedCache
             *        Specialization: {@link PDataPopTupleNode#popTuple}
             *        Parameter: {@link PRaiseNode} raiseNode
             *        Inline method: {@link PRaiseNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;

            private PDataPopTupleNodeGen() {
            }

            @Override
            public PTuple execute(PData arg0Value, int arg1Value) {
                {
                    Node inliningTarget__ = (this);
                    PythonLanguage language__ = (PythonLanguage.get(this));
                    return PDataPopTupleNode.popTuple(arg0Value, arg1Value, inliningTarget__, language__, INLINED_RAISE_NODE_);
                }
            }

        }
    }
    @GeneratedBy(PDataPopListNode.class)
    public static final class PDataPopListNodeFactory implements NodeFactory<PDataPopListNode> {

        private static final PDataPopListNodeFactory PDATA_POP_LIST_NODE_FACTORY_INSTANCE = new PDataPopListNodeFactory();

        private PDataPopListNodeFactory() {
        }

        @Override
        public Class<PDataPopListNode> getNodeClass() {
            return PDataPopListNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public PDataPopListNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<PDataPopListNode> getInstance() {
            return PDATA_POP_LIST_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static PDataPopListNode create() {
            return new PDataPopListNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link PDataPopListNode#popList}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre> */
        @GeneratedBy(PDataPopListNode.class)
        @SuppressWarnings("javadoc")
        public static final class PDataPopListNodeGen extends PDataPopListNode {

            private PDataPopListNodeGen() {
            }

            @Override
            public PList execute(PData arg0Value, int arg1Value) {
                {
                    PythonLanguage language__ = (PythonLanguage.get(this));
                    return popList(arg0Value, arg1Value, language__);
                }
            }

        }
    }
}
