// CheckStyle: start generated
package com.oracle.graal.python.builtins.objects.cell;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cell.CellBuiltins.CellContentsNode;
import com.oracle.graal.python.builtins.objects.cell.CellBuiltins.CellTypeNode;
import com.oracle.graal.python.builtins.objects.cell.CellBuiltins.EqNode;
import com.oracle.graal.python.builtins.objects.cell.CellBuiltins.GetRefNode;
import com.oracle.graal.python.builtins.objects.cell.CellBuiltins.ReprNode;
import com.oracle.graal.python.builtins.objects.str.StringUtils.SimpleTruffleStringFormatNode;
import com.oracle.graal.python.builtins.objects.str.StringUtilsFactory.SimpleTruffleStringFormatNodeGen;
import com.oracle.graal.python.builtins.objects.type.TypeNodes.GetNameNode;
import com.oracle.graal.python.builtins.objects.type.TypeNodesFactory.GetNameNodeGen;
import com.oracle.graal.python.lib.PyObjectRichCompareBool;
import com.oracle.graal.python.lib.PyObjectRichCompareBoolNodeGen;
import com.oracle.graal.python.lib.RichCmpOp;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.PRaiseNodeGen;
import com.oracle.graal.python.nodes.argument.ReadArgumentNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.object.GetClassNodeGen;
import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.RequiredField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.List;
import java.util.Objects;

@GeneratedBy(CellBuiltins.class)
@SuppressWarnings({"javadoc", "unused"})
public final class CellBuiltinsFactory {

    public static List<NodeFactory<? extends PythonBuiltinBaseNode>> getFactories() {
        return List.of(CellTypeNodeFactory.getInstance(), EqNodeFactory.getInstance(), ReprNodeFactory.getInstance(), CellContentsNodeFactory.getInstance());
    }

    @GeneratedBy(CellTypeNode.class)
    public static final class CellTypeNodeFactory implements NodeFactory<CellTypeNode> {

        private static final CellTypeNodeFactory CELL_TYPE_NODE_FACTORY_INSTANCE = new CellTypeNodeFactory();

        private CellTypeNodeFactory() {
        }

        @Override
        public Class<CellTypeNode> getNodeClass() {
            return CellTypeNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public CellTypeNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<CellTypeNode> getInstance() {
            return CELL_TYPE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static CellTypeNode create() {
            return new CellTypeNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link CellTypeNode#newCell}
         *     Activation probability: 1.00000
         *     With/without class size: 24/1 bytes
         * </pre> */
        @GeneratedBy(CellTypeNode.class)
        @SuppressWarnings("javadoc")
        public static final class CellTypeNodeGen extends CellTypeNode {

            private static final StateField STATE_0_CellTypeNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link CellTypeNode#newCell}
             *   Parameter: {@link InlinedConditionProfile} nonEmptyProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private static final InlinedConditionProfile INLINED_NON_EMPTY_PROFILE_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, STATE_0_CellTypeNode_UPDATER.subUpdater(0, 2)));

            /**
             * State Info: <pre>
             *   0-1: InlinedCache
             *        Specialization: {@link CellTypeNode#newCell}
             *        Parameter: {@link InlinedConditionProfile} nonEmptyProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;

            private CellTypeNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                {
                    Node inliningTarget__ = (this);
                    PythonLanguage language__ = (PythonLanguage.get(this));
                    return newCell(arg0Value, arg1Value, inliningTarget__, language__, INLINED_NON_EMPTY_PROFILE_);
                }
            }

        }
    }
    @GeneratedBy(EqNode.class)
    public static final class EqNodeFactory implements NodeFactory<EqNode> {

        private static final EqNodeFactory EQ_NODE_FACTORY_INSTANCE = new EqNodeFactory();

        private EqNodeFactory() {
        }

        @Override
        public Class<EqNode> getNodeClass() {
            return EqNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public EqNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<EqNode> getInstance() {
            return EQ_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EqNode create() {
            return new EqNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link EqNode#eq(VirtualFrame, PCell, PCell, RichCmpOp, Node, PyObjectRichCompareBool, InlinedConditionProfile, GetRefNode, GetRefNode)}
         *     Activation probability: 0.65000
         *     With/without class size: 27/19 bytes
         *   Specialization {@link EqNode#eq(Object, Object, RichCmpOp, Node, PRaiseNode)}
         *     Activation probability: 0.35000
         *     With/without class size: 11/1 bytes
         * </pre> */
        @GeneratedBy(EqNode.class)
        @SuppressWarnings("javadoc")
        public static final class EqNodeGen extends EqNode {

            private static final StateField STATE_0_EqNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link EqNode#eq(VirtualFrame, PCell, PCell, RichCmpOp, Node, PyObjectRichCompareBool, InlinedConditionProfile, GetRefNode, GetRefNode)}
             *   Parameter: {@link PyObjectRichCompareBool} richCmpNode
             *   Inline method: {@link PyObjectRichCompareBoolNodeGen#inline}</pre> */
            private static final PyObjectRichCompareBool INLINED_EQ_RICH_CMP_NODE_ = PyObjectRichCompareBoolNodeGen.inline(InlineTarget.create(PyObjectRichCompareBool.class, STATE_0_EqNode_UPDATER.subUpdater(2, 15), ReferenceField.create(MethodHandles.lookup(), "eq_richCmpNode__field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "eq_richCmpNode__field2_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link EqNode#eq(VirtualFrame, PCell, PCell, RichCmpOp, Node, PyObjectRichCompareBool, InlinedConditionProfile, GetRefNode, GetRefNode)}
             *   Parameter: {@link InlinedConditionProfile} nonEmptyProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private static final InlinedConditionProfile INLINED_EQ_NON_EMPTY_PROFILE_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, STATE_0_EqNode_UPDATER.subUpdater(17, 2)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link EqNode#eq(VirtualFrame, PCell, PCell, RichCmpOp, Node, PyObjectRichCompareBool, InlinedConditionProfile, GetRefNode, GetRefNode)}
             *   Parameter: {@link GetRefNode} getRefL
             *   Inline method: {@link GetRefNodeGen#inline}</pre> */
            private static final GetRefNode INLINED_EQ_GET_REF_L_ = GetRefNodeGen.inline(InlineTarget.create(GetRefNode.class, STATE_0_EqNode_UPDATER.subUpdater(19, 2), ReferenceField.create(MethodHandles.lookup(), "eq_getRefL__field1_", Object.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link EqNode#eq(VirtualFrame, PCell, PCell, RichCmpOp, Node, PyObjectRichCompareBool, InlinedConditionProfile, GetRefNode, GetRefNode)}
             *   Parameter: {@link GetRefNode} getRefR
             *   Inline method: {@link GetRefNodeGen#inline}</pre> */
            private static final GetRefNode INLINED_EQ_GET_REF_R_ = GetRefNodeGen.inline(InlineTarget.create(GetRefNode.class, STATE_0_EqNode_UPDATER.subUpdater(21, 2), ReferenceField.create(MethodHandles.lookup(), "eq_getRefR__field1_", Object.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link EqNode#eq(Object, Object, RichCmpOp, Node, PRaiseNode)}
             *   Parameter: {@link PRaiseNode} raiseNode
             *   Inline method: {@link PRaiseNodeGen#inline}</pre> */
            private static final PRaiseNode INLINED_FALLBACK_RAISE_NODE_ = PRaiseNodeGen.inline(InlineTarget.create(PRaiseNode.class, STATE_0_EqNode_UPDATER.subUpdater(23, 1)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link EqNode#eq(VirtualFrame, PCell, PCell, RichCmpOp, Node, PyObjectRichCompareBool, InlinedConditionProfile, GetRefNode, GetRefNode)}
             *   1: SpecializationActive {@link EqNode#eq(Object, Object, RichCmpOp, Node, PRaiseNode)}
             *   2-16: InlinedCache
             *        Specialization: {@link EqNode#eq(VirtualFrame, PCell, PCell, RichCmpOp, Node, PyObjectRichCompareBool, InlinedConditionProfile, GetRefNode, GetRefNode)}
             *        Parameter: {@link PyObjectRichCompareBool} richCmpNode
             *        Inline method: {@link PyObjectRichCompareBoolNodeGen#inline}
             *   17-18: InlinedCache
             *        Specialization: {@link EqNode#eq(VirtualFrame, PCell, PCell, RichCmpOp, Node, PyObjectRichCompareBool, InlinedConditionProfile, GetRefNode, GetRefNode)}
             *        Parameter: {@link InlinedConditionProfile} nonEmptyProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   19-20: InlinedCache
             *        Specialization: {@link EqNode#eq(VirtualFrame, PCell, PCell, RichCmpOp, Node, PyObjectRichCompareBool, InlinedConditionProfile, GetRefNode, GetRefNode)}
             *        Parameter: {@link GetRefNode} getRefL
             *        Inline method: {@link GetRefNodeGen#inline}
             *   21-22: InlinedCache
             *        Specialization: {@link EqNode#eq(VirtualFrame, PCell, PCell, RichCmpOp, Node, PyObjectRichCompareBool, InlinedConditionProfile, GetRefNode, GetRefNode)}
             *        Parameter: {@link GetRefNode} getRefR
             *        Inline method: {@link GetRefNodeGen#inline}
             *   23: InlinedCache
             *        Specialization: {@link EqNode#eq(Object, Object, RichCmpOp, Node, PRaiseNode)}
             *        Parameter: {@link PRaiseNode} raiseNode
             *        Inline method: {@link PRaiseNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link EqNode#eq(VirtualFrame, PCell, PCell, RichCmpOp, Node, PyObjectRichCompareBool, InlinedConditionProfile, GetRefNode, GetRefNode)}
             *   Parameter: {@link PyObjectRichCompareBool} richCmpNode
             *   Inline method: {@link PyObjectRichCompareBoolNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node eq_richCmpNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link EqNode#eq(VirtualFrame, PCell, PCell, RichCmpOp, Node, PyObjectRichCompareBool, InlinedConditionProfile, GetRefNode, GetRefNode)}
             *   Parameter: {@link PyObjectRichCompareBool} richCmpNode
             *   Inline method: {@link PyObjectRichCompareBoolNodeGen#inline}
             *   Inline field: {@link Node} field2</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node eq_richCmpNode__field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link EqNode#eq(VirtualFrame, PCell, PCell, RichCmpOp, Node, PyObjectRichCompareBool, InlinedConditionProfile, GetRefNode, GetRefNode)}
             *   Parameter: {@link GetRefNode} getRefL
             *   Inline method: {@link GetRefNodeGen#inline}
             *   Inline field: {@link Object} field1</pre> */
            @CompilationFinal @UnsafeAccessedField @SuppressWarnings("unused") private Object eq_getRefL__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link EqNode#eq(VirtualFrame, PCell, PCell, RichCmpOp, Node, PyObjectRichCompareBool, InlinedConditionProfile, GetRefNode, GetRefNode)}
             *   Parameter: {@link GetRefNode} getRefR
             *   Inline method: {@link GetRefNodeGen#inline}
             *   Inline field: {@link Object} field1</pre> */
            @CompilationFinal @UnsafeAccessedField @SuppressWarnings("unused") private Object eq_getRefR__field1_;

            private EqNodeGen() {
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, Object arg0Value, Object arg1Value, RichCmpOp arg2Value) {
                if (!((state_0 & 0b1) != 0 /* is SpecializationActive[CellBuiltins.EqNode.eq(VirtualFrame, PCell, PCell, RichCmpOp, Node, PyObjectRichCompareBool, InlinedConditionProfile, GetRefNode, GetRefNode)] */) && arg0Value instanceof PCell && arg1Value instanceof PCell) {
                    return false;
                }
                return true;
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value, RichCmpOp arg2Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[CellBuiltins.EqNode.eq(VirtualFrame, PCell, PCell, RichCmpOp, Node, PyObjectRichCompareBool, InlinedConditionProfile, GetRefNode, GetRefNode)] || SpecializationActive[CellBuiltins.EqNode.eq(Object, Object, RichCmpOp, Node, PRaiseNode)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[CellBuiltins.EqNode.eq(VirtualFrame, PCell, PCell, RichCmpOp, Node, PyObjectRichCompareBool, InlinedConditionProfile, GetRefNode, GetRefNode)] */ && arg0Value instanceof PCell) {
                        PCell arg0Value_ = (PCell) arg0Value;
                        if (arg1Value instanceof PCell) {
                            PCell arg1Value_ = (PCell) arg1Value;
                            {
                                Node inliningTarget__ = (this);
                                return EqNode.eq(frameValue, arg0Value_, arg1Value_, arg2Value, inliningTarget__, INLINED_EQ_RICH_CMP_NODE_, INLINED_EQ_NON_EMPTY_PROFILE_, INLINED_EQ_GET_REF_L_, INLINED_EQ_GET_REF_R_);
                            }
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[CellBuiltins.EqNode.eq(Object, Object, RichCmpOp, Node, PRaiseNode)] */) {
                        {
                            Node inliningTarget__1 = (this);
                            if (fallbackGuard_(state_0, arg0Value, arg1Value, arg2Value)) {
                                return EqNode.eq(arg0Value, arg1Value, arg2Value, inliningTarget__1, INLINED_FALLBACK_RAISE_NODE_);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value, arg2Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value, RichCmpOp arg2Value) {
                int state_0 = this.state_0_;
                {
                    Node inliningTarget__ = null;
                    if (arg0Value instanceof PCell) {
                        PCell arg0Value_ = (PCell) arg0Value;
                        if (arg1Value instanceof PCell) {
                            PCell arg1Value_ = (PCell) arg1Value;
                            inliningTarget__ = (this);
                            state_0 = state_0 | 0b1 /* add SpecializationActive[CellBuiltins.EqNode.eq(VirtualFrame, PCell, PCell, RichCmpOp, Node, PyObjectRichCompareBool, InlinedConditionProfile, GetRefNode, GetRefNode)] */;
                            this.state_0_ = state_0;
                            return EqNode.eq(frameValue, arg0Value_, arg1Value_, arg2Value, inliningTarget__, INLINED_EQ_RICH_CMP_NODE_, INLINED_EQ_NON_EMPTY_PROFILE_, INLINED_EQ_GET_REF_L_, INLINED_EQ_GET_REF_R_);
                        }
                    }
                }
                {
                    Node inliningTarget__1 = null;
                    inliningTarget__1 = (this);
                    state_0 = state_0 | 0b10 /* add SpecializationActive[CellBuiltins.EqNode.eq(Object, Object, RichCmpOp, Node, PRaiseNode)] */;
                    this.state_0_ = state_0;
                    return EqNode.eq(arg0Value, arg1Value, arg2Value, inliningTarget__1, INLINED_FALLBACK_RAISE_NODE_);
                }
            }

        }
    }
    @GeneratedBy(ReprNode.class)
    static final class ReprNodeFactory implements NodeFactory<ReprNode> {

        private static final ReprNodeFactory REPR_NODE_FACTORY_INSTANCE = new ReprNodeFactory();

        private ReprNodeFactory() {
        }

        @Override
        public Class<ReprNode> getNodeClass() {
            return ReprNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public ReprNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<ReprNode> getInstance() {
            return REPR_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ReprNode create() {
            return new ReprNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link ReprNode#repr}
         *     Activation probability: 0.65000
         *     With/without class size: 30/23 bytes
         *   Specialization {@link ReprNode#eq}
         *     Activation probability: 0.35000
         *     With/without class size: 11/1 bytes
         * </pre> */
        @GeneratedBy(ReprNode.class)
        @SuppressWarnings("javadoc")
        static final class ReprNodeGen extends ReprNode {

            private static final StateField STATE_0_ReprNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReprNode#repr}
             *   Parameter: {@link GetRefNode} getRef
             *   Inline method: {@link GetRefNodeGen#inline}</pre> */
            private static final GetRefNode INLINED_REPR_GET_REF_ = GetRefNodeGen.inline(InlineTarget.create(GetRefNode.class, STATE_0_ReprNode_UPDATER.subUpdater(2, 2), ReferenceField.create(MethodHandles.lookup(), "repr_getRef__field1_", Object.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReprNode#repr}
             *   Parameter: {@link GetClassNode} getClassNode
             *   Inline method: {@link GetClassNodeGen#inline}</pre> */
            private static final GetClassNode INLINED_REPR_GET_CLASS_NODE_ = GetClassNodeGen.inline(InlineTarget.create(GetClassNode.class, STATE_0_ReprNode_UPDATER.subUpdater(4, 16), ReferenceField.create(MethodHandles.lookup(), "repr_getClassNode__field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "repr_getClassNode__field2_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReprNode#repr}
             *   Parameter: {@link GetNameNode} getNameNode
             *   Inline method: {@link GetNameNodeGen#inline}</pre> */
            private static final GetNameNode INLINED_REPR_GET_NAME_NODE_ = GetNameNodeGen.inline(InlineTarget.create(GetNameNode.class, STATE_0_ReprNode_UPDATER.subUpdater(20, 3), ReferenceField.create(MethodHandles.lookup(), "repr_getNameNode__field1_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReprNode#eq}
             *   Parameter: {@link PRaiseNode} raiseNode
             *   Inline method: {@link PRaiseNodeGen#inline}</pre> */
            private static final PRaiseNode INLINED_FALLBACK_RAISE_NODE_ = PRaiseNodeGen.inline(InlineTarget.create(PRaiseNode.class, STATE_0_ReprNode_UPDATER.subUpdater(23, 1)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link ReprNode#repr}
             *   1: SpecializationActive {@link ReprNode#eq}
             *   2-3: InlinedCache
             *        Specialization: {@link ReprNode#repr}
             *        Parameter: {@link GetRefNode} getRef
             *        Inline method: {@link GetRefNodeGen#inline}
             *   4-19: InlinedCache
             *        Specialization: {@link ReprNode#repr}
             *        Parameter: {@link GetClassNode} getClassNode
             *        Inline method: {@link GetClassNodeGen#inline}
             *   20-22: InlinedCache
             *        Specialization: {@link ReprNode#repr}
             *        Parameter: {@link GetNameNode} getNameNode
             *        Inline method: {@link GetNameNodeGen#inline}
             *   23: InlinedCache
             *        Specialization: {@link ReprNode#eq}
             *        Parameter: {@link PRaiseNode} raiseNode
             *        Inline method: {@link PRaiseNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReprNode#repr}
             *   Parameter: {@link GetRefNode} getRef
             *   Inline method: {@link GetRefNodeGen#inline}
             *   Inline field: {@link Object} field1</pre> */
            @CompilationFinal @UnsafeAccessedField @SuppressWarnings("unused") private Object repr_getRef__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReprNode#repr}
             *   Parameter: {@link GetClassNode} getClassNode
             *   Inline method: {@link GetClassNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node repr_getClassNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReprNode#repr}
             *   Parameter: {@link GetClassNode} getClassNode
             *   Inline method: {@link GetClassNodeGen#inline}
             *   Inline field: {@link Node} field2</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node repr_getClassNode__field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReprNode#repr}
             *   Parameter: {@link GetNameNode} getNameNode
             *   Inline method: {@link GetNameNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node repr_getNameNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReprNode#repr}
             *   Parameter: {@link SimpleTruffleStringFormatNode} simpleTruffleStringFormatNode</pre> */
            @Child private SimpleTruffleStringFormatNode repr_simpleTruffleStringFormatNode_;

            private ReprNodeGen() {
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, Object arg0Value) {
                if (!((state_0 & 0b1) != 0 /* is SpecializationActive[CellBuiltins.ReprNode.repr(PCell, Node, GetRefNode, GetClassNode, GetNameNode, SimpleTruffleStringFormatNode)] */) && arg0Value instanceof PCell) {
                    return false;
                }
                return true;
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[CellBuiltins.ReprNode.repr(PCell, Node, GetRefNode, GetClassNode, GetNameNode, SimpleTruffleStringFormatNode)] || SpecializationActive[CellBuiltins.ReprNode.eq(Object, Node, PRaiseNode)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[CellBuiltins.ReprNode.repr(PCell, Node, GetRefNode, GetClassNode, GetNameNode, SimpleTruffleStringFormatNode)] */ && arg0Value instanceof PCell) {
                        PCell arg0Value_ = (PCell) arg0Value;
                        {
                            SimpleTruffleStringFormatNode simpleTruffleStringFormatNode__ = this.repr_simpleTruffleStringFormatNode_;
                            if (simpleTruffleStringFormatNode__ != null) {
                                Node inliningTarget__ = (this);
                                return ReprNode.repr(arg0Value_, inliningTarget__, INLINED_REPR_GET_REF_, INLINED_REPR_GET_CLASS_NODE_, INLINED_REPR_GET_NAME_NODE_, simpleTruffleStringFormatNode__);
                            }
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[CellBuiltins.ReprNode.eq(Object, Node, PRaiseNode)] */) {
                        {
                            Node inliningTarget__1 = (this);
                            if (fallbackGuard_(state_0, arg0Value)) {
                                return ReprNode.eq(arg0Value, inliningTarget__1, INLINED_FALLBACK_RAISE_NODE_);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private Object executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                {
                    Node inliningTarget__ = null;
                    if (arg0Value instanceof PCell) {
                        PCell arg0Value_ = (PCell) arg0Value;
                        inliningTarget__ = (this);
                        SimpleTruffleStringFormatNode simpleTruffleStringFormatNode__ = this.insert((SimpleTruffleStringFormatNodeGen.create()));
                        Objects.requireNonNull(simpleTruffleStringFormatNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.repr_simpleTruffleStringFormatNode_ = simpleTruffleStringFormatNode__;
                        state_0 = state_0 | 0b1 /* add SpecializationActive[CellBuiltins.ReprNode.repr(PCell, Node, GetRefNode, GetClassNode, GetNameNode, SimpleTruffleStringFormatNode)] */;
                        this.state_0_ = state_0;
                        return ReprNode.repr(arg0Value_, inliningTarget__, INLINED_REPR_GET_REF_, INLINED_REPR_GET_CLASS_NODE_, INLINED_REPR_GET_NAME_NODE_, simpleTruffleStringFormatNode__);
                    }
                }
                {
                    Node inliningTarget__1 = null;
                    inliningTarget__1 = (this);
                    state_0 = state_0 | 0b10 /* add SpecializationActive[CellBuiltins.ReprNode.eq(Object, Node, PRaiseNode)] */;
                    this.state_0_ = state_0;
                    return ReprNode.eq(arg0Value, inliningTarget__1, INLINED_FALLBACK_RAISE_NODE_);
                }
            }

        }
    }
    @GeneratedBy(CellContentsNode.class)
    public static final class CellContentsNodeFactory implements NodeFactory<CellContentsNode> {

        private static final CellContentsNodeFactory CELL_CONTENTS_NODE_FACTORY_INSTANCE = new CellContentsNodeFactory();

        private CellContentsNodeFactory() {
        }

        @Override
        public Class<CellContentsNode> getNodeClass() {
            return CellContentsNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(ReadArgumentNode.class, ReadArgumentNode.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(ReadArgumentNode[].class));
        }

        @Override
        public CellContentsNode createNode(Object... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return create((ReadArgumentNode[]) arguments[0]);
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<CellContentsNode> getInstance() {
            return CELL_CONTENTS_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static CellContentsNode create(ReadArgumentNode[] arguments) {
            return new CellContentsNodeGen(arguments);
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link CellContentsNode#get}
         *     Activation probability: 0.48333
         *     With/without class size: 15/5 bytes
         *   Specialization {@link CellContentsNode#delete}
         *     Activation probability: 0.33333
         *     With/without class size: 8/0 bytes
         *   Specialization {@link CellContentsNode#set}
         *     Activation probability: 0.18333
         *     With/without class size: 6/0 bytes
         * </pre> */
        @GeneratedBy(CellContentsNode.class)
        @SuppressWarnings("javadoc")
        public static final class CellContentsNodeGen extends CellContentsNode {

            private static final StateField STATE_0_CellContentsNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link CellContentsNode#get}
             *   Parameter: {@link GetRefNode} getRef
             *   Inline method: {@link GetRefNodeGen#inline}</pre> */
            private static final GetRefNode INLINED_GET_GET_REF_ = GetRefNodeGen.inline(InlineTarget.create(GetRefNode.class, STATE_0_CellContentsNode_UPDATER.subUpdater(3, 2), ReferenceField.create(MethodHandles.lookup(), "get_getRef__field1_", Object.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link CellContentsNode#get}
             *   Parameter: {@link PRaiseNode} raiseNode
             *   Inline method: {@link PRaiseNodeGen#inline}</pre> */
            private static final PRaiseNode INLINED_GET_RAISE_NODE_ = PRaiseNodeGen.inline(InlineTarget.create(PRaiseNode.class, STATE_0_CellContentsNode_UPDATER.subUpdater(5, 1)));

            @Child private ReadArgumentNode arguments0_;
            @Child private ReadArgumentNode arguments1_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link CellContentsNode#get}
             *   1: SpecializationActive {@link CellContentsNode#delete}
             *   2: SpecializationActive {@link CellContentsNode#set}
             *   3-4: InlinedCache
             *        Specialization: {@link CellContentsNode#get}
             *        Parameter: {@link GetRefNode} getRef
             *        Inline method: {@link GetRefNodeGen#inline}
             *   5: InlinedCache
             *        Specialization: {@link CellContentsNode#get}
             *        Parameter: {@link PRaiseNode} raiseNode
             *        Inline method: {@link PRaiseNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CellContentsNode#get}
             *   Parameter: {@link GetRefNode} getRef
             *   Inline method: {@link GetRefNodeGen#inline}
             *   Inline field: {@link Object} field1</pre> */
            @CompilationFinal @UnsafeAccessedField @SuppressWarnings("unused") private Object get_getRef__field1_;

            private CellContentsNodeGen(ReadArgumentNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                if ((state_0 & 0b111) != 0 /* is SpecializationActive[CellBuiltins.CellContentsNode.get(PCell, PNone, Node, GetRefNode, PRaiseNode)] || SpecializationActive[CellBuiltins.CellContentsNode.delete(PCell, Object)] || SpecializationActive[CellBuiltins.CellContentsNode.set(PCell, Object)] */ && arguments0Value_ instanceof PCell) {
                    PCell arguments0Value__ = (PCell) arguments0Value_;
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[CellBuiltins.CellContentsNode.get(PCell, PNone, Node, GetRefNode, PRaiseNode)] */ && arguments1Value_ instanceof PNone) {
                        PNone arguments1Value__ = (PNone) arguments1Value_;
                        if ((PGuards.isNoValue(arguments1Value__))) {
                            Node inliningTarget__ = (this);
                            return CellContentsNode.get(arguments0Value__, arguments1Value__, inliningTarget__, INLINED_GET_GET_REF_, INLINED_GET_RAISE_NODE_);
                        }
                    }
                    if ((state_0 & 0b110) != 0 /* is SpecializationActive[CellBuiltins.CellContentsNode.delete(PCell, Object)] || SpecializationActive[CellBuiltins.CellContentsNode.set(PCell, Object)] */) {
                        if ((state_0 & 0b10) != 0 /* is SpecializationActive[CellBuiltins.CellContentsNode.delete(PCell, Object)] */) {
                            if ((PGuards.isDeleteMarker(arguments1Value_))) {
                                return CellContentsNode.delete(arguments0Value__, arguments1Value_);
                            }
                        }
                        if ((state_0 & 0b100) != 0 /* is SpecializationActive[CellBuiltins.CellContentsNode.set(PCell, Object)] */) {
                            if ((!(PGuards.isNoValue(arguments1Value_))) && (!(PGuards.isDeleteMarker(arguments1Value_)))) {
                                return CellContentsNode.set(arguments0Value__, arguments1Value_);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arguments0Value_, arguments1Value_);
            }

            private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
                int state_0 = this.state_0_;
                if (arguments0Value instanceof PCell) {
                    PCell arguments0Value_ = (PCell) arguments0Value;
                    {
                        Node inliningTarget__ = null;
                        if (arguments1Value instanceof PNone) {
                            PNone arguments1Value_ = (PNone) arguments1Value;
                            if ((PGuards.isNoValue(arguments1Value_))) {
                                inliningTarget__ = (this);
                                state_0 = state_0 | 0b1 /* add SpecializationActive[CellBuiltins.CellContentsNode.get(PCell, PNone, Node, GetRefNode, PRaiseNode)] */;
                                this.state_0_ = state_0;
                                return CellContentsNode.get(arguments0Value_, arguments1Value_, inliningTarget__, INLINED_GET_GET_REF_, INLINED_GET_RAISE_NODE_);
                            }
                        }
                    }
                    if ((PGuards.isDeleteMarker(arguments1Value))) {
                        state_0 = state_0 | 0b10 /* add SpecializationActive[CellBuiltins.CellContentsNode.delete(PCell, Object)] */;
                        this.state_0_ = state_0;
                        return CellContentsNode.delete(arguments0Value_, arguments1Value);
                    }
                    if ((!(PGuards.isNoValue(arguments1Value))) && (!(PGuards.isDeleteMarker(arguments1Value)))) {
                        state_0 = state_0 | 0b100 /* add SpecializationActive[CellBuiltins.CellContentsNode.set(PCell, Object)] */;
                        this.state_0_ = state_0;
                        return CellContentsNode.set(arguments0Value_, arguments1Value);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {this.arguments0_, this.arguments1_}, arguments0Value, arguments1Value);
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link GetRefNode#cached}
     *     Activation probability: 0.65000
     *     With/without class size: 17/8 bytes
     *   Specialization {@link GetRefNode#uncached}
     *     Activation probability: 0.35000
     *     With/without class size: 8/0 bytes
     * </pre> */
    @GeneratedBy(GetRefNode.class)
    @SuppressWarnings("javadoc")
    public static final class GetRefNodeGen {

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * <li>{@link Inlined#cached_cache}
         * </ul> */
        @NeverDefault
        public static GetRefNode inline(@RequiredField(bits = 2, value = StateField.class)@RequiredField(type = Object.class, value = ReferenceField.class) InlineTarget target) {
            return new GetRefNodeGen.Inlined(target);
        }

        @GeneratedBy(GetRefNode.class)
        @DenyReplace
        private static final class Inlined extends GetRefNode implements UnadoptableNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link GetRefNode#cached}
             *   1: SpecializationActive {@link GetRefNode#uncached}
             * </pre> */
            private final StateField state_0_;
            private final ReferenceField<CachedData> cached_cache;

            @SuppressWarnings("unchecked")
            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(GetRefNode.class);
                this.state_0_ = target.getState(0, 2);
                this.cached_cache = target.getReference(1, CachedData.class);
            }

            @Override
            public Object execute(Node arg0Value, PCell arg1Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (state_0 != 0 /* is SpecializationActive[CellBuiltins.GetRefNode.cached(PCell, PCell, Object)] || SpecializationActive[CellBuiltins.GetRefNode.uncached(PCell)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[CellBuiltins.GetRefNode.cached(PCell, PCell, Object)] */) {
                        CachedData s0_ = this.cached_cache.get(arg0Value);
                        if (s0_ != null) {
                            if (!Assumption.isValidAssumption(s0_.assumption0_)) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                removeCached_(arg0Value, s0_);
                                return executeAndSpecialize(arg0Value, arg1Value);
                            }
                            assert DSLSupport.assertIdempotence((isSingleContext()));
                            if ((arg1Value == s0_.cachedSelf_)) {
                                return cached(arg1Value, s0_.cachedSelf_, s0_.ref_);
                            }
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[CellBuiltins.GetRefNode.uncached(PCell)] */) {
                        return uncached(arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            @SuppressWarnings("unused")
            private Object executeAndSpecialize(Node arg0Value, PCell arg1Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[CellBuiltins.GetRefNode.uncached(PCell)] */) {
                    while (true) {
                        int count0_ = 0;
                        CachedData s0_ = this.cached_cache.getVolatile(arg0Value);
                        CachedData s0_original = s0_;
                        while (s0_ != null) {
                            assert DSLSupport.assertIdempotence((isSingleContext()));
                            if ((arg1Value == s0_.cachedSelf_) && Assumption.isValidAssumption(s0_.assumption0_)) {
                                break;
                            }
                            count0_++;
                            s0_ = null;
                            break;
                        }
                        if (s0_ == null && count0_ < 1) {
                            if ((isSingleContext())) {
                                PCell cachedSelf__ = (arg1Value);
                                // assert (arg1Value == s0_.cachedSelf_);
                                Assumption assumption0 = (cachedSelf__.isEffectivelyFinalAssumption());
                                if (Assumption.isValidAssumption(assumption0)) {
                                    s0_ = new CachedData();
                                    Objects.requireNonNull(cachedSelf__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                    s0_.cachedSelf_ = cachedSelf__;
                                    s0_.ref_ = (arg1Value.getRef());
                                    s0_.assumption0_ = assumption0;
                                    if (!this.cached_cache.compareAndSet(arg0Value, s0_original, s0_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b1 /* add SpecializationActive[CellBuiltins.GetRefNode.cached(PCell, PCell, Object)] */;
                                    this.state_0_.set(arg0Value, state_0);
                                }
                            }
                        }
                        if (s0_ != null) {
                            return cached(arg1Value, s0_.cachedSelf_, s0_.ref_);
                        }
                        break;
                    }
                }
                this.cached_cache.set(arg0Value, null);
                state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[CellBuiltins.GetRefNode.cached(PCell, PCell, Object)] */;
                state_0 = state_0 | 0b10 /* add SpecializationActive[CellBuiltins.GetRefNode.uncached(PCell)] */;
                this.state_0_.set(arg0Value, state_0);
                return uncached(arg1Value);
            }

            void removeCached_(Node arg0Value, CachedData s0_) {
                this.state_0_.set(arg0Value, state_0_.get(arg0Value) & 0xfffffffe /* remove SpecializationActive[CellBuiltins.GetRefNode.cached(PCell, PCell, Object)] */);
                this.cached_cache.set(arg0Value, null);
            }

        }
        @GeneratedBy(GetRefNode.class)
        @DenyReplace
        private static final class CachedData implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link GetRefNode#cached}
             *   Parameter: {@link PCell} cachedSelf</pre> */
            @CompilationFinal PCell cachedSelf_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link GetRefNode#cached}
             *   Parameter: {@link Object} ref</pre> */
            @CompilationFinal Object ref_;
            @CompilationFinal Assumption assumption0_;

            CachedData() {
            }

        }
    }
}
