// CheckStyle: start generated
package com.oracle.graal.python.builtins.objects.posix;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.posix.ScandirIteratorBuiltins.CloseNode;
import com.oracle.graal.python.builtins.objects.posix.ScandirIteratorBuiltins.EnterNode;
import com.oracle.graal.python.builtins.objects.posix.ScandirIteratorBuiltins.ExitNode;
import com.oracle.graal.python.builtins.objects.posix.ScandirIteratorBuiltins.IterNode;
import com.oracle.graal.python.builtins.objects.posix.ScandirIteratorBuiltins.NextNode;
import com.oracle.graal.python.nodes.PConstructAndRaiseNode.Lazy;
import com.oracle.graal.python.nodes.PConstructAndRaiseNodeGen.LazyNodeGen;
import com.oracle.graal.python.nodes.argument.ReadArgumentNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.runtime.PosixSupportLibrary;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.List;
import java.util.Objects;

@GeneratedBy(ScandirIteratorBuiltins.class)
@SuppressWarnings("javadoc")
public final class ScandirIteratorBuiltinsFactory {

    private static final LibraryFactory<PosixSupportLibrary> POSIX_SUPPORT_LIBRARY_ = LibraryFactory.resolve(PosixSupportLibrary.class);

    public static List<NodeFactory<? extends PythonBuiltinBaseNode>> getFactories() {
        return List.of(CloseNodeFactory.getInstance(), IterNodeFactory.getInstance(), NextNodeFactory.getInstance(), EnterNodeFactory.getInstance(), ExitNodeFactory.getInstance());
    }

    @GeneratedBy(CloseNode.class)
    static final class CloseNodeFactory implements NodeFactory<CloseNode> {

        private static final CloseNodeFactory CLOSE_NODE_FACTORY_INSTANCE = new CloseNodeFactory();

        private CloseNodeFactory() {
        }

        @Override
        public Class<CloseNode> getNodeClass() {
            return CloseNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public CloseNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<CloseNode> getInstance() {
            return CLOSE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static CloseNode create() {
            return new CloseNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link CloseNode#close}
         *     Activation probability: 1.00000
         *     With/without class size: 24/4 bytes
         * </pre> */
        @GeneratedBy(CloseNode.class)
        @SuppressWarnings("javadoc")
        static final class CloseNodeGen extends CloseNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link CloseNode#close}
             * </pre> */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CloseNode#close}
             *   Parameter: {@link PosixSupportLibrary} posixLib</pre> */
            @Child private PosixSupportLibrary posixLib_;

            private CloseNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[ScandirIteratorBuiltins.CloseNode.close(PScandirIterator, PosixSupportLibrary)] */ && arg0Value instanceof PScandirIterator) {
                    PScandirIterator arg0Value_ = (PScandirIterator) arg0Value;
                    {
                        PosixSupportLibrary posixLib__ = this.posixLib_;
                        if (posixLib__ != null) {
                            if ((posixLib__.accepts(getPosixSupport()))) {
                                return close(arg0Value_, posixLib__);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private PNone executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PScandirIterator) {
                    PScandirIterator arg0Value_ = (PScandirIterator) arg0Value;
                    // assert (this.posixLib_.accepts(getPosixSupport()));
                    PosixSupportLibrary posixLib__ = this.insert((POSIX_SUPPORT_LIBRARY_.create(getPosixSupport())));
                    Objects.requireNonNull(posixLib__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.posixLib_ = posixLib__;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[ScandirIteratorBuiltins.CloseNode.close(PScandirIterator, PosixSupportLibrary)] */;
                    this.state_0_ = state_0;
                    return close(arg0Value_, posixLib__);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

        }
    }
    @GeneratedBy(IterNode.class)
    static final class IterNodeFactory implements NodeFactory<IterNode> {

        private static final IterNodeFactory ITER_NODE_FACTORY_INSTANCE = new IterNodeFactory();

        private IterNodeFactory() {
        }

        @Override
        public Class<IterNode> getNodeClass() {
            return IterNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public IterNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<IterNode> getInstance() {
            return ITER_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IterNode create() {
            return new IterNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link IterNode#iter}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre> */
        @GeneratedBy(IterNode.class)
        @SuppressWarnings("javadoc")
        static final class IterNodeGen extends IterNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link IterNode#iter}
             * </pre> */
            @CompilationFinal private int state_0_;

            private IterNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[ScandirIteratorBuiltins.IterNode.iter(PScandirIterator)] */ && arg0Value instanceof PScandirIterator) {
                    PScandirIterator arg0Value_ = (PScandirIterator) arg0Value;
                    return iter(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private PScandirIterator executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PScandirIterator) {
                    PScandirIterator arg0Value_ = (PScandirIterator) arg0Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[ScandirIteratorBuiltins.IterNode.iter(PScandirIterator)] */;
                    this.state_0_ = state_0;
                    return iter(arg0Value_);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

        }
    }
    @GeneratedBy(NextNode.class)
    static final class NextNodeFactory implements NodeFactory<NextNode> {

        private static final NextNodeFactory NEXT_NODE_FACTORY_INSTANCE = new NextNodeFactory();

        private NextNodeFactory() {
        }

        @Override
        public Class<NextNode> getNodeClass() {
            return NextNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public NextNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<NextNode> getInstance() {
            return NEXT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static NextNode create() {
            return new NextNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link NextNode#next}
         *     Activation probability: 1.00000
         *     With/without class size: 32/9 bytes
         * </pre> */
        @GeneratedBy(NextNode.class)
        @SuppressWarnings("javadoc")
        static final class NextNodeGen extends NextNode {

            private static final StateField STATE_0_NextNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link NextNode#next}
             *   Parameter: {@link Lazy} constructAndRaiseNode
             *   Inline method: {@link LazyNodeGen#inline}</pre> */
            private static final Lazy INLINED_CONSTRUCT_AND_RAISE_NODE_ = LazyNodeGen.inline(InlineTarget.create(Lazy.class, STATE_0_NextNode_UPDATER.subUpdater(1, 1), ReferenceField.create(MethodHandles.lookup(), "constructAndRaiseNode__field1_", Node.class)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link NextNode#next}
             *   1: InlinedCache
             *        Specialization: {@link NextNode#next}
             *        Parameter: {@link Lazy} constructAndRaiseNode
             *        Inline method: {@link LazyNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link NextNode#next}
             *   Parameter: {@link PosixSupportLibrary} posixLib</pre> */
            @Child private PosixSupportLibrary posixLib_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link NextNode#next}
             *   Parameter: {@link Lazy} constructAndRaiseNode
             *   Inline method: {@link LazyNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node constructAndRaiseNode__field1_;

            private NextNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[ScandirIteratorBuiltins.NextNode.next(VirtualFrame, PScandirIterator, Node, PosixSupportLibrary, Lazy, PythonLanguage)] */ && arg0Value instanceof PScandirIterator) {
                    PScandirIterator arg0Value_ = (PScandirIterator) arg0Value;
                    {
                        PosixSupportLibrary posixLib__ = this.posixLib_;
                        if (posixLib__ != null) {
                            if ((posixLib__.accepts(getPosixSupport()))) {
                                Node inliningTarget__ = (this);
                                PythonLanguage language__ = (PythonLanguage.get(this));
                                return NextNode.next(frameValue, arg0Value_, inliningTarget__, posixLib__, INLINED_CONSTRUCT_AND_RAISE_NODE_, language__);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                {
                    PythonLanguage language__ = null;
                    Node inliningTarget__ = null;
                    if (arg0Value instanceof PScandirIterator) {
                        PScandirIterator arg0Value_ = (PScandirIterator) arg0Value;
                        // assert (this.posixLib_.accepts(getPosixSupport()));
                        inliningTarget__ = (this);
                        PosixSupportLibrary posixLib__ = this.insert((POSIX_SUPPORT_LIBRARY_.create(getPosixSupport())));
                        Objects.requireNonNull(posixLib__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.posixLib_ = posixLib__;
                        language__ = (PythonLanguage.get(this));
                        state_0 = state_0 | 0b1 /* add SpecializationActive[ScandirIteratorBuiltins.NextNode.next(VirtualFrame, PScandirIterator, Node, PosixSupportLibrary, Lazy, PythonLanguage)] */;
                        this.state_0_ = state_0;
                        return NextNode.next(frameValue, arg0Value_, inliningTarget__, posixLib__, INLINED_CONSTRUCT_AND_RAISE_NODE_, language__);
                    }
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

        }
    }
    @GeneratedBy(EnterNode.class)
    static final class EnterNodeFactory implements NodeFactory<EnterNode> {

        private static final EnterNodeFactory ENTER_NODE_FACTORY_INSTANCE = new EnterNodeFactory();

        private EnterNodeFactory() {
        }

        @Override
        public Class<EnterNode> getNodeClass() {
            return EnterNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public EnterNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<EnterNode> getInstance() {
            return ENTER_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EnterNode create() {
            return new EnterNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link EnterNode#iter}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre> */
        @GeneratedBy(EnterNode.class)
        @SuppressWarnings("javadoc")
        static final class EnterNodeGen extends EnterNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link EnterNode#iter}
             * </pre> */
            @CompilationFinal private int state_0_;

            private EnterNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[ScandirIteratorBuiltins.EnterNode.iter(PScandirIterator)] */ && arg0Value instanceof PScandirIterator) {
                    PScandirIterator arg0Value_ = (PScandirIterator) arg0Value;
                    return iter(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private PScandirIterator executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PScandirIterator) {
                    PScandirIterator arg0Value_ = (PScandirIterator) arg0Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[ScandirIteratorBuiltins.EnterNode.iter(PScandirIterator)] */;
                    this.state_0_ = state_0;
                    return iter(arg0Value_);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

        }
    }
    @GeneratedBy(ExitNode.class)
    static final class ExitNodeFactory implements NodeFactory<ExitNode> {

        private static final ExitNodeFactory EXIT_NODE_FACTORY_INSTANCE = new ExitNodeFactory();

        private ExitNodeFactory() {
        }

        @Override
        public Class<ExitNode> getNodeClass() {
            return ExitNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(ReadArgumentNode.class, ReadArgumentNode.class, ReadArgumentNode.class, ReadArgumentNode.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(ReadArgumentNode[].class));
        }

        @Override
        public ExitNode createNode(Object... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return create((ReadArgumentNode[]) arguments[0]);
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<ExitNode> getInstance() {
            return EXIT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ExitNode create(ReadArgumentNode[] arguments) {
            return new ExitNodeGen(arguments);
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link ExitNode#exit}
         *     Activation probability: 1.00000
         *     With/without class size: 24/4 bytes
         * </pre> */
        @GeneratedBy(ExitNode.class)
        @SuppressWarnings("javadoc")
        static final class ExitNodeGen extends ExitNode {

            @Child private ReadArgumentNode arguments0_;
            @Child private ReadArgumentNode arguments1_;
            @Child private ReadArgumentNode arguments2_;
            @Child private ReadArgumentNode arguments3_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link ExitNode#exit}
             * </pre> */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ExitNode#exit}
             *   Parameter: {@link PosixSupportLibrary} posixLib</pre> */
            @Child private PosixSupportLibrary posixLib_;

            private ExitNodeGen(ReadArgumentNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.arguments3_ = arguments != null && 3 < arguments.length ? arguments[3] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                Object arguments2Value_ = this.arguments2_.execute(frameValue);
                Object arguments3Value_ = this.arguments3_.execute(frameValue);
                if (state_0 != 0 /* is SpecializationActive[ScandirIteratorBuiltins.ExitNode.exit(PScandirIterator, Object, Object, Object, PosixSupportLibrary)] */ && arguments0Value_ instanceof PScandirIterator) {
                    PScandirIterator arguments0Value__ = (PScandirIterator) arguments0Value_;
                    {
                        PosixSupportLibrary posixLib__ = this.posixLib_;
                        if (posixLib__ != null) {
                            if ((posixLib__.accepts(getPosixSupport()))) {
                                return exit(arguments0Value__, arguments1Value_, arguments2Value_, arguments3Value_, posixLib__);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
            }

            private PNone executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                int state_0 = this.state_0_;
                if (arguments0Value instanceof PScandirIterator) {
                    PScandirIterator arguments0Value_ = (PScandirIterator) arguments0Value;
                    // assert (this.posixLib_.accepts(getPosixSupport()));
                    PosixSupportLibrary posixLib__ = this.insert((POSIX_SUPPORT_LIBRARY_.create(getPosixSupport())));
                    Objects.requireNonNull(posixLib__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.posixLib_ = posixLib__;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[ScandirIteratorBuiltins.ExitNode.exit(PScandirIterator, Object, Object, Object, PosixSupportLibrary)] */;
                    this.state_0_ = state_0;
                    return exit(arguments0Value_, arguments1Value, arguments2Value, arguments3Value, posixLib__);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {this.arguments0_, this.arguments1_, this.arguments2_, this.arguments3_}, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

        }
    }
}
