// CheckStyle: start generated
package com.oracle.graal.python.builtins.objects.struct;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.struct.StructBuiltins.ConstructStructNode;
import com.oracle.graal.python.builtins.objects.struct.StructBuiltins.GetStructFormat;
import com.oracle.graal.python.builtins.objects.struct.StructBuiltins.GetStructSizeNode;
import com.oracle.graal.python.builtins.objects.struct.StructBuiltins.StructCalcSizeNode;
import com.oracle.graal.python.builtins.objects.struct.StructBuiltins.StructIterUnpackNode;
import com.oracle.graal.python.builtins.objects.struct.StructBuiltins.StructPackIntoNode;
import com.oracle.graal.python.builtins.objects.struct.StructBuiltins.StructPackNode;
import com.oracle.graal.python.builtins.objects.struct.StructBuiltins.StructUnpackFromNode;
import com.oracle.graal.python.builtins.objects.struct.StructBuiltins.StructUnpackNode;
import com.oracle.graal.python.builtins.objects.struct.StructNodes.PackValueNode;
import com.oracle.graal.python.builtins.objects.struct.StructNodes.UnpackValueNode;
import com.oracle.graal.python.builtins.objects.struct.StructNodesFactory.PackValueNodeGen;
import com.oracle.graal.python.builtins.objects.struct.StructNodesFactory.UnpackValueNodeGen;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.PRaiseNodeGen;
import com.oracle.graal.python.nodes.argument.ReadArgumentNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNodeGen;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleString.CopyToByteArrayNode;
import com.oracle.truffle.api.strings.TruffleString.FromByteArrayNode;
import com.oracle.truffle.api.strings.TruffleString.GetCodeRangeNode;
import com.oracle.truffle.api.strings.TruffleString.SwitchEncodingNode;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.invoke.MethodHandles.Lookup;
import java.util.List;
import java.util.Objects;

@GeneratedBy(StructBuiltins.class)
@SuppressWarnings({"javadoc", "unused"})
public final class StructBuiltinsFactory {

    private static final LibraryFactory<PythonBufferAccessLibrary> PYTHON_BUFFER_ACCESS_LIBRARY_ = LibraryFactory.resolve(PythonBufferAccessLibrary.class);

    public static List<NodeFactory<? extends PythonBuiltinBaseNode>> getFactories() {
        return List.of(ConstructStructNodeFactory.getInstance(), StructPackNodeFactory.getInstance(), StructPackIntoNodeFactory.getInstance(), StructUnpackNodeFactory.getInstance(), StructIterUnpackNodeFactory.getInstance(), StructUnpackFromNodeFactory.getInstance(), StructCalcSizeNodeFactory.getInstance(), GetStructSizeNodeFactory.getInstance(), GetStructFormatFactory.getInstance());
    }

    @GeneratedBy(ConstructStructNode.class)
    public static final class ConstructStructNodeFactory implements NodeFactory<ConstructStructNode> {

        private static final ConstructStructNodeFactory CONSTRUCT_STRUCT_NODE_FACTORY_INSTANCE = new ConstructStructNodeFactory();

        private ConstructStructNodeFactory() {
        }

        @Override
        public Class<ConstructStructNode> getNodeClass() {
            return ConstructStructNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public ConstructStructNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<ConstructStructNode> getInstance() {
            return CONSTRUCT_STRUCT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ConstructStructNode create() {
            return new ConstructStructNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link ConstructStructNode#struct(Object, TruffleString, Node, CopyToByteArrayNode, SwitchEncodingNode, GetCodeRangeNode)}
         *     Activation probability: 0.32000
         *     With/without class size: 7/0 bytes
         *   Specialization {@link ConstructStructNode#struct(Object, PString, Node, CastToTruffleStringNode, CopyToByteArrayNode, SwitchEncodingNode, GetCodeRangeNode)}
         *     Activation probability: 0.26000
         *     With/without class size: 12/13 bytes
         *   Specialization {@link ConstructStructNode#struct(Object, PBytes, Node, PythonBufferAccessLibrary)}
         *     Activation probability: 0.20000
         *     With/without class size: 8/4 bytes
         *   Specialization {@link ConstructStructNode#struct(Object, PBytes, Node, PythonBufferAccessLibrary)}
         *     Activation probability: 0.14000
         *     With/without class size: 5/0 bytes
         *   Specialization {@link ConstructStructNode#fallback}
         *     Activation probability: 0.08000
         *     With/without class size: 4/0 bytes
         * </pre> */
        @GeneratedBy(ConstructStructNode.class)
        @SuppressWarnings("javadoc")
        public static final class ConstructStructNodeGen extends ConstructStructNode {

            private static final StateField STRUCT1_CONSTRUCT_STRUCT_NODE_STRUCT1_STATE_0_UPDATER = StateField.create(Struct1Data.lookup_(), "struct1_state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link ConstructStructNode#struct(Object, PString, Node, CastToTruffleStringNode, CopyToByteArrayNode, SwitchEncodingNode, GetCodeRangeNode)}
             *   Parameter: {@link CastToTruffleStringNode} castToTruffleStringNode
             *   Inline method: {@link CastToTruffleStringNodeGen#inline}</pre> */
            private static final CastToTruffleStringNode INLINED_STRUCT1_CAST_TO_TRUFFLE_STRING_NODE_ = CastToTruffleStringNodeGen.inline(InlineTarget.create(CastToTruffleStringNode.class, STRUCT1_CONSTRUCT_STRUCT_NODE_STRUCT1_STATE_0_UPDATER.subUpdater(0, 8), ReferenceField.create(Struct1Data.lookup_(), "struct1_castToTruffleStringNode__field1_", Node.class), ReferenceField.create(Struct1Data.lookup_(), "struct1_castToTruffleStringNode__field2_", Node.class), ReferenceField.create(Struct1Data.lookup_(), "struct1_castToTruffleStringNode__field3_", Node.class)));
            static final ReferenceField<Struct2Data> STRUCT2_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "struct2_cache", Struct2Data.class);

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link ConstructStructNode#struct(Object, TruffleString, Node, CopyToByteArrayNode, SwitchEncodingNode, GetCodeRangeNode)}
             *   1: SpecializationActive {@link ConstructStructNode#struct(Object, PString, Node, CastToTruffleStringNode, CopyToByteArrayNode, SwitchEncodingNode, GetCodeRangeNode)}
             *   2: SpecializationActive {@link ConstructStructNode#struct(Object, PBytes, Node, PythonBufferAccessLibrary)}
             *   3: SpecializationActive {@link ConstructStructNode#struct(Object, PBytes, Node, PythonBufferAccessLibrary)}
             *   4: SpecializationActive {@link ConstructStructNode#fallback}
             * </pre> */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ConstructStructNode#struct(Object, TruffleString, Node, CopyToByteArrayNode, SwitchEncodingNode, GetCodeRangeNode)}
             *   Parameter: {@link CopyToByteArrayNode} copyToByteArrayNode</pre> */
            @Child private CopyToByteArrayNode copyToByteArrayNode;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ConstructStructNode#struct(Object, TruffleString, Node, CopyToByteArrayNode, SwitchEncodingNode, GetCodeRangeNode)}
             *   Parameter: {@link SwitchEncodingNode} switchEncodingNode</pre> */
            @Child private SwitchEncodingNode switchEncodingNode;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ConstructStructNode#struct(Object, TruffleString, Node, CopyToByteArrayNode, SwitchEncodingNode, GetCodeRangeNode)}
             *   Parameter: {@link GetCodeRangeNode} getCodeRangeNode</pre> */
            @Child private GetCodeRangeNode getCodeRangeNode;
            @Child private Struct1Data struct1_cache;
            @UnsafeAccessedField @Child private Struct2Data struct2_cache;

            private ConstructStructNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[StructBuiltins.ConstructStructNode.struct(Object, TruffleString, Node, CopyToByteArrayNode, SwitchEncodingNode, GetCodeRangeNode)] || SpecializationActive[StructBuiltins.ConstructStructNode.struct(Object, PString, Node, CastToTruffleStringNode, CopyToByteArrayNode, SwitchEncodingNode, GetCodeRangeNode)] || SpecializationActive[StructBuiltins.ConstructStructNode.struct(Object, PBytes, Node, PythonBufferAccessLibrary)] || SpecializationActive[StructBuiltins.ConstructStructNode.struct(Object, PBytes, Node, PythonBufferAccessLibrary)] || SpecializationActive[StructBuiltins.ConstructStructNode.fallback(Object, Object, GetCodeRangeNode, Node)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[StructBuiltins.ConstructStructNode.struct(Object, TruffleString, Node, CopyToByteArrayNode, SwitchEncodingNode, GetCodeRangeNode)] */ && arg1Value instanceof TruffleString) {
                        TruffleString arg1Value_ = (TruffleString) arg1Value;
                        {
                            CopyToByteArrayNode copyToByteArrayNode_ = this.copyToByteArrayNode;
                            if (copyToByteArrayNode_ != null) {
                                SwitchEncodingNode switchEncodingNode_ = this.switchEncodingNode;
                                if (switchEncodingNode_ != null) {
                                    GetCodeRangeNode getCodeRangeNode_ = this.getCodeRangeNode;
                                    if (getCodeRangeNode_ != null) {
                                        if ((PythonUtils.isAscii(arg1Value_, getCodeRangeNode_))) {
                                            Node inliningTarget__ = (this);
                                            return ConstructStructNode.struct(arg0Value, arg1Value_, inliningTarget__, copyToByteArrayNode_, switchEncodingNode_, getCodeRangeNode_);
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[StructBuiltins.ConstructStructNode.struct(Object, PString, Node, CastToTruffleStringNode, CopyToByteArrayNode, SwitchEncodingNode, GetCodeRangeNode)] */ && arg1Value instanceof PString) {
                        PString arg1Value_ = (PString) arg1Value;
                        Struct1Data s1_ = this.struct1_cache;
                        if (s1_ != null) {
                            {
                                CopyToByteArrayNode copyToByteArrayNode_1 = this.copyToByteArrayNode;
                                if (copyToByteArrayNode_1 != null) {
                                    SwitchEncodingNode switchEncodingNode_1 = this.switchEncodingNode;
                                    if (switchEncodingNode_1 != null) {
                                        GetCodeRangeNode getCodeRangeNode_1 = this.getCodeRangeNode;
                                        if (getCodeRangeNode_1 != null) {
                                            Node inliningTarget__1 = (s1_);
                                            return ConstructStructNode.struct(arg0Value, arg1Value_, inliningTarget__1, INLINED_STRUCT1_CAST_TO_TRUFFLE_STRING_NODE_, copyToByteArrayNode_1, switchEncodingNode_1, getCodeRangeNode_1);
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b1100) != 0 /* is SpecializationActive[StructBuiltins.ConstructStructNode.struct(Object, PBytes, Node, PythonBufferAccessLibrary)] || SpecializationActive[StructBuiltins.ConstructStructNode.struct(Object, PBytes, Node, PythonBufferAccessLibrary)] */ && arg1Value instanceof PBytes) {
                        PBytes arg1Value_ = (PBytes) arg1Value;
                        if ((state_0 & 0b100) != 0 /* is SpecializationActive[StructBuiltins.ConstructStructNode.struct(Object, PBytes, Node, PythonBufferAccessLibrary)] */) {
                            Struct2Data s2_ = this.struct2_cache;
                            if (s2_ != null) {
                                if ((s2_.bufferLib_.accepts(arg1Value_))) {
                                    Node inliningTarget__2 = (this);
                                    return ConstructStructNode.struct(arg0Value, arg1Value_, inliningTarget__2, s2_.bufferLib_);
                                }
                            }
                        }
                        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[StructBuiltins.ConstructStructNode.struct(Object, PBytes, Node, PythonBufferAccessLibrary)] */) {
                            return this.struct3Boundary(state_0, arg0Value, arg1Value_);
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[StructBuiltins.ConstructStructNode.fallback(Object, Object, GetCodeRangeNode, Node)] */) {
                        {
                            GetCodeRangeNode getCodeRangeNode_2 = this.getCodeRangeNode;
                            if (getCodeRangeNode_2 != null) {
                                if ((!(PGuards.isPBytes(arg1Value))) && (!(PGuards.isPString(arg1Value))) && (!(ConstructStructNode.isAsciiTruffleString(arg1Value, getCodeRangeNode_2)))) {
                                    Node inliningTarget__3 = (this);
                                    return ConstructStructNode.fallback(arg0Value, arg1Value, getCodeRangeNode_2, inliningTarget__3);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            @SuppressWarnings("static-method")
            @TruffleBoundary
            private Object struct3Boundary(int state_0, Object arg0Value, PBytes arg1Value_) {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set(this);
                try {
                    {
                        Node inliningTarget__2 = (this);
                        PythonBufferAccessLibrary bufferLib__ = (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached(arg1Value_));
                        return ConstructStructNode.struct(arg0Value, arg1Value_, inliningTarget__2, bufferLib__);
                    }
                } finally {
                    encapsulating_.set(prev_);
                }
            }

            @Override
            public PStruct execute(Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[StructBuiltins.ConstructStructNode.struct(Object, TruffleString, Node, CopyToByteArrayNode, SwitchEncodingNode, GetCodeRangeNode)] || SpecializationActive[StructBuiltins.ConstructStructNode.struct(Object, PString, Node, CastToTruffleStringNode, CopyToByteArrayNode, SwitchEncodingNode, GetCodeRangeNode)] || SpecializationActive[StructBuiltins.ConstructStructNode.struct(Object, PBytes, Node, PythonBufferAccessLibrary)] || SpecializationActive[StructBuiltins.ConstructStructNode.struct(Object, PBytes, Node, PythonBufferAccessLibrary)] || SpecializationActive[StructBuiltins.ConstructStructNode.fallback(Object, Object, GetCodeRangeNode, Node)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[StructBuiltins.ConstructStructNode.struct(Object, TruffleString, Node, CopyToByteArrayNode, SwitchEncodingNode, GetCodeRangeNode)] */ && arg1Value instanceof TruffleString) {
                        TruffleString arg1Value_ = (TruffleString) arg1Value;
                        {
                            CopyToByteArrayNode copyToByteArrayNode_ = this.copyToByteArrayNode;
                            if (copyToByteArrayNode_ != null) {
                                SwitchEncodingNode switchEncodingNode_ = this.switchEncodingNode;
                                if (switchEncodingNode_ != null) {
                                    GetCodeRangeNode getCodeRangeNode_ = this.getCodeRangeNode;
                                    if (getCodeRangeNode_ != null) {
                                        if ((PythonUtils.isAscii(arg1Value_, getCodeRangeNode_))) {
                                            Node inliningTarget__ = (this);
                                            return ConstructStructNode.struct(arg0Value, arg1Value_, inliningTarget__, copyToByteArrayNode_, switchEncodingNode_, getCodeRangeNode_);
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[StructBuiltins.ConstructStructNode.struct(Object, PString, Node, CastToTruffleStringNode, CopyToByteArrayNode, SwitchEncodingNode, GetCodeRangeNode)] */ && arg1Value instanceof PString) {
                        PString arg1Value_ = (PString) arg1Value;
                        Struct1Data s1_ = this.struct1_cache;
                        if (s1_ != null) {
                            {
                                CopyToByteArrayNode copyToByteArrayNode_1 = this.copyToByteArrayNode;
                                if (copyToByteArrayNode_1 != null) {
                                    SwitchEncodingNode switchEncodingNode_1 = this.switchEncodingNode;
                                    if (switchEncodingNode_1 != null) {
                                        GetCodeRangeNode getCodeRangeNode_1 = this.getCodeRangeNode;
                                        if (getCodeRangeNode_1 != null) {
                                            Node inliningTarget__1 = (s1_);
                                            return ConstructStructNode.struct(arg0Value, arg1Value_, inliningTarget__1, INLINED_STRUCT1_CAST_TO_TRUFFLE_STRING_NODE_, copyToByteArrayNode_1, switchEncodingNode_1, getCodeRangeNode_1);
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b1100) != 0 /* is SpecializationActive[StructBuiltins.ConstructStructNode.struct(Object, PBytes, Node, PythonBufferAccessLibrary)] || SpecializationActive[StructBuiltins.ConstructStructNode.struct(Object, PBytes, Node, PythonBufferAccessLibrary)] */ && arg1Value instanceof PBytes) {
                        PBytes arg1Value_ = (PBytes) arg1Value;
                        if ((state_0 & 0b100) != 0 /* is SpecializationActive[StructBuiltins.ConstructStructNode.struct(Object, PBytes, Node, PythonBufferAccessLibrary)] */) {
                            Struct2Data s2_ = this.struct2_cache;
                            if (s2_ != null) {
                                if ((s2_.bufferLib_.accepts(arg1Value_))) {
                                    Node inliningTarget__2 = (this);
                                    return ConstructStructNode.struct(arg0Value, arg1Value_, inliningTarget__2, s2_.bufferLib_);
                                }
                            }
                        }
                        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[StructBuiltins.ConstructStructNode.struct(Object, PBytes, Node, PythonBufferAccessLibrary)] */) {
                            return this.struct3Boundary0(state_0, arg0Value, arg1Value_);
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[StructBuiltins.ConstructStructNode.fallback(Object, Object, GetCodeRangeNode, Node)] */) {
                        {
                            GetCodeRangeNode getCodeRangeNode_2 = this.getCodeRangeNode;
                            if (getCodeRangeNode_2 != null) {
                                if ((!(PGuards.isPBytes(arg1Value))) && (!(PGuards.isPString(arg1Value))) && (!(ConstructStructNode.isAsciiTruffleString(arg1Value, getCodeRangeNode_2)))) {
                                    Node inliningTarget__3 = (this);
                                    return ConstructStructNode.fallback(arg0Value, arg1Value, getCodeRangeNode_2, inliningTarget__3);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            @SuppressWarnings("static-method")
            @TruffleBoundary
            private PStruct struct3Boundary0(int state_0, Object arg0Value, PBytes arg1Value_) {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set(this);
                try {
                    {
                        Node inliningTarget__2 = (this);
                        PythonBufferAccessLibrary bufferLib__ = (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached(arg1Value_));
                        return ConstructStructNode.struct(arg0Value, arg1Value_, inliningTarget__2, bufferLib__);
                    }
                } finally {
                    encapsulating_.set(prev_);
                }
            }

            private PStruct executeAndSpecialize(Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                {
                    Node inliningTarget__ = null;
                    if (arg1Value instanceof TruffleString) {
                        TruffleString arg1Value_ = (TruffleString) arg1Value;
                        {
                            GetCodeRangeNode getCodeRangeNode_;
                            GetCodeRangeNode getCodeRangeNode__shared = this.getCodeRangeNode;
                            if (getCodeRangeNode__shared != null) {
                                getCodeRangeNode_ = getCodeRangeNode__shared;
                            } else {
                                getCodeRangeNode_ = this.insert((GetCodeRangeNode.create()));
                                if (getCodeRangeNode_ == null) {
                                    throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                }
                            }
                            if ((PythonUtils.isAscii(arg1Value_, getCodeRangeNode_))) {
                                inliningTarget__ = (this);
                                CopyToByteArrayNode copyToByteArrayNode_;
                                CopyToByteArrayNode copyToByteArrayNode__shared = this.copyToByteArrayNode;
                                if (copyToByteArrayNode__shared != null) {
                                    copyToByteArrayNode_ = copyToByteArrayNode__shared;
                                } else {
                                    copyToByteArrayNode_ = this.insert((CopyToByteArrayNode.create()));
                                    if (copyToByteArrayNode_ == null) {
                                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                    }
                                }
                                if (this.copyToByteArrayNode == null) {
                                    VarHandle.storeStoreFence();
                                    this.copyToByteArrayNode = copyToByteArrayNode_;
                                }
                                SwitchEncodingNode switchEncodingNode_;
                                SwitchEncodingNode switchEncodingNode__shared = this.switchEncodingNode;
                                if (switchEncodingNode__shared != null) {
                                    switchEncodingNode_ = switchEncodingNode__shared;
                                } else {
                                    switchEncodingNode_ = this.insert((SwitchEncodingNode.create()));
                                    if (switchEncodingNode_ == null) {
                                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                    }
                                }
                                if (this.switchEncodingNode == null) {
                                    VarHandle.storeStoreFence();
                                    this.switchEncodingNode = switchEncodingNode_;
                                }
                                if (this.getCodeRangeNode == null) {
                                    VarHandle.storeStoreFence();
                                    this.getCodeRangeNode = getCodeRangeNode_;
                                }
                                state_0 = state_0 | 0b1 /* add SpecializationActive[StructBuiltins.ConstructStructNode.struct(Object, TruffleString, Node, CopyToByteArrayNode, SwitchEncodingNode, GetCodeRangeNode)] */;
                                this.state_0_ = state_0;
                                return ConstructStructNode.struct(arg0Value, arg1Value_, inliningTarget__, copyToByteArrayNode_, switchEncodingNode_, getCodeRangeNode_);
                            }
                        }
                    }
                }
                {
                    Node inliningTarget__1 = null;
                    if (arg1Value instanceof PString) {
                        PString arg1Value_ = (PString) arg1Value;
                        Struct1Data s1_ = this.insert(new Struct1Data());
                        inliningTarget__1 = (s1_);
                        CopyToByteArrayNode copyToByteArrayNode_1;
                        CopyToByteArrayNode copyToByteArrayNode_1_shared = this.copyToByteArrayNode;
                        if (copyToByteArrayNode_1_shared != null) {
                            copyToByteArrayNode_1 = copyToByteArrayNode_1_shared;
                        } else {
                            copyToByteArrayNode_1 = s1_.insert((CopyToByteArrayNode.create()));
                            if (copyToByteArrayNode_1 == null) {
                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.copyToByteArrayNode == null) {
                            this.copyToByteArrayNode = copyToByteArrayNode_1;
                        }
                        SwitchEncodingNode switchEncodingNode_1;
                        SwitchEncodingNode switchEncodingNode_1_shared = this.switchEncodingNode;
                        if (switchEncodingNode_1_shared != null) {
                            switchEncodingNode_1 = switchEncodingNode_1_shared;
                        } else {
                            switchEncodingNode_1 = s1_.insert((SwitchEncodingNode.create()));
                            if (switchEncodingNode_1 == null) {
                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.switchEncodingNode == null) {
                            this.switchEncodingNode = switchEncodingNode_1;
                        }
                        GetCodeRangeNode getCodeRangeNode_1;
                        GetCodeRangeNode getCodeRangeNode_1_shared = this.getCodeRangeNode;
                        if (getCodeRangeNode_1_shared != null) {
                            getCodeRangeNode_1 = getCodeRangeNode_1_shared;
                        } else {
                            getCodeRangeNode_1 = s1_.insert((GetCodeRangeNode.create()));
                            if (getCodeRangeNode_1 == null) {
                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.getCodeRangeNode == null) {
                            this.getCodeRangeNode = getCodeRangeNode_1;
                        }
                        VarHandle.storeStoreFence();
                        this.struct1_cache = s1_;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[StructBuiltins.ConstructStructNode.struct(Object, PString, Node, CastToTruffleStringNode, CopyToByteArrayNode, SwitchEncodingNode, GetCodeRangeNode)] */;
                        this.state_0_ = state_0;
                        return ConstructStructNode.struct(arg0Value, arg1Value_, inliningTarget__1, INLINED_STRUCT1_CAST_TO_TRUFFLE_STRING_NODE_, copyToByteArrayNode_1, switchEncodingNode_1, getCodeRangeNode_1);
                    }
                }
                if (arg1Value instanceof PBytes) {
                    PBytes arg1Value_ = (PBytes) arg1Value;
                    {
                        Node inliningTarget__2 = null;
                        if (((state_0 & 0b1000)) == 0 /* is-not SpecializationActive[StructBuiltins.ConstructStructNode.struct(Object, PBytes, Node, PythonBufferAccessLibrary)] */) {
                            while (true) {
                                int count2_ = 0;
                                Struct2Data s2_ = STRUCT2_CACHE_UPDATER.getVolatile(this);
                                Struct2Data s2_original = s2_;
                                while (s2_ != null) {
                                    if ((s2_.bufferLib_.accepts(arg1Value_))) {
                                        inliningTarget__2 = (this);
                                        break;
                                    }
                                    count2_++;
                                    s2_ = null;
                                    break;
                                }
                                if (s2_ == null && count2_ < 1) {
                                    // assert (s2_.bufferLib_.accepts(arg1Value_));
                                    s2_ = this.insert(new Struct2Data());
                                    inliningTarget__2 = (this);
                                    PythonBufferAccessLibrary bufferLib__ = s2_.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.create(arg1Value_)));
                                    Objects.requireNonNull(bufferLib__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                    s2_.bufferLib_ = bufferLib__;
                                    if (!STRUCT2_CACHE_UPDATER.compareAndSet(this, s2_original, s2_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b100 /* add SpecializationActive[StructBuiltins.ConstructStructNode.struct(Object, PBytes, Node, PythonBufferAccessLibrary)] */;
                                    this.state_0_ = state_0;
                                }
                                if (s2_ != null) {
                                    return ConstructStructNode.struct(arg0Value, arg1Value_, inliningTarget__2, s2_.bufferLib_);
                                }
                                break;
                            }
                        }
                    }
                    {
                        PythonBufferAccessLibrary bufferLib__ = null;
                        Node inliningTarget__2 = null;
                        {
                            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            Node prev_ = encapsulating_.set(this);
                            try {
                                inliningTarget__2 = (this);
                                bufferLib__ = (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached(arg1Value_));
                                this.struct2_cache = null;
                                state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[StructBuiltins.ConstructStructNode.struct(Object, PBytes, Node, PythonBufferAccessLibrary)] */;
                                state_0 = state_0 | 0b1000 /* add SpecializationActive[StructBuiltins.ConstructStructNode.struct(Object, PBytes, Node, PythonBufferAccessLibrary)] */;
                                this.state_0_ = state_0;
                                return ConstructStructNode.struct(arg0Value, arg1Value_, inliningTarget__2, bufferLib__);
                            } finally {
                                encapsulating_.set(prev_);
                            }
                        }
                    }
                }
                {
                    Node inliningTarget__3 = null;
                    if ((!(PGuards.isPBytes(arg1Value))) && (!(PGuards.isPString(arg1Value)))) {
                        GetCodeRangeNode getCodeRangeNode_2;
                        GetCodeRangeNode getCodeRangeNode_2_shared = this.getCodeRangeNode;
                        if (getCodeRangeNode_2_shared != null) {
                            getCodeRangeNode_2 = getCodeRangeNode_2_shared;
                        } else {
                            getCodeRangeNode_2 = this.insert((GetCodeRangeNode.create()));
                            if (getCodeRangeNode_2 == null) {
                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if ((!(ConstructStructNode.isAsciiTruffleString(arg1Value, getCodeRangeNode_2)))) {
                            if (this.getCodeRangeNode == null) {
                                VarHandle.storeStoreFence();
                                this.getCodeRangeNode = getCodeRangeNode_2;
                            }
                            inliningTarget__3 = (this);
                            state_0 = state_0 | 0b10000 /* add SpecializationActive[StructBuiltins.ConstructStructNode.fallback(Object, Object, GetCodeRangeNode, Node)] */;
                            this.state_0_ = state_0;
                            return ConstructStructNode.fallback(arg0Value, arg1Value, getCodeRangeNode_2, inliningTarget__3);
                        }
                    }
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value);
            }

            @GeneratedBy(ConstructStructNode.class)
            @DenyReplace
            private static final class Struct1Data extends Node implements SpecializationDataNode {

                /**
                 * State Info: <pre>
                 *   0-7: InlinedCache
                 *        Specialization: {@link ConstructStructNode#struct(Object, PString, Node, CastToTruffleStringNode, CopyToByteArrayNode, SwitchEncodingNode, GetCodeRangeNode)}
                 *        Parameter: {@link CastToTruffleStringNode} castToTruffleStringNode
                 *        Inline method: {@link CastToTruffleStringNodeGen#inline}
                 * </pre> */
                @CompilationFinal @UnsafeAccessedField private int struct1_state_0_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link ConstructStructNode#struct(Object, PString, Node, CastToTruffleStringNode, CopyToByteArrayNode, SwitchEncodingNode, GetCodeRangeNode)}
                 *   Parameter: {@link CastToTruffleStringNode} castToTruffleStringNode
                 *   Inline method: {@link CastToTruffleStringNodeGen#inline}
                 *   Inline field: {@link Node} field1</pre> */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node struct1_castToTruffleStringNode__field1_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link ConstructStructNode#struct(Object, PString, Node, CastToTruffleStringNode, CopyToByteArrayNode, SwitchEncodingNode, GetCodeRangeNode)}
                 *   Parameter: {@link CastToTruffleStringNode} castToTruffleStringNode
                 *   Inline method: {@link CastToTruffleStringNodeGen#inline}
                 *   Inline field: {@link Node} field2</pre> */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node struct1_castToTruffleStringNode__field2_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link ConstructStructNode#struct(Object, PString, Node, CastToTruffleStringNode, CopyToByteArrayNode, SwitchEncodingNode, GetCodeRangeNode)}
                 *   Parameter: {@link CastToTruffleStringNode} castToTruffleStringNode
                 *   Inline method: {@link CastToTruffleStringNodeGen#inline}
                 *   Inline field: {@link Node} field3</pre> */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node struct1_castToTruffleStringNode__field3_;

                Struct1Data() {
                }

                private static Lookup lookup_() {
                    return MethodHandles.lookup();
                }

            }
            @GeneratedBy(ConstructStructNode.class)
            @DenyReplace
            private static final class Struct2Data extends Node implements SpecializationDataNode {

                /**
                 * Source Info: <pre>
                 *   Specialization: {@link ConstructStructNode#struct(Object, PBytes, Node, PythonBufferAccessLibrary)}
                 *   Parameter: {@link PythonBufferAccessLibrary} bufferLib</pre> */
                @Child PythonBufferAccessLibrary bufferLib_;

                Struct2Data() {
                }

            }
        }
    }
    @GeneratedBy(StructPackNode.class)
    public static final class StructPackNodeFactory implements NodeFactory<StructPackNode> {

        private static final StructPackNodeFactory STRUCT_PACK_NODE_FACTORY_INSTANCE = new StructPackNodeFactory();

        private StructPackNodeFactory() {
        }

        @Override
        public Class<StructPackNode> getNodeClass() {
            return StructPackNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public StructPackNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<StructPackNode> getInstance() {
            return STRUCT_PACK_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static StructPackNode create() {
            return new StructPackNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link StructPackNode#pack}
         *     Activation probability: 1.00000
         *     With/without class size: 28/5 bytes
         * </pre> */
        @GeneratedBy(StructPackNode.class)
        @SuppressWarnings("javadoc")
        public static final class StructPackNodeGen extends StructPackNode {

            private static final StateField STATE_0_StructPackNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link StructPackNode#pack}
             *   Parameter: {@link PRaiseNode} raiseNode
             *   Inline method: {@link PRaiseNodeGen#inline}</pre> */
            private static final PRaiseNode INLINED_RAISE_NODE_ = PRaiseNodeGen.inline(InlineTarget.create(PRaiseNode.class, STATE_0_StructPackNode_UPDATER.subUpdater(1, 1)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link StructPackNode#pack}
             *   1: InlinedCache
             *        Specialization: {@link StructPackNode#pack}
             *        Parameter: {@link PRaiseNode} raiseNode
             *        Inline method: {@link PRaiseNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link StructPackNode#pack}
             *   Parameter: {@link PackValueNode} packValueNode</pre> */
            @Child private PackValueNode packValueNode_;

            private StructPackNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object[] arg1Value, PKeyword[] arg2Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[StructBuiltins.StructPackNode.pack(VirtualFrame, PStruct, Object[], PKeyword[], Node, PythonLanguage, PackValueNode, PRaiseNode)] */ && arg0Value instanceof PStruct) {
                    PStruct arg0Value_ = (PStruct) arg0Value;
                    {
                        PackValueNode packValueNode__ = this.packValueNode_;
                        if (packValueNode__ != null) {
                            Node inliningTarget__ = (this);
                            PythonLanguage language__ = (PythonLanguage.get(this));
                            return StructPackNode.pack(frameValue, arg0Value_, arg1Value, arg2Value, inliningTarget__, language__, packValueNode__, INLINED_RAISE_NODE_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value, arg2Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object[] arg1Value, PKeyword[] arg2Value) {
                int state_0 = this.state_0_;
                {
                    PythonLanguage language__ = null;
                    Node inliningTarget__ = null;
                    if (arg0Value instanceof PStruct) {
                        PStruct arg0Value_ = (PStruct) arg0Value;
                        inliningTarget__ = (this);
                        language__ = (PythonLanguage.get(this));
                        PackValueNode packValueNode__ = this.insert((PackValueNodeGen.create()));
                        Objects.requireNonNull(packValueNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.packValueNode_ = packValueNode__;
                        state_0 = state_0 | 0b1 /* add SpecializationActive[StructBuiltins.StructPackNode.pack(VirtualFrame, PStruct, Object[], PKeyword[], Node, PythonLanguage, PackValueNode, PRaiseNode)] */;
                        this.state_0_ = state_0;
                        return StructPackNode.pack(frameValue, arg0Value_, arg1Value, arg2Value, inliningTarget__, language__, packValueNode__, INLINED_RAISE_NODE_);
                    }
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value, arg2Value);
            }

        }
    }
    @GeneratedBy(StructPackIntoNode.class)
    public static final class StructPackIntoNodeFactory implements NodeFactory<StructPackIntoNode> {

        private static final StructPackIntoNodeFactory STRUCT_PACK_INTO_NODE_FACTORY_INSTANCE = new StructPackIntoNodeFactory();

        private StructPackIntoNodeFactory() {
        }

        @Override
        public Class<StructPackIntoNode> getNodeClass() {
            return StructPackIntoNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(ReadArgumentNode.class, ReadArgumentNode.class, ReadArgumentNode.class, ReadArgumentNode.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(ReadArgumentNode[].class));
        }

        @Override
        public StructPackIntoNode createNode(Object... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return create((ReadArgumentNode[]) arguments[0]);
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<StructPackIntoNode> getInstance() {
            return STRUCT_PACK_INTO_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static StructPackIntoNode create(ReadArgumentNode[] arguments) {
            return new StructPackIntoNodeGen(arguments);
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link StructPackIntoNode#packInto}
         *     Activation probability: 0.65000
         *     With/without class size: 27/13 bytes
         *   Specialization {@link StructPackIntoNode#packInto}
         *     Activation probability: 0.35000
         *     With/without class size: 13/9 bytes
         * </pre> */
        @GeneratedBy(StructPackIntoNode.class)
        @SuppressWarnings("javadoc")
        public static final class StructPackIntoNodeGen extends StructPackIntoNode {

            private static final StateField PACK_INTO0_STRUCT_PACK_INTO_NODE_PACK_INTO0_STATE_0_UPDATER = StateField.create(PackInto0Data.lookup_(), "packInto0_state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link StructPackIntoNode#packInto}
             *   Parameter: {@link PRaiseNode} raiseNode
             *   Inline method: {@link PRaiseNodeGen#inline}</pre> */
            private static final PRaiseNode INLINED_PACK_INTO0_RAISE_NODE_ = PRaiseNodeGen.inline(InlineTarget.create(PRaiseNode.class, PACK_INTO0_STRUCT_PACK_INTO_NODE_PACK_INTO0_STATE_0_UPDATER.subUpdater(0, 1)));
            private static final StateField STATE_0_StructPackIntoNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link StructPackIntoNode#packInto}
             *   Parameter: {@link PRaiseNode} raiseNode
             *   Inline method: {@link PRaiseNodeGen#inline}</pre> */
            private static final PRaiseNode INLINED_PACK_INTO1_RAISE_NODE_ = PRaiseNodeGen.inline(InlineTarget.create(PRaiseNode.class, STATE_0_StructPackIntoNode_UPDATER.subUpdater(2, 1)));
            static final ReferenceField<PackInto0Data> PACK_INTO0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "packInto0_cache", PackInto0Data.class);

            @Child private ReadArgumentNode arguments0_;
            @Child private ReadArgumentNode arguments1_;
            @Child private ReadArgumentNode arguments2_;
            @Child private ReadArgumentNode arguments3_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link StructPackIntoNode#packInto}
             *   1: SpecializationActive {@link StructPackIntoNode#packInto}
             *   2: InlinedCache
             *        Specialization: {@link StructPackIntoNode#packInto}
             *        Parameter: {@link PRaiseNode} raiseNode
             *        Inline method: {@link PRaiseNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            @UnsafeAccessedField @Child private PackInto0Data packInto0_cache;
            /**
             * Source Info: <pre>
             *   Specialization: {@link StructPackIntoNode#packInto}
             *   Parameter: {@link IndirectCallData} indirectCallData</pre> */
            @CompilationFinal private IndirectCallData packInto1_indirectCallData_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link StructPackIntoNode#packInto}
             *   Parameter: {@link PackValueNode} packValueNode</pre> */
            @Child private PackValueNode packInto1_packValueNode_;

            private StructPackIntoNodeGen(ReadArgumentNode[] arguments) {
                ReadArgumentNode[] arguments_ = arguments != null ? createCasts(arguments) : null;
                this.arguments0_ = arguments_ != null && 0 < arguments_.length ? arguments_[0] : null;
                this.arguments1_ = arguments_ != null && 1 < arguments_.length ? arguments_[1] : null;
                this.arguments2_ = arguments_ != null && 2 < arguments_.length ? arguments_[2] : null;
                this.arguments3_ = arguments_ != null && 3 < arguments_.length ? arguments_[3] : null;
            }

            @ExplodeLoop
            @Override
            public Object execute(VirtualFrame frameValue, PStruct arguments0Value, Object arguments1Value, int arguments2Value, Object[] arguments3Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[StructBuiltins.StructPackIntoNode.packInto(VirtualFrame, PStruct, Object, int, Object[], Node, IndirectCallData, PythonBufferAccessLibrary, PackValueNode, PRaiseNode)] || SpecializationActive[StructBuiltins.StructPackIntoNode.packInto(VirtualFrame, PStruct, Object, int, Object[], Node, IndirectCallData, PythonBufferAccessLibrary, PackValueNode, PRaiseNode)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[StructBuiltins.StructPackIntoNode.packInto(VirtualFrame, PStruct, Object, int, Object[], Node, IndirectCallData, PythonBufferAccessLibrary, PackValueNode, PRaiseNode)] */) {
                        PackInto0Data s0_ = this.packInto0_cache;
                        while (s0_ != null) {
                            if ((s0_.bufferLib_.accepts(arguments1Value))) {
                                Node inliningTarget__ = (s0_);
                                return StructPackIntoNode.packInto(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, inliningTarget__, s0_.indirectCallData_, s0_.bufferLib_, s0_.packValueNode_, INLINED_PACK_INTO0_RAISE_NODE_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[StructBuiltins.StructPackIntoNode.packInto(VirtualFrame, PStruct, Object, int, Object[], Node, IndirectCallData, PythonBufferAccessLibrary, PackValueNode, PRaiseNode)] */) {
                        {
                            IndirectCallData indirectCallData__ = this.packInto1_indirectCallData_;
                            if (indirectCallData__ != null) {
                                PackValueNode packValueNode__ = this.packInto1_packValueNode_;
                                if (packValueNode__ != null) {
                                    return this.packInto1Boundary(state_0, frameValue.materialize(), arguments0Value, arguments1Value, arguments2Value, arguments3Value, indirectCallData__, packValueNode__);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @SuppressWarnings("static-method")
            @TruffleBoundary
            private Object packInto1Boundary(int state_0, MaterializedFrame frameValue, PStruct arguments0Value, Object arguments1Value, int arguments2Value, Object[] arguments3Value, IndirectCallData indirectCallData__, PackValueNode packValueNode__) {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set(this);
                try {
                    {
                        Node inliningTarget__ = (this);
                        PythonBufferAccessLibrary bufferLib__ = (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached());
                        return StructPackIntoNode.packInto(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, inliningTarget__, indirectCallData__, bufferLib__, packValueNode__, INLINED_PACK_INTO1_RAISE_NODE_);
                    }
                } finally {
                    encapsulating_.set(prev_);
                }
            }

            @ExplodeLoop
            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                Object arguments2Value_ = this.arguments2_.execute(frameValue);
                Object arguments3Value_ = this.arguments3_.execute(frameValue);
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[StructBuiltins.StructPackIntoNode.packInto(VirtualFrame, PStruct, Object, int, Object[], Node, IndirectCallData, PythonBufferAccessLibrary, PackValueNode, PRaiseNode)] || SpecializationActive[StructBuiltins.StructPackIntoNode.packInto(VirtualFrame, PStruct, Object, int, Object[], Node, IndirectCallData, PythonBufferAccessLibrary, PackValueNode, PRaiseNode)] */ && arguments0Value_ instanceof PStruct) {
                    PStruct arguments0Value__ = (PStruct) arguments0Value_;
                    if (arguments2Value_ instanceof Integer) {
                        int arguments2Value__ = (int) arguments2Value_;
                        if (arguments3Value_ instanceof Object[]) {
                            Object[] arguments3Value__ = (Object[]) arguments3Value_;
                            if ((state_0 & 0b1) != 0 /* is SpecializationActive[StructBuiltins.StructPackIntoNode.packInto(VirtualFrame, PStruct, Object, int, Object[], Node, IndirectCallData, PythonBufferAccessLibrary, PackValueNode, PRaiseNode)] */) {
                                PackInto0Data s0_ = this.packInto0_cache;
                                while (s0_ != null) {
                                    if ((s0_.bufferLib_.accepts(arguments1Value_))) {
                                        Node inliningTarget__ = (s0_);
                                        return StructPackIntoNode.packInto(frameValue, arguments0Value__, arguments1Value_, arguments2Value__, arguments3Value__, inliningTarget__, s0_.indirectCallData_, s0_.bufferLib_, s0_.packValueNode_, INLINED_PACK_INTO0_RAISE_NODE_);
                                    }
                                    s0_ = s0_.next_;
                                }
                            }
                            if ((state_0 & 0b10) != 0 /* is SpecializationActive[StructBuiltins.StructPackIntoNode.packInto(VirtualFrame, PStruct, Object, int, Object[], Node, IndirectCallData, PythonBufferAccessLibrary, PackValueNode, PRaiseNode)] */) {
                                {
                                    IndirectCallData indirectCallData__ = this.packInto1_indirectCallData_;
                                    if (indirectCallData__ != null) {
                                        PackValueNode packValueNode__ = this.packInto1_packValueNode_;
                                        if (packValueNode__ != null) {
                                            return this.packInto1Boundary0(state_0, frameValue.materialize(), arguments0Value__, arguments1Value_, arguments2Value__, arguments3Value__, indirectCallData__, packValueNode__);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
            }

            @SuppressWarnings("static-method")
            @TruffleBoundary
            private Object packInto1Boundary0(int state_0, MaterializedFrame frameValue, PStruct arguments0Value__, Object arguments1Value_, int arguments2Value__, Object[] arguments3Value__, IndirectCallData indirectCallData__, PackValueNode packValueNode__) {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set(this);
                try {
                    {
                        Node inliningTarget__ = (this);
                        PythonBufferAccessLibrary bufferLib__ = (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached());
                        return StructPackIntoNode.packInto(frameValue, arguments0Value__, arguments1Value_, arguments2Value__, arguments3Value__, inliningTarget__, indirectCallData__, bufferLib__, packValueNode__, INLINED_PACK_INTO1_RAISE_NODE_);
                    }
                } finally {
                    encapsulating_.set(prev_);
                }
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                int state_0 = this.state_0_;
                if (arguments0Value instanceof PStruct) {
                    PStruct arguments0Value_ = (PStruct) arguments0Value;
                    if (arguments2Value instanceof Integer) {
                        int arguments2Value_ = (int) arguments2Value;
                        if (arguments3Value instanceof Object[]) {
                            Object[] arguments3Value_ = (Object[]) arguments3Value;
                            {
                                Node inliningTarget__ = null;
                                if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[StructBuiltins.StructPackIntoNode.packInto(VirtualFrame, PStruct, Object, int, Object[], Node, IndirectCallData, PythonBufferAccessLibrary, PackValueNode, PRaiseNode)] */) {
                                    while (true) {
                                        int count0_ = 0;
                                        PackInto0Data s0_ = PACK_INTO0_CACHE_UPDATER.getVolatile(this);
                                        PackInto0Data s0_original = s0_;
                                        while (s0_ != null) {
                                            if ((s0_.bufferLib_.accepts(arguments1Value))) {
                                                inliningTarget__ = (s0_);
                                                break;
                                            }
                                            count0_++;
                                            s0_ = s0_.next_;
                                        }
                                        if (s0_ == null) {
                                            // assert (s0_.bufferLib_.accepts(arguments1Value));
                                            if (count0_ < (3)) {
                                                s0_ = this.insert(new PackInto0Data(s0_original));
                                                inliningTarget__ = (s0_);
                                                IndirectCallData indirectCallData__ = (IndirectCallData.createFor(s0_));
                                                Objects.requireNonNull(indirectCallData__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                                s0_.indirectCallData_ = indirectCallData__;
                                                PythonBufferAccessLibrary bufferLib__ = s0_.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.create(arguments1Value)));
                                                Objects.requireNonNull(bufferLib__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                                s0_.bufferLib_ = bufferLib__;
                                                PackValueNode packValueNode__ = s0_.insert((PackValueNodeGen.create()));
                                                Objects.requireNonNull(packValueNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                                s0_.packValueNode_ = packValueNode__;
                                                if (!PACK_INTO0_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                                    continue;
                                                }
                                                state_0 = state_0 | 0b1 /* add SpecializationActive[StructBuiltins.StructPackIntoNode.packInto(VirtualFrame, PStruct, Object, int, Object[], Node, IndirectCallData, PythonBufferAccessLibrary, PackValueNode, PRaiseNode)] */;
                                                this.state_0_ = state_0;
                                            }
                                        }
                                        if (s0_ != null) {
                                            return StructPackIntoNode.packInto(frameValue, arguments0Value_, arguments1Value, arguments2Value_, arguments3Value_, inliningTarget__, s0_.indirectCallData_, s0_.bufferLib_, s0_.packValueNode_, INLINED_PACK_INTO0_RAISE_NODE_);
                                        }
                                        break;
                                    }
                                }
                            }
                            {
                                PythonBufferAccessLibrary bufferLib__ = null;
                                Node inliningTarget__ = null;
                                {
                                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                                    Node prev_ = encapsulating_.set(this);
                                    try {
                                        inliningTarget__ = (this);
                                        IndirectCallData indirectCallData__ = (IndirectCallData.createFor(this));
                                        Objects.requireNonNull(indirectCallData__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                        VarHandle.storeStoreFence();
                                        this.packInto1_indirectCallData_ = indirectCallData__;
                                        bufferLib__ = (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached());
                                        PackValueNode packValueNode__ = this.insert((PackValueNodeGen.create()));
                                        Objects.requireNonNull(packValueNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                        VarHandle.storeStoreFence();
                                        this.packInto1_packValueNode_ = packValueNode__;
                                        this.packInto0_cache = null;
                                        state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[StructBuiltins.StructPackIntoNode.packInto(VirtualFrame, PStruct, Object, int, Object[], Node, IndirectCallData, PythonBufferAccessLibrary, PackValueNode, PRaiseNode)] */;
                                        state_0 = state_0 | 0b10 /* add SpecializationActive[StructBuiltins.StructPackIntoNode.packInto(VirtualFrame, PStruct, Object, int, Object[], Node, IndirectCallData, PythonBufferAccessLibrary, PackValueNode, PRaiseNode)] */;
                                        this.state_0_ = state_0;
                                        return StructPackIntoNode.packInto(frameValue, arguments0Value_, arguments1Value, arguments2Value_, arguments3Value_, inliningTarget__, indirectCallData__, bufferLib__, packValueNode__, INLINED_PACK_INTO1_RAISE_NODE_);
                                    } finally {
                                        encapsulating_.set(prev_);
                                    }
                                }
                            }
                        }
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {this.arguments0_, this.arguments1_, this.arguments2_, this.arguments3_}, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @GeneratedBy(StructPackIntoNode.class)
            @DenyReplace
            private static final class PackInto0Data extends Node implements SpecializationDataNode {

                @Child PackInto0Data next_;
                /**
                 * State Info: <pre>
                 *   0: InlinedCache
                 *        Specialization: {@link StructPackIntoNode#packInto}
                 *        Parameter: {@link PRaiseNode} raiseNode
                 *        Inline method: {@link PRaiseNodeGen#inline}
                 * </pre> */
                @CompilationFinal @UnsafeAccessedField private int packInto0_state_0_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link StructPackIntoNode#packInto}
                 *   Parameter: {@link IndirectCallData} indirectCallData</pre> */
                @CompilationFinal IndirectCallData indirectCallData_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link StructPackIntoNode#packInto}
                 *   Parameter: {@link PythonBufferAccessLibrary} bufferLib</pre> */
                @Child PythonBufferAccessLibrary bufferLib_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link StructPackIntoNode#packInto}
                 *   Parameter: {@link PackValueNode} packValueNode</pre> */
                @Child PackValueNode packValueNode_;

                PackInto0Data(PackInto0Data next_) {
                    this.next_ = next_;
                }

                private static Lookup lookup_() {
                    return MethodHandles.lookup();
                }

            }
        }
    }
    @GeneratedBy(StructUnpackNode.class)
    public static final class StructUnpackNodeFactory implements NodeFactory<StructUnpackNode> {

        private static final StructUnpackNodeFactory STRUCT_UNPACK_NODE_FACTORY_INSTANCE = new StructUnpackNodeFactory();

        private StructUnpackNodeFactory() {
        }

        @Override
        public Class<StructUnpackNode> getNodeClass() {
            return StructUnpackNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public StructUnpackNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<StructUnpackNode> getInstance() {
            return STRUCT_UNPACK_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static StructUnpackNode create() {
            return new StructUnpackNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link StructUnpackNode#unpack}
         *     Activation probability: 0.65000
         *     With/without class size: 27/13 bytes
         *   Specialization {@link StructUnpackNode#unpack}
         *     Activation probability: 0.35000
         *     With/without class size: 13/9 bytes
         * </pre> */
        @GeneratedBy(StructUnpackNode.class)
        @SuppressWarnings("javadoc")
        public static final class StructUnpackNodeGen extends StructUnpackNode {

            private static final StateField UNPACK0_STRUCT_UNPACK_NODE_UNPACK0_STATE_0_UPDATER = StateField.create(Unpack0Data.lookup_(), "unpack0_state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link StructUnpackNode#unpack}
             *   Parameter: {@link PRaiseNode} raiseNode
             *   Inline method: {@link PRaiseNodeGen#inline}</pre> */
            private static final PRaiseNode INLINED_UNPACK0_RAISE_NODE_ = PRaiseNodeGen.inline(InlineTarget.create(PRaiseNode.class, UNPACK0_STRUCT_UNPACK_NODE_UNPACK0_STATE_0_UPDATER.subUpdater(0, 1)));
            private static final StateField STATE_0_StructUnpackNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link StructUnpackNode#unpack}
             *   Parameter: {@link PRaiseNode} raiseNode
             *   Inline method: {@link PRaiseNodeGen#inline}</pre> */
            private static final PRaiseNode INLINED_UNPACK1_RAISE_NODE_ = PRaiseNodeGen.inline(InlineTarget.create(PRaiseNode.class, STATE_0_StructUnpackNode_UPDATER.subUpdater(2, 1)));
            static final ReferenceField<Unpack0Data> UNPACK0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "unpack0_cache", Unpack0Data.class);

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link StructUnpackNode#unpack}
             *   1: SpecializationActive {@link StructUnpackNode#unpack}
             *   2: InlinedCache
             *        Specialization: {@link StructUnpackNode#unpack}
             *        Parameter: {@link PRaiseNode} raiseNode
             *        Inline method: {@link PRaiseNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            @UnsafeAccessedField @Child private Unpack0Data unpack0_cache;
            /**
             * Source Info: <pre>
             *   Specialization: {@link StructUnpackNode#unpack}
             *   Parameter: {@link IndirectCallData} indirectCallData</pre> */
            @CompilationFinal private IndirectCallData unpack1_indirectCallData_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link StructUnpackNode#unpack}
             *   Parameter: {@link UnpackValueNode} unpackValueNode</pre> */
            @Child private UnpackValueNode unpack1_unpackValueNode_;

            private StructUnpackNodeGen() {
            }

            @ExplodeLoop
            @Override
            protected Object executeWithoutClinic(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[StructBuiltins.StructUnpackNode.unpack(VirtualFrame, PStruct, Object, Node, PythonLanguage, IndirectCallData, PythonBufferAccessLibrary, UnpackValueNode, PRaiseNode)] || SpecializationActive[StructBuiltins.StructUnpackNode.unpack(VirtualFrame, PStruct, Object, Node, PythonLanguage, IndirectCallData, PythonBufferAccessLibrary, UnpackValueNode, PRaiseNode)] */ && arg0Value instanceof PStruct) {
                    PStruct arg0Value_ = (PStruct) arg0Value;
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[StructBuiltins.StructUnpackNode.unpack(VirtualFrame, PStruct, Object, Node, PythonLanguage, IndirectCallData, PythonBufferAccessLibrary, UnpackValueNode, PRaiseNode)] */) {
                        Unpack0Data s0_ = this.unpack0_cache;
                        while (s0_ != null) {
                            if ((s0_.bufferLib_.accepts(arg1Value))) {
                                Node inliningTarget__ = (s0_);
                                PythonLanguage language__ = (PythonLanguage.get(s0_));
                                return StructUnpackNode.unpack(frameValue, arg0Value_, arg1Value, inliningTarget__, language__, s0_.indirectCallData_, s0_.bufferLib_, s0_.unpackValueNode_, INLINED_UNPACK0_RAISE_NODE_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[StructBuiltins.StructUnpackNode.unpack(VirtualFrame, PStruct, Object, Node, PythonLanguage, IndirectCallData, PythonBufferAccessLibrary, UnpackValueNode, PRaiseNode)] */) {
                        {
                            IndirectCallData indirectCallData__ = this.unpack1_indirectCallData_;
                            if (indirectCallData__ != null) {
                                UnpackValueNode unpackValueNode__ = this.unpack1_unpackValueNode_;
                                if (unpackValueNode__ != null) {
                                    return this.unpack1Boundary(state_0, frameValue.materialize(), arg0Value_, arg1Value, indirectCallData__, unpackValueNode__);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            @SuppressWarnings("static-method")
            @TruffleBoundary
            private Object unpack1Boundary(int state_0, MaterializedFrame frameValue, PStruct arg0Value_, Object arg1Value, IndirectCallData indirectCallData__, UnpackValueNode unpackValueNode__) {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set(this);
                try {
                    {
                        Node inliningTarget__ = (this);
                        PythonLanguage language__ = (PythonLanguage.get(this));
                        PythonBufferAccessLibrary bufferLib__ = (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached());
                        return StructUnpackNode.unpack(frameValue, arg0Value_, arg1Value, inliningTarget__, language__, indirectCallData__, bufferLib__, unpackValueNode__, INLINED_UNPACK1_RAISE_NODE_);
                    }
                } finally {
                    encapsulating_.set(prev_);
                }
            }

            @ExplodeLoop
            @Override
            public Object execute(VirtualFrame frameValue, PStruct arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[StructBuiltins.StructUnpackNode.unpack(VirtualFrame, PStruct, Object, Node, PythonLanguage, IndirectCallData, PythonBufferAccessLibrary, UnpackValueNode, PRaiseNode)] || SpecializationActive[StructBuiltins.StructUnpackNode.unpack(VirtualFrame, PStruct, Object, Node, PythonLanguage, IndirectCallData, PythonBufferAccessLibrary, UnpackValueNode, PRaiseNode)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[StructBuiltins.StructUnpackNode.unpack(VirtualFrame, PStruct, Object, Node, PythonLanguage, IndirectCallData, PythonBufferAccessLibrary, UnpackValueNode, PRaiseNode)] */) {
                        Unpack0Data s0_ = this.unpack0_cache;
                        while (s0_ != null) {
                            if ((s0_.bufferLib_.accepts(arg1Value))) {
                                Node inliningTarget__ = (s0_);
                                PythonLanguage language__ = (PythonLanguage.get(s0_));
                                return StructUnpackNode.unpack(frameValue, arg0Value, arg1Value, inliningTarget__, language__, s0_.indirectCallData_, s0_.bufferLib_, s0_.unpackValueNode_, INLINED_UNPACK0_RAISE_NODE_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[StructBuiltins.StructUnpackNode.unpack(VirtualFrame, PStruct, Object, Node, PythonLanguage, IndirectCallData, PythonBufferAccessLibrary, UnpackValueNode, PRaiseNode)] */) {
                        {
                            IndirectCallData indirectCallData__ = this.unpack1_indirectCallData_;
                            if (indirectCallData__ != null) {
                                UnpackValueNode unpackValueNode__ = this.unpack1_unpackValueNode_;
                                if (unpackValueNode__ != null) {
                                    return this.unpack1Boundary0(state_0, frameValue.materialize(), arg0Value, arg1Value, indirectCallData__, unpackValueNode__);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            @SuppressWarnings("static-method")
            @TruffleBoundary
            private Object unpack1Boundary0(int state_0, MaterializedFrame frameValue, PStruct arg0Value, Object arg1Value, IndirectCallData indirectCallData__, UnpackValueNode unpackValueNode__) {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set(this);
                try {
                    {
                        Node inliningTarget__ = (this);
                        PythonLanguage language__ = (PythonLanguage.get(this));
                        PythonBufferAccessLibrary bufferLib__ = (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached());
                        return StructUnpackNode.unpack(frameValue, arg0Value, arg1Value, inliningTarget__, language__, indirectCallData__, bufferLib__, unpackValueNode__, INLINED_UNPACK1_RAISE_NODE_);
                    }
                } finally {
                    encapsulating_.set(prev_);
                }
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PStruct) {
                    PStruct arg0Value_ = (PStruct) arg0Value;
                    {
                        PythonLanguage language__ = null;
                        Node inliningTarget__ = null;
                        if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[StructBuiltins.StructUnpackNode.unpack(VirtualFrame, PStruct, Object, Node, PythonLanguage, IndirectCallData, PythonBufferAccessLibrary, UnpackValueNode, PRaiseNode)] */) {
                            while (true) {
                                int count0_ = 0;
                                Unpack0Data s0_ = UNPACK0_CACHE_UPDATER.getVolatile(this);
                                Unpack0Data s0_original = s0_;
                                while (s0_ != null) {
                                    if ((s0_.bufferLib_.accepts(arg1Value))) {
                                        inliningTarget__ = (s0_);
                                        language__ = (PythonLanguage.get(s0_));
                                        break;
                                    }
                                    count0_++;
                                    s0_ = s0_.next_;
                                }
                                if (s0_ == null) {
                                    // assert (s0_.bufferLib_.accepts(arg1Value));
                                    if (count0_ < (3)) {
                                        s0_ = this.insert(new Unpack0Data(s0_original));
                                        inliningTarget__ = (s0_);
                                        language__ = (PythonLanguage.get(s0_));
                                        IndirectCallData indirectCallData__ = (IndirectCallData.createFor(s0_));
                                        Objects.requireNonNull(indirectCallData__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                        s0_.indirectCallData_ = indirectCallData__;
                                        PythonBufferAccessLibrary bufferLib__ = s0_.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.create(arg1Value)));
                                        Objects.requireNonNull(bufferLib__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                        s0_.bufferLib_ = bufferLib__;
                                        UnpackValueNode unpackValueNode__ = s0_.insert((UnpackValueNodeGen.create()));
                                        Objects.requireNonNull(unpackValueNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                        s0_.unpackValueNode_ = unpackValueNode__;
                                        if (!UNPACK0_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                            continue;
                                        }
                                        state_0 = state_0 | 0b1 /* add SpecializationActive[StructBuiltins.StructUnpackNode.unpack(VirtualFrame, PStruct, Object, Node, PythonLanguage, IndirectCallData, PythonBufferAccessLibrary, UnpackValueNode, PRaiseNode)] */;
                                        this.state_0_ = state_0;
                                    }
                                }
                                if (s0_ != null) {
                                    return StructUnpackNode.unpack(frameValue, arg0Value_, arg1Value, inliningTarget__, language__, s0_.indirectCallData_, s0_.bufferLib_, s0_.unpackValueNode_, INLINED_UNPACK0_RAISE_NODE_);
                                }
                                break;
                            }
                        }
                    }
                    {
                        PythonBufferAccessLibrary bufferLib__ = null;
                        PythonLanguage language__ = null;
                        Node inliningTarget__ = null;
                        {
                            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            Node prev_ = encapsulating_.set(this);
                            try {
                                inliningTarget__ = (this);
                                language__ = (PythonLanguage.get(this));
                                IndirectCallData indirectCallData__ = (IndirectCallData.createFor(this));
                                Objects.requireNonNull(indirectCallData__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                VarHandle.storeStoreFence();
                                this.unpack1_indirectCallData_ = indirectCallData__;
                                bufferLib__ = (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached());
                                UnpackValueNode unpackValueNode__ = this.insert((UnpackValueNodeGen.create()));
                                Objects.requireNonNull(unpackValueNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                VarHandle.storeStoreFence();
                                this.unpack1_unpackValueNode_ = unpackValueNode__;
                                this.unpack0_cache = null;
                                state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[StructBuiltins.StructUnpackNode.unpack(VirtualFrame, PStruct, Object, Node, PythonLanguage, IndirectCallData, PythonBufferAccessLibrary, UnpackValueNode, PRaiseNode)] */;
                                state_0 = state_0 | 0b10 /* add SpecializationActive[StructBuiltins.StructUnpackNode.unpack(VirtualFrame, PStruct, Object, Node, PythonLanguage, IndirectCallData, PythonBufferAccessLibrary, UnpackValueNode, PRaiseNode)] */;
                                this.state_0_ = state_0;
                                return StructUnpackNode.unpack(frameValue, arg0Value_, arg1Value, inliningTarget__, language__, indirectCallData__, bufferLib__, unpackValueNode__, INLINED_UNPACK1_RAISE_NODE_);
                            } finally {
                                encapsulating_.set(prev_);
                            }
                        }
                    }
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value);
            }

            @GeneratedBy(StructUnpackNode.class)
            @DenyReplace
            private static final class Unpack0Data extends Node implements SpecializationDataNode {

                @Child Unpack0Data next_;
                /**
                 * State Info: <pre>
                 *   0: InlinedCache
                 *        Specialization: {@link StructUnpackNode#unpack}
                 *        Parameter: {@link PRaiseNode} raiseNode
                 *        Inline method: {@link PRaiseNodeGen#inline}
                 * </pre> */
                @CompilationFinal @UnsafeAccessedField private int unpack0_state_0_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link StructUnpackNode#unpack}
                 *   Parameter: {@link IndirectCallData} indirectCallData</pre> */
                @CompilationFinal IndirectCallData indirectCallData_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link StructUnpackNode#unpack}
                 *   Parameter: {@link PythonBufferAccessLibrary} bufferLib</pre> */
                @Child PythonBufferAccessLibrary bufferLib_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link StructUnpackNode#unpack}
                 *   Parameter: {@link UnpackValueNode} unpackValueNode</pre> */
                @Child UnpackValueNode unpackValueNode_;

                Unpack0Data(Unpack0Data next_) {
                    this.next_ = next_;
                }

                private static Lookup lookup_() {
                    return MethodHandles.lookup();
                }

            }
        }
    }
    @GeneratedBy(StructIterUnpackNode.class)
    public static final class StructIterUnpackNodeFactory implements NodeFactory<StructIterUnpackNode> {

        private static final StructIterUnpackNodeFactory STRUCT_ITER_UNPACK_NODE_FACTORY_INSTANCE = new StructIterUnpackNodeFactory();

        private StructIterUnpackNodeFactory() {
        }

        @Override
        public Class<StructIterUnpackNode> getNodeClass() {
            return StructIterUnpackNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public StructIterUnpackNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<StructIterUnpackNode> getInstance() {
            return STRUCT_ITER_UNPACK_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static StructIterUnpackNode create() {
            return new StructIterUnpackNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link StructIterUnpackNode#iterUnpack}
         *     Activation probability: 0.65000
         *     With/without class size: 24/9 bytes
         *   Specialization {@link StructIterUnpackNode#iterUnpack}
         *     Activation probability: 0.35000
         *     With/without class size: 12/5 bytes
         * </pre> */
        @GeneratedBy(StructIterUnpackNode.class)
        @SuppressWarnings("javadoc")
        public static final class StructIterUnpackNodeGen extends StructIterUnpackNode {

            private static final StateField ITER_UNPACK0_STRUCT_ITER_UNPACK_NODE_ITER_UNPACK0_STATE_0_UPDATER = StateField.create(IterUnpack0Data.lookup_(), "iterUnpack0_state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link StructIterUnpackNode#iterUnpack}
             *   Parameter: {@link PRaiseNode} raiseNode
             *   Inline method: {@link PRaiseNodeGen#inline}</pre> */
            private static final PRaiseNode INLINED_ITER_UNPACK0_RAISE_NODE_ = PRaiseNodeGen.inline(InlineTarget.create(PRaiseNode.class, ITER_UNPACK0_STRUCT_ITER_UNPACK_NODE_ITER_UNPACK0_STATE_0_UPDATER.subUpdater(0, 1)));
            private static final StateField STATE_0_StructIterUnpackNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link StructIterUnpackNode#iterUnpack}
             *   Parameter: {@link PRaiseNode} raiseNode
             *   Inline method: {@link PRaiseNodeGen#inline}</pre> */
            private static final PRaiseNode INLINED_ITER_UNPACK1_RAISE_NODE_ = PRaiseNodeGen.inline(InlineTarget.create(PRaiseNode.class, STATE_0_StructIterUnpackNode_UPDATER.subUpdater(2, 1)));
            static final ReferenceField<IterUnpack0Data> ITER_UNPACK0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "iterUnpack0_cache", IterUnpack0Data.class);

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link StructIterUnpackNode#iterUnpack}
             *   1: SpecializationActive {@link StructIterUnpackNode#iterUnpack}
             *   2: InlinedCache
             *        Specialization: {@link StructIterUnpackNode#iterUnpack}
             *        Parameter: {@link PRaiseNode} raiseNode
             *        Inline method: {@link PRaiseNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            @UnsafeAccessedField @Child private IterUnpack0Data iterUnpack0_cache;
            /**
             * Source Info: <pre>
             *   Specialization: {@link StructIterUnpackNode#iterUnpack}
             *   Parameter: {@link IndirectCallData} indirectCallData</pre> */
            @CompilationFinal private IndirectCallData iterUnpack1_indirectCallData_;

            private StructIterUnpackNodeGen() {
            }

            @ExplodeLoop
            @Override
            protected Object executeWithoutClinic(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[StructBuiltins.StructIterUnpackNode.iterUnpack(VirtualFrame, PStruct, Object, Node, PythonLanguage, IndirectCallData, PythonBufferAccessLibrary, PRaiseNode)] || SpecializationActive[StructBuiltins.StructIterUnpackNode.iterUnpack(VirtualFrame, PStruct, Object, Node, PythonLanguage, IndirectCallData, PythonBufferAccessLibrary, PRaiseNode)] */ && arg0Value instanceof PStruct) {
                    PStruct arg0Value_ = (PStruct) arg0Value;
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[StructBuiltins.StructIterUnpackNode.iterUnpack(VirtualFrame, PStruct, Object, Node, PythonLanguage, IndirectCallData, PythonBufferAccessLibrary, PRaiseNode)] */) {
                        IterUnpack0Data s0_ = this.iterUnpack0_cache;
                        while (s0_ != null) {
                            if ((s0_.bufferLib_.accepts(arg1Value))) {
                                Node inliningTarget__ = (s0_);
                                PythonLanguage language__ = (PythonLanguage.get(s0_));
                                return StructIterUnpackNode.iterUnpack(frameValue, arg0Value_, arg1Value, inliningTarget__, language__, s0_.indirectCallData_, s0_.bufferLib_, INLINED_ITER_UNPACK0_RAISE_NODE_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[StructBuiltins.StructIterUnpackNode.iterUnpack(VirtualFrame, PStruct, Object, Node, PythonLanguage, IndirectCallData, PythonBufferAccessLibrary, PRaiseNode)] */) {
                        {
                            IndirectCallData indirectCallData__ = this.iterUnpack1_indirectCallData_;
                            if (indirectCallData__ != null) {
                                return this.iterUnpack1Boundary(state_0, frameValue.materialize(), arg0Value_, arg1Value, indirectCallData__);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            @SuppressWarnings("static-method")
            @TruffleBoundary
            private Object iterUnpack1Boundary(int state_0, MaterializedFrame frameValue, PStruct arg0Value_, Object arg1Value, IndirectCallData indirectCallData__) {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set(this);
                try {
                    {
                        Node inliningTarget__ = (this);
                        PythonLanguage language__ = (PythonLanguage.get(this));
                        PythonBufferAccessLibrary bufferLib__ = (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached());
                        return StructIterUnpackNode.iterUnpack(frameValue, arg0Value_, arg1Value, inliningTarget__, language__, indirectCallData__, bufferLib__, INLINED_ITER_UNPACK1_RAISE_NODE_);
                    }
                } finally {
                    encapsulating_.set(prev_);
                }
            }

            @ExplodeLoop
            @Override
            public Object execute(VirtualFrame frameValue, PStruct arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[StructBuiltins.StructIterUnpackNode.iterUnpack(VirtualFrame, PStruct, Object, Node, PythonLanguage, IndirectCallData, PythonBufferAccessLibrary, PRaiseNode)] || SpecializationActive[StructBuiltins.StructIterUnpackNode.iterUnpack(VirtualFrame, PStruct, Object, Node, PythonLanguage, IndirectCallData, PythonBufferAccessLibrary, PRaiseNode)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[StructBuiltins.StructIterUnpackNode.iterUnpack(VirtualFrame, PStruct, Object, Node, PythonLanguage, IndirectCallData, PythonBufferAccessLibrary, PRaiseNode)] */) {
                        IterUnpack0Data s0_ = this.iterUnpack0_cache;
                        while (s0_ != null) {
                            if ((s0_.bufferLib_.accepts(arg1Value))) {
                                Node inliningTarget__ = (s0_);
                                PythonLanguage language__ = (PythonLanguage.get(s0_));
                                return StructIterUnpackNode.iterUnpack(frameValue, arg0Value, arg1Value, inliningTarget__, language__, s0_.indirectCallData_, s0_.bufferLib_, INLINED_ITER_UNPACK0_RAISE_NODE_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[StructBuiltins.StructIterUnpackNode.iterUnpack(VirtualFrame, PStruct, Object, Node, PythonLanguage, IndirectCallData, PythonBufferAccessLibrary, PRaiseNode)] */) {
                        {
                            IndirectCallData indirectCallData__ = this.iterUnpack1_indirectCallData_;
                            if (indirectCallData__ != null) {
                                return this.iterUnpack1Boundary0(state_0, frameValue.materialize(), arg0Value, arg1Value, indirectCallData__);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            @SuppressWarnings("static-method")
            @TruffleBoundary
            private Object iterUnpack1Boundary0(int state_0, MaterializedFrame frameValue, PStruct arg0Value, Object arg1Value, IndirectCallData indirectCallData__) {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set(this);
                try {
                    {
                        Node inliningTarget__ = (this);
                        PythonLanguage language__ = (PythonLanguage.get(this));
                        PythonBufferAccessLibrary bufferLib__ = (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached());
                        return StructIterUnpackNode.iterUnpack(frameValue, arg0Value, arg1Value, inliningTarget__, language__, indirectCallData__, bufferLib__, INLINED_ITER_UNPACK1_RAISE_NODE_);
                    }
                } finally {
                    encapsulating_.set(prev_);
                }
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PStruct) {
                    PStruct arg0Value_ = (PStruct) arg0Value;
                    {
                        PythonLanguage language__ = null;
                        Node inliningTarget__ = null;
                        if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[StructBuiltins.StructIterUnpackNode.iterUnpack(VirtualFrame, PStruct, Object, Node, PythonLanguage, IndirectCallData, PythonBufferAccessLibrary, PRaiseNode)] */) {
                            while (true) {
                                int count0_ = 0;
                                IterUnpack0Data s0_ = ITER_UNPACK0_CACHE_UPDATER.getVolatile(this);
                                IterUnpack0Data s0_original = s0_;
                                while (s0_ != null) {
                                    if ((s0_.bufferLib_.accepts(arg1Value))) {
                                        inliningTarget__ = (s0_);
                                        language__ = (PythonLanguage.get(s0_));
                                        break;
                                    }
                                    count0_++;
                                    s0_ = s0_.next_;
                                }
                                if (s0_ == null) {
                                    // assert (s0_.bufferLib_.accepts(arg1Value));
                                    if (count0_ < (3)) {
                                        s0_ = this.insert(new IterUnpack0Data(s0_original));
                                        inliningTarget__ = (s0_);
                                        language__ = (PythonLanguage.get(s0_));
                                        IndirectCallData indirectCallData__ = (IndirectCallData.createFor(s0_));
                                        Objects.requireNonNull(indirectCallData__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                        s0_.indirectCallData_ = indirectCallData__;
                                        PythonBufferAccessLibrary bufferLib__ = s0_.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.create(arg1Value)));
                                        Objects.requireNonNull(bufferLib__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                        s0_.bufferLib_ = bufferLib__;
                                        if (!ITER_UNPACK0_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                            continue;
                                        }
                                        state_0 = state_0 | 0b1 /* add SpecializationActive[StructBuiltins.StructIterUnpackNode.iterUnpack(VirtualFrame, PStruct, Object, Node, PythonLanguage, IndirectCallData, PythonBufferAccessLibrary, PRaiseNode)] */;
                                        this.state_0_ = state_0;
                                    }
                                }
                                if (s0_ != null) {
                                    return StructIterUnpackNode.iterUnpack(frameValue, arg0Value_, arg1Value, inliningTarget__, language__, s0_.indirectCallData_, s0_.bufferLib_, INLINED_ITER_UNPACK0_RAISE_NODE_);
                                }
                                break;
                            }
                        }
                    }
                    {
                        PythonBufferAccessLibrary bufferLib__ = null;
                        PythonLanguage language__ = null;
                        Node inliningTarget__ = null;
                        {
                            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            Node prev_ = encapsulating_.set(this);
                            try {
                                inliningTarget__ = (this);
                                language__ = (PythonLanguage.get(this));
                                IndirectCallData indirectCallData__ = (IndirectCallData.createFor(this));
                                Objects.requireNonNull(indirectCallData__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                VarHandle.storeStoreFence();
                                this.iterUnpack1_indirectCallData_ = indirectCallData__;
                                bufferLib__ = (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached());
                                this.iterUnpack0_cache = null;
                                state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[StructBuiltins.StructIterUnpackNode.iterUnpack(VirtualFrame, PStruct, Object, Node, PythonLanguage, IndirectCallData, PythonBufferAccessLibrary, PRaiseNode)] */;
                                state_0 = state_0 | 0b10 /* add SpecializationActive[StructBuiltins.StructIterUnpackNode.iterUnpack(VirtualFrame, PStruct, Object, Node, PythonLanguage, IndirectCallData, PythonBufferAccessLibrary, PRaiseNode)] */;
                                this.state_0_ = state_0;
                                return StructIterUnpackNode.iterUnpack(frameValue, arg0Value_, arg1Value, inliningTarget__, language__, indirectCallData__, bufferLib__, INLINED_ITER_UNPACK1_RAISE_NODE_);
                            } finally {
                                encapsulating_.set(prev_);
                            }
                        }
                    }
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value);
            }

            @GeneratedBy(StructIterUnpackNode.class)
            @DenyReplace
            private static final class IterUnpack0Data extends Node implements SpecializationDataNode {

                @Child IterUnpack0Data next_;
                /**
                 * State Info: <pre>
                 *   0: InlinedCache
                 *        Specialization: {@link StructIterUnpackNode#iterUnpack}
                 *        Parameter: {@link PRaiseNode} raiseNode
                 *        Inline method: {@link PRaiseNodeGen#inline}
                 * </pre> */
                @CompilationFinal @UnsafeAccessedField private int iterUnpack0_state_0_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link StructIterUnpackNode#iterUnpack}
                 *   Parameter: {@link IndirectCallData} indirectCallData</pre> */
                @CompilationFinal IndirectCallData indirectCallData_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link StructIterUnpackNode#iterUnpack}
                 *   Parameter: {@link PythonBufferAccessLibrary} bufferLib</pre> */
                @Child PythonBufferAccessLibrary bufferLib_;

                IterUnpack0Data(IterUnpack0Data next_) {
                    this.next_ = next_;
                }

                private static Lookup lookup_() {
                    return MethodHandles.lookup();
                }

            }
        }
    }
    @GeneratedBy(StructUnpackFromNode.class)
    public static final class StructUnpackFromNodeFactory implements NodeFactory<StructUnpackFromNode> {

        private static final StructUnpackFromNodeFactory STRUCT_UNPACK_FROM_NODE_FACTORY_INSTANCE = new StructUnpackFromNodeFactory();

        private StructUnpackFromNodeFactory() {
        }

        @Override
        public Class<StructUnpackFromNode> getNodeClass() {
            return StructUnpackFromNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public StructUnpackFromNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<StructUnpackFromNode> getInstance() {
            return STRUCT_UNPACK_FROM_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static StructUnpackFromNode create() {
            return new StructUnpackFromNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link StructUnpackFromNode#unpackFrom}
         *     Activation probability: 0.65000
         *     With/without class size: 27/13 bytes
         *   Specialization {@link StructUnpackFromNode#unpackFrom}
         *     Activation probability: 0.35000
         *     With/without class size: 13/9 bytes
         * </pre> */
        @GeneratedBy(StructUnpackFromNode.class)
        @SuppressWarnings("javadoc")
        public static final class StructUnpackFromNodeGen extends StructUnpackFromNode {

            private static final StateField UNPACK_FROM0_STRUCT_UNPACK_FROM_NODE_UNPACK_FROM0_STATE_0_UPDATER = StateField.create(UnpackFrom0Data.lookup_(), "unpackFrom0_state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link StructUnpackFromNode#unpackFrom}
             *   Parameter: {@link PRaiseNode} raiseNode
             *   Inline method: {@link PRaiseNodeGen#inline}</pre> */
            private static final PRaiseNode INLINED_UNPACK_FROM0_RAISE_NODE_ = PRaiseNodeGen.inline(InlineTarget.create(PRaiseNode.class, UNPACK_FROM0_STRUCT_UNPACK_FROM_NODE_UNPACK_FROM0_STATE_0_UPDATER.subUpdater(0, 1)));
            private static final StateField STATE_0_StructUnpackFromNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link StructUnpackFromNode#unpackFrom}
             *   Parameter: {@link PRaiseNode} raiseNode
             *   Inline method: {@link PRaiseNodeGen#inline}</pre> */
            private static final PRaiseNode INLINED_UNPACK_FROM1_RAISE_NODE_ = PRaiseNodeGen.inline(InlineTarget.create(PRaiseNode.class, STATE_0_StructUnpackFromNode_UPDATER.subUpdater(2, 1)));
            static final ReferenceField<UnpackFrom0Data> UNPACK_FROM0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "unpackFrom0_cache", UnpackFrom0Data.class);

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link StructUnpackFromNode#unpackFrom}
             *   1: SpecializationActive {@link StructUnpackFromNode#unpackFrom}
             *   2: InlinedCache
             *        Specialization: {@link StructUnpackFromNode#unpackFrom}
             *        Parameter: {@link PRaiseNode} raiseNode
             *        Inline method: {@link PRaiseNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            @UnsafeAccessedField @Child private UnpackFrom0Data unpackFrom0_cache;
            /**
             * Source Info: <pre>
             *   Specialization: {@link StructUnpackFromNode#unpackFrom}
             *   Parameter: {@link IndirectCallData} indirectCallData</pre> */
            @CompilationFinal private IndirectCallData unpackFrom1_indirectCallData_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link StructUnpackFromNode#unpackFrom}
             *   Parameter: {@link UnpackValueNode} unpackValueNode</pre> */
            @Child private UnpackValueNode unpackFrom1_unpackValueNode_;

            private StructUnpackFromNodeGen() {
            }

            @ExplodeLoop
            @Override
            protected Object executeWithoutClinic(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[StructBuiltins.StructUnpackFromNode.unpackFrom(VirtualFrame, PStruct, Object, int, Node, PythonLanguage, IndirectCallData, PythonBufferAccessLibrary, UnpackValueNode, PRaiseNode)] || SpecializationActive[StructBuiltins.StructUnpackFromNode.unpackFrom(VirtualFrame, PStruct, Object, int, Node, PythonLanguage, IndirectCallData, PythonBufferAccessLibrary, UnpackValueNode, PRaiseNode)] */ && arg0Value instanceof PStruct) {
                    PStruct arg0Value_ = (PStruct) arg0Value;
                    if (arg2Value instanceof Integer) {
                        int arg2Value_ = (int) arg2Value;
                        if ((state_0 & 0b1) != 0 /* is SpecializationActive[StructBuiltins.StructUnpackFromNode.unpackFrom(VirtualFrame, PStruct, Object, int, Node, PythonLanguage, IndirectCallData, PythonBufferAccessLibrary, UnpackValueNode, PRaiseNode)] */) {
                            UnpackFrom0Data s0_ = this.unpackFrom0_cache;
                            while (s0_ != null) {
                                if ((s0_.bufferLib_.accepts(arg1Value))) {
                                    Node inliningTarget__ = (s0_);
                                    PythonLanguage language__ = (PythonLanguage.get(s0_));
                                    return StructUnpackFromNode.unpackFrom(frameValue, arg0Value_, arg1Value, arg2Value_, inliningTarget__, language__, s0_.indirectCallData_, s0_.bufferLib_, s0_.unpackValueNode_, INLINED_UNPACK_FROM0_RAISE_NODE_);
                                }
                                s0_ = s0_.next_;
                            }
                        }
                        if ((state_0 & 0b10) != 0 /* is SpecializationActive[StructBuiltins.StructUnpackFromNode.unpackFrom(VirtualFrame, PStruct, Object, int, Node, PythonLanguage, IndirectCallData, PythonBufferAccessLibrary, UnpackValueNode, PRaiseNode)] */) {
                            {
                                IndirectCallData indirectCallData__ = this.unpackFrom1_indirectCallData_;
                                if (indirectCallData__ != null) {
                                    UnpackValueNode unpackValueNode__ = this.unpackFrom1_unpackValueNode_;
                                    if (unpackValueNode__ != null) {
                                        return this.unpackFrom1Boundary(state_0, frameValue.materialize(), arg0Value_, arg1Value, arg2Value_, indirectCallData__, unpackValueNode__);
                                    }
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value, arg2Value);
            }

            @SuppressWarnings("static-method")
            @TruffleBoundary
            private Object unpackFrom1Boundary(int state_0, MaterializedFrame frameValue, PStruct arg0Value_, Object arg1Value, int arg2Value_, IndirectCallData indirectCallData__, UnpackValueNode unpackValueNode__) {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set(this);
                try {
                    {
                        Node inliningTarget__ = (this);
                        PythonLanguage language__ = (PythonLanguage.get(this));
                        PythonBufferAccessLibrary bufferLib__ = (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached());
                        return StructUnpackFromNode.unpackFrom(frameValue, arg0Value_, arg1Value, arg2Value_, inliningTarget__, language__, indirectCallData__, bufferLib__, unpackValueNode__, INLINED_UNPACK_FROM1_RAISE_NODE_);
                    }
                } finally {
                    encapsulating_.set(prev_);
                }
            }

            @ExplodeLoop
            @Override
            public Object execute(VirtualFrame frameValue, PStruct arg0Value, Object arg1Value, int arg2Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[StructBuiltins.StructUnpackFromNode.unpackFrom(VirtualFrame, PStruct, Object, int, Node, PythonLanguage, IndirectCallData, PythonBufferAccessLibrary, UnpackValueNode, PRaiseNode)] || SpecializationActive[StructBuiltins.StructUnpackFromNode.unpackFrom(VirtualFrame, PStruct, Object, int, Node, PythonLanguage, IndirectCallData, PythonBufferAccessLibrary, UnpackValueNode, PRaiseNode)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[StructBuiltins.StructUnpackFromNode.unpackFrom(VirtualFrame, PStruct, Object, int, Node, PythonLanguage, IndirectCallData, PythonBufferAccessLibrary, UnpackValueNode, PRaiseNode)] */) {
                        UnpackFrom0Data s0_ = this.unpackFrom0_cache;
                        while (s0_ != null) {
                            if ((s0_.bufferLib_.accepts(arg1Value))) {
                                Node inliningTarget__ = (s0_);
                                PythonLanguage language__ = (PythonLanguage.get(s0_));
                                return StructUnpackFromNode.unpackFrom(frameValue, arg0Value, arg1Value, arg2Value, inliningTarget__, language__, s0_.indirectCallData_, s0_.bufferLib_, s0_.unpackValueNode_, INLINED_UNPACK_FROM0_RAISE_NODE_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[StructBuiltins.StructUnpackFromNode.unpackFrom(VirtualFrame, PStruct, Object, int, Node, PythonLanguage, IndirectCallData, PythonBufferAccessLibrary, UnpackValueNode, PRaiseNode)] */) {
                        {
                            IndirectCallData indirectCallData__ = this.unpackFrom1_indirectCallData_;
                            if (indirectCallData__ != null) {
                                UnpackValueNode unpackValueNode__ = this.unpackFrom1_unpackValueNode_;
                                if (unpackValueNode__ != null) {
                                    return this.unpackFrom1Boundary0(state_0, frameValue.materialize(), arg0Value, arg1Value, arg2Value, indirectCallData__, unpackValueNode__);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value, arg2Value);
            }

            @SuppressWarnings("static-method")
            @TruffleBoundary
            private Object unpackFrom1Boundary0(int state_0, MaterializedFrame frameValue, PStruct arg0Value, Object arg1Value, int arg2Value, IndirectCallData indirectCallData__, UnpackValueNode unpackValueNode__) {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set(this);
                try {
                    {
                        Node inliningTarget__ = (this);
                        PythonLanguage language__ = (PythonLanguage.get(this));
                        PythonBufferAccessLibrary bufferLib__ = (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached());
                        return StructUnpackFromNode.unpackFrom(frameValue, arg0Value, arg1Value, arg2Value, inliningTarget__, language__, indirectCallData__, bufferLib__, unpackValueNode__, INLINED_UNPACK_FROM1_RAISE_NODE_);
                    }
                } finally {
                    encapsulating_.set(prev_);
                }
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PStruct) {
                    PStruct arg0Value_ = (PStruct) arg0Value;
                    if (arg2Value instanceof Integer) {
                        int arg2Value_ = (int) arg2Value;
                        {
                            PythonLanguage language__ = null;
                            Node inliningTarget__ = null;
                            if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[StructBuiltins.StructUnpackFromNode.unpackFrom(VirtualFrame, PStruct, Object, int, Node, PythonLanguage, IndirectCallData, PythonBufferAccessLibrary, UnpackValueNode, PRaiseNode)] */) {
                                while (true) {
                                    int count0_ = 0;
                                    UnpackFrom0Data s0_ = UNPACK_FROM0_CACHE_UPDATER.getVolatile(this);
                                    UnpackFrom0Data s0_original = s0_;
                                    while (s0_ != null) {
                                        if ((s0_.bufferLib_.accepts(arg1Value))) {
                                            inliningTarget__ = (s0_);
                                            language__ = (PythonLanguage.get(s0_));
                                            break;
                                        }
                                        count0_++;
                                        s0_ = s0_.next_;
                                    }
                                    if (s0_ == null) {
                                        // assert (s0_.bufferLib_.accepts(arg1Value));
                                        if (count0_ < (3)) {
                                            s0_ = this.insert(new UnpackFrom0Data(s0_original));
                                            inliningTarget__ = (s0_);
                                            language__ = (PythonLanguage.get(s0_));
                                            IndirectCallData indirectCallData__ = (IndirectCallData.createFor(s0_));
                                            Objects.requireNonNull(indirectCallData__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                            s0_.indirectCallData_ = indirectCallData__;
                                            PythonBufferAccessLibrary bufferLib__ = s0_.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.create(arg1Value)));
                                            Objects.requireNonNull(bufferLib__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                            s0_.bufferLib_ = bufferLib__;
                                            UnpackValueNode unpackValueNode__ = s0_.insert((UnpackValueNodeGen.create()));
                                            Objects.requireNonNull(unpackValueNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                            s0_.unpackValueNode_ = unpackValueNode__;
                                            if (!UNPACK_FROM0_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                                continue;
                                            }
                                            state_0 = state_0 | 0b1 /* add SpecializationActive[StructBuiltins.StructUnpackFromNode.unpackFrom(VirtualFrame, PStruct, Object, int, Node, PythonLanguage, IndirectCallData, PythonBufferAccessLibrary, UnpackValueNode, PRaiseNode)] */;
                                            this.state_0_ = state_0;
                                        }
                                    }
                                    if (s0_ != null) {
                                        return StructUnpackFromNode.unpackFrom(frameValue, arg0Value_, arg1Value, arg2Value_, inliningTarget__, language__, s0_.indirectCallData_, s0_.bufferLib_, s0_.unpackValueNode_, INLINED_UNPACK_FROM0_RAISE_NODE_);
                                    }
                                    break;
                                }
                            }
                        }
                        {
                            PythonBufferAccessLibrary bufferLib__ = null;
                            PythonLanguage language__ = null;
                            Node inliningTarget__ = null;
                            {
                                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                                Node prev_ = encapsulating_.set(this);
                                try {
                                    inliningTarget__ = (this);
                                    language__ = (PythonLanguage.get(this));
                                    IndirectCallData indirectCallData__ = (IndirectCallData.createFor(this));
                                    Objects.requireNonNull(indirectCallData__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                    VarHandle.storeStoreFence();
                                    this.unpackFrom1_indirectCallData_ = indirectCallData__;
                                    bufferLib__ = (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached());
                                    UnpackValueNode unpackValueNode__ = this.insert((UnpackValueNodeGen.create()));
                                    Objects.requireNonNull(unpackValueNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                    VarHandle.storeStoreFence();
                                    this.unpackFrom1_unpackValueNode_ = unpackValueNode__;
                                    this.unpackFrom0_cache = null;
                                    state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[StructBuiltins.StructUnpackFromNode.unpackFrom(VirtualFrame, PStruct, Object, int, Node, PythonLanguage, IndirectCallData, PythonBufferAccessLibrary, UnpackValueNode, PRaiseNode)] */;
                                    state_0 = state_0 | 0b10 /* add SpecializationActive[StructBuiltins.StructUnpackFromNode.unpackFrom(VirtualFrame, PStruct, Object, int, Node, PythonLanguage, IndirectCallData, PythonBufferAccessLibrary, UnpackValueNode, PRaiseNode)] */;
                                    this.state_0_ = state_0;
                                    return StructUnpackFromNode.unpackFrom(frameValue, arg0Value_, arg1Value, arg2Value_, inliningTarget__, language__, indirectCallData__, bufferLib__, unpackValueNode__, INLINED_UNPACK_FROM1_RAISE_NODE_);
                                } finally {
                                    encapsulating_.set(prev_);
                                }
                            }
                        }
                    }
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value, arg2Value);
            }

            @GeneratedBy(StructUnpackFromNode.class)
            @DenyReplace
            private static final class UnpackFrom0Data extends Node implements SpecializationDataNode {

                @Child UnpackFrom0Data next_;
                /**
                 * State Info: <pre>
                 *   0: InlinedCache
                 *        Specialization: {@link StructUnpackFromNode#unpackFrom}
                 *        Parameter: {@link PRaiseNode} raiseNode
                 *        Inline method: {@link PRaiseNodeGen#inline}
                 * </pre> */
                @CompilationFinal @UnsafeAccessedField private int unpackFrom0_state_0_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link StructUnpackFromNode#unpackFrom}
                 *   Parameter: {@link IndirectCallData} indirectCallData</pre> */
                @CompilationFinal IndirectCallData indirectCallData_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link StructUnpackFromNode#unpackFrom}
                 *   Parameter: {@link PythonBufferAccessLibrary} bufferLib</pre> */
                @Child PythonBufferAccessLibrary bufferLib_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link StructUnpackFromNode#unpackFrom}
                 *   Parameter: {@link UnpackValueNode} unpackValueNode</pre> */
                @Child UnpackValueNode unpackValueNode_;

                UnpackFrom0Data(UnpackFrom0Data next_) {
                    this.next_ = next_;
                }

                private static Lookup lookup_() {
                    return MethodHandles.lookup();
                }

            }
        }
    }
    @GeneratedBy(StructCalcSizeNode.class)
    public static final class StructCalcSizeNodeFactory implements NodeFactory<StructCalcSizeNode> {

        private static final StructCalcSizeNodeFactory STRUCT_CALC_SIZE_NODE_FACTORY_INSTANCE = new StructCalcSizeNodeFactory();

        private StructCalcSizeNodeFactory() {
        }

        @Override
        public Class<StructCalcSizeNode> getNodeClass() {
            return StructCalcSizeNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public StructCalcSizeNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<StructCalcSizeNode> getInstance() {
            return STRUCT_CALC_SIZE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static StructCalcSizeNode create() {
            return new StructCalcSizeNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link StructCalcSizeNode#calcSize}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre> */
        @GeneratedBy(StructCalcSizeNode.class)
        @SuppressWarnings("javadoc")
        public static final class StructCalcSizeNodeGen extends StructCalcSizeNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link StructCalcSizeNode#calcSize}
             * </pre> */
            @CompilationFinal private int state_0_;

            private StructCalcSizeNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[StructBuiltins.StructCalcSizeNode.calcSize(PStruct)] */ && arg0Value instanceof PStruct) {
                    PStruct arg0Value_ = (PStruct) arg0Value;
                    return calcSize(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private Object executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PStruct) {
                    PStruct arg0Value_ = (PStruct) arg0Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[StructBuiltins.StructCalcSizeNode.calcSize(PStruct)] */;
                    this.state_0_ = state_0;
                    return calcSize(arg0Value_);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

        }
    }
    @GeneratedBy(GetStructSizeNode.class)
    public static final class GetStructSizeNodeFactory implements NodeFactory<GetStructSizeNode> {

        private static final GetStructSizeNodeFactory GET_STRUCT_SIZE_NODE_FACTORY_INSTANCE = new GetStructSizeNodeFactory();

        private GetStructSizeNodeFactory() {
        }

        @Override
        public Class<GetStructSizeNode> getNodeClass() {
            return GetStructSizeNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(ReadArgumentNode.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(ReadArgumentNode[].class));
        }

        @Override
        public GetStructSizeNode createNode(Object... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return create((ReadArgumentNode[]) arguments[0]);
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<GetStructSizeNode> getInstance() {
            return GET_STRUCT_SIZE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static GetStructSizeNode create(ReadArgumentNode[] arguments) {
            return new GetStructSizeNodeGen(arguments);
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link GetStructSizeNode#get}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre> */
        @GeneratedBy(GetStructSizeNode.class)
        @SuppressWarnings("javadoc")
        public static final class GetStructSizeNodeGen extends GetStructSizeNode {

            @Child private ReadArgumentNode arguments0_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link GetStructSizeNode#get}
             * </pre> */
            @CompilationFinal private int state_0_;

            private GetStructSizeNodeGen(ReadArgumentNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                if (state_0 != 0 /* is SpecializationActive[StructBuiltins.GetStructSizeNode.get(PStruct)] */ && arguments0Value_ instanceof PStruct) {
                    PStruct arguments0Value__ = (PStruct) arguments0Value_;
                    return get(arguments0Value__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arguments0Value_);
            }

            private Object executeAndSpecialize(Object arguments0Value) {
                int state_0 = this.state_0_;
                if (arguments0Value instanceof PStruct) {
                    PStruct arguments0Value_ = (PStruct) arguments0Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[StructBuiltins.GetStructSizeNode.get(PStruct)] */;
                    this.state_0_ = state_0;
                    return get(arguments0Value_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {this.arguments0_}, arguments0Value);
            }

        }
    }
    @GeneratedBy(GetStructFormat.class)
    public static final class GetStructFormatFactory implements NodeFactory<GetStructFormat> {

        private static final GetStructFormatFactory GET_STRUCT_FORMAT_FACTORY_INSTANCE = new GetStructFormatFactory();

        private GetStructFormatFactory() {
        }

        @Override
        public Class<GetStructFormat> getNodeClass() {
            return GetStructFormat.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(ReadArgumentNode.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(ReadArgumentNode[].class));
        }

        @Override
        public GetStructFormat createNode(Object... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return create((ReadArgumentNode[]) arguments[0]);
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<GetStructFormat> getInstance() {
            return GET_STRUCT_FORMAT_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static GetStructFormat create(ReadArgumentNode[] arguments) {
            return new GetStructFormatNodeGen(arguments);
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link GetStructFormat#get}
         *     Activation probability: 1.00000
         *     With/without class size: 28/8 bytes
         * </pre> */
        @GeneratedBy(GetStructFormat.class)
        @SuppressWarnings("javadoc")
        public static final class GetStructFormatNodeGen extends GetStructFormat {

            @Child private ReadArgumentNode arguments0_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link GetStructFormat#get}
             * </pre> */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link GetStructFormat#get}
             *   Parameter: {@link FromByteArrayNode} fromBytes</pre> */
            @Child private FromByteArrayNode fromBytes_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link GetStructFormat#get}
             *   Parameter: {@link SwitchEncodingNode} switchEncoding</pre> */
            @Child private SwitchEncodingNode switchEncoding_;

            private GetStructFormatNodeGen(ReadArgumentNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                if (state_0 != 0 /* is SpecializationActive[StructBuiltins.GetStructFormat.get(PStruct, FromByteArrayNode, SwitchEncodingNode)] */ && arguments0Value_ instanceof PStruct) {
                    PStruct arguments0Value__ = (PStruct) arguments0Value_;
                    {
                        FromByteArrayNode fromBytes__ = this.fromBytes_;
                        if (fromBytes__ != null) {
                            SwitchEncodingNode switchEncoding__ = this.switchEncoding_;
                            if (switchEncoding__ != null) {
                                return get(arguments0Value__, fromBytes__, switchEncoding__);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arguments0Value_);
            }

            private Object executeAndSpecialize(Object arguments0Value) {
                int state_0 = this.state_0_;
                if (arguments0Value instanceof PStruct) {
                    PStruct arguments0Value_ = (PStruct) arguments0Value;
                    FromByteArrayNode fromBytes__ = this.insert((FromByteArrayNode.create()));
                    Objects.requireNonNull(fromBytes__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.fromBytes_ = fromBytes__;
                    SwitchEncodingNode switchEncoding__ = this.insert((SwitchEncodingNode.create()));
                    Objects.requireNonNull(switchEncoding__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.switchEncoding_ = switchEncoding__;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[StructBuiltins.GetStructFormat.get(PStruct, FromByteArrayNode, SwitchEncodingNode)] */;
                    this.state_0_ = state_0;
                    return get(arguments0Value_, fromBytes__, switchEncoding__);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {this.arguments0_}, arguments0Value);
            }

        }
    }
}
