// CheckStyle: start generated
package com.oracle.graal.python.lib;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.modules.MathGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.PRaiseNodeGen;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.RequiredField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;

/**
 * Debug Info: <pre>
 *   Specialization {@link PyLongFromDoubleNode#doInt}
 *     Activation probability: 0.38500
 *     With/without class size: 8/0 bytes
 *   Specialization {@link PyLongFromDoubleNode#doLong}
 *     Activation probability: 0.29500
 *     With/without class size: 7/0 bytes
 *   Specialization {@link PyLongFromDoubleNode#doFinite}
 *     Activation probability: 0.20500
 *     With/without class size: 6/0 bytes
 *   Specialization {@link PyLongFromDoubleNode#doInfinite}
 *     Activation probability: 0.11500
 *     With/without class size: 6/1 bytes
 * </pre> */
@GeneratedBy(PyLongFromDoubleNode.class)
@SuppressWarnings("javadoc")
public final class PyLongFromDoubleNodeGen {

    private static final Uncached UNCACHED = new Uncached();

    @TruffleBoundary
    private static UnsupportedSpecializationException newUnsupportedSpecializationException2LD(Node thisNode_, Object arg0Value, double arg1Value) {
        return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value);
    }

    @NeverDefault
    public static PyLongFromDoubleNode getUncached() {
        return PyLongFromDoubleNodeGen.UNCACHED;
    }

    /**
     * Required Fields: <ul>
     * <li>{@link Inlined#state_0_}
     * </ul> */
    @NeverDefault
    public static PyLongFromDoubleNode inline(@RequiredField(bits = 5, value = StateField.class) InlineTarget target) {
        return new PyLongFromDoubleNodeGen.Inlined(target);
    }

    @GeneratedBy(PyLongFromDoubleNode.class)
    @DenyReplace
    private static final class Inlined extends PyLongFromDoubleNode implements UnadoptableNode {

        /**
         * State Info: <pre>
         *   0: SpecializationActive {@link PyLongFromDoubleNode#doInt}
         *   1: SpecializationActive {@link PyLongFromDoubleNode#doLong}
         *   2: SpecializationActive {@link PyLongFromDoubleNode#doFinite}
         *   3: SpecializationActive {@link PyLongFromDoubleNode#doInfinite}
         *   4: InlinedCache
         *        Specialization: {@link PyLongFromDoubleNode#doInfinite}
         *        Parameter: {@link PRaiseNode} raiseNode
         *        Inline method: {@link PRaiseNodeGen#inline}
         * </pre> */
        private final StateField state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link PyLongFromDoubleNode#doInfinite}
         *   Parameter: {@link PRaiseNode} raiseNode
         *   Inline method: {@link PRaiseNodeGen#inline}</pre> */
        private final PRaiseNode infinite_raiseNode_;

        private Inlined(InlineTarget target) {
            assert target.getTargetClass().isAssignableFrom(PyLongFromDoubleNode.class);
            this.state_0_ = target.getState(0, 5);
            this.infinite_raiseNode_ = PRaiseNodeGen.inline(InlineTarget.create(PRaiseNode.class, state_0_.subUpdater(4, 1)));
        }

        @Override
        public Object execute(Node arg0Value, double arg1Value) {
            int state_0 = this.state_0_.get(arg0Value);
            if ((state_0 & 0b1111) != 0 /* is SpecializationActive[PyLongFromDoubleNode.doInt(double)] || SpecializationActive[PyLongFromDoubleNode.doLong(double)] || SpecializationActive[PyLongFromDoubleNode.doFinite(double, PythonLanguage)] || SpecializationActive[PyLongFromDoubleNode.doInfinite(Node, double, PRaiseNode)] */) {
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[PyLongFromDoubleNode.doInt(double)] */) {
                    if ((MathGuards.fitInt(arg1Value))) {
                        return PyLongFromDoubleNode.doInt(arg1Value);
                    }
                }
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[PyLongFromDoubleNode.doLong(double)] */) {
                    if ((MathGuards.fitLong(arg1Value))) {
                        return PyLongFromDoubleNode.doLong(arg1Value);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[PyLongFromDoubleNode.doFinite(double, PythonLanguage)] */) {
                    if ((!(MathGuards.fitLong(arg1Value))) && (PyLongFromDoubleNode.isFinite(arg1Value))) {
                        PythonLanguage language__ = (PythonLanguage.get(arg0Value));
                        return PyLongFromDoubleNode.doFinite(arg1Value, language__);
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[PyLongFromDoubleNode.doInfinite(Node, double, PRaiseNode)] */) {
                    if ((!(PyLongFromDoubleNode.isFinite(arg1Value)))) {
                        assert InlineSupport.validate(arg0Value, this.state_0_);
                        return PyLongFromDoubleNode.doInfinite(arg0Value, arg1Value, this.infinite_raiseNode_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private Object executeAndSpecialize(Node arg0Value, double arg1Value) {
            int state_0 = this.state_0_.get(arg0Value);
            if ((MathGuards.fitInt(arg1Value))) {
                state_0 = state_0 | 0b1 /* add SpecializationActive[PyLongFromDoubleNode.doInt(double)] */;
                this.state_0_.set(arg0Value, state_0);
                return PyLongFromDoubleNode.doInt(arg1Value);
            }
            if ((MathGuards.fitLong(arg1Value))) {
                state_0 = state_0 | 0b10 /* add SpecializationActive[PyLongFromDoubleNode.doLong(double)] */;
                this.state_0_.set(arg0Value, state_0);
                return PyLongFromDoubleNode.doLong(arg1Value);
            }
            {
                PythonLanguage language__ = null;
                if ((!(MathGuards.fitLong(arg1Value))) && (PyLongFromDoubleNode.isFinite(arg1Value))) {
                    language__ = (PythonLanguage.get(arg0Value));
                    state_0 = state_0 | 0b100 /* add SpecializationActive[PyLongFromDoubleNode.doFinite(double, PythonLanguage)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return PyLongFromDoubleNode.doFinite(arg1Value, language__);
                }
            }
            if ((!(PyLongFromDoubleNode.isFinite(arg1Value)))) {
                state_0 = state_0 | 0b1000 /* add SpecializationActive[PyLongFromDoubleNode.doInfinite(Node, double, PRaiseNode)] */;
                this.state_0_.set(arg0Value, state_0);
                assert InlineSupport.validate(arg0Value, this.state_0_);
                return PyLongFromDoubleNode.doInfinite(arg0Value, arg1Value, this.infinite_raiseNode_);
            }
            throw newUnsupportedSpecializationException2LD(this, arg0Value, arg1Value);
        }

    }
    @GeneratedBy(PyLongFromDoubleNode.class)
    @DenyReplace
    private static final class Uncached extends PyLongFromDoubleNode implements UnadoptableNode {

        @TruffleBoundary
        @Override
        public Object execute(Node arg0Value, double arg1Value) {
            if ((MathGuards.fitInt(arg1Value))) {
                return PyLongFromDoubleNode.doInt(arg1Value);
            }
            if ((MathGuards.fitLong(arg1Value))) {
                return PyLongFromDoubleNode.doLong(arg1Value);
            }
            if ((!(MathGuards.fitLong(arg1Value))) && (PyLongFromDoubleNode.isFinite(arg1Value))) {
                return PyLongFromDoubleNode.doFinite(arg1Value, (PythonLanguage.get(this)));
            }
            if ((!(PyLongFromDoubleNode.isFinite(arg1Value)))) {
                return PyLongFromDoubleNode.doInfinite(arg0Value, arg1Value, (PRaiseNode.getUncached()));
            }
            throw newUnsupportedSpecializationException2LD(this, arg0Value, arg1Value);
        }

    }
}
