/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.java.annotation;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.graphwalker.core.machine.Context;
import org.graphwalker.java.annotation.GraphWalker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AnnotationUtils {
    private static final Logger logger = LoggerFactory.getLogger(AnnotationUtils.class);

    public static Set<Class<?>> findTests() {
        return AnnotationUtils.find(Context.class, GraphWalker.class);
    }

    public static Set<Class<?>> find(Class<?> type, Class<? extends Annotation> annotation) {
        HashSet classes = new HashSet();
        try (ScanResult scanResult = new ClassGraph().enableClassInfo().enableAnnotationInfo().scan();){
            for (ClassInfo classInfo : scanResult.getClassesWithAnnotation(annotation)) {
                if (!type.isAssignableFrom(classInfo.loadClass())) continue;
                classes.add(classInfo.loadClass());
            }
        }
        return classes;
    }

    private static boolean isAnnotationPresent(Class<?> type, Class<? extends Annotation> annotation) {
        return AnnotationUtils.isAnnotationPresent(type, annotation, Thread.currentThread().getContextClassLoader());
    }

    private static boolean isAnnotationPresent(Class<?> type, Class<? extends Annotation> annotation, ClassLoader classLoader) {
        try {
            Class<?> a = classLoader.loadClass(annotation.getName());
            return type.isAnnotationPresent(a);
        }
        catch (ClassNotFoundException e) {
            logger.error(e.getMessage());
            throw new RuntimeException();
        }
    }

    public static <T extends Annotation> Set<T> getAnnotations(Class<?> clazz, Class<T> annotation) {
        HashSet annotations = new HashSet();
        for (Class<?> queryClass = clazz; null != queryClass; queryClass = queryClass.getSuperclass()) {
            AnnotationUtils.addAnnotation(queryClass, annotations, annotation);
            for (Class<?> interfaceClass : queryClass.getInterfaces()) {
                AnnotationUtils.addAnnotation(interfaceClass, annotations, annotation);
            }
        }
        return annotations;
    }

    private static <T extends Annotation> void addAnnotation(Class<?> clazz, Set<T> annotations, Class<T> annotation) {
        if (clazz.isAnnotationPresent(annotation)) {
            annotations.add(clazz.getAnnotation(annotation));
        }
    }

    public static void execute(Class<? extends Annotation> annotation, Object implementation) {
        for (Method method : implementation.getClass().getMethods()) {
            if (!method.isAnnotationPresent(annotation)) continue;
            try {
                method.invoke(implementation, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }
}

