/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.issues;

import java.net.InetSocketAddress;
import java.net.URI;
import java.util.concurrent.CountDownLatch;
import org.java_websocket.WebSocket;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.handshake.ServerHandshake;
import org.java_websocket.server.WebSocketServer;
import org.java_websocket.util.SocketUtil;
import org.java_websocket.util.ThreadCheck;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class Issue732Test {
    @Rule
    public ThreadCheck zombies = new ThreadCheck();
    private CountDownLatch countServerDownLatch = new CountDownLatch(1);

    @Test(timeout=2000L)
    public void testIssue() throws Exception {
        int port = SocketUtil.getAvailablePort();
        final WebSocketClient webSocket = new WebSocketClient(new URI("ws://localhost:" + port)){

            public void onOpen(ServerHandshake handshakedata) {
                try {
                    this.reconnect();
                    Assert.fail((String)"Exception should be thrown");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }

            public void onMessage(String message) {
                try {
                    this.reconnect();
                    Assert.fail((String)"Exception should be thrown");
                }
                catch (IllegalStateException e) {
                    this.send("hi");
                }
            }

            public void onClose(int code, String reason, boolean remote) {
                try {
                    this.reconnect();
                    Assert.fail((String)"Exception should be thrown");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }

            public void onError(Exception ex) {
                try {
                    this.reconnect();
                    Assert.fail((String)"Exception should be thrown");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        };
        WebSocketServer server = new WebSocketServer(new InetSocketAddress(port)){

            public void onOpen(WebSocket conn, ClientHandshake handshake) {
                conn.send("hi");
            }

            public void onClose(WebSocket conn, int code, String reason, boolean remote) {
                Issue732Test.this.countServerDownLatch.countDown();
            }

            public void onMessage(WebSocket conn, String message) {
                conn.close();
            }

            public void onError(WebSocket conn, Exception ex) {
                Assert.fail((String)"There should be no onError!");
            }

            public void onStart() {
                webSocket.connect();
            }
        };
        server.start();
        this.countServerDownLatch.await();
        server.stop();
    }
}

