/*
 * Decompiled with CFR 0.152.
 */
package org.linuxmce.dce;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.linuxmce.dce.Connection;
import org.linuxmce.dce.ConnectionMonitor;
import org.linuxmce.dce.DCEConnectionInformation;
import org.linuxmce.dce.Message;
import org.linuxmce.dce.MessageDeserializer;
import org.linuxmce.dce.MessageHandler;

public class CommandConnection
extends ConnectionMonitor {
    private MessageHandler commandHandler;
    private DCEConnectionInformation parent;

    public CommandConnection(Connection connection, MessageDeserializer messageDeserializer) {
        super("event", connection, messageDeserializer);
    }

    public void setup(InputStream read, OutputStream write) throws IOException {
        String mesg = "COMMAND " + this.parent.getDeviceId() + "\n";
        write.write(mesg.getBytes());
        String text = this.readLine();
        if (!text.equals("OK")) {
            throw new IllegalArgumentException("Return text is no 'OK', is " + text);
        }
    }

    public void onMessage(Message message) {
        this.commandHandler.handleCommand(message);
    }

    public void setParent(DCEConnectionInformation parent) {
        this.parent = parent;
    }

    public void setCommandHandler(MessageHandler commandHandler) {
        this.commandHandler = commandHandler;
    }
}

