/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.maven.extractor;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class CodeExtractor
extends AbstractMojo {
    private static final String LINE_END = "\n";
    protected static final String startAnnotation = "@extract ";
    protected static final String endAnnotation = "@extract-end";
    private File outputDirectory;
    private File inputDirectory;
    private boolean useDefaultExcludes;
    private BufferedWriter writer = null;

    public void execute() throws MojoExecutionException {
        File f = this.outputDirectory;
        if (!f.exists()) {
            f.mkdirs();
        }
        try {
            this.extractCode(this.inputDirectory);
            this.close();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error extracting code ", e);
        }
    }

    public void extractCode(File sourceDir) throws Exception {
        if (sourceDir.getName().startsWith(".") && this.useDefaultExcludes) {
            return;
        }
        System.out.println("Extracting dir " + sourceDir);
        File[] elements = sourceDir.listFiles();
        for (int i = 0; i < elements.length; ++i) {
            File file = elements[i];
            if (file.isDirectory()) {
                this.extractCode(file);
                continue;
            }
            if (!file.getName().endsWith(".java") || file.getName().equals("Extractor.java")) continue;
            this.extractAnnotatedCode(file);
        }
    }

    private void close() throws Exception {
        if (this.writer != null) {
            this.closeFile(this.writer);
        }
    }

    public void extractAnnotatedCode(File file) throws Exception {
        System.out.println("Extracting file " + file.getName());
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        boolean extract = false;
        boolean skip = false;
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (extract) {
                if (line.contains("@skip-end") || line.contains("@ignore-end")) {
                    skip = false;
                    continue;
                }
                if (line.contains("@skip")) {
                    StringBuffer skipping = new StringBuffer();
                    int i = 0;
                    while (line.charAt(i) == ' ') {
                        skipping.append(" ");
                        ++i;
                    }
                    skipping.append(":");
                    this.writer.write(skipping.toString());
                    this.writer.newLine();
                    this.writer.write(skipping.toString());
                    this.writer.newLine();
                    skip = true;
                    continue;
                }
                if (line.contains("@ignore")) {
                    skip = true;
                    continue;
                }
                if (line.contains(endAnnotation)) {
                    this.writer.write("</programlisting></simplesect>");
                    this.writer.newLine();
                    extract = false;
                    continue;
                }
                if (skip) continue;
                this.writer.append(this.converToXml(line));
                this.writer.newLine();
                continue;
            }
            if (!line.contains(startAnnotation)) continue;
            if (this.writer == null) {
                this.writer = this.createXiIncludeFile();
            }
            String fileName = file.getName();
            fileName = fileName.substring(0, fileName.lastIndexOf(46)).trim();
            int pos = line.indexOf(startAnnotation);
            String section = line.substring(pos + startAnnotation.length()).trim();
            extract = true;
            this.writer.newLine();
            this.writer.write("<simplesect><title>" + fileName + "_" + section + "</title>");
            this.writer.write("<programlisting id=\"" + fileName + "_" + section + "\">");
        }
    }

    private String converToXml(String line) {
        StringBuffer output = new StringBuffer();
        block5: for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            switch (c) {
                case '<': {
                    output.append("&lt;");
                    continue block5;
                }
                case '>': {
                    output.append("&gt;");
                    continue block5;
                }
                case '&': {
                    output.append("&amp;");
                    continue block5;
                }
                default: {
                    output.append(c);
                }
            }
        }
        return output.toString();
    }

    public BufferedWriter createXiIncludeFile() throws Exception {
        File targetFile = new File(this.outputDirectory, "extracts.xml");
        BufferedWriter writer = new BufferedWriter(new FileWriter(targetFile));
        writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        writer.write("<!DOCTYPE chapter PUBLIC \"-//OASIS//DTD DocBook XML V4.5//EN\"\n");
        writer.write("\"http://www.oasis-open.org/docbook/xml/4.5/docbookx.dtd\">\n");
        writer.write("<chapter>\n");
        writer.write("<title>Code extracts</title>\n");
        return writer;
    }

    public void closeFile(BufferedWriter writer) throws Exception {
        writer.write("");
        writer.newLine();
        writer.write("</chapter>");
        writer.flush();
        writer.close();
    }
}

