/*
 * Decompiled with CFR 0.152.
 */
package org.opencompare.api.java.io;

public class IOCell {
    protected String content;
    protected String rawContent;
    protected int rowspan;
    protected int colspan;

    public IOCell() {
        this("", "", 1, 1);
    }

    public IOCell(String content) {
        this(content, content);
    }

    public IOCell(String content, String rawContent) {
        this(content, rawContent, 1, 1);
    }

    public IOCell(String content, int rowspan, int colspan) {
        this(content, content, rowspan, colspan);
    }

    public IOCell(String content, String rawContent, int rowspan, int colspan) {
        this.setContent(content);
        this.setRawContent(rawContent);
        this.setRowspan(rowspan);
        this.setColspan(colspan);
    }

    public String getContent() {
        return this.content;
    }

    public IOCell setContent(String content) {
        if (content == null) {
            this.content = "";
        }
        this.content = content;
        return this;
    }

    public String getRawContent() {
        return this.rawContent;
    }

    public IOCell setRawContent(String rawContent) {
        if (rawContent == null) {
            this.rawContent = "";
        }
        this.rawContent = rawContent;
        return this;
    }

    public int getRowspan() {
        return this.rowspan;
    }

    public void setRowspan(int rowspan) {
        this.rowspan = rowspan;
    }

    public int getColspan() {
        return this.colspan;
    }

    public void setColspan(int colspan) {
        this.colspan = colspan;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IOCell ioCell = (IOCell)o;
        if (this.content != null ? !this.content.equals(ioCell.content) : ioCell.content != null) {
            return false;
        }
        return !(this.rawContent == null ? ioCell.rawContent != null : !this.rawContent.equals(ioCell.rawContent));
    }

    public int hashCode() {
        int result = this.content != null ? this.content.hashCode() : 0;
        result = 31 * result + (this.rawContent != null ? this.rawContent.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "IOCell{content='" + this.content + '\'' + ", rawContent='" + this.rawContent + '\'' + '}';
    }
}

