/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.docs.tutorial.fund.ml.class101;

import de.bwaldvogel.liblinear.SolverType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openimaj.data.DataSource;
import org.openimaj.data.dataset.GroupedDataset;
import org.openimaj.data.dataset.ListDataset;
import org.openimaj.data.dataset.VFSGroupDataset;
import org.openimaj.experiment.dataset.sampling.GroupSampler;
import org.openimaj.experiment.dataset.sampling.GroupedUniformRandomisedSampler;
import org.openimaj.experiment.dataset.split.GroupedRandomSplitter;
import org.openimaj.experiment.evaluation.classification.ClassificationAnalyser;
import org.openimaj.experiment.evaluation.classification.ClassificationEvaluator;
import org.openimaj.experiment.evaluation.classification.Classifier;
import org.openimaj.experiment.evaluation.classification.analysers.confusionmatrix.CMAnalyser;
import org.openimaj.experiment.evaluation.classification.analysers.confusionmatrix.CMResult;
import org.openimaj.feature.DoubleFV;
import org.openimaj.feature.FeatureExtractor;
import org.openimaj.feature.SparseIntFV;
import org.openimaj.feature.local.data.LocalFeatureListDataSource;
import org.openimaj.feature.local.list.LocalFeatureList;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.annotation.evaluation.datasets.Caltech101;
import org.openimaj.image.feature.dense.gradient.dsift.AbstractDenseSIFT;
import org.openimaj.image.feature.dense.gradient.dsift.DenseSIFT;
import org.openimaj.image.feature.dense.gradient.dsift.PyramidDenseSIFT;
import org.openimaj.image.feature.local.aggregate.BagOfVisualWords;
import org.openimaj.image.feature.local.aggregate.BlockSpatialAggregator;
import org.openimaj.image.feature.local.aggregate.VectorAggregator;
import org.openimaj.io.InputStreamObjectReader;
import org.openimaj.ml.annotation.linear.LiblinearAnnotator;
import org.openimaj.ml.clustering.ByteCentroidsResult;
import org.openimaj.ml.clustering.assignment.HardAssigner;
import org.openimaj.ml.clustering.kmeans.ByteKMeans;
import org.openimaj.util.pair.IntFloatPair;

public class App {
    public static void main(String[] args) throws IOException {
        System.out.println("Load dataset and take a sample");
        VFSGroupDataset allData = Caltech101.getData((InputStreamObjectReader)ImageUtilities.FIMAGE_READER);
        GroupedDataset data = GroupSampler.sample((GroupedDataset)allData, (int)5, (boolean)false);
        System.out.println("Construct the base feature extractor");
        DenseSIFT dsift = new DenseSIFT(5, 7);
        PyramidDenseSIFT pdsift = new PyramidDenseSIFT((AbstractDenseSIFT)dsift, 6.0f, new int[]{7});
        System.out.println("Create training and testing data");
        GroupedRandomSplitter splits = new GroupedRandomSplitter(data, 15, 0, 15);
        System.out.println("Learn a vocabulary");
        HardAssigner<byte[], float[], IntFloatPair> assigner = App.trainQuantiser((GroupedDataset<String, ListDataset<Caltech101.Record<FImage>>, Caltech101.Record<FImage>>)GroupedUniformRandomisedSampler.sample((GroupedDataset)splits.getTrainingDataset(), (int)30), (PyramidDenseSIFT<FImage>)pdsift);
        System.out.println("Define feature extractor");
        SpPHOWExtractorImplementation extractor = new SpPHOWExtractorImplementation((PyramidDenseSIFT<FImage>)pdsift, assigner);
        System.out.println("Construct and train classifier");
        LiblinearAnnotator ann = new LiblinearAnnotator((FeatureExtractor)extractor, LiblinearAnnotator.Mode.MULTICLASS, SolverType.L2R_L2LOSS_SVC, 1.0, 1.0E-5);
        ann.train(splits.getTrainingDataset());
        System.out.println("Evaluate classifier");
        ClassificationEvaluator eval = new ClassificationEvaluator((Classifier)ann, splits.getTestDataset(), (ClassificationAnalyser)new CMAnalyser(CMAnalyser.Strategy.SINGLE));
        Map guesses = eval.evaluate();
        CMResult result = (CMResult)eval.analyse(guesses);
        System.out.println(result.getDetailReport());
    }

    private static HardAssigner<byte[], float[], IntFloatPair> trainQuantiser(GroupedDataset<String, ListDataset<Caltech101.Record<FImage>>, Caltech101.Record<FImage>> sample, PyramidDenseSIFT<FImage> pdsift) {
        List<LocalFeatureList> allkeys = new ArrayList();
        for (Caltech101.Record rec : sample) {
            FImage img = (FImage)rec.getImage();
            pdsift.analyseImage((Image)img);
            allkeys.add(pdsift.getByteKeypoints(0.005f));
        }
        if (allkeys.size() > 10000) {
            allkeys = allkeys.subList(0, 10000);
        }
        ByteKMeans km = ByteKMeans.createKDTreeEnsemble((int)300);
        LocalFeatureListDataSource datasource = new LocalFeatureListDataSource(allkeys);
        ByteCentroidsResult result = km.cluster((DataSource)datasource);
        return result.defaultHardAssigner();
    }

    private static final class SpPHOWExtractorImplementation
    implements FeatureExtractor<DoubleFV, Caltech101.Record<FImage>> {
        PyramidDenseSIFT<FImage> pdsift;
        HardAssigner<byte[], float[], IntFloatPair> assigner;

        public SpPHOWExtractorImplementation(PyramidDenseSIFT<FImage> pdsift, HardAssigner<byte[], float[], IntFloatPair> assigner) {
            this.pdsift = pdsift;
            this.assigner = assigner;
        }

        public DoubleFV extractFeature(Caltech101.Record<FImage> object) {
            FImage image = (FImage)object.getImage();
            this.pdsift.analyseImage((Image)image);
            BagOfVisualWords bovw = new BagOfVisualWords(this.assigner);
            BlockSpatialAggregator spatial = new BlockSpatialAggregator((VectorAggregator)bovw, 2, 2);
            return ((SparseIntFV)spatial.aggregate((List)this.pdsift.getByteKeypoints(0.015f), image.getBounds())).normaliseFV();
        }
    }
}

