/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import processing.app.Base;
import processing.app.Formatter;
import processing.app.Language;
import processing.app.Library;
import processing.app.Messages;
import processing.app.Mode;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.Problem;
import processing.app.RunnerListener;
import processing.app.Sketch;
import processing.app.SketchCode;
import processing.app.SketchException;
import processing.app.Util;
import processing.app.contrib.AvailableContribution;
import processing.app.contrib.Contribution;
import processing.app.contrib.ContributionListing;
import processing.app.contrib.ContributionManager;
import processing.app.contrib.ToolContribution;
import processing.app.syntax.JEditTextArea;
import processing.app.syntax.PdeTextAreaDefaults;
import processing.app.syntax.TextAreaDefaults;
import processing.app.ui.About;
import processing.app.ui.ColorChooser;
import processing.app.ui.Editor;
import processing.app.ui.EditorException;
import processing.app.ui.EditorFooter;
import processing.app.ui.EditorHeader;
import processing.app.ui.EditorState;
import processing.app.ui.EditorToolbar;
import processing.app.ui.Toolkit;
import processing.app.ui.Welcome;
import processing.core.PApplet;
import processing.data.StringList;
import processing.mode.java.AutoFormat;
import processing.mode.java.Debugger;
import processing.mode.java.JavaMode;
import processing.mode.java.JavaToolbar;
import processing.mode.java.VariableInspector;
import processing.mode.java.debug.LineBreakpoint;
import processing.mode.java.debug.LineHighlight;
import processing.mode.java.debug.LineID;
import processing.mode.java.pdex.ImportStatement;
import processing.mode.java.pdex.JavaProblem;
import processing.mode.java.pdex.JavaTextArea;
import processing.mode.java.pdex.PDEX;
import processing.mode.java.pdex.PreprocessingService;
import processing.mode.java.pdex.SourceUtils;
import processing.mode.java.preproc.PdePreprocessor;
import processing.mode.java.runner.Runner;
import processing.mode.java.tweak.ColorControlBox;
import processing.mode.java.tweak.Handle;
import processing.mode.java.tweak.SketchParser;
import processing.mode.java.tweak.TweakClient;

public class JavaEditor
extends Editor {
    JavaMode jmode;
    private Runner runtime;
    private boolean runtimeLaunchRequested;
    private final Object runtimeLock = new Object[0];
    protected final List<LineHighlight> breakpointedLines = new ArrayList<LineHighlight>();
    protected LineHighlight currentLine;
    protected final String breakpointMarkerComment = " //<>//";
    protected JMenu debugMenu;
    protected JMenuItem debugItem;
    protected Debugger debugger;
    protected boolean debugEnabled;
    protected VariableInspector inspector;
    protected JMenuItem inspectorItem;
    static final int ERROR_TAB_INDEX = 0;
    private boolean hasJavaTabs;
    private boolean javaTabWarned;
    protected PreprocessingService preprocessingService;
    protected PDEX pdex;
    private int previousTabCount = 1;
    static final String EXPORT_PREFIX = "export.application.platform_";
    static final String EXPORT_MACOSX = "export.application.platform_macosx";
    static final String EXPORT_WINDOWS = "export.application.platform_windows";
    static final String EXPORT_LINUX = "export.application.platform_linux";
    final JButton exportButton = new JButton(Language.text((String)"prompt.export"));
    final JButton cancelButton = new JButton(Language.text((String)"prompt.cancel"));
    final JCheckBox windowsButton = new JCheckBox("Windows");
    final JCheckBox macosxButton = new JCheckBox("Mac OS X");
    final JCheckBox linuxButton = new JCheckBox("Linux");
    JFrame frmImportSuggest;
    static final String PREF_TWEAK_PORT = "tweak.port";
    static final String PREF_TWEAK_SHOW_CODE = "tweak.showcode";
    public String[] baseCode;
    TweakClient tweakClient;

    protected JavaEditor(Base base, String path, EditorState state, Mode mode) throws EditorException {
        super(base, path, state, mode);
        this.jmode = (JavaMode)mode;
        this.debugger = new Debugger(this);
        this.inspector = new VariableInspector(this);
        for (LineID lineID : this.stripBreakpointComments()) {
            this.debugger.setBreakpoint(lineID);
        }
        this.getSketch().setModified(false);
        this.hasJavaTabs = this.checkForJavaTabs();
        this.preprocessingService = new PreprocessingService(this);
        this.pdex = new PDEX(this, this.preprocessingService);
        Toolkit.setMenuMnemonics((JPopupMenu)this.textarea.getRightClickPopup());
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowLostFocus(WindowEvent e) {
                JavaEditor.this.getJavaTextArea().hideSuggestion();
            }

            @Override
            public void windowGainedFocus(WindowEvent e) {
            }
        });
    }

    public PdePreprocessor createPreprocessor(String sketchName) {
        return new PdePreprocessor(sketchName);
    }

    protected JEditTextArea createTextArea() {
        return new JavaTextArea((TextAreaDefaults)new PdeTextAreaDefaults(this.mode), this);
    }

    public EditorToolbar createToolbar() {
        return new JavaToolbar(this);
    }

    public EditorHeader createHeader() {
        return new EditorHeader(this){

            public void rebuild() {
                super.rebuild();
                boolean newHasJavaTabs = JavaEditor.this.checkForJavaTabs();
                boolean hasJavaTabsChanged = JavaEditor.this.hasJavaTabs != newHasJavaTabs;
                JavaEditor.this.hasJavaTabs = newHasJavaTabs;
                if (JavaEditor.this.preprocessingService != null) {
                    int currentTabCount;
                    if (hasJavaTabsChanged) {
                        JavaEditor.this.preprocessingService.handleHasJavaTabsChange(JavaEditor.this.hasJavaTabs);
                        JavaEditor.this.pdex.hasJavaTabsChanged(JavaEditor.this.hasJavaTabs);
                        if (JavaEditor.this.hasJavaTabs) {
                            JavaEditor.this.setProblemList(Collections.emptyList());
                        }
                    }
                    if ((currentTabCount = JavaEditor.this.sketch.getCodeCount()) != JavaEditor.this.previousTabCount) {
                        JavaEditor.this.previousTabCount = currentTabCount;
                        JavaEditor.this.pdex.sketchChanged();
                    }
                }
            }
        };
    }

    public EditorFooter createFooter() {
        EditorFooter footer = super.createFooter();
        this.addErrorTable(footer);
        return footer;
    }

    public Formatter createFormatter() {
        return new AutoFormat();
    }

    public JMenu buildFileMenu() {
        String appTitle = Language.text((String)"menu.file.export_application");
        JMenuItem exportApplication = Toolkit.newJMenuItemShift((String)appTitle, (int)69);
        exportApplication.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaEditor.this.handleExportApplication();
            }
        });
        return this.buildFileMenu(new JMenuItem[]{exportApplication});
    }

    public JMenu buildSketchMenu() {
        JMenuItem runItem = Toolkit.newJMenuItem((String)Language.text((String)"menu.sketch.run"), (int)82);
        runItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaEditor.this.handleRun();
            }
        });
        JMenuItem presentItem = Toolkit.newJMenuItemShift((String)Language.text((String)"menu.sketch.present"), (int)82);
        presentItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaEditor.this.handlePresent();
            }
        });
        JMenuItem stopItem = new JMenuItem(Language.text((String)"menu.sketch.stop"));
        stopItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JavaEditor.this.isDebuggerEnabled()) {
                    Messages.log((String)"Invoked 'Stop' menu item");
                    JavaEditor.this.debugger.stopDebug();
                } else {
                    JavaEditor.this.handleStop();
                }
            }
        });
        JMenuItem tweakItem = Toolkit.newJMenuItemShift((String)Language.text((String)"menu.sketch.tweak"), (int)84);
        tweakItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaEditor.this.handleTweak();
            }
        });
        return this.buildSketchMenu(new JMenuItem[]{runItem, presentItem, tweakItem, stopItem});
    }

    public JMenu buildHelpMenu() {
        JMenuItem item;
        JMenu menu = new JMenu(Language.text((String)"menu.help"));
        if (!Platform.isMacOS()) {
            item = new JMenuItem(Language.text((String)"menu.help.about"));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new About((Frame)((Object)JavaEditor.this));
                }
            });
            menu.add(item);
        }
        item = new JMenuItem(Language.text((String)"menu.help.welcome"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    new Welcome(JavaEditor.this.base, Preferences.getSketchbookPath().equals(Preferences.getOldSketchbookPath()));
                }
                catch (IOException ioe) {
                    Messages.showWarning((String)"Unwelcome Error", (String)"Please report this error to\nhttps://github.com/processing/processing/issues", (Throwable)ioe);
                }
            }
        });
        menu.add(item);
        item = new JMenuItem(Language.text((String)"menu.help.environment"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaEditor.this.showReference("environment" + File.separator + "index.html");
            }
        });
        menu.add(item);
        item = new JMenuItem(Language.text((String)"menu.help.reference"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaEditor.this.showReference("index.html");
            }
        });
        menu.add(item);
        item = Toolkit.newJMenuItemShift((String)Language.text((String)"menu.help.find_in_reference"), (int)70);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JavaEditor.this.textarea.isSelectionActive()) {
                    JavaEditor.this.handleFindReference();
                } else {
                    JavaEditor.this.statusNotice(Language.text((String)"editor.status.find_reference.select_word_first"));
                }
            }
        });
        menu.add(item);
        menu.addSeparator();
        final JMenu libRefSubmenu = new JMenu(Language.text((String)"menu.help.libraries_reference"));
        libRefSubmenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                boolean isContribLibMenuItemAdded;
                boolean isCoreLibMenuItemAdded = JavaEditor.this.addLibReferencesToSubMenu(((JavaEditor)JavaEditor.this).mode.coreLibraries, libRefSubmenu);
                if (isCoreLibMenuItemAdded && !((JavaEditor)JavaEditor.this).mode.contribLibraries.isEmpty()) {
                    libRefSubmenu.addSeparator();
                }
                if (!(isContribLibMenuItemAdded = JavaEditor.this.addLibReferencesToSubMenu(((JavaEditor)JavaEditor.this).mode.contribLibraries, libRefSubmenu)) && !isCoreLibMenuItemAdded) {
                    JMenuItem emptyMenuItem = new JMenuItem(Language.text((String)"menu.help.empty"));
                    emptyMenuItem.setEnabled(false);
                    emptyMenuItem.setFocusable(false);
                    emptyMenuItem.setFocusPainted(false);
                    libRefSubmenu.add(emptyMenuItem);
                } else if (!isContribLibMenuItemAdded && !((JavaEditor)JavaEditor.this).mode.coreLibraries.isEmpty()) {
                    libRefSubmenu.removeAll();
                    JavaEditor.this.addLibReferencesToSubMenu(((JavaEditor)JavaEditor.this).mode.coreLibraries, libRefSubmenu);
                }
            }

            @Override
            public void menuDeselected(MenuEvent e) {
                libRefSubmenu.removeAll();
            }

            @Override
            public void menuCanceled(MenuEvent e) {
                this.menuDeselected(e);
            }
        });
        menu.add(libRefSubmenu);
        final JMenu toolRefSubmenu = new JMenu(Language.text((String)"menu.help.tools_reference"));
        toolRefSubmenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                boolean isCoreToolMenuItemAdded = false;
                boolean isContribToolMenuItemAdded = false;
                List contribTools = JavaEditor.this.base.getToolContribs();
                isCoreToolMenuItemAdded = JavaEditor.this.addToolReferencesToSubMenu(JavaEditor.this.base.getCoreTools(), toolRefSubmenu);
                if (isCoreToolMenuItemAdded && !contribTools.isEmpty()) {
                    toolRefSubmenu.addSeparator();
                }
                if (!(isContribToolMenuItemAdded = JavaEditor.this.addToolReferencesToSubMenu(contribTools, toolRefSubmenu)) && !isCoreToolMenuItemAdded) {
                    toolRefSubmenu.removeAll();
                    JMenuItem emptyMenuItem = new JMenuItem(Language.text((String)"menu.help.empty"));
                    emptyMenuItem.setEnabled(false);
                    emptyMenuItem.setBorderPainted(false);
                    emptyMenuItem.setFocusable(false);
                    emptyMenuItem.setFocusPainted(false);
                    toolRefSubmenu.add(emptyMenuItem);
                } else if (!isContribToolMenuItemAdded && !contribTools.isEmpty()) {
                    toolRefSubmenu.removeAll();
                    JavaEditor.this.addToolReferencesToSubMenu(JavaEditor.this.base.getCoreTools(), toolRefSubmenu);
                }
            }

            @Override
            public void menuDeselected(MenuEvent e) {
                toolRefSubmenu.removeAll();
            }

            @Override
            public void menuCanceled(MenuEvent e) {
                this.menuDeselected(e);
            }
        });
        menu.add(toolRefSubmenu);
        menu.addSeparator();
        item = new JMenuItem(Language.text((String)"menu.help.online"));
        item.setEnabled(false);
        menu.add(item);
        item = new JMenuItem(Language.text((String)"menu.help.getting_started"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Platform.openURL((String)Language.text((String)"menu.help.getting_started.url"));
            }
        });
        menu.add(item);
        item = new JMenuItem(Language.text((String)"menu.help.troubleshooting"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Platform.openURL((String)Language.text((String)"menu.help.troubleshooting.url"));
            }
        });
        menu.add(item);
        item = new JMenuItem(Language.text((String)"menu.help.faq"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Platform.openURL((String)Language.text((String)"menu.help.faq.url"));
            }
        });
        menu.add(item);
        item = new JMenuItem(Language.text((String)"menu.help.foundation"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Platform.openURL((String)Language.text((String)"menu.help.foundation.url"));
            }
        });
        menu.add(item);
        item = new JMenuItem(Language.text((String)"menu.help.visit"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Platform.openURL((String)Language.text((String)"menu.help.visit.url"));
            }
        });
        menu.add(item);
        return menu;
    }

    private boolean addLibReferencesToSubMenu(List<Library> libsList, JMenu subMenu) {
        boolean isItemAdded = false;
        for (final Library libContrib : libsList) {
            if (!libContrib.hasReference()) continue;
            JMenuItem libRefItem = new JMenuItem(libContrib.getName());
            libRefItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    JavaEditor.this.showReferenceFile(libContrib.getReferenceIndexFile());
                }
            });
            subMenu.add(libRefItem);
            isItemAdded = true;
        }
        return isItemAdded;
    }

    private boolean addToolReferencesToSubMenu(List<ToolContribution> toolsList, JMenu subMenu) {
        boolean isItemAdded = false;
        for (ToolContribution toolContrib : toolsList) {
            final File toolRef = new File(toolContrib.getFolder(), "reference/index.html");
            if (!toolRef.exists()) continue;
            JMenuItem libRefItem = new JMenuItem(toolContrib.getName());
            libRefItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    JavaEditor.this.showReferenceFile(toolRef);
                }
            });
            subMenu.add(libRefItem);
            isItemAdded = true;
        }
        return isItemAdded;
    }

    public String getCommentPrefix() {
        return "//";
    }

    public void handleExportApplication() {
        if (this.handleExportCheckModified()) {
            this.statusNotice(Language.text((String)"export.notice.exporting"));
            try {
                if (this.exportApplicationPrompt()) {
                    Platform.openFolder((File)this.sketch.getFolder());
                    this.statusNotice(Language.text((String)"export.notice.exporting.done"));
                }
            }
            catch (Exception e) {
                this.statusNotice(Language.text((String)"export.notice.exporting.error"));
                e.printStackTrace();
            }
        }
    }

    protected void updateExportButton() {
        this.exportButton.setEnabled(this.windowsButton.isSelected() || this.macosxButton.isSelected() || this.linuxButton.isSelected());
    }

    protected boolean exportApplicationPrompt() throws IOException, SketchException {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(Box.createVerticalStrut(6));
        String line1 = Language.text((String)"export.description.line1");
        String line2 = Language.text((String)"export.description.line2");
        JLabel label1 = new JLabel(line1, 0);
        JLabel label2 = new JLabel(line2, 0);
        label1.setAlignmentX(0.0f);
        label2.setAlignmentX(0.0f);
        panel.add(label1);
        panel.add(label2);
        panel.add(Box.createVerticalStrut(12));
        this.windowsButton.setSelected(Preferences.getBoolean((String)EXPORT_WINDOWS));
        this.windowsButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Preferences.setBoolean((String)JavaEditor.EXPORT_WINDOWS, (boolean)JavaEditor.this.windowsButton.isSelected());
                JavaEditor.this.updateExportButton();
            }
        });
        if (!Platform.isMacOS()) {
            Preferences.setBoolean((String)EXPORT_MACOSX, (boolean)false);
        }
        this.macosxButton.setSelected(Preferences.getBoolean((String)EXPORT_MACOSX));
        this.macosxButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Preferences.setBoolean((String)JavaEditor.EXPORT_MACOSX, (boolean)JavaEditor.this.macosxButton.isSelected());
                JavaEditor.this.updateExportButton();
            }
        });
        if (!Platform.isMacOS()) {
            this.macosxButton.setEnabled(false);
            this.macosxButton.setToolTipText(Language.text((String)"export.tooltip.macosx"));
        }
        this.linuxButton.setSelected(Preferences.getBoolean((String)EXPORT_LINUX));
        this.linuxButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Preferences.setBoolean((String)JavaEditor.EXPORT_LINUX, (boolean)JavaEditor.this.linuxButton.isSelected());
                JavaEditor.this.updateExportButton();
            }
        });
        this.updateExportButton();
        JPanel platformPanel = new JPanel();
        platformPanel.add(this.windowsButton);
        platformPanel.add(Box.createHorizontalStrut(6));
        platformPanel.add(this.macosxButton);
        platformPanel.add(Box.createHorizontalStrut(6));
        platformPanel.add(this.linuxButton);
        platformPanel.setBorder(new TitledBorder(Language.text((String)"export.platforms")));
        platformPanel.setAlignmentX(0.0f);
        panel.add(platformPanel);
        int divWidth = platformPanel.getPreferredSize().width;
        int indent = 0;
        final JCheckBox showStopButton = new JCheckBox(Language.text((String)"export.options.show_stop_button"));
        showStopButton.setSelected(Preferences.getBoolean((String)"export.application.stop"));
        showStopButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Preferences.setBoolean((String)"export.application.stop", (boolean)showStopButton.isSelected());
            }
        });
        showStopButton.setEnabled(Preferences.getBoolean((String)"export.application.present"));
        showStopButton.setBorder(new EmptyBorder(3, 13 + indent, 6, 13));
        final JCheckBox presentButton = new JCheckBox(Language.text((String)"export.options.present"));
        presentButton.setSelected(Preferences.getBoolean((String)"export.application.present"));
        presentButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean sal = presentButton.isSelected();
                Preferences.setBoolean((String)"export.application.present", (boolean)sal);
                showStopButton.setEnabled(sal);
            }
        });
        presentButton.setBorder(new EmptyBorder(3, 13, 3, 13));
        JPanel presentPanel = new JPanel();
        presentPanel.setLayout(new BoxLayout(presentPanel, 1));
        Box fullScreenBox = Box.createHorizontalBox();
        fullScreenBox.add(presentButton);
        fullScreenBox.add(new ColorPreference("run.present.bgcolor"));
        fullScreenBox.add(Box.createHorizontalStrut(10));
        fullScreenBox.add(Box.createHorizontalGlue());
        presentPanel.add(fullScreenBox);
        Box showStopBox = Box.createHorizontalBox();
        showStopBox.add(showStopButton);
        showStopBox.add(new ColorPreference("run.present.stop.color"));
        showStopBox.add(Box.createHorizontalStrut(10));
        showStopBox.add(Box.createHorizontalGlue());
        presentPanel.add(showStopBox);
        presentPanel.setBorder(new TitledBorder(Language.text((String)"export.full_screen")));
        presentPanel.setAlignmentX(0.0f);
        panel.add(presentPanel);
        JPanel embedPanel = new JPanel();
        embedPanel.setLayout(new BoxLayout(embedPanel, 1));
        String platformName = null;
        if (Platform.isMacOS()) {
            platformName = "Mac OS X";
        } else if (Platform.isWindows()) {
            platformName = "Windows (" + Platform.getNativeBits() + "-bit)";
        } else if (Platform.isLinux()) {
            platformName = "Linux (" + Platform.getNativeBits() + "-bit)";
        }
        boolean embed = Preferences.getBoolean((String)"export.application.embed_java");
        final String embedWarning = "<html><div width=\"" + divWidth + "\"><font size=\"2\">Embedding Java will make the " + platformName + " application larger, but it will be far more likely to work. Users on other platforms will need to <a href=\"\">install Java " + PApplet.javaPlatform + "</a>.";
        final String nopeWarning = "<html><div width=\"" + divWidth + "\"><font size=\"2\">Users on all platforms will have to install the latest version of Java " + PApplet.javaPlatform + " from <a href=\"\">http://java.com/download</a>. <br/>&nbsp;";
        final JLabel warningLabel = new JLabel(embed ? embedWarning : nopeWarning);
        warningLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                Platform.openURL((String)"http://java.com/download");
            }
        });
        warningLabel.setBorder(new EmptyBorder(3, 13 + indent, 3, 13));
        final JCheckBox embedJavaButton = new JCheckBox(Language.text((String)"export.embed_java.for") + " " + platformName);
        embedJavaButton.setSelected(embed);
        embedJavaButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean selected = embedJavaButton.isSelected();
                Preferences.setBoolean((String)"export.application.embed_java", (boolean)selected);
                if (selected) {
                    warningLabel.setText(embedWarning);
                } else {
                    warningLabel.setText(nopeWarning);
                }
            }
        });
        embedJavaButton.setBorder(new EmptyBorder(3, 13, 3, 13));
        embedPanel.add(embedJavaButton);
        embedPanel.add(warningLabel);
        embedPanel.setBorder(new TitledBorder(Language.text((String)"export.embed_java")));
        panel.add(embedPanel);
        if (Platform.isMacOS()) {
            JPanel signPanel = new JPanel();
            signPanel.setLayout(new BoxLayout(signPanel, 1));
            signPanel.setBorder(new TitledBorder(Language.text((String)"export.code_signing")));
            String thePain = "In recent versions of OS X, Apple has introduced the \u201cGatekeeper\u201d system, which makes it more difficult to run applications like those exported from Processing. ";
            thePain = new File("/usr/bin/codesign_allocate").exists() ? thePain + "This application will be \u201cself-signed\u201d which means that Finder may report that the application is from an \u201cunidentified developer\u201d. If the application will not run, try right-clicking the app and selecting Open from the pop-up menu. Or you can visit System Preferences \u2192 Security & Privacy and select Allow apps downloaded from: anywhere. " : thePain + "Gatekeeper requires applications to be \u201csigned\u201d, or they will be reported as damaged. To prevent this message, install Xcode (and the Command Line Tools) from the App Store, or visit System Preferences \u2192 Security & Privacy and select Allow apps downloaded from: anywhere. ";
            thePain = thePain + "To avoid the messages entirely, manually code sign your app. For more information: <a href=\"\">https://developer.apple.com/developer-id/</a>";
            JLabel area = new JLabel("<html><div width=\"" + divWidth + "\"><font size=\"2\">" + thePain + "</div></html>");
            area.setBorder(new EmptyBorder(3, 13, 3, 13));
            signPanel.add(area);
            signPanel.setAlignmentX(0.0f);
            area.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent event) {
                    Platform.openURL((String)"https://developer.apple.com/developer-id/");
                }
            });
            panel.add(signPanel);
        }
        Object[] options = new JButton[]{this.exportButton, this.cancelButton};
        final JOptionPane optionPane = new JOptionPane(panel, -1, 0, null, options, this.exportButton);
        final JDialog dialog = new JDialog((Frame)((Object)this), Language.text((String)"export"), true);
        dialog.setContentPane(optionPane);
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                optionPane.setValue(JavaEditor.this.exportButton);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                optionPane.setValue(JavaEditor.this.cancelButton);
            }
        });
        optionPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String prop = e.getPropertyName();
                if (dialog.isVisible() && e.getSource() == optionPane && prop.equals("value")) {
                    dialog.setVisible(false);
                }
            }
        });
        dialog.pack();
        dialog.setResizable(false);
        Rectangle bounds = this.getBounds();
        dialog.setLocation(bounds.x + (bounds.width - dialog.getSize().width) / 2, bounds.y + (bounds.height - dialog.getSize().height) / 2);
        dialog.setVisible(true);
        Object value = optionPane.getValue();
        if (value.equals(this.exportButton)) {
            return this.jmode.handleExportApplication(this.sketch);
        }
        if (value.equals(this.cancelButton) || value.equals(-1)) {
            this.statusNotice(Language.text((String)"export.notice.exporting.cancel"));
        }
        return false;
    }

    protected boolean handleExportCheckModified() {
        if (this.sketch.isReadOnly()) {
            Messages.showMessage((String)Language.text((String)"export.messages.is_read_only"), (String)Language.text((String)"export.messages.is_read_only.description"));
            return false;
        }
        if (this.sketch.isUntitled()) {
            Messages.showMessage((String)Language.text((String)"export.messages.cannot_export"), (String)Language.text((String)"export.messages.cannot_export.description"));
            return false;
        }
        if (this.sketch.isModified()) {
            Object[] options = new Object[]{Language.text((String)"prompt.ok"), Language.text((String)"prompt.cancel")};
            int result = JOptionPane.showOptionDialog((Component)((Object)this), Language.text((String)"export.unsaved_changes"), Language.text((String)"menu.file.save"), 2, 3, null, options, options[0]);
            if (result == 0) {
                this.handleSave(true);
            } else {
                this.statusNotice(Language.text((String)"export.notice.cancel.unsaved_changes"));
                return false;
            }
        }
        return true;
    }

    public void handleRun() {
        if (this.isDebuggerEnabled()) {
            if (this.debugger.isStarted()) {
                this.debugger.stopDebug();
            }
            this.debugger.continueDebug();
        } else {
            this.handleLaunch(false, false);
        }
    }

    public void handlePresent() {
        this.handleLaunch(true, false);
    }

    public void handleTweak() {
        this.autoSave();
        if (this.sketch.isModified()) {
            Messages.showMessage((String)Language.text((String)"menu.file.save"), (String)Language.text((String)"tweak_mode.save_before_tweak"));
            return;
        }
        this.handleLaunch(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleLaunch(boolean present, boolean tweak) {
        this.prepareRun();
        this.toolbar.activateRun();
        Object object = this.runtimeLock;
        synchronized (object) {
            this.runtimeLaunchRequested = true;
        }
        new Thread(() -> {
            try {
                Object object = this.runtimeLock;
                synchronized (object) {
                    if (this.runtimeLaunchRequested) {
                        this.runtimeLaunchRequested = false;
                        this.runtime = !tweak ? this.jmode.handleLaunch(this.sketch, (RunnerListener)this, present) : this.jmode.handleTweak(this.sketch, (RunnerListener)this);
                    }
                }
            }
            catch (Exception e) {
                EventQueue.invokeLater(() -> this.statusError(e));
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleStop() {
        if (this.debugger.isStarted()) {
            this.debugger.stopDebug();
        } else {
            this.toolbar.activateStop();
            try {
                Object object = this.runtimeLock;
                synchronized (object) {
                    if (this.runtimeLaunchRequested) {
                        this.runtimeLaunchRequested = false;
                    }
                    if (this.runtime != null) {
                        this.runtime.close();
                        this.runtime = null;
                    }
                }
            }
            catch (Exception e) {
                this.statusError(e);
            }
            this.toolbar.deactivateStop();
            this.toolbar.deactivateRun();
            this.toFront();
        }
    }

    public void handleStep(int modifiers) {
        if (modifiers == 0) {
            Messages.log((String)"Invoked 'Step Over' menu item");
            this.debugger.stepOver();
        } else if ((modifiers & 1) != 0) {
            Messages.log((String)"Invoked 'Step Into' menu item");
            this.debugger.stepInto();
        } else if ((modifiers & 8) != 0) {
            Messages.log((String)"Invoked 'Step Out' menu item");
            this.debugger.stepOut();
        }
    }

    public void handleContinue() {
        Messages.log((String)"Invoked 'Continue' menu item");
        this.debugger.continueDebug();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRunnerExiting(Runner runner) {
        Object object = this.runtimeLock;
        synchronized (object) {
            if (this.runtime == runner) {
                this.deactivateRun();
            }
        }
    }

    public void toggleBreakpoint(int lineIndex) {
        this.debugger.toggleBreakpoint(lineIndex);
    }

    public boolean handleSaveAs() {
        String oldName = this.getSketch().getCode(0).getFileName();
        boolean saved = super.handleSaveAs();
        if (saved) {
            List<LineBreakpoint> bps = this.debugger.getBreakpoints(oldName);
            this.debugger.clearBreakpoints(oldName);
            String newName = this.getSketch().getCode(0).getFileName();
            for (LineBreakpoint bp : bps) {
                LineID line = new LineID(newName, bp.lineID().lineIdx());
                this.debugger.setBreakpoint(line);
            }
            for (SketchCode code : this.getSketch().getCode()) {
                this.addBreakpointComments(code.getFileName());
            }
        }
        return saved;
    }

    public void handleImportLibrary(String libraryName) {
        Library lib;
        this.sketch.ensureExistence();
        if (this.mode.isDefaultExtension(this.sketch.getCurrentCode())) {
            this.sketch.setCurrentCode(0);
        }
        if ((lib = this.mode.findLibraryByName(libraryName)) == null) {
            this.statusError("Unable to locate library: " + libraryName);
            return;
        }
        StringList list = lib.getImports();
        if (list == null) {
            list = Util.packageListFromClassPath((String)lib.getJarPath());
        }
        StringBuilder sb = new StringBuilder();
        for (String item : list) {
            sb.append("import ");
            sb.append(item);
            sb.append(".*;\n");
        }
        sb.append('\n');
        sb.append(this.getText());
        this.setText(sb.toString());
        this.setSelection(0, 0);
        this.sketch.setModified(true);
    }

    public void librariesChanged() {
        this.preprocessingService.notifyLibrariesChanged();
    }

    public void codeFolderChanged() {
        this.preprocessingService.notifyCodeFolderChanged();
    }

    public void sketchChanged() {
        this.preprocessingService.notifySketchChanged();
    }

    public void statusError(String what) {
        super.statusError(what);
        this.toolbar.deactivateRun();
    }

    public void internalCloseRunner() {
        this.handleStop();
    }

    public void dispose() {
        if (this.debugEnabled) {
            this.debugger.stopDebug();
        }
        if (this.inspector != null) {
            this.inspector.dispose();
        }
        this.preprocessingService.dispose();
        this.pdex.dispose();
        super.dispose();
    }

    protected JMenu buildDebugMenu() {
        this.debugMenu = new JMenu(Language.text((String)"menu.debug"));
        this.debugItem = Toolkit.newJMenuItem((String)Language.text((String)"menu.debug.enable"), (int)68);
        this.debugItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaEditor.this.toggleDebug();
            }
        });
        this.debugMenu.add(this.debugItem);
        this.debugMenu.addSeparator();
        JMenuItem item = Toolkit.newJMenuItem((String)Language.text((String)"menu.debug.continue"), (int)85);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaEditor.this.handleContinue();
            }
        });
        this.debugMenu.add(item);
        item.setEnabled(false);
        item = Toolkit.newJMenuItem((String)Language.text((String)"menu.debug.step"), (int)74);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaEditor.this.handleStep(0);
            }
        });
        this.debugMenu.add(item);
        item.setEnabled(false);
        item = Toolkit.newJMenuItemShift((String)Language.text((String)"menu.debug.step_into"), (int)74);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaEditor.this.handleStep(1);
            }
        });
        this.debugMenu.add(item);
        item.setEnabled(false);
        item = Toolkit.newJMenuItemAlt((String)Language.text((String)"menu.debug.step_out"), (int)74);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaEditor.this.handleStep(8);
            }
        });
        this.debugMenu.add(item);
        item.setEnabled(false);
        this.debugMenu.addSeparator();
        item = Toolkit.newJMenuItem((String)Language.text((String)"menu.debug.toggle_breakpoint"), (int)66);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Messages.log((String)"Invoked 'Toggle Breakpoint' menu item");
                JavaEditor.this.toggleBreakpoint(JavaEditor.this.getCurrentLineID().lineIdx());
            }
        });
        this.debugMenu.add(item);
        item.setEnabled(false);
        return this.debugMenu;
    }

    public boolean isDebuggerEnabled() {
        return this.debugEnabled;
    }

    public JMenu buildModeMenu() {
        return this.buildDebugMenu();
    }

    protected List<LineID> stripBreakpointComments() {
        ArrayList<LineID> bps = new ArrayList<LineID>();
        Sketch sketch = this.getSketch();
        for (int i = 0; i < sketch.getCodeCount(); ++i) {
            SketchCode tab = sketch.getCode(i);
            String code = tab.getProgram();
            String[] lines = code.split("\\r?\\n");
            int lineIdx = 0;
            for (String line : lines) {
                if (line.endsWith(" //<>//")) {
                    LineID lineID = new LineID(tab.getFileName(), lineIdx);
                    bps.add(lineID);
                    int index = line.lastIndexOf(" //<>//");
                    lines[lineIdx] = line.substring(0, index);
                }
                ++lineIdx;
            }
            code = PApplet.join((String[])lines, (String)"\n");
            this.setTabContents(tab.getFileName(), code);
        }
        return bps;
    }

    protected void addBreakpointComments(String tabFilename) {
        SketchCode tab = this.getTab(tabFilename);
        if (tab == null) {
            Messages.loge((String)("Illegal tab name to addBreakpointComments() " + tabFilename));
            return;
        }
        List<LineBreakpoint> bps = this.debugger.getBreakpoints(tab.getFileName());
        try {
            tab.load();
            String code = tab.getProgram();
            String[] lines = code.split("\\r?\\n");
            for (LineBreakpoint bp : bps) {
                int n = bp.lineID().lineIdx();
                lines[n] = lines[n] + " //<>//";
            }
            code = PApplet.join((String[])lines, (String)"\n");
            tab.setProgram(code);
            tab.save();
        }
        catch (IOException ex) {
            Messages.loge(null, (Throwable)ex);
        }
    }

    public boolean handleSave(boolean immediately) {
        final ArrayList<String> modified = new ArrayList<String>();
        for (int i = 0; i < this.getSketch().getCodeCount(); ++i) {
            SketchCode tab = this.getSketch().getCode(i);
            if (!tab.isModified()) continue;
            modified.add(tab.getFileName());
        }
        boolean saved = super.handleSave(immediately);
        if (saved) {
            if (immediately) {
                for (String tabFilename : modified) {
                    this.addBreakpointComments(tabFilename);
                }
            } else {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        for (String tabFilename : modified) {
                            JavaEditor.this.addBreakpointComments(tabFilename);
                        }
                    }
                });
            }
        }
        return saved;
    }

    protected void setTabContents(String tabFilename, String code) {
        this.debugger.clearBreakpoints(tabFilename);
        SketchCode currentTab = this.getCurrentTab();
        SketchCode tab = this.getTab(tabFilename);
        if (tab != null) {
            tab.setProgram(code);
            tab.setDocument(null);
            this.setCode(tab);
            this.setCode(currentTab);
        }
    }

    public void clearConsole() {
        this.console.clear();
    }

    public void clearSelection() {
        this.setSelection(this.getCaretOffset(), this.getCaretOffset());
    }

    public void selectLine(int lineIdx) {
        this.setSelection(this.getLineStartOffset(lineIdx), this.getLineStopOffset(lineIdx));
    }

    public void cursorToLineStart(int lineIdx) {
        this.setSelection(this.getLineStartOffset(lineIdx), this.getLineStartOffset(lineIdx));
    }

    public void cursorToLineEnd(int lineIdx) {
        this.setSelection(this.getLineStopOffset(lineIdx), this.getLineStopOffset(lineIdx));
    }

    public void switchToTab(String tabFileName) {
        Sketch s = this.getSketch();
        for (int i = 0; i < s.getCodeCount(); ++i) {
            if (!tabFileName.equals(s.getCode(i).getFileName())) continue;
            s.setCurrentCode(i);
            break;
        }
    }

    public Debugger getDebugger() {
        return this.debugger;
    }

    public JavaTextArea getJavaTextArea() {
        return (JavaTextArea)this.textarea;
    }

    public PreprocessingService getPreprocessingService() {
        return this.preprocessingService;
    }

    public void prepareRun() {
        this.autoSave();
        super.prepareRun();
        this.downloadImports();
        this.preprocessingService.cancel();
    }

    protected void downloadImports() {
        for (SketchCode sc : this.sketch.getCode()) {
            String tabCode;
            List<ImportStatement> imports;
            if (!sc.isExtension("pde") || (imports = SourceUtils.parseProgramImports(tabCode = sc.getProgram())).isEmpty()) continue;
            ArrayList<String> importHeaders = new ArrayList<String>();
            for (ImportStatement importStatement : imports) {
                importHeaders.add(importStatement.getFullClassName());
            }
            List<AvailableContribution> installLibsHeaders = this.getNotInstalledAvailableLibs(importHeaders);
            if (installLibsHeaders.isEmpty()) continue;
            StringBuilder libList = new StringBuilder("Would you like to install them now?");
            for (AvailableContribution ac : installLibsHeaders) {
                libList.append("\n  \u2022 ").append(ac.getName());
            }
            int option = Messages.showYesNoQuestion((Frame)((Object)this), (String)Language.text((String)"contrib.import.dialog.title"), (String)Language.text((String)"contrib.import.dialog.primary_text"), (String)libList.toString());
            if (option != 0) continue;
            ContributionManager.downloadAndInstallOnImport((Base)this.base, installLibsHeaders);
        }
    }

    private List<AvailableContribution> getNotInstalledAvailableLibs(ArrayList<String> importHeadersList) {
        Map importMap = ContributionListing.getInstance().getLibrariesByImportHeader();
        ArrayList<AvailableContribution> libList = new ArrayList<AvailableContribution>();
        for (String importHeaders : importHeadersList) {
            int dot = importHeaders.lastIndexOf(46);
            String entry = dot == -1 ? importHeaders : importHeaders.substring(0, dot);
            if (entry.startsWith("java.") || entry.startsWith("javax.") || entry.startsWith("processing.")) continue;
            Library library = null;
            try {
                Contribution c;
                library = this.getMode().getLibrary(entry);
                if (library != null || (c = (Contribution)importMap.get(importHeaders)) == null || !(c instanceof AvailableContribution)) continue;
                libList.add((AvailableContribution)c);
            }
            catch (Exception e) {
                Contribution c = (Contribution)importMap.get(importHeaders);
                if (c == null || !(c instanceof AvailableContribution)) continue;
                libList.add((AvailableContribution)c);
            }
        }
        return libList;
    }

    protected void autoSave() {
        if (!JavaMode.autoSaveEnabled) {
            return;
        }
        try {
            if (this.sketch.isModified() && !this.sketch.isUntitled()) {
                if (JavaMode.autoSavePromptEnabled) {
                    final JDialog autoSaveDialog = new JDialog((Frame)this.base.getActiveEditor(), this.getSketch().getName(), true);
                    Container container = autoSaveDialog.getContentPane();
                    JPanel panelMain = new JPanel();
                    panelMain.setBorder(BorderFactory.createEmptyBorder(4, 0, 2, 2));
                    panelMain.setLayout(new BoxLayout(panelMain, 3));
                    JPanel panelLabel = new JPanel(new FlowLayout(0));
                    JLabel label = new JLabel("<html><body>&nbsp;There are unsaved changes in your sketch.<br />&nbsp;&nbsp;&nbsp; Do you want to save it before running? </body></html>");
                    label.setFont(new Font(label.getFont().getName(), 0, label.getFont().getSize() + 1));
                    panelLabel.add(label);
                    panelMain.add(panelLabel);
                    final JCheckBox dontRedisplay = new JCheckBox("Remember this decision");
                    JPanel panelButtons = new JPanel(new FlowLayout(1, 8, 2));
                    JButton btnRunSave = new JButton("Save and Run");
                    btnRunSave.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            JavaEditor.this.handleSave(true);
                            if (dontRedisplay.isSelected()) {
                                JavaMode.autoSavePromptEnabled = !dontRedisplay.isSelected();
                                JavaMode.defaultAutoSaveEnabled = true;
                                JavaEditor.this.jmode.savePreferences();
                            }
                            autoSaveDialog.dispose();
                        }
                    });
                    panelButtons.add(btnRunSave);
                    JButton btnRunNoSave = new JButton("Run, Don't Save");
                    btnRunNoSave.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (dontRedisplay.isSelected()) {
                                JavaMode.autoSavePromptEnabled = !dontRedisplay.isSelected();
                                JavaMode.defaultAutoSaveEnabled = false;
                                JavaEditor.this.jmode.savePreferences();
                            }
                            autoSaveDialog.dispose();
                        }
                    });
                    panelButtons.add(btnRunNoSave);
                    panelMain.add(panelButtons);
                    JPanel panelCheck = new JPanel();
                    panelCheck.setLayout(new FlowLayout(1, 0, 0));
                    panelCheck.add(dontRedisplay);
                    panelMain.add(panelCheck);
                    container.add(panelMain);
                    autoSaveDialog.setResizable(false);
                    autoSaveDialog.pack();
                    autoSaveDialog.setLocationRelativeTo((Component)this.base.getActiveEditor());
                    autoSaveDialog.setVisible(true);
                } else if (JavaMode.defaultAutoSaveEnabled) {
                    this.handleSave(true);
                }
            }
        }
        catch (Exception e) {
            this.statusError(e);
        }
    }

    public VariableInspector variableInspector() {
        return this.inspector;
    }

    protected void activateRun() {
        this.debugItem.setEnabled(false);
        this.toolbar.activateRun();
    }

    public void deactivateRun() {
        this.toolbar.deactivateRun();
        this.debugItem.setEnabled(true);
    }

    protected void activateDebug() {
        this.activateRun();
    }

    protected void deactivateDebug() {
        this.deactivateRun();
    }

    protected void activateContinue() {
        ((JavaToolbar)this.toolbar).activateContinue();
    }

    protected void deactivateContinue() {
        ((JavaToolbar)this.toolbar).deactivateContinue();
    }

    protected void activateStep() {
        ((JavaToolbar)this.toolbar).activateStep();
    }

    protected void deactivateStep() {
        ((JavaToolbar)this.toolbar).deactivateStep();
    }

    public void toggleDebug() {
        this.debugEnabled = !this.debugEnabled;
        this.rebuildToolbar();
        this.repaint();
        if (this.debugEnabled) {
            this.debugItem.setText(Language.text((String)"menu.debug.disable"));
        } else {
            this.debugItem.setText(Language.text((String)"menu.debug.enable"));
        }
        this.inspector.setVisible(this.debugEnabled);
        for (Component item : this.debugMenu.getMenuComponents()) {
            if (!(item instanceof JMenuItem) || item == this.debugItem) continue;
            item.setEnabled(this.debugEnabled);
        }
    }

    public void setCurrentLine(LineID line) {
        this.clearCurrentLine();
        if (line == null) {
            return;
        }
        this.switchToTab(line.fileName());
        this.cursorToLineStart(line.lineIdx());
        this.currentLine = new LineHighlight(line.lineIdx(), this);
        this.currentLine.setMarker("->");
        this.currentLine.setPriority(10);
    }

    public void clearCurrentLine() {
        if (this.currentLine != null) {
            this.currentLine.clear();
            this.currentLine.dispose();
            for (LineHighlight hl : this.breakpointedLines) {
                if (!hl.getLineID().equals(this.currentLine.getLineID())) continue;
                hl.paint();
                break;
            }
            this.currentLine = null;
        }
    }

    public void addBreakpointedLine(LineID lineID) {
        LineHighlight hl = new LineHighlight(lineID, this);
        hl.setMarker("<>");
        this.breakpointedLines.add(hl);
        if (this.currentLine != null && this.currentLine.getLineID().equals(lineID)) {
            this.currentLine.paint();
        }
    }

    public void removeBreakpointedLine(int lineIdx) {
        LineID line = this.getLineIDInCurrentTab(lineIdx);
        LineHighlight foundLine = null;
        for (LineHighlight hl : this.breakpointedLines) {
            if (!hl.getLineID().equals(line)) continue;
            foundLine = hl;
            break;
        }
        if (foundLine != null) {
            foundLine.clear();
            this.breakpointedLines.remove(foundLine);
            foundLine.dispose();
            if (this.currentLine != null && this.currentLine.getLineID().equals(line)) {
                this.currentLine.paint();
            }
        }
    }

    public void clearBreakpointedLines() {
        for (LineHighlight hl : this.breakpointedLines) {
            hl.clear();
            hl.dispose();
        }
        this.breakpointedLines.clear();
        this.getJavaTextArea().clearGutterText();
        if (this.currentLine != null) {
            this.currentLine.paint();
        }
    }

    public LineID getLineIDInCurrentTab(int lineIdx) {
        return new LineID(this.getSketch().getCurrentCode().getFileName(), lineIdx);
    }

    protected LineID getCurrentLineID() {
        String tab = this.getSketch().getCurrentCode().getFileName();
        int lineNo = this.getTextArea().getCaretLine();
        return new LineID(tab, lineNo);
    }

    public boolean isInCurrentTab(LineID line) {
        return line.fileName().equals(this.getSketch().getCurrentCode().getFileName());
    }

    public void setCode(SketchCode code) {
        JavaTextArea ta;
        Document oldDoc = code.getDocument();
        super.setCode(code);
        Document newDoc = code.getDocument();
        if (oldDoc != newDoc && this.pdex != null) {
            this.pdex.documentChanged(newDoc);
        }
        if ((ta = this.getJavaTextArea()) != null) {
            ta.clearGutterText();
            if (this.breakpointedLines != null) {
                for (LineHighlight hl : this.breakpointedLines) {
                    if (!this.isInCurrentTab(hl.getLineID())) continue;
                    hl.paint();
                }
            }
            if (this.currentLine != null && this.isInCurrentTab(this.currentLine.getLineID())) {
                this.currentLine.paint();
            }
        }
        if (this.getDebugger() != null && this.getDebugger().isStarted()) {
            this.getDebugger().startTrackingLineChanges();
        }
        if (this.errorColumn != null) {
            this.errorColumn.repaint();
        }
    }

    public SketchCode getTab(String filename) {
        Sketch s = this.getSketch();
        for (SketchCode c : s.getCode()) {
            if (!c.getFileName().equals(filename)) continue;
            return c;
        }
        return null;
    }

    public SketchCode getCurrentTab() {
        return this.getSketch().getCurrentCode();
    }

    public Document currentDocument() {
        return this.getCurrentTab().getDocument();
    }

    public void statusBusy() {
        this.statusNotice(Language.text((String)"editor.status.debug.busy"));
    }

    public void statusHalted() {
        this.statusNotice(Language.text((String)"editor.status.debug.halt"));
    }

    public void updateErrorTable(List<Problem> problems) {
        this.errorTable.clearRows();
        for (Problem p : problems) {
            JavaProblem jp = (JavaProblem)p;
            String message = p.getMessage();
            if (JavaMode.importSuggestEnabled && jp.getImportSuggestions() != null && jp.getImportSuggestions().length > 0) {
                message = message + " (double-click for suggestions)";
            }
            this.errorTable.addRow(p, message, this.sketch.getCode(jp.getTabIndex()).getPrettyName(), Integer.toString(p.getLineNumber() + 1));
        }
    }

    public void errorTableDoubleClick(Object item) {
        JavaProblem p = (JavaProblem)item;
        String[] suggs = p.getImportSuggestions();
        if (suggs != null && suggs.length > 0) {
            String[] list = p.getImportSuggestions();
            String className = list[0].substring(list[0].lastIndexOf(46) + 1);
            String[] temp = new String[list.length];
            for (int i = 0; i < list.length; ++i) {
                temp[i] = "<html>Import '" + className + "' <font color=#777777>(" + list[i] + ")</font></html>";
            }
            Point mouse = MouseInfo.getPointerInfo().getLocation();
            this.showImportSuggestion(temp, mouse.x, mouse.y);
        } else {
            this.errorTableClick(item);
        }
    }

    private void showImportSuggestion(String[] list, int x, int y) {
        if (this.frmImportSuggest != null) {
            return;
        }
        final JList<String> classList = new JList<String>(list);
        classList.setSelectionMode(0);
        this.frmImportSuggest = new JFrame();
        this.frmImportSuggest.setUndecorated(true);
        this.frmImportSuggest.setDefaultCloseOperation(2);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBackground(Color.WHITE);
        this.frmImportSuggest.setBackground(Color.WHITE);
        panel.add(classList);
        JLabel label = new JLabel("<html><div alight = \"left\"><font size = \"2\"><br>(Click to insert)</font></div></html>");
        label.setBackground(Color.WHITE);
        label.setHorizontalTextPosition(2);
        panel.add(label);
        panel.validate();
        this.frmImportSuggest.getContentPane().add(panel);
        this.frmImportSuggest.pack();
        classList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (classList.getSelectedValue() != null) {
                    try {
                        String t = ((String)classList.getSelectedValue()).trim();
                        Messages.log((String)t);
                        int x = t.indexOf(40);
                        String impString = "import " + t.substring(x + 1, t.indexOf(41)) + ";\n";
                        int ct = JavaEditor.this.getSketch().getCurrentCodeIndex();
                        JavaEditor.this.getSketch().setCurrentCode(0);
                        JavaEditor.this.getTextArea().getDocument().insertString(0, impString, null);
                        JavaEditor.this.getSketch().setCurrentCode(ct);
                    }
                    catch (BadLocationException ble) {
                        Messages.log((String)"Failed to insert import");
                        ble.printStackTrace();
                    }
                }
                JavaEditor.this.frmImportSuggest.setVisible(false);
                JavaEditor.this.frmImportSuggest.dispose();
                JavaEditor.this.frmImportSuggest = null;
            }
        });
        this.frmImportSuggest.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowLostFocus(WindowEvent e) {
                if (JavaEditor.this.frmImportSuggest != null) {
                    JavaEditor.this.frmImportSuggest.dispose();
                    JavaEditor.this.frmImportSuggest = null;
                }
            }

            @Override
            public void windowGainedFocus(WindowEvent e) {
            }
        });
        this.frmImportSuggest.setLocation(x, y);
        this.frmImportSuggest.setBounds(x, y, 250, 100);
        this.frmImportSuggest.pack();
        this.frmImportSuggest.setVisible(true);
    }

    public boolean hasJavaTabs() {
        return this.hasJavaTabs;
    }

    private boolean checkForJavaTabs() {
        for (SketchCode code : this.getSketch().getCode()) {
            if (!code.getExtension().equals("java")) continue;
            if (!this.javaTabWarned) {
                System.out.println(this.getSketch().getName() + " contains .java tabs. ");
                System.out.println("Some editor features (like completion and error checking) will be disabled.");
                this.javaTabWarned = true;
            }
            return true;
        }
        return false;
    }

    protected void applyPreferences() {
        super.applyPreferences();
        if (this.jmode != null) {
            this.jmode.loadPreferences();
            Messages.log((String)"Applying prefs");
            this.pdex.preferencesChanged();
        }
    }

    protected void startTweakMode() {
        this.getJavaTextArea().startTweakMode();
    }

    protected void stopTweakMode(List<List<Handle>> handles) {
        this.tweakClient.shutdown();
        this.getJavaTextArea().stopTweakMode();
        boolean[] tweakedTabs = JavaEditor.getTweakedTabs(handles);
        boolean modified = JavaEditor.anythingTrue(tweakedTabs);
        if (modified) {
            if (Messages.showYesNoQuestion((Frame)((Object)this), (String)Language.text((String)"tweak_mode"), (String)Language.text((String)"tweak_mode.keep_changes.line1"), (String)Language.text((String)"tweak_mode.keep_changes.line2")) == 0) {
                for (int i = 0; i < this.sketch.getCodeCount(); ++i) {
                    if (tweakedTabs[i]) {
                        this.sketch.getCode(i).setModified(true);
                        continue;
                    }
                    this.sketch.getCode(i).setProgram(this.sketch.getCode(i).getSavedProgram());
                    this.sketch.getCode(i).setDocument(null);
                    if (i != this.sketch.getCurrentCodeIndex()) continue;
                    this.setCode(this.sketch.getCurrentCode());
                }
                try {
                    this.sketch.save();
                }
                catch (IOException e) {
                    Messages.showWarning((String)"Error", (String)"Could not save the modified sketch.", (Throwable)e);
                }
                this.header.repaint();
                this.textarea.invalidate();
            } else {
                this.loadSavedCode();
                this.textarea.invalidate();
            }
        } else {
            this.loadSavedCode();
            this.textarea.invalidate();
        }
    }

    private static boolean anythingTrue(boolean[] list) {
        for (boolean b : list) {
            if (!b) continue;
            return true;
        }
        return false;
    }

    protected void updateInterface(List<List<Handle>> handles, List<List<ColorControlBox>> colorBoxes) {
        this.getJavaTextArea().updateInterface(handles, colorBoxes);
    }

    private static boolean[] getTweakedTabs(List<List<Handle>> handles) {
        boolean[] outgoing = new boolean[handles.size()];
        for (int i = 0; i < handles.size(); ++i) {
            for (Handle h : handles.get(i)) {
                if (!h.valueChanged()) continue;
                outgoing[i] = true;
            }
        }
        return outgoing;
    }

    protected void initBaseCode() {
        SketchCode[] code = this.sketch.getCode();
        this.baseCode = new String[code.length];
        for (int i = 0; i < code.length; ++i) {
            this.baseCode[i] = code[i].getSavedProgram();
        }
    }

    protected void initEditorCode(List<List<Handle>> handles, boolean withSpaces) {
        SketchCode[] sketchCode = this.sketch.getCode();
        for (int tab = 0; tab < this.baseCode.length; ++tab) {
            int charInc = 0;
            String code = this.baseCode[tab];
            for (Handle n : handles.get(tab)) {
                int s = n.startChar + charInc;
                int e = n.endChar + charInc;
                String newStr = n.strNewValue;
                if (withSpaces) {
                    newStr = "  " + newStr + "  ";
                }
                code = JavaEditor.replaceString(code, s, e, newStr);
                n.newStartChar = n.startChar + charInc;
                charInc += n.strNewValue.length() - n.strValue.length();
                if (withSpaces) {
                    charInc += 4;
                }
                n.newEndChar = n.endChar + charInc;
            }
            sketchCode[tab].setProgram(code);
            sketchCode[tab].setDocument(null);
        }
        this.setCode(this.sketch.getCurrentCode());
    }

    private void loadSavedCode() {
        SketchCode[] code = this.sketch.getCode();
        for (int i = 0; i < code.length; ++i) {
            if (code[i].getProgram().equals(code[i].getSavedProgram())) continue;
            code[i].setProgram(code[i].getSavedProgram());
            code[i].setDocument(null);
        }
        this.setCode(this.sketch.getCurrentCode());
    }

    protected boolean automateSketch(Sketch sketch, SketchParser parser) {
        int tab;
        SketchCode[] code = sketch.getCode();
        List<List<Handle>> handles = parser.allHandles;
        if (code.length < 1) {
            return false;
        }
        if (handles.size() == 0) {
            return false;
        }
        int afterSizePos = SketchParser.getAfterSizePos(this.baseCode[0]);
        if (afterSizePos < 0) {
            return false;
        }
        String portStr = Preferences.get((String)PREF_TWEAK_PORT);
        if (portStr == null) {
            Preferences.set((String)PREF_TWEAK_PORT, (String)"auto");
            portStr = "auto";
        }
        int port = portStr.equals("auto") ? (int)(Math.random() * 16383.0) + 49152 : Preferences.getInteger((String)PREF_TWEAK_PORT);
        this.tweakClient = new TweakClient(port);
        for (tab = 0; tab < code.length; ++tab) {
            for (Handle h : handles.get(tab)) {
                h.setTweakClient(this.tweakClient);
            }
        }
        for (tab = 0; tab < code.length; ++tab) {
            int charInc = 0;
            String c = this.baseCode[tab];
            for (Handle handle : handles.get(tab)) {
                c = JavaEditor.replaceString(c, handle.startChar + charInc, handle.endChar + charInc, handle.name);
                charInc += handle.name.length() - handle.strValue.length();
            }
            code[tab].setProgram(c);
        }
        String c = code[0].getProgram();
        String header = "\n\n/*************************/\n/* MODIFIED BY TWEAKMODE */\n/*************************/\n\n\n";
        header = header + "import java.net.*;\n";
        header = header + "import java.io.*;\n";
        header = header + "import java.nio.*;\n\n";
        int numOfInts = JavaEditor.howManyInts(handles);
        int numOfFloats = JavaEditor.howManyFloats(handles);
        if (numOfInts > 0) {
            header = header + "int[] tweakmode_int = new int[" + numOfInts + "];\n";
        }
        if (numOfFloats > 0) {
            header = header + "float[] tweakmode_float = new float[" + numOfFloats + "];\n\n";
        }
        header = header + "TweakModeServer tweakmode_Server;\n";
        header = header + "void tweakmode_initAllVars() {\n";
        for (List<Handle> list : handles) {
            for (Handle n : list) {
                header = header + "  " + n.name + " = " + n.strValue + ";\n";
            }
        }
        header = header + "}\n\n";
        header = header + "void tweakmode_initCommunication() {\n";
        header = header + " tweakmode_Server = new TweakModeServer();\n";
        header = header + " tweakmode_Server.setup();\n";
        header = header + " tweakmode_Server.start();\n";
        header = header + "}\n";
        header = header + "\n\n\n\n\n";
        String string = "\n\n\n  /* TWEAKMODE */\n    tweakmode_initAllVars();\n    tweakmode_initCommunication();\n  /* TWEAKMODE */\n\n";
        afterSizePos = SketchParser.getAfterSizePos(c);
        c = JavaEditor.replaceString(c, afterSizePos, afterSizePos, string);
        String string2 = TweakClient.getServerCode(port, numOfInts > 0, numOfFloats > 0);
        code[0].setProgram(header + c + string2);
        String showModCode = Preferences.get((String)PREF_TWEAK_SHOW_CODE);
        if (showModCode == null) {
            Preferences.setBoolean((String)PREF_TWEAK_SHOW_CODE, (boolean)false);
        }
        if (Preferences.getBoolean((String)PREF_TWEAK_SHOW_CODE)) {
            System.out.println("\nTweakMode modified code:\n");
            for (int i = 0; i < code.length; ++i) {
                System.out.println("tab " + i + "\n");
                System.out.println("=======================================================\n");
                System.out.println(code[i].getProgram());
            }
        }
        return true;
    }

    private static String replaceString(String str, int start, int end, String put) {
        return str.substring(0, start) + put + str.substring(end, str.length());
    }

    private static int howManyInts(List<List<Handle>> handles) {
        int count = 0;
        for (List<Handle> list : handles) {
            for (Handle n : list) {
                if (!"int".equals(n.type) && !"hex".equals(n.type) && !"webcolor".equals(n.type)) continue;
                ++count;
            }
        }
        return count;
    }

    private static int howManyFloats(List<List<Handle>> handles) {
        int count = 0;
        for (List<Handle> list : handles) {
            for (Handle n : list) {
                if (!"float".equals(n.type)) continue;
                ++count;
            }
        }
        return count;
    }

    class ColorPreference
    extends JPanel
    implements ActionListener {
        ColorChooser chooser;
        String prefName;

        public ColorPreference(String pref) {
            this.prefName = pref;
            this.setBorder(BorderFactory.createBevelBorder(1));
            this.setPreferredSize(new Dimension(30, 20));
            this.setMaximumSize(new Dimension(30, 20));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    Color color = Preferences.getColor((String)ColorPreference.this.prefName);
                    ColorPreference.this.chooser = new ColorChooser((Frame)((Object)JavaEditor.this), true, color, Language.text((String)"color_chooser.select"), (ActionListener)ColorPreference.this);
                    ColorPreference.this.chooser.show();
                }
            });
        }

        @Override
        public void paintComponent(Graphics g) {
            g.setColor(Preferences.getColor((String)this.prefName));
            Dimension size = this.getSize();
            g.fillRect(0, 0, size.width, size.height);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Color color = this.chooser.getColor();
            Preferences.setColor((String)this.prefName, (Color)color);
            this.repaint();
            this.chooser.hide();
        }
    }
}

