/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.pdex;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.List;
import processing.app.SketchCode;
import processing.app.syntax.JEditTextArea;
import processing.app.syntax.PdeTextAreaPainter;
import processing.app.syntax.TextAreaDefaults;
import processing.mode.java.JavaEditor;
import processing.mode.java.pdex.JavaTextArea;
import processing.mode.java.tweak.ColorControlBox;
import processing.mode.java.tweak.ColorSelector;
import processing.mode.java.tweak.Handle;
import processing.mode.java.tweak.Settings;

public class JavaTextAreaPainter
extends PdeTextAreaPainter {
    protected int horizontalAdjustment = 0;
    public boolean tweakMode = false;
    public List<List<Handle>> handles;
    public List<List<ColorControlBox>> colorBoxes;
    public Handle mouseHandle = null;
    public ColorSelector colorSelector;
    int cursorType;
    BufferedImage cursorImg = new BufferedImage(16, 16, 2);
    Cursor blankCursor;

    public JavaTextAreaPainter(JavaTextArea textArea, TextAreaDefaults defaults) {
        super((JEditTextArea)textArea, defaults);
        Dimension cursorSize = Toolkit.getDefaultToolkit().getBestCursorSize(16, 16);
        this.blankCursor = cursorSize.width == 0 || cursorSize.height == 0 ? Cursor.getDefaultCursor() : Toolkit.getDefaultToolkit().createCustomCursor(this.cursorImg, new Point(0, 0), "blank cursor");
        this.tweakMode = false;
        this.cursorType = 0;
    }

    public synchronized void paint(Graphics gfx) {
        super.paint(gfx);
        if (this.tweakMode && this.handles != null) {
            int y;
            int x;
            int lineStartChar;
            int currentTab = this.getCurrentCodeIndex();
            Graphics2D g2d = (Graphics2D)gfx;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            for (Handle n : this.handles.get(currentTab)) {
                lineStartChar = this.textArea.getLineStartOffset(n.line);
                x = this.textArea.offsetToX(n.line, n.newStartChar - lineStartChar);
                y = this.textArea.lineToY(n.line) + this.fm.getHeight() + 1;
                int end = this.textArea.offsetToX(n.line, n.newEndChar - lineStartChar);
                n.setPos(x, y);
                n.setWidth(end - x);
                n.draw(g2d, n == this.mouseHandle);
            }
            for (ColorControlBox cBox : this.colorBoxes.get(currentTab)) {
                lineStartChar = this.textArea.getLineStartOffset(cBox.getLine());
                x = this.textArea.offsetToX(cBox.getLine(), cBox.getCharIndex() - lineStartChar);
                y = this.textArea.lineToY(cBox.getLine()) + this.fm.getDescent();
                cBox.setPos(x, y + 1);
                cBox.draw(g2d);
            }
        }
    }

    protected void startTweakMode() {
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (JavaTextAreaPainter.this.mouseHandle != null) {
                    JavaTextAreaPainter.this.mouseHandle.resetProgress();
                    JavaTextAreaPainter.this.mouseHandle = null;
                    JavaTextAreaPainter.this.updateCursor(e.getX(), e.getY());
                    JavaTextAreaPainter.this.repaint();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                int currentTab = JavaTextAreaPainter.this.getCurrentCodeIndex();
                for (Handle n : JavaTextAreaPainter.this.handles.get(currentTab)) {
                    if (!n.pick(e.getX(), e.getY())) continue;
                    JavaTextAreaPainter.this.cursorType = -1;
                    JavaTextAreaPainter.this.setCursor(JavaTextAreaPainter.this.blankCursor);
                    JavaTextAreaPainter.this.mouseHandle = n;
                    JavaTextAreaPainter.this.mouseHandle.setCenterX(e.getX());
                    JavaTextAreaPainter.this.repaint();
                    return;
                }
                for (ColorControlBox box : JavaTextAreaPainter.this.colorBoxes.get(currentTab)) {
                    if (!box.pick(e.getX(), e.getY())) continue;
                    if (JavaTextAreaPainter.this.colorSelector != null) {
                        JavaTextAreaPainter.this.colorSelector.frame.dispatchEvent(new WindowEvent(JavaTextAreaPainter.this.colorSelector.frame, 201));
                    }
                    JavaTextAreaPainter.this.colorSelector = new ColorSelector(box);
                    JavaTextAreaPainter.this.colorSelector.frame.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent e) {
                            JavaTextAreaPainter.this.colorSelector.frame.setVisible(false);
                            JavaTextAreaPainter.this.colorSelector = null;
                        }
                    });
                    JavaTextAreaPainter.this.colorSelector.show(JavaTextAreaPainter.this.getLocationOnScreen().x + e.getX() + 30, JavaTextAreaPainter.this.getLocationOnScreen().y + e.getY() - 130);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent e) {
                JavaTextAreaPainter.this.updateCursor(e.getX(), e.getY());
                if (!Settings.alwaysShowColorBoxes) {
                    JavaTextAreaPainter.this.showHideColorBoxes(e.getY());
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (JavaTextAreaPainter.this.mouseHandle != null) {
                    JavaTextAreaPainter.this.mouseHandle.setCurrentX(e.getX());
                    JavaTextAreaPainter.this.updateCodeText();
                    if (JavaTextAreaPainter.this.colorSelector != null) {
                        JavaTextAreaPainter.this.colorSelector.refreshColor();
                    }
                    JavaTextAreaPainter.this.repaint();
                }
            }
        });
        this.tweakMode = true;
        this.setCursor(new Cursor(0));
        this.repaint();
    }

    protected void stopTweakMode() {
        this.tweakMode = false;
        if (this.colorSelector != null) {
            this.colorSelector.hide();
            WindowEvent windowEvent = new WindowEvent(this.colorSelector.frame, 201);
            this.colorSelector.frame.dispatchEvent(windowEvent);
        }
        this.setCursor(new Cursor(2));
        this.repaint();
    }

    protected void updateTweakInterface(List<List<Handle>> handles, List<List<ColorControlBox>> colorBoxes) {
        this.handles = handles;
        this.colorBoxes = colorBoxes;
        this.updateTweakInterfacePositions();
        this.repaint();
    }

    private synchronized void updateTweakInterfacePositions() {
        SketchCode[] code = this.getEditor().getSketch().getCode();
        int prevScroll = this.textArea.getVerticalScrollPosition();
        String prevText = this.textArea.getText();
        for (int tab = 0; tab < code.length; ++tab) {
            int x;
            int lineStartChar;
            String tabCode = this.getJavaEditor().baseCode[tab];
            this.textArea.setText(tabCode);
            for (Handle n : this.handles.get(tab)) {
                lineStartChar = this.textArea.getLineStartOffset(n.line);
                x = this.textArea.offsetToX(n.line, n.newStartChar - lineStartChar);
                int end = this.textArea.offsetToX(n.line, n.newEndChar - lineStartChar);
                int y = this.textArea.lineToY(n.line) + this.fm.getHeight() + 1;
                n.initInterface(x, y, end - x, this.fm.getHeight());
            }
            for (ColorControlBox cBox : this.colorBoxes.get(tab)) {
                lineStartChar = this.textArea.getLineStartOffset(cBox.getLine());
                x = this.textArea.offsetToX(cBox.getLine(), cBox.getCharIndex() - lineStartChar);
                int y = this.textArea.lineToY(cBox.getLine()) + this.fm.getDescent();
                cBox.initInterface(this, x, y + 1, this.fm.getHeight() - 2, this.fm.getHeight() - 2);
            }
        }
        this.textArea.setText(prevText);
        this.textArea.scrollTo(prevScroll, 0);
    }

    public void updateCodeText() {
        int charInc = 0;
        int currentTab = this.getCurrentCodeIndex();
        SketchCode sc = this.getEditor().getSketch().getCode(currentTab);
        String code = this.getJavaEditor().baseCode[currentTab];
        for (Handle n : this.handles.get(currentTab)) {
            int s = n.startChar + charInc;
            int e = n.endChar + charInc;
            code = JavaTextAreaPainter.replaceString(code, s, e, n.strNewValue);
            n.newStartChar = n.startChar + charInc;
            n.newEndChar = n.endChar + (charInc += n.strNewValue.length() - n.strValue.length());
        }
        this.replaceTextAreaCode(code);
        sc.setProgram(code);
    }

    private synchronized void replaceTextAreaCode(String code) {
        int scrollLine = this.textArea.getVerticalScrollPosition();
        int scrollHor = this.textArea.getHorizontalScrollPosition();
        this.textArea.setText(code);
        this.textArea.setOrigin(scrollLine, -scrollHor);
    }

    private static String replaceString(String str, int start, int end, String put) {
        return str.substring(0, start) + put + str.substring(end, str.length());
    }

    private void updateCursor(int mouseX, int mouseY) {
        int currentTab = this.getCurrentCodeIndex();
        for (Handle n : this.handles.get(currentTab)) {
            if (!n.pick(mouseX, mouseY)) continue;
            this.cursorType = 10;
            this.setCursor(new Cursor(this.cursorType));
            return;
        }
        for (ColorControlBox colorBox : this.colorBoxes.get(currentTab)) {
            if (!colorBox.pick(mouseX, mouseY)) continue;
            this.cursorType = 12;
            this.setCursor(new Cursor(this.cursorType));
            return;
        }
        if (this.cursorType == 10 || this.cursorType == 12 || this.cursorType == -1) {
            this.cursorType = 0;
            this.setCursor(new Cursor(this.cursorType));
        }
    }

    private void showHideColorBoxes(int y) {
        int currentTab = this.getCurrentCodeIndex();
        boolean change = false;
        for (ColorControlBox box : this.colorBoxes.get(currentTab)) {
            if (!box.setMouseY(y)) continue;
            change = true;
        }
        if (this.colorSelector != null) {
            this.colorSelector.colorBox.visible = true;
        }
        if (change) {
            this.repaint();
        }
    }

    private JavaEditor getJavaEditor() {
        return (JavaEditor)this.getEditor();
    }

    private int getCurrentCodeIndex() {
        return this.getEditor().getSketch().getCurrentCodeIndex();
    }
}

