/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.tweak;

public class ColorMode {
    static final int RGB = 0;
    static final int HSB = 1;
    float v1Max;
    float v2Max;
    float v3Max;
    float aMax;
    int modeType;
    boolean unrecognizedMode;
    String drawContext;

    public ColorMode(String context) {
        this.drawContext = context;
        this.modeType = 0;
        this.v1Max = 255.0f;
        this.v2Max = 255.0f;
        this.v3Max = 255.0f;
        this.aMax = 255.0f;
        this.unrecognizedMode = false;
    }

    public ColorMode(String context, int type, float v1, float v2, float v3, float a) {
        this.drawContext = context;
        this.modeType = type;
        this.v1Max = v1;
        this.v2Max = v2;
        this.v3Max = v3;
        this.aMax = a;
        this.unrecognizedMode = false;
    }

    public static ColorMode fromString(String context, String mode) {
        try {
            String[] elements = mode.split(",");
            int type = 0;
            if (elements[0].trim().equals("HSB")) {
                type = 1;
            }
            if (elements.length == 1) {
                return new ColorMode(context, type, 255.0f, 255.0f, 255.0f, 255.0f);
            }
            if (elements.length == 2) {
                float max = Float.parseFloat(elements[1].trim());
                return new ColorMode(context, type, max, max, max, max);
            }
            if (elements.length == 4) {
                float r = Float.parseFloat(elements[1].trim());
                float g = Float.parseFloat(elements[2].trim());
                float b = Float.parseFloat(elements[3].trim());
                return new ColorMode(context, type, r, g, b, 255.0f);
            }
            if (elements.length == 5) {
                float r = Float.parseFloat(elements[1].trim());
                float g = Float.parseFloat(elements[2].trim());
                float b = Float.parseFloat(elements[3].trim());
                float a = Float.parseFloat(elements[4].trim());
                return new ColorMode(context, type, r, g, b, a);
            }
        }
        catch (Exception elements) {
            // empty catch block
        }
        ColorMode newMode = new ColorMode(context);
        newMode.unrecognizedMode = true;
        return newMode;
    }

    public String toString() {
        String type = this.modeType == 0 ? "RGB" : "HSB";
        return "ColorMode: " + type + ": (" + this.v1Max + ", " + this.v2Max + ", " + this.v3Max + ", " + this.aMax + ")";
    }
}

