/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.tools.ToolProvider;
import org.revapi.AnalysisContext;
import org.revapi.Difference;
import org.revapi.DifferenceAnalyzer;
import org.revapi.Element;
import org.revapi.Report;
import org.revapi.Stats;
import org.revapi.java.AnalysisConfiguration;
import org.revapi.java.Timing;
import org.revapi.java.compilation.CompilationValve;
import org.revapi.java.compilation.ProbingEnvironment;
import org.revapi.java.model.AnnotationElement;
import org.revapi.java.model.FieldElement;
import org.revapi.java.model.MethodElement;
import org.revapi.java.model.MethodParameterElement;
import org.revapi.java.model.TypeElement;
import org.revapi.java.spi.Check;
import org.revapi.java.spi.JavaAnnotationElement;
import org.revapi.java.spi.JavaElement;
import org.revapi.java.spi.JavaFieldElement;
import org.revapi.java.spi.JavaMethodElement;
import org.revapi.java.spi.JavaMethodParameterElement;
import org.revapi.java.spi.JavaModelElement;
import org.revapi.java.spi.JavaTypeElement;
import org.revapi.java.spi.TypeEnvironment;
import org.revapi.java.spi.UseSite;
import org.revapi.java.spi.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JavaElementDifferenceAnalyzer
implements DifferenceAnalyzer {
    private static final Logger LOG = LoggerFactory.getLogger(JavaElementDifferenceAnalyzer.class);
    private static final Map<Check.Type, Set<Check.Type>> POSSIBLE_CHILDREN_TYPES;
    private static final Method CLEAR_COMPILER_CACHE;
    private static final Object SHARED_ZIP_FILE_INDEX_CACHE;
    private final CompilationValve oldCompilationValve;
    private final CompilationValve newCompilationValve;
    private final AnalysisConfiguration analysisConfiguration;
    private final ResourceBundle messages;
    private final ProbingEnvironment oldEnvironment;
    private final ProbingEnvironment newEnvironment;
    private final Map<Check.Type, List<Check>> checksByInterest;
    private final Deque<CheckType> checkTypeStack = new ArrayDeque<CheckType>();
    private final Deque<Collection<Check>> checksStack = new ArrayDeque<Collection<Check>>();
    private List<Difference> lastAnnotationResults;
    private boolean nonExistenceMode;
    private Element nonExistenceOldRoot;
    private Element nonExistenceNewRoot;
    private final Map<Check.Type, Set<Check>> descendingChecksByTypes;

    public JavaElementDifferenceAnalyzer(AnalysisContext analysisContext, ProbingEnvironment oldEnvironment, CompilationValve oldValve, ProbingEnvironment newEnvironment, CompilationValve newValve, Iterable<Check> checks, AnalysisConfiguration analysisConfiguration) {
        this.oldCompilationValve = oldValve;
        this.newCompilationValve = newValve;
        this.descendingChecksByTypes = new HashMap<Check.Type, Set<Check>>();
        for (Check c2 : checks) {
            c2.initialize(analysisContext);
            c2.setOldTypeEnvironment((TypeEnvironment)oldEnvironment);
            c2.setNewTypeEnvironment((TypeEnvironment)newEnvironment);
            if (!c2.isDescendingOnNonExisting()) continue;
            c2.getInterest().forEach(t -> this.descendingChecksByTypes.computeIfAbsent((Check.Type)t, __ -> new HashSet()).add(c2));
        }
        this.analysisConfiguration = analysisConfiguration;
        this.messages = ResourceBundle.getBundle("org.revapi.java.messages", analysisContext.getLocale());
        this.oldEnvironment = oldEnvironment;
        this.newEnvironment = newEnvironment;
        this.checksByInterest = new EnumMap<Check.Type, List<Check>>(Check.Type.class);
        checks.forEach(c -> c.getInterest().forEach(i -> this.checksByInterest.computeIfAbsent((Check.Type)i, __ -> new ArrayList()).add(c)));
    }

    public void open() {
        Timing.LOG.debug("Opening difference analyzer.");
    }

    public void close() {
        Timing.LOG.debug("About to close difference analyzer.");
        this.oldCompilationValve.removeCompiledResults();
        this.newCompilationValve.removeCompiledResults();
        JavaElementDifferenceAnalyzer.forceClearCompilerCache();
        Timing.LOG.debug("Difference analyzer closed.");
    }

    public void beginAnalysis(@Nullable Element oldElement, @Nullable Element newElement) {
        Collection possibleChecks;
        Timing.LOG.trace("Beginning analysis of {} and {}.", (Object)oldElement, (Object)newElement);
        Check.Type elementsType = this.getCheckType(oldElement, newElement);
        Collection collection = possibleChecks = this.nonExistenceMode ? (Collection)this.descendingChecksByTypes.getOrDefault(elementsType, Collections.emptySet()) : (Collection)this.checksByInterest.get(elementsType);
        if (this.conforms(oldElement, newElement, TypeElement.class)) {
            this.checkTypeStack.push(CheckType.CLASS);
            this.checksStack.push(possibleChecks);
            this.lastAnnotationResults = null;
            for (Check c : possibleChecks) {
                Stats.of((String)c.getClass().getName()).start();
                c.visitClass((JavaTypeElement)(oldElement == null ? null : (TypeElement)oldElement), (JavaTypeElement)(newElement == null ? null : (TypeElement)newElement));
                Stats.of((String)c.getClass().getName()).end((Object)oldElement, (Object)newElement);
            }
        } else if (this.conforms(oldElement, newElement, AnnotationElement.class)) {
            if (this.lastAnnotationResults == null) {
                this.lastAnnotationResults = new ArrayList<Difference>(4);
            }
            for (Check c : possibleChecks) {
                Stats.of((String)c.getClass().getName()).start();
                List cps = c.visitAnnotation((JavaAnnotationElement)(oldElement == null ? null : (AnnotationElement)oldElement), (JavaAnnotationElement)(newElement == null ? null : (AnnotationElement)newElement));
                if (cps != null) {
                    this.lastAnnotationResults.addAll(cps);
                }
                Stats.of((String)c.getClass().getName()).end((Object)oldElement, (Object)newElement);
            }
        } else if (this.conforms(oldElement, newElement, FieldElement.class)) {
            this.doRestrictedCheck((FieldElement)oldElement, (FieldElement)newElement, CheckType.FIELD, possibleChecks);
        } else if (this.conforms(oldElement, newElement, MethodElement.class)) {
            this.doRestrictedCheck((MethodElement)oldElement, (MethodElement)newElement, CheckType.METHOD, possibleChecks);
        } else if (this.conforms(oldElement, newElement, MethodParameterElement.class)) {
            this.doRestrictedCheck((MethodParameterElement)oldElement, (MethodParameterElement)newElement, CheckType.METHOD_PARAMETER, possibleChecks);
        }
        if (!(this.nonExistenceMode || oldElement != null && newElement != null)) {
            this.nonExistenceMode = true;
            this.nonExistenceOldRoot = oldElement;
            this.nonExistenceNewRoot = newElement;
        }
    }

    public boolean isDescendRequired(@Nullable Element oldElement, @Nullable Element newElement) {
        if (oldElement != null && newElement != null) {
            return true;
        }
        Check.Type type = this.getCheckType(oldElement, newElement);
        if (type == null) {
            return false;
        }
        Set<Check.Type> possibleChildren = POSSIBLE_CHILDREN_TYPES.get(type);
        return this.descendingChecksByTypes.keySet().stream().anyMatch(possibleChildren::contains);
    }

    private <T extends JavaModelElement> void doRestrictedCheck(T oldElement, T newElement, CheckType interest, Collection<Check> possibleChecks) {
        this.lastAnnotationResults = null;
        if (!this.isCheckedElsewhere(oldElement, this.oldEnvironment) || !this.isCheckedElsewhere(newElement, this.newEnvironment)) {
            this.checkTypeStack.push(interest);
            this.checksStack.push(possibleChecks);
            for (Check c : possibleChecks) {
                Stats.of((String)c.getClass().getName()).start();
                switch (interest) {
                    case FIELD: {
                        c.visitField((JavaFieldElement)((FieldElement)oldElement), (JavaFieldElement)((FieldElement)newElement));
                        break;
                    }
                    case METHOD: {
                        c.visitMethod((JavaMethodElement)((MethodElement)oldElement), (JavaMethodElement)((MethodElement)newElement));
                        break;
                    }
                    case METHOD_PARAMETER: {
                        c.visitMethodParameter((JavaMethodParameterElement)((MethodParameterElement)oldElement), (JavaMethodParameterElement)((MethodParameterElement)newElement));
                    }
                }
                Stats.of((String)c.getClass().getName()).end(oldElement, newElement);
            }
        } else {
            this.checkTypeStack.push(CheckType.NONE);
            this.checksStack.push(Collections.emptyList());
        }
    }

    public Report endAnalysis(@Nullable Element oldElement, @Nullable Element newElement) {
        if (oldElement == this.nonExistenceOldRoot && newElement == this.nonExistenceNewRoot) {
            this.nonExistenceMode = false;
            this.nonExistenceOldRoot = null;
            this.nonExistenceNewRoot = null;
        }
        if (this.conforms(oldElement, newElement, AnnotationElement.class)) {
            return new Report(Collections.emptyList(), oldElement, newElement);
        }
        ArrayList<Difference> differences = new ArrayList<Difference>();
        CheckType lastInterest = this.checkTypeStack.pop();
        if (lastInterest.isConcrete()) {
            for (Check c : this.checksStack.pop()) {
                List p = c.visitEnd();
                if (p == null) continue;
                differences.addAll(p);
            }
        }
        if (this.lastAnnotationResults != null && !this.lastAnnotationResults.isEmpty()) {
            differences.addAll(this.lastAnnotationResults);
            this.lastAnnotationResults.clear();
        }
        if (!differences.isEmpty()) {
            LOG.trace("Detected following problems: {}", differences);
        }
        Timing.LOG.trace("Ended analysis of {} and {}.", (Object)oldElement, (Object)newElement);
        ListIterator<Difference> it = differences.listIterator();
        while (it.hasNext()) {
            Difference d = (Difference)it.next();
            if (this.analysisConfiguration.reportUseForAllDifferences() || this.analysisConfiguration.getUseReportingCodes().contains(d.code)) {
                StringBuilder oldUseChain = null;
                StringBuilder newUseChain = null;
                if (oldElement != null) {
                    oldUseChain = new StringBuilder();
                    this.appendUses(this.oldEnvironment, oldElement, oldUseChain);
                }
                if (newElement != null) {
                    newUseChain = new StringBuilder();
                    this.appendUses(this.newEnvironment, newElement, newUseChain);
                }
                HashMap<String, String> atts = new HashMap<String, String>(d.attachments);
                if (oldUseChain != null) {
                    atts.put("exampleUseChainInOldApi", oldUseChain.toString());
                }
                if (newUseChain != null) {
                    atts.put("exampleUseChainInNewApi", newUseChain.toString());
                }
                d = ((Difference.Builder)((Difference.Builder)((Difference.Builder)((Difference.Builder)((Difference.Builder)Difference.builder().addAttachments(atts)).addClassifications(d.classification)).withCode(d.code)).withName(d.name)).withDescription(d.description)).build();
            }
            it.set(d);
        }
        return new Report(differences, oldElement, newElement);
    }

    private <T> boolean conforms(Object a, Object b, Class<T> cls) {
        boolean ca = a == null || cls.isAssignableFrom(a.getClass());
        boolean cb = b == null || cls.isAssignableFrom(b.getClass());
        return ca && cb;
    }

    private Check.Type getCheckType(Element a, Element b) {
        if (a != null) {
            return this.getCheckType(a);
        }
        if (b != null) {
            return this.getCheckType(b);
        }
        return null;
    }

    private Check.Type getCheckType(Element e) {
        if (e instanceof TypeElement) {
            return Check.Type.CLASS;
        }
        if (e instanceof AnnotationElement) {
            return Check.Type.ANNOTATION;
        }
        if (e instanceof FieldElement) {
            return Check.Type.FIELD;
        }
        if (e instanceof MethodElement) {
            return Check.Type.METHOD;
        }
        if (e instanceof MethodParameterElement) {
            return Check.Type.METHOD_PARAMETER;
        }
        return null;
    }

    private void append(StringBuilder bld, TypeAndUseSite typeAndUseSite) {
        String message;
        switch (typeAndUseSite.useSite.getUseType()) {
            case ANNOTATES: {
                message = "revapi.java.uses.annotates";
                break;
            }
            case HAS_TYPE: {
                message = "revapi.java.uses.hasType";
                break;
            }
            case IS_IMPLEMENTED: {
                message = "revapi.java.uses.isImplemented";
                break;
            }
            case IS_INHERITED: {
                message = "revapi.java.uses.isInherited";
                break;
            }
            case IS_THROWN: {
                message = "revapi.java.uses.isThrown";
                break;
            }
            case PARAMETER_TYPE: {
                message = "revapi.java.uses.parameterType";
                break;
            }
            case RETURN_TYPE: {
                message = "revapi.java.uses.returnType";
                break;
            }
            case CONTAINS: {
                message = "revapi.java.uses.contains";
                break;
            }
            case TYPE_PARAMETER_OR_BOUND: {
                message = "revapi.java.uses.typeParameterOrBound";
                break;
            }
            default: {
                throw new AssertionError((Object)("Invalid use type: " + typeAndUseSite.useSite.getUseType()));
            }
        }
        message = this.messages.getString(message);
        message = MessageFormat.format(message, typeAndUseSite.useSite.getSite().getFullHumanReadableString(), Util.toHumanReadableString((AnnotatedConstruct)typeAndUseSite.type));
        bld.append(message);
    }

    private void appendUses(final ProbingEnvironment env, Element element, final StringBuilder bld) {
        LOG.trace("Reporting uses of {}", (Object)element);
        if (element == null) {
            bld.append("<null>");
            return;
        }
        while (element != null && !(element instanceof JavaTypeElement)) {
            element = element.getParent();
        }
        if (element == null) {
            return;
        }
        final JavaTypeElement usedType = (JavaTypeElement)element;
        if (usedType.isInAPI() && !usedType.isInApiThroughUse()) {
            String message = MessageFormat.format(this.messages.getString("revapi.java.uses.partOfApi"), usedType.getFullHumanReadableString());
            bld.append(message);
            return;
        }
        usedType.visitUseSites((UseSite.Visitor)new UseSite.Visitor<Object, Void>(){

            @Nullable
            public Object visit(@Nonnull DeclaredType type, @Nonnull UseSite use, @Nullable Void parameter) {
                if (JavaElementDifferenceAnalyzer.this.appendUse(env, usedType, bld, type, use)) {
                    return Boolean.TRUE;
                }
                return null;
            }

            @Nullable
            public Object end(DeclaredType type, @Nullable Void parameter) {
                return null;
            }
        }, null);
    }

    private boolean appendUse(ProbingEnvironment env, JavaTypeElement usedType, StringBuilder bld, DeclaredType type, UseSite use) {
        if (!use.getUseType().isMovingToApi()) {
            return false;
        }
        List<TypeAndUseSite> chain = this.getExamplePathToApiArchive(env, usedType, type, use);
        Iterator<TypeAndUseSite> chainIt = chain.iterator();
        if (chain.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Could not find example path to API element for type {} starting with use {}", (Object)((javax.lang.model.element.TypeElement)type.asElement()).getQualifiedName().toString(), (Object)use);
            }
            return false;
        }
        TypeAndUseSite last = null;
        if (chainIt.hasNext()) {
            last = chainIt.next();
            this.append(bld, last);
        }
        while (chainIt.hasNext()) {
            bld.append(" <- ");
            last = chainIt.next();
            this.append(bld, last);
        }
        String message = MessageFormat.format(this.messages.getString("revapi.java.uses.partOfApi"), last.useSite.getSite().getFullHumanReadableString());
        bld.append(" (").append(message).append(")");
        return true;
    }

    private List<TypeAndUseSite> getExamplePathToApiArchive(ProbingEnvironment env, JavaTypeElement usedType, DeclaredType type, UseSite bottomUse) {
        ArrayList<TypeAndUseSite> ret = new ArrayList<TypeAndUseSite>();
        this.traverseToApi(env, usedType, type, bottomUse, ret, new HashSet<javax.lang.model.element.TypeElement>());
        return ret;
    }

    private boolean traverseToApi(ProbingEnvironment env, JavaTypeElement usedType, DeclaredType type, UseSite currentUse, List<TypeAndUseSite> path, Set<javax.lang.model.element.TypeElement> visitedTypes) {
        if (!currentUse.getUseType().isMovingToApi()) {
            return false;
        }
        JavaTypeElement ut = this.findClassOf(currentUse.getSite());
        return this.appendUseType(env, ut, path, usedType, type, currentUse, visitedTypes);
    }

    private boolean appendUseType(final ProbingEnvironment env, JavaTypeElement ut, final List<TypeAndUseSite> path, final JavaTypeElement usedType, final DeclaredType type, final UseSite currentUse, final Set<javax.lang.model.element.TypeElement> visitedTypes) {
        javax.lang.model.element.TypeElement useType = ut.getDeclaringElement();
        if (visitedTypes.contains(useType)) {
            return false;
        }
        visitedTypes.add(useType);
        if (ut.isInAPI() && !ut.isInApiThroughUse() && !ut.equals(usedType)) {
            path.add(0, new TypeAndUseSite(type, currentUse));
            return true;
        }
        Boolean ret = (Boolean)ut.visitUseSites((UseSite.Visitor)new UseSite.Visitor<Boolean, Void>(){

            @Nullable
            public Boolean visit(@Nonnull DeclaredType visitedType, @Nonnull UseSite use, @Nullable Void parameter) {
                if (JavaElementDifferenceAnalyzer.this.traverseToApi(env, usedType, visitedType, use, path, visitedTypes)) {
                    path.add(0, new TypeAndUseSite(type, currentUse));
                    return true;
                }
                return null;
            }

            @Nullable
            public Boolean end(DeclaredType type2, @Nullable Void parameter) {
                return null;
            }
        }, null);
        if (ret == null) {
            Set<javax.lang.model.element.TypeElement> derivedUseTypes = env.getDerivedTypes(useType);
            for (javax.lang.model.element.TypeElement dut : derivedUseTypes) {
                UseSite derivedUse;
                JavaModelElement derivedUseElement;
                TypeElement model = env.getTypeMap().get(dut);
                if (model == null || (derivedUseElement = this.findSameDeclarationUnder(currentUse.getSite(), model)) == null || !this.appendUseType(env, model, path, usedType, type, derivedUse = new UseSite(currentUse.getUseType(), (JavaElement)derivedUseElement), visitedTypes)) continue;
                ret = true;
                break;
            }
        }
        return ret == null ? false : ret;
    }

    private JavaTypeElement findClassOf(JavaElement element) {
        while (element != null && !(element instanceof JavaTypeElement)) {
            element = (JavaElement)element.getParent();
        }
        return (JavaTypeElement)element;
    }

    private javax.lang.model.element.TypeElement findTypeOf(javax.lang.model.element.Element element) {
        while (element != null && !element.getKind().isClass() && !element.getKind().isInterface()) {
            element = element.getEnclosingElement();
        }
        return (javax.lang.model.element.TypeElement)element;
    }

    private JavaModelElement findSameDeclarationUnder(JavaElement declaredElement, JavaTypeElement owningElement) {
        if (!(declaredElement instanceof JavaModelElement)) {
            return null;
        }
        JavaModelElement dme = (JavaModelElement)declaredElement;
        for (Element e : owningElement.getChildren()) {
            if (!(e instanceof JavaModelElement) || !((JavaModelElement)e).getDeclaringElement().equals(dme.getDeclaringElement())) continue;
            return (JavaModelElement)e;
        }
        return null;
    }

    private boolean isCheckedElsewhere(JavaModelElement element, ProbingEnvironment env) {
        String declSig;
        if (element == null) {
            return true;
        }
        if (!element.isInherited()) {
            return false;
        }
        String elementSig = Util.toUniqueString((TypeMirror)element.getModelRepresentation());
        if (!Objects.equals(elementSig, declSig = Util.toUniqueString((TypeMirror)element.getDeclaringElement().asType()))) {
            return false;
        }
        javax.lang.model.element.TypeElement declaringType = this.findTypeOf(element.getDeclaringElement());
        JavaTypeElement declaringClass = env.getTypeMap().get(declaringType);
        return declaringClass != null && declaringClass.isInAPI();
    }

    private static void forceClearCompilerCache() {
        if (CLEAR_COMPILER_CACHE != null && SHARED_ZIP_FILE_INDEX_CACHE != null) {
            try {
                CLEAR_COMPILER_CACHE.invoke(SHARED_ZIP_FILE_INDEX_CACHE, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOG.warn("Failed to force-clear compiler caches, even though it should have been possible.This will probably leak memory", (Throwable)e);
            }
        }
    }

    static {
        EnumMap<Check.Type, Set<Object>> map = new EnumMap<Check.Type, Set<Object>>(Check.Type.class);
        map.put(Check.Type.ANNOTATION, Collections.emptySet());
        map.put(Check.Type.CLASS, EnumSet.of(Check.Type.CLASS, Check.Type.FIELD, Check.Type.METHOD, Check.Type.METHOD_PARAMETER, Check.Type.ANNOTATION));
        map.put(Check.Type.FIELD, Collections.singleton(Check.Type.ANNOTATION));
        map.put(Check.Type.METHOD, EnumSet.of(Check.Type.METHOD_PARAMETER, Check.Type.ANNOTATION));
        map.put(Check.Type.METHOD_PARAMETER, Collections.singleton(Check.Type.ANNOTATION));
        POSSIBLE_CHILDREN_TYPES = Collections.unmodifiableMap(map);
        String javaVersion = System.getProperty("java.version");
        if (javaVersion.startsWith("1.")) {
            Method clearCompilerCache = null;
            Object sharedInstance = null;
            try {
                Class<?> zipFileIndexCacheClass = ToolProvider.getSystemToolClassLoader().loadClass("com.sun.tools.javac.file.ZipFileIndexCache");
                clearCompilerCache = zipFileIndexCacheClass.getDeclaredMethod("clearCache", new Class[0]);
                Method getSharedInstance = zipFileIndexCacheClass.getDeclaredMethod("getSharedInstance", new Class[0]);
                sharedInstance = getSharedInstance.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                LOG.warn("Failed to initialize the force-clearing of javac file caches. We will probably leak resources.", (Throwable)e);
            }
            if (clearCompilerCache != null && sharedInstance != null) {
                CLEAR_COMPILER_CACHE = clearCompilerCache;
                SHARED_ZIP_FILE_INDEX_CACHE = sharedInstance;
            } else {
                CLEAR_COMPILER_CACHE = null;
                SHARED_ZIP_FILE_INDEX_CACHE = null;
            }
        } else {
            CLEAR_COMPILER_CACHE = null;
            SHARED_ZIP_FILE_INDEX_CACHE = null;
        }
    }

    private static enum CheckType {
        CLASS(Check.Type.CLASS),
        FIELD(Check.Type.FIELD),
        METHOD(Check.Type.METHOD),
        METHOD_PARAMETER(Check.Type.METHOD_PARAMETER),
        ANNOTATION(Check.Type.ANNOTATION),
        NONE(null);

        private final Check.Type checkType;

        private CheckType(Check.Type checkType) {
            this.checkType = checkType;
        }

        public Check.Type getCheckType() {
            return this.checkType;
        }

        public boolean isConcrete() {
            return this.checkType != null;
        }
    }

    private static class TypeAndUseSite {
        final DeclaredType type;
        final UseSite useSite;

        public TypeAndUseSite(DeclaredType type, UseSite useSite) {
            this.type = type;
            this.useSite = useSite;
        }
    }
}

