/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.checks.fields;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleTypeVisitor7;
import javax.lang.model.util.Types;
import org.jboss.dmr.ModelNode;
import org.revapi.AnalysisContext;
import org.revapi.Difference;
import org.revapi.java.spi.Check;
import org.revapi.java.spi.CheckBase;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.JavaElement;
import org.revapi.java.spi.JavaFieldElement;
import org.revapi.java.spi.JavaModelElement;
import org.revapi.java.spi.TypeEnvironment;
import org.revapi.java.spi.Util;

public final class SerialVersionUidChecker
extends CheckBase {
    static final String SERIAL_VERSION_UID_FIELD_NAME = "serialVersionUID";
    private boolean strict = false;
    private PrimitiveType oldLong;
    private PrimitiveType newLong;

    public EnumSet<Check.Type> getInterest() {
        return EnumSet.of(Check.Type.FIELD);
    }

    public void initialize(@Nonnull AnalysisContext analysisContext) {
        super.initialize(analysisContext);
        ModelNode changeDetectionType = analysisContext.getConfiguration().get("changeDetection");
        if (changeDetectionType.isDefined() && "jvm".equals(changeDetectionType.asString())) {
            this.strict = true;
        }
    }

    @Nullable
    public String getExtensionId() {
        return SERIAL_VERSION_UID_FIELD_NAME;
    }

    @Nullable
    public Reader getJSONSchema() {
        return new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/META-INF/serialVersionUID-config-schema.json"), Charset.forName("UTF-8"));
    }

    protected void doVisitField(JavaFieldElement oldField, JavaFieldElement newField) {
        Long actualNewSUID;
        if (oldField == null || newField == null || !this.isBothAccessible((JavaModelElement)oldField.getParent(), (JavaModelElement)newField.getParent())) {
            return;
        }
        if (!SERIAL_VERSION_UID_FIELD_NAME.contentEquals(oldField.getDeclaringElement().getSimpleName())) {
            return;
        }
        if (!SERIAL_VERSION_UID_FIELD_NAME.contentEquals(newField.getDeclaringElement().getSimpleName())) {
            return;
        }
        this.ensurePrimitiveTypesLoaded();
        if (!this.getOldTypeEnvironment().getTypeUtils().isSameType(oldField.getModelRepresentation(), this.oldLong)) {
            return;
        }
        if (!this.getNewTypeEnvironment().getTypeUtils().isSameType(newField.getModelRepresentation(), this.newLong)) {
            return;
        }
        if (!oldField.getDeclaringElement().getModifiers().contains((Object)Modifier.STATIC) || !oldField.getDeclaringElement().getModifiers().contains((Object)Modifier.FINAL)) {
            return;
        }
        if (!newField.getDeclaringElement().getModifiers().contains((Object)Modifier.STATIC) || !newField.getDeclaringElement().getModifiers().contains((Object)Modifier.FINAL)) {
            return;
        }
        TypeElement oldType = (TypeElement)oldField.getDeclaringElement().getEnclosingElement();
        TypeElement newType = (TypeElement)newField.getDeclaringElement().getEnclosingElement();
        long computedOldSUID = this.strict ? SerialVersionUidChecker.computeSerialVersionUID(oldType, this.getOldTypeEnvironment()) : SerialVersionUidChecker.computeStructuralId(oldType, this.getOldTypeEnvironment());
        long computedNewSUID = this.strict ? SerialVersionUidChecker.computeSerialVersionUID(newType, this.getNewTypeEnvironment()) : SerialVersionUidChecker.computeStructuralId(newType, this.getNewTypeEnvironment());
        Long actualOldSUID = (Long)oldField.getDeclaringElement().getConstantValue();
        if (!Objects.equals(actualOldSUID, actualNewSUID = (Long)newField.getDeclaringElement().getConstantValue()) || computedOldSUID != computedNewSUID) {
            this.pushActive((JavaElement)oldField, (JavaElement)newField, new Object[]{actualOldSUID, actualNewSUID, computedOldSUID, computedNewSUID});
        }
    }

    protected List<Difference> doEnd() {
        CheckBase.ActiveElements fields = this.popIfActive();
        if (fields == null) {
            return null;
        }
        long actualOldSUID = (Long)fields.context[0];
        long actualNewSUID = (Long)fields.context[1];
        long computedOldSUID = (Long)fields.context[2];
        long computedNewSUID = (Long)fields.context[3];
        boolean reportUnchanged = false;
        boolean reportChanged = false;
        if (actualOldSUID == actualNewSUID && computedOldSUID != computedNewSUID) {
            reportUnchanged = true;
        }
        if (actualOldSUID != actualNewSUID) {
            reportChanged = true;
        }
        if (!reportChanged && !reportUnchanged) {
            return Collections.emptyList();
        }
        ArrayList<Difference> ret = new ArrayList<Difference>(1);
        if (reportUnchanged) {
            ret.add(this.createDifference(Code.FIELD_SERIAL_VERSION_UID_UNCHANGED, Code.attachmentsFor((JavaElement)((JavaFieldElement)fields.oldElement), (JavaElement)((JavaFieldElement)fields.newElement), (String[])new String[]{SERIAL_VERSION_UID_FIELD_NAME, Long.toString(actualOldSUID)})));
        } else {
            ret.add(this.createDifference(Code.FIELD_SERIAL_VERSION_UID_CHANGED, Code.attachmentsFor((JavaElement)((JavaFieldElement)fields.oldElement), (JavaElement)((JavaFieldElement)fields.newElement), (String[])new String[]{"oldSerialVersionUID", Long.toString(actualOldSUID), "newSerialVersionUID", Long.toString(actualNewSUID)})));
        }
        return ret;
    }

    public static long computeStructuralId(TypeElement type, TypeEnvironment environment) {
        Predicate<Element> serializableFields = e -> {
            Set<Modifier> mods = e.getModifiers();
            return !mods.contains((Object)Modifier.TRANSIENT) && !mods.contains((Object)Modifier.STATIC);
        };
        Comparator<Element> bySimpleName = Comparator.comparing(e -> e.getSimpleName().toString());
        List fields = ElementFilter.fieldsIn(type.getEnclosedElements()).stream().filter(serializableFields).sorted(bySimpleName).map(Element::asType).collect(Collectors.toList());
        Types types = environment.getTypeUtils();
        for (TypeMirror st : Util.getAllSuperClasses((Types)types, (TypeMirror)type.asType())) {
            Element ste = types.asElement(st);
            ElementFilter.fieldsIn(ste.getEnclosedElements()).stream().filter(serializableFields).sorted(bySimpleName).map(e -> types.asMemberOf((DeclaredType)st, (Element)e)).forEach(fields::add);
        }
        String data = fields.stream().map(Util::toUniqueString).collect(Collectors.joining());
        try {
            byte[] bytes = data.getBytes("UTF-8");
            MessageDigest md = MessageDigest.getInstance("SHA");
            byte[] hashBytes = md.digest(bytes);
            long hash = 0L;
            for (int i = Math.min(hashBytes.length, 8) - 1; i >= 0; --i) {
                hash = hash << 8 | (long)(hashBytes[i] & 0xFF);
            }
            return hash;
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e2) {
            throw new IllegalStateException("Could not compute structural ID of a type " + type.getQualifiedName().toString(), e2);
        }
    }

    public static long computeSerialVersionUID(TypeElement type, TypeEnvironment environment) {
        TypeElement javaIoSerializable = environment.getElementUtils().getTypeElement("java.io.Serializable");
        if (!environment.getTypeUtils().isAssignable(type.asType(), javaIoSerializable.asType())) {
            return 0L;
        }
        try {
            int i;
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(bout);
            dout.writeUTF(type.getQualifiedName().toString());
            int classMods = SerialVersionUidChecker.asReflectiveModifiers(type, Modifier.PUBLIC, Modifier.FINAL, Modifier.ABSTRACT);
            if (type.getKind() == ElementKind.INTERFACE) {
                classMods |= 0x200;
            }
            if (type.getKind() == ElementKind.INTERFACE) {
                classMods = ElementFilter.methodsIn(type.getEnclosedElements()).size() > 0 ? (classMods |= 0x400) : (classMods &= 0xFFFFFBFF);
            }
            dout.writeInt(classMods);
            if (!(type.asType() instanceof ArrayType)) {
                List<? extends TypeMirror> interfaces = type.getInterfaces();
                Object[] ifaceNames = new String[interfaces.size()];
                for (i = 0; i < interfaces.size(); ++i) {
                    ifaceNames[i] = ((TypeElement)((DeclaredType)interfaces.get(i)).asElement()).getQualifiedName().toString();
                }
                Arrays.sort(ifaceNames);
                for (i = 0; i < ifaceNames.length; ++i) {
                    dout.writeUTF((String)ifaceNames[i]);
                }
            }
            List<VariableElement> fields = ElementFilter.fieldsIn(type.getEnclosedElements());
            MemberSignature[] fieldSigs = new MemberSignature[fields.size()];
            for (i = 0; i < fields.size(); ++i) {
                fieldSigs[i] = new MemberSignature(fields.get(i));
            }
            Arrays.sort(fieldSigs, new Comparator<MemberSignature>(){

                @Override
                public int compare(MemberSignature o1, MemberSignature o2) {
                    String name1 = o1.name;
                    String name2 = o2.name;
                    return name1.compareTo(name2);
                }
            });
            for (i = 0; i < fieldSigs.length; ++i) {
                MemberSignature sig = fieldSigs[i];
                int n = SerialVersionUidChecker.asReflectiveModifiers(sig.member, Modifier.PUBLIC, Modifier.PRIVATE, Modifier.PROTECTED, Modifier.STATIC, Modifier.FINAL, Modifier.VOLATILE, Modifier.TRANSIENT);
                if ((n & 2) != 0 && (n & 0x88) != 0) continue;
                dout.writeUTF(sig.name);
                dout.writeInt(n);
                dout.writeUTF(sig.signature);
            }
            boolean hasStaticInitializer = false;
            for (Element element : type.getEnclosedElements()) {
                if (element.getKind() != ElementKind.STATIC_INIT) continue;
                hasStaticInitializer = true;
                break;
            }
            if (hasStaticInitializer) {
                dout.writeUTF("<clinit>");
                dout.writeInt(8);
                dout.writeUTF("()V");
            }
            List<ExecutableElement> ctors = ElementFilter.constructorsIn(type.getEnclosedElements());
            MemberSignature[] memberSignatureArray = new MemberSignature[ctors.size()];
            int i2 = 0;
            for (ExecutableElement ctor : ctors) {
                memberSignatureArray[i2++] = new MemberSignature(ctor);
            }
            Arrays.sort(memberSignatureArray, new Comparator<MemberSignature>(){

                @Override
                public int compare(MemberSignature o1, MemberSignature o2) {
                    String sig1 = o1.signature;
                    String sig2 = o2.signature;
                    return sig1.compareTo(sig2);
                }
            });
            for (MemberSignature sig : memberSignatureArray) {
                int mods = SerialVersionUidChecker.asReflectiveModifiers(sig.member, Modifier.PUBLIC, Modifier.PRIVATE, Modifier.PROTECTED, Modifier.STATIC, Modifier.FINAL, Modifier.SYNCHRONIZED, Modifier.NATIVE, Modifier.ABSTRACT, Modifier.STRICTFP);
                if ((mods & 2) != 0) continue;
                dout.writeUTF("<init>");
                dout.writeInt(mods);
                dout.writeUTF(sig.signature.replace('/', '.'));
            }
            List<ExecutableElement> methods = ElementFilter.methodsIn(type.getEnclosedElements());
            MemberSignature[] methSigs = new MemberSignature[methods.size()];
            i2 = 0;
            for (ExecutableElement m : methods) {
                methSigs[i2++] = new MemberSignature(m);
            }
            Arrays.sort(methSigs, new Comparator<MemberSignature>(){

                @Override
                public int compare(MemberSignature ms1, MemberSignature ms2) {
                    int comp = ms1.name.compareTo(ms2.name);
                    if (comp == 0) {
                        comp = ms1.signature.compareTo(ms2.signature);
                    }
                    return comp;
                }
            });
            for (MemberSignature sig : methSigs) {
                int mods = SerialVersionUidChecker.asReflectiveModifiers(sig.member, Modifier.PUBLIC, Modifier.PRIVATE, Modifier.PROTECTED, Modifier.STATIC, Modifier.FINAL, Modifier.SYNCHRONIZED, Modifier.NATIVE, Modifier.ABSTRACT, Modifier.STRICTFP);
                if ((mods & 2) != 0) continue;
                dout.writeUTF(sig.name);
                dout.writeInt(mods);
                dout.writeUTF(sig.signature.replace('/', '.'));
            }
            dout.flush();
            MessageDigest md = MessageDigest.getInstance("SHA");
            byte[] hashBytes = md.digest(bout.toByteArray());
            long hash = 0L;
            for (i2 = Math.min(hashBytes.length, 8) - 1; i2 >= 0; --i2) {
                hash = hash << 8 | (long)(hashBytes[i2] & 0xFF);
            }
            return hash;
        }
        catch (IOException | NoSuchAlgorithmException ex) {
            throw new IllegalStateException("Could not compute default serialization UID for class: " + type.getQualifiedName().toString(), ex);
        }
    }

    private static int asReflectiveModifiers(Element el, Modifier ... applicableModifiers) {
        int mods = 0;
        block13: for (Modifier m : applicableModifiers) {
            if (!el.getModifiers().contains((Object)m)) continue;
            switch (m) {
                case ABSTRACT: {
                    mods |= 0x400;
                    continue block13;
                }
                case FINAL: {
                    mods |= 0x10;
                    continue block13;
                }
                case NATIVE: {
                    mods |= 0x100;
                    continue block13;
                }
                case PRIVATE: {
                    mods |= 2;
                    continue block13;
                }
                case PROTECTED: {
                    mods |= 4;
                    continue block13;
                }
                case PUBLIC: {
                    mods |= 1;
                    continue block13;
                }
                case STATIC: {
                    mods |= 8;
                    continue block13;
                }
                case STRICTFP: {
                    mods |= 0x800;
                    continue block13;
                }
                case SYNCHRONIZED: {
                    mods |= 0x20;
                    continue block13;
                }
                case TRANSIENT: {
                    mods |= 0x80;
                    continue block13;
                }
                case VOLATILE: {
                    mods |= 0x40;
                    continue block13;
                }
            }
        }
        return mods;
    }

    private static String getSignature(TypeMirror type) {
        StringBuilder sbuf = new StringBuilder();
        type.accept(new SimpleTypeVisitor7<Void, StringBuilder>(){

            @Override
            protected Void defaultAction(TypeMirror e, StringBuilder stringBuilder) {
                return null;
            }

            @Override
            public Void visitPrimitive(PrimitiveType t, StringBuilder stringBuilder) {
                switch (t.getKind()) {
                    case BOOLEAN: {
                        stringBuilder.append("Z");
                        break;
                    }
                    case BYTE: {
                        stringBuilder.append("B");
                        break;
                    }
                    case CHAR: {
                        stringBuilder.append("C");
                        break;
                    }
                    case DOUBLE: {
                        stringBuilder.append("D");
                        break;
                    }
                    case FLOAT: {
                        stringBuilder.append("F");
                        break;
                    }
                    case INT: {
                        stringBuilder.append("I");
                        break;
                    }
                    case LONG: {
                        stringBuilder.append("J");
                        break;
                    }
                    case SHORT: {
                        stringBuilder.append("S");
                        break;
                    }
                }
                return null;
            }

            @Override
            public Void visitArray(ArrayType t, StringBuilder stringBuilder) {
                stringBuilder.append("[");
                t.getComponentType().accept(this, stringBuilder);
                return null;
            }

            @Override
            public Void visitDeclared(DeclaredType t, StringBuilder stringBuilder) {
                stringBuilder.append("L");
                stringBuilder.append(((TypeElement)t.asElement()).getQualifiedName().toString().replace('.', '/'));
                stringBuilder.append(";");
                return null;
            }

            @Override
            public Void visitExecutable(ExecutableType t, StringBuilder stringBuilder) {
                stringBuilder.append("(");
                for (TypeMirror typeMirror : t.getParameterTypes()) {
                    typeMirror.accept(this, stringBuilder);
                }
                stringBuilder.append(")");
                t.getReturnType().accept(this, stringBuilder);
                return null;
            }

            @Override
            public Void visitNoType(NoType t, StringBuilder stringBuilder) {
                if (t.getKind() == TypeKind.VOID) {
                    stringBuilder.append("V");
                }
                return null;
            }
        }, sbuf);
        return sbuf.toString();
    }

    private void ensurePrimitiveTypesLoaded() {
        if (this.oldLong != null) {
            return;
        }
        this.oldLong = this.getOldTypeEnvironment().getTypeUtils().getPrimitiveType(TypeKind.LONG);
        this.newLong = this.getNewTypeEnvironment().getTypeUtils().getPrimitiveType(TypeKind.LONG);
    }

    private static class MemberSignature {
        public final Element member;
        public final String name;
        public final String signature;

        public MemberSignature(VariableElement field) {
            this.member = field;
            this.name = field.getSimpleName().toString();
            this.signature = SerialVersionUidChecker.getSignature(field.asType());
        }

        public MemberSignature(ExecutableElement meth) {
            this.member = meth;
            this.name = meth.getSimpleName().toString();
            this.signature = SerialVersionUidChecker.getSignature(meth.asType());
        }
    }
}

