/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.extract;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.revapi.AnalysisContext;
import org.revapi.Archive;
import org.revapi.java.spi.JarExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WarJarExtractor
implements JarExtractor {
    private static final Logger LOG = LoggerFactory.getLogger(WarJarExtractor.class);
    private boolean doNothing;
    private Map<Pattern, Set<String>> scan;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<InputStream> extract(Archive archive) {
        if (this.doNothing) {
            return Optional.empty();
        }
        Set<String> pathPatterns = this.getPrefixesToExtract(archive.getName());
        if (pathPatterns.isEmpty()) {
            return Optional.empty();
        }
        Path path = null;
        try (ZipInputStream orig = new ZipInputStream(archive.openStream());){
            path = Files.createTempFile("revapi-java-jarextract-war", null, new FileAttribute[0]);
            boolean isWarFile = false;
            ZipOutputStream croppedZip = new ZipOutputStream(new FileOutputStream(path.toFile()));
            Object object = null;
            try {
                croppedZip.setLevel(0);
                croppedZip.setMethod(8);
                byte[] buf = new byte[32768];
                ZipEntry inEntry = orig.getNextEntry();
                while (inEntry != null) {
                    int prefixLen = this.getMatchedPathPrefixLength(inEntry.getName(), pathPatterns);
                    if (prefixLen >= 0) {
                        isWarFile = true;
                        ZipEntry outEntry = new ZipEntry(inEntry.getName().substring(prefixLen));
                        croppedZip.putNextEntry(outEntry);
                        if (!inEntry.isDirectory()) {
                            int cnt;
                            while ((cnt = orig.read(buf)) != -1) {
                                croppedZip.write(buf, 0, cnt);
                            }
                        }
                        croppedZip.closeEntry();
                    }
                    inEntry = orig.getNextEntry();
                }
            }
            catch (Throwable throwable2) {
                object = throwable2;
                throw throwable2;
            }
            finally {
                if (croppedZip != null) {
                    if (object != null) {
                        try {
                            croppedZip.close();
                        }
                        catch (Throwable throwable3) {
                            ((Throwable)object).addSuppressed(throwable3);
                        }
                    } else {
                        croppedZip.close();
                    }
                }
            }
            if (isWarFile) {
                final Path finalPath = path;
                object = Optional.of(new FileInputStream(path.toFile()){

                    @Override
                    public void close() throws IOException {
                        super.close();
                        Files.delete(finalPath);
                    }
                });
                return object;
            }
            this.cleanPath(path);
            Optional<InputStream> optional = Optional.empty();
            return optional;
        }
        catch (IOException e) {
            this.cleanPath(path);
            return Optional.empty();
        }
    }

    private int getMatchedPathPrefixLength(String entryName, Set<String> prefixes) {
        for (String prefix : prefixes) {
            if (!entryName.startsWith(prefix)) continue;
            return prefix.length();
        }
        return -1;
    }

    private void cleanPath(Path path) {
        if (path != null) {
            try {
                Files.delete(path);
            }
            catch (IOException e1) {
                LOG.warn("Failed to delete temporary file " + path, (Throwable)e1);
            }
        }
    }

    public String getExtensionId() {
        return "war";
    }

    @Nullable
    public Reader getJSONSchema() {
        return new InputStreamReader(this.getClass().getResourceAsStream("/META-INF/warJarExtract-config-schema.json"), Charset.forName("UTF-8"));
    }

    public void initialize(@Nonnull AnalysisContext analysisContext) {
        ModelNode scan = analysisContext.getConfiguration().get("scan");
        ModelNode disabled = analysisContext.getConfiguration().get("disabled");
        boolean bl = this.doNothing = disabled.isDefined() && disabled.asBoolean();
        if (this.doNothing) {
            return;
        }
        if (scan.isDefined() && scan.getType() == ModelType.LIST) {
            this.scan = new HashMap<Pattern, Set<String>>(scan.keys().size(), 1.0f);
            for (ModelNode record : scan.asList()) {
                ModelNode archiveNode = record.get("archive");
                ModelNode prefixesNode = record.get("prefixes");
                if (!archiveNode.isDefined() || !prefixesNode.isDefined() || archiveNode.getType() != ModelType.STRING || prefixesNode.getType() != ModelType.LIST) continue;
                Pattern archive = Pattern.compile(archiveNode.asString());
                Set prefixes = prefixesNode.asList().stream().map(ModelNode::asString).map(v -> v.endsWith("/") ? v : v + "/").collect(Collectors.toSet());
                this.scan.put(archive, prefixes);
            }
        } else {
            this.scan = new HashMap<Pattern, Set<String>>(1, 1.0f);
            this.scan.put(Pattern.compile(".*"), new HashSet<String>(Collections.singletonList("/WEB-INF/classes/")));
        }
    }

    private Set<String> getPrefixesToExtract(String archiveName) {
        HashSet ret = null;
        for (Map.Entry<Pattern, Set<String>> e : this.scan.entrySet()) {
            if (!e.getKey().matcher(archiveName).matches()) continue;
            if (ret == null) {
                ret = new HashSet(e.getValue());
                continue;
            }
            ret.addAll(e.getValue());
        }
        return ret == null ? Collections.emptySet() : ret;
    }
}

