/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.classif.match.declaration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.revapi.classif.ModelInspector;
import org.revapi.classif.TestResult;
import org.revapi.classif.match.declaration.DeclarationMatch;
import org.revapi.classif.match.instance.TypeReferenceMatch;
import org.revapi.classif.progress.context.MatchContext;
import org.revapi.classif.util.Glob;

public final class ImplementsMatch
extends DeclarationMatch {
    private final boolean onlyDirect;
    private final List<TypeReferenceMatch> types;
    private final Glob<TypeReferenceMatch> glob;

    public ImplementsMatch(boolean onlyDirect, boolean exactList, List<TypeReferenceMatch> types) {
        this.onlyDirect = onlyDirect;
        this.types = exactList ? null : types;
        this.glob = exactList ? new Glob<TypeReferenceMatch>(types) : null;
    }

    @Override
    protected <M> TestResult testType(TypeElement declaration, TypeMirror instantiation, MatchContext<M> ctx) {
        if (this.glob == null) {
            assert (this.types != null);
            List<DeclaredType> impld = this.getImplemented(instantiation, ctx.getModelInspector());
            return TestResult.TestableStream.testable(this.types).testAll(m -> TestResult.TestableStream.testable(impld).testAny(i -> m.testInstance((TypeMirror)i, ctx)));
        }
        return this.glob.testUnordered((m, t) -> m.testInstance((TypeMirror)t, ctx), this.getImplemented(instantiation, ctx.getModelInspector()));
    }

    public String toString() {
        List<TypeReferenceMatch> list = this.types == null ? this.glob.getMatches() : this.types;
        return (this.onlyDirect ? "directly " : "") + (this.types == null ? "exactly " : "") + "implements " + list.stream().map(Object::toString).collect(Collectors.joining(", "));
    }

    private List<DeclaredType> getImplemented(TypeMirror type, ModelInspector<?> insp) {
        List<Object> ret;
        List<DeclaredType> superTypes = this.directSuperTypes(type, insp);
        if (!this.onlyDirect) {
            ret = new ArrayList(superTypes.size());
            this.resolveAllImplemented(superTypes, ret, insp);
        } else {
            ret = superTypes.size() > 1 ? superTypes.subList(1, superTypes.size()) : Collections.emptyList();
        }
        return ret;
    }

    private void resolveAllImplemented(List<DeclaredType> superTypes, List<DeclaredType> ifaces, ModelInspector<?> insp) {
        if (!superTypes.isEmpty()) {
            DeclaredType superClass = superTypes.get(0);
            List<DeclaredType> superIfaces = superTypes.subList(1, superTypes.size());
            this.resolveAllImplemented(superClass, superIfaces, ifaces, insp);
        }
    }

    private void resolveAllImplemented(DeclaredType superClass, List<DeclaredType> superIfaces, List<DeclaredType> result, ModelInspector<?> insp) {
        List<DeclaredType> superTypesOfSuperClass = this.directSuperTypes(superClass, insp);
        if (!superTypesOfSuperClass.isEmpty()) {
            this.resolveAllImplemented(superTypesOfSuperClass.get(0), superTypesOfSuperClass.subList(1, superTypesOfSuperClass.size()), result, insp);
        }
        for (DeclaredType si : superIfaces) {
            if (result.contains(si)) continue;
            result.add(si);
            List<DeclaredType> superTypesOfSuperInterface = this.directSuperTypes(si, insp);
            if (superTypesOfSuperInterface.isEmpty()) continue;
            this.resolveAllImplemented(superTypesOfSuperInterface.get(0), superTypesOfSuperInterface.subList(1, superTypesOfSuperInterface.size()), result, insp);
        }
    }

    private List<DeclaredType> directSuperTypes(TypeMirror t, ModelInspector<?> insp) {
        return insp.directSupertypes(t).stream().map(s -> (DeclaredType)s).collect(Collectors.toList());
    }
}

