/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.classif.match.declaration;

import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.revapi.classif.TestResult;
import org.revapi.classif.match.declaration.DeclarationMatch;
import org.revapi.classif.match.instance.TypeReferenceMatch;
import org.revapi.classif.progress.context.MatchContext;
import org.revapi.classif.util.Glob;

public final class ThrowsMatch
extends DeclarationMatch {
    private final Glob<TypeReferenceMatch> thrownTypes;

    public ThrowsMatch(List<TypeReferenceMatch> thrownTypes) {
        this.thrownTypes = new Glob<TypeReferenceMatch>(thrownTypes);
    }

    @Override
    protected <M> TestResult testMethod(ExecutableElement declaration, TypeMirror instantiation, MatchContext<M> ctx) {
        if (instantiation.getKind() != TypeKind.EXECUTABLE) {
            return TestResult.NOT_PASSED;
        }
        ExecutableType method = (ExecutableType)instantiation;
        List<? extends TypeMirror> thrown = method.getThrownTypes();
        return this.thrownTypes.testUnordered((m, t) -> m.testInstance((TypeMirror)t, ctx), thrown);
    }

    public String toString() {
        return "throws " + this.thrownTypes.getMatches().stream().map(Object::toString).collect(Collectors.joining(", "));
    }
}

