/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.classif.match.instance;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.type.WildcardType;
import org.revapi.classif.TestResult;
import org.revapi.classif.match.instance.TypeInstanceMatch;
import org.revapi.classif.match.instance.TypeParameterWildcardMatch;
import org.revapi.classif.match.instance.TypeReferenceMatch;
import org.revapi.classif.progress.context.MatchContext;
import org.revapi.classif.util.Globbed;

public final class TypeParameterMatch
extends TypeInstanceMatch
implements Globbed {
    private final TypeParameterWildcardMatch wildcard;
    private final List<TypeReferenceMatch> bounds;

    public TypeParameterMatch(TypeParameterWildcardMatch wildcard, List<TypeReferenceMatch> bounds) {
        this.wildcard = wildcard;
        this.bounds = bounds;
    }

    @Override
    public boolean isMatchAny() {
        if (this.wildcard != null || this.bounds.size() != 1) {
            return false;
        }
        TypeReferenceMatch ref = this.bounds.get(0);
        return ref.isMatchAny();
    }

    @Override
    public boolean isMatchAll() {
        if (this.wildcard != null || this.bounds.size() != 1) {
            return false;
        }
        TypeReferenceMatch ref = this.bounds.get(0);
        return ref.isMatchAll();
    }

    @Override
    protected <M> TestResult testIntersection(IntersectionType t, MatchContext<M> matchContext) {
        return TestResult.TestableStream.testable(this.bounds).testAll(m -> TestResult.TestableStream.testable(t.getBounds()).testAny(b -> m.testInstance((TypeMirror)b, matchContext)));
    }

    @Override
    protected <M> TestResult testDeclared(DeclaredType t, MatchContext<M> matchContext) {
        return this.bounds == null ? TestResult.NOT_PASSED : TestResult.TestableStream.testable(this.bounds).testAll(b -> b.testInstance(t, matchContext));
    }

    @Override
    protected <M> TestResult testError(ErrorType t, MatchContext<M> matchContext) {
        return this.testDeclared(t, matchContext);
    }

    @Override
    protected <M> TestResult testTypeVariable(TypeVariable t, MatchContext<M> matchContext) {
        if (this.wildcard != null) {
            return this.testWildcard(((Function<TypeVariable, WildcardType>)x -> TypeParameterMatch.extendsWildcard(x.getUpperBound())).apply(t), matchContext);
        }
        if (this.bounds != null) {
            TypeMirror bound = t.getUpperBound();
            if (TypeParameterMatch.isJavaLangObject(bound, matchContext)) {
                return TestResult.TestableStream.testable(this.bounds).testAll(m -> m.testInstance(bound, matchContext));
            }
            return TestResult.NOT_PASSED;
        }
        return TestResult.NOT_PASSED;
    }

    @Override
    protected <M> TestResult testWildcard(WildcardType t, MatchContext<M> matchContext) {
        if (this.wildcard != null) {
            return this.wildcard.testInstance(t, matchContext);
        }
        if (this.bounds != null && t.getSuperBound() == null && t.getExtendsBound() == null) {
            TypeMirror bound = matchContext.getModelInspector().getJavaLangObjectElement().asType();
            return TestResult.TestableStream.testable(this.bounds).testAll(m -> m.testInstance(bound, matchContext));
        }
        return TestResult.NOT_PASSED;
    }

    public String toString() {
        return this.wildcard != null ? this.wildcard.toString() : (this.bounds.isEmpty() ? "?" : this.bounds.stream().map(Object::toString).collect(Collectors.joining(" & ")));
    }

    private static boolean isJavaLangObject(TypeMirror t, MatchContext<?> ctx) {
        if (!(t instanceof DeclaredType)) {
            return false;
        }
        DeclaredType dt = (DeclaredType)t;
        return ctx.getModelInspector().getJavaLangObjectElement().equals(dt.asElement());
    }

    private static WildcardType extendsWildcard(TypeMirror bound) {
        return new SyntheticExtendsWildcardType(bound);
    }

    private static final class SyntheticExtendsWildcardType
    implements WildcardType {
        private final TypeMirror bound;

        private SyntheticExtendsWildcardType(TypeMirror bound) {
            this.bound = bound;
        }

        @Override
        public TypeMirror getExtendsBound() {
            return this.bound;
        }

        @Override
        public TypeMirror getSuperBound() {
            return null;
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.WILDCARD;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitWildcard(this, p);
        }

        @Override
        public List<? extends AnnotationMirror> getAnnotationMirrors() {
            return Collections.emptyList();
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
            return null;
        }

        @Override
        public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationType) {
            return (Annotation[])new Object[0];
        }
    }
}

