/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.classif.progress;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.revapi.classif.StructuralMatcher;
import org.revapi.classif.TestResult;
import org.revapi.classif.progress.MatchingProgress;
import org.revapi.classif.progress.StatementMatch;
import org.revapi.classif.progress.WalkInstruction;

final class SimpleMatchingProgress<M>
extends MatchingProgress<M> {
    private static final Logger LOG = LogManager.getLogger(SimpleMatchingProgress.class);
    private final StatementMatch<M> statementMatch;
    private final StructuralMatcher.Configuration configuration;
    private final Map<M, TestResult> activeTestResults = new IdentityHashMap<M, TestResult>();

    SimpleMatchingProgress(StructuralMatcher.Configuration configuration, StatementMatch<M> statementMatch) {
        this.configuration = configuration;
        this.statementMatch = statementMatch;
    }

    @Override
    public WalkInstruction start(M model) {
        TestResult res = this.statementMatch.test(model, this.statementMatch.getContext().getMatchContext());
        this.activeTestResults.put(model, res);
        return LOG.traceExit(WalkInstruction.of(!this.configuration.isStrictHierarchy(), res));
    }

    @Override
    public TestResult finish(M model) {
        TestResult res = this.activeTestResults.remove(model);
        if (res == null) {
            throw new IllegalArgumentException("Unbalanced start/finish call.");
        }
        return res;
    }

    @Override
    public Map<M, TestResult> finish() {
        return Collections.emptyMap();
    }

    @Override
    public void reset() {
        this.activeTestResults.clear();
        this.statementMatch.reset();
    }
}

