/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.classif.progress.context;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.revapi.classif.ModelInspector;
import org.revapi.classif.TestResult;
import org.revapi.classif.progress.StatementMatch;

public final class MatchContext<M> {
    private final ModelInspector<M> modelInspector;
    private final Map<String, StatementMatch<M>> referencedStatements;

    public MatchContext(ModelInspector<M> modelInspector, Set<String> variables) {
        this(Objects.requireNonNull(modelInspector), Objects.requireNonNull(variables).stream().collect(Collectors.toMap(Function.identity(), __ -> AlwaysMatch.instance())));
    }

    private MatchContext(ModelInspector<M> modelInspector, Map<String, StatementMatch<M>> referencedStatements) {
        this.modelInspector = modelInspector;
        this.referencedStatements = referencedStatements;
    }

    public MatchContext<M> require(Map<String, M> mapping) {
        HashMap newVars = new HashMap(this.referencedStatements);
        mapping.forEach((var, requiredModel) -> {
            StatementMatch cfr_ignored_0 = newVars.put((String)var, new ExactMatch(requiredModel));
        });
        return new MatchContext<M>(this.modelInspector, newVars);
    }

    public MatchContext<M> withResults(Map<String, TestResult> mapping) {
        HashMap newVars = new HashMap(this.referencedStatements);
        mapping.forEach((var, result) -> {
            StatementMatch cfr_ignored_0 = newVars.put((String)var, new DefinedMatch((TestResult)((Object)result)));
        });
        return new MatchContext<M>(this.modelInspector, newVars);
    }

    public ModelInspector<M> getModelInspector() {
        return this.modelInspector;
    }

    public StatementMatch<M> getVariableMatcher(String variable) {
        return this.referencedStatements.getOrDefault(variable, AlwaysMatch.instance());
    }

    public Set<String> getVariables() {
        return this.referencedStatements.keySet();
    }

    public String toString() {
        return "MatchContext{referencedStatements=" + this.referencedStatements + '}';
    }

    private static final class DefinedMatch<M>
    extends StatementMatch<M> {
        private final TestResult result;

        DefinedMatch(TestResult result) {
            this.result = result;
        }

        @Override
        protected TestResult defaultElementTest(M model, MatchContext<M> ctx) {
            return this.result;
        }
    }

    private static final class AlwaysMatch<M>
    extends StatementMatch<M> {
        static final AlwaysMatch<?> INSTANCE = new AlwaysMatch();

        private AlwaysMatch() {
        }

        static <M> AlwaysMatch<M> instance() {
            return INSTANCE;
        }

        @Override
        protected TestResult defaultElementTest(M model, MatchContext<M> ctx) {
            return TestResult.PASSED;
        }

        @Override
        public String toString() {
            return "AlwaysMatch";
        }
    }

    private static final class ExactMatch<M>
    extends StatementMatch<M> {
        private final M model;

        private ExactMatch(M model) {
            this.model = model;
        }

        @Override
        protected TestResult defaultElementTest(M model, MatchContext<M> ctx) {
            return TestResult.fromBoolean(Objects.equals(model, this.model));
        }

        @Override
        public String toString() {
            return "ExactMatch{model=" + this.model + '}';
        }
    }
}

