/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.classif.statement;

import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import org.revapi.classif.TestResult;
import org.revapi.classif.match.NameMatch;
import org.revapi.classif.match.declaration.AnnotationsMatch;
import org.revapi.classif.match.declaration.MethodConstraintsMatch;
import org.revapi.classif.match.declaration.MethodParameterMatch;
import org.revapi.classif.match.declaration.ModifiersMatch;
import org.revapi.classif.match.instance.TypeParametersMatch;
import org.revapi.classif.match.instance.TypeReferenceMatch;
import org.revapi.classif.progress.StatementMatch;
import org.revapi.classif.progress.context.MatchContext;
import org.revapi.classif.statement.AbstractStatement;
import org.revapi.classif.util.Glob;

public final class MethodStatement
extends AbstractStatement {
    private final NameMatch name;
    private final TypeReferenceMatch returnType;
    private final TypeReferenceMatch declaringType;
    private final TypeParametersMatch typeParameters;
    private final MethodConstraintsMatch constraints;
    private final Glob<MethodParameterMatch> parameters;

    public MethodStatement(String definedVariable, List<String> referencedVariables, AnnotationsMatch annotations, ModifiersMatch modifiers, boolean isMatch, NameMatch name, TypeReferenceMatch returnType, TypeReferenceMatch declaringType, TypeParametersMatch typeParameters, List<MethodParameterMatch> parameters, MethodConstraintsMatch constraints, boolean negation) {
        super(definedVariable, referencedVariables, isMatch, annotations, modifiers, negation);
        this.name = name;
        this.returnType = returnType;
        this.declaringType = declaringType;
        this.typeParameters = typeParameters;
        this.parameters = new Glob<MethodParameterMatch>(parameters);
        this.constraints = constraints;
    }

    @Override
    public <M> StatementMatch<M> createMatch() {
        return new StatementMatch<M>(){

            @Override
            public TestResult testMethod(M method, MatchContext<M> ctx) {
                ExecutableElement element = (ExecutableElement)ctx.getModelInspector().toElement(method);
                TypeMirror type = ctx.getModelInspector().toMirror(method);
                TestResult res = TestResult.fromBoolean(MethodStatement.this.name.matches(element.getSimpleName().toString()));
                if (MethodStatement.this.modifiers != null) {
                    res = res.and(() -> MethodStatement.this.modifiers.testDeclaration(element, type, ctx));
                }
                if (MethodStatement.this.annotations != null) {
                    res = res.and(() -> MethodStatement.this.annotations.testDeclaration(element, type, ctx));
                }
                if (MethodStatement.this.returnType != null) {
                    res = res.and(() -> MethodStatement.this.returnType.testInstance(element.getReturnType(), ctx));
                }
                res = res.and(() -> MethodStatement.this.parameters.test((match, p) -> match.testDeclaration((Element)p, p.asType(), ctx), element.getParameters()));
                if (MethodStatement.this.declaringType != null) {
                    res = res.and(() -> MethodStatement.this.declaringType.testInstance(element.getEnclosingElement().asType(), ctx));
                }
                if (MethodStatement.this.typeParameters != null) {
                    res = res.and(() -> MethodStatement.this.typeParameters.testInstance(type, ctx));
                }
                if (MethodStatement.this.constraints != null) {
                    res = res.and(() -> MethodStatement.this.constraints.testDeclaration(element, type, ctx));
                }
                return MethodStatement.this.negation ? res.negate() : res;
            }

            @Override
            public String toString() {
                StringBuilder bld = new StringBuilder(MethodStatement.this.toStringPrefix());
                if (MethodStatement.this.typeParameters != null) {
                    bld.append("<");
                    bld.append(MethodStatement.this.typeParameters.toString());
                    bld.append(">");
                }
                if (MethodStatement.this.returnType != null) {
                    if (bld.length() > 0) {
                        bld.append(" ");
                    }
                    bld.append(MethodStatement.this.returnType);
                }
                if (MethodStatement.this.declaringType != null) {
                    if (bld.length() > 0) {
                        bld.append(" ");
                    }
                    bld.append(MethodStatement.this.declaringType);
                    bld.append("::");
                }
                if (MethodStatement.this.isMatch()) {
                    bld.append("^");
                }
                MethodStatement.this.insertVariable(bld);
                if (MethodStatement.this.negation) {
                    bld.append("!");
                }
                bld.append(MethodStatement.this.name);
                bld.append("(");
                bld.append(MethodStatement.this.parameters.getMatches().stream().map(Object::toString).collect(Collectors.joining(", ")));
                bld.append(")");
                if (MethodStatement.this.constraints != null) {
                    bld.append(" ");
                    bld.append(MethodStatement.this.constraints);
                }
                return bld.toString();
            }
        };
    }
}

