/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.SimpleElementVisitor8;
import org.revapi.Archive;
import org.revapi.java.compilation.ClassPathUseSite;
import org.revapi.java.compilation.InheritedUseSite;
import org.revapi.java.compilation.ProbingEnvironment;
import org.revapi.java.compilation.UseSitePath;
import org.revapi.java.model.FieldElement;
import org.revapi.java.model.JavaElementBase;
import org.revapi.java.model.JavaElementFactory;
import org.revapi.java.model.MethodElement;
import org.revapi.java.model.MethodParameterElement;
import org.revapi.java.spi.JavaElement;
import org.revapi.java.spi.JavaModelElement;
import org.revapi.java.spi.JavaTypeElement;
import org.revapi.java.spi.UseSite;
import org.revapi.java.spi.Util;

public class TypeElement
extends JavaElementBase<javax.lang.model.element.TypeElement, DeclaredType>
implements JavaTypeElement {
    private final String binaryName;
    private final String canonicalName;
    private Set<UseSite> useSites;
    private Set<ClassPathUseSite> rawUseSites;
    private boolean inApi;
    private boolean inApiThroughUse;
    private Map<UseSite.Type, Map<JavaTypeElement, Set<JavaModelElement>>> usedTypes;
    private Map<UseSite.Type, Map<TypeElement, Set<UseSitePath>>> rawUsedTypes;

    TypeElement(ProbingEnvironment env, Archive archive, String binaryName, String canonicalName) {
        super(env, archive, null, null);
        this.binaryName = binaryName;
        this.canonicalName = canonicalName;
    }

    public TypeElement(ProbingEnvironment env, Archive archive, javax.lang.model.element.TypeElement element, DeclaredType type) {
        super(env, archive, element, type);
        this.binaryName = env.getElementUtils().getBinaryName(element).toString();
        this.canonicalName = element.getQualifiedName().toString();
    }

    @Override
    @Nonnull
    protected String getHumanReadableElementType() {
        switch (((javax.lang.model.element.TypeElement)this.element).getKind()) {
            case ANNOTATION_TYPE: {
                return "@interface";
            }
            case CLASS: {
                return "class";
            }
            case ENUM: {
                return "enum";
            }
            case INTERFACE: {
                return "interface";
            }
        }
        return "class";
    }

    public String getBinaryName() {
        return this.binaryName;
    }

    public String getCanonicalName() {
        return this.canonicalName;
    }

    @Override
    public boolean isInAPI() {
        return this.inApi;
    }

    @Override
    public boolean isInApiThroughUse() {
        return this.inApiThroughUse;
    }

    @Override
    public Set<UseSite> getUseSites() {
        if (this.useSites == null) {
            this.useSites = this.rawUseSites == null ? new HashSet<UseSite>(1) : this.rawUseSites.stream().map(u -> {
                if (u instanceof InheritedUseSite) {
                    JavaModelElement model = this.getModel(u.site, ((InheritedUseSite)u).inheritor, u.indexInParent);
                    return model == null ? null : new UseSite(u.useType, model);
                }
                JavaModelElement model = this.getModel(u.site, null, u.indexInParent);
                return model == null ? null : new UseSite(u.useType, model);
            }).filter(Objects::nonNull).collect(Collectors.toSet());
            this.rawUseSites = null;
        }
        return this.useSites;
    }

    @Override
    public Map<UseSite.Type, Map<JavaTypeElement, Set<JavaModelElement>>> getUsedTypes() {
        if (this.usedTypes == null) {
            this.usedTypes = new HashMap<UseSite.Type, Map<JavaTypeElement, Set<JavaModelElement>>>();
            if (this.rawUsedTypes != null) {
                for (Map.Entry<UseSite.Type, Map<TypeElement, Set<UseSitePath>>> e : this.rawUsedTypes.entrySet()) {
                    Map<JavaTypeElement, Set> value = e.getValue().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Set)entry.getValue()).stream().map(path -> {
                        int index = -1;
                        if (path.useSite instanceof VariableElement && path.useSite.getEnclosingElement() instanceof ExecutableElement) {
                            index = ((ExecutableElement)path.useSite.getEnclosingElement()).getParameters().indexOf(path.useSite);
                        }
                        TypeElement owner = null;
                        if (path.owner != null) {
                            owner = (TypeElement)this.getModel(path.owner, null, -1);
                        }
                        return this.getModel(path.useSite, owner, index);
                    }).filter(Objects::nonNull).collect(Collectors.toSet())));
                    this.usedTypes.put(e.getKey(), value);
                }
            }
        }
        return this.usedTypes;
    }

    public void setRawUsedTypes(Map<UseSite.Type, Map<TypeElement, Set<UseSitePath>>> usedTypes) {
        this.rawUsedTypes = usedTypes;
    }

    public void setInApi(boolean inApi) {
        this.inApi = inApi;
    }

    public void setInApiThroughUse(boolean inApiThroughUse) {
        this.inApiThroughUse = inApiThroughUse;
    }

    public void setRawUseSites(Set<ClassPathUseSite> rawUseSites) {
        this.rawUseSites = rawUseSites;
    }

    @Override
    public int compareTo(@Nonnull JavaElement o) {
        if (!o.getClass().equals(TypeElement.class)) {
            return JavaElementFactory.compareByType(this, o);
        }
        return this.binaryName.compareTo(((TypeElement)o).binaryName);
    }

    @Override
    protected String createFullHumanReadableString() {
        Object rep = this.getModelRepresentation();
        return this.getHumanReadableElementType() + " " + (rep == null ? this.canonicalName : Util.toHumanReadableString(rep));
    }

    @Override
    protected String createComparableSignature() {
        return null;
    }

    @Override
    public TypeElement clone() {
        return (TypeElement)super.clone();
    }

    private JavaModelElement getModel(Element element, final TypeElement owner, final int indexInParent) {
        return element.accept(new SimpleElementVisitor8<JavaModelElement, Void>(){

            @Override
            public JavaModelElement visitVariable(VariableElement e, Void ignored) {
                if (e.getEnclosingElement() instanceof javax.lang.model.element.TypeElement) {
                    TypeElement type = this.findModelType(e.getEnclosingElement());
                    if (type == null) {
                        return null;
                    }
                    List fs = type.stream(FieldElement.class, false).filter(f -> ((VariableElement)f.getDeclaringElement()).equals(e)).collect(Collectors.toList());
                    return fs.isEmpty() ? null : (JavaModelElement)fs.get(0);
                }
                if (e.getEnclosingElement() instanceof ExecutableElement) {
                    Element methodEl = e.getEnclosingElement();
                    TypeElement type = this.findModelType(methodEl.getEnclosingElement());
                    if (type == null) {
                        return null;
                    }
                    List ms = type.stream(MethodElement.class, false).filter(m -> ((ExecutableElement)m.getDeclaringElement()).equals(methodEl)).collect(Collectors.toList());
                    if (ms.isEmpty()) {
                        return null;
                    }
                    MethodElement method = (MethodElement)ms.get(0);
                    List params = method.stream(MethodParameterElement.class, false).collect(Collectors.toList());
                    return params.size() > indexInParent ? (JavaModelElement)params.get(indexInParent) : null;
                }
                return null;
            }

            @Override
            public JavaModelElement visitType(javax.lang.model.element.TypeElement e, Void ignored) {
                return this.findModelType(e);
            }

            @Override
            public JavaModelElement visitExecutable(ExecutableElement e, Void ignored) {
                TypeElement type = this.findModelType(e.getEnclosingElement());
                if (type == null) {
                    return null;
                }
                List ms = type.stream(MethodElement.class, false).filter(m -> ((ExecutableElement)m.getDeclaringElement()).equals(e)).collect(Collectors.toList());
                return ms.isEmpty() ? null : (JavaModelElement)ms.get(0);
            }

            private TypeElement findModelType(Element enclosingElement) {
                if (owner == null) {
                    return TypeElement.this.environment.getTypeMap().get(enclosingElement);
                }
                return owner;
            }
        }, null);
    }
}

