/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorState;
import com.networknt.schema.ValidatorTypeCode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesValidator
extends BaseJsonValidator
implements JsonValidator {
    public static final String PROPERTY = "properties";
    private static final Logger logger = LoggerFactory.getLogger(PropertiesValidator.class);
    private Map<String, JsonSchema> schemas = new HashMap<String, JsonSchema>();

    public PropertiesValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.PROPERTIES, validationContext);
        Iterator<String> it = schemaNode.fieldNames();
        while (it.hasNext()) {
            String pname = it.next();
            this.schemas.put(pname, new JsonSchema(validationContext, schemaPath + "/" + pname, parentSchema.getCurrentUri(), schemaNode.get(pname), parentSchema).initialize());
        }
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
        ValidatorState state = (ValidatorState)validatorState.get();
        if (state == null) {
            state = new ValidatorState();
            validatorState.set(state);
        }
        for (Map.Entry<String, JsonSchema> entry : this.schemas.entrySet()) {
            Set<ValidationMessage> requiredErrors;
            JsonSchema propertySchema = entry.getValue();
            JsonNode propertyNode = node.get(entry.getKey());
            if (propertyNode != null) {
                boolean isComplex = state.isComplexValidator();
                if (state.isComplexValidator()) {
                    state.setMatchedNode(true);
                }
                state.setComplexValidator(false);
                errors.addAll(propertySchema.validate(propertyNode, rootNode, at + "." + entry.getKey()));
                state.setComplexValidator(isComplex);
                if (!state.isComplexValidator()) continue;
                state.setMatchedNode(true);
                continue;
            }
            if (!this.getParentSchema().hasRequiredValidator() || (requiredErrors = this.getParentSchema().getRequiredValidator().validate(node, rootNode, at)).isEmpty()) continue;
            if (state.isComplexValidator()) {
                state.setMatchedNode(false);
                return Collections.unmodifiableSet(new LinkedHashSet());
            }
            errors.addAll(requiredErrors);
        }
        return Collections.unmodifiableSet(errors);
    }
}

