/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.classif.dsl;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.revapi.classif.StructuralMatcher;
import org.revapi.classif.dsl.ClassifBaseVisitor;
import org.revapi.classif.dsl.ClassifLexer;
import org.revapi.classif.dsl.ClassifParser;
import org.revapi.classif.dsl.ErrorFormatter;
import org.revapi.classif.match.NameMatch;
import org.revapi.classif.match.Operator;
import org.revapi.classif.match.declaration.AnnotationAttributeMatch;
import org.revapi.classif.match.declaration.AnnotationMatch;
import org.revapi.classif.match.declaration.AnnotationValueMatch;
import org.revapi.classif.match.declaration.AnnotationsMatch;
import org.revapi.classif.match.declaration.DeclarationMatch;
import org.revapi.classif.match.declaration.DefaultValueMatch;
import org.revapi.classif.match.declaration.ExtendsMatch;
import org.revapi.classif.match.declaration.ImplementsMatch;
import org.revapi.classif.match.declaration.MethodConstraintsMatch;
import org.revapi.classif.match.declaration.MethodParameterMatch;
import org.revapi.classif.match.declaration.Modifier;
import org.revapi.classif.match.declaration.ModifierClusterMatch;
import org.revapi.classif.match.declaration.ModifierMatch;
import org.revapi.classif.match.declaration.ModifiersMatch;
import org.revapi.classif.match.declaration.OverridesMatch;
import org.revapi.classif.match.declaration.ThrowsMatch;
import org.revapi.classif.match.declaration.TypeConstraintsMatch;
import org.revapi.classif.match.declaration.TypeKind;
import org.revapi.classif.match.declaration.TypeKindMatch;
import org.revapi.classif.match.declaration.UsedByMatch;
import org.revapi.classif.match.declaration.UsesMatch;
import org.revapi.classif.match.instance.FqnMatch;
import org.revapi.classif.match.instance.SingleTypeReferenceMatch;
import org.revapi.classif.match.instance.TypeParameterMatch;
import org.revapi.classif.match.instance.TypeParameterWildcardMatch;
import org.revapi.classif.match.instance.TypeParametersMatch;
import org.revapi.classif.match.instance.TypeReferenceMatch;
import org.revapi.classif.statement.AbstractStatement;
import org.revapi.classif.statement.FieldStatement;
import org.revapi.classif.statement.GenericStatement;
import org.revapi.classif.statement.MethodStatement;
import org.revapi.classif.statement.TypeDefinitionStatement;

public final class ClassifDSL {
    private static final DecimalFormat NUMBER_FORMAT = (DecimalFormat)DecimalFormat.getNumberInstance(Locale.ROOT);

    private ClassifDSL() {
        throw new AssertionError((Object)"I shall not be summoned.");
    }

    public static StructuralMatcher compile(final String program) {
        BaseErrorListener errorListener = new BaseErrorListener(){

            @Override
            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                throw new ParseCancellationException(ErrorFormatter.formatError(program, line, charPositionInLine, msg));
            }
        };
        ClassifLexer lexer = new ClassifLexer(CharStreams.fromString(program));
        lexer.removeErrorListeners();
        lexer.addErrorListener(errorListener);
        ClassifParser parser = new ClassifParser(new CommonTokenStream(lexer));
        parser.removeErrorListeners();
        parser.addErrorListener(errorListener);
        return parser.program().accept(ProgramVisitor.INSTANCE);
    }

    private static Pattern toRegex(TerminalNode node) {
        return Pattern.compile(ClassifDSL.stringContents(node));
    }

    private static Number toNumber(TerminalNode node) {
        ParsePosition pos = new ParsePosition(0);
        String s = node.getText();
        Number ret = NUMBER_FORMAT.parse(s, pos);
        if (pos.getErrorIndex() != -1 || pos.getIndex() != s.length()) {
            throw new IllegalArgumentException("Could not parse '" + s + "' as a number");
        }
        return ret;
    }

    private static boolean toBoolean(TerminalNode node) {
        String s = node.getText();
        boolean val = false;
        if ("true".equals(s)) {
            val = true;
        } else if (!"false".equals(s)) {
            throw new IllegalArgumentException("Could not parse '" + s + "' as a boolean.");
        }
        return val;
    }

    private static String stringContents(TerminalNode node) {
        String all = node.getText();
        all = all.substring(1, all.length() - 1);
        return all;
    }

    private static <T, R> R ifNotNull(T object, Function<T, R> action) {
        if (object == null) {
            return null;
        }
        return action.apply(object);
    }

    private static Operator toOperator(ClassifParser.OperatorContext ctx) {
        Operator op;
        if (ctx.EQ() != null) {
            op = Operator.EQ;
        } else if (ctx.NE() != null) {
            op = Operator.NE;
        } else if (ctx.LT() != null) {
            op = Operator.LT;
        } else if (ctx.LE() != null) {
            op = Operator.LE;
        } else if (ctx.GT() != null) {
            op = Operator.GT;
        } else if (ctx.GE() != null) {
            op = Operator.GE;
        } else {
            throw new IllegalArgumentException("Operator " + ctx.getText() + " not supported.");
        }
        return op;
    }

    static {
        NUMBER_FORMAT.setGroupingUsed(true);
        DecimalFormatSymbols symbols = NUMBER_FORMAT.getDecimalFormatSymbols();
        symbols.setGroupingSeparator('_');
        NUMBER_FORMAT.setDecimalFormatSymbols(symbols);
    }

    private static final class ReferencedVariablesAnd<T> {
        List<String> referencedVariables = new ArrayList<String>(2);
        T match;

        ReferencedVariablesAnd() {
        }

        ReferencedVariablesAnd(T match) {
            this.match = match;
        }
    }

    private static final class MethodConstraintsVisitor
    extends ClassifBaseVisitor<ReferencedVariablesAnd<MethodConstraintsMatch>> {
        static final MethodConstraintsVisitor INSTANCE = new MethodConstraintsVisitor();

        private MethodConstraintsVisitor() {
        }

        @Override
        public ReferencedVariablesAnd<MethodConstraintsMatch> visitMethodConstraints(ClassifParser.MethodConstraintsContext ctx) {
            ReferencedVariablesAnd<MethodConstraintsMatch> ret = new ReferencedVariablesAnd<MethodConstraintsMatch>();
            List<ClassifParser.MethodConstraintContext> mCtxs = ctx.methodConstraint();
            ArrayList<DeclarationMatch> constraints = new ArrayList<DeclarationMatch>(mCtxs.size());
            for (ClassifParser.MethodConstraintContext mctx : mCtxs) {
                if (mctx.USES() != null) {
                    boolean directly = mctx.DIRECTLY() != null;
                    ReferencedVariablesAnd<TypeReferenceMatch> type = mctx.typeReference().get(0).accept(TypeReferenceVisitor.INSTANCE);
                    constraints.add(new UsesMatch(directly, (TypeReferenceMatch)type.match));
                    ret.referencedVariables.addAll(type.referencedVariables);
                    continue;
                }
                if (mctx.THROWS() != null) {
                    List<ClassifParser.TypeReferenceContext> thrownCtx = mctx.typeReference();
                    ArrayList<TypeReferenceMatch> thrown = new ArrayList<TypeReferenceMatch>(thrownCtx.size());
                    for (ClassifParser.TypeReferenceContext tctx : thrownCtx) {
                        ReferencedVariablesAnd<TypeReferenceMatch> type = tctx.accept(TypeReferenceVisitor.INSTANCE);
                        thrown.add((TypeReferenceMatch)type.match);
                        ret.referencedVariables.addAll(type.referencedVariables);
                    }
                    constraints.add(new ThrowsMatch(thrown));
                    continue;
                }
                if (mctx.OVERRIDES() != null) {
                    List<ClassifParser.TypeReferenceContext> types = mctx.typeReference();
                    ClassifParser.TypeReferenceContext typeCtx = types.isEmpty() ? null : types.get(0);
                    ReferencedVariablesAnd<TypeReferenceMatch> type = typeCtx == null ? null : typeCtx.accept(TypeReferenceVisitor.INSTANCE);
                    constraints.add(new OverridesMatch(type == null ? null : (TypeReferenceMatch)type.match));
                    if (type == null) continue;
                    ret.referencedVariables.addAll(type.referencedVariables);
                    continue;
                }
                if (mctx.DEFAULT() == null) continue;
                boolean negation = mctx.not() != null;
                ReferencedVariablesAnd<AnnotationValueMatch> match = negation ? null : mctx.annotationValue().accept(new AnnotationValueVisitor(ClassifDSL.toOperator(mctx.operator())));
                constraints.add(new DefaultValueMatch(negation, match == null ? null : (AnnotationValueMatch)match.match));
                if (match == null) continue;
                ret.referencedVariables.addAll(match.referencedVariables);
            }
            ret.match = new MethodConstraintsMatch(constraints);
            return ret;
        }
    }

    private static final class ParameterListVisitor
    extends ClassifBaseVisitor<ReferencedVariablesAnd<List<MethodParameterMatch>>> {
        static final ParameterListVisitor INSTANCE = new ParameterListVisitor();

        private ParameterListVisitor() {
        }

        @Override
        public ReferencedVariablesAnd<List<MethodParameterMatch>> visitParameterList(ClassifParser.ParameterListContext ctx) {
            ReferencedVariablesAnd<List<MethodParameterMatch>> ret = new ReferencedVariablesAnd<List<MethodParameterMatch>>();
            ret.match = new ArrayList();
            ctx.methodParameter().forEach(p -> {
                AnnotationsMatch annos = null;
                if (p.annotations() != null) {
                    annos = new AnnotationsMatch(p.annotations().annotation().stream().map(a -> a.accept(AnnotationVisitor.INSTANCE)).peek(a -> ret.referencedVariables.addAll(a.referencedVariables)).map(a -> (AnnotationMatch)a.match).collect(Collectors.toList()));
                }
                ReferencedVariablesAnd<TypeReferenceMatch> type = p.typeReference().accept(TypeReferenceVisitor.INSTANCE);
                ret.referencedVariables.addAll(type.referencedVariables);
                ((List)ret.match).add(new MethodParameterMatch(annos, (TypeReferenceMatch)type.match));
            });
            return ret;
        }
    }

    private static final class MethodRestStatementVisitor
    extends ClassifBaseVisitor<MethodStatement> {
        private final List<ReferencedVariablesAnd<AnnotationMatch>> annotations;
        private final ModifiersMatch modifiers;
        private final ReferencedVariablesAnd<TypeReferenceMatch> returnType;
        private final ReferencedVariablesAnd<TypeReferenceMatch> declaringType;
        private final ReferencedVariablesAnd<TypeParametersMatch> typeParams;
        private final boolean isReturn;
        private final boolean negation;
        private final NameMatch name;
        private final String definedName;

        private MethodRestStatementVisitor(List<ReferencedVariablesAnd<AnnotationMatch>> annotations, ModifiersMatch modifiers, ReferencedVariablesAnd<TypeReferenceMatch> returnType, ReferencedVariablesAnd<TypeReferenceMatch> declaringType, ReferencedVariablesAnd<TypeParametersMatch> typeParams, boolean isReturn, boolean negation, NameMatch name, String definedName) {
            this.annotations = annotations;
            this.modifiers = modifiers;
            this.returnType = returnType;
            this.declaringType = declaringType;
            this.typeParams = typeParams;
            this.isReturn = isReturn;
            this.negation = negation;
            this.name = name;
            this.definedName = definedName;
        }

        @Override
        public MethodStatement visitMethodRestStatement(ClassifParser.MethodRestStatementContext ctx) {
            ReferencedVariablesAnd<List<MethodParameterMatch>> params = null;
            ReferencedVariablesAnd<MethodConstraintsMatch> constraints = null;
            ArrayList<String> reffed = new ArrayList<String>();
            if (ctx.parameterList() != null) {
                params = ctx.parameterList().accept(ParameterListVisitor.INSTANCE);
                reffed.addAll(params.referencedVariables);
            }
            if (ctx.methodConstraints() != null) {
                constraints = ctx.methodConstraints().accept(MethodConstraintsVisitor.INSTANCE);
                reffed.addAll(constraints.referencedVariables);
            }
            AnnotationsMatch annos = null;
            if (!this.annotations.isEmpty()) {
                ArrayList<AnnotationMatch> ams = new ArrayList<AnnotationMatch>(this.annotations.size());
                this.annotations.forEach(a -> {
                    reffed.addAll(a.referencedVariables);
                    ams.add((AnnotationMatch)a.match);
                });
                annos = new AnnotationsMatch(ams);
            } else {
                annos = new AnnotationsMatch(Collections.emptyList());
            }
            if (this.returnType != null) {
                reffed.addAll(this.returnType.referencedVariables);
            }
            if (this.declaringType != null) {
                reffed.addAll(this.declaringType.referencedVariables);
            }
            if (this.typeParams != null) {
                reffed.addAll(this.typeParams.referencedVariables);
            }
            return new MethodStatement(this.definedName, reffed, annos, this.modifiers, this.isReturn, this.name, this.returnType == null ? null : (TypeReferenceMatch)this.returnType.match, this.declaringType == null ? null : (TypeReferenceMatch)this.declaringType.match, this.typeParams == null ? null : (TypeParametersMatch)this.typeParams.match, params == null ? Collections.emptyList() : (List)params.match, constraints == null ? null : (MethodConstraintsMatch)constraints.match, this.negation);
        }
    }

    private static final class MethodNameAndRestStatementVisitor
    extends ClassifBaseVisitor<MethodStatement> {
        private final List<ReferencedVariablesAnd<AnnotationMatch>> annotations;
        private final ModifiersMatch modifiers;
        private final ReferencedVariablesAnd<TypeReferenceMatch> returnType;
        private final ReferencedVariablesAnd<TypeReferenceMatch> declaringType;
        private final ReferencedVariablesAnd<TypeParametersMatch> typeParams;

        private MethodNameAndRestStatementVisitor(List<ReferencedVariablesAnd<AnnotationMatch>> annotations, ModifiersMatch modifiers, ReferencedVariablesAnd<TypeReferenceMatch> returnType, ReferencedVariablesAnd<TypeParametersMatch> typeParams, ReferencedVariablesAnd<TypeReferenceMatch> declaringType) {
            this.annotations = annotations;
            this.modifiers = modifiers;
            this.returnType = returnType;
            this.typeParams = typeParams;
            this.declaringType = declaringType;
        }

        @Override
        public MethodStatement visitMethodNameAndRestStatement(ClassifParser.MethodNameAndRestStatementContext ctx) {
            boolean isReturn = ctx.returned() != null;
            boolean negation = ctx.not() != null;
            NameMatch name = ctx.name().accept(NameVisitor.INSTANCE);
            String definedName = ctx.assignment() == null ? null : ctx.assignment().resolvedName().getText();
            return new MethodRestStatementVisitor(this.annotations, this.modifiers, this.returnType, this.declaringType, this.typeParams, isReturn, negation, name, definedName).visitMethodRestStatement(ctx.methodRestStatement());
        }
    }

    private static final class FieldNameOrMethodWithoutReturnType
    extends ClassifBaseVisitor<AbstractStatement> {
        private final List<ReferencedVariablesAnd<AnnotationMatch>> annotations;
        private final ModifiersMatch modifiers;
        private final ReferencedVariablesAnd<TypeReferenceMatch> type;

        private FieldNameOrMethodWithoutReturnType(List<ReferencedVariablesAnd<AnnotationMatch>> annotations, ModifiersMatch modifiers, ReferencedVariablesAnd<TypeReferenceMatch> type) {
            this.annotations = annotations;
            this.modifiers = modifiers;
            this.type = type;
        }

        @Override
        public AbstractStatement visitFieldNameOrMethodWithoutReturnType(ClassifParser.FieldNameOrMethodWithoutReturnTypeContext ctx) {
            ReferencedVariablesAnd<TypeReferenceMatch> declaringType = null;
            if (ctx.typeReference() != null) {
                declaringType = ctx.typeReference().accept(TypeReferenceVisitor.INSTANCE);
            }
            boolean isReturn = ctx.returned() != null;
            String definedName = ctx.assignment() == null ? null : ctx.assignment().resolvedName().getText();
            boolean negation = ctx.not() != null;
            NameMatch name = ctx.name().accept(NameVisitor.INSTANCE);
            if (ctx.methodRestStatement() != null) {
                return new MethodRestStatementVisitor(this.annotations, this.modifiers, this.type, declaringType, null, isReturn, negation, name, definedName).visitMethodRestStatement(ctx.methodRestStatement());
            }
            ArrayList<String> referenced = new ArrayList<String>(4);
            UsesMatch fieldConstraints = null;
            if (ctx.fieldConstraints() != null) {
                ClassifParser.FieldConstraintsContext constraints = ctx.fieldConstraints();
                ReferencedVariablesAnd<TypeReferenceMatch> useType = constraints.typeReference().accept(TypeReferenceVisitor.INSTANCE);
                boolean direct = constraints.DIRECTLY() != null;
                fieldConstraints = new UsesMatch(direct, (TypeReferenceMatch)useType.match);
                referenced.addAll(useType.referencedVariables);
            }
            AnnotationsMatch annos = new AnnotationsMatch(this.annotations.stream().peek(ref -> referenced.addAll(ref.referencedVariables)).map(ref -> (AnnotationMatch)ref.match).collect(Collectors.toList()));
            if (this.type != null) {
                referenced.addAll(this.type.referencedVariables);
            }
            if (declaringType != null) {
                referenced.addAll(declaringType.referencedVariables);
            }
            return new FieldStatement(definedName, referenced, annos, this.modifiers, isReturn, negation, name, this.type == null ? null : (TypeReferenceMatch)this.type.match, declaringType == null ? null : (TypeReferenceMatch)declaringType.match, fieldConstraints);
        }
    }

    private static final class FieldOrMethodWithoutTypeParametersVisitor
    extends ClassifBaseVisitor<AbstractStatement> {
        private final List<ReferencedVariablesAnd<AnnotationMatch>> annotations;
        private final ModifiersMatch modifiers;

        FieldOrMethodWithoutTypeParametersVisitor(List<ReferencedVariablesAnd<AnnotationMatch>> annotations, ModifiersMatch modifiers) {
            this.annotations = annotations;
            this.modifiers = modifiers;
        }

        @Override
        public AbstractStatement visitFieldOrMethodWithoutTypeParameters(ClassifParser.FieldOrMethodWithoutTypeParametersContext ctx) {
            ReferencedVariablesAnd<TypeReferenceMatch> type = null;
            if (ctx.typeReference() != null) {
                type = ctx.typeReference().accept(TypeReferenceVisitor.INSTANCE);
            }
            return new FieldNameOrMethodWithoutReturnType(this.annotations, this.modifiers, type).visitFieldNameOrMethodWithoutReturnType(ctx.fieldNameOrMethodWithoutReturnType());
        }
    }

    private static final class MethodAfterTypeParametersStatementVisitor
    extends ClassifBaseVisitor<MethodStatement> {
        private final List<ReferencedVariablesAnd<AnnotationMatch>> annotations;
        private final ModifiersMatch modifiers;
        private final ReferencedVariablesAnd<TypeParametersMatch> typeParams;

        MethodAfterTypeParametersStatementVisitor(List<ReferencedVariablesAnd<AnnotationMatch>> annotations, ModifiersMatch modifiers, ReferencedVariablesAnd<TypeParametersMatch> typeParams) {
            this.annotations = annotations;
            this.modifiers = modifiers;
            this.typeParams = typeParams;
        }

        @Override
        public MethodStatement visitMethodAfterTypeParametersStatement(ClassifParser.MethodAfterTypeParametersStatementContext ctx) {
            ReferencedVariablesAnd<TypeReferenceMatch> returnType = null;
            ReferencedVariablesAnd<TypeReferenceMatch> declaringType = null;
            List<ClassifParser.TypeReferenceContext> types = ctx.typeReference();
            if (types != null && !types.isEmpty()) {
                if (ctx.DOUBLE_COLON() != null) {
                    if (types.size() == 1) {
                        declaringType = types.get(0).accept(TypeReferenceVisitor.INSTANCE);
                    } else {
                        returnType = types.get(0).accept(TypeReferenceVisitor.INSTANCE);
                        declaringType = types.get(1).accept(TypeReferenceVisitor.INSTANCE);
                    }
                } else {
                    returnType = types.get(0).accept(TypeReferenceVisitor.INSTANCE);
                }
            }
            return (MethodStatement)new MethodNameAndRestStatementVisitor(this.annotations, this.modifiers, returnType, this.typeParams, declaringType).visit(ctx.methodNameAndRestStatement());
        }
    }

    private static final class FieldOrMethodOrTypeStatementVisitor
    extends ClassifBaseVisitor<AbstractStatement> {
        private final List<ReferencedVariablesAnd<AnnotationMatch>> annotations;
        private final ModifiersMatch modifiers;

        private FieldOrMethodOrTypeStatementVisitor(List<ReferencedVariablesAnd<AnnotationMatch>> annotations, ModifiersMatch modifiers) {
            this.annotations = annotations;
            this.modifiers = modifiers;
        }

        @Override
        public AbstractStatement visitFieldOrMethodOrTypeStatement(ClassifParser.FieldOrMethodOrTypeStatementContext ctx) {
            if (ctx.typeDefinition() != null) {
                return new TypeDefinitionVisitor(this.annotations, this.modifiers).visitTypeDefinition(ctx.typeDefinition());
            }
            if (ctx.typeParameters() != null) {
                ReferencedVariablesAnd<TypeParametersMatch> typeParams = ctx.typeParameters().accept(TypeParametersVisitor.INSTANCE);
                return new MethodAfterTypeParametersStatementVisitor(this.annotations, this.modifiers, typeParams).visitMethodAfterTypeParametersStatement(ctx.methodAfterTypeParametersStatement());
            }
            return new FieldOrMethodWithoutTypeParametersVisitor(this.annotations, this.modifiers).visitFieldOrMethodWithoutTypeParameters(ctx.fieldOrMethodWithoutTypeParameters());
        }
    }

    private static final class ElementStatementVisitor
    extends ClassifBaseVisitor<AbstractStatement> {
        static final ElementStatementVisitor INSTANCE = new ElementStatementVisitor();

        private ElementStatementVisitor() {
        }

        @Override
        public AbstractStatement visitElementStatement(ClassifParser.ElementStatementContext ctx) {
            List annos = ctx.annotations().annotation().stream().map(a -> a.accept(AnnotationVisitor.INSTANCE)).collect(Collectors.toList());
            ModifiersMatch modifiers = new ModifiersMatch(ctx.modifiers().modifierCluster().stream().map(cc -> new ModifierClusterMatch(cc.modifier().stream().map(mc -> {
                boolean negation = mc.not() != null;
                String text = negation ? mc.getText().substring(1) : mc.getText();
                return new ModifierMatch(negation, Modifier.fromString(text));
            }).collect(Collectors.toList()))).collect(Collectors.toList()));
            return new FieldOrMethodOrTypeStatementVisitor(annos, modifiers).visitFieldOrMethodOrTypeStatement(ctx.fieldOrMethodOrTypeStatement());
        }
    }

    private static final class TypeConstraintsVisitor
    extends ClassifBaseVisitor<ReferencedVariablesAnd<TypeConstraintsMatch>> {
        static final TypeConstraintsVisitor INSTANCE = new TypeConstraintsVisitor();

        private TypeConstraintsVisitor() {
        }

        @Override
        public ReferencedVariablesAnd<TypeConstraintsMatch> visitTypeConstraints(ClassifParser.TypeConstraintsContext ctx) {
            ReferencedVariablesAnd<TypeConstraintsMatch> ret = new ReferencedVariablesAnd<TypeConstraintsMatch>();
            ArrayList<ImplementsMatch> implemented = new ArrayList<ImplementsMatch>(2);
            ArrayList<UsesMatch> uses = new ArrayList<UsesMatch>(2);
            ArrayList<UsedByMatch> usedBys = new ArrayList<UsedByMatch>(2);
            ExtendsMatch[] extended = new ExtendsMatch[1];
            ctx.typeConstraint().forEach(constraintCtx -> {
                if (constraintCtx.IMPLEMENTS() != null) {
                    boolean onlyDirect = constraintCtx.DIRECTLY() != null;
                    boolean exact = constraintCtx.EXACTLY() != null;
                    List<TypeReferenceMatch> types = constraintCtx.typeReference().stream().map(typeRef -> {
                        ReferencedVariablesAnd m = (ReferencedVariablesAnd)TypeReferenceVisitor.INSTANCE.visit((ParseTree)typeRef);
                        ret.referencedVariables.addAll(m.referencedVariables);
                        return (TypeReferenceMatch)m.match;
                    }).collect(Collectors.toList());
                    implemented.add(new ImplementsMatch(onlyDirect, exact, types));
                } else if (constraintCtx.USES() != null) {
                    boolean onlyDirect = constraintCtx.DIRECTLY() != null;
                    ReferencedVariablesAnd<TypeReferenceMatch> type = constraintCtx.typeReference().get(0).accept(TypeReferenceVisitor.INSTANCE);
                    ret.referencedVariables.addAll(type.referencedVariables);
                    uses.add(new UsesMatch(onlyDirect, (TypeReferenceMatch)type.match));
                } else if (constraintCtx.EXTENDS() != null) {
                    boolean onlyDirect = constraintCtx.DIRECTLY() != null;
                    ReferencedVariablesAnd<TypeReferenceMatch> type = constraintCtx.typeReference().get(0).accept(TypeReferenceVisitor.INSTANCE);
                    ret.referencedVariables.addAll(type.referencedVariables);
                    extended[0] = new ExtendsMatch(onlyDirect, (TypeReferenceMatch)type.match);
                } else if (constraintCtx.USED_BY() != null) {
                    boolean onlyDirect = constraintCtx.DIRECTLY() != null;
                    List<String> variables = constraintCtx.variables().variable().stream().map(v -> v.accept(VariableVisitor.INSTANCE)).collect(Collectors.toList());
                    ret.referencedVariables.addAll(variables);
                    usedBys.add(new UsedByMatch(onlyDirect, variables));
                }
            });
            ret.match = new TypeConstraintsMatch(implemented, extended[0], uses, usedBys);
            return ret;
        }
    }

    private static final class GenericConstraintVisitor
    extends ClassifBaseVisitor<ReferencedVariablesAnd<UsesMatch>> {
        static final GenericConstraintVisitor INSTANCE = new GenericConstraintVisitor();

        private GenericConstraintVisitor() {
        }

        @Override
        public ReferencedVariablesAnd<UsesMatch> visitGenericConstraints(ClassifParser.GenericConstraintsContext ctx) {
            ReferencedVariablesAnd<TypeReferenceMatch> type = ctx.typeReference().accept(TypeReferenceVisitor.INSTANCE);
            boolean onlyDirect = ctx.DIRECTLY() != null;
            ReferencedVariablesAnd<UsesMatch> ret = new ReferencedVariablesAnd<UsesMatch>();
            ret.referencedVariables = type.referencedVariables;
            ret.match = new UsesMatch(onlyDirect, (TypeReferenceMatch)type.match);
            return ret;
        }
    }

    private static final class TypeKindVisitor
    extends ClassifBaseVisitor<TypeKindMatch> {
        private static final TypeKindVisitor INSTANCE = new TypeKindVisitor();

        private TypeKindVisitor() {
        }

        @Override
        public TypeKindMatch visitTypeKind(ClassifParser.TypeKindContext ctx) {
            boolean neg = ctx.not() != null;
            String typeKind = neg ? ctx.getText().substring(ctx.not().getText().length()) : ctx.getText();
            return new TypeKindMatch(neg, TypeKind.fromString(typeKind));
        }
    }

    private static final class GenericStatementVisitor
    extends ClassifBaseVisitor<GenericStatement> {
        private final AnnotationsMatch annotations;
        private final ModifiersMatch modifiers;
        private final List<String> referenced = new ArrayList<String>();

        private GenericStatementVisitor(List<ReferencedVariablesAnd<AnnotationMatch>> annotations, ModifiersMatch modifiers) {
            this.annotations = new AnnotationsMatch(annotations.stream().map(a -> {
                this.referenced.addAll(a.referencedVariables);
                return (AnnotationMatch)a.match;
            }).collect(Collectors.toList()));
            this.modifiers = modifiers;
        }

        @Override
        public GenericStatement visitGenericStatement(ClassifParser.GenericStatementContext ctx) {
            boolean isMatch = ctx.returned() != null;
            boolean negation = ctx.not() != null;
            String variable = ctx.assignment() == null ? null : ctx.assignment().resolvedName().getText();
            UsesMatch uses = null;
            if (ctx.genericConstraints() != null) {
                ReferencedVariablesAnd usesAndVars = (ReferencedVariablesAnd)GenericConstraintVisitor.INSTANCE.visit(ctx.genericConstraints());
                this.referenced.addAll(usesAndVars.referencedVariables);
                uses = (UsesMatch)usesAndVars.match;
            }
            return new GenericStatement(variable, this.referenced, this.annotations, this.modifiers, isMatch, negation, uses);
        }
    }

    private static final class TypeDefinitionVisitor
    extends ClassifBaseVisitor<TypeDefinitionStatement> {
        private final AnnotationsMatch annotations;
        private final ModifiersMatch modifiers;
        private final List<String> referenced = new ArrayList<String>();

        private TypeDefinitionVisitor(List<ReferencedVariablesAnd<AnnotationMatch>> annotations, ModifiersMatch modifiers) {
            this.annotations = new AnnotationsMatch(annotations.stream().map(a -> {
                this.referenced.addAll(a.referencedVariables);
                return (AnnotationMatch)a.match;
            }).collect(Collectors.toList()));
            this.modifiers = modifiers;
        }

        @Override
        public TypeDefinitionStatement visitTypeDefinition(ClassifParser.TypeDefinitionContext ctx) {
            TypeKindMatch typeKind = TypeKindVisitor.INSTANCE.visitTypeKind(ctx.typeKind());
            boolean isMatch = ctx.returned() != null;
            ArrayList<String> reffed = new ArrayList<String>(2);
            TypeConstraintsMatch constraints = null;
            if (ctx.typeConstraints() != null) {
                ReferencedVariablesAnd constrs = (ReferencedVariablesAnd)TypeConstraintsVisitor.INSTANCE.visit(ctx.typeConstraints());
                reffed.addAll(constrs.referencedVariables);
                constraints = (TypeConstraintsMatch)constrs.match;
            }
            if (ctx.possibleTypeAssignment() == null) {
                reffed.addAll(this.referenced);
                TypeDefinitionStatement type = new TypeDefinitionStatement(null, reffed, this.annotations, this.modifiers, typeKind, new FqnMatch(Collections.singletonList(NameMatch.any())), null, constraints, false, isMatch);
                for (ClassifParser.ElementStatementContext elementStatementContext : ctx.elementStatement()) {
                    type.getChildren().add(ElementStatementVisitor.INSTANCE.visit(elementStatementContext));
                }
                return type;
            }
            FqnMatch fqn = (FqnMatch)FqnVisitor.INSTANCE.visit(ctx.possibleTypeAssignment().fqn());
            ReferencedVariablesAnd tps = null;
            if (ctx.possibleTypeAssignment().typeParameters() != null) {
                tps = (ReferencedVariablesAnd)TypeParametersVisitor.INSTANCE.visit(ctx.possibleTypeAssignment().typeParameters());
            }
            boolean negation = ctx.possibleTypeAssignment().not() != null;
            String variable = null;
            if (ctx.possibleTypeAssignment().assignment() != null) {
                variable = ctx.possibleTypeAssignment().assignment().resolvedName().getText();
            }
            if (tps != null) {
                reffed.addAll(tps.referencedVariables);
            }
            reffed.addAll(this.referenced);
            TypeDefinitionStatement type = new TypeDefinitionStatement(variable, reffed, this.annotations, this.modifiers, typeKind, fqn, tps == null ? null : (TypeParametersMatch)tps.match, constraints, negation, isMatch);
            for (ClassifParser.ElementStatementContext elementStatementContext : ctx.elementStatement()) {
                type.getChildren().add(ElementStatementVisitor.INSTANCE.visit(elementStatementContext));
            }
            return type;
        }
    }

    private static final class TypeParametersVisitor
    extends ClassifBaseVisitor<ReferencedVariablesAnd<TypeParametersMatch>> {
        static final TypeParametersVisitor INSTANCE = new TypeParametersVisitor();

        private TypeParametersVisitor() {
        }

        @Override
        public ReferencedVariablesAnd<TypeParametersMatch> visitTypeParameters(ClassifParser.TypeParametersContext ctx) {
            ReferencedVariablesAnd<TypeParametersMatch> ret = new ReferencedVariablesAnd<TypeParametersMatch>();
            List<TypeParameterMatch> params = ctx.typeParam().stream().map(tp -> {
                if (tp.typeParamWildcard() != null) {
                    Object w = TypeParamWildcardVisitor.INSTANCE.visitTypeParamWildcard(tp.typeParamWildcard());
                    ret.referencedVariables.addAll(((ReferencedVariablesAnd)w).referencedVariables);
                    return new TypeParameterMatch((TypeParameterWildcardMatch)((ReferencedVariablesAnd)w).match, Collections.emptyList());
                }
                return new TypeParameterMatch(null, tp.typeReference().stream().map(tr -> {
                    Object m = TypeReferenceVisitor.INSTANCE.visitTypeReference((ClassifParser.TypeReferenceContext)tr);
                    ret.referencedVariables.addAll(((ReferencedVariablesAnd)m).referencedVariables);
                    return (TypeReferenceMatch)((ReferencedVariablesAnd)m).match;
                }).collect(Collectors.toList()));
            }).collect(Collectors.toList());
            ret.match = new TypeParametersMatch(params);
            return ret;
        }
    }

    private static final class TypeParamWildcardVisitor
    extends ClassifBaseVisitor<ReferencedVariablesAnd<TypeParameterWildcardMatch>> {
        static final TypeParamWildcardVisitor INSTANCE = new TypeParamWildcardVisitor();

        private TypeParamWildcardVisitor() {
        }

        @Override
        public ReferencedVariablesAnd<TypeParameterWildcardMatch> visitTypeParamWildcard(ClassifParser.TypeParamWildcardContext ctx) {
            ReferencedVariablesAnd<TypeParameterWildcardMatch> ret = new ReferencedVariablesAnd<TypeParameterWildcardMatch>();
            boolean isExtends = ctx.EXTENDS() != null;
            List<TypeReferenceMatch> bounds = ctx.typeReference().stream().map(tr -> {
                Object m = TypeReferenceVisitor.INSTANCE.visitTypeReference((ClassifParser.TypeReferenceContext)tr);
                ret.referencedVariables.addAll(((ReferencedVariablesAnd)m).referencedVariables);
                return (TypeReferenceMatch)((ReferencedVariablesAnd)m).match;
            }).collect(Collectors.toList());
            ret.match = new TypeParameterWildcardMatch(isExtends, bounds);
            return ret;
        }
    }

    private static final class TypeReferenceVisitor
    extends ClassifBaseVisitor<ReferencedVariablesAnd<TypeReferenceMatch>> {
        static final TypeReferenceVisitor INSTANCE = new TypeReferenceVisitor();

        private TypeReferenceVisitor() {
        }

        @Override
        public ReferencedVariablesAnd<TypeReferenceMatch> visitTypeReference(ClassifParser.TypeReferenceContext ctx) {
            ReferencedVariablesAnd<TypeReferenceMatch> ret = new ReferencedVariablesAnd<TypeReferenceMatch>();
            ret.match = new TypeReferenceMatch(ctx.singleTypeReference().stream().map(sctx -> {
                String variable;
                ReferencedVariablesAnd tps;
                FqnMatch fqn = sctx.fqn() == null ? null : (FqnMatch)FqnVisitor.INSTANCE.visit(sctx.fqn());
                ReferencedVariablesAnd referencedVariablesAnd = tps = sctx.typeParameters() == null ? null : (ReferencedVariablesAnd)TypeParametersVisitor.INSTANCE.visit(sctx.typeParameters());
                if (tps != null) {
                    ret.referencedVariables.addAll(tps.referencedVariables);
                }
                String string = variable = sctx.variable() == null ? null : (String)VariableVisitor.INSTANCE.visit(sctx.variable());
                if (variable != null) {
                    ret.referencedVariables.add(variable);
                }
                boolean negation = sctx.not() != null;
                int arrayDimension = sctx.arrayType().size();
                return new SingleTypeReferenceMatch(fqn, tps == null ? null : (TypeParametersMatch)tps.match, variable, negation, arrayDimension);
            }).collect(Collectors.toList()));
            return ret;
        }
    }

    private static final class AnnotationValueArrayContentsVisitor
    extends ClassifBaseVisitor<List<ReferencedVariablesAnd<AnnotationValueMatch>>> {
        static final AnnotationValueArrayContentsVisitor INSTANCE = new AnnotationValueArrayContentsVisitor();

        private AnnotationValueArrayContentsVisitor() {
        }

        @Override
        public List<ReferencedVariablesAnd<AnnotationValueMatch>> visitAnnotationValueArrayContents(ClassifParser.AnnotationValueArrayContentsContext ctx) {
            ArrayList<ReferencedVariablesAnd<AnnotationValueMatch>> ret = new ArrayList<ReferencedVariablesAnd<AnnotationValueMatch>>();
            ReferencedVariablesAnd<AnnotationValueMatch> firstForRecursion = null;
            if (ctx.annotationValueArray_strings() != null) {
                ClassifParser.AnnotationValueArray_stringsContext strCtx = ctx.annotationValueArray_strings();
                ret.add(new ReferencedVariablesAnd<AnnotationValueMatch>(AnnotationValueMatch.string(Operator.EQ, ClassifDSL.stringContents(strCtx.STRING()))));
                strCtx.annotationValueArray_strings_next().forEach(n -> {
                    if (n.STRING() != null) {
                        ret.add(new ReferencedVariablesAnd<AnnotationValueMatch>(AnnotationValueMatch.string(Operator.EQ, ClassifDSL.stringContents(n.STRING()))));
                    } else if (n.REGEX() != null) {
                        ret.add(new ReferencedVariablesAnd<AnnotationValueMatch>(AnnotationValueMatch.regex(Operator.EQ, ClassifDSL.toRegex(n.REGEX()))));
                    } else if (n.ANY() != null) {
                        ret.add(new ReferencedVariablesAnd<AnnotationValueMatch>(AnnotationValueMatch.any(Operator.EQ)));
                    } else if (n.ANY_NUMBER_OF_THINGS() != null) {
                        ret.add(new ReferencedVariablesAnd<AnnotationValueMatch>(AnnotationValueMatch.all()));
                    }
                });
            } else if (ctx.annotationValueArray_numbers() != null) {
                ClassifParser.AnnotationValueArray_numbersContext numCtx = ctx.annotationValueArray_numbers();
                Number num = ClassifDSL.toNumber(numCtx.NUMBER());
                ret.add(new ReferencedVariablesAnd<AnnotationValueMatch>(AnnotationValueMatch.number(Operator.EQ, num)));
                numCtx.annotationValueArray_numbers_next().forEach(n -> {
                    if (n.NUMBER() != null) {
                        ret.add(new ReferencedVariablesAnd<AnnotationValueMatch>(AnnotationValueMatch.number(Operator.EQ, ClassifDSL.toNumber(n.NUMBER()))));
                    } else if (n.REGEX() != null) {
                        ret.add(new ReferencedVariablesAnd<AnnotationValueMatch>(AnnotationValueMatch.regex(Operator.EQ, ClassifDSL.toRegex(n.REGEX()))));
                    } else if (n.ANY() != null) {
                        ret.add(new ReferencedVariablesAnd<AnnotationValueMatch>(AnnotationValueMatch.any(Operator.EQ)));
                    } else if (n.ANY_NUMBER_OF_THINGS() != null) {
                        ret.add(new ReferencedVariablesAnd<AnnotationValueMatch>(AnnotationValueMatch.all()));
                    }
                });
            } else if (ctx.annotationValueArray_booleans() != null) {
                ClassifParser.AnnotationValueArray_booleansContext boolCtx = ctx.annotationValueArray_booleans();
                ret.add(new ReferencedVariablesAnd<AnnotationValueMatch>(AnnotationValueMatch.bool(Operator.EQ, ClassifDSL.toBoolean(boolCtx.BOOLEAN()))));
                boolCtx.annotationValueArray_booleans_next().forEach(n -> {
                    if (n.BOOLEAN() != null) {
                        ret.add(new ReferencedVariablesAnd<AnnotationValueMatch>(AnnotationValueMatch.bool(Operator.EQ, ClassifDSL.toBoolean(n.BOOLEAN()))));
                    } else if (n.REGEX() != null) {
                        ret.add(new ReferencedVariablesAnd<AnnotationValueMatch>(AnnotationValueMatch.regex(Operator.EQ, ClassifDSL.toRegex(n.REGEX()))));
                    } else if (n.ANY() != null) {
                        ret.add(new ReferencedVariablesAnd<AnnotationValueMatch>(AnnotationValueMatch.any(Operator.EQ)));
                    } else if (n.ANY_NUMBER_OF_THINGS() != null) {
                        ret.add(new ReferencedVariablesAnd<AnnotationValueMatch>(AnnotationValueMatch.all()));
                    }
                });
            } else if (ctx.annotationValueArray_types() != null) {
                ClassifParser.AnnotationValueArray_typesContext typeCtx = ctx.annotationValueArray_types();
                ReferencedVariablesAnd<TypeReferenceMatch> m = typeCtx.typeReference().accept(TypeReferenceVisitor.INSTANCE);
                ReferencedVariablesAnd am = new ReferencedVariablesAnd();
                am.referencedVariables.addAll(m.referencedVariables);
                am.match = AnnotationValueMatch.type(Operator.EQ, (TypeReferenceMatch)m.match);
                ret.add(am);
                typeCtx.annotationValueArray_types_next().forEach(n -> {
                    if (n.typeReference() != null) {
                        ReferencedVariablesAnd<TypeReferenceMatch> nm = n.typeReference().accept(TypeReferenceVisitor.INSTANCE);
                        ReferencedVariablesAnd nam = new ReferencedVariablesAnd();
                        nam.referencedVariables.addAll(nm.referencedVariables);
                        nam.match = AnnotationValueMatch.type(Operator.EQ, (TypeReferenceMatch)nm.match);
                        ret.add(nam);
                    } else if (n.ANY() != null) {
                        ret.add(new ReferencedVariablesAnd<AnnotationValueMatch>(AnnotationValueMatch.any(Operator.EQ)));
                    } else if (n.ANY_NUMBER_OF_THINGS() != null) {
                        ret.add(new ReferencedVariablesAnd<AnnotationValueMatch>(AnnotationValueMatch.all()));
                    }
                });
            } else if (ctx.annotationValueArray_enums() != null) {
                ClassifParser.AnnotationValueArray_enumsContext eCtx = ctx.annotationValueArray_enums();
                FqnMatch fqn = eCtx.fqn().accept(FqnVisitor.INSTANCE);
                NameMatch name = eCtx.name().accept(NameVisitor.INSTANCE);
                ret.add(new ReferencedVariablesAnd<AnnotationValueMatch>(AnnotationValueMatch.enumConstant(Operator.EQ, fqn, name)));
                eCtx.annotationValueArray_enums_next().forEach(n -> {
                    if (n.fqn() != null) {
                        FqnMatch nextFqn = n.fqn().accept(FqnVisitor.INSTANCE);
                        NameMatch nextName = n.name().accept(NameVisitor.INSTANCE);
                        ret.add(new ReferencedVariablesAnd<AnnotationValueMatch>(AnnotationValueMatch.enumConstant(Operator.EQ, nextFqn, nextName)));
                    } else if (n.ANY() != null) {
                        ret.add(new ReferencedVariablesAnd<AnnotationValueMatch>(AnnotationValueMatch.any(Operator.EQ)));
                    } else if (n.ANY_NUMBER_OF_THINGS() != null) {
                        ret.add(new ReferencedVariablesAnd<AnnotationValueMatch>(AnnotationValueMatch.all()));
                    }
                });
            } else if (ctx.annotationValueArray_annotations() != null) {
                ClassifParser.AnnotationValueArray_annotationsContext annoCtx = ctx.annotationValueArray_annotations();
                ReferencedVariablesAnd<AnnotationMatch> m = annoCtx.annotation().accept(AnnotationVisitor.INSTANCE);
                ReferencedVariablesAnd am = new ReferencedVariablesAnd();
                am.referencedVariables.addAll(m.referencedVariables);
                am.match = AnnotationValueMatch.annotation(Operator.EQ, (AnnotationMatch)m.match);
                ret.add(am);
                annoCtx.annotationValueArray_annotations_next().forEach(n -> {
                    if (n.annotation() != null) {
                        ReferencedVariablesAnd<AnnotationMatch> nm = n.annotation().accept(AnnotationVisitor.INSTANCE);
                        ReferencedVariablesAnd nam = new ReferencedVariablesAnd();
                        nam.referencedVariables.addAll(nm.referencedVariables);
                        nam.match = AnnotationValueMatch.annotation(Operator.EQ, (AnnotationMatch)nm.match);
                        ret.add(nam);
                    } else if (n.ANY() != null) {
                        ret.add(new ReferencedVariablesAnd<AnnotationValueMatch>(AnnotationValueMatch.any(Operator.EQ)));
                    } else if (n.ANY_NUMBER_OF_THINGS() != null) {
                        ret.add(new ReferencedVariablesAnd<AnnotationValueMatch>(AnnotationValueMatch.all()));
                    }
                });
            } else if (ctx.REGEX() != null) {
                firstForRecursion = new ReferencedVariablesAnd<AnnotationValueMatch>(AnnotationValueMatch.regex(Operator.EQ, ClassifDSL.toRegex(ctx.REGEX())));
            } else if (ctx.ANY() != null) {
                firstForRecursion = new ReferencedVariablesAnd<AnnotationValueMatch>(AnnotationValueMatch.any(Operator.EQ));
            } else if (ctx.ANY_NUMBER_OF_THINGS() != null) {
                firstForRecursion = new ReferencedVariablesAnd<AnnotationValueMatch>(AnnotationValueMatch.all());
            }
            if (firstForRecursion != null) {
                ret.add(firstForRecursion);
                if (ctx.annotationValueArrayContents() != null) {
                    List<ReferencedVariablesAnd<AnnotationValueMatch>> tail = ctx.annotationValueArrayContents().accept(this);
                    ret.addAll(tail);
                }
            }
            return ret;
        }
    }

    private static final class AnnotationValueVisitor
    extends ClassifBaseVisitor<ReferencedVariablesAnd<AnnotationValueMatch>> {
        private final Operator operator;

        private AnnotationValueVisitor(Operator operator) {
            this.operator = operator;
        }

        @Override
        public ReferencedVariablesAnd<AnnotationValueMatch> visitAnnotationValue(ClassifParser.AnnotationValueContext ctx) {
            ReferencedVariablesAnd<AnnotationValueMatch> ret = new ReferencedVariablesAnd<AnnotationValueMatch>();
            if (ctx.STRING() != null) {
                ret.match = AnnotationValueMatch.string(this.operator, ClassifDSL.stringContents(ctx.STRING()));
            } else if (ctx.REGEX() != null) {
                ret.match = AnnotationValueMatch.regex(this.operator, ClassifDSL.toRegex(ctx.REGEX()));
            } else if (ctx.NUMBER() != null) {
                Number n = ClassifDSL.toNumber(ctx.NUMBER());
                ret.match = AnnotationValueMatch.number(this.operator, n);
            } else if (ctx.BOOLEAN() != null) {
                boolean val = ClassifDSL.toBoolean(ctx.BOOLEAN());
                ret.match = AnnotationValueMatch.bool(this.operator, val);
            } else if (ctx.ANY() != null) {
                ret.match = AnnotationValueMatch.any(this.operator);
            } else if (ctx.DEFAULT() != null) {
                ret.match = AnnotationValueMatch.defaultValue(this.operator);
            } else if (ctx.typeReference() != null) {
                ReferencedVariablesAnd<TypeReferenceMatch> type = ctx.typeReference().accept(TypeReferenceVisitor.INSTANCE);
                ret.referencedVariables.addAll(type.referencedVariables);
                ret.match = AnnotationValueMatch.type(this.operator, (TypeReferenceMatch)type.match);
            } else if (ctx.fqn() != null) {
                FqnMatch fqn = ctx.fqn().accept(FqnVisitor.INSTANCE);
                NameMatch name = ctx.name().accept(NameVisitor.INSTANCE);
                ret.match = AnnotationValueMatch.enumConstant(this.operator, fqn, name);
            } else if (ctx.annotation() != null) {
                ReferencedVariablesAnd<AnnotationMatch> anno = ctx.annotation().accept(AnnotationVisitor.INSTANCE);
                ret.referencedVariables.addAll(anno.referencedVariables);
                ret.match = AnnotationValueMatch.annotation(this.operator, (AnnotationMatch)anno.match);
            } else if (ctx.OPEN_BRACE() != null) {
                if (ctx.annotationValueArrayContents() == null) {
                    ret.match = AnnotationValueMatch.array(this.operator, Collections.emptyList());
                } else {
                    List<ReferencedVariablesAnd<AnnotationValueMatch>> contents = ctx.annotationValueArrayContents().accept(AnnotationValueArrayContentsVisitor.INSTANCE);
                    ArrayList<AnnotationValueMatch> vals = new ArrayList<AnnotationValueMatch>(contents.size());
                    for (ReferencedVariablesAnd<AnnotationValueMatch> m : contents) {
                        ret.referencedVariables.addAll(m.referencedVariables);
                        vals.add((AnnotationValueMatch)m.match);
                    }
                    ret.match = AnnotationValueMatch.array(this.operator, vals);
                }
            }
            return ret;
        }
    }

    private static final class AnnotationAttributeVisitor
    extends ClassifBaseVisitor<ReferencedVariablesAnd<AnnotationAttributeMatch>> {
        static final AnnotationAttributeVisitor INSTANCE = new AnnotationAttributeVisitor();

        private AnnotationAttributeVisitor() {
        }

        @Override
        public ReferencedVariablesAnd<AnnotationAttributeMatch> visitAnnotationAttribute(ClassifParser.AnnotationAttributeContext ctx) {
            ReferencedVariablesAnd<AnnotationAttributeMatch> ret = new ReferencedVariablesAnd<AnnotationAttributeMatch>();
            if (ctx.ANY() != null) {
                ret.match = new AnnotationAttributeMatch(true, false, null, null);
            } else if (ctx.ANY_NUMBER_OF_THINGS() != null) {
                ret.match = new AnnotationAttributeMatch(false, true, null, null);
            } else {
                NameMatch name = ctx.name().accept(NameVisitor.INSTANCE);
                Operator op = ClassifDSL.toOperator(ctx.operator());
                ReferencedVariablesAnd<AnnotationValueMatch> value = ctx.annotationValue().accept(new AnnotationValueVisitor(op));
                ret.referencedVariables.addAll(value.referencedVariables);
                ret.match = new AnnotationAttributeMatch(false, false, name, (AnnotationValueMatch)value.match);
            }
            return ret;
        }
    }

    private static final class AnnotationVisitor
    extends ClassifBaseVisitor<ReferencedVariablesAnd<AnnotationMatch>> {
        static final AnnotationVisitor INSTANCE = new AnnotationVisitor();

        private AnnotationVisitor() {
        }

        @Override
        public ReferencedVariablesAnd<AnnotationMatch> visitAnnotation(ClassifParser.AnnotationContext ctx) {
            ReferencedVariablesAnd<AnnotationMatch> ret = new ReferencedVariablesAnd<AnnotationMatch>();
            boolean negation = ctx.not() != null;
            ReferencedVariablesAnd<TypeReferenceMatch> type = ctx.typeReference().accept(TypeReferenceVisitor.INSTANCE);
            ret.referencedVariables.addAll(type.referencedVariables);
            List<AnnotationAttributeMatch> attrs = ctx.annotationAttributes() != null ? ctx.annotationAttributes().annotationAttribute().stream().map(attrctx -> {
                ReferencedVariablesAnd<AnnotationAttributeMatch> attr = attrctx.accept(AnnotationAttributeVisitor.INSTANCE);
                ret.referencedVariables.addAll(attr.referencedVariables);
                return (AnnotationAttributeMatch)attr.match;
            }).collect(Collectors.toList()) : Collections.emptyList();
            ret.match = new AnnotationMatch(negation, (TypeReferenceMatch)type.match, attrs);
            return ret;
        }
    }

    private static final class StatementVisitor
    extends ClassifBaseVisitor<AbstractStatement> {
        static final StatementVisitor INSTANCE = new StatementVisitor();

        private StatementVisitor() {
        }

        @Override
        public AbstractStatement visitStatement(ClassifParser.StatementContext ctx) {
            List annos = ctx.annotations().annotation().stream().map(a -> a.accept(AnnotationVisitor.INSTANCE)).collect(Collectors.toList());
            ModifiersMatch modifiers = new ModifiersMatch(ctx.modifiers().modifierCluster().stream().map(cc -> new ModifierClusterMatch(cc.modifier().stream().map(mc -> {
                boolean negation = mc.not() != null;
                String text = negation ? mc.getText().substring(1) : mc.getText();
                return new ModifierMatch(negation, Modifier.fromString(text));
            }).collect(Collectors.toList()))).collect(Collectors.toList()));
            if (ctx.typeDefinitionOrGenericStatement().typeDefinition() != null) {
                return new TypeDefinitionVisitor(annos, modifiers).visitTypeDefinition(ctx.typeDefinitionOrGenericStatement().typeDefinition());
            }
            return new GenericStatementVisitor(annos, modifiers).visitGenericStatement(ctx.typeDefinitionOrGenericStatement().genericStatement());
        }
    }

    private static final class FqnVisitor
    extends ClassifBaseVisitor<FqnMatch> {
        static final FqnVisitor INSTANCE = new FqnVisitor();

        private FqnVisitor() {
        }

        @Override
        public FqnMatch visitFqn(ClassifParser.FqnContext ctx) {
            return new FqnMatch(ctx.name().stream().map(NameVisitor.INSTANCE::visit).collect(Collectors.toList()));
        }
    }

    private static final class NameVisitor
    extends ClassifBaseVisitor<NameMatch> {
        static final NameVisitor INSTANCE = new NameVisitor();

        private NameVisitor() {
        }

        @Override
        public NameMatch visitName(ClassifParser.NameContext ctx) {
            NameMatch ret = (NameMatch)ClassifDSL.ifNotNull(ctx.resolvedName(), c -> c.accept(ResolvedNameVisitor.INSTANCE));
            if (ret == null && (ret = (NameMatch)ClassifDSL.ifNotNull(ctx.REGEX(), r -> NameMatch.pattern(ClassifDSL.toRegex(r)))) == null && (ret = (NameMatch)ClassifDSL.ifNotNull(ctx.ANY(), r -> NameMatch.any())) == null) {
                ret = (NameMatch)ClassifDSL.ifNotNull(ctx.ANY_NUMBER_OF_THINGS(), r -> NameMatch.all());
            }
            return ret;
        }
    }

    private static final class VariableVisitor
    extends ClassifBaseVisitor<String> {
        static final VariableVisitor INSTANCE = new VariableVisitor();

        private VariableVisitor() {
        }

        @Override
        public String visitVariable(ClassifParser.VariableContext ctx) {
            return ctx.resolvedName().getText();
        }
    }

    private static final class MatchStatementVisitor
    extends ClassifBaseVisitor<List<String>> {
        static final MatchStatementVisitor INSTANCE = new MatchStatementVisitor();

        private MatchStatementVisitor() {
        }

        @Override
        public List<String> visitMatchStatement(ClassifParser.MatchStatementContext ctx) {
            return ctx.variables().variable().stream().map(v -> v.accept(VariableVisitor.INSTANCE)).collect(Collectors.toList());
        }
    }

    private static final class ResolvedNameVisitor
    extends ClassifBaseVisitor<NameMatch> {
        static final ResolvedNameVisitor INSTANCE = new ResolvedNameVisitor();

        private ResolvedNameVisitor() {
        }

        @Override
        public NameMatch visitResolvedName(ClassifParser.ResolvedNameContext ctx) {
            return NameMatch.exact(ctx.getText());
        }
    }

    private static final class ProgramVisitor
    extends ClassifBaseVisitor<StructuralMatcher> {
        static final ProgramVisitor INSTANCE = new ProgramVisitor();

        private ProgramVisitor() {
        }

        @Override
        public StructuralMatcher visitProgram(ClassifParser.ProgramContext ctx) {
            List namedMatches = (List)ClassifDSL.ifNotNull(ctx.matchStatement(), m -> m.accept(MatchStatementVisitor.INSTANCE));
            List<AbstractStatement> exprs = ctx.statement().stream().map(s -> s.accept(StatementVisitor.INSTANCE)).collect(Collectors.toList());
            boolean strictHierarchy = false;
            ClassifParser.PragmasContext pragmas = ctx.pragmas();
            if (pragmas != null) {
                for (ClassifParser.PragmaContext pctx : pragmas.pragma()) {
                    if (pctx.STRICT_HIERARCHY() == null) continue;
                    strictHierarchy = true;
                }
            }
            StructuralMatcher.Configuration config = new StructuralMatcher.Configuration(strictHierarchy);
            return new StructuralMatcher(config, namedMatches, exprs);
        }
    }
}

