/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.classif.match.declaration;

import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import org.revapi.classif.TestResult;
import org.revapi.classif.match.declaration.AnnotationValueMatch;
import org.revapi.classif.match.declaration.DeclarationMatch;
import org.revapi.classif.progress.context.MatchContext;

public final class DefaultValueMatch
extends DeclarationMatch {
    private final boolean negation;
    private final AnnotationValueMatch valueMatch;

    public DefaultValueMatch(boolean negation, AnnotationValueMatch valueMatch) {
        this.negation = negation;
        this.valueMatch = valueMatch;
    }

    @Override
    protected <M> TestResult testMethod(ExecutableElement declaration, TypeMirror instantiation, MatchContext<M> ctx) {
        AnnotationValue defaultValue = declaration.getDefaultValue();
        if (defaultValue == null) {
            return TestResult.fromBoolean(this.negation != (this.valueMatch == null));
        }
        return this.valueMatch == null ? TestResult.NOT_PASSED : this.valueMatch.test(defaultValue, ctx);
    }

    public String toString() {
        String ret = "default";
        if (this.valueMatch != null) {
            ret = ret + " " + this.valueMatch;
        }
        return ret;
    }
}

